/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ProductionStrategyHelper;
import com.kingdee.eas.mm.control.IProductionOrderStockEntry;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryFactory;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.control.client.AbstractProductionStockInventoryQueryUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMLockInvDataVO;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProductionStockInventoryQueryUI
extends AbstractProductionStockInventoryQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductionStockInventoryQueryUI.class);
    private static final String TB_PS_ID = "id";
    private static final String TB_PS_STORORGUNITID = "FStorageOrgUnitID";
    private static final String TB_PS_STORORGUNITNAME = "FStorageOrgUnitName";
    private static final String TB_PS_NUMBER = "FNumber";
    private static final String TB_PS_LINENUM = "FLineNo";
    private static final String TB_PS_TRACKNUMBERID = "FTrackNumberID";
    private static final String TB_PS_TRACKNUMBER = "FTrackNumber";
    private static final String TB_PS_ENTRYID = "FEntryID";
    private static final String TB_PS_MATERIALID = "FMaterialID";
    private static final String TB_PS_MATERIALNUM = "FMaterialNum";
    private static final String TB_PS_MATERIALNAME = "FMaterialName";
    private static final String TB_PS_MODEL = "FModel";
    private static final String TB_PS_FUNIT = "FUnit";
    private static final String TB_PS_REQQTY = "FQty";
    private static final String TB_PS_STARTDATE = "FStartDate";
    private static final String TB_PS_ENDDATE = "FEndDate";
    private static final String TB_PS_WAREHOUSE = "FWarehouse";
    private DataChangeListener prmtWarehouseDataChange = null;
    private static final String[] QTYPRECISIONFROMUNITTAB = new String[]{"FQty"};
    private static final String[] QTYPRECISIONFROMUNITTAB2 = new String[]{"FCurQty", "FCurLockQty"};
    private static final String[] PSB_DATES = new String[]{"FStartDate", "FEndDate"};
    private static final String[] IV_DATES = new String[]{"expDate"};
    private Set userStorOrgSet = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadUserStorOrgSet();
        this.initWarehouseF7();
        this.prmtWarehouseDataChange = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ProductionStockInventoryQueryUI.this.prmtWareHouse_dataChanged(e);
                }
                catch (Exception exc) {
                    ProductionStockInventoryQueryUI.this.handUIException(exc);
                }
            }
        };
        this.prmtWareHouse.addDataChangeListener(this.prmtWarehouseDataChange);
        this.prmtLocation.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (ProductionStockInventoryQueryUI.this.prmtWareHouse.getValue() == null) {
                    e.setCanceled(true);
                }
            }
        });
        this.cbIncludeExpMaterial.setSelected(true);
        this.cbIncludeExpMaterial.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    ProductionStockInventoryQueryUI.this.cbIncludeExpMaterial_itemStateChanged(e);
                }
                catch (Exception exc) {
                    ProductionStockInventoryQueryUI.this.handUIException(exc);
                }
            }
        });
    }

    public void cbIncludeExpMaterial_itemStateChanged(ItemEvent e) {
        Object[] locationArr;
        HashSet<BOSUuid> warehouseIdSet = null;
        HashSet<BOSUuid> locationIdSet = null;
        int tblpsRowIndex = this.tblPSBill.getSelectManager().getActiveRowIndex();
        Object[] warehouseArr = (Object[])this.prmtWareHouse.getData();
        if (warehouseArr != null && warehouseArr.length > 0) {
            warehouseIdSet = new HashSet<BOSUuid>();
            for (int i = 0; i < warehouseArr.length; ++i) {
                warehouseIdSet.add(((WarehouseInfo)warehouseArr[i]).getId());
            }
        }
        if ((locationArr = (Object[])this.prmtLocation.getValue()) != null && locationArr.length > 0) {
            locationIdSet = new HashSet<BOSUuid>();
            for (int i = 0; i < locationArr.length; ++i) {
                locationIdSet.add(((LocationInfo)locationArr[i]).getId());
            }
        }
        try {
            this.tblInventoryinsertRow(tblpsRowIndex, warehouseIdSet, locationIdSet);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    protected Set getUserStorOrgSet() {
        return this.userStorOrgSet;
    }

    private void loadUserStorOrgSet() throws BOSException {
        UserInfo curUser = SysContext.getSysContext().getCurrentUserInfo();
        String orgRangeOql = "select org.id where user = '" + curUser.getId().toString() + "' and type = " + 10 + " and org.isStorageOrgUnit = 1";
        IOrgRange iorgRange = OrgRangeFactory.getRemoteInstance();
        OrgRangeCollection orgRangeCol = iorgRange.getOrgRangeCollection(orgRangeOql);
        HashSet<String> orgSet = new HashSet<String>();
        for (OrgRangeInfo orgRangeInfo : orgRangeCol) {
            orgSet.add(orgRangeInfo.getOrg().getId().toString());
        }
        this.userStorOrgSet = orgSet;
    }

    private void initWarehouseF7() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.getUserStorOrgSet(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("transState", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("transState", (Object)"2", CompareType.EQUALS));
        filter.setMaskString("#0 and (#1 or #2)");
        viewInfo.setFilter(filter);
        this.prmtWareHouse.setEntityViewInfo(viewInfo);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblPSBill.getSelectManager().setSelectMode(2);
        this.tblPSBill.getStyleAttributes().setLocked(true);
        this.tblInventory.getSelectManager().setSelectMode(2);
        this.tblInventory.getStyleAttributes().setLocked(true);
        String isSingle = (String)this.getUIContext().get("isSingle");
        if ("1".equals(isSingle)) {
            this.tblPSBill.getColumn(TB_PS_STORORGUNITNAME).getStyleAttributes().setHided(true);
            this.tblPSBill.getColumn(TB_PS_NUMBER).getStyleAttributes().setHided(true);
        }
        this.tblPSBillInsertRows();
        EditTableUtil.formatColDate((KDTable)this.tblPSBill, (String[])PSB_DATES);
        EditTableUtil.formatColDate((KDTable)this.tblInventory, (String[])IV_DATES);
    }

    private void tblPSBillInsertRows() throws Exception {
        this.tblPSBill.removeRows();
        ArrayList idList = (ArrayList)this.getUIContext().get("idList");
        ProductionOrderStockEntryCollection poseCol = null;
        if (idList != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("parent.number"));
            sic.add(new SelectorItemInfo("warehouse.id"));
            sic.add(new SelectorItemInfo("warehouse.number"));
            sic.add(new SelectorItemInfo("warehouse.name"));
            sic.add(new SelectorItemInfo("material.id"));
            sic.add(new SelectorItemInfo("material.number"));
            sic.add(new SelectorItemInfo("material.name"));
            sic.add(new SelectorItemInfo("material.model"));
            sic.add(new SelectorItemInfo("baseUnit.id"));
            sic.add(new SelectorItemInfo("baseUnit.number"));
            sic.add(new SelectorItemInfo("baseUnit.name"));
            sic.add(new SelectorItemInfo("unit.id"));
            sic.add(new SelectorItemInfo("unit.number"));
            sic.add(new SelectorItemInfo("unit.name"));
            sic.add(new SelectorItemInfo("parent.storageOrgUnit.*"));
            sic.add(new SelectorItemInfo("parent.material.*"));
            sic.add(new SelectorItemInfo("parent.trackNumber.*"));
            viewInfo.setSelector(sic);
            HashSet idSet = new HashSet();
            for (int i = 0; i < idList.size(); ++i) {
                idSet.add(idList.get(i));
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(TB_PS_ID, idSet, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            SorterItemInfo sorter = new SorterItemInfo("parent.number");
            SorterItemInfo sorter2 = new SorterItemInfo("seq");
            sorter.setSortType(SortType.ASCEND);
            viewInfo.getSorter().add(sorter);
            viewInfo.getSorter().add(sorter2);
            IProductionOrderStockEntry ipsbe = ProductionOrderStockEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            poseCol = ipsbe.getProductionOrderStockEntryCollection(viewInfo);
        } else {
            poseCol = (ProductionOrderStockEntryCollection)((Object)this.getUIContext().get("EntryCol"));
        }
        MaterialInfo[] materialInfos = null;
        MeasureUnitInfo[] measureUnitInfos = null;
        int[] rowIndexs = null;
        Iterator it = poseCol.iterator();
        int psCount = poseCol.size();
        if (psCount > 0) {
            materialInfos = new MaterialInfo[psCount];
            measureUnitInfos = new MeasureUnitInfo[psCount];
            rowIndexs = new int[psCount];
        }
        int rowIndex = 0;
        while (it.hasNext()) {
            ProductionOrderStockEntryInfo poseInfo = (ProductionOrderStockEntryInfo)it.next();
            if (poseInfo.getMaterial() == null) continue;
            IRow newRow = this.tblPSBill.addRow();
            newRow.getCell(TB_PS_ID).setValue((Object)poseInfo.getParent().getId());
            newRow.getCell(TB_PS_STORORGUNITID).setValue((Object)poseInfo.getParent().getStorageOrgUnit().getId());
            newRow.getCell(TB_PS_STORORGUNITNAME).setValue((Object)poseInfo.getParent().getStorageOrgUnit().getName());
            newRow.getCell(TB_PS_ENTRYID).setValue((Object)poseInfo.getId());
            newRow.getCell(TB_PS_NUMBER).setValue((Object)poseInfo.getParent().getNumber());
            newRow.getCell(TB_PS_MATERIALID).setValue((Object)poseInfo.getMaterial().getId());
            newRow.getCell(TB_PS_MATERIALID).setUserObject((Object)poseInfo.getMaterial());
            newRow.getCell(TB_PS_MATERIALNUM).setValue((Object)poseInfo.getMaterial().getNumber());
            newRow.getCell(TB_PS_MATERIALNAME).setValue((Object)poseInfo.getMaterial().getName());
            if (poseInfo.getParent().getTrackNumber() != null && ProductionStrategyHelper.isATO20orMTO20(null, (String)poseInfo.getMaterial().getId().toString(), (String)poseInfo.getParent().getStorageOrgUnit().getId().toString())) {
                newRow.getCell(TB_PS_TRACKNUMBER).setValue((Object)poseInfo.getParent().getTrackNumber().getNumber());
                newRow.getCell(TB_PS_TRACKNUMBERID).setValue((Object)poseInfo.getParent().getTrackNumber().getId());
            }
            newRow.getCell(TB_PS_LINENUM).setValue((Object)poseInfo.getLineSeq());
            newRow.getCell(TB_PS_MODEL).setValue((Object)poseInfo.getMaterial().getModel());
            if (poseInfo.getUnit() != null) {
                newRow.getCell(TB_PS_FUNIT).setValue((Object)poseInfo.getUnit().getName());
                newRow.getCell(TB_PS_FUNIT).setUserObject((Object)poseInfo.getUnit());
            }
            newRow.getCell(TB_PS_REQQTY).setValue((Object)poseInfo.getQty());
            newRow.getCell(TB_PS_STARTDATE).setValue((Object)poseInfo.getStartDate());
            newRow.getCell(TB_PS_ENDDATE).setValue((Object)poseInfo.getEndDate());
            newRow.getCell(TB_PS_WAREHOUSE).setValue(poseInfo.getDefaultWarehouse() != null ? poseInfo.getDefaultWarehouse().getName() : null);
            materialInfos[rowIndex] = poseInfo.getMaterial();
            measureUnitInfos[rowIndex] = poseInfo.getUnit();
            rowIndexs[rowIndex] = rowIndex;
            ++rowIndex;
        }
        SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo[])materialInfos, (MeasureUnitInfo[])measureUnitInfos, (KDTable)this.tblPSBill, (String[])QTYPRECISIONFROMUNITTAB, (int[])rowIndexs);
        this.tblPSBill.getSelectManager().select(0, 0);
    }

    private void tblInventoryinsertRow(int rowIndex, Set warehouseIdSet, Set locationIdSet) throws Exception {
        this.tblInventory.removeRows();
        if (this.tblPSBill.getRowCount() == 0) {
            return;
        }
        IRow aRow = this.tblPSBill.getRow(rowIndex);
        EntityViewInfo ev = new EntityViewInfo();
        MaterialInfo aMaterialInfo = (MaterialInfo)aRow.getCell(TB_PS_MATERIALID).getUserObject();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo orgUnitFilter = new FilterItemInfo("STORAGEORGUNIT.ID", (Object)this.getUserStorOrgSet(), CompareType.INCLUDE);
        FilterItemInfo materialFilter = new FilterItemInfo("MATERIAL.ID", aRow.getCell(TB_PS_MATERIALID).getValue(), CompareType.EQUALS);
        FilterItemInfo warehouseStateFilter1 = new FilterItemInfo("WAREHOUSE.transState", (Object)"1", CompareType.EQUALS);
        FilterItemInfo warehouseStateFilter2 = new FilterItemInfo("WAREHOUSE.transState", (Object)"2", CompareType.EQUALS);
        filter.getFilterItems().add(orgUnitFilter);
        filter.getFilterItems().add(materialFilter);
        filter.getFilterItems().add(warehouseStateFilter1);
        filter.getFilterItems().add(warehouseStateFilter2);
        FilterItemInfo trackNumberFilter = null;
        trackNumberFilter = aRow.getCell(TB_PS_TRACKNUMBERID).getValue() == null || "".equals(aRow.getCell(TB_PS_TRACKNUMBERID).getValue().toString().trim()) ? new FilterItemInfo("trackNumber.id", null, CompareType.EQUALS) : new FilterItemInfo("trackNumber.id", (Object)aRow.getCell(TB_PS_TRACKNUMBERID).getValue().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(trackNumberFilter);
        filter.setMaskString("#0 and #1 and (#2 or #3) and #4");
        FilterInfo conditionfilter = new FilterInfo();
        if (warehouseIdSet != null && warehouseIdSet.size() > 0) {
            FilterItemInfo warehouseFilter = new FilterItemInfo("WAREHOUSE.ID", (Object)warehouseIdSet, CompareType.INCLUDE);
            conditionfilter.getFilterItems().add(warehouseFilter);
        }
        if (locationIdSet != null && locationIdSet.size() > 0) {
            FilterItemInfo locationFilter = new FilterItemInfo("LOCATION.ID", (Object)locationIdSet, CompareType.INCLUDE);
            conditionfilter.getFilterItems().add(locationFilter);
        }
        if (conditionfilter.getFilterItems().size() > 0) {
            filter.mergeFilter(conditionfilter, "and");
        }
        ev.setFilter(filter);
        SCMLockInvDataVO vo = new SCMLockInvDataVO();
        vo.setTableNether(true);
        vo.setViewInfo(ev);
        vo.setType("bottom");
        boolean flag = this.cbIncludeExpMaterial.isSelected();
        Date reqDate = null;
        if (flag) {
            reqDate = (Date)aRow.getCell(TB_PS_ENDDATE).getValue();
        }
        SCMLockInvDataVO tblInventoryVO = ProductionOrderFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getMaterialInventory(vo, reqDate, false);
        IObjectPK[] invIdList = tblInventoryVO.getInvIdList();
        Map wareHouseMap = tblInventoryVO.getWareHouseMap();
        Map locationMap = tblInventoryVO.getLocationMap();
        Map storeTypeMap = tblInventoryVO.getStoreTypeMap();
        Map storeStateMap = tblInventoryVO.getStoreStateMap();
        Map supplierMap = tblInventoryVO.getSupplierMap();
        Map customerMap = tblInventoryVO.getCustomerMap();
        Map storageMap = tblInventoryVO.getStorageMap();
        Map invUnitMap = tblInventoryVO.getInvUnitMap();
        Map inventoryMap = tblInventoryVO.getInventoryMap();
        Map trackNumberMap = tblInventoryVO.getTrackNumberMap();
        Map expMap = tblInventoryVO.getExpMap();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(TB_PS_ID));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        String invID = null;
        int n = invIdList.length;
        for (int i = 0; i < n; ++i) {
            invID = invIdList[i].toString();
            InventoryInfo aInventoryInfo = (InventoryInfo)inventoryMap.get(invID);
            if (aInventoryInfo.getCurStoreQty() != null && aInventoryInfo.getCurStoreQty().doubleValue() == 0.0) continue;
            IRow newRow = this.tblInventory.addRow();
            StorageOrgUnitInfo aStorageOrgUnitInfo = (StorageOrgUnitInfo)storageMap.get(invID);
            newRow.getCell("FStorageOrg").setValue((Object)aStorageOrgUnitInfo.getName());
            newRow.getCell("FStorageOrg").setUserObject((Object)aStorageOrgUnitInfo);
            newRow.getCell(TB_PS_ID).setValue((Object)invIdList[i]);
            if (aInventoryInfo.getWarehouse() != null) {
                WarehouseInfo aWarehouseInfo = (WarehouseInfo)wareHouseMap.get(invID);
                newRow.getCell("FWareHouse").setValue((Object)aWarehouseInfo.getName());
                newRow.getCell("FWareHouse").setUserObject((Object)aWarehouseInfo);
            }
            if (aInventoryInfo.getLocation() != null) {
                LocationInfo aLocationInfo = (LocationInfo)locationMap.get(invID);
                newRow.getCell("FLocation").setValue((Object)aLocationInfo.getName());
                newRow.getCell("FLocation").setUserObject((Object)aLocationInfo);
            }
            newRow.getCell("FCurQty").setValue((Object)aInventoryInfo.getCurStoreQty());
            if (aInventoryInfo.getLot() != null) {
                newRow.getCell("FLot").setValue((Object)aInventoryInfo.getLot());
            }
            if (aInventoryInfo.getStoretype() != null) {
                StoreTypeInfo aStoreTypeInfo = (StoreTypeInfo)storeTypeMap.get(invID);
                newRow.getCell("FStoreType").setValue((Object)aStoreTypeInfo.getName());
                newRow.getCell("FStoreType").setUserObject((Object)aStoreTypeInfo);
            }
            if (aInventoryInfo.getStorestatus() != null) {
                StoreStateInfo aStoreStateInfo = (StoreStateInfo)storeStateMap.get(invID);
                newRow.getCell("FStoreState").setValue((Object)aStoreStateInfo.getName());
                newRow.getCell("FStoreState").setUserObject((Object)aStoreStateInfo);
            }
            if (aInventoryInfo.getSupplier() != null) {
                SupplierInfo aSupplierInfo = (SupplierInfo)supplierMap.get(invID);
                newRow.getCell("FSupplier").setValue((Object)aSupplierInfo.getName());
                newRow.getCell("FSupplier").setUserObject((Object)aSupplierInfo);
            }
            if (aInventoryInfo.getCustomer() != null) {
                CustomerInfo aCustomerInfo = (CustomerInfo)customerMap.get(invID);
                newRow.getCell("FCustomer").setValue((Object)aCustomerInfo.getName());
                newRow.getCell("FCustomer").setUserObject((Object)aCustomerInfo);
            }
            if (aInventoryInfo.getUnit() != null) {
                MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)invUnitMap.get(invID);
                newRow.getCell(TB_PS_FUNIT).setValue((Object)measureUnitInfo.getName());
                newRow.getCell(TB_PS_FUNIT).setUserObject((Object)measureUnitInfo);
                this.changePrecision(tblInventoryVO, this.tblInventory, QTYPRECISIONFROMUNITTAB2, aMaterialInfo, measureUnitInfo, newRow.getRowIndex());
            }
            if (aInventoryInfo.getTrackNumber() != null) {
                TrackNumberInfo trackNumberInfo = (TrackNumberInfo)trackNumberMap.get(invID);
                newRow.getCell(TB_PS_TRACKNUMBER).setValue((Object)trackNumberInfo.getNumber());
            }
            if (aInventoryInfo.getExp() != null) {
                newRow.getCell("expDate").setValue(expMap.get(invID));
            }
            newRow.getCell("FCurLockQty").getStyleAttributes().setLocked(true);
        }
    }

    protected void prmtWareHouse_dataChanged(DataChangeEvent e) {
        Object warehouse = this.prmtWareHouse.getData();
        HashSet<String> warehouseSet = new HashSet<String>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        this.prmtLocation.setValue(null);
        if (warehouse == null) {
            this.prmtLocation.setEnabled(false);
        } else if (warehouse instanceof Object[]) {
            Object[] warehouseArr = (Object[])warehouse;
            if (warehouseArr.length == 1) {
                filter.getFilterItems().add(new FilterItemInfo("Warehouse.id", (Object)((WarehouseInfo)warehouseArr[0]).getId().toString(), CompareType.EQUALS));
            } else if (warehouseArr.length > 1) {
                for (int i = 0; i < warehouseArr.length; ++i) {
                    warehouseSet.add(((WarehouseInfo)warehouseArr[i]).getId().toString());
                }
                filter.getFilterItems().add(new FilterItemInfo("Warehouse.id", warehouseSet, CompareType.INCLUDE));
            }
            this.prmtLocation.setEnabled(true);
            viewInfo.setFilter(filter);
            this.prmtLocation.setEntityViewInfo(viewInfo);
        }
    }

    private void changePrecision(SCMLockInvDataVO resultVO, KDTable kdtable, String[] fieldNames, MaterialInfo info, MeasureUnitInfo measureUnitInfo, int rowIndex) {
        MultiMeasureUnitInfo multiUnitInfo;
        int precision = 2;
        Map mmuMap = resultVO.getMmuPrecisions();
        if (info != null && measureUnitInfo != null && (multiUnitInfo = (MultiMeasureUnitInfo)mmuMap.get(info.getId().toString() + measureUnitInfo.getId().toString())) != null) {
            precision = multiUnitInfo.getQtyPrecision();
        }
        SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)kdtable, (String[])fieldNames, (int)rowIndex);
    }

    @Override
    protected void tblPSBill_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.prmtWareHouse.removeDataChangeListener(this.prmtWarehouseDataChange);
        this.prmtWareHouse.setValue(null);
        this.prmtWareHouse.addDataChangeListener(this.prmtWarehouseDataChange);
        this.prmtLocation.setValue(null);
        this.prmtLocation.setEnabled(false);
        this.tblInventoryinsertRow(e.getSelectBlock().getBeginRow(), null, null);
    }

    @Override
    public void actionQueryInventory_actionPerformed(ActionEvent e) throws Exception {
        Object[] locationArr;
        HashSet<BOSUuid> warehouseIdSet = null;
        HashSet<BOSUuid> locationIdSet = null;
        int tblpsRowIndex = this.tblPSBill.getSelectManager().getActiveRowIndex();
        Object[] warehouseArr = (Object[])this.prmtWareHouse.getData();
        if (warehouseArr != null && warehouseArr.length > 0) {
            warehouseIdSet = new HashSet<BOSUuid>();
            for (int i = 0; i < warehouseArr.length; ++i) {
                warehouseIdSet.add(((WarehouseInfo)warehouseArr[i]).getId());
            }
        }
        if ((locationArr = (Object[])this.prmtLocation.getValue()) != null && locationArr.length > 0) {
            locationIdSet = new HashSet<BOSUuid>();
            for (int i = 0; i < locationArr.length; ++i) {
                locationIdSet.add(((LocationInfo)locationArr[i]).getId());
            }
        }
        this.tblInventoryinsertRow(tblpsRowIndex, warehouseIdSet, locationIdSet);
    }
}

