/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.mm.basedata.ProductLineFactory;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ParamUtil;
import com.kingdee.eas.mm.control.IStockAllocationFacade;
import com.kingdee.eas.mm.control.ProductionOrderCollection;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.control.SACalcParamInfo;
import com.kingdee.eas.mm.control.SAGroupEnum;
import com.kingdee.eas.mm.control.SARuleEnum;
import com.kingdee.eas.mm.control.SASourceInfo;
import com.kingdee.eas.mm.control.SAStockInfo;
import com.kingdee.eas.mm.control.SATransactionEnum;
import com.kingdee.eas.mm.control.StockAllocationFacadeFactory;
import com.kingdee.eas.mm.control.TransactionTypeEnum;
import com.kingdee.eas.mm.control.client.AbstractStockAllocationEditUI;
import com.kingdee.eas.mm.control.client.Field.StockAllocationFieldName;
import com.kingdee.eas.mm.control.client.StockAllocationFilterUI;
import com.kingdee.eas.mm.control.client.StockAllocationParamUI;
import com.kingdee.eas.mm.control.client.StockAllocationSourceUI;
import com.kingdee.eas.mm.control.client.util.StockAllocationClientCommon;
import com.kingdee.eas.mm.control.client.util.StockAllocationUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class StockAllocationEditUI
extends AbstractStockAllocationEditUI
implements StockAllocationFieldName {
    private static final long serialVersionUID = -4432229622179497776L;
    private static final Logger logger = CoreUIObject.getLogger(StockAllocationEditUI.class);
    private IUIWindow stockAllocationSourceWindow;
    private Map billMap = new HashMap();
    private ProductionOrderCollection ptStaticOrderCollection;
    private ProductionOrderStockEntryCollection ptStaticOrderStockEntryCollection;
    private Map sASourceMap;
    private Map precisionMap;
    private Map sAStockMap;
    private Map sAStockMap_simulate = new HashMap();
    private Map zeroQtySAStockInfoMap = new HashMap();
    private Map zeroQtyPtStockInfoMap = new HashMap();
    private Map receiptQtyMap = new HashMap();
    private Map mapAllocationMethod = new HashMap();
    protected String[] REQUIREPARAMS = new String[]{"AllocationMethod"};
    private static String ALLOCATIONMETHOD_SPECIFIEDORDER = String.valueOf((Object)SATransactionEnum.SPECIFIEDORDER);
    private boolean isSpecifiedOrder = true;
    private static final String[] SIO_DATES = new String[]{"receiptPlanDate"};
    private static final String[] ORD_DATETIMES = new String[]{"planBeginDate", "planEndDate"};
    private static final String[] STO_DATETIMES = new String[]{"demandTime"};
    private DataChangeListener storageOrgChangeListener = null;
    private KDTEditAdapter kdOrderChanged;
    private ItemListener stockAllocComboChanged;
    private KDTEditAdapter kdStockChanged;
    private KDTEditAdapter kdSimulateChanged;

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_flow_stockAllocation");
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_flow_stockAllocation");
        this.prmtStorageOrgUnit.setValue((Object)storage);
        this.setTransactionControl(storage);
        this.init();
        this.initSortManager();
        this.kdOrder.getActionMap().remove("Delete");
        this.kdOrder.getActionMap().remove("Paste");
        this.kdStock.getActionMap().remove("Delete");
        this.kdStock.getActionMap().remove("Paste");
        this.kdSimulationOrder.getActionMap().remove("Delete");
        this.kdSimulationOrder.getActionMap().remove("Paste");
        EditTableUtil.formatColDate((KDTable)this.kdSimulationOrder, (String[])SIO_DATES);
        EditTableUtil.formatColDateTime((KDTable)this.kdOrder, (String[])ORD_DATETIMES);
        EditTableUtil.formatColDateTime((KDTable)this.kdStock, (String[])STO_DATETIMES);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemQuery.setIcon(MMUtils.getNewIcon((String)"imgTbtn_sourcebillfilter"));
        this.btnQuery.setIcon(MMUtils.getNewIcon((String)"imgTbtn_sourcebillfilter"));
        this.menuItemCollectCalculate.setIcon(MMUtils.getNewIcon((String)"imgTbtn_collectcomputation"));
        this.btnCollectCalculate.setIcon(MMUtils.getNewIcon((String)"imgTbtn_collectcomputation"));
        this.menuItemBuild.setIcon(MMUtils.getNewIcon((String)"imgTbtn_createbill"));
        this.btnBuild.setIcon(MMUtils.getNewIcon((String)"imgTbtn_createbill"));
        this.menuItemSimulate.setIcon(EASResource.getIcon((String)"imgTbtn_simulate"));
        this.btnSimulate.setIcon(EASResource.getIcon((String)"imgTbtn_simulate"));
    }

    private void getStockAllocationParam(String storageOrgUnitID) throws Exception {
        if (this.mapAllocationMethod.get(storageOrgUnitID) == null) {
            ParamUtil paramUtil = new ParamUtil(null, storageOrgUnitID, this.REQUIREPARAMS);
            String[] allocationMethods = new String[]{String.valueOf((Object)SATransactionEnum.SPECIFIEDORDER), String.valueOf((Object)SATransactionEnum.WAREHOUSERESTOCK)};
            String allocationMethod = ALLOCATIONMETHOD_SPECIFIEDORDER;
            String temp = paramUtil.getAllocationMethod(ALLOCATIONMETHOD_SPECIFIEDORDER);
            for (int i = 0; i < allocationMethods.length; ++i) {
                if (!temp.equals(String.valueOf(i))) continue;
                allocationMethod = allocationMethods[i];
                break;
            }
            this.mapAllocationMethod.put(storageOrgUnitID, allocationMethod);
        }
        this.isSpecifiedOrder = ALLOCATIONMETHOD_SPECIFIEDORDER.equals(this.mapAllocationMethod.get(storageOrgUnitID).toString());
    }

    private void initSortManager() {
        KDTable[] kdTables = new KDTable[]{this.kdOrder, this.kdStock, this.kdSimulationOrder};
        for (int i = 0; i < kdTables.length; ++i) {
            KDTSortManager sortManager = new KDTSortManager(kdTables[i]);
            sortManager.setSortAuto(true);
            sortManager.setClickCount(1);
            kdTables[i].setSortMange(sortManager);
            for (int j = 0; j < kdTables[i].getColumnCount(); ++j) {
                kdTables[i].getColumn(j).setSortable(true);
            }
        }
    }

    private void init() {
        this.kdOrder.checkParsed();
        this.kdStock.checkParsed();
        this.kdSimulationOrder.checkParsed();
        this.stTransaction.setEnabled(false);
        this.stRule.getActionMap().remove("ClearItem");
        this.stGroup.getActionMap().remove("ClearItem");
        this.stTransaction.getActionMap().remove("ClearItem");
        this.stcProductionLine.getActionMap().remove("ClearItem");
        this.stcOperation.getActionMap().remove("ClearItem");
        this.stcIssueWarehouse.getActionMap().remove("ClearItem");
        this.stcMaterial.getActionMap().remove("ClearItem");
        this.stcFromOranization.getActionMap().remove("ClearItem");
        this.stcFromWarehouse.getActionMap().remove("ClearItem");
        this.initOrderRecepitQty(true);
        this.initDemandTime();
        this.initStockRecepitQty();
        this.addListener();
        KDTextField remarkcolumn = new KDTextField();
        remarkcolumn.setMaxLength(80);
        this.kdStock.getColumn("remark").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)remarkcolumn));
        this.kdSimulationOrder.getColumn("remark").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)remarkcolumn));
    }

    private void initAllocationMethod() {
        this.stRule.setSelectedItem((Object)SARuleEnum.NORMAL);
        if (SATransactionEnum.SPECIFIEDORDER.equals(this.stTransaction.getSelectedItem())) {
            this.panleSourse.setEnabledAt(0, true);
            this.panleSourse.setEnabledAt(1, false);
            this.panleSourse.setSelectedIndex(0);
            this.actionQuery.setEnabled(true);
            this.stRule.setEnabled(true);
        } else {
            this.panleSourse.setEnabledAt(0, false);
            this.panleSourse.setEnabledAt(1, true);
            this.panleSourse.setSelectedIndex(1);
            this.actionQuery.setEnabled(false);
            this.stRule.setEnabled(false);
        }
    }

    private void initOrderRecepitQty(boolean editable) {
        KDFormattedTextField orderRreceiptQty = new KDFormattedTextField();
        orderRreceiptQty.setName("orderRreceiptQty");
        orderRreceiptQty.setDataType(1);
        orderRreceiptQty.setVisible(true);
        orderRreceiptQty.setRequired(true);
        orderRreceiptQty.setSupportedEmpty(false);
        orderRreceiptQty.setMinimumValue((Comparable)ZERO);
        orderRreceiptQty.setMaximumValue((Comparable)MAX_VALUE);
        KDTDefaultCellEditor orderRreceiptQtyCellEditor = new KDTDefaultCellEditor((JTextField)orderRreceiptQty);
        this.kdOrder.getColumn("receiptQty").setEditor((ICellEditor)orderRreceiptQtyCellEditor);
        this.kdOrder.getColumn("receiptQty").getStyleAttributes().setLocked(editable);
    }

    private void initDemandTime() {
        KDDatePicker stockDemandTimeDatePicker = new KDDatePicker();
        stockDemandTimeDatePicker.setTimeEnabled(true);
        stockDemandTimeDatePicker.setName("stockDemandTime_DatePicker");
        stockDemandTimeDatePicker.setVisible(true);
        stockDemandTimeDatePicker.setEditable(true);
        stockDemandTimeDatePicker.setDatePattern(CtrlFormatUtilities.getDateTimeFormatString());
        KDTDefaultCellEditor stockDemandTime_CellEditor = new KDTDefaultCellEditor(stockDemandTimeDatePicker);
        this.kdStock.getColumn("demandTime").setEditor((ICellEditor)stockDemandTime_CellEditor);
    }

    private void initStockRecepitQty() {
        KDFormattedTextField stockReceiptQty = new KDFormattedTextField();
        stockReceiptQty.setName("stockRecepitQty");
        stockReceiptQty.setDataType(1);
        stockReceiptQty.setVisible(true);
        stockReceiptQty.setRequired(true);
        stockReceiptQty.setSupportedEmpty(false);
        stockReceiptQty.setMinimumValue((Comparable)ZERO);
        stockReceiptQty.setMaximumValue((Comparable)MAX_VALUE);
        KDTDefaultCellEditor orderRreceiptQtyCellEditor = new KDTDefaultCellEditor((JTextField)stockReceiptQty);
        this.kdStock.getColumn("receiptQty").setEditor((ICellEditor)orderRreceiptQtyCellEditor);
        this.kdStock.getColumn("receiptQty").getStyleAttributes().setLocked(false);
    }

    private void addListener() {
        this.stRule.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    StockAllocationEditUI.this.stRuleChanged();
                }
                catch (EASBizException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
                catch (BOSException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.stockAllocComboChanged = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    StockAllocationEditUI.this.kdComboBoxChanged();
                }
                catch (EASBizException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
                catch (BOSException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        };
        this.kdOrderChanged = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                String fieldName = StockAllocationEditUI.this.kdOrder.getColumnKey(e.getColIndex());
                if ("receiptQty".equals(fieldName)) {
                    StockAllocationEditUI.this.receipChanged(e);
                }
            }
        };
        this.kdStockChanged = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                String fieldName = StockAllocationEditUI.this.kdStock.getColumnKey(e.getColIndex());
                if ("receiptQty".equals(fieldName)) {
                    StockAllocationEditUI.this.stockReceipChanged(e);
                }
                if ("remark".equals(fieldName)) {
                    StockAllocationEditUI.this.remarkChanged(e);
                }
                if ("demandTime".equals(fieldName)) {
                    StockAllocationEditUI.this.demandTimeChanged(e);
                }
            }
        };
        this.kdSimulateChanged = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                String fieldName = StockAllocationEditUI.this.kdSimulationOrder.getColumnKey(e.getColIndex());
                if ("remark".equals(fieldName)) {
                    StockAllocationEditUI.this.remarkSimulateChanged(e);
                }
                if ("number".equals(fieldName)) {
                    StockAllocationEditUI.this.simulateNumberReceipChanged(e);
                }
            }
        };
        this.storageOrgChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    StockAllocationEditUI.this.storagChanged(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        };
        this.kdOrder.addKDTEditListener((KDTEditListener)this.kdOrderChanged);
        this.kdStock.addKDTEditListener((KDTEditListener)this.kdStockChanged);
        this.kdSimulationOrder.addKDTEditListener((KDTEditListener)this.kdSimulateChanged);
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgChangeListener);
        this.addStockAllocItem();
    }

    private void kdComboBoxChanged() throws EASBizException, BOSException {
        Map resultMap = this.stockAllocQuery(this.sAStockMap_simulate, this.stcProductionLine.getSelectedItem(), this.stcOperation.getSelectedItem(), this.stcIssueWarehouse.getSelectedItem(), this.stcMaterial.getSelectedItem(), this.stcFromOranization.getSelectedItem(), this.stcFromWarehouse.getSelectedItem());
        if (this.sAStockMap != null) {
            this.sAStockMap.clear();
        }
        this.sAStockMap = resultMap;
        this.billMap.remove("transferOrderBillCollection");
        this.billMap.remove("stockTransferBillCollection");
        this.bindingStockData(resultMap);
    }

    private void stockReceipChanged(KDTEditEvent e) {
        BigDecimal newValue = (BigDecimal)e.getValue();
        BigDecimal oldValue = (BigDecimal)e.getOldValue();
        if (newValue == null) {
            this.kdStock.getCell(e.getRowIndex(), e.getColIndex()).setValue((Object)oldValue);
        } else {
            this.updateStockReceiptQty(e.getRowIndex(), newValue);
        }
    }

    private void updateStockReceiptQty(int rowIndex, BigDecimal newValue) {
        String sAStockInfoId = this.kdStock.getCell(rowIndex, "id").getValue().toString();
        SAStockInfo saStockInfo = (SAStockInfo)this.sAStockMap.get(sAStockInfoId);
        if (saStockInfo != null) {
            saStockInfo.setReceiptQty(newValue);
        } else {
            saStockInfo = (SAStockInfo)this.zeroQtySAStockInfoMap.get(sAStockInfoId);
            saStockInfo.setReceiptQty(newValue);
            this.sAStockMap.put(sAStockInfoId, this.zeroQtySAStockInfoMap.get(sAStockInfoId));
            this.zeroQtySAStockInfoMap.remove(sAStockInfoId);
            ProductionOrderStockEntryCollection ptStockCollection = (ProductionOrderStockEntryCollection)((Object)this.sAStockMap.get("ptStockCollection"));
            ProductionOrderStockEntryInfo ptStockInfo = (ProductionOrderStockEntryInfo)this.zeroQtyPtStockInfoMap.get(sAStockInfoId);
            ptStockCollection.add(ptStockInfo);
            this.zeroQtyPtStockInfoMap.remove(sAStockInfoId);
        }
    }

    private void remarkChanged(KDTEditEvent e) {
        Object newValue = e.getValue();
        String sAStockInfoId = this.kdStock.getCell(e.getRowIndex(), "id").getValue().toString();
        SAStockInfo saStockInfo = (SAStockInfo)this.sAStockMap.get(sAStockInfoId);
        if (saStockInfo != null) {
            saStockInfo.setRemark((String)newValue);
        } else {
            saStockInfo = (SAStockInfo)this.zeroQtySAStockInfoMap.get(sAStockInfoId);
            saStockInfo.setRemark((String)newValue);
            this.sAStockMap.put(sAStockInfoId, this.zeroQtySAStockInfoMap.get(sAStockInfoId));
            this.zeroQtySAStockInfoMap.remove(sAStockInfoId);
            ProductionOrderStockEntryCollection ptStockCollection = (ProductionOrderStockEntryCollection)((Object)this.sAStockMap.get("ptStockCollection"));
            ProductionOrderStockEntryInfo ptStockInfo = (ProductionOrderStockEntryInfo)this.zeroQtyPtStockInfoMap.get(sAStockInfoId);
            ptStockCollection.add(ptStockInfo);
            this.zeroQtyPtStockInfoMap.remove(sAStockInfoId);
        }
    }

    private void demandTimeChanged(KDTEditEvent e) {
        Date newValue = (Date)e.getValue();
        Date oldValue = (Date)e.getOldValue();
        if (newValue == null) {
            this.kdStock.getCell(e.getRowIndex(), "demandTime").setValue((Object)oldValue);
            return;
        }
        long newTime = newValue.getTime();
        String id = this.kdStock.getCell(e.getRowIndex(), "id").getValue().toString();
        ProductionOrderStockEntryCollection ptStockCollection = (ProductionOrderStockEntryCollection)((Object)this.sAStockMap.get("ptStockCollection"));
        Map idMap = (Map)this.sAStockMap.get("idMap");
        String ptStockId = (String)idMap.get(id);
        if (ptStockCollection != null && ptStockCollection.size() > 0) {
            for (int j = 0; j < ptStockCollection.size(); ++j) {
                ProductionOrderStockEntryInfo ptStockInfo = ptStockCollection.get(j);
                if (!ptStockId.equals(ptStockInfo.getId().toString())) continue;
                ptStockInfo.setStartDate(new Timestamp(newTime));
                break;
            }
        }
    }

    private void stRuleChanged() throws EASBizException, BOSException {
        this.kdStock.removeRows();
        if (this.stRule.getSelectedItem() == SARuleEnum.NORMAL) {
            this.initOrderRecepitQty(true);
        } else {
            this.initOrderRecepitQty(false);
        }
        int orderRowCount = this.kdOrder.getRowCount();
        if (orderRowCount > 0) {
            for (int i = 0; i < orderRowCount; ++i) {
                SASourceInfo saSourceInfo = new SASourceInfo();
                ProductionOrderInfo ptOrderInfo = new ProductionOrderInfo();
                IRow orderRow = this.kdOrder.getRow(i);
                saSourceInfo.setMaxReceiptQty(new BigDecimal(orderRow.getCell("maxReceiptQty").getValue().toString()));
                saSourceInfo.setMinReceiptQty(new BigDecimal(orderRow.getCell("minReceiptQty").getValue().toString()));
                orderRow.getCell("totalReceiptQty").setValue((Object)this.getTotalReceiptQtyBySASourceInfo(saSourceInfo));
                ptOrderInfo.setQty(new BigDecimal(orderRow.getCell("orderQty").getValue().toString()));
                BigDecimal receiptQty = this.getReceiptQtyBySASourceInfo(ptOrderInfo, orderRow);
                this.updateReceiptQty(i, receiptQty);
                orderRow.getCell("receiptQty").setValue((Object)receiptQty);
                this.setOrderOrStockRowPrecision(orderRow, orderRow.getCell("prdId").getValue().toString(), orderRow.getCell("unitID").getValue().toString(), StockAllocationUtil.getOrderQtyFieldNames());
            }
        }
        this.stockAllocQuerySetting(null, null);
        this.panleSourse.setSelectedIndex(0);
    }

    private void receipChanged(KDTEditEvent e) {
        BigDecimal newValue = (BigDecimal)e.getValue();
        BigDecimal oldValue = (BigDecimal)e.getOldValue();
        if (newValue == null) {
            this.kdOrder.getCell(e.getRowIndex(), e.getColIndex()).setValue((Object)oldValue);
        } else if (newValue.compareTo(new BigDecimal(this.kdOrder.getCell(e.getRowIndex(), "totalReceiptQty").getValue().toString())) < 0) {
            if (SARuleEnum.REINFORCE == (SARuleEnum)((Object)this.stRule.getSelectedItem())) {
                this.kdOrder.getCell(e.getRowIndex(), e.getColIndex()).setValue((Object)oldValue);
            } else {
                this.updateReceiptQty(e.getRowIndex(), newValue);
            }
        } else {
            this.updateReceiptQty(e.getRowIndex(), newValue);
        }
    }

    private void updateReceiptQty(int rowIndex, BigDecimal newValue) {
        String orderId = this.kdOrder.getCell(rowIndex, "orderId").getValue().toString();
        this.receiptQtyMap.put(orderId, newValue);
    }

    private void storagChanged(DataChangeEvent e) throws Exception {
        StorageOrgUnitInfo oldStorage = (StorageOrgUnitInfo)e.getOldValue();
        StorageOrgUnitInfo newStorage = (StorageOrgUnitInfo)e.getNewValue();
        if (newStorage == null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgChangeListener);
            this.prmtStorageOrgUnit.setValue((Object)oldStorage);
            this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgChangeListener);
        } else {
            boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldStorage, (Object)newStorage);
            if (isDiffrent) {
                if (this.kdOrder.getRowCount() > 0) {
                    if (MsgBox.showConfirm2((String)StockAllocationUtil.getResource("IS_CLEAR_DATA")) == 0) {
                        this.clearRow();
                        this.clearStaticData(0);
                        this.stockAllocQuerySetting(null, null);
                        this.setTransactionControl(newStorage);
                    } else {
                        this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgChangeListener);
                        this.prmtStorageOrgUnit.setValue((Object)oldStorage);
                        this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgChangeListener);
                    }
                } else if (this.kdStock.getRowCount() > 0) {
                    if (MsgBox.showConfirm2((String)StockAllocationUtil.getResource("IS_CLEAR_DATA")) == 0) {
                        this.clearRow();
                        this.clearStaticData(0);
                        this.stockAllocQuerySetting(null, null);
                        this.setTransactionControl(newStorage);
                    } else {
                        this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgChangeListener);
                        this.prmtStorageOrgUnit.setValue((Object)oldStorage);
                        this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgChangeListener);
                    }
                } else {
                    this.setTransactionControl(newStorage);
                }
            }
        }
    }

    private void setTransactionControl(StorageOrgUnitInfo storage) throws Exception {
        if (storage != null) {
            this.getStockAllocationParam(storage.getId().toString());
        }
        if (this.isSpecifiedOrder) {
            this.stTransaction.setSelectedItem((Object)SATransactionEnum.SPECIFIEDORDER);
        } else {
            this.stTransaction.setSelectedItem((Object)SATransactionEnum.WAREHOUSERESTOCK);
        }
        this.initAllocationMethod();
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        StockAllocationFilterUI conditionPanel = new StockAllocationFilterUI(this.prmtStorageOrgUnit.getValue());
        return conditionPanel;
    }

    protected CustomerQueryPanel getParamUI() throws Exception {
        StockAllocationParamUI paramPanel = new StockAllocationParamUI(this.stTransaction.getSelectedItem(), (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        return paramPanel;
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRowIndexs = KDTableUtil.getSelectedRows((KDTable)this.kdStock);
        if (selectRowIndexs == null || selectRowIndexs.length == 0) {
            MsgBox.showInfo((String)StockAllocationUtil.getResource("SELECT_STOCKROW_IS_NULL"));
            SysUtil.abort();
        }
        int tmpint = selectRowIndexs.length;
        int tmpint2 = this.kdStock.getRowCount();
        ProductionOrderStockEntryCollection tempPoseCollection = new ProductionOrderStockEntryCollection();
        for (int i = selectRowIndexs.length - 1; i >= 0; --i) {
            IRow stockRow = this.kdStock.getRow(selectRowIndexs[i]);
            String id = (String)stockRow.getCell("id").getValue();
            this.sAStockMap.remove(id);
            ProductionOrderStockEntryCollection ptStockCollection = (ProductionOrderStockEntryCollection)((Object)this.sAStockMap.get("ptStockCollection"));
            Map idMap = (Map)this.sAStockMap.get("idMap");
            String ptStockId = (String)idMap.get(id);
            if (ptStockCollection != null && ptStockCollection.size() > 0) {
                for (int j = 0; j < ptStockCollection.size(); ++j) {
                    ProductionOrderStockEntryInfo ptStockInfo = ptStockCollection.get(j);
                    if (!ptStockId.equals(ptStockInfo.getId().toString())) continue;
                    ptStockCollection.remove(ptStockInfo);
                    tempPoseCollection.add(ptStockInfo);
                    break;
                }
            }
            this.kdStock.removeRow(selectRowIndexs[i]);
        }
        Map resultMap = this.stockAllocQuery(this.sAStockMap, this.stcProductionLine.getSelectedItem(), this.stcOperation.getSelectedItem(), this.stcIssueWarehouse.getSelectedItem(), this.stcMaterial.getSelectedItem(), this.stcFromOranization.getSelectedItem(), this.stcFromWarehouse.getSelectedItem());
        this.clearStockAllocItem();
        if (tmpint == tmpint2) {
            this.stockAllocQuerySetting(this.sAStockMap_simulate, tempPoseCollection);
            this.stcMaterial.setSelectedItem(null);
            this.stcOperation.setSelectedItem(null);
            this.stcIssueWarehouse.setSelectedItem(null);
            this.stcMaterial.setSelectedItem(null);
            this.stcFromOranization.setSelectedItem(null);
            this.stcFromWarehouse.setSelectedItem(null);
        } else if (!(this.stcProductionLine.getSelectedItem() != null && !this.stcProductionLine.getSelectedItem().equals("") || this.stcOperation.getSelectedItem() != null && !this.stcOperation.getSelectedItem().equals("") || this.stcIssueWarehouse.getSelectedItem() != null && !this.stcIssueWarehouse.getSelectedItem().equals("") || this.stcMaterial.getSelectedItem() != null && !this.stcMaterial.getSelectedItem().equals("") || this.stcFromOranization.getSelectedItem() != null && !this.stcFromOranization.getSelectedItem().equals("") || this.stcFromWarehouse.getSelectedItem() != null && !this.stcFromWarehouse.getSelectedItem().equals(""))) {
            this.stockAllocQuerySetting(this.sAStockMap, tempPoseCollection);
        }
        this.addStockAllocItem();
        if (this.sAStockMap != null) {
            this.sAStockMap.clear();
        }
        this.sAStockMap = resultMap;
    }

    @Override
    public void actionCollectCalculate_actionPerformed(ActionEvent e) throws Exception {
        this.checkStorage();
        if (SATransactionEnum.SPECIFIEDORDER.equals(this.stTransaction.getSelectedItem())) {
            if (this.kdOrder.getRowCount() <= 0) {
                MsgBox.showInfo((String)StockAllocationUtil.getResource("ORDER_IS_NULL"));
                SysUtil.abort();
            }
            this.checkReceiptQty();
        }
        this.clearStockAllocItem();
        CommonQueryDialog dialog = this.initParamDialog();
        dialog.show();
        EntityViewInfo entityViewInfo = dialog.getEntityViewInfoResult();
        if (entityViewInfo.getFilter() != null) {
            StockAllocationClientCommon stockAllocationClientCommon = new StockAllocationClientCommon();
            SACalcParamInfo sACalcParam = stockAllocationClientCommon.transferToSACalParamInfo(entityViewInfo);
            if (sACalcParam.getBaseStatus() == null || sACalcParam.getBaseStatus().isEmpty()) {
                HashSet<Integer> baseStatusSet = new HashSet<Integer>();
                baseStatusSet.add(new Integer(2));
                baseStatusSet.add(new Integer(4));
                baseStatusSet.add(new Integer(5));
                baseStatusSet.add(new Integer(8));
                sACalcParam.setBaseStatus(baseStatusSet);
            }
            IStockAllocationFacade remoteFacade = StockAllocationFacadeFactory.getRemoteInstance();
            Map map = null;
            if (SATransactionEnum.WAREHOUSERESTOCK.equals(this.stTransaction.getSelectedItem())) {
                EntityViewInfo view_warestock = new EntityViewInfo();
                FilterInfo filter_warestock = new FilterInfo();
                StorageOrgUnitInfo srcOrg = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
                if (srcOrg != null) {
                    filter_warestock.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)srcOrg.getId().toString(), CompareType.EQUALS));
                } else {
                    filter_warestock.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", null, CompareType.EQUALS));
                }
                filter_warestock.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)sACalcParam.getBaseStatus(), CompareType.INCLUDE));
                view_warestock.setFilter(filter_warestock);
                view_warestock.setSelector(StockAllocationUtil.getSelectors());
                ProductionOrderCollection pococn = ProductionOrderFactory.getRemoteInstance().getProductionOrderCollection(view_warestock);
                ProductionOrderCollection anotherCon = stockAllocationClientCommon.filterPOCollection(pococn);
                if (anotherCon == null || anotherCon.size() <= 0) {
                    return;
                }
                List resultList = remoteFacade.getStockColl(anotherCon);
                if (this.ptStaticOrderCollection == null) {
                    this.ptStaticOrderCollection = anotherCon;
                }
                ProductionOrderStockEntryCollection ptStockCollection = (ProductionOrderStockEntryCollection)((Object)resultList.get(0));
                map = remoteFacade.sACalculate(anotherCon, ptStockCollection, null, sACalcParam, (SARuleEnum)((Object)this.stRule.getSelectedItem()), (SATransactionEnum)((Object)this.stTransaction.getSelectedItem()), ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString());
            } else {
                map = remoteFacade.sACalculate(this.ptStaticOrderCollection, this.ptStaticOrderStockEntryCollection, this.receiptQtyMap, sACalcParam, (SARuleEnum)((Object)this.stRule.getSelectedItem()), (SATransactionEnum)((Object)this.stTransaction.getSelectedItem()), ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString());
            }
            this.clearStaticData(1);
            this.panleSourse.setEnabledAt(1, true);
            this.panleSourse.setSelectedIndex(1);
            this.stockAllocQuerySetting(map, null);
            this.sAStockMap = map;
            for (Map.Entry entry : this.sAStockMap.entrySet()) {
                Object key = entry.getKey();
                Object val = entry.getValue();
                this.sAStockMap_simulate.put(key, val);
            }
            this.bindingStockData(map);
        }
        this.addStockAllocItem();
    }

    private void clearStockAllocItem() {
        this.stcProductionLine.removeItemListener(this.stockAllocComboChanged);
        this.stcOperation.removeItemListener(this.stockAllocComboChanged);
        this.stcIssueWarehouse.removeItemListener(this.stockAllocComboChanged);
        this.stcMaterial.removeItemListener(this.stockAllocComboChanged);
        this.stcFromOranization.removeItemListener(this.stockAllocComboChanged);
        this.stcFromWarehouse.removeItemListener(this.stockAllocComboChanged);
    }

    private void addStockAllocItem() {
        this.stcProductionLine.addItemListener(this.stockAllocComboChanged);
        this.stcOperation.addItemListener(this.stockAllocComboChanged);
        this.stcIssueWarehouse.addItemListener(this.stockAllocComboChanged);
        this.stcMaterial.addItemListener(this.stockAllocComboChanged);
        this.stcFromOranization.addItemListener(this.stockAllocComboChanged);
        this.stcFromWarehouse.addItemListener(this.stockAllocComboChanged);
    }

    private void stockAllocQuerySetting(Map resultMap, ProductionOrderStockEntryCollection tempPoseCollection) throws EASBizException, BOSException {
        this.stcProductionLine.removeAllItems();
        this.stcOperation.removeAllItems();
        this.stcIssueWarehouse.removeAllItems();
        this.stcMaterial.removeAllItems();
        this.stcFromOranization.removeAllItems();
        this.stcFromWarehouse.removeAllItems();
        if (resultMap == null) {
            return;
        }
        ProductionOrderStockEntryCollection ptStockCollection = (ProductionOrderStockEntryCollection)((Object)resultMap.get("ptStockCollection"));
        Map idMap = (Map)resultMap.get("idMap");
        Vector<String> items_ProductionLine = new Vector<String>();
        Vector<String> items_Operation = new Vector<String>();
        Vector<String> items_IssueWarehouse = new Vector<String>();
        Vector<String> items_Material = new Vector<String>();
        Vector<String> items_FromOranization = new Vector<String>();
        Vector<String> items_FromWarehouse = new Vector<String>();
        if (ptStockCollection != null && ptStockCollection.size() > 0) {
            for (int i = 0; i < ptStockCollection.size(); ++i) {
                SAStockInfo sAStockInfo;
                ProductionOrderStockEntryInfo ptStockInfo = ptStockCollection.get(i);
                if (tempPoseCollection != null && tempPoseCollection.contains(ptStockInfo) || (sAStockInfo = (SAStockInfo)resultMap.get((String)idMap.get(ptStockInfo.getId().toString()))) == null) continue;
                ObjectUuidPK pk = new ObjectUuidPK(sAStockInfo.getProductLineId());
                ProductLineInfo temp_pl = ProductLineFactory.getRemoteInstance().getProductLineInfo((IObjectPK)pk);
                if (temp_pl != null && !items_ProductionLine.contains(temp_pl.getName())) {
                    items_ProductionLine.add(temp_pl.getName());
                }
                if (sAStockInfo.getOperationNo() != null && !items_Operation.contains(sAStockInfo.getOperationNo())) {
                    items_Operation.add(sAStockInfo.getOperationNo());
                }
                if (ptStockInfo.getDefaultWarehouse() != null && !items_IssueWarehouse.contains(ptStockInfo.getDefaultWarehouse().getName()) && ptStockInfo.getDefaultWarehouse().getName() != null) {
                    items_IssueWarehouse.add(ptStockInfo.getDefaultWarehouse().getName());
                }
                if (ptStockInfo.getMaterial() != null && !items_Material.contains(ptStockInfo.getMaterial().getName())) {
                    items_Material.add(ptStockInfo.getMaterial().getName());
                }
                if (ptStockInfo.getMoveOutStorageOrgUnit() != null && !items_FromOranization.contains(ptStockInfo.getMoveOutStorageOrgUnit().getName())) {
                    items_FromOranization.add(ptStockInfo.getMoveOutStorageOrgUnit().getName());
                }
                if (ptStockInfo.getMoveOutWarehouse() == null || items_FromWarehouse.contains(ptStockInfo.getMoveOutWarehouse().getName()) || ptStockInfo.getMoveOutWarehouse().getName() == null) continue;
                items_FromWarehouse.add(ptStockInfo.getMoveOutWarehouse().getName());
            }
        }
        if (!items_ProductionLine.isEmpty()) {
            this.stcProductionLine.addItem((Object)"");
            this.stcProductionLine.addItems(items_ProductionLine);
        }
        if (!items_Operation.isEmpty()) {
            this.stcOperation.addItem((Object)"");
            this.stcOperation.addItems(items_Operation);
        }
        if (!items_IssueWarehouse.isEmpty()) {
            this.stcIssueWarehouse.addItem((Object)"");
            this.stcIssueWarehouse.addItems(items_IssueWarehouse);
        }
        if (!items_Material.isEmpty()) {
            this.stcMaterial.addItem((Object)"");
            this.stcMaterial.addItems(items_Material);
        }
        if (!items_FromOranization.isEmpty()) {
            this.stcFromOranization.addItem((Object)"");
            this.stcFromOranization.addItems(items_FromOranization);
        }
        if (!items_FromWarehouse.isEmpty()) {
            this.stcFromWarehouse.addItem((Object)"");
            this.stcFromWarehouse.addItems(items_FromWarehouse);
        }
    }

    private Map stockAllocQuery(Map sourceMap, Object productionLine, Object operation, Object issueWarehouse, Object material, Object fromOranization, Object fromWarehouse) throws EASBizException, BOSException {
        HashMap resultMap = new HashMap();
        for (Map.Entry entry : sourceMap.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            resultMap.put(key, val);
        }
        ProductionOrderStockEntryCollection ptStockCollection = (ProductionOrderStockEntryCollection)((Object)resultMap.get("ptStockCollection"));
        Map idMap = (Map)resultMap.get("idMap");
        if (ptStockCollection != null && ptStockCollection.size() > 0) {
            for (int i = 0; i < ptStockCollection.size(); ++i) {
                ProductionOrderStockEntryInfo ptStockInfo = ptStockCollection.get(i);
                SAStockInfo sAStockInfo = (SAStockInfo)resultMap.get((String)idMap.get(ptStockInfo.getId().toString()));
                if (sAStockInfo == null) continue;
                if (productionLine != null && !productionLine.toString().equals("")) {
                    ObjectUuidPK pk_pl = null;
                    ProductLineInfo temp_pl = null;
                    if (!"".equals(sAStockInfo.getProductLineId())) {
                        pk_pl = new ObjectUuidPK(sAStockInfo.getProductLineId());
                        temp_pl = ProductLineFactory.getRemoteInstance().getProductLineInfo((IObjectPK)pk_pl);
                        if (!productionLine.toString().equals(temp_pl.getName())) {
                            resultMap.remove(sAStockInfo.getId());
                            continue;
                        }
                    }
                }
                if (!(operation == null || operation.toString().equals("") || sAStockInfo.getOperationNo() != null && operation.toString().equals(sAStockInfo.getOperationNo()))) {
                    resultMap.remove(sAStockInfo.getId());
                    continue;
                }
                if (!(issueWarehouse == null || issueWarehouse.toString().equals("") || ptStockInfo.getDefaultWarehouse() != null && issueWarehouse.toString().equals(ptStockInfo.getDefaultWarehouse().getName()))) {
                    resultMap.remove(sAStockInfo.getId());
                    continue;
                }
                if (!(material == null || material.toString().equals("") || ptStockInfo.getMaterial() != null && material.toString().equals(ptStockInfo.getMaterial().getName()))) {
                    resultMap.remove(sAStockInfo.getId());
                    continue;
                }
                if (!(fromOranization == null || fromOranization.toString().equals("") || ptStockInfo.getMoveOutStorageOrgUnit() != null && fromOranization.toString().equals(ptStockInfo.getMoveOutStorageOrgUnit().getName()))) {
                    resultMap.remove(sAStockInfo.getId());
                    continue;
                }
                if (fromWarehouse == null || fromWarehouse.toString().equals("") || ptStockInfo.getMoveOutWarehouse() != null && fromWarehouse.toString().equals(ptStockInfo.getMoveOutWarehouse().getName())) continue;
                resultMap.remove(sAStockInfo.getId());
            }
        }
        return resultMap;
    }

    protected CommonQueryDialog initParamDialog() throws Exception {
        CommonQueryDialog paramDialog = this.initMyCommonQueryDialog("com.kingdee.eas.mm.control.app", "SACalculateQuery", this.getUITitle() + " - " + StockAllocationUtil.getResource("CALCULATE_TITLE"));
        paramDialog.setWidth(480);
        paramDialog.setHeight(320);
        CustomerQueryPanel paramPanel = this.getParamUI();
        try {
            SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(paramPanel, this.getMainBizOrgType());
            paramDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
            paramDialog.setProcessor((IProcessor)new SCMCommonProcessor());
            paramDialog.addUserPanel((KDPanel)paramPanel);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return paramDialog;
    }

    private void checkReceiptQty() {
        boolean flag = false;
        boolean flag_reinforce = false;
        boolean flag_suit = false;
        for (int i = this.kdOrder.getRowCount() - 1; i >= 0; --i) {
            BigDecimal totalRecetipQty;
            BigDecimal noReceiptQty;
            IRow row = this.kdOrder.getRow(i);
            BigDecimal receiptQty = (BigDecimal)row.getCell("receiptQty").getValue();
            if (receiptQty.signum() <= 0) {
                flag = true;
            }
            BigDecimal orderQty = (BigDecimal)row.getCell("orderQty").getValue();
            if (SARuleEnum.REINFORCE == (SARuleEnum)((Object)this.stRule.getSelectedItem()) && receiptQty.compareTo(orderQty) > 0) {
                flag_reinforce = true;
            }
            if ((noReceiptQty = orderQty.subtract(totalRecetipQty = row.getCell("totalReceiptQty").getValue() != null ? (BigDecimal)row.getCell("totalReceiptQty").getValue() : ZERO)).signum() < 0) {
                noReceiptQty = ZERO;
            }
            if (SARuleEnum.SUIT == (SARuleEnum)((Object)this.stRule.getSelectedItem()) && receiptQty.compareTo(noReceiptQty) > 0) {
                flag_suit = true;
            }
            if (flag && flag_reinforce && flag_suit) break;
        }
        if (flag && MsgBox.showConfirm2((String)StockAllocationUtil.getResource("RECEIPT_QTY_IS_NULL")) != 0) {
            SysUtil.abort();
        }
        if (flag_reinforce && MsgBox.showConfirm2((String)StockAllocationUtil.getResource("RECEIPT_QTY_MORETHEN_QTY")) != 0) {
            SysUtil.abort();
        }
        if (flag_suit && MsgBox.showConfirm2((String)StockAllocationUtil.getResource("RECEIPT_QTY_MORETHEN_QTY_SUBSTRACTRECEPT")) != 0) {
            SysUtil.abort();
        }
    }

    @Override
    public void actionBuild_actionPerformed(ActionEvent e) throws Exception {
        this.checkStorage();
        if (this.kdSimulationOrder.getRowCount() <= 0) {
            MsgBox.showInfo((String)StockAllocationUtil.getResource("BILL_IS_NULL"));
            SysUtil.abort();
        }
        IStockAllocationFacade remoteFacade = StockAllocationFacadeFactory.getRemoteInstance();
        this.billMap.put("storageOrgUnitInfo", (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        int flag = remoteFacade.generateDestBill(this.billMap);
        String msg = "";
        if (flag == 0) {
            this.billMap.put("isBuild", new Boolean(true));
            msg = StockAllocationUtil.getResource("BUILD_SUCCEED");
        } else {
            msg = flag == 1 ? StockAllocationUtil.getResource("ALREADY_BUILDED") : StockAllocationUtil.getResource("ALREADY_PARTIAL_BUILDED");
        }
        this.setMessageText(msg);
        this.showMessage();
        MsgBox.showInfo((String)msg);
    }

    @Override
    public void actionSimulate_actionPerformed(ActionEvent e) throws Exception {
        this.checkStorage();
        StockAllocationUtil.setMergeColumn(this.kdSimulationOrder);
        if (this.kdStock.getRowCount() <= 0) {
            MsgBox.showInfo((String)StockAllocationUtil.getResource("STOCK_IS_NULL"));
            SysUtil.abort();
        }
        boolean flag = false;
        ProductionOrderStockEntryCollection ptStockCollection = (ProductionOrderStockEntryCollection)((Object)this.sAStockMap.get("ptStockCollection"));
        Map idMap = (Map)this.sAStockMap.get("idMap");
        HashSet<String> setReceiptqtyZero = new HashSet<String>();
        if (ptStockCollection != null && ptStockCollection.size() > 0) {
            for (int i = 0; i < ptStockCollection.size(); ++i) {
                ProductionOrderStockEntryInfo ptStockInfo = ptStockCollection.get(i);
                SAStockInfo sAStockInfo = (SAStockInfo)this.sAStockMap.get((String)idMap.get(ptStockInfo.getId().toString()));
                if (sAStockInfo == null) continue;
                if (ptStockInfo.getTransactionType() == TransactionTypeEnum.NULL) {
                    String orderNumber = ptStockInfo.getParent() != null ? ptStockInfo.getParent().getNumber() : StockAllocationUtil.getResource("MergeOrder");
                    MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(StockAllocationUtil.getResource("NotTransactionTypeEnum"), orderNumber, ptStockInfo.getMaterial().getName()));
                    SysUtil.abort();
                }
                if (sAStockInfo.getReceiptQty().signum() > 0) continue;
                flag = true;
                setReceiptqtyZero.add(ptStockInfo.getId().toString());
            }
        }
        if (flag) {
            if (MsgBox.showConfirm2((String)StockAllocationUtil.getResource("STOCK_ZERO")) == 0) {
                this.simulate(setReceiptqtyZero);
            } else {
                SysUtil.abort();
            }
        } else {
            this.simulate(null);
        }
    }

    private void simulate(Set setReceiptqtyZero) throws BOSException, EASBizException {
        this.setOprtState("EDIT");
        boolean flag = false;
        IStockAllocationFacade remoteFacade = StockAllocationFacadeFactory.getRemoteInstance();
        if (this.billMap != null && (this.billMap.containsKey("transferOrderBillCollection") || this.billMap.containsKey("stockTransferBillCollection")) && ((Boolean)this.billMap.get("isBuild")).booleanValue()) {
            if (MsgBox.showConfirm2((String)StockAllocationUtil.getResource("STOCK_BILL_IS_BUILD")) == 0) {
                remoteFacade.deleteDestBill(this.billMap);
                this.billMap.put("isBuild", new Boolean(false));
            } else {
                flag = true;
            }
        }
        if (!flag) {
            if (setReceiptqtyZero != null && setReceiptqtyZero.size() > 0) {
                ProductionOrderStockEntryCollection ptStockCollection = (ProductionOrderStockEntryCollection)((Object)this.sAStockMap.get("ptStockCollection"));
                Map idMap = (Map)this.sAStockMap.get("idMap");
                block0: for (String strReceiptqtyZero : setReceiptqtyZero) {
                    if (ptStockCollection == null || ptStockCollection.size() <= 0) continue;
                    for (int i = 0; i < ptStockCollection.size(); ++i) {
                        ProductionOrderStockEntryInfo ptStockInfo = ptStockCollection.get(i);
                        SAStockInfo sAStockInfo = (SAStockInfo)this.sAStockMap.get((String)idMap.get(ptStockInfo.getId().toString()));
                        if (sAStockInfo == null || !strReceiptqtyZero.equals(ptStockInfo.getId().toString())) continue;
                        this.sAStockMap.remove(sAStockInfo.getId().toString());
                        ptStockCollection.remove(ptStockInfo);
                        this.zeroQtySAStockInfoMap.put(sAStockInfo.getId().toString(), sAStockInfo);
                        this.zeroQtyPtStockInfoMap.put(sAStockInfo.getId().toString(), ptStockInfo);
                        continue block0;
                    }
                }
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("SAStockMap", this.sAStockMap);
            paramMap.put("SAGroupEnum", (Object)((SAGroupEnum)((Object)this.stGroup.getSelectedItem())));
            paramMap.put("storageOrgUnitInfo", (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
            Map resultMap = remoteFacade.prepareDestBill(paramMap);
            this.bindingBillData(resultMap);
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.checkStorage();
        UIContext uiContext = new UIContext((Object)this);
        this.setSARuleSel(uiContext);
        if (this.billMap != null && (this.billMap.containsKey("transferOrderBillCollection") || this.billMap.containsKey("stockTransferBillCollection")) && !((Boolean)this.billMap.get("isBuild")).booleanValue() && MsgBox.showConfirm2((String)StockAllocationUtil.getResource("SIMULATE_NO_BUILD")) != 0) {
            SysUtil.abort();
        }
        CommonQueryDialog dialog = this.initCommonQueryDialog();
        dialog.show();
        EntityViewInfo entityViewInfo = dialog.getEntityViewInfoResult();
        if (entityViewInfo.getFilter() == null) {
            this.abort();
        }
        FilterInfo filter1 = entityViewInfo.getFilter();
        FilterItemCollection items = filter1.getFilterItems();
        for (int index = items.size() - 1; index >= 0; --index) {
            FilterItemInfo filterInfo = items.get(index);
            if (!filterInfo.getPropertyName().equals("storageOrgUnit.number") || filterInfo.getCompareValue().toString().equals(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getNumber())) continue;
            MsgBox.showInfo((String)StockAllocationUtil.getResource("STORAGE_ORG_DIFFERENT"));
            SysUtil.abort();
        }
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> baseStatusSet = new HashSet<Integer>();
        baseStatusSet.add(new Integer(2));
        baseStatusSet.add(new Integer(4));
        baseStatusSet.add(new Integer(5));
        baseStatusSet.add(new Integer(8));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", baseStatusSet, CompareType.INCLUDE));
        entityViewInfo.getFilter().mergeFilter(filter, "and");
        entityViewInfo.setSelector(StockAllocationUtil.getSelectors());
        ProductionOrderCollection pococn = ProductionOrderFactory.getRemoteInstance().getProductionOrderCollection(entityViewInfo);
        StockAllocationClientCommon stockAllocationClientCommon = new StockAllocationClientCommon();
        ProductionOrderCollection anotherCon = stockAllocationClientCommon.filterPOCollection(pococn);
        uiContext.put((Object)"pococn", (Object)anotherCon);
        uiContext.put((Object)"storageUnitInfo", this.prmtStorageOrgUnit.getValue());
        this.stockAllocationSourceWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.mm.control.client.StockAllocationSourceUI", (Map)uiContext, null, OprtState.VIEW);
        StockAllocationSourceUI sourceUI = (StockAllocationSourceUI)this.stockAllocationSourceWindow.getUIObject();
        this.stockAllocationSourceWindow.show();
        if (sourceUI.getResultList() != null) {
            this.clearStaticData(0);
            this.stockAllocQuerySetting(null, null);
            List resultList = sourceUI.getResultList();
            this.bindingOrderData(resultList);
        }
        this.panleSourse.setSelectedIndex(0);
    }

    private void setSARuleSel(UIContext uiContext) {
        SARuleEnum saRuleSelEnum = (SARuleEnum)((Object)this.stRule.getSelectedItem());
        uiContext.put((Object)"saRuleSelEnum", (Object)saRuleSelEnum);
    }

    private void checkStorage() {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)StockAllocationUtil.getResource("STORAGEUNIT_IS_NOT_NULL"));
            SysUtil.abort();
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() throws Exception {
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}-{1}");
        String title = format.format(new Object[]{StockAllocationUtil.getResource("PRODUCTIONTITLE"), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter")});
        CommonQueryDialog commonQueryDialog = this.initMyCommonQueryDialog("com.kingdee.eas.base.message", "MsgQuery", title);
        commonQueryDialog.setWidth(480);
        commonQueryDialog.setHeight(340);
        CustomerQueryPanel conditionPanel = this.getFilterUI();
        try {
            SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(conditionPanel, this.getMainBizOrgType());
            commonQueryDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
            commonQueryDialog.setProcessor((IProcessor)new SCMCommonProcessor());
            commonQueryDialog.addUserPanel((KDPanel)conditionPanel);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return commonQueryDialog;
    }

    protected CommonQueryDialog initMyCommonQueryDialog(String queryPackage, String queryName, String title) {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        MetaDataPK mainQueryPK = MetaDataPK.create((String)queryPackage, (String)queryName);
        dialog.setQueryObjectPK((IMetaDataPK)mainQueryPK);
        dialog.setParentUIClassName(this.getClass().getName());
        dialog.setTitle(title);
        dialog.setShowSorter(false);
        dialog.setShowFilter(false);
        return dialog;
    }

    private void clearStaticData(int key) {
        switch (key) {
            case 0: {
                if (this.ptStaticOrderCollection != null) {
                    this.ptStaticOrderCollection.clear();
                }
                if (this.ptStaticOrderStockEntryCollection != null) {
                    this.ptStaticOrderStockEntryCollection.clear();
                }
                if (this.sASourceMap != null) {
                    this.sASourceMap.clear();
                }
                if (this.sAStockMap != null) {
                    this.sAStockMap.clear();
                }
                if (this.sAStockMap_simulate != null) {
                    this.sAStockMap_simulate.clear();
                }
                if (this.billMap == null) break;
                this.billMap.clear();
                break;
            }
            case 1: {
                if (this.billMap == null) break;
                this.billMap.clear();
                break;
            }
            case 2: {
                if (this.billMap == null) break;
                this.billMap.clear();
                break;
            }
            case 3: {
                break;
            }
        }
    }

    private void bindingOrderData(List resultList) throws EASBizException, BOSException {
        ProductionOrderCollection ptOrderCollection;
        this.clearRow();
        this.ptStaticOrderCollection = ptOrderCollection = (ProductionOrderCollection)((Object)resultList.get(0));
        this.sASourceMap = (Map)resultList.get(1);
        this.precisionMap = (Map)resultList.get(2);
        this.ptStaticOrderStockEntryCollection = (ProductionOrderStockEntryCollection)((Object)resultList.get(3));
        for (int i = 0; i < ptOrderCollection.size(); ++i) {
            IRow orderRow = this.kdOrder.addRow();
            ProductionOrderInfo ptOrderInfo = ptOrderCollection.get(i);
            SASourceInfo saSourceInfo = (SASourceInfo)this.sASourceMap.get(ptOrderInfo.getId().toString());
            orderRow.getCell("billType").setValue((Object)(ptOrderInfo.getBillType() != null ? ptOrderInfo.getBillType().getName() : ""));
            orderRow.getCell("number").setValue((Object)ptOrderInfo.getNumber());
            orderRow.getCell("bizType").setValue((Object)(ptOrderInfo.getMmBizType() != null ? ptOrderInfo.getMmBizType().getAlias() : ""));
            orderRow.getCell("productLine").setValue((Object)(ptOrderInfo.getProductLine() != null ? ptOrderInfo.getProductLine().getName() : ""));
            orderRow.getCell("prdNumber").setValue((Object)(ptOrderInfo.getMaterial() != null ? ptOrderInfo.getMaterial().getNumber() : ""));
            orderRow.getCell("prdName").setValue((Object)(ptOrderInfo.getMaterial() != null ? ptOrderInfo.getMaterial().getName() : ""));
            orderRow.getCell("prdModel").setValue((Object)(ptOrderInfo.getMaterial() != null ? ptOrderInfo.getMaterial().getModel() : ""));
            orderRow.getCell("trackNumber").setValue((Object)(ptOrderInfo.getTrackNumber() != null ? ptOrderInfo.getTrackNumber().getNumber() : ""));
            orderRow.getCell("formula").setValue((Object)(ptOrderInfo.getFormula() != null ? ptOrderInfo.getFormula().getName() : ""));
            orderRow.getCell("bom").setValue((Object)(ptOrderInfo.getBom() != null ? ptOrderInfo.getBom().getName() : ""));
            orderRow.getCell("orderQty").setValue((Object)ptOrderInfo.getQty());
            orderRow.getCell("totalReceiptQty").setValue((Object)this.getTotalReceiptQtyBySASourceInfo(saSourceInfo));
            BigDecimal receiptQty = this.getReceiptQtyBySASourceInfo(ptOrderInfo, orderRow);
            orderRow.getCell("receiptQty").setValue((Object)receiptQty);
            this.receiptQtyMap.put(ptOrderInfo.getId().toString(), receiptQty);
            orderRow.getCell("unit").setValue((Object)ptOrderInfo.getUnit());
            orderRow.getCell("planBeginDate").setValue((Object)ptOrderInfo.getStartDate());
            orderRow.getCell("planEndDate").setValue((Object)ptOrderInfo.getExpectEndDate());
            orderRow.getCell("prdId").setValue((Object)(ptOrderInfo.getMaterial() != null ? ptOrderInfo.getMaterial().getId().toString() : ""));
            orderRow.getCell("unitID").setValue((Object)(ptOrderInfo.getUnit() != null ? ptOrderInfo.getUnit().getId().toString() : ""));
            orderRow.getCell("orderId").setValue((Object)ptOrderInfo.getId());
            orderRow.getCell("maxReceiptQty").setValue((Object)saSourceInfo.getMaxReceiptQty());
            orderRow.getCell("bsMaxReceiptQty").setValue((Object)saSourceInfo.getBsMaxReceiptQty());
            orderRow.getCell("minReceiptQty").setValue((Object)saSourceInfo.getMinReceiptQty());
            orderRow.getCell("bsMinReceiptQty").setValue((Object)saSourceInfo.getBsMinReceiptQty());
            this.setOrderOrStockRowPrecision(orderRow, ptOrderInfo.getMaterial().getId().toString(), ptOrderInfo.getUnit().getId().toString(), StockAllocationUtil.getOrderQtyFieldNames());
        }
    }

    private void bindingStockData(Map resultMap) throws EASBizException, BOSException {
        this.kdStock.removeRows();
        this.kdSimulationOrder.removeRows();
        ProductionOrderStockEntryCollection ptStockCollection = this.sortOrderCollectionByMaterial((ProductionOrderStockEntryCollection)((Object)resultMap.get("ptStockCollection")));
        Map idMap = (Map)resultMap.get("idMap");
        if (this.precisionMap == null) {
            if (this.ptStaticOrderCollection == null) {
                return;
            }
            IStockAllocationFacade facade = StockAllocationFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            this.precisionMap = facade.getStockDataPrecision(this.ptStaticOrderCollection);
        }
        if (ptStockCollection != null && ptStockCollection.size() > 0) {
            for (int i = 0; i < ptStockCollection.size(); ++i) {
                WarehouseInfo warehouse;
                ObjectUuidPK pk;
                ProductionOrderStockEntryInfo ptStockInfo = ptStockCollection.get(i);
                SAStockInfo sAStockInfo = (SAStockInfo)resultMap.get((String)idMap.get(ptStockInfo.getId().toString()));
                if (sAStockInfo == null) continue;
                IRow stockRow = this.kdStock.addRow();
                stockRow.getCell("orderNumber").setValue((Object)(ptStockInfo.getParent() != null ? ptStockInfo.getParent().getNumber() : ""));
                ObjectUuidPK pk_track = null;
                TrackNumberInfo temp_tn = null;
                if (!"".equals(sAStockInfo.getTrackNumberId())) {
                    pk_track = new ObjectUuidPK(sAStockInfo.getTrackNumberId());
                    temp_tn = TrackNumberFactory.getRemoteInstance().getTrackNumberInfo((IObjectPK)pk_track);
                }
                stockRow.getCell("trackNumber").setValue((Object)(temp_tn != null ? temp_tn.getNumber() : ""));
                if (ptStockInfo.getMaterial() != null) {
                    ObjectUuidPK pk2 = new ObjectUuidPK(ptStockInfo.getMaterial().getId().toString());
                    MaterialInfo material = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)pk2);
                    stockRow.getCell("materialNumber").setValue((Object)material.getNumber());
                    stockRow.getCell("materialName").setValue((Object)material.getName());
                    stockRow.getCell("materialModel").setValue((Object)material.getModel());
                } else {
                    stockRow.getCell("materialNumber").setValue((Object)"");
                    stockRow.getCell("materialName").setValue((Object)"");
                    stockRow.getCell("materialModel").setValue((Object)"");
                }
                ObjectUuidPK pk_pl = null;
                ProductLineInfo temp_pl = null;
                if (!"".equals(sAStockInfo.getProductLineId())) {
                    pk_pl = new ObjectUuidPK(sAStockInfo.getProductLineId());
                    temp_pl = ProductLineFactory.getRemoteInstance().getProductLineInfo((IObjectPK)pk_pl);
                }
                stockRow.getCell("productLine").setValue((Object)(temp_pl != null ? temp_pl.getName() : ""));
                stockRow.getCell("operationNo").setValue((Object)sAStockInfo.getOperationNo());
                stockRow.getCell("operationName").setValue((Object)sAStockInfo.getOperationName());
                if (ptStockInfo.getUnit() != null) {
                    pk = new ObjectUuidPK(ptStockInfo.getUnit().getId().toString());
                    MeasureUnitInfo unit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)pk);
                    stockRow.getCell("stockUnit").setValue((Object)unit.getName());
                } else {
                    stockRow.getCell("stockUnit").setValue((Object)"");
                }
                stockRow.getCell("invQty").setValue((Object)sAStockInfo.getInvQty());
                stockRow.getCell("stockReserveQty").setValue((Object)sAStockInfo.getStockReserveQty());
                stockRow.getCell("demandTime").setValue((Object)ptStockInfo.getStartDate());
                stockRow.getCell("reqQty").setValue((Object)sAStockInfo.getReqQty());
                stockRow.getCell("receiptReqQty").setValue((Object)sAStockInfo.getReceiptReqQty());
                stockRow.getCell("receiptQty").setValue((Object)sAStockInfo.getReceiptQty());
                stockRow.getCell("totalReceiptQty").setValue((Object)sAStockInfo.getTotalReceiptQty());
                stockRow.getCell("transferBatch").setValue((Object)sAStockInfo.getTransferBatch());
                if (ptStockInfo.getDefaultWarehouse() != null) {
                    pk = new ObjectUuidPK(ptStockInfo.getDefaultWarehouse().getId().toString());
                    warehouse = WarehouseFactory.getRemoteInstance().getWarehouseInfo((IObjectPK)pk);
                    stockRow.getCell("warehouse").setValue((Object)warehouse.getName());
                } else {
                    stockRow.getCell("warehouse").setValue((Object)"");
                }
                if (ptStockInfo.getMoveOutStorageOrgUnit() != null) {
                    pk = new ObjectUuidPK(ptStockInfo.getMoveOutStorageOrgUnit().getId().toString());
                    StorageOrgUnitInfo orginfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)pk);
                    stockRow.getCell("fromStorageOrg").setValue((Object)orginfo.getName());
                } else {
                    stockRow.getCell("fromStorageOrg").setValue((Object)"");
                }
                if (ptStockInfo.getMoveOutWarehouse() != null) {
                    pk = new ObjectUuidPK(ptStockInfo.getMoveOutWarehouse().getId().toString());
                    warehouse = WarehouseFactory.getRemoteInstance().getWarehouseInfo((IObjectPK)pk);
                    stockRow.getCell("fromWarehs").setValue((Object)warehouse.getName());
                } else {
                    stockRow.getCell("fromWarehs").setValue((Object)"");
                }
                stockRow.getCell("remark").setValue((Object)ptStockInfo.getRemark());
                stockRow.getCell("id").setValue((Object)sAStockInfo.getId());
                stockRow.getCell("orderId").setValue((Object)sAStockInfo.getOrderId());
                stockRow.getCell("stockEntryId").setValue((Object)sAStockInfo.getStockEntryId());
                stockRow.getCell("materialId").setValue((Object)sAStockInfo.getMaterialId());
                stockRow.getCell("unitId").setValue((Object)sAStockInfo.getUnitId());
                stockRow.getCell("bsUnitId").setValue((Object)sAStockInfo.getBsUnitId());
                stockRow.getCell("bsInvQty").setValue((Object)sAStockInfo.getBsInvQty());
                stockRow.getCell("bsStockReserveQty").setValue((Object)sAStockInfo.getBsStockReserveQty());
                stockRow.getCell("bsReqQty").setValue((Object)sAStockInfo.getBsReqQty());
                stockRow.getCell("bsReceiptReqQty").setValue((Object)sAStockInfo.getBsReceiptReqQty());
                stockRow.getCell("bsReceiptQty").setValue((Object)sAStockInfo.getBsReceiptQty());
                stockRow.getCell("bsTotalReceiptQty").setValue((Object)sAStockInfo.getBsTotalReceiptQty());
                stockRow.getCell("bsTransferBatch").setValue((Object)sAStockInfo.getBsTransferBatch());
                stockRow.getCell("warehouseId").setValue((Object)sAStockInfo.getWarehouseId());
                stockRow.getCell("fromStorageOrgId").setValue((Object)sAStockInfo.getFromStorageOrgId());
                stockRow.getCell("fromWarehsId").setValue((Object)sAStockInfo.getFromWarehsId());
                stockRow.getCell("transferType").setValue((Object)ptStockInfo.getTransactionType());
                this.setOrderOrStockRowPrecision(stockRow, ptStockInfo.getMaterial().getId().toString(), ptStockInfo.getUnit().getId().toString(), StockAllocationUtil.getStockQtyFieldNames());
            }
        }
    }

    private void bindingBillData(Map resultMap) throws EASBizException, BOSException {
        IRow simulationOrderRow;
        int j;
        int i;
        this.kdSimulationOrder.removeRows();
        this.billMap = resultMap;
        TransferOrderBillCollection toCollection = (TransferOrderBillCollection)resultMap.get("transferOrderBillCollection");
        StockTransferBillCollection stCollection = (StockTransferBillCollection)resultMap.get("stockTransferBillCollection");
        if (toCollection != null && toCollection.size() > 0) {
            for (i = 0; i < toCollection.size(); ++i) {
                TransferOrderBillInfo toInfo = toCollection.get(i);
                TransferOrderBillEntryCollection toEntryCollection = toInfo.getEntry();
                if (toEntryCollection == null || toEntryCollection.size() <= 0) continue;
                for (j = 0; j < toEntryCollection.size(); ++j) {
                    TransferOrderBillEntryInfo toEntryInfo = toEntryCollection.get(j);
                    simulationOrderRow = this.kdSimulationOrder.addRow();
                    simulationOrderRow.getCell("id").setValue((Object)toInfo.getId().toString());
                    simulationOrderRow.getCell("entryId").setValue((Object)toEntryInfo.getId().toString());
                    simulationOrderRow.getCell("sTDestBillType").setValue((Object)StockAllocationUtil.getResource("BIZ_TRANSFER_ORDER"));
                    simulationOrderRow.getCell("issueStorageOrgUnit").setValue((Object)(toInfo.getIssueStorageOrgUnit() != null ? toInfo.getIssueStorageOrgUnit().getName() : ""));
                    simulationOrderRow.getCell("number").setValue((Object)toInfo.getNumber());
                    simulationOrderRow.getCell("bizType").setValue((Object)(toInfo.getBizType() != null ? toInfo.getBizType().getName() : ""));
                    simulationOrderRow.getCell("trackNumber").setValue((Object)(toEntryInfo.getTrackNumber() != null ? toEntryInfo.getTrackNumber().getNumber() : ""));
                    simulationOrderRow.getCell("receiptAdminOrgUnit").setValue((Object)(toInfo.getReceiptAdminOrgUnit() != null ? toInfo.getReceiptAdminOrgUnit().getName() : ""));
                    simulationOrderRow.getCell("materialNumber").setValue((Object)(toEntryInfo.getMaterial() != null ? toEntryInfo.getMaterial().getNumber() : ""));
                    simulationOrderRow.getCell("materialName").setValue((Object)(toEntryInfo.getMaterial() != null ? toEntryInfo.getMaterial().getName() : ""));
                    simulationOrderRow.getCell("materialModel").setValue((Object)(toEntryInfo.getMaterial() != null ? toEntryInfo.getMaterial().getModel() : ""));
                    simulationOrderRow.getCell("unit").setValue((Object)(toEntryInfo.getUnit() != null ? toEntryInfo.getUnit().getName() : ""));
                    simulationOrderRow.getCell("qty").setValue((Object)toEntryInfo.getQty());
                    simulationOrderRow.getCell("receiptPlanDate").setValue((Object)toEntryInfo.getReceiptPlanDate());
                    simulationOrderRow.getCell("remark").setValue((Object)toEntryInfo.getRemark());
                    this.setOrderOrStockRowPrecision(simulationOrderRow, toEntryInfo.getMaterial().getId().toString(), toEntryInfo.getUnit().getId().toString(), StockAllocationUtil.getSimulateQtyFieldNames());
                }
            }
        }
        if (stCollection != null && stCollection.size() > 0) {
            for (i = 0; i < stCollection.size(); ++i) {
                StockTransferBillInfo stInfo = stCollection.get(i);
                StockTransferBillEntryCollection stEntryCollection = stInfo.getEntry();
                if (stEntryCollection == null || stEntryCollection.size() <= 0) continue;
                for (j = 0; j < stEntryCollection.size(); ++j) {
                    StockTransferBillEntryInfo stEntryInfo = stEntryCollection.get(j);
                    simulationOrderRow = this.kdSimulationOrder.addRow();
                    simulationOrderRow.getCell("id").setValue((Object)stInfo.getId().toString());
                    simulationOrderRow.getCell("entryId").setValue((Object)stEntryInfo.getId().toString());
                    simulationOrderRow.getCell("sTDestBillType").setValue((Object)StockAllocationUtil.getResource("BIZ_STOCK_TRANSFER"));
                    simulationOrderRow.getCell("issueStorageOrgUnit").setValue((Object)(stInfo.getIssueStorageOrgUnit() != null ? stInfo.getIssueStorageOrgUnit().getName() : ""));
                    simulationOrderRow.getCell("number").setValue((Object)stInfo.getNumber());
                    simulationOrderRow.getCell("bizType").setValue((Object)(stInfo.getBizType() != null ? stInfo.getBizType().getName() : ""));
                    simulationOrderRow.getCell("trackNumber").setValue((Object)(stEntryInfo.getTrackNumber() != null ? stEntryInfo.getTrackNumber().getNumber() : ""));
                    simulationOrderRow.getCell("receiptAdminOrgUnit").setValue((Object)(stInfo.getReceiptAdminOrgUnit() != null ? stInfo.getReceiptAdminOrgUnit().getName() : ""));
                    simulationOrderRow.getCell("materialNumber").setValue((Object)(stEntryInfo.getMaterial() != null ? stEntryInfo.getMaterial().getNumber() : ""));
                    simulationOrderRow.getCell("materialName").setValue((Object)(stEntryInfo.getMaterial() != null ? stEntryInfo.getMaterial().getName() : ""));
                    simulationOrderRow.getCell("materialModel").setValue((Object)(stEntryInfo.getMaterial() != null ? stEntryInfo.getMaterial().getModel() : ""));
                    simulationOrderRow.getCell("unit").setValue((Object)(stEntryInfo.getUnit() != null ? stEntryInfo.getUnit().getName() : ""));
                    simulationOrderRow.getCell("qty").setValue((Object)stEntryInfo.getQty());
                    simulationOrderRow.getCell("receiptPlanDate").setValue((Object)stEntryInfo.getReceiptPlanDate());
                    simulationOrderRow.getCell("remark").setValue((Object)stEntryInfo.getRemark());
                    this.setOrderOrStockRowPrecision(simulationOrderRow, stEntryInfo.getMaterial().getId().toString(), stEntryInfo.getUnit().getId().toString(), StockAllocationUtil.getSimulateQtyFieldNames());
                }
            }
        }
        StockAllocationUtil.setMergeColumn(this.kdSimulationOrder);
    }

    private void setOrderOrStockRowPrecision(IRow Row, String materialId, String unitId, String[] qtyFieldNames) {
        String key = materialId + unitId;
        int precision = 0;
        if (this.precisionMap.containsKey(key)) {
            precision = (Integer)this.precisionMap.get(key);
        }
        SCMClientUtils.changeCellPrecision((IRow)Row, (String[])qtyFieldNames, (int)precision, (boolean)false, (boolean)false);
    }

    private void clearRow() {
        this.kdOrder.removeRows();
        this.kdStock.removeRows();
        this.kdSimulationOrder.removeRows();
    }

    private BigDecimal getTotalReceiptQtyBySASourceInfo(SASourceInfo saSourceInfo) {
        if (this.stRule.getSelectedItem() == SARuleEnum.SUIT) {
            return saSourceInfo.getMaxReceiptQty();
        }
        if (this.stRule.getSelectedItem() == SARuleEnum.REINFORCE) {
            return saSourceInfo.getMinReceiptQty();
        }
        return null;
    }

    private BigDecimal getReceiptQtyBySASourceInfo(ProductionOrderInfo ptOrderInfo, IRow currentRow) {
        BigDecimal qty = ptOrderInfo.getQty();
        if (this.stRule.getSelectedItem() == SARuleEnum.NORMAL) {
            return qty;
        }
        if (this.stRule.getSelectedItem() == SARuleEnum.SUIT) {
            BigDecimal subtrac = qty.subtract(new BigDecimal(currentRow.getCell("totalReceiptQty").getValue().toString()));
            return subtrac.signum() > 0 ? subtrac : ZERO;
        }
        if (this.stRule.getSelectedItem() == SARuleEnum.REINFORCE) {
            return qty;
        }
        return null;
    }

    private void remarkSimulateChanged(KDTEditEvent e) {
        block5: {
            StockTransferBillCollection stCollection;
            String billBizType;
            String entryId;
            String id;
            Object newValue;
            block6: {
                newValue = e.getValue();
                id = this.kdSimulationOrder.getCell(e.getRowIndex(), "id").getValue().toString();
                entryId = this.kdSimulationOrder.getCell(e.getRowIndex(), "entryId").getValue().toString();
                billBizType = this.kdSimulationOrder.getCell(e.getRowIndex(), "sTDestBillType").getValue().toString();
                TransferOrderBillCollection toCollection = (TransferOrderBillCollection)this.billMap.get("transferOrderBillCollection");
                stCollection = (StockTransferBillCollection)this.billMap.get("stockTransferBillCollection");
                if (!billBizType.equals(StockAllocationUtil.getResource("BIZ_TRANSFER_ORDER"))) break block6;
                if (toCollection == null || toCollection.size() <= 0) break block5;
                for (int i = 0; i < toCollection.size(); ++i) {
                    TransferOrderBillInfo toInfo = toCollection.get(i);
                    if (!toInfo.getId().toString().equals(id)) continue;
                    TransferOrderBillEntryCollection toEntryCollection = toInfo.getEntry();
                    if (toEntryCollection == null || toEntryCollection.size() <= 0) break block5;
                    for (int j = 0; j < toEntryCollection.size(); ++j) {
                        TransferOrderBillEntryInfo toEntryInfo = toEntryCollection.get(j);
                        if (!toEntryInfo.getId().toString().equals(entryId)) continue;
                        toEntryInfo.setRemark((String)newValue);
                        break block5;
                    }
                    break block5;
                }
                break block5;
            }
            if (billBizType.equals(StockAllocationUtil.getResource("BIZ_STOCK_TRANSFER")) && stCollection != null && stCollection.size() > 0) {
                for (int i = 0; i < stCollection.size(); ++i) {
                    StockTransferBillInfo stInfo = stCollection.get(i);
                    if (!stInfo.getId().toString().equals(id)) continue;
                    StockTransferBillEntryCollection stEntryCollection = stInfo.getEntry();
                    if (stEntryCollection == null || stEntryCollection.size() <= 0) break;
                    for (int j = 0; j < stEntryCollection.size(); ++j) {
                        StockTransferBillEntryInfo stEntryInfo = stEntryCollection.get(j);
                        if (!stEntryInfo.getId().toString().equals(entryId)) continue;
                        stEntryInfo.setRemark((String)newValue);
                        break block5;
                    }
                    break;
                }
            }
        }
    }

    private void simulateNumberReceipChanged(KDTEditEvent e) {
        block3: {
            StockTransferBillCollection stCollection;
            String billBizType;
            String id;
            String newValue;
            block5: {
                block4: {
                    newValue = (String)e.getValue();
                    String oldValue = (String)e.getOldValue();
                    if (newValue != null && !"".equals(newValue.trim())) break block4;
                    this.kdSimulationOrder.getCell(e.getRowIndex(), e.getColIndex()).setValue((Object)oldValue);
                    break block3;
                }
                id = this.kdSimulationOrder.getCell(e.getRowIndex(), "id").getValue().toString();
                billBizType = this.kdSimulationOrder.getCell(e.getRowIndex(), "sTDestBillType").getValue().toString();
                TransferOrderBillCollection toCollection = (TransferOrderBillCollection)this.billMap.get("transferOrderBillCollection");
                stCollection = (StockTransferBillCollection)this.billMap.get("stockTransferBillCollection");
                if (!billBizType.equals(StockAllocationUtil.getResource("BIZ_TRANSFER_ORDER"))) break block5;
                if (toCollection == null || toCollection.size() <= 0) break block3;
                for (int i = 0; i < toCollection.size(); ++i) {
                    TransferOrderBillInfo toInfo = toCollection.get(i);
                    if (!toInfo.getId().toString().equals(id)) continue;
                    toInfo.setNumber(newValue);
                    break block3;
                }
                break block3;
            }
            if (billBizType.equals(StockAllocationUtil.getResource("BIZ_STOCK_TRANSFER")) && stCollection != null && stCollection.size() > 0) {
                for (int i = 0; i < stCollection.size(); ++i) {
                    StockTransferBillInfo stInfo = stCollection.get(i);
                    if (!stInfo.getId().toString().equals(id)) continue;
                    stInfo.setNumber(newValue);
                    break;
                }
            }
        }
    }

    private ProductionOrderStockEntryCollection sortOrderCollectionByMaterial(ProductionOrderStockEntryCollection collection) {
        ArrayList<ProductionOrderStockEntryInfo> sortList = new ArrayList<ProductionOrderStockEntryInfo>();
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                sortList.add(collection.get(i));
            }
        }
        Collections.sort(sortList, (Comparator)new Comparator(){

            public int compare(Object arg0, Object arg1) {
                ProductionOrderStockEntryInfo info1 = (ProductionOrderStockEntryInfo)arg0;
                ProductionOrderStockEntryInfo info2 = (ProductionOrderStockEntryInfo)arg1;
                if (info1.getMaterial().compareTo((Object)info2.getMaterial()) == 0) {
                    return 0;
                }
                if (info1.getMaterial().compareTo((Object)info2.getMaterial()) < 0) {
                    return -1;
                }
                if (info1.getMaterial().compareTo((Object)info2.getMaterial()) > 0) {
                    return 1;
                }
                return 0;
            }
        });
        ProductionOrderStockEntryCollection relustCollection = new ProductionOrderStockEntryCollection();
        for (int i = 0; i < sortList.size(); ++i) {
            relustCollection.add((ProductionOrderStockEntryInfo)sortList.get(i));
        }
        return relustCollection;
    }
}

