/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.control.BizTypeEnum;
import com.kingdee.eas.mm.control.client.AbstractStockAllocationFilterUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class StockAllocationFilterUI
extends AbstractStockAllocationFilterUI {
    private static final long serialVersionUID = -786524279346345109L;
    private static final Logger logger = CoreUIObject.getLogger(StockAllocationFilterUI.class);
    private StorageOrgUnitInfo storageOrgUnitInfo;

    public StockAllocationFilterUI() throws Exception {
    }

    public StockAllocationFilterUI(Object storageOrgUnitInfo) throws Exception {
        this.storageOrgUnitInfo = (StorageOrgUnitInfo)storageOrgUnitInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setNumber(this.prmtnumberFrom, this.storageOrgUnitInfo != null ? this.storageOrgUnitInfo.getId().toString() : "");
        this.setNumber(this.prmtnumberTo, this.storageOrgUnitInfo != null ? this.storageOrgUnitInfo.getId().toString() : "");
        this.setProductline(this.prmtproductLine, this.storageOrgUnitInfo != null ? this.storageOrgUnitInfo.getId().toString() : "");
        this.setMaterialFilter(this.promMaterialNumFrom);
        this.setMaterialFilter(this.promMaterialNumTo);
        Timestamp timeStart = SCMUtils.getSCMQueryTime(null, (String)"startDate");
        Timestamp timeEnd = SCMUtils.getSCMQueryTime(null, (String)"endDate");
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, StockAllocationFilterUI.getResource("Stroage_IsNotNull")));
        mainOrgElement.setDefaultValue((Object)this.storageOrgUnitInfo);
        elements.add((FilterElement)new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit));
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.prmtnumberFrom, (Component)this.prmtnumberTo));
        elements.add((FilterElement)new RangeFilterElement("material.number", (Component)this.promMaterialNumFrom, (Component)this.promMaterialNumTo));
        elements.add((FilterElement)new SingleFilterElement("productLine.number", (Component)this.prmtproductLine));
        elements.add((FilterElement)new SingleFilterElement("workShop.number", (Component)this.prmtworkShop));
        RangeFilterElement elementStartDate = new RangeFilterElement("startDate", (Component)this.pkstartDateFrom, (Component)this.pkstartDateTo);
        elementStartDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elementStartDate.setDefaultValue((Object)new Timestamp[]{timeStart, timeEnd});
        elements.add((FilterElement)elementStartDate);
        RangeFilterElement elementEndDate = new RangeFilterElement("endDate", (Component)this.pkendDateFrom, (Component)this.pkendDateTo);
        elementEndDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elementEndDate.setDefaultValue((Object)new Timestamp[]{timeStart, timeEnd});
        elements.add((FilterElement)elementEndDate);
        elements.add((FilterElement)new RangeFilterElement("trackNumber.number", (Component)this.prmtTrackNumberFrom, (Component)this.prmtTrackNumberTo));
        elements.add((FilterElement)new RangeFilterElement("lotNo", (Component)this.txtlotNoFrom, (Component)this.txtlotNoTo));
        elements.add((FilterElement)new RangeFilterElement("sourceBillNumber", (Component)this.txtsourceBillNumberFrom, (Component)this.txtsourceBillNumberTo));
        RangeFilterElement elementBizDate = new RangeFilterElement("bizDate", (Component)this.pkBizDateFrom, (Component)this.pkBizDateTo);
        elementBizDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elementBizDate.setDefaultValue((Object)new Timestamp[]{timeStart, timeEnd});
        elements.add((FilterElement)elementBizDate);
        this.cmbbaseStatus.removeAllItems();
        this.cmbbaseStatus.addItem((Object)BillBaseStatusEnum.NULL);
        this.cmbbaseStatus.addItem((Object)BillBaseStatusEnum.AUDITED);
        this.cmbbaseStatus.addItem((Object)BillBaseStatusEnum.RELEASED);
        this.cmbbaseStatus.addItem((Object)BillBaseStatusEnum.COMPLETE);
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.cmbbaseStatus, (Object)BillBaseStatusEnum.NULL));
        elements.add((FilterElement)new SingleFilterElement("mmBizType", (Component)this.cmbBizType, (Object)BizTypeEnum.all));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.promMaterialNumFrom, this.promMaterialNumTo, this.prmtproductLine, this.prmtworkShop});
    }

    private void setMaterialFilter(KDBizPromptBox prmtMaterial) {
        String queryInfo = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.f7Manager.registerBizMaterialF7(prmtMaterial, null, queryInfo, (OrgUnitInfo)this.storageOrgUnitInfo, OrgType.Storage, false, true);
        prmtMaterial.setDisplayFormat("$number$");
        EntityViewInfo eview = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)new Integer(1), CompareType.EQUALS));
        if (this.storageOrgUnitInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)this.storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        eview.setFilter(filter);
        prmtMaterial.setEntityViewInfo(eview);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected void setNumber(KDBizPromptBox kDBizBillNum, String storageId) {
        kDBizBillNum.setQueryInfo("com.kingdee.eas.mm.control.app.F7ProductionOrderQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageId, CompareType.EQUALS));
        HashSet<Integer> baseStatusSet = new HashSet<Integer>();
        baseStatusSet.add(new Integer(4));
        baseStatusSet.add(new Integer(5));
        baseStatusSet.add(new Integer(8));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", baseStatusSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        kDBizBillNum.setEntityViewInfo(viewInfo);
        kDBizBillNum.setVisible(true);
        kDBizBillNum.setEditFormat("$number$");
        kDBizBillNum.setDisplayFormat("$number$");
        kDBizBillNum.setCommitFormat("$number$");
    }

    protected void setProductline(KDBizPromptBox kDBizProductline, String storageId) {
        kDBizProductline.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7ProductLineQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageId, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        kDBizProductline.setEntityViewInfo(viewInfo);
        kDBizProductline.setVisible(true);
        kDBizProductline.setEditFormat("$number$");
        kDBizProductline.setDisplayFormat("$name$");
        kDBizProductline.setCommitFormat("$number$");
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.control.StockAllocationResource", (String)strKey);
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = super.getFilterInfo();
        FilterItemCollection items = this.filterInfo.getFilterItems();
        this.filterInfo.setMaskString(null);
        if (this.isOutSource.isSelected()) {
            items.add(new FilterItemInfo("outSourceFlag", (Object)new Integer(1), CompareType.EQUALS));
        } else {
            items.add(new FilterItemInfo("outSourceFlag", (Object)new Integer(0), CompareType.EQUALS));
        }
        HashSet<String> bsSet = new HashSet<String>();
        bsSet.add(String.valueOf(4));
        bsSet.add(String.valueOf(5));
        bsSet.add(String.valueOf(8));
        if (bsSet.size() > 0) {
            this.filterInfo.setMaskString(null);
            items.add(new FilterItemInfo("baseStatus", bsSet, CompareType.INCLUDE));
        }
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        FilterInfo filterInfo;
        super.loadData(entityViewInfo);
        if (entityViewInfo != null && (filterInfo = entityViewInfo.getFilter()).getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                if (!"outSourceFlag".equals(filterItemInfo.getPropertyName())) continue;
                int bss = (Integer)filterItemInfo.getCompareValue();
                if (bss == 1) {
                    this.isOutSource.setSelected(true);
                    continue;
                }
                this.isOutSource.setSelected(false);
            }
        }
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.prmtStorageOrgUnit.setValue((Object)this.storageOrgUnitInfo);
        this.isOutSource.setSelected(false);
    }
}

