/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.control.SABackFlashEnum;
import com.kingdee.eas.mm.control.SASumEnum;
import com.kingdee.eas.mm.control.SATransactionEnum;
import com.kingdee.eas.mm.control.client.AbstractStockAllocationParamUI;
import com.kingdee.eas.mm.control.client.util.StockAllocationUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class StockAllocationParamUI
extends AbstractStockAllocationParamUI {
    private static final long serialVersionUID = 5395124779157574801L;
    private static final Logger logger = CoreUIObject.getLogger(StockAllocationParamUI.class);
    private static final String CLEAR_ITEM = "ClearItem";
    private ItemListener isEnableQtyListener = null;
    private StorageOrgUnitInfo storageOrgUnitInfo;
    private Object transactionType;

    public StockAllocationParamUI() throws Exception {
    }

    public StockAllocationParamUI(Object transactionType, StorageOrgUnitInfo storageOrgUnitInfo) throws Exception {
        this.storageOrgUnitInfo = storageOrgUnitInfo;
        this.transactionType = transactionType;
    }

    public boolean verify() {
        if (super.verify()) {
            Date startDemandTime = (Date)this.dateRequiredFrom.getValue();
            Date endDemandTime = (Date)this.dateRequiredTo.getValue();
            if (endDemandTime != null && startDemandTime != null && startDemandTime.compareTo(endDemandTime) > 0) {
                MsgBox.showInfo((String)SCMClientUtils.getResource((String)"CompareDate"));
                return false;
            }
            if (!(!this.isEnableQty.isSelected() || this.baseStatusSubmit.isSelected() || this.baseStatusAudit.isSelected() || this.baseStatusReleased.isSelected() || this.baseStatusComplete.isSelected())) {
                MsgBox.showInfo((String)StockAllocationUtil.getResource("IsEnableQty"));
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.backFlush.getActionMap().remove(CLEAR_ITEM);
        this.sumWay.getActionMap().remove(CLEAR_ITEM);
        this.initMaterialF7(this.prmtMaterialFrom);
        this.initMaterialF7(this.prmtMaterialTo);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement materialNumFromValue = new SingleFilterElement("materialNumFrom", (Component)this.prmtMaterialFrom);
        elements.add((FilterElement)materialNumFromValue);
        SingleFilterElement materialNumToValue = new SingleFilterElement("materialNumTo", (Component)this.prmtMaterialTo);
        elements.add((FilterElement)materialNumToValue);
        SingleFilterElement pickingWarehouseValue = new SingleFilterElement("pickingWarehouseNum", (Component)this.prmtPickingWarehouse);
        EntityViewInfo warehouseEview = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.storageOrgUnitInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)this.storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        warehouseEview.setFilter(filter);
        this.prmtPickingWarehouse.setEntityViewInfo(warehouseEview);
        elements.add((FilterElement)pickingWarehouseValue);
        SingleFilterElement exportStorageUnitValue = new SingleFilterElement("exportStorageUnitNum", (Component)this.prmtExportStorageUnit);
        this.addEntityViewForExportWarehouse();
        elements.add((FilterElement)exportStorageUnitValue);
        SingleFilterElement exportWarehouseValue = new SingleFilterElement("exportWarehouseNum", (Component)this.prmtExportWarehouse);
        elements.add((FilterElement)exportWarehouseValue);
        SingleFilterElement backFlushValue = new SingleFilterElement("backFlushValue", (Component)this.backFlush);
        elements.add((FilterElement)backFlushValue);
        backFlushValue.setDefaultValue((Object)SABackFlashEnum.ALL);
        if (SATransactionEnum.SPECIFIEDORDER.equals(this.transactionType)) {
            SingleFilterElement sumWayValue = new SingleFilterElement("sumWayValue", (Component)this.sumWay);
            elements.add((FilterElement)sumWayValue);
            this.sumWay.setEnabled(true);
            sumWayValue.setDefaultValue((Object)SASumEnum.NO_SUM);
            SingleFilterElement dateRequiredFromValue = new SingleFilterElement("dateRequiredFrom", (Component)this.dateRequiredFrom);
            elements.add((FilterElement)dateRequiredFromValue);
            SingleFilterElement dateRequiredToValue = new SingleFilterElement("dateRequiredTo", (Component)this.dateRequiredTo);
            elements.add((FilterElement)dateRequiredToValue);
            SingleFilterElement isExportBatchValue = new SingleFilterElement("isExportBatch", (Component)this.isExportBatch);
            isExportBatchValue.setDefaultValue((Object)new Boolean(false));
            elements.add((FilterElement)isExportBatchValue);
            SingleFilterElement isEnableQtyValue = new SingleFilterElement("isEnableQty", (Component)this.isEnableQty);
            isEnableQtyValue.setDefaultValue((Object)new Boolean(false));
            elements.add((FilterElement)isEnableQtyValue);
            this.baseStatusSubmit.setSelected(false);
            this.baseStatusSubmit.setEnabled(false);
            this.baseStatusAudit.setSelected(false);
            this.baseStatusAudit.setEnabled(false);
            this.baseStatusReleased.setSelected(false);
            this.baseStatusReleased.setEnabled(false);
            this.baseStatusComplete.setSelected(false);
            this.baseStatusComplete.setEnabled(false);
        } else {
            SingleFilterElement sumWayValue = new SingleFilterElement("sumWayValue", (Component)this.sumWay);
            elements.add((FilterElement)sumWayValue);
            this.sumWay.setEnabled(false);
            sumWayValue.setDefaultValue((Object)SASumEnum.SUM_BY_MATERIAL);
            this.dateRequiredFrom.setValue(null);
            this.dateRequiredFrom.setEnabled(false);
            SingleFilterElement dateRequiredToValue = new SingleFilterElement("dateRequiredTo", (Component)this.dateRequiredTo);
            elements.add((FilterElement)dateRequiredToValue);
            SingleFilterElement isExportBatchValue = new SingleFilterElement("isExportBatch", (Component)this.isExportBatch);
            isExportBatchValue.setDefaultValue((Object)new Boolean(true));
            elements.add((FilterElement)isExportBatchValue);
            SingleFilterElement isEnableQtyValue = new SingleFilterElement("isEnableQty", (Component)this.isEnableQty);
            isEnableQtyValue.setDefaultValue((Object)new Boolean(true));
            elements.add((FilterElement)isEnableQtyValue);
            this.baseStatusAudit.setSelected(true);
            this.baseStatusReleased.setSelected(true);
        }
        this.addListener();
        this.getFilterManager().setElement((FilterElement)elements);
    }

    protected void initListener() {
        super.initListener();
    }

    private void addListener() {
        this.isEnableQtyListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int state = e.getStateChange();
                if (state == 1) {
                    if (SATransactionEnum.SPECIFIEDORDER.equals(StockAllocationParamUI.this.transactionType) && MsgBox.showConfirm2((String)StockAllocationUtil.getResource("SUBTACTQTY_REALITYAPPDATA")) != 0) {
                        StockAllocationParamUI.this.isEnableQty.setSelected(false);
                        SysUtil.abort();
                    }
                    StockAllocationParamUI.this.baseStatusSubmit.setSelected(false);
                    StockAllocationParamUI.this.baseStatusSubmit.setEnabled(true);
                    StockAllocationParamUI.this.baseStatusAudit.setSelected(true);
                    StockAllocationParamUI.this.baseStatusAudit.setEnabled(true);
                    StockAllocationParamUI.this.baseStatusReleased.setSelected(true);
                    StockAllocationParamUI.this.baseStatusReleased.setEnabled(true);
                    StockAllocationParamUI.this.baseStatusComplete.setSelected(false);
                    StockAllocationParamUI.this.baseStatusComplete.setEnabled(true);
                } else {
                    StockAllocationParamUI.this.baseStatusSubmit.setSelected(false);
                    StockAllocationParamUI.this.baseStatusSubmit.setEnabled(false);
                    StockAllocationParamUI.this.baseStatusAudit.setSelected(false);
                    StockAllocationParamUI.this.baseStatusAudit.setEnabled(false);
                    StockAllocationParamUI.this.baseStatusReleased.setSelected(false);
                    StockAllocationParamUI.this.baseStatusReleased.setEnabled(false);
                    StockAllocationParamUI.this.baseStatusComplete.setSelected(false);
                    StockAllocationParamUI.this.baseStatusComplete.setEnabled(false);
                }
            }
        };
        this.isEnableQty.addItemListener(this.isEnableQtyListener);
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = super.getFilterInfo();
        FilterItemCollection items = this.filterInfo.getFilterItems();
        HashSet<String> bsSet = new HashSet<String>();
        if (this.baseStatusSubmit.isSelected()) {
            bsSet.add(String.valueOf(2));
        }
        if (this.baseStatusAudit.isSelected()) {
            bsSet.add(String.valueOf(4));
        }
        if (this.baseStatusReleased.isSelected()) {
            bsSet.add(String.valueOf(5));
        }
        if (this.baseStatusComplete.isSelected()) {
            bsSet.add(String.valueOf(8));
        }
        if (bsSet.size() > 0) {
            this.filterInfo.setMaskString(null);
            items.add(new FilterItemInfo("baseStatus", bsSet, CompareType.INCLUDE));
        }
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        FilterInfo filterInfo;
        if (null != this.isEnableQtyListener) {
            this.isEnableQty.removeItemListener(this.isEnableQtyListener);
        }
        super.loadData(entityViewInfo);
        if (entityViewInfo != null && (filterInfo = entityViewInfo.getFilter()).getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                if ("baseStatus".equals(filterItemInfo.getPropertyName())) {
                    Object[] bss = ((HashSet)filterItemInfo.getCompareValue()).toArray();
                    if (bss.length <= 0) continue;
                    for (int j = 0; j < bss.length; ++j) {
                        if (String.valueOf(2).toString().equals(bss[j])) {
                            this.baseStatusSubmit.setSelected(true);
                        }
                        if (String.valueOf(4).toString().equals(bss[j])) {
                            this.baseStatusAudit.setSelected(true);
                        }
                        if (String.valueOf(5).equals(bss[j])) {
                            this.baseStatusReleased.setSelected(true);
                        }
                        if (!String.valueOf(8).equals(bss[j])) continue;
                        this.baseStatusComplete.setSelected(true);
                    }
                    continue;
                }
                if (!"isEnableQty".equals(filterItemInfo.getPropertyName())) continue;
                if ("true".equals(filterItemInfo.getCompareValue().toString())) {
                    this.baseStatusSubmit.setEnabled(true);
                    this.baseStatusAudit.setEnabled(true);
                    this.baseStatusReleased.setEnabled(true);
                    this.baseStatusComplete.setEnabled(true);
                    continue;
                }
                this.baseStatusSubmit.setEnabled(false);
                this.baseStatusAudit.setEnabled(false);
                this.baseStatusReleased.setEnabled(false);
                this.baseStatusComplete.setEnabled(false);
            }
        }
        this.addListener();
    }

    public void clear() {
        super.clear();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void initMaterialF7(KDBizPromptBox prmtMaterial) throws Exception {
        String queryInfo = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.f7Manager.registerBizMaterialF7(prmtMaterial, null, queryInfo, (OrgUnitInfo)this.storageOrgUnitInfo, OrgType.Storage, false, true);
        prmtMaterial.setDisplayFormat("$name$");
        EntityViewInfo eview = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)new Integer(1), CompareType.EQUALS));
        if (this.storageOrgUnitInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)this.storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        eview.setFilter(filter);
        prmtMaterial.setEntityViewInfo(eview);
    }

    private void addEntityViewForExportWarehouse() {
        this.prmtExportWarehouse.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                EntityViewInfo exportWView = new EntityViewInfo();
                FilterInfo exportWfilter = new FilterInfo();
                if (StockAllocationParamUI.this.prmtExportStorageUnit.getValue() != null) {
                    Object[] storages = (Object[])StockAllocationParamUI.this.prmtExportStorageUnit.getValue();
                    HashSet<String> storageIds = new HashSet<String>();
                    for (int i = 0; i < storages.length; ++i) {
                        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)storages[i];
                        storageIds.add(storage.getId().toString());
                    }
                    exportWfilter.getFilterItems().add(new FilterItemInfo("storageOrg.id", storageIds, CompareType.INCLUDE));
                }
                exportWView.setFilter(exportWfilter);
                StockAllocationParamUI.this.prmtExportWarehouse.setEntityViewInfo(exportWView);
            }
        });
        this.prmtExportStorageUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                boolean isDiffrent;
                Object oldStorage = e.getOldValue();
                Object newStorage = e.getNewValue();
                if (newStorage != null && (isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldStorage, (Object)newStorage))) {
                    StockAllocationParamUI.this.prmtExportWarehouse.setValue(null);
                }
            }
        });
    }
}

