/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.control.IStockAllocationFacade;
import com.kingdee.eas.mm.control.ProductionOrderCollection;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.SARuleEnum;
import com.kingdee.eas.mm.control.StockAllocationFacadeFactory;
import com.kingdee.eas.mm.control.client.AbstractStockAllocationSourceUI;
import com.kingdee.eas.mm.control.client.StockAllocationFilterUI;
import com.kingdee.eas.mm.control.client.util.StockAllocationClientCommon;
import com.kingdee.eas.mm.control.client.util.StockAllocationUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class StockAllocationSourceUI
extends AbstractStockAllocationSourceUI {
    private static final long serialVersionUID = 8518140023651407207L;
    private static final Logger logger = CoreUIObject.getLogger(StockAllocationSourceUI.class);
    private StorageOrgUnitInfo storagetOrgUnitInfo;
    protected static final BigDecimal ZERO = SysConstant.BIGZERO;
    private static final String ID = "id";
    private static final String STORAGEORGUNIT = "storageOrgUnit";
    private static final String BILLTYPE = "billType";
    private static final String NUMBER = "number";
    private static final String BIZTYPE = "bizType";
    private static final String PRODUCTLINE = "productLine";
    private static final String MATERIAL_NUMBER = "material.number";
    private static final String MATERIAL_NAME = "material.name";
    private static final String MATERIAL_MODEL = "material.model";
    private static final String TRACKNUMBER = "trackNumber";
    private static final String FORMULA = "formula";
    private static final String BOM = "bom";
    private static final String QTY = "qty";
    private static final String UNIT = "unit";
    private static final String STARTDATE = "startDate";
    private static final String EXPECTENDDATE = "expectEndDate";
    private static final String[] KDT_DATETIMES = new String[]{"startDate", "expectEndDate"};
    private SARuleEnum saRuleSelEnum;
    private ProductionOrderCollection cocn;
    private List resultList;

    public void setSaRuleSelEnum(SARuleEnum saRuleSelEnum) {
        this.saRuleSelEnum = saRuleSelEnum;
    }

    public SARuleEnum getSaRuleSelEnum() {
        return this.saRuleSelEnum;
    }

    public void setCocn(ProductionOrderCollection cocn) {
        this.cocn = cocn;
    }

    public ProductionOrderCollection getCocn() {
        return this.cocn;
    }

    public void setResultList(List resultList) {
        this.resultList = resultList;
    }

    public List getResultList() {
        return this.resultList;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtable.checkParsed();
        this.kdtable.getSelectManager().setSelectMode(10);
        this.btnOK.setEnabled(false);
        this.btnCancel.setEnabled(true);
        this.kdtable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int[] index = KDTableUtil.getSelectedRows((KDTable)StockAllocationSourceUI.this.kdtable);
                if (index != null && index.length > 0) {
                    StockAllocationSourceUI.this.btnOK.setEnabled(true);
                }
            }
        });
        Map uictx = this.getUIContext();
        this.storagetOrgUnitInfo = (StorageOrgUnitInfo)uictx.get("storageUnitInfo");
        if (uictx.get("saRuleSelEnum") != null) {
            this.setSaRuleSelEnum((SARuleEnum)((Object)uictx.get("saRuleSelEnum")));
        }
        if (uictx.get("pococn") != null) {
            ProductionOrderCollection pcocn = (ProductionOrderCollection)((Object)uictx.get("pococn"));
            this.setCocn(pcocn);
            this.bindingData();
        }
        EditTableUtil.formatColDateTime((KDTable)this.kdtable, (String[])KDT_DATETIMES);
    }

    private void bindingData() throws EASBizException, BOSException {
        this.kdtable.removeRows();
        if (this.getCocn() != null && this.getCocn().size() > 0) {
            ProductionOrderCollection ptll = this.getCocn();
            IStockAllocationFacade facade = StockAllocationFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            Map precisionMap = facade.getStockDataPrecision(ptll);
            for (int i = 0; i < this.cocn.size(); ++i) {
                ProductionOrderInfo ptinfo = ptll.get(i);
                if (ptinfo.getStockEntry() == null || ptinfo.getStockEntry().size() == 0) continue;
                IRow row = this.kdtable.addRow();
                row.getCell(ID).setValue((Object)ptinfo.getId());
                row.getCell(STORAGEORGUNIT).setValue((Object)(ptinfo.getStorageOrgUnit() != null ? ptinfo.getStorageOrgUnit().getName() : ""));
                row.getCell(BILLTYPE).setValue((Object)(ptinfo.getBillType() != null ? ptinfo.getBillType().getName() : ""));
                row.getCell(NUMBER).setValue((Object)ptinfo.getNumber());
                row.getCell(BIZTYPE).setValue((Object)(ptinfo.getMmBizType() != null ? ptinfo.getMmBizType().getAlias() : ""));
                row.getCell(PRODUCTLINE).setValue((Object)(ptinfo.getProductLine() != null ? ptinfo.getProductLine().getName() : ""));
                row.getCell(MATERIAL_NUMBER).setValue((Object)(ptinfo.getMaterial() != null ? ptinfo.getMaterial().getNumber() : ""));
                row.getCell(MATERIAL_NAME).setValue((Object)(ptinfo.getMaterial() != null ? ptinfo.getMaterial().getName() : ""));
                row.getCell(MATERIAL_MODEL).setValue((Object)(ptinfo.getMaterial() != null ? ptinfo.getMaterial().getModel() : ""));
                row.getCell(TRACKNUMBER).setValue((Object)(ptinfo.getTrackNumber() != null ? ptinfo.getTrackNumber().getNumber() : ""));
                row.getCell(FORMULA).setValue((Object)(ptinfo.getFormula() != null ? ptinfo.getFormula().getName() : ""));
                row.getCell(BOM).setValue((Object)(ptinfo.getBom() != null ? ptinfo.getBom().getName() : ""));
                row.getCell(QTY).setValue((Object)ptinfo.getQty());
                row.getCell(UNIT).setValue((Object)ptinfo.getUnit().getName());
                row.getCell(STARTDATE).setValue((Object)ptinfo.getStartDate());
                row.getCell(EXPECTENDDATE).setValue((Object)ptinfo.getExpectEndDate());
                this.setOrderOrStockRowPrecision(row, ptinfo.getMaterial().getId().toString(), ptinfo.getUnit().getId().toString(), precisionMap);
            }
        } else {
            this.btnOK.setEnabled(false);
        }
    }

    private void setOrderOrStockRowPrecision(IRow Row, String materialId, String unitId, Map precisionMap) {
        String key = materialId + unitId;
        int precision = 0;
        if (precisionMap.containsKey(key)) {
            precision = (Integer)precisionMap.get(key);
        }
        String[] aaa = new String[]{QTY};
        SCMClientUtils.changeCellPrecision((IRow)Row, (String[])aaa, (int)precision, (boolean)false, (boolean)false);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        int saRule = this.saRuleSelEnum.getValue();
        int[] index = KDTableUtil.getSelectedRows((KDTable)this.kdtable);
        ArrayList<String> orderIdList = new ArrayList<String>();
        for (int i = 0; i < index.length; ++i) {
            orderIdList.add(this.kdtable.getRow(index[i]).getCell(ID).getValue().toString());
        }
        IStockAllocationFacade facade = StockAllocationFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        this.setResultList(facade.sASourceList(this.storagetOrgUnitInfo, orderIdList, saRule));
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryDialog dialog = this.initCommonQueryDialog();
        dialog.show();
        EntityViewInfo entityViewInfo = dialog.getEntityViewInfoResult();
        if (entityViewInfo.getFilter() == null) {
            this.abort();
        }
        FilterInfo filter1 = entityViewInfo.getFilter();
        FilterItemCollection items = filter1.getFilterItems();
        for (int index = items.size() - 1; index >= 0; --index) {
            FilterItemInfo filterInfo = items.get(index);
            if (!filterInfo.getPropertyName().equals("storageOrgUnit.number") || filterInfo.getCompareValue().toString().equals(this.storagetOrgUnitInfo.getNumber())) continue;
            MsgBox.showInfo((String)StockAllocationUtil.getResource("STORAGE_ORG_DIFFERENT"));
            SysUtil.abort();
        }
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> baseStatusSet = new HashSet<Integer>();
        baseStatusSet.add(new Integer(4));
        baseStatusSet.add(new Integer(5));
        baseStatusSet.add(new Integer(8));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", baseStatusSet, CompareType.INCLUDE));
        entityViewInfo.getFilter().mergeFilter(filter, "and");
        entityViewInfo.setSelector(StockAllocationUtil.getSelectors());
        ProductionOrderCollection pococn = ProductionOrderFactory.getRemoteInstance().getProductionOrderCollection(entityViewInfo);
        StockAllocationClientCommon stockAllocationClientCommon = new StockAllocationClientCommon();
        ProductionOrderCollection anotherCon = stockAllocationClientCommon.filterPOCollection(pococn);
        this.setCocn(anotherCon);
        this.bindingData();
    }

    protected CommonQueryDialog initCommonQueryDialog() throws Exception {
        CommonQueryDialog commonQueryDialog = this.initMyCommonQueryDialog();
        commonQueryDialog.setWidth(450);
        commonQueryDialog.setHeight(320);
        CustomerQueryPanel conditionPanel = this.getFilterUI();
        try {
            SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(conditionPanel, this.getMainBizOrgType());
            commonQueryDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
            commonQueryDialog.setProcessor((IProcessor)new SCMCommonProcessor());
            commonQueryDialog.addUserPanel((KDPanel)conditionPanel);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return commonQueryDialog;
    }

    protected CommonQueryDialog initMyCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        MetaDataPK mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.base.message", (String)"MsgQuery");
        dialog.setQueryObjectPK((IMetaDataPK)mainQueryPK);
        dialog.setParentUIClassName("com.kingdee.eas.mm.control.client.StockAllocationEditUI");
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}-{1}");
        String title = format.format(new Object[]{StockAllocationUtil.getResource("PRODUCTIONTITLE"), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter")});
        dialog.setTitle(title);
        dialog.setTitle(title);
        dialog.setShowSorter(false);
        dialog.setShowFilter(false);
        return dialog;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        StockAllocationFilterUI conditionPanel = new StockAllocationFilterUI(this.storagetOrgUnitInfo);
        return conditionPanel;
    }
}

