/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BooleanAllEnum;
import com.kingdee.eas.mm.basedata.ProductLineFactory;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryFactory;
import com.kingdee.eas.mm.control.client.AbstractStockConditionGatherFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class StockConditionGatherFilterUI
extends AbstractStockConditionGatherFilterUI {
    protected F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 1);
    private static final Logger logger = CoreUIObject.getLogger(StockConditionGatherFilterUI.class);
    private DataChangeListener storageOrgUnitChanged = null;
    private DataChangeListener defaultWareHouseChanged = null;
    private DataChangeListener moveOutStorageOrgUnitChanged = null;
    private DataChangeListener workShopChanged = null;
    public static final String RES_STOCKGATHER = "com.kingdee.eas.mm.control.StockGatherResource";
    private Map productLineMap = null;
    private Map workShopMap = null;
    private Map wareHouseMap = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_flow_stockAllocation");
        StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_stockGatherMove_conditionGather");
        this.prmtStorageOrgUnit.setValue((Object)storageOrgInfo);
        this.prmtWorkShop.setValue(null);
        this.prmtProductLine.setValue(null);
        this.prmMaterialNumFrom.setText(null);
        this.prmtMaterialNumTo.setText(null);
        this.pkstartDateFrom.setValue(null);
        this.pkstartDateTo.setValue(null);
        this.pkendDateFrom.setValue(null);
        this.pkendDateTo.setValue(null);
        this.prmtProductionOrderFrom.setText(null);
        this.prmtProductionOrderTo.setText(null);
        this.pkMoveInPlanDate.setValue(null);
        this.prmtDefaultWareHouse.setValue(null);
        this.prmtMoveStorageOrgUnit.setValue(null);
        this.prmtMoveOutWareHouse.setValue(null);
        this.prmtLocation.setValue(null);
        this.cmbIsBackFlush.setSelectedItem((Object)BooleanAllEnum.All);
        this.isConsiderLocation.setSelected(false);
    }

    public FilterInfo getFilterInfo() {
        WarehouseInfo whi;
        int i;
        HashSet<String> set;
        this.filterInfo.getFilterItems().clear();
        FilterItemCollection items = this.filterInfo.getFilterItems();
        this.filterInfo.setMaskString(null);
        if (this.prmtStorageOrgUnit.getValue() != null && this.prmtStorageOrgUnit.getText() != null && this.prmtStorageOrgUnit.getText().length() > 0) {
            items.add(new FilterItemInfo("storageOrgUnitID", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmtWorkShop.getValue() != null && this.prmtWorkShop.getText() != null && this.prmtWorkShop.getText().length() > 0) {
            set = new HashSet<String>();
            for (i = 0; i < ((Object[])this.prmtWorkShop.getValue()).length; ++i) {
                AdminOrgUnitInfo workShop = (AdminOrgUnitInfo)((Object[])this.prmtWorkShop.getValue())[i];
                set.add(workShop.getId().toString());
            }
            items.add(new FilterItemInfo("workShopID", set, CompareType.INCLUDE));
        }
        if (this.prmtProductLine.getValue() != null && this.prmtProductLine.getText() != null && this.prmtProductLine.getText().length() > 0) {
            set = new HashSet();
            for (i = 0; i < ((Object[])this.prmtProductLine.getValue()).length; ++i) {
                ProductLineInfo productLine = (ProductLineInfo)((Object[])this.prmtProductLine.getValue())[i];
                set.add(productLine.getId().toString());
            }
            items.add(new FilterItemInfo("productLineID", set, CompareType.INCLUDE));
        }
        if (this.prmMaterialNumFrom.getText() != null && this.prmMaterialNumFrom.getText().length() > 0) {
            items.add(new FilterItemInfo("materialNumFrom", (Object)this.prmMaterialNumFrom.getText().toString().trim(), CompareType.GREATER_EQUALS));
        }
        if (this.prmtMaterialNumTo.getText() != null && this.prmtMaterialNumTo.getText().length() > 0) {
            items.add(new FilterItemInfo("materialNumTo", (Object)this.prmtMaterialNumTo.getText().toString().trim(), CompareType.LESS_EQUALS));
        }
        if (this.pkstartDateFrom.getValue() != null && this.pkstartDateFrom.getText() != null && this.pkstartDateFrom.getText().length() > 0) {
            items.add(new FilterItemInfo("startDateFrom", (Object)new Timestamp(((Date)this.pkstartDateFrom.getValue()).getTime()), CompareType.GREATER_EQUALS));
        }
        if (this.pkstartDateTo.getValue() != null && this.pkstartDateTo.getText() != null && this.pkstartDateTo.getText().length() > 0) {
            items.add(new FilterItemInfo("startDateTo", (Object)new Timestamp(((Date)this.pkstartDateTo.getValue()).getTime()), CompareType.LESS_EQUALS));
        }
        if (this.pkendDateFrom.getValue() != null && this.pkendDateFrom.getText() != null && this.pkendDateFrom.getText().length() > 0) {
            items.add(new FilterItemInfo("endDateFrom", (Object)new Timestamp(((Date)this.pkendDateFrom.getValue()).getTime()), CompareType.GREATER_EQUALS));
        }
        if (this.pkendDateTo.getValue() != null && this.pkendDateTo.getText() != null && this.pkendDateTo.getText().length() > 0) {
            items.add(new FilterItemInfo("endDateTo", (Object)new Timestamp(((Date)this.pkendDateTo.getValue()).getTime()), CompareType.LESS_EQUALS));
        }
        if (this.pkMoveInPlanDate.getValue() != null && this.pkMoveInPlanDate.getText() != null && this.pkMoveInPlanDate.getText().length() > 0) {
            items.add(new FilterItemInfo("moveInPlanDate", (Object)new Timestamp(((Date)this.pkMoveInPlanDate.getValue()).getTime()), CompareType.EQUALS));
        }
        if (this.prmtProductionOrderFrom.getText() != null && this.prmtProductionOrderFrom.getText().length() > 0) {
            items.add(new FilterItemInfo("productionOrderFrom", (Object)this.prmtProductionOrderFrom.getText().toString().trim(), CompareType.GREATER_EQUALS));
        }
        if (this.prmtProductionOrderTo.getText() != null && this.prmtProductionOrderTo.getText().length() > 0) {
            items.add(new FilterItemInfo("productionOrderTo", (Object)this.prmtProductionOrderTo.getText().toString().trim(), CompareType.LESS_EQUALS));
        }
        if (this.prmtDefaultWareHouse.getValue() != null && this.prmtDefaultWareHouse.getText() != null && this.prmtDefaultWareHouse.getText().length() > 0) {
            set = new HashSet();
            for (i = 0; i < ((Object[])this.prmtDefaultWareHouse.getValue()).length; ++i) {
                whi = (WarehouseInfo)((Object[])this.prmtDefaultWareHouse.getValue())[i];
                set.add(whi.getId().toString());
            }
            items.add(new FilterItemInfo("defaultWareHouseId", set, CompareType.INCLUDE));
        }
        if (this.prmtMoveStorageOrgUnit.getValue() != null && this.prmtMoveStorageOrgUnit.getText() != null && this.prmtMoveStorageOrgUnit.getText().length() > 0) {
            items.add(new FilterItemInfo("moveOutStorageOrgUnitId", (Object)((StorageOrgUnitInfo)this.prmtMoveStorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmtLocation.getValue() != null && this.prmtLocation.getText() != null && this.prmtLocation.getText().length() > 0) {
            items.add(new FilterItemInfo("locationID", (Object)((LocationInfo)this.prmtLocation.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmtMoveOutWareHouse.getValue() != null && this.prmtMoveOutWareHouse.getText() != null && this.prmtMoveOutWareHouse.getText().length() > 0) {
            set = new HashSet();
            for (i = 0; i < ((Object[])this.prmtMoveOutWareHouse.getValue()).length; ++i) {
                whi = (WarehouseInfo)((Object[])this.prmtMoveOutWareHouse.getValue())[i];
                set.add(whi.getId().toString());
            }
            items.add(new FilterItemInfo("moveOutWareHouseId", set, CompareType.INCLUDE));
        }
        items.add(new FilterItemInfo("isBackFlush", (Object)new Integer(((BooleanAllEnum)this.cmbIsBackFlush.getSelectedItem()).getValue()), CompareType.EQUALS));
        if (this.isConsiderLocation.isSelected()) {
            items.add(new FilterItemInfo("isConsiderLocation", (Object)Boolean.TRUE));
        } else {
            items.add(new FilterItemInfo("isConsiderLocation", (Object)Boolean.FALSE));
        }
        return this.filterInfo;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected OrgType getAdminOrgType() {
        return OrgType.Admin;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    private void initProductLineF7(StorageOrgUnitInfo storageOrgInfo) throws Exception {
        this.prmtProductLine.setEnabledMultiSelection(true);
        this.prmtProductLine.setDisplayFormat("$name$");
        this.prmtProductLine.setEditFormat("$number$");
        this.prmtProductLine.setCommitFormat("$number$");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (storageOrgInfo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        this.prmtProductLine.setEntityViewInfo(viewInfo);
    }

    private void initMaterialF7(StorageOrgUnitInfo storageOrgInfo) throws Exception {
        this.prmMaterialNumFrom.setDisplayFormat("$number$");
        this.prmMaterialNumFrom.setEditFormat("$number$");
        this.prmMaterialNumFrom.setCommitFormat("$number$");
        this.prmtMaterialNumTo.setDisplayFormat("$number$");
        this.prmtMaterialNumTo.setEditFormat("$number$");
        this.prmtMaterialNumTo.setCommitFormat("$number$");
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (storageOrgInfo != null) {
            String storageOrgId = storageOrgInfo.getId().toString();
            String materialIDs = ProductionOrderStockEntryFactory.getRemoteInstance().getMaterialIDs(storageOrgId);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)materialIDs, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
        }
        this.prmMaterialNumFrom.setEntityViewInfo(viewInfo);
        this.prmtMaterialNumTo.setEntityViewInfo(viewInfo);
    }

    private void initProductionOrderF7(StorageOrgUnitInfo storageOrgInfo) throws Exception {
        this.prmtProductionOrderFrom.setDisplayFormat("$number$");
        this.prmtProductionOrderFrom.setEditFormat("$number$");
        this.prmtProductionOrderFrom.setCommitFormat("$number$");
        this.prmtProductionOrderTo.setDisplayFormat("$number$");
        this.prmtProductionOrderTo.setEditFormat("$number$");
        this.prmtProductionOrderTo.setCommitFormat("$number$");
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(4));
        set.add(new Integer(5));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", set, CompareType.INCLUDE));
        if (storageOrgInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
        }
        viewInfo.setFilter(filter);
        this.prmtProductionOrderFrom.setEntityViewInfo(viewInfo);
        this.prmtProductionOrderTo.setEntityViewInfo(viewInfo);
    }

    protected void prmtStorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        StorageOrgUnitInfo oldObject = (StorageOrgUnitInfo)e.getOldValue();
        StorageOrgUnitInfo newObject = (StorageOrgUnitInfo)e.getNewValue();
        if (newObject != null && !newObject.equals((Object)oldObject)) {
            this.resetOtherF7(newObject);
        } else if (newObject == null && oldObject != null) {
            this.resetOtherF7(newObject);
        }
    }

    private void resetOtherF7(StorageOrgUnitInfo newObject) throws Exception {
        this.prmtProductLine.setValue(null);
        this.initProductLineF7(newObject);
        this.prmtWorkShop.setValue(null);
        MMUtils.initWorkshopF7((KDBizPromptBox)this.prmtWorkShop, (StorageOrgUnitInfo)newObject);
        this.prmtWorkShop.setEnabledMultiSelection(true);
        this.prmMaterialNumFrom.setValue(null);
        this.prmtMaterialNumTo.setValue(null);
        this.initMaterialF7(newObject);
        this.prmtProductionOrderFrom.setValue(null);
        this.prmtProductionOrderTo.setValue(null);
        this.initProductionOrderF7(newObject);
        this.initWarehouse(newObject);
    }

    private void initWarehouse(StorageOrgUnitInfo storageOrgInfo) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (storageOrgInfo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        this.prmtDefaultWareHouse.setEntityViewInfo(viewInfo);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtWorkShop.setDisplayFormat("$name$");
        this.prmtWorkShop.setEditFormat("$number$");
        this.prmtWorkShop.setCommitFormat("$number$");
        this.removeListener();
        this.storageOrgUnitChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    StockConditionGatherFilterUI.this.prmtStorageOrgUnit_dataChanged(e);
                }
                catch (Exception exc) {
                    StockConditionGatherFilterUI.this.handUIException(exc);
                }
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgUnitChanged);
        this.defaultWareHouseChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    if (e.getNewValue() != null && ((Object[])e.getNewValue()).length > 1) {
                        StockConditionGatherFilterUI.this.prmtLocation.setValue(null);
                        StockConditionGatherFilterUI.this.prmtLocation.setEnabled(false);
                    } else if (e.getNewValue() != null && ((Object[])e.getNewValue()).length == 1) {
                        WarehouseInfo whInfo = (WarehouseInfo)((Object[])e.getNewValue())[0];
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        FilterInfo filterInfo = new FilterInfo();
                        filterInfo.getFilterItems().add(new FilterItemInfo("Warehouse.ID", (Object)whInfo.getId().toString(), CompareType.EQUALS));
                        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
                        viewInfo.setFilter(filterInfo);
                        StockConditionGatherFilterUI.this.prmtLocation.setEntityViewInfo(viewInfo);
                        StockConditionGatherFilterUI.this.prmtLocation.setEnabled(true);
                    } else {
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        StockConditionGatherFilterUI.this.prmtLocation.setEntityViewInfo(viewInfo);
                        StockConditionGatherFilterUI.this.prmtLocation.setEnabled(true);
                    }
                }
                catch (Exception exc) {
                    StockConditionGatherFilterUI.this.handUIException(exc);
                }
            }
        };
        this.prmtDefaultWareHouse.addDataChangeListener(this.defaultWareHouseChanged);
        this.moveOutStorageOrgUnitChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    if (e.getNewValue() != null) {
                        if (e.getNewValue() != e.getOldValue()) {
                            StockConditionGatherFilterUI.this.prmtMoveOutWareHouse.setValue(null);
                        }
                        StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)e.getNewValue();
                        StockConditionGatherFilterUI.this.prmtMoveOutWareHouse.setEntityViewInfo(SCMClientUtils.getWarehouseFilter((StorageOrgUnitInfo)storageOrgInfo, (int)-1));
                    } else {
                        StockConditionGatherFilterUI.this.prmtMoveOutWareHouse.setValue(null);
                        StockConditionGatherFilterUI.this.prmtMoveOutWareHouse.setEntityViewInfo(new EntityViewInfo());
                    }
                }
                catch (Exception exc) {
                    StockConditionGatherFilterUI.this.handUIException(exc);
                }
            }
        };
        this.prmtMoveStorageOrgUnit.addDataChangeListener(this.moveOutStorageOrgUnitChanged);
    }

    public boolean verify() {
        boolean bRet = true;
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessage((String)RES_STOCKGATHER, (String)"StockGatherConditionChk1"));
            bRet = false;
        }
        Date startDateFrom = (Date)this.pkstartDateFrom.getValue();
        Date startDateTo = (Date)this.pkstartDateTo.getValue();
        if (startDateFrom != null && startDateTo != null && new Timestamp(startDateFrom.getTime()).after(new Timestamp(startDateTo.getTime()))) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessage((String)RES_STOCKGATHER, (String)"StockGatherConditionChk2"));
            bRet = false;
        }
        Date endDateFrom = (Date)this.pkendDateFrom.getValue();
        Date endDateTo = (Date)this.pkendDateTo.getValue();
        if (endDateFrom != null && endDateTo != null && new Timestamp(endDateFrom.getTime()).after(new Timestamp(endDateTo.getTime()))) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessage((String)RES_STOCKGATHER, (String)"StockGatherConditionChk3"));
            bRet = false;
        }
        return bRet;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_flow_stockAllocation");
        this.prmtWorkShop.setValue(null);
        this.prmtProductLine.setValue(null);
        this.prmMaterialNumFrom.setText(null);
        this.prmtMaterialNumTo.setText(null);
        this.pkstartDateFrom.setValue(null);
        this.pkstartDateTo.setValue(null);
        this.pkendDateFrom.setValue(null);
        this.pkendDateTo.setValue(null);
        this.prmtProductionOrderFrom.setText(null);
        this.prmtProductionOrderTo.setText(null);
        this.pkMoveInPlanDate.setValue(null);
        this.cmbIsBackFlush.setSelectedItem((Object)BooleanAllEnum.All);
        this.isConsiderLocation.setSelected(false);
        this.prmtMoveStorageOrgUnit.setValue(null);
        this.prmtMoveOutWareHouse.setValue(null);
        this.prmtLocation.setValue(null);
        try {
            FilterInfo filterInfo;
            if (entityViewInfo != null && (filterInfo = entityViewInfo.getFilter()).getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
                for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                    FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                    if (filterItemInfo.getPropertyName().equals("storageOrgUnitID")) {
                        this.prmtStorageOrgUnit.setValue((Object)StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(filterItemInfo.getCompareValue().toString())));
                    }
                    if (filterItemInfo.getPropertyName().equals("workShopID") && filterItemInfo.getCompareValue() != null && ((Set)filterItemInfo.getCompareValue()).size() > 0) {
                        this.prmtWorkShop.setValue((Object)this.getWorkShop(((Set)filterItemInfo.getCompareValue()).toArray()));
                    }
                    if (filterItemInfo.getPropertyName().equals("productLineID") && filterItemInfo.getCompareValue() != null && ((Set)filterItemInfo.getCompareValue()).size() > 0) {
                        this.prmtProductLine.setValue((Object)this.getProductLine(((Set)filterItemInfo.getCompareValue()).toArray()));
                    }
                    if (filterItemInfo.getPropertyName().equals("materialNumFrom")) {
                        this.prmMaterialNumFrom.setText(filterItemInfo.getCompareValue().toString());
                    }
                    if (filterItemInfo.getPropertyName().equals("materialNumTo")) {
                        this.prmtMaterialNumTo.setText(filterItemInfo.getCompareValue().toString());
                    }
                    if (filterItemInfo.getPropertyName().equals("startDateFrom")) {
                        this.pkstartDateFrom.setValue(filterItemInfo.getCompareValue());
                    }
                    if (filterItemInfo.getPropertyName().equals("startDateTo")) {
                        this.pkstartDateTo.setValue(filterItemInfo.getCompareValue());
                    }
                    if (filterItemInfo.getPropertyName().equals("endDateFrom")) {
                        this.pkendDateFrom.setValue(filterItemInfo.getCompareValue());
                    }
                    if (filterItemInfo.getPropertyName().equals("endDateTo")) {
                        this.pkendDateTo.setValue(filterItemInfo.getCompareValue());
                    }
                    if (filterItemInfo.getPropertyName().equals("productionOrderFrom")) {
                        this.prmtProductionOrderFrom.setText(filterItemInfo.getCompareValue().toString());
                    }
                    if (filterItemInfo.getPropertyName().equals("productionOrderTo")) {
                        this.prmtProductionOrderTo.setText(filterItemInfo.getCompareValue().toString());
                    }
                    if (filterItemInfo.getPropertyName().equals("isBackFlush")) {
                        this.cmbIsBackFlush.setSelectedItem((Object)BooleanAllEnum.getEnum((int)((Integer)filterItemInfo.getCompareValue())));
                    }
                    if (filterItemInfo.getPropertyName().equals("moveInPlanDate")) {
                        this.pkMoveInPlanDate.setValue(filterItemInfo.getCompareValue());
                    }
                    if (filterItemInfo.getPropertyName().equals("moveOutStorageOrgUnitId")) {
                        this.prmtMoveStorageOrgUnit.setValue((Object)StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(filterItemInfo.getCompareValue().toString())));
                    }
                    if (filterItemInfo.getPropertyName().equals("locationID")) {
                        this.prmtLocation.setValue((Object)LocationFactory.getRemoteInstance().getLocationInfo((IObjectPK)new ObjectUuidPK(filterItemInfo.getCompareValue().toString())));
                    }
                    if (filterItemInfo.getPropertyName().equals("moveOutWareHouseId") && filterItemInfo.getCompareValue() != null && ((Set)filterItemInfo.getCompareValue()).size() > 0) {
                        this.prmtMoveOutWareHouse.setValue((Object)this.getWareHouse(((Set)filterItemInfo.getCompareValue()).toArray()));
                    }
                    if (filterItemInfo.getPropertyName().equals("defaultWareHouseId") && filterItemInfo.getCompareValue() != null && ((Set)filterItemInfo.getCompareValue()).size() > 0) {
                        this.prmtDefaultWareHouse.setValue((Object)this.getWareHouse(((Set)filterItemInfo.getCompareValue()).toArray()));
                    }
                    if (!filterItemInfo.getPropertyName().equals("isConsiderLocation")) continue;
                    this.isConsiderLocation.setSelected((Integer)filterItemInfo.getCompareValue() == 1);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private Object[] getProductLine(Object[] productLineIDs) {
        if (this.productLineMap == null) {
            this.productLineMap = new HashMap();
        }
        Object[] productLines = new Object[productLineIDs.length];
        for (int i = 0; i < productLineIDs.length; ++i) {
            if (this.productLineMap.containsKey(productLineIDs[i])) {
                productLines[i] = this.productLineMap.get(productLineIDs[i]);
                continue;
            }
            try {
                ProductLineInfo productLineInfo = ProductLineFactory.getRemoteInstance().getProductLineInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)productLineIDs[i]))));
                if (productLineInfo == null || !productLineInfo.getStorageOrgUnit().getId().toString().equals(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString())) continue;
                productLines[i] = productLineInfo;
                this.productLineMap.put(productLineInfo.getId().toString(), productLineInfo);
                continue;
            }
            catch (EASBizException e) {
                this.handUIException(e);
                continue;
            }
            catch (BOSException e) {
                this.handUIException(e);
                continue;
            }
            catch (UuidException e) {
                this.handUIException(e);
            }
        }
        return productLines;
    }

    private Object[] getWorkShop(Object[] workShopIDs) {
        if (this.workShopMap == null) {
            this.workShopMap = new HashMap();
        }
        Object[] workShops = new Object[workShopIDs.length];
        for (int i = 0; i < workShopIDs.length; ++i) {
            if (this.workShopMap.containsKey(workShopIDs[i])) {
                workShops[i] = this.workShopMap.get(workShopIDs[i]);
                continue;
            }
            try {
                AdminOrgUnitInfo workShopInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)workShopIDs[i]))));
                if (workShopInfo == null) continue;
                workShops[i] = workShopInfo;
                this.workShopMap.put(workShopInfo.getId().toString(), workShopInfo);
                continue;
            }
            catch (EASBizException e) {
                this.handUIException(e);
                continue;
            }
            catch (BOSException e) {
                this.handUIException(e);
                continue;
            }
            catch (UuidException e) {
                this.handUIException(e);
            }
        }
        return workShops;
    }

    private Object[] getWareHouse(Object[] wareHouseIDs) throws Exception {
        if (this.wareHouseMap == null) {
            this.wareHouseMap = new HashMap();
        }
        Object[] wareHouses = new Object[wareHouseIDs.length];
        for (int i = 0; i < wareHouseIDs.length; ++i) {
            if (this.wareHouseMap.containsKey(wareHouseIDs[i])) {
                wareHouses[i] = this.wareHouseMap.get(wareHouseIDs[i]);
                continue;
            }
            try {
                WarehouseInfo warehouseInfo = WarehouseFactory.getRemoteInstance().getWarehouseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)wareHouseIDs[i]))));
                if (warehouseInfo == null) continue;
                wareHouses[i] = warehouseInfo;
                this.wareHouseMap.put(warehouseInfo.getId().toString(), warehouseInfo);
                continue;
            }
            catch (EASBizException e) {
                throw new Exception(e);
            }
            catch (BOSException e) {
                throw new Exception(e);
            }
            catch (UuidException e) {
                throw new Exception(e);
            }
        }
        return wareHouses;
    }

    private void removeListener() {
        this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgUnitChanged);
        this.prmtWorkShop.removeDataChangeListener(this.workShopChanged);
    }
}

