/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.mm.control.client.AbstractStockGatherMoveBillFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class StockGatherMoveBillFilterUI
extends AbstractStockGatherMoveBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(StockGatherMoveBillFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtstorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_flow_stockAllocation");
        RangeFilterElement elementBizDate = new RangeFilterElement("bizDate", (Component)this.pkBizDateFrom, (Component)this.pkBizDateTo);
        elementBizDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        Timestamp timeStart = SCMUtils.getSCMQueryTime(null, (String)"startDate");
        Timestamp timeEnd = SCMUtils.getSCMQueryTime(null, (String)"endDate");
        elementBizDate.setDefaultValue((Object)new Timestamp[]{timeStart, timeEnd});
        elements.add((FilterElement)elementBizDate);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtstorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, StockGatherMoveBillFilterUI.getResource("STORAGEORG_ISNULL")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = super.getFilterInfo();
        FilterItemCollection items = this.filterInfo.getFilterItems();
        this.filterInfo.setMaskString(null);
        HashSet<String> hs = new HashSet<String>();
        if (this.kDCheckBoxCommit.isSelected()) {
            hs.add(String.valueOf(2));
        }
        if (this.kDCheckBoxAudit.isSelected()) {
            hs.add(String.valueOf(4));
        }
        if (this.kDCheckBoxClose.isSelected()) {
            hs.add(String.valueOf(7));
        }
        if (this.kDCheckBoxComplete.isSelected()) {
            hs.add(String.valueOf(90));
        }
        if (hs.size() > 0) {
            items.add(new FilterItemInfo("baseStatus", hs, CompareType.INCLUDE));
        } else {
            items.removeObject((Object)"baseStatus");
        }
        return this.filterInfo;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtstorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.control.client.ControlResource", (String)strKey);
    }

    protected String getViewPermission() {
        return "mm_flow_stockAllocation";
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        FilterInfo filterInfo;
        this.kDCheckBoxCommit.setSelected(false);
        this.kDCheckBoxAudit.setSelected(false);
        this.kDCheckBoxClose.setSelected(false);
        this.kDCheckBoxComplete.setSelected(false);
        super.loadData(entityViewInfo);
        if (entityViewInfo != null && (filterInfo = entityViewInfo.getFilter()).getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                if (!filterItemInfo.getPropertyName().equals("baseStatus")) continue;
                HashSet hs = (HashSet)filterItemInfo.getCompareValue();
                for (String status : hs) {
                    if (String.valueOf(2).equals(status)) {
                        this.kDCheckBoxCommit.setSelected(true);
                        continue;
                    }
                    if (String.valueOf(4).equals(status)) {
                        this.kDCheckBoxAudit.setSelected(true);
                        continue;
                    }
                    if (String.valueOf(7).equals(status)) {
                        this.kDCheckBoxClose.setSelected(true);
                        continue;
                    }
                    if (!String.valueOf(90).equals(status)) continue;
                    this.kDCheckBoxComplete.setSelected(true);
                }
            }
        }
    }

    public void clear() {
        super.clear();
        this.kDCheckBoxCommit.setSelected(false);
        this.kDCheckBoxAudit.setSelected(false);
        this.kDCheckBoxClose.setSelected(false);
        this.kDCheckBoxComplete.setSelected(false);
    }
}

