/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.control.IStockGatherMove;
import com.kingdee.eas.mm.control.StockGatherMoveFactory;
import com.kingdee.eas.mm.control.StockGatherMoveInfo;
import com.kingdee.eas.mm.control.client.AbstractStockGatherMoveBillListUI;
import com.kingdee.eas.mm.control.client.StockGatherMoveBillEditUI;
import com.kingdee.eas.mm.control.client.StockGatherMoveBillFilterUI;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.apache.log4j.Logger;

public class StockGatherMoveBillListUI
extends AbstractStockGatherMoveBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(StockGatherMoveBillListUI.class);
    private StockGatherMoveBillFilterUI conditionPanel = null;
    public static final String RES_PRD_ORDER = "com.kingdee.eas.mm.control.ProductionOrderResource";
    public static final String RES_STOCKGATHER = "com.kingdee.eas.mm.control.StockGatherResource";
    private static final String[] KDT_DATES = new String[]{"bizDate", "entrys.moveInPlanDate"};

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnTraceUp.setVisible(false);
        this.menuItemTraceUp.setVisible(false);
        this.menuItemTraceUp.setAccelerator(KeyStroke.getKeyStroke(""));
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("entrys.moveQty").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.btnAuditResult.setVisible(false);
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])KDT_DATES);
        super.setReservationVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.kDMenuItemQueryGeneralInventory.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_storagefilter", (Locale)this.getLocale()));
        this.btnQueryGeneralInventory.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_storagefilter", (Locale)this.getLocale()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.checkSelected();
            ArrayList ids = this.getSelectedIdValues();
            if (ids == null || ids.isEmpty()) {
                return;
            }
            this.setOprtState("AUDIT");
            for (int i = 0; i < ids.size(); ++i) {
                this.pubFireVOChangeListener(ids.get(i).toString());
            }
            IObjectPK[] pks = new IObjectPK[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                pks[i] = new ObjectUuidPK(ids.get(i).toString());
            }
            ((IStockGatherMove)this.getBizInterface()).audit(pks);
            this.refresh(e);
            this.showProcessMsg(EASResource.getString((String)"com.kingdee.eas.mm.control.ProductionOrderResource.AuditSuccess"));
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.checkSelected();
            if (!this.confirmUnAduit()) {
                return;
            }
            ArrayList ids = this.getSelectedIdValues();
            if (ids == null || ids.isEmpty()) {
                return;
            }
            this.setOprtState("UNAUDIT");
            for (int i = 0; i < ids.size(); ++i) {
                this.pubFireVOChangeListener(ids.get(i).toString());
            }
            IObjectPK[] pks = new IObjectPK[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                pks[i] = new ObjectUuidPK(ids.get(i).toString());
            }
            ((IStockGatherMove)this.getBizInterface()).unAudit(pks);
            this.refresh(e);
            this.showProcessMsg(EASResource.getString((String)"com.kingdee.eas.mm.control.ProductionOrderResource.UnAuditSuccess"));
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionForceClose_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.checkSelected();
            if (!this.confirmClose()) {
                return;
            }
            ArrayList idList = this.getSelectedIdValues();
            this.setOprtState("FORCECLOSE");
            IObjectPK[] pks = new IObjectPK[idList.size()];
            for (int i = 0; i < idList.size(); ++i) {
                this.pubFireVOChangeListener(idList.get(i).toString());
                pks[i] = new ObjectUuidPK(idList.get(i).toString());
            }
            ((IStockGatherMove)this.getBizInterface()).forceClose(pks);
            this.showProcessMsg(EASResource.getString((String)"com.kingdee.eas.mm.control.ProductionOrderResource.CloseSuccess"));
            this.refresh(e);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return StockGatherMoveFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected IObjectValue createNewData() {
        StockGatherMoveInfo objectValue = new StockGatherMoveInfo();
        return objectValue;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Storage)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    public static String getResource(String strKey) {
        return ResourceManage.getResource((String)"com.kingdee.eas.mm.control.client.ControlResource", (String)strKey);
    }

    private String getResourceMsg2(String key) {
        return ResourceUtils.getMessage((String)RES_STOCKGATHER, (String)key);
    }

    protected String getEditUIName() {
        return StockGatherMoveBillEditUI.class.getName();
    }

    public String getEntriesName() {
        return "entrys";
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"id", "number", "storageOrgUnit.id", "storageOrgUnit.name", "bizDate", "creator.name", "baseStatus"};
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        String title = StockGatherMoveBillListUI.getResource("StockGatherBillQueryF7WindowTitle");
        dialog.setTitle(title + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        return dialog;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new StockGatherMoveBillFilterUI();
        }
        return this.conditionPanel;
    }

    protected boolean initDefaultFilter() {
        return this.getUIContext().get("BillMainQuery") == null;
    }

    private void showProcessMsg(String msg) {
        this.setMessageText(msg);
        this.showMessage();
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public void initBatchActions() throws BOSException {
        this.initPSBatchActions();
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, StockGatherMoveFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", null, "number", null, "storageOrgUnit.id");
    }

    public void initPSBatchActions() throws BOSException {
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.DELETE, (ItemAction)this.actionRemove, (String)"delete");
        this.actionManager.registerBatchAction(actionProxy, "actionRemove");
        actionProxy.bindTo((AbstractButton)this.btnRemove);
        actionProxy.bindTo((AbstractButton)this.menuItemRemove);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.btnRemove);
    }

    protected boolean confirmClose() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)this.getResourceMsg2("StockGatherCloseCorfirm")));
    }

    @Override
    public void actionQueryGeneralInventory_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList entryIds = super.getSelectedFieldValues("entrys.id");
        if (entryIds == null || entryIds.size() == 0) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)this.getMainBizOrgType(), this.getMainOrgContext().get((Object)this.getMainBizOrgType()));
        uiContext.put((Object)"idList", (Object)entryIds);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.mm.control.client.StockGatherInventoryQueryUI", (Map)uiContext, null);
        window.show();
    }

    @Override
    public void actionSourceBillView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList entryIds = super.getSelectedFieldValues("entrys.id");
        if (entryIds == null || entryIds.size() == 0) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)this.getMainBizOrgType(), this.getMainOrgContext().get((Object)this.getMainBizOrgType()));
        uiContext.put((Object)"idList", (Object)entryIds);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.mm.control.client.StockGatherSourceQueryUI", (Map)uiContext, null);
        window.show();
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "stockGatherBillTemplate";
        param.alias = this.getResourceMsg2("StockGatherBill");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.ExportData();
    }

    private void ExportData() throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        Object tmp = para.get(0);
        if (tmp instanceof DatataskParameter) {
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.mm.control.app", "StockGatherMoveForPrintQuery");
            DatataskParameter dp = (DatataskParameter)tmp;
            dp.putContextParam((Object)"mainQueryPK", (Object)mainQueryPK);
            dp.putContextParam((Object)"mainQuery", (Object)this.mainQuery);
        }
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.setMainOrgContext(this.getMainOrgContext());
        dc.invoke(para, 1);
    }

    protected void logPrint() {
        StockGatherMoveInfo sgmInfo = new StockGatherMoveInfo();
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)sgmInfo.getBOSType(), null, (String)this.getResourceMsg2("Msg_StockGather_Print"), (String)"mm_stockGatherMove_print");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected void initKeyStroke() {
        super.initKeyStroke();
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ctrl shift E"), "exportData");
        actionMap.put("exportData", (Action)this.actionExportData);
    }
}

