/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.basedata.BooleanAllEnum;
import com.kingdee.eas.mm.basedata.ProductLineFactory;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryFactory;
import com.kingdee.eas.mm.control.client.AbstractStockGatherMoveFilterUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class StockGatherMoveFilterUI
extends AbstractStockGatherMoveFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(StockGatherMoveFilterUI.class);
    public static final String RES_PRD_ORDER = "com.kingdee.eas.mm.control.ProductionOrderResource";
    private Map productLineMap = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_flow_stockAllocation");
        StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_flow_stockAllocation");
        this.prmtStorageOrgUnit.setValue((Object)storageOrgInfo);
        this.prmtWorkShop.setValue(null);
        this.prmtProductLine.setValue(null);
        this.prmMaterialNumFrom.setText(null);
        this.prmtMaterialNumTo.setText(null);
        this.kdBizDateFrom.setValue(null);
        this.kdBizDateTo.setValue(null);
        this.prmtProductionOrderFrom.setText(null);
        this.prmtProductionOrderTo.setText(null);
        this.cmbProductionOrderStatus.setSelectedItem((Object)BillBaseStatusEnum.AUDITED);
        this.cmbIsTranslateID.setSelectedItem((Object)BooleanAllEnum.No);
        this.cmbIsBackFlush.setSelectedItem((Object)BooleanAllEnum.Yes);
        this.prmtDefaultWarehouse.setValue(null);
        this.prmtMoveOutWarehouse.setValue(null);
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo.getFilterItems().clear();
        FilterItemCollection items = this.filterInfo.getFilterItems();
        this.filterInfo.setMaskString(null);
        if (this.prmtStorageOrgUnit.getValue() != null && this.prmtStorageOrgUnit.getText() != null && this.prmtStorageOrgUnit.getText().length() > 0) {
            items.add(new FilterItemInfo("storageOrgUnitID", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmtWorkShop.getValue() != null && this.prmtWorkShop.getText() != null && this.prmtWorkShop.getText().length() > 0) {
            items.add(new FilterItemInfo("workShopID", (Object)((AdminOrgUnitInfo)this.prmtWorkShop.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmtProductLine.getValue() != null && this.prmtProductLine.getText() != null && this.prmtProductLine.getText().length() > 0) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < ((Object[])this.prmtProductLine.getValue()).length; ++i) {
                ProductLineInfo productLine = (ProductLineInfo)((Object[])this.prmtProductLine.getValue())[i];
                set.add(productLine.getId().toString());
            }
            items.add(new FilterItemInfo("productLineID", set, CompareType.INCLUDE));
        }
        if (this.prmtDefaultWarehouse.getValue() != null && this.prmtDefaultWarehouse.getText() != null && this.prmtDefaultWarehouse.getText().length() > 0) {
            items.add(new FilterItemInfo("defaultWarehouse", (Object)((WarehouseInfo)this.prmtDefaultWarehouse.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmtMoveOutWarehouse.getValue() != null && this.prmtMoveOutWarehouse.getText() != null && this.prmtMoveOutWarehouse.getText().length() > 0) {
            items.add(new FilterItemInfo("moveOutWarehouse", (Object)((WarehouseInfo)this.prmtMoveOutWarehouse.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmMaterialNumFrom.getText() != null && this.prmMaterialNumFrom.getText().length() > 0) {
            items.add(new FilterItemInfo("materialNumFrom", (Object)this.prmMaterialNumFrom.getText().toString().trim(), CompareType.GREATER_EQUALS));
        }
        if (this.prmtMaterialNumTo.getText() != null && this.prmtMaterialNumTo.getText().length() > 0) {
            items.add(new FilterItemInfo("materialNumTo", (Object)this.prmtMaterialNumTo.getText().toString().trim(), CompareType.LESS_EQUALS));
        }
        if (this.kdBizDateFrom.getValue() != null && this.kdBizDateFrom.getText() != null && this.kdBizDateFrom.getText().length() > 0) {
            items.add(new FilterItemInfo("bizDateFrom", (Object)new Timestamp(((Date)this.kdBizDateFrom.getValue()).getTime()), CompareType.GREATER_EQUALS));
        }
        if (this.kdBizDateTo.getValue() != null && this.kdBizDateTo.getText() != null && this.kdBizDateTo.getText().length() > 0) {
            items.add(new FilterItemInfo("bizDateTo", (Object)new Timestamp(((Date)this.kdBizDateTo.getValue()).getTime()), CompareType.LESS_EQUALS));
        }
        if (this.prmtProductionOrderFrom.getText() != null && this.prmtProductionOrderFrom.getText().length() > 0) {
            items.add(new FilterItemInfo("productionOrderFrom", (Object)this.prmtProductionOrderFrom.getText().toString().trim(), CompareType.GREATER_EQUALS));
        }
        if (this.prmtProductionOrderTo.getText() != null && this.prmtProductionOrderTo.getText().length() > 0) {
            items.add(new FilterItemInfo("productionOrderTo", (Object)this.prmtProductionOrderTo.getText().toString().trim(), CompareType.LESS_EQUALS));
        }
        if (this.cmbProductionOrderStatus.getSelectedItem() != null) {
            items.add(new FilterItemInfo("productionOrderStatus", (Object)new Integer(((BillBaseStatusEnum)this.cmbProductionOrderStatus.getSelectedItem()).getValue()), CompareType.EQUALS));
        }
        items.add(new FilterItemInfo("isBackFlush", (Object)new Integer(((BooleanAllEnum)this.cmbIsBackFlush.getSelectedItem()).getValue()), CompareType.EQUALS));
        items.add(new FilterItemInfo("isTranslateID", (Object)new Integer(((BooleanAllEnum)this.cmbIsTranslateID.getSelectedItem()).getValue()), CompareType.EQUALS));
        return this.filterInfo;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected OrgType getAdminOrgType() {
        return OrgType.Admin;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    private void initProductLineF7(StorageOrgUnitInfo storageOrgInfo, AdminOrgUnitInfo adminOrgUnitInfo) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("workshop.id", (Object)adminOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.prmtProductLine.setEntityViewInfo(viewInfo);
        this.prmtProductLine.setValue(null);
    }

    private void initProductLineF7(StorageOrgUnitInfo storageOrgInfo) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (storageOrgInfo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        this.prmtProductLine.setEntityViewInfo(viewInfo);
    }

    private void initWarehouse(StorageOrgUnitInfo storageOrgInfo) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (storageOrgInfo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        this.prmtDefaultWarehouse.setEntityViewInfo(viewInfo);
        OrgUnitInfo[] stockGatherOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), "mm_flow_stockAllocation");
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < stockGatherOrgs.length; ++i) {
            String id = stockGatherOrgs[i].getId().toString();
            ids.add(id);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo2 = new FilterInfo();
        filterInfo2.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", ids, CompareType.INCLUDE));
        view.setFilter(filterInfo2);
        this.prmtMoveOutWarehouse.setEntityViewInfo(view);
    }

    private void initMaterialF7(StorageOrgUnitInfo storageOrgInfo) throws Exception {
        if (storageOrgInfo != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            String storageOrgId = storageOrgInfo.getId().toString();
            String materialIDs = ProductionOrderStockEntryFactory.getRemoteInstance().getMaterialIDs(storageOrgId);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)materialIDs, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            this.prmMaterialNumFrom.setEntityViewInfo(viewInfo);
            this.prmtMaterialNumTo.setEntityViewInfo(viewInfo);
        }
    }

    private void initProductionOrderFromF7() throws Exception {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(4));
        set.add(new Integer(5));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", set, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        this.prmtProductionOrderFrom.setEntityViewInfo(viewInfo);
    }

    private void initProductionOrderToF7() throws Exception {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(4));
        set.add(new Integer(5));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", set, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        this.prmtProductionOrderTo.setEntityViewInfo(viewInfo);
    }

    @Override
    protected void prmtWorkShop_dataChanged(DataChangeEvent e) throws Exception {
        AdminOrgUnitInfo oldObject = (AdminOrgUnitInfo)e.getOldValue();
        AdminOrgUnitInfo newObject = (AdminOrgUnitInfo)e.getNewValue();
        if (null != newObject && !newObject.equals((Object)oldObject)) {
            this.initProductLineF7((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue(), newObject);
        } else if (null == newObject && null != oldObject) {
            this.initProductLineF7((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_flow_stockAllocation");
        StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), null);
        this.prmtStorageOrgUnit.setValue((Object)storageOrgInfo);
        this.prmtStorageOrgUnit.setEnabled(false);
        MMUtils.initWorkshopF7((KDBizPromptBox)this.prmtWorkShop, (StorageOrgUnitInfo)storageOrgInfo);
        this.initProductLineF7(storageOrgInfo);
        this.initWarehouse(storageOrgInfo);
        this.initMaterialF7(storageOrgInfo);
        this.initProductionOrderFromF7();
        this.initProductionOrderToF7();
        this.cmbProductionOrderStatus.removeAllItems();
        this.cmbProductionOrderStatus.addItem((Object)BillBaseStatusEnum.NULL);
        this.cmbProductionOrderStatus.addItem((Object)BillBaseStatusEnum.TEMPORARILYSAVED);
        this.cmbProductionOrderStatus.addItem((Object)BillBaseStatusEnum.SUBMITED);
        this.cmbProductionOrderStatus.addItem((Object)BillBaseStatusEnum.AUDITED);
        this.cmbProductionOrderStatus.addItem((Object)BillBaseStatusEnum.RELEASED);
        this.cmbProductionOrderStatus.addItem((Object)BillBaseStatusEnum.BLOCKED);
        this.cmbProductionOrderStatus.addItem((Object)BillBaseStatusEnum.DELETED);
        this.cmbProductionOrderStatus.addItem((Object)BillBaseStatusEnum.COMPLETE);
        this.cmbProductionOrderStatus.addItem((Object)BillBaseStatusEnum.CLOSED);
        this.cmbProductionOrderStatus.setSelectedItem((Object)BillBaseStatusEnum.AUDITED);
        this.cmbIsTranslateID.removeAllItems();
        this.cmbIsTranslateID.addItem((Object)BooleanAllEnum.Yes);
        this.cmbIsTranslateID.addItem((Object)BooleanAllEnum.No);
        this.cmbIsTranslateID.setSelectedItem((Object)BooleanAllEnum.No);
    }

    public boolean verify() {
        boolean bRet = true;
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessage((String)RES_PRD_ORDER, (String)"StorageOrgNotNull"));
            bRet = false;
        }
        Date bizDateFrom = (Date)this.kdBizDateFrom.getValue();
        Date bizDateTo = (Date)this.kdBizDateTo.getValue();
        if (bizDateFrom != null && bizDateTo != null && new Timestamp(bizDateFrom.getTime()).after(new Timestamp(bizDateTo.getTime()))) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessage((String)RES_PRD_ORDER, (String)"stockGather_BizDate"));
            bRet = false;
        }
        return bRet;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.prmtWorkShop.setValue(null);
        this.prmtProductLine.setValue(null);
        this.prmMaterialNumFrom.setText(null);
        this.prmtMaterialNumTo.setText(null);
        this.kdBizDateFrom.setValue(null);
        this.kdBizDateTo.setValue(null);
        this.prmtProductionOrderFrom.setText(null);
        this.prmtProductionOrderTo.setText(null);
        this.prmtDefaultWarehouse.setValue(null);
        this.prmtMoveOutWarehouse.setValue(null);
        try {
            FilterInfo filterInfo;
            if (entityViewInfo != null && (filterInfo = entityViewInfo.getFilter()).getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
                for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                    FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                    if (filterItemInfo.getPropertyName().equals("workShopID")) {
                        this.prmtWorkShop.setValue((Object)AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(filterItemInfo.getCompareValue().toString())));
                    }
                    if (filterItemInfo.getPropertyName().equals("productLineID") && filterItemInfo.getCompareValue() != null && ((Set)filterItemInfo.getCompareValue()).size() > 0) {
                        this.prmtProductLine.setValue((Object)this.getProductLine(((Set)filterItemInfo.getCompareValue()).toArray()));
                    }
                    if (filterItemInfo.getPropertyName().equals("materialNumFrom")) {
                        this.prmMaterialNumFrom.setText(filterItemInfo.getCompareValue().toString());
                    }
                    if (filterItemInfo.getPropertyName().equals("materialNumTo")) {
                        this.prmtMaterialNumTo.setText(filterItemInfo.getCompareValue().toString());
                    }
                    if (filterItemInfo.getPropertyName().equals("bizDateFrom")) {
                        this.kdBizDateFrom.setValue(filterItemInfo.getCompareValue());
                    }
                    if (filterItemInfo.getPropertyName().equals("bizDateTo")) {
                        this.kdBizDateTo.setValue(filterItemInfo.getCompareValue());
                    }
                    if (filterItemInfo.getPropertyName().equals("productionOrderFrom")) {
                        this.prmtProductionOrderFrom.setText(filterItemInfo.getCompareValue().toString());
                    }
                    if (filterItemInfo.getPropertyName().equals("productionOrderTo")) {
                        this.prmtProductionOrderTo.setText(filterItemInfo.getCompareValue().toString());
                    }
                    if (filterItemInfo.getPropertyName().equals("productionOrderStatus")) {
                        this.cmbProductionOrderStatus.setSelectedItem((Object)BillBaseStatusEnum.getEnum((int)((Integer)filterItemInfo.getCompareValue())));
                    }
                    if (filterItemInfo.getPropertyName().equals("isBackFlush")) {
                        this.cmbIsBackFlush.setSelectedItem((Object)BooleanAllEnum.getEnum((int)((Integer)filterItemInfo.getCompareValue())));
                    }
                    if (filterItemInfo.getPropertyName().equals("isTranslateID")) {
                        this.cmbIsTranslateID.setSelectedItem((Object)BooleanAllEnum.getEnum((int)((Integer)filterItemInfo.getCompareValue())));
                    }
                    if (filterItemInfo.getPropertyName().equals("defaultWarehouse")) {
                        this.prmtDefaultWarehouse.setValue((Object)WarehouseFactory.getRemoteInstance().getWarehouseInfo((IObjectPK)new ObjectUuidPK(filterItemInfo.getCompareValue().toString())));
                    }
                    if (!filterItemInfo.getPropertyName().equals("moveOutWarehouse")) continue;
                    this.prmtMoveOutWarehouse.setValue((Object)WarehouseFactory.getRemoteInstance().getWarehouseInfo((IObjectPK)new ObjectUuidPK(filterItemInfo.getCompareValue().toString())));
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private Object[] getProductLine(Object[] productLineIDs) {
        if (this.productLineMap == null) {
            this.productLineMap = new HashMap();
        }
        Object[] productLines = new Object[productLineIDs.length];
        for (int i = 0; i < productLineIDs.length; ++i) {
            if (this.productLineMap.containsKey(productLineIDs[i])) {
                productLines[i] = this.productLineMap.get(productLineIDs[i]);
                continue;
            }
            try {
                ProductLineInfo productLineInfo = ProductLineFactory.getRemoteInstance().getProductLineInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)productLineIDs[i]))));
                if (productLineInfo == null || !productLineInfo.getStorageOrgUnit().getId().toString().equals(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString())) continue;
                productLines[i] = productLineInfo;
                this.productLineMap.put(productLineInfo.getId().toString(), productLineInfo);
                continue;
            }
            catch (EASBizException e) {
                this.handUIException(e);
                continue;
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return productLines;
    }
}

