/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BooleanAllEnum;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.loadmass.HashMapObject;
import com.kingdee.eas.mm.control.IProductionOrderStockEntry;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryFactory;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.control.client.AbstractStockGatherMoveListUI;
import com.kingdee.eas.mm.control.client.ProductLotNoTraceDataProvider;
import com.kingdee.eas.mm.control.client.StockGatherMoveDataProvider;
import com.kingdee.eas.mm.control.client.StockGatherMoveFilterUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.helper.FormattedEditorFactory;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class StockGatherMoveListUI
extends AbstractStockGatherMoveListUI {
    private static final Logger logger = CoreUIObject.getLogger(StockGatherMoveListUI.class);
    private CommonQueryDialog dialog;
    private StockGatherMoveFilterUI stockGatherMoveFilterUI;
    private IMetaDataPK mainQueryPK;
    private FilterInfo filterInfo;
    public static final String RES_PRD_ORDER = "com.kingdee.eas.mm.control.ProductionOrderResource";
    public static final String RES_PRD_NEXT_ORDER = "com.kingdee.eas.mm.control.ProductionOrderNextResource";
    private static final String TB_DEFAULTWAREHOUSE = "defaultwarehouse";
    private static final String TB_DEFAULTWAREHOUSEID = "defaultwarehouseId";
    private static final String TB_STORAGEORGUNIT = "storageOrgUnit";
    private static final String TB_WAREHOUSE = "warehouse";
    private static final String TB_WAREHOUSEID = "warehouseId";
    private static final String TB_REMARK = "remark";
    private static final String TB_MATERIAL = "material";
    private static final String TB_MATERIALNUMBER = "materialNumber";
    private static final String TB_UNIT = "unit";
    private static final String TB_QTY = "qty";
    private static final String TB_INVENTORYQTY = "inventoryQty";
    private static final String TB_INVENTORYBASEQTY = "inventoryBaseQty";
    private static final String TB_MOVEQTY = "moveQty";
    private static final String TB_MOVEBASEQTY = "moveBaseQty";
    private static final String TB_BASEUNIT = "baseUnit";
    private static final String TB_BASEQTY = "baseQty";
    private static final String TB_ASSITANTUNIT = "assitantUnitId";
    private static final String TB_ASSITANTQTY = "assitantQty";
    private KDTEditAdapter kdtEntrysChangeListener = null;
    private DataChangeListener prmtMoveInDate_dataChanged = null;
    private Map materialQtyCatch = new HashMap();
    private Map materialCatch = new HashMap();
    private Map companyCatch = new HashMap();
    private Map bizTypeCatch = new HashMap();
    private Map takeUpCatch = new HashMap();
    private Map transBatchCatch = new HashMap();
    private Map rateCatch = new HashMap();
    private Map inventoryCatch = new HashMap();
    private Map assistantRateCatch = new HashMap();

    public StockGatherMoveListUI() throws Exception {
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.base.message", "MsgQuery");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    private void setDefaultWarehouseFilter(StorageOrgUnitInfo orgUnit) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (orgUnit != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgUnit.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
        }
        this.prmtWarehouse.setEntityViewInfo(viewInfo);
    }

    private void addListeners() {
        if (null == this.kdtEntrysChangeListener) {
            this.kdtEntrysChangeListener = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        StockGatherMoveListUI.this.kdtEntrys_Changed(e.getRowIndex(), e.getColIndex(), e);
                    }
                    catch (Exception exc) {
                        StockGatherMoveListUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtStock.addKDTEditListener((KDTEditListener)this.kdtEntrysChangeListener);
        if (null == this.prmtMoveInDate_dataChanged) {
            this.prmtMoveInDate_dataChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        StockGatherMoveListUI.this.prmtMoveInDate_dataChanged(e);
                    }
                    catch (Exception exc) {
                        StockGatherMoveListUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdPlanDate.addDataChangeListener(this.prmtMoveInDate_dataChanged);
    }

    public void kdtEntrys_Changed(int rowIndex, int colIndex, KDTEditEvent e) throws Exception {
        if (TB_STORAGEORGUNIT.equalsIgnoreCase(this.kdtStock.getColumn(colIndex).getKey())) {
            if (e.getOldValue() != e.getValue()) {
                this.kdtStock.getCell(rowIndex, TB_WAREHOUSE).setValue(null);
                StorageOrgUnitInfo soi = (StorageOrgUnitInfo)this.kdtStock.getCell(rowIndex, TB_STORAGEORGUNIT).getValue();
                EntityViewInfo viewInfo = new EntityViewInfo();
                if (soi != null) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)soi.getId().toString(), CompareType.EQUALS));
                    viewInfo.setFilter(filter);
                }
                KDBizPromptBox warehouseBox = new KDBizPromptBox();
                warehouseBox.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
                warehouseBox.setEditable(true);
                warehouseBox.setEnabledMultiSelection(false);
                warehouseBox.setCommitFormat("$number$");
                warehouseBox.setDisplayFormat("$number$");
                warehouseBox.setEditFormat("$number$");
                warehouseBox.setEntityViewInfo(viewInfo);
                this.kdtStock.getCell(rowIndex, TB_WAREHOUSE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)warehouseBox));
            }
        } else if (TB_MOVEQTY.equalsIgnoreCase(this.kdtStock.getColumn(colIndex).getKey())) {
            if (e.getOldValue() == null && e.getValue() != null || e.getOldValue() != null && e.getValue() == null || e.getOldValue() != null && e.getValue() != null && !e.getOldValue().equals(e.getValue())) {
                this.calSTNum(rowIndex, true);
            }
            StringBuffer no = new StringBuffer("");
            BigDecimal numBefore = new BigDecimal(0);
            BigDecimal numAfter = new BigDecimal(0);
            BigDecimal numChange = new BigDecimal(0);
            if (e.getOldValue() != null) {
                numBefore = (BigDecimal)e.getOldValue();
            }
            if (e.getValue() != null) {
                numAfter = (BigDecimal)e.getValue();
            }
            String notice = "";
            String materialNumber = "";
            if (!numBefore.equals(numAfter)) {
                String materialId = (String)this.kdtStock.getCell(rowIndex, TB_MATERIAL).getValue();
                WarehouseInfo wareHouse = (WarehouseInfo)this.kdtStock.getCell(rowIndex, TB_DEFAULTWAREHOUSE).getValue();
                materialNumber = (String)this.kdtStock.getCell(rowIndex, TB_MATERIALNUMBER).getValue();
                if (wareHouse == null) {
                    return;
                }
                int j = this.kdtStock.getRowCount();
                for (int i = 0; i < j; ++i) {
                    if (rowIndex == i) continue;
                    WarehouseInfo wareHouseOther = (WarehouseInfo)this.kdtStock.getRow(i).getCell(TB_DEFAULTWAREHOUSE).getValue();
                    String materialIdOther = (String)this.kdtStock.getRow(i).getCell(TB_MATERIAL).getValue();
                    if (wareHouseOther == null || !wareHouseOther.getId().toString().equals(wareHouse.getId().toString()) || !materialId.equals(materialIdOther)) continue;
                    no.append(i + 1 + ",");
                }
                BigDecimal inventoryQty = (BigDecimal)this.inventoryCatch.get(materialId + wareHouse.getId().toString());
                inventoryQty = inventoryQty.add(numChange);
                this.inventoryCatch.put(materialId + wareHouse.getId().toString(), inventoryQty);
            }
        } else if (TB_MOVEBASEQTY.equalsIgnoreCase(this.kdtStock.getColumn(colIndex).getKey())) {
            if (e.getOldValue() == null && e.getValue() != null || e.getOldValue() != null && e.getValue() == null || e.getOldValue() != null && e.getValue() != null && !e.getOldValue().equals(e.getValue())) {
                this.calSTNum(rowIndex, false);
            }
        } else if (TB_DEFAULTWAREHOUSE.equalsIgnoreCase(this.kdtStock.getColumn(colIndex).getKey()) && (e.getOldValue() == null && e.getValue() != null || e.getOldValue() != null && e.getValue() == null || e.getOldValue() != null && e.getValue() != null && !e.getOldValue().equals(e.getValue()))) {
            BigDecimal qty;
            String materialId = (String)this.kdtStock.getCell(rowIndex, TB_MATERIAL).getValue();
            BigDecimal moveQty = qty = (BigDecimal)this.kdtStock.getCell(rowIndex, TB_QTY).getValue();
            BigDecimal transBatch = (BigDecimal)this.transBatchCatch.get(materialId);
            BigDecimal rate = (BigDecimal)this.rateCatch.get(materialId);
            BigDecimal assitantRate = (BigDecimal)this.assistantRateCatch.get(materialId);
            String unit = (String)this.kdtStock.getCell(rowIndex, TB_UNIT).getValue();
            String baseUnit = (String)this.kdtStock.getCell(rowIndex, TB_BASEUNIT).getValue();
            BigDecimal inventoryQty = null;
            BigDecimal takeUpBaseQty = null;
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
            MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialId, unit);
            MultiMeasureUnitInfo baseMultiUnifInfo = multiUnit.getMultiUnit(materialId, baseUnit);
            if (e.getValue() == null) {
                WarehouseInfo warehouseInfo = (WarehouseInfo)e.getOldValue();
                BigDecimal moveQtyOld = (BigDecimal)this.kdtStock.getCell(rowIndex, TB_MOVEBASEQTY).getValue();
                String key = materialId + warehouseInfo.getId().toString();
                this.kdtStock.getCell(rowIndex, TB_INVENTORYQTY).setValue((Object)new BigDecimal(0.0));
                this.kdtStock.getCell(rowIndex, TB_INVENTORYBASEQTY).setValue((Object)new BigDecimal(0.0));
                moveQty = this.calcMoveQty(qty, inventoryQty, rate, multiUnifInfo.getQtyPrecision(), transBatch, moveQty);
                this.kdtStock.getCell(rowIndex, TB_MOVEQTY).setValue((Object)moveQty);
                BigDecimal moveBaseQty = moveQty.multiply(rate).setScale(baseMultiUnifInfo.getQtyPrecision());
                if (assitantRate != null) {
                    BigDecimal assitantQty = moveBaseQty.divide(assitantRate, 4);
                    this.kdtStock.getCell(rowIndex, TB_ASSITANTQTY).setValue((Object)assitantQty);
                }
                this.kdtStock.getCell(rowIndex, TB_MOVEBASEQTY).setValue((Object)moveBaseQty);
                BigDecimal inventoryQtyOld = (BigDecimal)this.inventoryCatch.get(key);
                inventoryQtyOld = inventoryQtyOld.add(qty).subtract(moveQtyOld);
                this.inventoryCatch.put(key, inventoryQtyOld);
                this.kdtStock.getCell(rowIndex, TB_INVENTORYQTY).setValue((Object)new BigDecimal(0.0));
                this.kdtStock.getCell(rowIndex, TB_INVENTORYBASEQTY).setValue((Object)new BigDecimal(0.0));
            } else if (e.getValue() != null) {
                WarehouseInfo warehouseInfo = (WarehouseInfo)e.getValue();
                WarehouseInfo warehouseInfo2 = (WarehouseInfo)e.getOldValue();
                String key = materialId + warehouseInfo.getId().toString();
                String key2 = materialId + (warehouseInfo2 != null ? warehouseInfo2.getId().toString() : "");
                if (this.inventoryCatch.containsKey(key)) {
                    inventoryQty = (BigDecimal)this.inventoryCatch.get(key);
                    this.resetInventoryQtyAndMoveQty(rowIndex, materialId, qty, moveQty, transBatch, rate, inventoryQty, multiUnifInfo, baseMultiUnifInfo, warehouseInfo2, key, key2, assitantRate);
                } else {
                    IProductionOrderStockEntry pe = ProductionOrderStockEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
                    Map inventory = pe.getInventoryQtys(this.filterInfo, materialId, warehouseInfo.getId().toString(), this.kdPlanDate.getSqlDate());
                    BigDecimal inventoryBaseQty = (BigDecimal)inventory.get(key);
                    Map stageResult = pe.getProductStageQtyS(materialId, warehouseInfo.getId().toString());
                    takeUpBaseQty = (BigDecimal)stageResult.get(key);
                    this.takeUpCatch.put(key, takeUpBaseQty);
                    inventoryBaseQty = inventoryBaseQty.subtract(takeUpBaseQty);
                    inventoryQty = inventoryBaseQty.divide(rate, multiUnifInfo.getQtyPrecision(), 4);
                    this.resetInventoryQtyAndMoveQty(rowIndex, materialId, qty, moveQty, transBatch, rate, inventoryQty, multiUnifInfo, baseMultiUnifInfo, warehouseInfo2, key, key2, assitantRate);
                }
            }
        }
    }

    private void resetInventoryQtyAndMoveQty(int rowIndex, String materialId, BigDecimal qty, BigDecimal moveQty, BigDecimal transBatch, BigDecimal rate, BigDecimal inventoryQty, MultiMeasureUnitInfo multiUnifInfo, MultiMeasureUnitInfo baseMultiUnifInfo, WarehouseInfo warehouseInfo2, String key, String key2, BigDecimal assitantRate) throws SQLException, BOSException, EASBizException {
        BigDecimal moveQtyOld = (BigDecimal)this.kdtStock.getCell(rowIndex, TB_MOVEBASEQTY).getValue();
        moveQty = this.calcMoveQty(qty, inventoryQty, rate, multiUnifInfo.getQtyPrecision(), transBatch, moveQty);
        this.kdtStock.getCell(rowIndex, TB_MOVEQTY).setValue((Object)moveQty);
        BigDecimal moveBaseQty = moveQty.multiply(rate).setScale(baseMultiUnifInfo.getQtyPrecision());
        this.kdtStock.getCell(rowIndex, TB_MOVEBASEQTY).setValue((Object)moveBaseQty);
        if (assitantRate != null) {
            BigDecimal assitantQty = moveBaseQty.divide(assitantRate, 4);
            this.kdtStock.getCell(rowIndex, TB_ASSITANTQTY).setValue((Object)assitantQty);
        }
        if (inventoryQty == null) {
            this.kdtStock.getCell(rowIndex, TB_INVENTORYQTY).setValue((Object)new BigDecimal(0.0));
            this.kdtStock.getCell(rowIndex, TB_INVENTORYBASEQTY).setValue((Object)new BigDecimal(0.0));
        } else {
            this.kdtStock.getCell(rowIndex, TB_INVENTORYQTY).setValue((Object)inventoryQty);
            this.kdtStock.getCell(rowIndex, TB_INVENTORYBASEQTY).setValue((Object)inventoryQty.multiply(rate).setScale(baseMultiUnifInfo.getQtyPrecision(), 4));
        }
        inventoryQty = inventoryQty.subtract(qty).add(moveQty);
        this.inventoryCatch.put(key, inventoryQty);
        if (warehouseInfo2 != null) {
            BigDecimal inventoryQtyOld = (BigDecimal)this.inventoryCatch.get(key2);
            inventoryQtyOld = inventoryQtyOld.add(qty).subtract(moveQtyOld);
            this.inventoryCatch.put(key2, inventoryQtyOld);
        }
    }

    private void calSTNum(int rowIndex, boolean flag) throws BOSException, EASBizException {
        String materialId = (String)this.kdtStock.getCell(rowIndex, TB_MATERIAL).getValue();
        String unit = (String)this.kdtStock.getCell(rowIndex, TB_UNIT).getValue();
        String baseUnit = (String)this.kdtStock.getCell(rowIndex, TB_BASEUNIT).getValue();
        String assistUnitId = (String)this.kdtStock.getCell(rowIndex, TB_ASSITANTUNIT).getValue();
        if (materialId != null && unit != null && baseUnit != null) {
            MeasureUnitInfo measureUnitInfo = new MeasureUnitInfo();
            measureUnitInfo.setId(BOSUuid.read((String)unit));
            MeasureUnitInfo measureBaseUnitInfo = new MeasureUnitInfo();
            measureBaseUnitInfo.setId(BOSUuid.read((String)baseUnit));
            BigDecimal moveQty = (BigDecimal)this.kdtStock.getCell(rowIndex, TB_MOVEQTY).getValue();
            BigDecimal moveBaseQty = (BigDecimal)this.kdtStock.getCell(rowIndex, TB_MOVEBASEQTY).getValue();
            if (flag) {
                if (moveQty == null || moveQty.doubleValue() <= 0.0) {
                    this.kdtStock.getCell(rowIndex, TB_MOVEBASEQTY).setValue((Object)new BigDecimal(0.0));
                    this.kdtStock.getCell(rowIndex, TB_MOVEQTY).setValue((Object)new BigDecimal(0.0));
                    this.kdtStock.getCell(rowIndex, TB_ASSITANTQTY).setValue((Object)new BigDecimal(0.0));
                } else {
                    BigDecimal moveBaseQtyNew = SCMUtils.getExchangePricesionQtyForClient((String)materialId, (MeasureUnitInfo)measureUnitInfo, (MeasureUnitInfo)measureBaseUnitInfo, (BigDecimal)moveQty);
                    this.kdtStock.getCell(rowIndex, TB_MOVEBASEQTY).setValue((Object)moveBaseQtyNew);
                    if (assistUnitId != null) {
                        MeasureUnitInfo measureAssistUnitInfo = new MeasureUnitInfo();
                        measureAssistUnitInfo.setId(BOSUuid.read((String)assistUnitId));
                        BigDecimal assistQtyNew = SCMUtils.getExchangePricesionQtyForClient((String)materialId, (MeasureUnitInfo)measureUnitInfo, (MeasureUnitInfo)measureAssistUnitInfo, (BigDecimal)moveQty);
                        this.kdtStock.getCell(rowIndex, TB_ASSITANTQTY).setValue((Object)assistQtyNew);
                    }
                }
            } else if (moveBaseQty == null || moveBaseQty.doubleValue() <= 0.0) {
                this.kdtStock.getCell(rowIndex, TB_MOVEQTY).setValue((Object)new BigDecimal(0.0));
                this.kdtStock.getCell(rowIndex, TB_ASSITANTQTY).setValue((Object)new BigDecimal(0.0));
                this.kdtStock.getCell(rowIndex, TB_MOVEBASEQTY).setValue((Object)new BigDecimal(0.0));
            } else {
                BigDecimal qtyNew = SCMUtils.getExchangePricesionQtyForClient((String)materialId, (MeasureUnitInfo)measureBaseUnitInfo, (MeasureUnitInfo)measureUnitInfo, (BigDecimal)moveBaseQty);
                this.kdtStock.getCell(rowIndex, TB_MOVEQTY).setValue((Object)qtyNew);
                if (assistUnitId != null) {
                    MeasureUnitInfo measureAssistUnitInfo = new MeasureUnitInfo();
                    measureAssistUnitInfo.setId(BOSUuid.read((String)assistUnitId));
                    BigDecimal assistQtyNew = SCMUtils.getExchangePricesionQtyForClient((String)materialId, (MeasureUnitInfo)measureBaseUnitInfo, (MeasureUnitInfo)measureAssistUnitInfo, (BigDecimal)moveBaseQty);
                    this.kdtStock.getCell(rowIndex, TB_ASSITANTQTY).setValue((Object)assistQtyNew);
                }
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtStock.getActionMap().remove("Delete");
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtstorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_flow_stockAllocation");
        StorageOrgUnitInfo soi = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_flow_stockAllocation");
        this.prmtstorageOrgUnit.setValue((Object)soi);
        this.setDefaultWarehouseFilter(soi);
        if (this.dialog == null) {
            this.initCommonQueryDialog();
            this.dialog.init();
            QuerySolutionInfo currSolution = this.dialog.getCurrentSolutionInfo();
            if (currSolution.isIsUserDefaultSolu() && currSolution.getEntityViewInfo() != null) {
                EntityViewInfo entityViewInfo = new EntityViewInfo(currSolution.getEntityViewInfo());
                this.filterInfo = entityViewInfo.getFilter();
                this.getStockGatherByCondition(this.filterInfo);
            } else if (this.dialog.show()) {
                StockGatherMoveFilterUI stockGatherMoveFilterUI = (StockGatherMoveFilterUI)this.dialog.getUserPanel(0);
                this.filterInfo = stockGatherMoveFilterUI.getFilterInfo();
                this.getStockGatherByCondition(this.filterInfo);
            } else {
                this.tHelper.setDialog(this.dialog);
                SysUtil.abort();
            }
        }
        this.kdtStock.getSelectManager().setSelectMode(10);
        this.addListeners();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
        }
        if (this.getUIWindow() == null) {
            this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            this.dialog.setOwner((Component)((Object)this));
        }
        this.dialog.setUiObject((IUIObject)this);
        this.dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        this.dialog.setQueryObjectPK(this.mainQueryPK);
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}-{1}");
        String title = format.format(new Object[]{this.getUITitle(), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter")});
        this.dialog.setTitle(title);
        try {
            if (this.stockGatherMoveFilterUI == null) {
                this.stockGatherMoveFilterUI = new StockGatherMoveFilterUI();
                this.dialog.setShowFilter(true);
                this.dialog.setShowSorter(true);
                this.dialog.setHeight(435);
                this.dialog.setWidth(580);
                this.dialog.addUserPanel((KDPanel)this.stockGatherMoveFilterUI);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return this.dialog;
    }

    private void getStockGatherByCondition(FilterInfo filterInfo) {
        try {
            IProductionOrderStockEntry pe = ProductionOrderStockEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            IRowSet rows = pe.getStockGatherByCondition(filterInfo, this.kdPlanDate.getSqlDate());
            StockGatherMoveFilterUI filterUI = (StockGatherMoveFilterUI)this.dialog.getUserPanel(StockGatherMoveFilterUI.class.getName());
            int isTranslateID = ((BooleanAllEnum)filterUI.cmbIsTranslateID.getSelectedItem()).getValue();
            this.takeUpCatch = isTranslateID == 0 ? pe.getProductStageQty(filterInfo) : new HashMap();
            this.inventoryCatch = new HashMap();
            if (rows != null) {
                while (rows.next()) {
                    BigDecimal inventoryBaseQty = new BigDecimal(0);
                    BigDecimal takeUpBaseQty = new BigDecimal(0);
                    if (rows.getString(TB_DEFAULTWAREHOUSEID) == null) continue;
                    String key = rows.getString(TB_MATERIAL) + rows.getString(TB_DEFAULTWAREHOUSEID);
                    inventoryBaseQty = rows.getBigDecimal(TB_INVENTORYBASEQTY);
                    if (this.takeUpCatch.containsKey(key) && this.takeUpCatch.get(key) != null) {
                        takeUpBaseQty = (BigDecimal)this.takeUpCatch.get(key);
                        inventoryBaseQty = inventoryBaseQty.subtract(takeUpBaseQty);
                    }
                    BigDecimal rate = rows.getBigDecimal("rate");
                    int unitPrecision = rows.getInt("unitPrecision");
                    BigDecimal inventoryQty = inventoryBaseQty.divide(rate, unitPrecision, 4);
                    if (this.inventoryCatch.containsKey(key)) continue;
                    this.inventoryCatch.put(key, inventoryQty);
                }
                rows.beforeFirst();
                this.fillDataKdtStock(this.kdtStock, rows);
            }
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
        }
    }

    private void fillDataKdtStock(KDTable kdTable, IRowSet rowSet) {
        try {
            kdTable.checkParsed();
            ObjectValueRender avr = new ObjectValueRender();
            avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
            KDBizPromptBox storageOrgUnitBox = new KDBizPromptBox();
            storageOrgUnitBox.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageItemQuery");
            storageOrgUnitBox.setEditable(true);
            storageOrgUnitBox.setEnabledMultiSelection(false);
            storageOrgUnitBox.setDisplayFormat("$number$");
            storageOrgUnitBox.setCommitFormat("$number$");
            storageOrgUnitBox.setEditFormat("$number$");
            SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)storageOrgUnitBox, (OrgType)OrgType.Storage, (String)"mm_flow_stockAllocation");
            kdTable.getColumn(TB_STORAGEORGUNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)storageOrgUnitBox));
            kdTable.getColumn(TB_STORAGEORGUNIT).setRenderer((IBasicRender)avr);
            KDBizPromptBox warehouseBox = new KDBizPromptBox();
            warehouseBox.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
            warehouseBox.setEditable(true);
            warehouseBox.setEnabledMultiSelection(false);
            warehouseBox.setCommitFormat("$number$");
            warehouseBox.setDisplayFormat("$number$");
            warehouseBox.setEditFormat("$number$");
            EntityViewInfo viewInfo = new EntityViewInfo();
            StorageOrgUnitInfo soi = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
            if (soi != null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)soi.getId().toString(), CompareType.EQUALS));
                viewInfo.setFilter(filter);
            }
            warehouseBox.setEntityViewInfo(viewInfo);
            kdTable.getColumn(TB_WAREHOUSE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)warehouseBox));
            kdTable.getColumn(TB_WAREHOUSE).setRenderer((IBasicRender)avr);
            kdTable.removeRows();
            int columnCount = kdTable.getColumnCount();
            IRow row = null;
            while (rowSet.next()) {
                row = kdTable.addRow();
                row.getCell(TB_STORAGEORGUNIT).setValue(this.prmtstorageOrgUnit.getValue());
                for (int i = 0; i < columnCount; ++i) {
                    BigDecimal moveQty;
                    String pk;
                    if (kdTable.getColumn(i).getKey().equals(TB_DEFAULTWAREHOUSE)) {
                        if (rowSet.getString(kdTable.getColumn(i).getKey()) == null) {
                            KDBizPromptBox defaultWarehouseBox = new KDBizPromptBox();
                            defaultWarehouseBox.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseByMSAssignQuery");
                            defaultWarehouseBox.setEditable(true);
                            defaultWarehouseBox.setEnabledMultiSelection(false);
                            defaultWarehouseBox.setCommitFormat("$number$");
                            defaultWarehouseBox.setDisplayFormat("$number$");
                            defaultWarehouseBox.setEditFormat("$number$");
                            String materialId = (String)row.getCell(TB_MATERIAL).getValue();
                            EntityViewInfo viewWareHouseInfo = new EntityViewInfo();
                            FilterInfo filterHouseInfo = new FilterInfo();
                            filterHouseInfo.getFilterItems().add(new FilterItemInfo("assignMaterial.id", (Object)materialId, CompareType.EQUALS));
                            viewWareHouseInfo.setFilter(filterHouseInfo);
                            defaultWarehouseBox.setEntityViewInfo(viewWareHouseInfo);
                            row.getCell(TB_DEFAULTWAREHOUSE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)defaultWarehouseBox));
                            row.getCell(TB_STORAGEORGUNIT).setRenderer((IBasicRender)avr);
                            continue;
                        }
                        pk = rowSet.getString(kdTable.getColumn(i).getKey());
                        row.getCell(i).setValue((Object)WarehouseFactory.getRemoteInstance().getWarehouseInfo((IObjectPK)new ObjectUuidPK(pk)));
                        row.getCell(i).getStyleAttributes().setLocked(true);
                        continue;
                    }
                    if (kdTable.getColumn(i).getKey().equals(TB_WAREHOUSE)) {
                        if (rowSet.getString(kdTable.getColumn(i).getKey()) == null) continue;
                        pk = rowSet.getString(kdTable.getColumn(i).getKey());
                        SelectorItemCollection selector = new SelectorItemCollection();
                        selector.add(new SelectorItemInfo("*"));
                        selector.add(new SelectorItemInfo("storageOrg.id"));
                        selector.add(new SelectorItemInfo("storageOrg.name"));
                        selector.add(new SelectorItemInfo("storageOrg.number"));
                        WarehouseInfo moveOutWarehouse = WarehouseFactory.getRemoteInstance().getWarehouseInfo((IObjectPK)new ObjectUuidPK(pk), selector);
                        row.getCell(i).setValue((Object)moveOutWarehouse);
                        if (soi == null || moveOutWarehouse.getStorageOrg().getId().toString().equals(soi.getId().toString())) continue;
                        row.getCell(TB_STORAGEORGUNIT).setValue((Object)moveOutWarehouse.getStorageOrg());
                        KDBizPromptBox warehouseBox2 = new KDBizPromptBox();
                        warehouseBox2.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
                        warehouseBox2.setEditable(true);
                        warehouseBox2.setEnabledMultiSelection(false);
                        warehouseBox2.setCommitFormat("$number$");
                        warehouseBox2.setDisplayFormat("$number$");
                        warehouseBox2.setEditFormat("$number$");
                        EntityViewInfo viewInfo2 = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)moveOutWarehouse.getStorageOrg().getId().toString(), CompareType.EQUALS));
                        viewInfo2.setFilter(filter);
                        warehouseBox2.setEntityViewInfo(viewInfo2);
                        row.getCell(i).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)warehouseBox2));
                        continue;
                    }
                    if (kdTable.getColumn(i).getKey().equals(TB_STORAGEORGUNIT) || kdTable.getColumn(i).getKey().equals(TB_WAREHOUSE)) continue;
                    if (!kdTable.getColumn(i).getKey().equals(TB_MOVEQTY) && !kdTable.getColumn(i).getKey().equals(TB_REMARK)) {
                        kdTable.getColumn(i).getStyleAttributes().setLocked(true);
                    }
                    if (kdTable.getColumn(i).getKey().equals(TB_QTY) || kdTable.getColumn(i).getKey().equals(TB_BASEQTY)) {
                        row.getCell(i).setValue((Object)rowSet.getBigDecimal(kdTable.getColumn(i).getKey()));
                        continue;
                    }
                    if (kdTable.getColumn(i).getKey().equals(TB_INVENTORYQTY)) {
                        if (rowSet.getString(TB_DEFAULTWAREHOUSEID) == null) {
                            row.getCell(i).setValue((Object)new BigDecimal(0));
                            continue;
                        }
                        row.getCell(i).setValue((Object)((BigDecimal)this.inventoryCatch.get(rowSet.getString(TB_MATERIAL) + rowSet.getString(TB_DEFAULTWAREHOUSEID))));
                        continue;
                    }
                    if (kdTable.getColumn(i).getKey().equals(TB_INVENTORYBASEQTY)) {
                        BigDecimal inventQty = (BigDecimal)row.getCell(TB_INVENTORYQTY).getValue();
                        BigDecimal inventBaseQty = inventQty.multiply(rowSet.getBigDecimal("rate")).setScale(rowSet.getInt("basePrecision"), 4);
                        row.getCell(i).setValue((Object)inventBaseQty);
                        continue;
                    }
                    if (kdTable.getColumn(i).getKey().equals(TB_MOVEQTY)) {
                        moveQty = rowSet.getBigDecimal(TB_MOVEQTY);
                        BigDecimal qty = rowSet.getBigDecimal(TB_QTY);
                        BigDecimal inventoryQty = null;
                        if (rowSet.getString(TB_DEFAULTWAREHOUSEID) != null && this.inventoryCatch.containsKey(rowSet.getString(TB_MATERIAL) + rowSet.getString(TB_DEFAULTWAREHOUSEID))) {
                            inventoryQty = (BigDecimal)this.inventoryCatch.get(rowSet.getString(TB_MATERIAL) + rowSet.getString(TB_DEFAULTWAREHOUSEID));
                        }
                        BigDecimal rate = rowSet.getBigDecimal("rate");
                        BigDecimal transBatch = rowSet.getBigDecimal("transBatch");
                        int unitPrecision = rowSet.getInt("unitPrecision");
                        moveQty = this.calcMoveQty(qty, inventoryQty, rate, unitPrecision, transBatch, moveQty);
                        row.getCell(i).setValue((Object)moveQty);
                        continue;
                    }
                    if (kdTable.getColumn(i).getKey().equals(TB_MOVEBASEQTY)) {
                        moveQty = (BigDecimal)row.getCell(TB_MOVEQTY).getValue();
                        BigDecimal moveBaseQty = moveQty.multiply(rowSet.getBigDecimal("rate")).setScale(rowSet.getInt("basePrecision"), 4);
                        row.getCell(i).setValue((Object)moveBaseQty);
                        continue;
                    }
                    if (kdTable.getColumn(i).getKey().equals(TB_ASSITANTQTY)) {
                        BigDecimal moveBaseQty = (BigDecimal)row.getCell(TB_MOVEBASEQTY).getValue();
                        if (rowSet.getString(TB_ASSITANTUNIT) == null) continue;
                        BigDecimal assitantRate = rowSet.getBigDecimal("assitantRate");
                        int assitantPre = rowSet.getInt("assitantPre");
                        BigDecimal assitantQty = moveBaseQty.divide(assitantRate, assitantPre, 4);
                        row.getCell(i).setValue((Object)assitantQty);
                        this.assistantRateCatch.put(rowSet.getString(TB_MATERIAL), rowSet.getBigDecimal("assitantRate"));
                        continue;
                    }
                    row.getCell(i).setValue((Object)rowSet.getString(kdTable.getColumn(i).getKey()));
                }
                this.rateCatch.put(rowSet.getString(TB_MATERIAL), rowSet.getBigDecimal("rate"));
                this.transBatchCatch.put(rowSet.getString(TB_MATERIAL), rowSet.getBigDecimal("transBatch"));
                if (rowSet.getString(TB_DEFAULTWAREHOUSEID) != null) {
                    BigDecimal tempCalc = (BigDecimal)this.inventoryCatch.get(rowSet.getString(TB_MATERIAL) + rowSet.getString(TB_DEFAULTWAREHOUSEID));
                    tempCalc = tempCalc.add((BigDecimal)row.getCell(TB_MOVEQTY).getValue()).subtract(rowSet.getBigDecimal(TB_QTY));
                    this.inventoryCatch.put(rowSet.getString(TB_MATERIAL) + rowSet.getString(TB_DEFAULTWAREHOUSEID), tempCalc);
                }
                String basePrecision = rowSet.getString("basePrecision");
                String precision = rowSet.getString("unitPrecision");
                String assistPre = rowSet.getString("assitantPre");
                row.getCell(TB_BASEQTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)Integer.parseInt(basePrecision)));
                row.getCell(TB_MOVEBASEQTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)Integer.parseInt(basePrecision)));
                row.getCell(TB_MOVEBASEQTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)Integer.parseInt(basePrecision)));
                if (assistPre != null) {
                    row.getCell(TB_ASSITANTQTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)Integer.parseInt(assistPre)));
                }
                this.materialQtyCatch.put(rowSet.getString(TB_MATERIAL) + rowSet.getString(TB_DEFAULTWAREHOUSEID), rowSet.getString(TB_BASEQTY));
                if (precision == null) continue;
                row.getCell(TB_QTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)Integer.parseInt(precision)));
                row.getCell(TB_MOVEQTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)Integer.parseInt(precision)));
                KDTDefaultCellEditor kdCellUnitNumEditor = FormattedEditorFactory.getBigDecimalCellEditor((int)Integer.valueOf(precision), (boolean)false);
                row.getCell(TB_QTY).setEditor((ICellEditor)kdCellUnitNumEditor);
                row.getCell(TB_MOVEQTY).setEditor((ICellEditor)kdCellUnitNumEditor);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.repaint();
    }

    private BigDecimal calcMoveQty(BigDecimal qty, BigDecimal inventoryQty, BigDecimal rate, int unitPrecision, BigDecimal transBatchQty, BigDecimal moveQty) throws SQLException {
        if (inventoryQty == null) {
            inventoryQty = new BigDecimal(0);
        }
        if (inventoryQty.doubleValue() - qty.doubleValue() >= 0.0) {
            moveQty = new BigDecimal(0);
        } else {
            moveQty = qty.subtract(inventoryQty);
            if (transBatchQty != null && transBatchQty.doubleValue() > 0.0 && moveQty.doubleValue() % transBatchQty.doubleValue() != 0.0) {
                moveQty = transBatchQty.multiply(moveQty.divide(transBatchQty, 0, 0));
            }
        }
        return moveQty;
    }

    private void fillDataKdtOrder(KDTable kdTable, IRowSet rowSet) {
        try {
            kdTable.checkParsed();
            kdTable.removeRows();
            int columnCount = rowSet.getMetaData().getColumnCount();
            IRow row = null;
            while (rowSet.next()) {
                row = kdTable.addRow();
                for (int i = 0; i < columnCount - 1; ++i) {
                    row.getCell(i).setValue((Object)rowSet.getString(kdTable.getColumn(i).getKey()));
                }
                String precision = rowSet.getString("unitPrecision");
                row.getCell(TB_QTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)Integer.parseInt(precision)));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.repaint();
    }

    @Override
    protected void panelOrder_componentShown(ComponentEvent e) throws Exception {
        try {
            IRowSet rows = ProductionOrderStockEntryFactory.getRemoteInstance().getStockProductionOrderByCondition(this.filterInfo);
            if (rows != null) {
                this.fillDataKdtOrder(this.kdtOrder, rows);
                this.kdtOrder.getStyleAttributes().setLocked(true);
            }
        }
        catch (BOSException bose) {
            MsgBox.showInfo((Component)((Object)this), (String)bose.getMessage());
        }
    }

    protected void getStockProductionOrderByCondition(FilterInfo filterInfo) throws Exception {
        try {
            IRowSet rows = ProductionOrderStockEntryFactory.getRemoteInstance().getStockProductionOrderByCondition(filterInfo);
            if (rows != null) {
                this.fillDataKdtOrder(this.kdtOrder, rows);
                this.kdtOrder.getStyleAttributes().setLocked(true);
            }
        }
        catch (BOSException bose) {
            MsgBox.showInfo((Component)((Object)this), (String)bose.getMessage());
        }
    }

    @Override
    protected void prmtstorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtstorageOrgUnit_dataChanged(e);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtStock);
        this.prmtWarehouse.setValue(null);
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (e.getNewValue() != null) {
            StorageOrgUnitInfo orgUnit = (StorageOrgUnitInfo)e.getNewValue();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgUnit.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
        }
        this.prmtWarehouse.setEntityViewInfo(viewInfo);
        KDBizPromptBox warehouseBox = new KDBizPromptBox();
        if (selectRows.length > 0) {
            warehouseBox.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
            warehouseBox.setEditable(true);
            warehouseBox.setEnabledMultiSelection(false);
            warehouseBox.setCommitFormat("$number$");
            warehouseBox.setDisplayFormat("$number$");
            warehouseBox.setEditFormat("$number$");
            warehouseBox.setEntityViewInfo(viewInfo);
        }
        for (int i = 0; i < selectRows.length; ++i) {
            this.kdtStock.getCell(selectRows[i], TB_STORAGEORGUNIT).setValue(e.getNewValue());
            this.kdtStock.getCell(selectRows[i], TB_WAREHOUSE).setValue(null);
            this.kdtStock.getCell(selectRows[i], TB_WAREHOUSE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)warehouseBox));
        }
    }

    protected void prmtMoveInDate_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null) {
            return;
        }
        this.inventoryCatch = new HashMap();
        String[] wareHouseIds = new String[]{};
        String[] materialIds = new String[]{};
        ArrayList<String> wareHouses = new ArrayList<String>();
        ArrayList<String> materials = new ArrayList<String>();
        int len = 0;
        int j = this.kdtStock.getRowCount();
        for (int i = 0; i < j; ++i) {
            WarehouseInfo wareHouse = (WarehouseInfo)this.kdtStock.getRow(i).getCell(TB_DEFAULTWAREHOUSE).getValue();
            if (wareHouse == null) continue;
            String wareHouseId = wareHouse.getId().toString();
            String materialId = (String)this.kdtStock.getRow(i).getCell(TB_MATERIAL).getValue();
            wareHouses.add(wareHouseId);
            materials.add(materialId);
            ++len;
        }
        if (len > 0) {
            String key;
            String materialId;
            String wareHouseId;
            WarehouseInfo wareHouse;
            int i;
            wareHouseIds = wareHouses.toArray(wareHouseIds);
            materialIds = materials.toArray(materialIds);
            IProductionOrderStockEntry pe = ProductionOrderStockEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            Map result = pe.getInventoryQty(this.filterInfo, materialIds, wareHouseIds, this.kdPlanDate.getSqlDate());
            int j2 = this.kdtStock.getRowCount();
            for (i = 0; i < j2; ++i) {
                wareHouse = (WarehouseInfo)this.kdtStock.getRow(i).getCell(TB_DEFAULTWAREHOUSE).getValue();
                if (wareHouse == null) continue;
                wareHouseId = wareHouse.getId().toString();
                materialId = (String)this.kdtStock.getRow(i).getCell(TB_MATERIAL).getValue();
                key = materialId + wareHouseId;
                BigDecimal inventoryBaseQty = new BigDecimal(0);
                BigDecimal takeUpBaseQty = new BigDecimal(0);
                if (result.containsKey(key) && result.get(key) != null) {
                    inventoryBaseQty = (BigDecimal)result.get(key);
                }
                if (this.takeUpCatch.containsKey(key) && this.takeUpCatch.get(key) != null) {
                    takeUpBaseQty = (BigDecimal)this.takeUpCatch.get(key);
                    inventoryBaseQty = inventoryBaseQty.subtract(takeUpBaseQty);
                }
                if (!result.containsKey(key)) continue;
                result.put(key, inventoryBaseQty);
            }
            j2 = this.kdtStock.getRowCount();
            for (i = 0; i < j2; ++i) {
                BigDecimal qty;
                wareHouse = (WarehouseInfo)this.kdtStock.getRow(i).getCell(TB_DEFAULTWAREHOUSE).getValue();
                if (wareHouse == null) continue;
                wareHouseId = wareHouse.getId().toString();
                materialId = (String)this.kdtStock.getRow(i).getCell(TB_MATERIAL).getValue();
                key = materialId + wareHouseId;
                BigDecimal transBatch = (BigDecimal)this.transBatchCatch.get(materialId);
                BigDecimal rate = (BigDecimal)this.rateCatch.get(materialId);
                BigDecimal assitantRate = (BigDecimal)this.assistantRateCatch.get(materialId);
                String unit = (String)this.kdtStock.getRow(i).getCell(TB_UNIT).getValue();
                String baseUnit = (String)this.kdtStock.getRow(i).getCell(TB_BASEUNIT).getValue();
                BigDecimal moveQty = qty = (BigDecimal)this.kdtStock.getRow(i).getCell(TB_QTY).getValue();
                IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
                MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialId, unit);
                MultiMeasureUnitInfo baseMultiUnifInfo = multiUnit.getMultiUnit(materialId, baseUnit);
                BigDecimal inventoryBaseQty = (BigDecimal)result.get(key);
                BigDecimal inventoryQty = inventoryBaseQty.divide(rate, multiUnifInfo.getQtyPrecision(), 4);
                if (this.inventoryCatch.containsKey(key)) {
                    inventoryQty = (BigDecimal)this.inventoryCatch.get(key);
                }
                moveQty = this.calcMoveQty(qty, inventoryQty, rate, multiUnifInfo.getQtyPrecision(), transBatch, moveQty);
                this.kdtStock.getRow(i).getCell(TB_MOVEQTY).setValue((Object)moveQty);
                BigDecimal moveBaseQty = moveQty.multiply(rate).setScale(baseMultiUnifInfo.getQtyPrecision(), 4);
                this.kdtStock.getRow(i).getCell(TB_MOVEBASEQTY).setValue((Object)moveBaseQty);
                if (assitantRate != null) {
                    BigDecimal assitantQty = moveBaseQty.divide(assitantRate, 4);
                    this.kdtStock.getRow(i).getCell(TB_ASSITANTQTY).setValue((Object)assitantQty);
                }
                if (inventoryQty == null) {
                    this.kdtStock.getRow(i).getCell(TB_INVENTORYQTY).setValue((Object)new BigDecimal(0.0));
                    this.kdtStock.getRow(i).getCell(TB_INVENTORYBASEQTY).setValue((Object)new BigDecimal(0.0));
                } else {
                    this.kdtStock.getRow(i).getCell(TB_INVENTORYQTY).setValue((Object)inventoryQty);
                    this.kdtStock.getRow(i).getCell(TB_INVENTORYBASEQTY).setValue((Object)inventoryQty.multiply(rate).setScale(baseMultiUnifInfo.getQtyPrecision(), 4));
                }
                BigDecimal tempCalc = inventoryQty.add(moveQty).subtract(qty);
                this.inventoryCatch.put(key, tempCalc);
            }
        }
    }

    @Override
    protected void prmtWarehouse_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtWarehouse_dataChanged(e);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtStock);
        for (int i = 0; i < selectRows.length; ++i) {
            StorageOrgUnitInfo orgUnit = (StorageOrgUnitInfo)this.kdtStock.getCell(selectRows[i], TB_STORAGEORGUNIT).getValue();
            if (orgUnit != this.prmtstorageOrgUnit.getValue() && (orgUnit == null || this.prmtstorageOrgUnit.getValue() == null || !orgUnit.getId().toString().equals(((StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue()).getId().toString()))) continue;
            this.kdtStock.getCell(selectRows[i], TB_WAREHOUSE).setValue(e.getNewValue());
        }
    }

    @Override
    public void actionPreview_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtStock);
        if (selectRows == null || selectRows.length <= 0) {
            MsgBox.showInfo((String)this.getResourceMsg("stockGather_notRow"));
        } else {
            StockGatherMoveDataProvider data = new StockGatherMoveDataProvider(this.kdtStock);
            KDNoteHelper appHlp = new KDNoteHelper();
            appHlp.printPreview(null, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtStock);
        if (selectRows == null || selectRows.length <= 0) {
            MsgBox.showInfo((String)this.getResourceMsg("stockGather_notRow"));
        } else {
            StockGatherMoveDataProvider data = new StockGatherMoveDataProvider(this.kdtStock);
            KDNoteHelper appHlp = new KDNoteHelper();
            appHlp.print(null, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    public KDTable getTableForCommon() {
        return this.kdtStock;
    }

    @Override
    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
        this.logExport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionLinkBuild_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkBuild_actionPerformed(e);
        try {
            this.setOprtState("STATUS_ADDNEW");
            if (this.verify()) {
                this.showSuccessMsg(this.getResourceMsg("stockGatherStart"));
                StorageOrgUnitInfo currentSou = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_flow_stockAllocation");
                BOSUuid currentSouUuid = currentSou.getId();
                HashMapObject collectionMap = new HashMapObject();
                int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtStock);
                int[] zeroRows = new int[selectRows.length];
                int index = 0;
                ObjectUuidPK billTypePK = new ObjectUuidPK("ejIZHXXTQliYCQJg9t4Re0Y+1VI=");
                BillTypeInfo billTypeInfo = BillTypeFactory.getRemoteInstance().getBillTypeInfo((IObjectPK)billTypePK);
                for (int i = 0; i < selectRows.length; ++i) {
                    HashMapObject detailMap;
                    StorageOrgUnitInfo issueStorageOrgUnit = (StorageOrgUnitInfo)this.kdtStock.getCell(selectRows[i], TB_STORAGEORGUNIT).getValue();
                    BOSUuid issueSouUuid = issueStorageOrgUnit.getId();
                    String issueSouId = issueSouUuid.toString();
                    if (collectionMap.containsKey(issueSouId)) {
                        HashMapObject entityMap = (HashMapObject)collectionMap.get(issueSouId);
                        String strBillType = (String)entityMap.get("billType");
                        if (strBillType.equals("1")) {
                            StockTransferBillInfo stockTransferBillInfo = (StockTransferBillInfo)entityMap.get("stockTransferBillInfo");
                            StockTransferBillInfo entityStockTransferBillInfo = this.buildStockTransferBillInfo(selectRows[i], issueStorageOrgUnit, currentSou, billTypeInfo);
                            if (entityStockTransferBillInfo != null) {
                                StockTransferBillEntryInfo stockTransferBillEntryInfo = entityStockTransferBillInfo.getEntry().get(0);
                                stockTransferBillEntryInfo.setParent(stockTransferBillInfo);
                                stockTransferBillInfo.getEntry().add(stockTransferBillEntryInfo);
                                continue;
                            }
                            zeroRows[index] = selectRows[i] + 1;
                            ++index;
                            continue;
                        }
                        TransferOrderBillInfo transferOrderBillInfo = (TransferOrderBillInfo)entityMap.get("transferOrderBillInfo");
                        TransferOrderBillInfo entityTransferOrderBillInfo = this.buildTransferOrderBillInfo(selectRows[i], issueStorageOrgUnit, currentSou, billTypeInfo);
                        if (entityTransferOrderBillInfo != null) {
                            TransferOrderBillEntryInfo transferOrderBillEntryInfo = entityTransferOrderBillInfo.getEntry().get(0);
                            transferOrderBillEntryInfo.setParent(transferOrderBillInfo);
                            transferOrderBillInfo.getEntry().add(transferOrderBillEntryInfo);
                            continue;
                        }
                        zeroRows[index] = selectRows[i] + 1;
                        ++index;
                        continue;
                    }
                    if (this.compareCompanyInfo(issueSouUuid, currentSouUuid)) {
                        StockTransferBillInfo stockTransferBillInfo = this.buildStockTransferBillInfo(selectRows[i], issueStorageOrgUnit, currentSou, billTypeInfo);
                        if (stockTransferBillInfo != null) {
                            detailMap = new HashMapObject();
                            detailMap.put("billType", (Object)"1");
                            detailMap.put("stockTransferBillInfo", (Object)stockTransferBillInfo);
                            collectionMap.put(issueSouId, (Object)detailMap);
                            continue;
                        }
                        zeroRows[index] = selectRows[i] + 1;
                        ++index;
                        continue;
                    }
                    TransferOrderBillInfo transferOrderBillInfo = this.buildTransferOrderBillInfo(selectRows[i], issueStorageOrgUnit, currentSou, billTypeInfo);
                    if (transferOrderBillInfo != null) {
                        detailMap = new HashMapObject();
                        detailMap.put("billType", (Object)"0");
                        detailMap.put("transferOrderBillInfo", (Object)transferOrderBillInfo);
                        collectionMap.put(issueSouId, (Object)detailMap);
                        continue;
                    }
                    zeroRows[index] = selectRows[i] + 1;
                    ++index;
                }
                if (index > 0) {
                    StringBuffer rowNum = new StringBuffer();
                    for (int i = 0; i < index; ++i) {
                        rowNum.append(String.valueOf(zeroRows[i]) + ",");
                    }
                    if (MsgBox.showConfirm2New((Component)((Object)this), (String)this.getResourceMsg("stockGatherNotice", new String[]{rowNum.replace(rowNum.length() - 1, rowNum.length(), "").toString()})) == 1) {
                        return;
                    }
                }
                int successNum = 0;
                successNum = ProductionOrderStockEntryFactory.getRemoteInstance().totleAddNewAndBackWrite(collectionMap, this.filterInfo, currentSou.getId().toString());
                this.getStockGatherByCondition(this.filterInfo);
                this.showSuccessMsg(this.getResourceMsg("stockGatherEnd", new String[]{String.valueOf(successNum)}));
            }
        }
        catch (Exception ex) {
            MsgBox.showError((Component)((Object)this), (String)ex.getMessage());
        }
        finally {
            this.setOprtState("RELEASEALL");
        }
    }

    private TransferOrderBillInfo buildTransferOrderBillInfo(int intSelectRow, StorageOrgUnitInfo issueStorageOrgUnit, StorageOrgUnitInfo currentSou, BillTypeInfo billTypeInfo) throws Exception {
        String baseUnit;
        String unitId;
        TransferOrderBillInfo transferOrderBillInfo = new TransferOrderBillInfo();
        FilterInfo checkFilterInfo = (FilterInfo)this.filterInfo.clone();
        FilterItemCollection checkItems = checkFilterInfo.getFilterItems();
        String materId = (String)this.kdtStock.getCell(intSelectRow, TB_MATERIAL).getValue();
        String receiptWarehouseId = (String)this.kdtStock.getCell(intSelectRow, TB_DEFAULTWAREHOUSEID).getValue();
        String moveOutWarehouseId = (String)this.kdtStock.getCell(intSelectRow, TB_WAREHOUSEID).getValue();
        String beforeNumber = (String)this.materialQtyCatch.get(materId + receiptWarehouseId);
        checkItems.add(new FilterItemInfo("materialId", (Object)materId, CompareType.EQUALS));
        checkItems.add(new FilterItemInfo("defaultWarehouseId", (Object)receiptWarehouseId, CompareType.EQUALS));
        checkItems.add(new FilterItemInfo("moveOutWarehouseId", (Object)moveOutWarehouseId, CompareType.EQUALS));
        checkItems.add(new FilterItemInfo("beforeNumber", (Object)beforeNumber));
        if (this.checkTransferBillExisted(checkFilterInfo)) {
            throw new Exception(this.getResourceMsg("stockGather_mutex"));
        }
        BigDecimal qty = (BigDecimal)this.kdtStock.getCell(intSelectRow, TB_QTY).getValue();
        BigDecimal baseQty = (BigDecimal)this.kdtStock.getCell(intSelectRow, TB_BASEQTY).getValue();
        BigDecimal moveQty = (BigDecimal)this.kdtStock.getCell(intSelectRow, TB_MOVEQTY).getValue();
        BigDecimal moveBaseQty = (BigDecimal)this.kdtStock.getCell(intSelectRow, TB_MOVEBASEQTY).getValue();
        if (moveBaseQty == null || moveBaseQty.doubleValue() <= 0.0) {
            return null;
        }
        CompanyOrgUnitInfo companyOrgUnit = null;
        if (this.companyCatch.containsKey(issueStorageOrgUnit.getId().toString())) {
            companyOrgUnit = (CompanyOrgUnitInfo)this.companyCatch.get(issueStorageOrgUnit.getId().toString());
        } else {
            companyOrgUnit = SCMClientUtils.getCompanyInfo((BOSUuid)issueStorageOrgUnit.getId());
            this.companyCatch.put(issueStorageOrgUnit.getId().toString(), companyOrgUnit);
        }
        CompanyOrgUnitInfo currentCompanyOrgUnit = null;
        if (this.companyCatch.containsKey(currentSou.getId().toString())) {
            currentCompanyOrgUnit = (CompanyOrgUnitInfo)this.companyCatch.get(currentSou.getId().toString());
        } else {
            currentCompanyOrgUnit = SCMClientUtils.getCompanyInfo((BOSUuid)currentSou.getId());
            this.companyCatch.put(currentSou.getId().toString(), currentCompanyOrgUnit);
        }
        transferOrderBillInfo.setIssueCompanyOrgUnit(companyOrgUnit);
        transferOrderBillInfo.setIssueStorageOrgUnit(issueStorageOrgUnit);
        transferOrderBillInfo.setReceiptStorageOrgUnit(currentSou);
        transferOrderBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        transferOrderBillInfo.setSourceBillType(billTypeInfo);
        transferOrderBillInfo.setBizDate(new Date());
        BizTypeInfo bizType = null;
        if (this.bizTypeCatch.containsKey("d8e80652-0117-1000-e000-04c5c0a812202407435C")) {
            bizType = (BizTypeInfo)this.bizTypeCatch.get("d8e80652-0117-1000-e000-04c5c0a812202407435C");
        } else {
            ObjectUuidPK bizTypePK = new ObjectUuidPK("d8e80652-0117-1000-e000-04c5c0a812202407435C");
            bizType = BizTypeFactory.getRemoteInstance().getBizTypeInfo((IObjectPK)bizTypePK);
            transferOrderBillInfo.setBizType(bizType);
            this.bizTypeCatch.put("d8e80652-0117-1000-e000-04c5c0a812202407435C", bizType);
        }
        TransferOrderBillEntryInfo transferOrderBillEntryInfo = new TransferOrderBillEntryInfo();
        transferOrderBillEntryInfo.setParent(transferOrderBillInfo);
        if (materId != null && materId.trim().length() != 0) {
            MaterialInfo materialInfo = new MaterialInfo();
            materialInfo.setId(BOSUuid.read((String)materId));
            transferOrderBillEntryInfo.setMaterial(materialInfo);
        }
        if ((unitId = (String)this.kdtStock.getCell(intSelectRow, TB_UNIT).getValue()) != null && unitId.trim().length() != 0) {
            MeasureUnitInfo measureUnitInfo = new MeasureUnitInfo();
            measureUnitInfo.setId(BOSUuid.read((String)unitId));
            transferOrderBillEntryInfo.setUnit(measureUnitInfo);
        }
        if ((baseUnit = (String)this.kdtStock.getCell(intSelectRow, TB_BASEUNIT).getValue()) != null && baseUnit.trim().length() != 0) {
            MeasureUnitInfo measureUnitInfo = new MeasureUnitInfo();
            measureUnitInfo.setId(BOSUuid.read((String)baseUnit));
            transferOrderBillEntryInfo.setBaseUnit(measureUnitInfo);
        }
        transferOrderBillEntryInfo.setQty(moveQty);
        transferOrderBillEntryInfo.setBaseQty(moveBaseQty);
        String assistUnitId = (String)this.kdtStock.getCell(intSelectRow, TB_ASSITANTUNIT).getValue();
        BigDecimal assistUnitQty = (BigDecimal)this.kdtStock.getCell(intSelectRow, TB_ASSITANTQTY).getValue();
        if (assistUnitId != null && assistUnitId.trim().length() != 0) {
            MeasureUnitInfo assistUnit = new MeasureUnitInfo();
            assistUnit.setId(BOSUuid.read((String)assistUnitId));
            transferOrderBillEntryInfo.setAssistUnit(assistUnit);
            transferOrderBillEntryInfo.setAssistQty(assistUnitQty);
        }
        transferOrderBillEntryInfo.setIssueStorageOrgUnit(issueStorageOrgUnit);
        WarehouseInfo warehouseInfo = (WarehouseInfo)this.kdtStock.getCell(intSelectRow, TB_WAREHOUSE).getValue();
        if (warehouseInfo != null) {
            transferOrderBillEntryInfo.setIssueWarehouse(warehouseInfo);
        }
        transferOrderBillEntryInfo.setReceiveStorageOrgUnit(currentSou);
        transferOrderBillEntryInfo.setReceiveCompanyOrgUnit(currentCompanyOrgUnit);
        WarehouseInfo defaultWarehouse = (WarehouseInfo)this.kdtStock.getCell(intSelectRow, TB_DEFAULTWAREHOUSE).getValue();
        transferOrderBillEntryInfo.setReceiptWarehouse(defaultWarehouse);
        transferOrderBillEntryInfo.setManuWarehouseId(receiptWarehouseId);
        transferOrderBillEntryInfo.setReceiptPlanDate((Date)this.kdPlanDate.getSqlDate());
        transferOrderBillEntryInfo.setRemark((String)this.kdtStock.getCell(intSelectRow, TB_REMARK).getValue());
        transferOrderBillEntryInfo.setIssueCompanyOrgUnit(companyOrgUnit);
        transferOrderBillEntryInfo.put("defaultMoveOutWarehouseId", (Object)moveOutWarehouseId);
        transferOrderBillInfo.getEntry().add(transferOrderBillEntryInfo);
        return transferOrderBillInfo;
    }

    private StockTransferBillInfo buildStockTransferBillInfo(int intSelectRow, StorageOrgUnitInfo issueStorageOrgUnit, StorageOrgUnitInfo currentSou, BillTypeInfo billTypeInfo) throws Exception {
        String baseUnit;
        String unitId;
        ObjectUuidPK bizTypePK;
        BizTypeInfo bizType;
        BOSUuid issueSouUuid = issueStorageOrgUnit.getId();
        String issueSouId = issueSouUuid.toString();
        BOSUuid currentSouUuid = currentSou.getId();
        String currentSouId = currentSouUuid.toString();
        StockTransferBillInfo stockTransferBillInfo = new StockTransferBillInfo();
        FilterInfo checkFilterInfo = (FilterInfo)this.filterInfo.clone();
        FilterItemCollection checkItems = checkFilterInfo.getFilterItems();
        String materId = (String)this.kdtStock.getCell(intSelectRow, TB_MATERIAL).getValue();
        String receiptWarehouseId = (String)this.kdtStock.getCell(intSelectRow, TB_DEFAULTWAREHOUSEID).getValue();
        String moveOutWarehouseId = (String)this.kdtStock.getCell(intSelectRow, TB_WAREHOUSEID).getValue();
        String beforeNumber = (String)this.materialQtyCatch.get(materId + receiptWarehouseId);
        checkItems.add(new FilterItemInfo("materialId", (Object)materId, CompareType.EQUALS));
        checkItems.add(new FilterItemInfo("defaultWarehouseId", (Object)receiptWarehouseId, CompareType.EQUALS));
        checkItems.add(new FilterItemInfo("moveOutWarehouseId", (Object)moveOutWarehouseId, CompareType.EQUALS));
        checkItems.add(new FilterItemInfo("beforeNumber", (Object)beforeNumber));
        if (this.checkTransferBillExisted(checkFilterInfo)) {
            throw new Exception(this.getResourceMsg("stockGather_mutex"));
        }
        BigDecimal qty = (BigDecimal)this.kdtStock.getCell(intSelectRow, TB_QTY).getValue();
        BigDecimal baseQty = (BigDecimal)this.kdtStock.getCell(intSelectRow, TB_BASEQTY).getValue();
        BigDecimal moveQty = (BigDecimal)this.kdtStock.getCell(intSelectRow, TB_MOVEQTY).getValue();
        BigDecimal moveBaseQty = (BigDecimal)this.kdtStock.getCell(intSelectRow, TB_MOVEBASEQTY).getValue();
        if (moveBaseQty == null || moveBaseQty.doubleValue() <= 0.0) {
            return null;
        }
        stockTransferBillInfo.setIssueStorageOrgUnit(issueStorageOrgUnit);
        CompanyOrgUnitInfo companyOrgUnit = null;
        if (this.companyCatch.containsKey(issueStorageOrgUnit.getId().toString())) {
            companyOrgUnit = (CompanyOrgUnitInfo)this.companyCatch.get(issueStorageOrgUnit.getId().toString());
        } else {
            companyOrgUnit = SCMClientUtils.getCompanyInfo((BOSUuid)issueStorageOrgUnit.getId());
            this.companyCatch.put(issueStorageOrgUnit.getId().toString(), companyOrgUnit);
        }
        stockTransferBillInfo.setIssueCompanyOrgUnit(companyOrgUnit);
        stockTransferBillInfo.setReceiptStorageOrgUnit(currentSou);
        stockTransferBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        stockTransferBillInfo.setSourceBillType(billTypeInfo);
        stockTransferBillInfo.setBizDate(new Date());
        if (currentSouId.equals(issueSouId)) {
            bizType = null;
            if (this.bizTypeCatch.containsKey("d8e80652-011b-1000-e000-04c5c0a812202407435C")) {
                bizType = (BizTypeInfo)this.bizTypeCatch.get("d8e80652-011b-1000-e000-04c5c0a812202407435C");
            } else {
                bizTypePK = new ObjectUuidPK("d8e80652-011b-1000-e000-04c5c0a812202407435C");
                bizType = BizTypeFactory.getRemoteInstance().getBizTypeInfo((IObjectPK)bizTypePK);
                stockTransferBillInfo.setBizType(bizType);
                this.bizTypeCatch.put("d8e80652-011b-1000-e000-04c5c0a812202407435C", bizType);
            }
        } else {
            bizType = null;
            if (this.bizTypeCatch.containsKey("d8e80652-011a-1000-e000-04c5c0a812202407435C")) {
                bizType = (BizTypeInfo)this.bizTypeCatch.get("d8e80652-011a-1000-e000-04c5c0a812202407435C");
            } else {
                bizTypePK = new ObjectUuidPK("d8e80652-011a-1000-e000-04c5c0a812202407435C");
                bizType = BizTypeFactory.getRemoteInstance().getBizTypeInfo((IObjectPK)bizTypePK);
                stockTransferBillInfo.setBizType(bizType);
                this.bizTypeCatch.put("d8e80652-011a-1000-e000-04c5c0a812202407435C", bizType);
            }
        }
        StockTransferBillEntryInfo stockTransferBillEntryInfo = new StockTransferBillEntryInfo();
        stockTransferBillEntryInfo.setParent(stockTransferBillInfo);
        if (materId != null && materId.trim().length() != 0) {
            MaterialInfo materialInfo = new MaterialInfo();
            materialInfo.setId(BOSUuid.read((String)materId));
            stockTransferBillEntryInfo.setMaterial(materialInfo);
        }
        if ((unitId = (String)this.kdtStock.getCell(intSelectRow, TB_UNIT).getValue()) != null && unitId.trim().length() != 0) {
            MeasureUnitInfo measureUnitInfo = new MeasureUnitInfo();
            measureUnitInfo.setId(BOSUuid.read((String)unitId));
            stockTransferBillEntryInfo.setUnit(measureUnitInfo);
        }
        if ((baseUnit = (String)this.kdtStock.getCell(intSelectRow, TB_BASEUNIT).getValue()) != null && baseUnit.trim().length() != 0) {
            MeasureUnitInfo measureUnitInfo = new MeasureUnitInfo();
            measureUnitInfo.setId(BOSUuid.read((String)baseUnit));
            stockTransferBillEntryInfo.setBaseUnit(measureUnitInfo);
        }
        String assistUnitId = (String)this.kdtStock.getCell(intSelectRow, TB_ASSITANTUNIT).getValue();
        BigDecimal assistUnitQty = (BigDecimal)this.kdtStock.getCell(intSelectRow, TB_ASSITANTQTY).getValue();
        if (assistUnitId != null && assistUnitId.trim().length() != 0) {
            MeasureUnitInfo assistUnit = new MeasureUnitInfo();
            assistUnit.setId(BOSUuid.read((String)assistUnitId));
            stockTransferBillEntryInfo.setAssistUnit(assistUnit);
            stockTransferBillEntryInfo.setAssistQty(assistUnitQty);
        }
        stockTransferBillEntryInfo.setQty(moveQty);
        stockTransferBillEntryInfo.setBaseQty(moveBaseQty);
        WarehouseInfo warehouseInfo = (WarehouseInfo)this.kdtStock.getCell(intSelectRow, TB_WAREHOUSE).getValue();
        if (warehouseInfo != null) {
            stockTransferBillEntryInfo.setIssueWarehouse(warehouseInfo);
        }
        WarehouseInfo defaultWarehouseInfo = (WarehouseInfo)this.kdtStock.getCell(intSelectRow, TB_DEFAULTWAREHOUSE).getValue();
        stockTransferBillEntryInfo.setReceiptWarehouse(defaultWarehouseInfo);
        stockTransferBillEntryInfo.setManuWarehouseId(receiptWarehouseId);
        stockTransferBillEntryInfo.setReceiptPlanDate((Date)this.kdPlanDate.getSqlDate());
        stockTransferBillEntryInfo.setRemark((String)this.kdtStock.getCell(intSelectRow, TB_REMARK).getValue());
        stockTransferBillEntryInfo.setIssueCompanyOrgUnit(companyOrgUnit);
        stockTransferBillEntryInfo.put("defaultMoveOutWarehouseId", (Object)moveOutWarehouseId);
        stockTransferBillInfo.getEntry().add(stockTransferBillEntryInfo);
        return stockTransferBillInfo;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.initCommonQueryDialog();
        this.stockGatherMoveFilterUI.getUIContext().clear();
        this.stockGatherMoveFilterUI.getUIContext().putAll(this.getUIContext());
        if (this.dialog.show()) {
            StockGatherMoveFilterUI stockGatherMoveFilterUI = (StockGatherMoveFilterUI)this.dialog.getUserPanel(0);
            this.filterInfo = stockGatherMoveFilterUI.getFilterInfo();
            this.getStockGatherByCondition(this.filterInfo);
            if (!"panelStock".equals(this.tabStockOrder.getSelectedComponent().getName())) {
                this.getStockProductionOrderByCondition(this.filterInfo);
            }
        } else {
            this.tHelper.setDialog(this.dialog);
            SysUtil.abort();
        }
    }

    public boolean verify() throws Exception {
        boolean bRet = true;
        StringBuffer showInfo = new StringBuffer();
        StockGatherMoveFilterUI filterUI = (StockGatherMoveFilterUI)this.dialog.getUserPanel(StockGatherMoveFilterUI.class.getName());
        int isTranslateID = ((BooleanAllEnum)filterUI.cmbIsTranslateID.getSelectedItem()).getValue();
        int orderStatus = new Integer(((BillBaseStatusEnum)filterUI.cmbProductionOrderStatus.getSelectedItem()).getValue());
        if (isTranslateID == 0) {
            if (orderStatus != 4 && orderStatus != 5) {
                showInfo.append(this.getResourceMsg("stockGather_not_orderStatus") + "\n");
                bRet = false;
            }
        } else {
            showInfo.append(this.getResourceMsg("stockGather_orderStatus") + "\n");
            bRet = false;
        }
        if (bRet) {
            int[] selectRows;
            if (new Date().after((Date)this.kdPlanDate.getValue())) {
                showInfo.append(this.getResourceMsg("stockGather_planDate") + "\n");
                bRet = false;
            }
            if ((selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtStock)) == null || selectRows.length <= 0) {
                showInfo.append(this.getResourceMsg("stockGather_notRow") + "\n");
                bRet = false;
            }
            for (int i = 0; i < selectRows.length; ++i) {
                WarehouseInfo warehouse;
                StorageOrgUnitInfo storageOrgUnit;
                int len = selectRows[i] + 1;
                WarehouseInfo warehouseInfo = (WarehouseInfo)this.kdtStock.getCell(selectRows[i], TB_DEFAULTWAREHOUSE).getValue();
                if (warehouseInfo == null) {
                    showInfo.append(this.getResourceMsg("stockGather_defaultWareHouse", new String[]{String.valueOf(len)}) + "\n");
                    bRet = false;
                }
                if ((storageOrgUnit = (StorageOrgUnitInfo)this.kdtStock.getCell(selectRows[i], TB_STORAGEORGUNIT).getValue()) == null || storageOrgUnit.getId().toString().equals("")) {
                    showInfo.append(this.getResourceMsg("stockGather_storageorgUnit", new String[]{String.valueOf(len)}) + "\n");
                    bRet = false;
                }
                if ((warehouse = (WarehouseInfo)this.kdtStock.getCell(selectRows[i], TB_WAREHOUSE).getValue()) == null || warehouse.getId().toString().equals("")) {
                    showInfo.append(this.getResourceMsg("stockGather_warehouse", new String[]{String.valueOf(len)}) + "\n");
                    bRet = false;
                }
                if (warehouseInfo == null || warehouse == null || !warehouseInfo.getId().toString().equals(warehouse.getId().toString())) continue;
                showInfo.append(this.getResourceMsg2("stockGather_warehouseNoSame", new String[]{String.valueOf(len)}) + "\n");
                bRet = false;
            }
        }
        if (!bRet) {
            MsgBox.showInfo((String)showInfo.toString());
        }
        return bRet;
    }

    private boolean compareCompanyInfo(BOSUuid storageOrgUnitID, BOSUuid companyOrgUnitID) throws EASBizException, BOSException {
        boolean bRet = true;
        CompanyOrgUnitInfo storageOrgUnit = null;
        CompanyOrgUnitInfo companyOrgUnit = null;
        if (this.companyCatch.containsKey(storageOrgUnitID.toString())) {
            storageOrgUnit = (CompanyOrgUnitInfo)this.companyCatch.get(storageOrgUnitID.toString());
        } else {
            storageOrgUnit = SCMClientUtils.getCompanyInfo((BOSUuid)storageOrgUnitID);
            this.companyCatch.put(storageOrgUnitID.toString(), storageOrgUnit);
        }
        if (this.companyCatch.containsKey(companyOrgUnitID.toString())) {
            companyOrgUnit = (CompanyOrgUnitInfo)this.companyCatch.get(companyOrgUnitID.toString());
        } else {
            companyOrgUnit = SCMClientUtils.getCompanyInfo((BOSUuid)companyOrgUnitID);
            this.companyCatch.put(companyOrgUnitID.toString(), companyOrgUnit);
        }
        if (storageOrgUnit != null && companyOrgUnit != null) {
            bRet = storageOrgUnit.getId().toString().equals(companyOrgUnit.getId().toString());
        }
        return bRet;
    }

    private boolean checkTransferBillExisted(FilterInfo filterInfo) throws Exception {
        return ProductionOrderStockEntryFactory.getRemoteInstance().checkTransferBillExisted(filterInfo);
    }

    protected String getOnloadPermItemName() {
        return "mm_flow_stockAllocation";
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(msgResource);
        this.showMessage();
    }

    private String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RES_PRD_ORDER, (String)key);
    }

    private String getResourceMsg2(String key) {
        return ResourceUtils.getMessage((String)RES_PRD_NEXT_ORDER, (String)key);
    }

    private String getResourceMsg(String key, String[] params) {
        return ResourceUtils.getMessage((String)RES_PRD_ORDER, (String)key, (String[])params);
    }

    private String getResourceMsg2(String key, String[] params) {
        return ResourceUtils.getMessage((String)RES_PRD_NEXT_ORDER, (String)key, (String[])params);
    }

    protected void logExport() {
        ProductionOrderStockEntryInfo stockEntryInfo = new ProductionOrderStockEntryInfo();
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)stockEntryInfo.getBOSType(), null, (String)this.getResourceMsg("stockGather_export"), (String)"mm_flow_stockAllocation");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.panelStock.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 996, 551));
        this.panelOrder.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 996, 551));
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        ProductLotNoTraceDataProvider data = new ProductLotNoTraceDataProvider(this.kdtStock, this.kdtOrder, this.filterInfo, this.materialCatch);
        if (data.getSelRowIndexLst() == null || data.getSelRowIndexLst().length < 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.control.ProductionOrderResource.ExportVerify_Msg2"));
            return;
        }
        super.actionExportSelected_actionPerformed(e);
    }

    private String getNumberFormat(String precision) {
        int len = Integer.parseInt(precision);
        StringBuffer result = new StringBuffer();
        result.append("%{0");
        if (len > 0) {
            result.append(".");
        }
        for (int i = 0; i < len; ++i) {
            result.append("0");
        }
        result.append("}f");
        return result.toString();
    }
}

