/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.util.UIConfigUtility;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.control.IStockGatherMove;
import com.kingdee.eas.mm.control.IStockGatherMoveEntry;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.StockGatherMoveEntryCollection;
import com.kingdee.eas.mm.control.StockGatherMoveEntryFactory;
import com.kingdee.eas.mm.control.StockGatherMoveEntryInfo;
import com.kingdee.eas.mm.control.StockGatherMoveFactory;
import com.kingdee.eas.mm.control.client.AbstractStockGatherSourceQueryUI;
import com.kingdee.eas.mm.control.client.ProductionOrderEditUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class StockGatherSourceQueryUI
extends AbstractStockGatherSourceQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(StockGatherSourceQueryUI.class);
    private static final String TB_PS_ID = "id";
    private static final String TB_PS_STORORGUNITID = "FStorageOrgUnitID";
    private static final String TB_PS_STORORGUNITNAME = "FStorageOrgUnitName";
    private static final String TB_PS_NUMBER = "FNumber";
    private static final String TB_PS_LINENUM = "FLineNo";
    private static final String TB_PS_ENTRYID = "FEntryID";
    private static final String TB_PS_MATERIALID = "FMaterialID";
    private static final String TB_PS_MATERIALNUM = "FMaterialNum";
    private static final String TB_PS_MATERIALNAME = "FMaterialName";
    private static final String TB_PS_MODEL = "FModel";
    private static final String TB_PS_FUNIT = "FUnit";
    private static final String TB_PS_FLOTNO = "FLotNo";
    private static final String TB_PS_REQQTY = "FQty";
    private static final String TB_PS_MOVEQTY = "FMoveQty";
    private static final String TB_PS_MOVEINPLANDATE = "FMoveInPlanDate";
    private static final String TB_PS_MOVEOUTSTORAGE = "FMoveOutStorageOrgUnit";
    private static final String TB_PS_MOVEOUTWAREHOUSE = "FMoveOutWarehouse";
    private static final String TB_PS_WAREHOUSE = "FWarehouse";
    private static final String TB_PS_WAREHOUSEID = "FWarehouseId";
    private static final String TB_PS_MOVEOUTSTORAGEID = "moveOutStorageOrgUnitId";
    private static final String TB_PS_MOVEOUTWAREHOUSEID = "moveOutWareHouseId";
    private static final String TB_ST_ID = "id";
    private static final String TB_ST_ORDERNUMBER = "orderNum";
    private static final String TB_ST_SEQ = "stockSeq";
    private static final String TB_ST_QTY = "qty";
    private static final String TB_ST_STARTDATE = "startDate";
    private static final String TB_ST_ENDDATE = "endDate";
    private static final String[] QTYPRECISIONFROMUNITTAB = new String[]{"FQty", "FMoveQty"};
    private Set userStorOrgSet = null;
    public static final String RES_STOCKGATHER = "com.kingdee.eas.mm.control.StockGatherResource";
    private static final String[] TPS_DATES = new String[]{"FMoveInPlanDate"};
    private static final String[] TST_DATES = new String[]{"startDate", "endDate"};

    public void onLoad() throws Exception {
        super.onLoad();
        EditTableUtil.formatColDate((KDTable)this.tblPSBill, (String[])TPS_DATES);
        EditTableUtil.formatColDate((KDTable)this.tblInventory, (String[])TST_DATES);
    }

    protected Set getUserStorOrgSet() {
        return this.userStorOrgSet;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblPSBill.getSelectManager().setSelectMode(2);
        this.tblPSBill.getStyleAttributes().setLocked(true);
        this.tblInventory.getSelectManager().setSelectMode(2);
        this.tblInventory.getStyleAttributes().setLocked(true);
        String isSingle = (String)this.getUIContext().get("isSingle");
        if ("1".equals(isSingle)) {
            this.tblPSBill.getColumn(TB_PS_STORORGUNITNAME).getStyleAttributes().setHided(true);
            this.tblPSBill.getColumn(TB_PS_NUMBER).getStyleAttributes().setHided(true);
        }
        this.tblPSBillInsertRows();
    }

    private void tblPSBillInsertRows() throws Exception {
        this.tblPSBill.removeRows();
        ArrayList idList = (ArrayList)this.getUIContext().get("idList");
        StockGatherMoveEntryCollection psbeCol = null;
        if (idList != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("moveOutWarehouse.*"));
            sic.add(new SelectorItemInfo("moveOutStorageOrgUnit.*"));
            sic.add(new SelectorItemInfo("parent.number"));
            sic.add(new SelectorItemInfo("warehouse.id"));
            sic.add(new SelectorItemInfo("warehouse.number"));
            sic.add(new SelectorItemInfo("warehouse.name"));
            sic.add(new SelectorItemInfo("material.id"));
            sic.add(new SelectorItemInfo("material.number"));
            sic.add(new SelectorItemInfo("material.name"));
            sic.add(new SelectorItemInfo("material.model"));
            sic.add(new SelectorItemInfo("baseUnit.id"));
            sic.add(new SelectorItemInfo("baseUnit.number"));
            sic.add(new SelectorItemInfo("baseUnit.name"));
            sic.add(new SelectorItemInfo("unit.id"));
            sic.add(new SelectorItemInfo("unit.number"));
            sic.add(new SelectorItemInfo("unit.name"));
            sic.add(new SelectorItemInfo("parent.storageOrgUnit.*"));
            viewInfo.setSelector(sic);
            HashSet idSet = new HashSet();
            for (int i = 0; i < idList.size(); ++i) {
                idSet.add(idList.get(i));
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            IStockGatherMoveEntry ipsbe = StockGatherMoveEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            psbeCol = ipsbe.getStockGatherMoveEntryCollection(viewInfo);
        } else {
            psbeCol = (StockGatherMoveEntryCollection)((Object)this.getUIContext().get("EntryCol"));
        }
        MaterialInfo[] materialInfos = null;
        MeasureUnitInfo[] measureUnitInfos = null;
        int[] rowIndexs = null;
        Iterator it = psbeCol.iterator();
        int psCount = psbeCol.size();
        if (psCount > 0) {
            materialInfos = new MaterialInfo[psCount];
            measureUnitInfos = new MeasureUnitInfo[psCount];
            rowIndexs = new int[psCount];
        }
        int rowIndex = 0;
        while (it.hasNext()) {
            StockGatherMoveEntryInfo psbeInfo = (StockGatherMoveEntryInfo)it.next();
            if (psbeInfo.getMaterial() == null) continue;
            IRow newRow = this.tblPSBill.addRow();
            newRow.getCell("id").setValue((Object)psbeInfo.getParent().getId());
            newRow.getCell(TB_PS_STORORGUNITID).setValue((Object)psbeInfo.getParent().getStorageOrgUnit().getId());
            newRow.getCell(TB_PS_STORORGUNITNAME).setValue((Object)psbeInfo.getParent().getStorageOrgUnit().getName());
            newRow.getCell(TB_PS_ENTRYID).setValue((Object)psbeInfo.getId());
            newRow.getCell(TB_PS_NUMBER).setValue((Object)psbeInfo.getParent().getNumber());
            newRow.getCell(TB_PS_MATERIALID).setValue((Object)psbeInfo.getMaterial().getId());
            newRow.getCell(TB_PS_MATERIALID).setUserObject((Object)psbeInfo.getMaterial());
            newRow.getCell(TB_PS_MATERIALNUM).setValue((Object)psbeInfo.getMaterial().getNumber());
            newRow.getCell(TB_PS_MATERIALNAME).setValue((Object)psbeInfo.getMaterial().getName());
            if (psbeInfo.get("seqDisplay") != null) {
                newRow.getCell(TB_PS_LINENUM).setValue((Object)((String)psbeInfo.get("seqDisplay")));
            } else {
                newRow.getCell(TB_PS_LINENUM).setValue((Object)String.valueOf(psbeInfo.getSeq()));
            }
            newRow.getCell(TB_PS_MODEL).setValue((Object)psbeInfo.getModel());
            if (psbeInfo.getUnit() != null) {
                newRow.getCell(TB_PS_FUNIT).setValue((Object)psbeInfo.getUnit().getName());
                newRow.getCell(TB_PS_FUNIT).setUserObject((Object)psbeInfo.getUnit());
            }
            newRow.getCell(TB_PS_REQQTY).setValue((Object)psbeInfo.getQty());
            newRow.getCell(TB_PS_MOVEQTY).setValue((Object)psbeInfo.getMoveQty());
            if (psbeInfo.getWarehouse() != null) {
                newRow.getCell(TB_PS_WAREHOUSE).setValue((Object)psbeInfo.getWarehouse().getName());
            }
            newRow.getCell(TB_PS_WAREHOUSEID).setValue((Object)((String)psbeInfo.get("wareHouseId")));
            newRow.getCell(TB_PS_MOVEOUTSTORAGEID).setValue((Object)((String)psbeInfo.get(TB_PS_MOVEOUTSTORAGEID)));
            newRow.getCell(TB_PS_MOVEOUTWAREHOUSEID).setValue((Object)((String)psbeInfo.get(TB_PS_MOVEOUTWAREHOUSEID)));
            newRow.getCell(TB_PS_MOVEINPLANDATE).setValue((Object)psbeInfo.getMoveInPlanDate());
            newRow.getCell(TB_PS_MOVEOUTSTORAGE).setValue(psbeInfo.getMoveOutStorageOrgUnit() != null ? psbeInfo.getMoveOutStorageOrgUnit().getName() : null);
            newRow.getCell(TB_PS_MOVEOUTWAREHOUSE).setValue(psbeInfo.getMoveOutWarehouse() != null ? psbeInfo.getMoveOutWarehouse().getName() : null);
            newRow.getCell(TB_PS_FLOTNO).setValue((Object)psbeInfo.getLotNo());
            materialInfos[rowIndex] = psbeInfo.getMaterial();
            measureUnitInfos[rowIndex] = psbeInfo.getUnit();
            rowIndexs[rowIndex] = rowIndex;
            ++rowIndex;
        }
        SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo[])materialInfos, (MeasureUnitInfo[])measureUnitInfos, (KDTable)this.tblPSBill, (String[])QTYPRECISIONFROMUNITTAB, (int[])rowIndexs);
        this.tblPSBill.getSelectManager().select(0, 0);
    }

    @Override
    protected void tblPSBill_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.tblInventoryinsertRow(e.getSelectBlock().getBeginRow(), null, null);
    }

    private void tblInventoryinsertRow(int rowIndex, Set warehouseIdSet, Set locationIdSet) throws Exception {
        this.tblInventory.removeRows();
        if (this.tblPSBill.getRowCount() == 0) {
            return;
        }
        FilterInfo filterInfo = (FilterInfo)this.getUIContext().get("filterInfo");
        String isAddNew = (String)this.getUIContext().get("isAddNew");
        IRow aRow = this.tblPSBill.getRow(rowIndex);
        if (filterInfo != null) {
            String warehouseId = (String)aRow.getCell(TB_PS_WAREHOUSEID).getValue();
            if ("noSource".equals(warehouseId)) {
                return;
            }
            String moveOutStorageOrgUnitId = (String)aRow.getCell(TB_PS_MOVEOUTSTORAGEID).getValue();
            String moveOutWareHouseId = (String)aRow.getCell(TB_PS_MOVEOUTWAREHOUSEID).getValue();
            String lotNo = (String)aRow.getCell(TB_PS_FLOTNO).getValue();
            this.getSourceBillByCondition(filterInfo, aRow, warehouseId, lotNo, moveOutStorageOrgUnitId, moveOutWareHouseId);
        } else {
            if ("1".equals(isAddNew)) {
                return;
            }
            this.getSourceByRelation(aRow);
        }
    }

    private void getSourceBillByCondition(FilterInfo filterInfo, IRow aRow, String warehouseId, String lotNo, String moveOutStorageId, String moveOutWarehouseId) throws BOSException, EASBizException {
        MaterialInfo aMaterialInfo = (MaterialInfo)aRow.getCell(TB_PS_MATERIALID).getUserObject();
        String materialId = aMaterialInfo.getId().toString();
        MeasureUnitInfo aMeasureUnitInfo = (MeasureUnitInfo)aRow.getCell(TB_PS_FUNIT).getUserObject();
        String unitId = aMeasureUnitInfo.getId().toString();
        FilterInfo searchFilterInfo = (FilterInfo)filterInfo.clone();
        FilterItemCollection items = searchFilterInfo.getFilterItems();
        items.add(new FilterItemInfo("materialId", (Object)materialId, CompareType.EQUALS));
        items.add(new FilterItemInfo("unitId", (Object)unitId, CompareType.EQUALS));
        items.add(new FilterItemInfo("defaultWarehouseId", (Object)warehouseId, CompareType.EQUALS));
        items.add(new FilterItemInfo(TB_PS_MOVEOUTSTORAGEID, (Object)moveOutStorageId, CompareType.EQUALS));
        items.add(new FilterItemInfo("moveOutWarehouseId", (Object)moveOutWarehouseId, CompareType.EQUALS));
        items.add(new FilterItemInfo("lotNo", (Object)lotNo, CompareType.EQUALS));
        IStockGatherMove sgm = StockGatherMoveFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        String parentId = aRow.getCell("id").getValue() != null ? ((BOSUuid)aRow.getCell("id").getValue()).toString() : null;
        IRowSet rows = sgm.getSourceBillByCondition(searchFilterInfo, parentId);
        this.fillDataKdtOrder(this.tblInventory, rows);
        this.tblInventory.getStyleAttributes().setLocked(true);
    }

    private void getSourceByRelation(IRow aRow) throws BOSException {
        if (aRow.getCell(TB_PS_ENTRYID).getValue() == null) {
            return;
        }
        String parentId = ((BOSUuid)aRow.getCell("id").getValue()).toString();
        String entryId = ((BOSUuid)aRow.getCell(TB_PS_ENTRYID).getValue()).toString();
        IStockGatherMove sgm = StockGatherMoveFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        IRowSet rows = sgm.getSourceBillByRelation(parentId, entryId);
        this.fillDataKdtOrder(this.tblInventory, rows);
        this.tblInventory.getStyleAttributes().setLocked(true);
    }

    private void fillDataKdtOrder(KDTable kdTable, IRowSet rowSet) {
        try {
            kdTable.checkParsed();
            kdTable.removeRows();
            IRow row = null;
            while (rowSet.next()) {
                row = kdTable.addRow();
                int precision = rowSet.getInt("unitPrecision");
                String fid = rowSet.getString("fid");
                String number = rowSet.getString("number");
                BigDecimal FQty = rowSet.getBigDecimal(TB_ST_QTY);
                String startDate = rowSet.getString(TB_ST_STARTDATE);
                String endDate = rowSet.getString(TB_ST_ENDDATE);
                String seq = rowSet.getString("lineSeq");
                row.getCell("id").setValue((Object)fid);
                row.getCell(TB_ST_ORDERNUMBER).setValue((Object)number);
                row.getCell(TB_ST_SEQ).setValue((Object)seq);
                row.getCell(TB_ST_QTY).setValue((Object)FQty);
                row.getCell(TB_ST_STARTDATE).setValue((Object)startDate);
                row.getCell(TB_ST_ENDDATE).setValue((Object)endDate);
                row.getCell(TB_ST_QTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.repaint();
    }

    @Override
    public void actionSourceBillView_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblInventory);
        if (selectRows.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResourceMsg("StockgatherSourceViewChk"));
            return;
        }
        String entryId = (String)this.tblInventory.getCell(selectRows[0], "id").getValue();
        if (!ProductionOrderFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).exists((IObjectPK)new ObjectUuidPK(entryId))) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)entryId.toString());
        uiContext.put((Object)"isSourceView", (Object)"1");
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getEditUIModal() {
        String openModel = UIConfigUtility.getOpenModel();
        if (openModel != null) {
            return openModel;
        }
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected String getEditUIName() {
        return ProductionOrderEditUI.class.getName();
    }

    private String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RES_STOCKGATHER, (String)key);
    }
}

