/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ParamUtil;
import com.kingdee.eas.mm.control.ITaskDispBill;
import com.kingdee.eas.mm.control.TaskDispBillFactory;
import com.kingdee.eas.mm.control.TaskDispBillInfo;
import com.kingdee.eas.mm.control.client.AbstractTaskDispBillListUI;
import com.kingdee.eas.mm.control.client.TaskDispBillFilterUI;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import org.apache.log4j.Logger;

public class TaskDispBillListUI
extends AbstractTaskDispBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(TaskDispBillListUI.class);
    private ParamUtil paramUtil = new ParamUtil(null);
    private TaskDispBillFilterUI conditionPanel = null;
    private static final String[] KDT_DATES = new String[]{"startDate", "endDate"};

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public String getEntriesName() {
        return "entrys";
    }

    public void onLoad() throws Exception {
        this.isTaskDispEnable();
        super.onLoad();
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.btnRemove);
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])KDT_DATES);
        super.setReservationVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btndiscard.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnLock.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.btnUnlock.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.btnFreeze.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.btnUnFreeze.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.generatePick.setIcon(EASResource.getIcon((String)"imgTbtn_associatecreate"));
        this.menuItemGeneratePick.setIcon(EASResource.getIcon((String)"imgTbtn_associatecreate"));
        this.menuItemFreeze.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.menuItemUnFreeze.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.menuItemComplete.setIcon(EASResource.getIcon((String)"imgTbtn_complete"));
        this.menuItemSubmit.setVisible(false);
        this.kDMenuPercisionConfig.setText(this.kDMenuPercisionConfig.getText() + "(C)");
        this.kDMenuPercisionConfig.setIcon(EASResource.getIcon((String)"imgTbtn_showsetting"));
        this.kDMenuPercisionConfig.setMnemonic(67);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        SorterItemCollection sorters = viewInfo.getSorter();
        for (int i = 0; i < sorters.size(); ++i) {
            if (!sorters.get(i).getPropertyName().equals(this.getEntriesName() + ".seq")) continue;
            sorters.removeObject(i);
            break;
        }
        return exec;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Storage)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return TaskDispBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected IObjectValue createNewData() {
        TaskDispBillInfo objectValue = new TaskDispBillInfo();
        return objectValue;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new TaskDispBillFilterUI();
        }
        return this.conditionPanel;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        String title = TaskDispBillListUI.getResource("TaskDispBill");
        dialog.setTitle(title + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        return dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionComplete_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billIDList = this.getSelectedIdValues();
        try {
            for (int i = 0; i < billIDList.size(); ++i) {
                this.pubFireVOChangeListener(billIDList.get(i).toString());
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
            SysUtil.abort();
        }
        try {
            Iterator it = billIDList.iterator();
            ObjectUuidPK[] pks = new ObjectUuidPK[billIDList.size()];
            int i = 0;
            while (it.hasNext()) {
                ObjectUuidPK pk = new ObjectUuidPK((String)it.next());
                String billID = (String)billIDList.get(i);
                pks[i++] = pk;
                this.setOprtState("TaskComplete");
                this.pubFireVOChangeListener(billID);
            }
            boolean result = ((ITaskDispBill)this.getBizInterface()).taskComplete((IObjectPK[])pks);
            if (result) {
                this.showSuccessMsg(TaskDispBillListUI.getResource("completeOk"));
                super.refreshList();
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)TaskDispBillListUI.getResource("completeNotOk"));
            }
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                if (null != billIDList && billIDList.size() > 0) {
                    Iterator iter = billIDList.iterator();
                    while (iter.hasNext()) {
                        this.pubFireVOChangeListener((String)iter.next());
                    }
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public void initBatchActions() throws BOSException {
        super.initBatchActions();
        this.initPSBatchActions();
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, TaskDispBillFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", null, "number", null, "storageOrgUnit.id");
    }

    public void initPSBatchActions() {
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)new BatchActionEnum("FREEZE"), (ItemAction)this.actionfreeze, (String)"freeze");
        this.actionManager.registerBatchAction(actionProxy, "actionfreeze");
        actionProxy.bindTo((AbstractButton)this.btnFreeze);
        actionProxy.bindTo((AbstractButton)this.menuItemFreeze);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.btnFreeze);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)new BatchActionEnum("UNFREEZE"), (ItemAction)this.actionUnfreeze, (String)"unFreeze");
        this.actionManager.registerBatchAction(actionProxy, "actionUnfreeze");
        actionProxy.bindTo((AbstractButton)this.btnUnFreeze);
        actionProxy.bindTo((AbstractButton)this.menuItemUnFreeze);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.btnUnFreeze);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)new BatchActionEnum("GENERATE"), (ItemAction)this.actionGeneratePickBill, (String)"generatePickingSlipBill");
        this.actionManager.registerBatchAction(actionProxy, "actiongenerate");
        actionProxy.bindTo((AbstractButton)this.generatePick);
        actionProxy.bindTo((AbstractButton)this.menuItemGeneratePick);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.generatePick);
    }

    @Override
    public String[] getMergeColumnKeys() {
        return new String[]{"storageOrg", "number", "productNum", "materialNum", "materialName", "spec", "workShop", "productionLine", "isGeneratePick", "storageOrgUnit.id", "billBaseStatus", "id"};
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{"productQty"};
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.mm.control.app.TaskDispBilForPrintlQuery");
    }

    @Override
    protected String getTDFileName() {
        return "/MAF/CONTROL/TaskDispBill";
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billIDList = this.getSelectedIdValues();
        Iterator it = billIDList.iterator();
        ObjectUuidPK[] pks = new ObjectUuidPK[billIDList.size()];
        int i = 0;
        while (it.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK((String)it.next());
            pks[i++] = pk;
        }
        String strIdLists = StringUtils.arrayToString((Object[])billIDList.toArray(), (String)"','");
        String result = ((ITaskDispBill)this.getBizInterface()).taskDispBillClosed((IObjectPK[])pks);
        if (result.length() <= 0) {
            this.showCloseInfo(strIdLists, e);
        } else {
            String messeage;
            String[] splitResult = result.split("@");
            if (splitResult[0].length() > 0 && splitResult[1].length() > 0) {
                messeage = TaskDispBillListUI.getResource("underPicking") + splitResult[0] + TaskDispBillListUI.getResource("underFinish") + splitResult[1] + TaskDispBillListUI.getResource("notCompleteState");
                if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)messeage))) {
                    this.showCloseInfo(strIdLists, e);
                } else {
                    return;
                }
            }
            if (splitResult[0].length() > 0 && splitResult[1].length() < 0) {
                messeage = TaskDispBillListUI.getResource("underPicking") + splitResult[0] + TaskDispBillListUI.getResource("notCompleteState");
                if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)messeage))) {
                    this.showCloseInfo(strIdLists, e);
                } else {
                    return;
                }
            }
            if (splitResult[0].length() < 0 && splitResult[1].length() > 0) {
                messeage = TaskDispBillListUI.getResource("underFinish") + splitResult[1] + TaskDispBillListUI.getResource("notCompleteState");
                if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)messeage))) {
                    this.showCloseInfo(strIdLists, e);
                } else {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCloseInfo(String strIdLists, ActionEvent a) throws Exception {
        String[] newString = strIdLists.split(",");
        try {
            for (int i = 0; i < newString.length; ++i) {
                this.pubFireVOChangeListener(newString[i]);
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
            SysUtil.abort();
        }
        try {
            boolean flag = ((ITaskDispBill)this.getBizInterface()).confirmClose(strIdLists);
            if (flag) {
                this.showSuccessMsg(TaskDispBillListUI.getResource("closeOk"));
                this.refresh(a);
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)TaskDispBillListUI.getResource("closeNotOk"));
            }
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                if (null != newString && newString.length > 0) {
                    for (int i = 0; i < newString.length; ++i) {
                        this.pubFireVOChangeListener(newString[i]);
                    }
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(msgResource);
        this.showMessage();
    }

    private void isTaskDispEnable() throws BOSException, Exception {
        OrgUnitInfo org = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        if (org != null) {
            this.paramUtil.setStorageOrgUnitID(org.getId().toString(), false);
            String strDispType = this.paramUtil.getTaskDispTypeParam("");
            String enabledReport = this.paramUtil.getEnabledProductionReportParam("true");
            if (StringUtils.equals((String)strDispType, (String)String.valueOf(2))) {
                MsgBox.showWarning((Component)((Object)this), (String)TaskDispBillListUI.getResource("noUseTaskDispBill"));
                this.abort();
                return;
            }
            if (!"true".equals(enabledReport)) {
                MsgBox.showWarning((Component)((Object)this), (String)TaskDispBillListUI.getResource("noUseTaskDispForRpt"));
                this.abort();
                return;
            }
        }
    }

    private String getTskDisParam(String orgUnitID, String paramKey) throws BOSException, Exception {
        return ((ITaskDispBill)this.getBizInterface()).getTskDisParam(orgUnitID, paramKey);
    }

    public void actionMultiPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiPrintPreview_actionPerformed(e);
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.control.TaskDispBillResource", (String)strKey);
    }

    protected void logPrint() {
        TaskDispBillInfo taskdispInfo = new TaskDispBillInfo();
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)taskdispInfo.getBOSType(), null, (String)TaskDispBillListUI.getResource("taskdispbillPrint"), (String)"mm_taskdispbill_print");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "taskDispBill";
        param.alias = TaskDispBillListUI.getResource("TaskDispBill");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.ExportData();
    }

    private void ExportData() throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        Object tmp = para.get(0);
        if (tmp instanceof DatataskParameter) {
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.mm.control.app", "TaskDispBillForTransmitQuery");
            DatataskParameter dp = (DatataskParameter)tmp;
            dp.putContextParam((Object)"mainQueryPK", (Object)mainQueryPK);
            dp.putContextParam((Object)"mainQuery", (Object)this.mainQuery);
        }
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.setMainOrgContext(this.getMainOrgContext());
        dc.invoke(para, 1);
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        return super.beforeAction(bizAction, selectionEntries, event);
    }
}

