/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.lot.LotParamValueInfo;

public class TaskDispLotClientUtils {
    public static int dealLotNoSituation(StorageOrgUnitInfo sou, MaterialInfo material) throws EASBizException, BOSException {
        if (material == null || sou == null) {
            return 0;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)sou.getId().toString(), CompareType.EQUALS));
        EntityViewInfo viewer = new EntityViewInfo();
        viewer.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("isLotNumber");
        viewer.setSelector(selector);
        MaterialInventoryCollection inv = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(viewer);
        if (inv.size() <= 0) {
            return 0;
        }
        MaterialInventoryInfo invInfo = inv.get(0);
        if (!invInfo.isIsLotNumber()) {
            return 0;
        }
        LotParamValueInfo param = LotFacadeFactory.getRemoteInstance().getLotParamValueByOrg(sou.getId().toString());
        boolean isPlanOrderGene = param.isProductionOrderPlan();
        boolean isPrdOrderGene = param.isProductionOrderProduction();
        boolean isTaskDispGene = param.isProductionOrderTaskDisp();
        boolean isDefaultCarried = param.isProductionOrderProsee();
        if (isPlanOrderGene) {
            if (isTaskDispGene) {
                if (isDefaultCarried) {
                    return 1;
                }
                return 2;
            }
            return 3;
        }
        if (isPrdOrderGene) {
            if (isTaskDispGene) {
                if (isDefaultCarried) {
                    return 1;
                }
                return 2;
            }
            return 3;
        }
        if (isTaskDispGene) {
            return 2;
        }
        return 0;
    }
}

