/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.math.BigDecimal;

public class StockAllocationUtil {
    private static SCMEntryDataVO voResult = null;
    public static final int PRECISION_DEFAUL_DB = 8;
    public static final BigDecimal EXCHANGERATE_DEFAULT = new BigDecimal("1.0");

    public static int getPrecision(ProductionOrderStockEntryInfo ptfStockInfo) throws EASBizException, BOSException {
        if (voResult == null) {
            voResult = StockAllocationUtil.getVoResult(ptfStockInfo);
        }
        String materialid = ptfStockInfo.getMaterial().getId().toString();
        String untiid = ptfStockInfo.getUnit().getId().toString();
        String baseuntiid = ptfStockInfo.getBaseUnit().getId().toString();
        int precision = new Integer(voResult.getMmuPrecisions().get(materialid + untiid + baseuntiid).toString());
        return precision;
    }

    private static SCMEntryDataVO getVoResult(ProductionOrderStockEntryInfo ptfStockInfo) throws BOSException, EASBizException {
        MaterialInfo[] materials = new MaterialInfo[1];
        MeasureUnitInfo[] units = new MeasureUnitInfo[1];
        MeasureUnitInfo[] baseUnits = new MeasureUnitInfo[1];
        MaterialInfo materialInfo = new MaterialInfo();
        MeasureUnitInfo unitInfo = new MeasureUnitInfo();
        MeasureUnitInfo baseUnitInfo = new MeasureUnitInfo();
        String materialid = ptfStockInfo.getMaterial().getId().toString();
        String untiid = ptfStockInfo.getUnit().getId().toString();
        String baseuntiid = ptfStockInfo.getBaseUnit().getId().toString();
        materialInfo.setId(BOSUuid.read((String)materialid));
        unitInfo.setId(BOSUuid.read((String)untiid));
        baseUnitInfo.setId(BOSUuid.read((String)baseuntiid));
        materials[0] = materialInfo;
        units[0] = unitInfo;
        baseUnits[0] = baseUnitInfo;
        SCMEntryDataVO vo = new SCMEntryDataVO();
        vo.setMaterialInfos(materials);
        vo.setMeasureUnitInfos(units);
        vo.setBaseMeasureUnitInfos(baseUnits);
        voResult = SCMGroupFacadeFactory.getRemoteInstance().loadMmuPrecision(vo);
        return voResult;
    }

    public static BigDecimal getExchangeQtyForClient(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = qty;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = StockAllocationUtil.effectualNumeric(qty).multiply(baseExchangeRate1);
            int scale = 8;
            if (baseQty != null && qty != null) {
                scale = otherUnitInfo.getQtyPrecision();
            }
            targetQty = StockAllocationUtil.effectualNumeric(baseQty).divide(StockAllocationUtil.effectualExchangeRate(baseExchangeRate2), scale != 0 ? scale : 8, 4);
        }
        return targetQty;
    }

    public static BigDecimal effectualNumeric(BigDecimal v) {
        return StockAllocationUtil.equalsZero(v) ? SysConstant.BIGZERO : v;
    }

    public static boolean equalsZero(BigDecimal v) {
        return v == null || SysConstant.BIGZERO.compareTo(v) == 0;
    }

    public static BigDecimal effectualExchangeRate(BigDecimal exchangeRate) {
        return StockAllocationUtil.isDistrustExchangeRate(exchangeRate) ? exchangeRate : EXCHANGERATE_DEFAULT;
    }

    public static boolean isDistrustExchangeRate(BigDecimal exchangeRate) {
        return exchangeRate != null && exchangeRate.compareTo(SysConstant.BIGZERO) != 0 && exchangeRate.compareTo(SysConstant.BIGZERO) != -1;
    }

    public static OrgUnitInfo checkOrgPermission(OrgType orgType, String strStatus, StorageOrgUnitInfo orderStorage) {
        OrgUnitInfo[] mainOrgs = null;
        try {
            mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), orgType, strStatus);
            if (mainOrgs == null || mainOrgs.length == 0) {
                return null;
            }
            if (mainOrgs.length > 0) {
                mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        int k = 0;
        if (mainOrgs == null) {
            orderStorage = null;
        }
        if (orderStorage != null && mainOrgs.length > 0) {
            for (int i = 0; i < mainOrgs.length; ++i) {
                if (orderStorage.getId().toString().equals(mainOrgs[i].getId().toString())) {
                    return orderStorage;
                }
                if (++k != mainOrgs.length) continue;
                orderStorage = null;
            }
        } else {
            orderStorage = null;
        }
        return orderStorage;
    }

    public static void setMergeColumn(KDTable kdTable) {
        kdTable.getGroupManager().group();
        kdTable.getGroupManager().setGroup(true);
        String[] mergeColumnKeys = StockAllocationUtil.getSimulateFieldNames();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                kdTable.getColumn(mergeColumnKeys[i]).setGroup(true);
                kdTable.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    public static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("stockEntry.*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo("productLine.*"));
        sic.add(new SelectorItemInfo("unit.*"));
        sic.add(new SelectorItemInfo("warehouse.*"));
        sic.add(new SelectorItemInfo("baseUnit.*"));
        sic.add(new SelectorItemInfo("workShop.*"));
        sic.add(new SelectorItemInfo("classTeam.*"));
        sic.add(new SelectorItemInfo("classGroup.*"));
        sic.add(new SelectorItemInfo("formula.*"));
        sic.add(new SelectorItemInfo("bom.*"));
        sic.add(new SelectorItemInfo("trackNumber.*"));
        sic.add(new SelectorItemInfo("bizType.*"));
        sic.add(new SelectorItemInfo("billType.*"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("mmBizType.*"));
        sic.add(new SelectorItemInfo("mmBizType"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("actualEndDate"));
        sic.add(new SelectorItemInfo("expectEndDate"));
        sic.add(new SelectorItemInfo("OutSourceFlag"));
        sic.add(new SelectorItemInfo("stockEntry.material.*"));
        sic.add(new SelectorItemInfo("stockEntry.baseUnit.*"));
        sic.add(new SelectorItemInfo("stockEntry.unit.*"));
        sic.add(new SelectorItemInfo("stockEntry.moveOutWarehouse.id"));
        sic.add(new SelectorItemInfo("stockEntry.moveOutWarehouse.name"));
        sic.add(new SelectorItemInfo("stockEntry.moveOutWarehouse.number"));
        sic.add(new SelectorItemInfo("stockEntry.moveOutStorageOrgUnit.id"));
        sic.add(new SelectorItemInfo("stockEntry.moveOutStorageOrgUnit.name"));
        sic.add(new SelectorItemInfo("stockEntry.moveOutStorageOrgUnit.number"));
        sic.add(new SelectorItemInfo("stockEntry.defaultWarehouse.id"));
        sic.add(new SelectorItemInfo("stockEntry.defaultWarehouse.name"));
        sic.add(new SelectorItemInfo("stockEntry.defaultWarehouse.number"));
        sic.add(new SelectorItemInfo("stockEntry.productLineWP.id"));
        sic.add(new SelectorItemInfo("stockEntry.productLineWP.name"));
        sic.add(new SelectorItemInfo("stockEntry.productLineWP.number"));
        sic.add(new SelectorItemInfo("stockEntry.supplyOrgUnit.name"));
        return sic;
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.control.StockAllocationResource", (String)strKey);
    }

    public static String[] getOrderQtyFieldNames() {
        return new String[]{"orderQty", "totalReceiptQty", "receiptQty"};
    }

    public static String[] getStockQtyFieldNames() {
        return new String[]{"invQty", "stockReserveQty", "reqQty", "receiptReqQty", "receiptQty", "totalReceiptQty", "transferBatch"};
    }

    public static String[] getSimulateQtyFieldNames() {
        return new String[]{"qty"};
    }

    public static String[] getSimulateFieldNames() {
        return new String[]{"number", "sTDestBillType", "issueStorageOrgUnit", "bizType", "receiptAdminOrgUnit"};
    }
}

