/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;

public abstract class AbstractMatingRule {
    protected KDTable kdtMo;
    protected KDTable kdtStock;
    protected String orgId;
    protected FilterInfo filter;
    protected String BILL_TYPE;
    protected boolean isGetMaterial = true;
    protected boolean isUseInvQty;
    protected SCMEntryDataVO voResult = null;
    protected SCMEntryDataVO moVoResult = null;
    protected static final BigDecimal ZERO = SysConstant.BIGZERO;

    protected void calculate() throws BOSException, EASBizException {
        int i;
        this.getVoResult();
        this.getMoVoResult();
        ArrayList<IRow> priorityList = new ArrayList<IRow>();
        for (i = 0; i < this.kdtMo.getRowCount(); ++i) {
            priorityList.add(this.kdtMo.getRow(i));
        }
        for (i = 0; i < priorityList.size(); ++i) {
            IRow row = (IRow)priorityList.get(i);
            this.calMaxPickingSet(row);
            this.calPickingQty(row);
            this.calSimulateOccupyQty(row);
            this.calcBaseQty(this.kdtMo.getCell(i, "number").getValue().toString());
        }
    }

    private SCMEntryDataVO getMoVoResult() throws BOSException, EASBizException {
        if (this.voResult == null && this.moVoResult == null) {
            MaterialInfo[] materials = new MaterialInfo[this.kdtMo.getRowCount()];
            MeasureUnitInfo[] units = new MeasureUnitInfo[this.kdtMo.getRowCount()];
            MaterialInfo materialInfo = null;
            MeasureUnitInfo unitInfo = null;
            for (int i = 0; i < this.kdtMo.getRowCount(); ++i) {
                String materialid = this.kdtMo.getRow(i).getCell("material.id").getValue().toString();
                String untiid = this.kdtMo.getRow(i).getCell("unit.id").getValue().toString();
                materialInfo = new MaterialInfo();
                unitInfo = new MeasureUnitInfo();
                materialInfo.setId(BOSUuid.read((String)materialid));
                unitInfo.setId(BOSUuid.read((String)untiid));
                materials[i] = materialInfo;
                units[i] = unitInfo;
            }
            SCMEntryDataVO vo = new SCMEntryDataVO();
            vo.setMaterialInfos(materials);
            vo.setMeasureUnitInfos(units);
            this.moVoResult = SCMGroupFacadeFactory.getRemoteInstance().loadMmuPrecision(vo);
            return this.moVoResult;
        }
        return this.moVoResult;
    }

    protected void setVoResult(SCMEntryDataVO voResult) {
        this.voResult = voResult;
    }

    protected void setMoVoResult(SCMEntryDataVO moVoResult) {
        this.moVoResult = moVoResult;
    }

    private static Comparator getPriorityComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer priority2;
                IRow row1 = (IRow)o1;
                IRow row2 = (IRow)o2;
                Integer priority1 = (Integer)row1.getCell("priority").getValue();
                if (priority1.compareTo(priority2 = (Integer)row2.getCell("priority").getValue()) != 0) {
                    return priority1.compareTo(priority2);
                }
                return 0;
            }
        };
    }

    private SCMEntryDataVO getVoResult() throws BOSException, EASBizException {
        if (this.voResult == null && this.moVoResult == null) {
            MaterialInfo[] materials = new MaterialInfo[this.kdtStock.getRowCount()];
            MeasureUnitInfo[] units = new MeasureUnitInfo[this.kdtStock.getRowCount()];
            MeasureUnitInfo[] baseUnits = new MeasureUnitInfo[this.kdtStock.getRowCount()];
            MaterialInfo materialInfo = null;
            MeasureUnitInfo unitInfo = null;
            MeasureUnitInfo baseUnitInfo = null;
            for (int i = 0; i < this.kdtStock.getRowCount(); ++i) {
                String materialid = this.kdtStock.getRow(i).getCell("material.id").getValue().toString();
                String untiid = this.kdtStock.getRow(i).getCell("unitid").getValue().toString();
                String baseuntiid = this.kdtStock.getRow(i).getCell("baseUnitID").getValue().toString();
                materialInfo = new MaterialInfo();
                unitInfo = new MeasureUnitInfo();
                baseUnitInfo = new MeasureUnitInfo();
                materialInfo.setId(BOSUuid.read((String)materialid));
                unitInfo.setId(BOSUuid.read((String)untiid));
                baseUnitInfo.setId(BOSUuid.read((String)baseuntiid));
                materials[i] = materialInfo;
                units[i] = unitInfo;
                baseUnits[i] = baseUnitInfo;
            }
            SCMEntryDataVO vo = new SCMEntryDataVO();
            vo.setMaterialInfos(materials);
            vo.setMeasureUnitInfos(units);
            vo.setBaseMeasureUnitInfos(baseUnits);
            this.voResult = SCMGroupFacadeFactory.getRemoteInstance().loadMmuPrecision(vo);
            return this.voResult;
        }
        return this.voResult;
    }

    protected abstract void calMaxPickingSet(IRow var1) throws BOSException, EASBizException;

    protected abstract void calPickingQty(IRow var1) throws BOSException, EASBizException;

    protected abstract void calSimulateOccupyQty(IRow var1) throws BOSException, EASBizException;

    protected void calcBaseQty(String number) throws BOSException, EASBizException {
        BigDecimal convsRate = null;
        Integer prec = null;
        Integer basePrec = null;
        for (int i = 0; i < this.kdtStock.getRowCount(); ++i) {
            IRow row = this.kdtStock.getRow(i);
            if (!row.getCell("number").getValue().toString().equals(number)) continue;
            String materialid = this.kdtStock.getRow(i).getCell("material.id").getValue().toString();
            String untiid = this.kdtStock.getRow(i).getCell("unitid").getValue().toString();
            String baseuntiid = this.kdtStock.getRow(i).getCell("baseUnitID").getValue().toString();
            convsRate = (BigDecimal)this.voResult.getMmuConvsRate().get(materialid + untiid);
            prec = (Integer)this.voResult.getMmuPrecisions().get(materialid + untiid);
            basePrec = (Integer)this.voResult.getMmuPrecisions().get(materialid + baseuntiid);
            this.kdtStock.getRow(i).getCell("qtyPrecision").setValue((Object)prec);
            this.kdtStock.getRow(i).getCell("baseQtyPrecision").setValue((Object)basePrec);
            this.kdtStock.getRow(i).getCell("convsRate").setValue((Object)convsRate);
        }
    }

    protected BigDecimal getScaleQty(IRow row, BigDecimal qty) {
        String materialId = row.getCell("material.id").getValue().toString();
        String measureUnitId = row.getCell("unit.id").getValue().toString();
        int precision = new Integer(this.moVoResult.getMmuPrecisions().get(materialId + measureUnitId).toString());
        BigDecimal tempQty = qty.divide(new BigDecimal("1.00"), precision, 1);
        return tempQty;
    }

    protected int getPrecision(IRow row) {
        String materialId = row.getCell("material.id").getValue().toString();
        String measureUnitId = row.getCell("unit.id").getValue().toString();
        int precision = new Integer(this.moVoResult.getMmuPrecisions().get(materialId + measureUnitId).toString());
        return precision;
    }
}

