/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.ManufactureStrategyGroup;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.mo.client.AbstractBomF7ListUI;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class BomF7ListUI
extends AbstractBomF7ListUI {
    private static final long serialVersionUID = -8377536628823646639L;
    protected F7ContextManager f7Manager = null;
    private DataChangeListener materialDataChanged;
    protected boolean isCanceled = true;
    private MaterialInfo materialInfo = null;
    private Map materialPlanMap = new HashMap();
    private StorageOrgUnitInfo mainOrgInfo = null;
    private static final String TB_ID = "id";
    private static final String TB_BOMTYPE = "bomType";
    private static final String TB_PROJECTNO = "projectNum";
    private static final String TB_TRACKNO = "trackNum";
    private static final String QUERY_PROJECT = "com.kingdee.eas.mm.project.app.F7ProjectQuery";
    private static final String QUERY_TRACK = "com.kingdee.eas.mm.basedata.app.TrackNumberQuery";

    public BomF7ListUI() throws Exception {
        this.tblMain.checkParsed(true);
        this.f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType());
    }

    public void onLoad() throws Exception {
        this.fillTrackToTable();
        this.materialInfo = (MaterialInfo)this.getUIContext().get("MATERIAL");
        this.mainOrgInfo = (StorageOrgUnitInfo)this.getUIContext().get("ORG");
        this.initUIMainOrgContext(this.mainOrgInfo.getId().toString());
        this.initMaterialF7(this.mainOrgInfo);
        this.prmtmaterial.setEnabled(false);
        this.currentMaterialBom.setSelected(true);
        this.removeListener();
        this.prmtmaterial.setValue((Object)this.materialInfo);
        this.txtMaterialName.setText(this.materialInfo.getName());
        this.prmtProject.setValue((Object)((ProjectInfo)this.getUIContext().get("PROJECT")));
        this.prmtTrack.setValue((Object)((TrackNumberInfo)this.getUIContext().get("TRACK")));
        this.chkOrderBomCheckProTra.setEnabled(true);
        this.addListener();
        super.onLoad();
    }

    private void initMaterialF7(StorageOrgUnitInfo storageOrgInfo) throws Exception {
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtmaterial, (OrgUnitInfo)storageOrgInfo);
        EntityViewInfo viewInfo = this.prmtmaterial.getEntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
        String attrFilter = "10030,10050,10040";
        filterInfo.getFilterItems().add(new FilterItemInfo("plan.materialAttr", (Object)attrFilter, CompareType.INNER));
        filterInfo.getFilterItems().add(new FilterItemInfo("plan.status", (Object)new Integer(1), CompareType.EQUALS));
        viewInfo.getFilter().mergeFilter(filterInfo, "and");
        viewInfo.getFilter();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        Integer status = new Integer(4);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)status, CompareType.EQUALS));
        String storageOrgUnitId = this.mainOrgInfo.getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        MaterialInfo materialInfo = (MaterialInfo)this.prmtmaterial.getValue();
        if (materialInfo == null || materialInfo.getId() == null) {
            return filter;
        }
        String materialId = materialInfo.getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        boolean isSelected = this.chkOrderBomCheckProTra.isSelected();
        if (isSelected) {
            try {
                filter = this.getFilterInfo(filter, materialId);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            HashSet<Integer> bomTypeSet = new HashSet<Integer>();
            bomTypeSet.add(new Integer(40));
            bomTypeSet.add(new Integer(45));
            filter.getFilterItems().add(new FilterItemInfo(TB_BOMTYPE, bomTypeSet, CompareType.INCLUDE));
        }
        return filter;
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.setCanceled(false);
        this.disposeUIWindow();
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.checkBeforeQuery();
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (this.mainQuery != null && this.mainQuery.getSorter() != null) {
            viewInfo.setSorter(this.mainQuery.getSorter());
        }
        this.mainQuery = this.getEntityViewInfo(viewInfo);
        this.execQuery();
    }

    private void checkBeforeQuery() {
        if (this.prmtmaterial.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource.FirstSelectMaterial"));
            SysUtil.abort();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            ActionEvent evt = new ActionEvent(this.btnConfirm, 0, "Double Clicked");
            ItemAction actConfirm = this.getActionFromActionEvent(evt);
            actConfirm.actionPerformed(evt);
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected void initKeyStroke() {
        this.tblMain.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "Confirm_1");
        this.tblMain.getActionMap().put("Confirm_1", new AbstractAction(){
            private static final long serialVersionUID = -5669325198048189263L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEvent evt = new ActionEvent(BomF7ListUI.this.btnConfirm, 0, "Enter");
                ItemAction actConfirm = BomF7ListUI.this.getActionFromActionEvent(evt);
                actConfirm.actionPerformed(evt);
            }
        });
    }

    private boolean isMaterialUnitSameGroup(String materialId1, String materialId2) throws BOSException {
        if (materialId1.equals(materialId2)) {
            return true;
        }
        boolean isSameGroup = false;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        HashSet<String> set = new HashSet<String>();
        set.add(materialId1);
        set.add(materialId2);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBasicUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(TB_ID));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("measureUnit.measureUnitGroup.id"));
        view.setSelector(sic);
        MultiMeasureUnitCollection multiMeaUnitCol = multiUnit.getMultiMeasureUnitCollection(view);
        if (multiMeaUnitCol.size() == 2) {
            String unitGroup1 = multiMeaUnitCol.get(0).getMeasureUnit().getMeasureUnitGroup().getId().toString();
            String unitGroup2 = multiMeaUnitCol.get(1).getMeasureUnit().getMeasureUnitGroup().getId().toString();
            if (unitGroup1 != null && unitGroup2 != null && unitGroup1.equals(unitGroup2)) {
                isSameGroup = true;
            }
        }
        return isSameGroup;
    }

    @Override
    public void actionCurrentMaterial_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.repaint();
        this.tblMain.removeRows(false);
        this.prmtmaterial.setValue((Object)this.materialInfo);
        this.txtMaterialName.setText(this.materialInfo.getName());
        this.prmtmaterial.setEnabled(false);
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    public void actionOtherMaterial_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.repaint();
        this.tblMain.removeRows(false);
        this.prmtmaterial.setEnabled(true);
        if (this.prmtmaterial.getValue() != null) {
            this.actionRefresh_actionPerformed(null);
        }
    }

    @Override
    public void actionCheckProjectTrack_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentMaterialBom.isSelected()) {
            this.actionCurrentMaterial_actionPerformed(null);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BomFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
    }

    protected void prmtmaterial_dataChanged(DataChangeEvent e) {
        try {
            boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
            if (isDiffrent) {
                if (e.getNewValue() != null) {
                    MaterialInfo materialInfo = (MaterialInfo)e.getNewValue();
                    if (this.isMaterialUnitSameGroup(materialInfo.getId().toString(), this.materialInfo.getId().toString())) {
                        this.txtMaterialName.setText(materialInfo.getName());
                    } else {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource.MaterialUnit_NotSameGroup"));
                        this.removeListener();
                        this.prmtmaterial.setValue(e.getOldValue());
                        this.addListener();
                    }
                } else {
                    this.txtMaterialName.setText(null);
                }
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    public void removeListener() {
        if (this.materialDataChanged != null) {
            this.prmtmaterial.removeDataChangeListener(this.materialDataChanged);
        }
    }

    public void addListener() {
        if (this.materialDataChanged == null) {
            this.materialDataChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        BomF7ListUI.this.prmtmaterial_dataChanged(e);
                    }
                    catch (Exception exc) {
                        BomF7ListUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtmaterial.addDataChangeListener(this.materialDataChanged);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getEditUIName() {
        return null;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCancel) {
        this.isCanceled = isCancel;
    }

    private MaterialPlanInfo getMaterialPlan(String materialId) {
        String orgId = this.mainOrgInfo.getId().toString();
        String key = orgId + materialId;
        MaterialPlanInfo plan = null;
        if (this.materialPlanMap.containsKey(key)) {
            plan = (MaterialPlanInfo)this.materialPlanMap.get(key);
        } else {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection selectorColl = new SelectorItemCollection();
            selectorColl.add("manufactureStrategy.id");
            selectorColl.add("isolatedRule");
            view.setSelector(selectorColl);
            try {
                MaterialPlanCollection coll = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(view);
                if (coll != null && coll.size() > 0) {
                    plan = coll.get(0);
                    this.materialPlanMap.put(key, plan);
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return plan;
    }

    private FilterInfo getFilterInfo(FilterInfo filter, String materialId) throws BOSException {
        MaterialPlanInfo plan = this.getMaterialPlan(materialId);
        if (plan == null) {
            return filter;
        }
        String strategyId = "NUnM+gEcEADgAA3cwKgL09g0uEU=";
        if (plan.getManufactureStrategy() != null) {
            strategyId = plan.getManufactureStrategy().getId().toString();
        }
        String trackId = null;
        if (this.prmtTrack.getValue() != null && this.prmtTrack.getValue() instanceof TrackNumberInfo) {
            trackId = ((TrackNumberInfo)this.prmtTrack.getValue()).getId().toString();
        }
        if (ManufactureStrategyGroup.getProjectTrackOrderBomStrategyIdSet().contains(strategyId)) {
            FilterInfo f1 = new FilterInfo();
            Integer bomType = new Integer(40);
            f1.getFilterItems().add(new FilterItemInfo(TB_BOMTYPE, (Object)bomType, CompareType.EQUALS));
            FilterInfo f2 = new FilterInfo();
            bomType = new Integer(45);
            f2.getFilterItems().add(new FilterItemInfo(TB_BOMTYPE, (Object)bomType, CompareType.EQUALS));
            IsolatedRuleEnum isolatedRule = plan.getIsolatedRule();
            if (!IsolatedRuleEnum.NONE.equals((Object)isolatedRule)) {
                String projectId = null;
                if (this.prmtProject.getValue() != null && this.prmtProject.getValue() instanceof ProjectInfo) {
                    projectId = ((ProjectInfo)this.prmtProject.getValue()).getId().toString();
                }
                f2.getFilterItems().add(new FilterItemInfo("orderBomTP.projectId", projectId, CompareType.EQUALS));
            }
            if (IsolatedRuleEnum.ITEM_TRACKNO.equals((Object)isolatedRule)) {
                f2.getFilterItems().add(new FilterItemInfo("orderBomTP.trackId", (Object)trackId, CompareType.EQUALS));
            }
            f1.mergeFilter(f2, "or");
            filter.mergeFilter(f1, "and");
        } else if (ManufactureStrategyGroup.getTrackOrderBomStrategyIdSet().contains(strategyId)) {
            FilterInfo f1 = new FilterInfo();
            Integer bomType = new Integer(40);
            f1.getFilterItems().add(new FilterItemInfo(TB_BOMTYPE, (Object)bomType, CompareType.EQUALS));
            FilterInfo f2 = new FilterInfo();
            bomType = new Integer(45);
            f2.getFilterItems().add(new FilterItemInfo(TB_BOMTYPE, (Object)bomType, CompareType.EQUALS));
            f2.getFilterItems().add(new FilterItemInfo("orderBomTP.trackId", (Object)trackId, CompareType.EQUALS));
            f2.getFilterItems().add(new FilterItemInfo("orderBomTP.projectId", null, CompareType.EQUALS));
            f1.mergeFilter(f2, "or");
            filter.mergeFilter(f1, "and");
        } else if (ManufactureStrategyGroup.getNoOrderBomStrategyIdSet().contains(strategyId)) {
            Integer bomType = new Integer(40);
            filter.getFilterItems().add(new FilterItemInfo(TB_BOMTYPE, (Object)bomType, CompareType.EQUALS));
        }
        return filter;
    }

    private void fillTrackToTable() {
        IColumn column = this.tblMain.getColumn(TB_TRACKNO);
        KDBizPromptBox trackBox = new KDBizPromptBox();
        trackBox.setQueryInfo(QUERY_TRACK);
        trackBox.setDisplayFormat("$number$");
        trackBox.setEditFormat("$number$");
        trackBox.setCommitFormat("$number$");
        trackBox.setEnabledMultiSelection(true);
        ObjectValueRender kdtEntry_OVR = new ObjectValueRender();
        kdtEntry_OVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        column.setRenderer((IBasicRender)kdtEntry_OVR);
        column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)trackBox));
        column = this.tblMain.getColumn(TB_PROJECTNO);
        KDBizPromptBox projectBox = new KDBizPromptBox();
        projectBox.setQueryInfo(QUERY_PROJECT);
        projectBox.setDisplayFormat("$number$");
        projectBox.setEditFormat("$number$");
        projectBox.setCommitFormat("$number$");
        projectBox.setEnabledMultiSelection(false);
        kdtEntry_OVR = new ObjectValueRender();
        kdtEntry_OVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        column.setRenderer((IBasicRender)kdtEntry_OVR);
        column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)projectBox));
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    BomF7ListUI.this.kdtable_afterDataFill(e);
                }
                catch (EASBizException e1) {
                    BomF7ListUI.this.handUIException(e1);
                }
                catch (BOSException e1) {
                    BomF7ListUI.this.handUIException(e1);
                }
            }
        });
    }

    public void kdtable_afterDataFill(KDTDataRequestEvent e) throws EASBizException, BOSException {
        int currRowCount = this.tblMain.getRowCount3();
        int start = e.getFirstRow();
        int end = e.getLastRow();
        HashSet<String> bomIdSet = new HashSet<String>();
        Object obj = null;
        int bomType = 0;
        BizEnumValueDTO bizEnum = null;
        for (int i = start; i <= end && i <= currRowCount - 1; ++i) {
            obj = this.tblMain.getCell(i, TB_BOMTYPE).getValue();
            if (obj == null || 45 != (bomType = Integer.parseInt((bizEnum = (BizEnumValueDTO)obj).getValue().toString()))) continue;
            bomIdSet.add(this.tblMain.getCell(i, TB_ID).getValue().toString());
        }
        Map map = null;
        if (bomIdSet != null && bomIdSet.size() > 0) {
            IBom bom = BomFactory.getRemoteInstance();
            map = bom.getOrderBomTracks(bomIdSet);
        }
        String trackKey = null;
        List trackList = null;
        String bomId = null;
        for (int i = start; i <= end && i <= currRowCount - 1; ++i) {
            if (this.tblMain.getCell(i, TB_BOMTYPE).getValue() == null) continue;
            bizEnum = (BizEnumValueDTO)this.tblMain.getCell(i, TB_BOMTYPE).getValue();
            bomType = Integer.parseInt(bizEnum.getValue().toString());
            bomId = this.tblMain.getCell(i, TB_ID).getValue().toString();
            if (45 == bomType) {
                if (map == null) continue;
                this.tblMain.getCell(i, TB_PROJECTNO).setValue(map.get(bomId));
                trackKey = bomId + "_track";
                if (!map.containsKey(trackKey)) continue;
                trackList = (List)map.get(trackKey);
                this.tblMain.getCell(i, TB_TRACKNO).setValue((Object)trackList.toArray());
                continue;
            }
            this.tblMain.getCell(i, TB_PROJECTNO).setValue(null);
            this.tblMain.getCell(i, TB_TRACKNO).setValue(null);
        }
    }
}

