/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.client.AbstractMORemarkUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;

public class MORemarkUI
extends AbstractMORemarkUI {
    private static final long serialVersionUID = 8211624994428878782L;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private int txtLen = 0;
    private String moID;
    private String oldRemark = null;

    public MORemarkUI() throws Exception {
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    public void onLoad() throws Exception {
        this.moID = (String)this.getUIContext().get("MO_ID");
        this.oldRemark = (String)this.getUIContext().get("MO_REMARK");
        int MAX_LENGTH = (Integer)this.getUIContext().get("MaxLength");
        if (this.oldRemark != null) {
            int length = this.oldRemark.length();
            if (length < MAX_LENGTH) {
                this.txtRemark.setMaxLength(MAX_LENGTH - length);
            } else {
                this.txtRemark.setMaxLength(0);
            }
        } else {
            this.txtRemark.setMaxLength(MAX_LENGTH);
        }
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.txtRemark.getEditor().getItem().toString().length() != this.txtLen) {
            String msg = EASResource.getString((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"REMARK_NOT_SAVED");
            int ret = MsgBox.showConfirm2((String)msg);
            if (ret == 0) {
                boolean retB = super.checkBeforeWindowClosing();
                if (retB) {
                    this.txtRemark.getEditor().setItem("");
                }
                return retB;
            }
            return false;
        }
        return super.checkBeforeWindowClosing();
    }

    public String getRemark() {
        if (this.oldRemark == null) {
            return this.txtRemark.getEditor().getItem().toString();
        }
        String newText = this.txtRemark.getEditor().getItem().toString();
        if (!StringUtils.isEmpty((String)newText)) {
            return this.oldRemark + LINE_SEPARATOR + this.txtRemark.getEditor().getItem().toString();
        }
        return this.oldRemark;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.txtRemark.getEditor().getItem().toString().length() > 0) {
            String newRem = this.getRemark();
            ManufactureOrderFactory.getRemoteInstance().updateRemark(this.moID, newRem);
            this.txtLen = this.txtRemark.getEditor().getItem().toString().length();
            this.actionExitCurrent_actionPerformed(e);
        }
    }
}

