/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.mm.common.MMDateUtil;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.mo.client.AbstractManufactureOrderTechnicsFilterUI;
import com.kingdee.eas.mm.mo.client.F7Unit;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;

public class ManufactureOrderTechnicsFilterUI
extends AbstractManufactureOrderTechnicsFilterUI {
    private static final long serialVersionUID = 3061580082448242393L;
    protected KDBizPromptBox[] disableCommitF7;

    public ManufactureOrderTechnicsFilterUI() throws Exception {
        this.disableCommitF7 = new KDBizPromptBox[]{this.kDBizBillNumFrom, this.kDBizBillNumTo, this.promMaterialNumFrom, this.promMaterialNumTo, this.prmtprojectStart, this.prmtprojectEnd, this.prmtttrackNumStart, this.prmttrackNumEnd, this.prmptWorkCenterNumberFrom, this.prmptWorkCenterNumberTo, this.promOperationNumFrom, this.promOperationNumTo, this.prmtSONumberFrom, this.prmtSONumberTo};
    }

    protected boolean isCustomizedBill() {
        return false;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected Date getNextMonthDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 1);
        return calendar.getTime();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, ManufactureOrderTechnicsFilterUI.getResource("Stroage_IsNotNull")));
        this.comboBaseStatus.removeItem((Object)BillBaseStatusEnum.VERSION);
        this.comboBaseStatus.removeItem((Object)BillBaseStatusEnum.ALTERING);
        this.comboBaseStatus.removeItem((Object)BillBaseStatusEnum.ADD);
        this.comboBaseStatus.removeItem((Object)BillBaseStatusEnum.FINISH);
        this.comboBaseStatus.removeItem((Object)BillBaseStatusEnum.PUBLISHED);
        Timestamp[] dates = MMDateUtil.getDateRange((Date)SCMClientUtils.getServerDate2(), (int)5, (int)10);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        RangeFilterElement elementBizDate = new RangeFilterElement("bizDate", (Component)this.dateBizDateFrom, (Component)this.dateBizDateTo);
        elements.add((FilterElement)elementBizDate);
        elements.add((FilterElement)new SingleFilterElement("storageOrgUnit1.number", (Component)this.prmptMfgOrg));
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.kDBizBillNumFrom, (Component)this.kDBizBillNumTo));
        elements.add((FilterElement)new RangeFilterElement("material1.number", (Component)this.promMaterialNumFrom, (Component)this.promMaterialNumTo));
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtprojectStart);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtprojectEnd);
        elements.add((FilterElement)new RangeFilterElement("project.number", (Component)this.prmtprojectStart, (Component)this.prmtprojectEnd));
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtttrackNumStart);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmttrackNumEnd);
        elements.add((FilterElement)new RangeFilterElement("trackNumber.number", (Component)this.prmtttrackNumStart, (Component)this.prmttrackNumEnd));
        elements.add((FilterElement)new RangeFilterElement("workCenter.number", (Component)this.prmptWorkCenterNumberFrom, (Component)this.prmptWorkCenterNumberTo));
        elements.add((FilterElement)new SingleFilterElement("adminOrgUnit1.number", (Component)this.prmtOrgUnit));
        elements.add((FilterElement)new SingleFilterElement("adminOrgUnit.number", (Component)this.prmtDepartment));
        elements.add((FilterElement)new RangeFilterElement("technics.operation.number", (Component)this.promOperationNumFrom, (Component)this.promOperationNumTo));
        elements.add((FilterElement)new RangeFilterElement("relatingOrderNum", (Component)this.prmtSONumberFrom, (Component)this.prmtSONumberTo));
        RangeFilterElement planBeginDate = new RangeFilterElement("planBeginDate", (Component)this.datePlanStartFrom, (Component)this.datePlanStartTo);
        planBeginDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        planBeginDate.setDefaultValue((Object)dates);
        elements.add((FilterElement)planBeginDate);
        RangeFilterElement planEnfDate = new RangeFilterElement("planEndDate", (Component)this.datePlanEndFrom, (Component)this.datePlanEndTo);
        planEnfDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)planEnfDate);
        RangeFilterElement FactStratDate = new RangeFilterElement("actureBeginDate", (Component)this.dateFactStratFrom, (Component)this.dateFactStratTo);
        FactStratDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)FactStratDate);
        RangeFilterElement FactEndDate = new RangeFilterElement("actureEndDate", (Component)this.dateFactEndFrom, (Component)this.dateFactEndTo);
        FactEndDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)FactEndDate);
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.comboBaseStatus, (Object)BillBaseStatusEnum.NULL));
        this.f7Manager.registerContextChangeF7(this.kDBizBillNumFrom, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.kDBizBillNumTo, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.promOperationNumFrom, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.promOperationNumTo, "storageOrgUnit.id");
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"401,402,403", CompareType.INCLUDE));
        ev.setFilter(filter);
        this.promOperationNumFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ManufactureOrderTechnicsFilterUI.this.OperationNumaddEntityView();
            }
        });
        this.promOperationNumTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ManufactureOrderTechnicsFilterUI.this.OperationNumaddEntityView();
            }
        });
        this.prmptWorkCenterNumberFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ManufactureOrderTechnicsFilterUI.this.addEntityViewToWorkCenter(e);
            }
        });
        this.prmptWorkCenterNumberTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ManufactureOrderTechnicsFilterUI.this.addEntityViewToWorkCenter(e);
            }
        });
        this.setMaterialFilter();
        this.initNeedMainOrgF7s();
        MMUtils.resetF7CommitParser((KDBizPromptBox[])this.disableCommitF7);
    }

    public boolean verify() {
        if (!super.verify()) {
            return false;
        }
        if (this.datePlanStartFrom.getValue() == null || this.datePlanStartTo.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"PlanStartDate_IsNotNull"));
            return false;
        }
        return true;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getViewPermission() {
        return "mm_mo_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public void clear() {
        super.clear();
    }

    public Date getCurrentlyDate() {
        return new Date();
    }

    private void performStorageNullCheck() {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"Stroage_IsNotNull"));
            this.prmtStorageOrgUnit.requestFocus();
            SysUtil.abort();
        }
    }

    public static Timestamp[] getDefaultDateRange(Date d, int monthAmount, boolean isbefore) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        Timestamp currDate = new Timestamp(calendar.getTimeInMillis());
        if (isbefore) {
            calendar.add(2, -1 * monthAmount);
        } else {
            calendar.add(2, monthAmount);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp[]{new Timestamp(calendar.getTimeInMillis()), currDate};
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)strKey);
    }

    private void setMaterialFilter() {
        String queryInfo = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.setBizMaterialF7(this.promMaterialNumFrom, false, queryInfo);
        this.setBizMaterialF7(this.promMaterialNumTo, false, queryInfo);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("plan.materialAttr", (Object)String.valueOf(10040), CompareType.NOTEQUALS));
        view.setFilter(filter);
        this.promMaterialNumFrom.setEntityViewInfo(view);
        this.promMaterialNumTo.setEntityViewInfo(view);
        this.promMaterialNumTo.getQueryAgent().resetRuntimeEntityView();
        this.promMaterialNumFrom.getQueryAgent().resetRuntimeEntityView();
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.promMaterialNumFrom, this.promMaterialNumTo});
    }

    private void OperationNumaddEntityView() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"20", CompareType.EQUALS));
        try {
            this.promOperationNumFrom.getEntityViewInfo().getFilter().mergeFilter(filter, "and");
            this.promOperationNumTo.getEntityViewInfo().getFilter().mergeFilter(filter, "and");
            this.promOperationNumFrom.getQueryAgent().resetRuntimeEntityView();
            this.promOperationNumTo.getQueryAgent().resetRuntimeEntityView();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void addEntityViewToWorkCenter(SelectorEvent event) {
        int i;
        HashSet<String> ids;
        IObjectValue[] mfOrgs = null;
        if (this.prmptMfgOrg.getValue() instanceof IObjectValue[]) {
            mfOrgs = (IObjectValue[])this.prmptMfgOrg.getValue();
        } else if (this.prmptMfgOrg.getValue() instanceof Object[]) {
            Object[] objects = (Object[])this.prmptMfgOrg.getValue();
            mfOrgs = new IObjectValue[objects.length];
            System.arraycopy(objects, 0, mfOrgs, 0, objects.length);
        } else if (this.prmptMfgOrg.getValue() instanceof IObjectValue) {
            mfOrgs = new IObjectValue[]{(IObjectValue)this.prmptMfgOrg.getValue()};
        }
        IObjectValue[] mainOrgs = null;
        if (this.prmtStorageOrgUnit.getValue() instanceof IObjectValue[]) {
            mainOrgs = (IObjectValue[])this.prmtStorageOrgUnit.getValue();
        } else if (this.prmtStorageOrgUnit.getValue() instanceof Object[]) {
            Object[] objects = (Object[])this.prmtStorageOrgUnit.getValue();
            mainOrgs = new IObjectValue[objects.length];
            System.arraycopy(objects, 0, mainOrgs, 0, objects.length);
        } else if (this.prmtStorageOrgUnit.getValue() instanceof IObjectValue) {
            mainOrgs = new IObjectValue[]{(IObjectValue)this.prmtStorageOrgUnit.getValue()};
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20)));
        if (mfOrgs != null && mfOrgs.length > 0) {
            ids = new HashSet<String>();
            int count = mfOrgs.length;
            for (i = 0; i < count; ++i) {
                ids.add(mfOrgs[i].get("id").toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", ids, CompareType.INCLUDE));
        } else if (mainOrgs != null && mainOrgs.length > 0) {
            ids = new HashSet();
            int count = mainOrgs.length;
            for (i = 0; i < count; ++i) {
                ids.add(mainOrgs[i].get("id").toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", ids, CompareType.INCLUDE));
        }
        KDBizPromptBox box = (KDBizPromptBox)event.getSource();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        box.setEntityViewInfo(view);
        box.getQueryAgent().resetRuntimeEntityView();
    }

    protected void setSaleOrderF7(Object e, KDBizPromptBox bizOrgUnitBox) {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)ManufactureOrderTechnicsFilterUI.getResource("INPUT_PROCESSORG"));
            this.cancelF7Event(e);
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo = F7Unit.getSaleOrderF7EntityView(this.prmtStorageOrgUnit);
        filterInfo = viewInfo.getFilter();
        Timestamp[] beforeDates = ManufactureOrderTechnicsFilterUI.getDefaultDateRange((Date)this.dateBizDateFrom.getValue(), 12, true);
        filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)beforeDates[0], CompareType.GREATER_EQUALS));
        bizOrgUnitBox.setEntityViewInfo(viewInfo);
        bizOrgUnitBox.getQueryAgent().resetRuntimeEntityView();
    }

    protected void cancelF7Event(Object e) {
        if (e instanceof SelectorEvent) {
            ((SelectorEvent)e).setCanceled(true);
        } else if (e instanceof CommitEvent) {
            ((CommitEvent)e).setCanceled(true);
        }
    }

    protected void initNeedMainOrgF7s() {
        this.prmtOrgUnit.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (ManufactureOrderTechnicsFilterUI.this.prmtStorageOrgUnit.getValue() == null) {
                    MsgBox.showInfo((String)ManufactureOrderTechnicsFilterUI.getResource("INPUT_PROCESSORG"));
                    ManufactureOrderTechnicsFilterUI.this.cancelF7Event(e);
                    return;
                }
                try {
                    F7Unit.setMoDepartmentF7(e, ManufactureOrderTechnicsFilterUI.this.prmtStorageOrgUnit, ManufactureOrderTechnicsFilterUI.this.prmtOrgUnit);
                }
                catch (Exception e1) {
                    ManufactureOrderTechnicsFilterUI.this.handUIException(e1);
                }
            }
        });
        this.prmtOrgUnit.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                if (ManufactureOrderTechnicsFilterUI.this.prmtStorageOrgUnit.getValue() == null) {
                    MsgBox.showInfo((String)ManufactureOrderTechnicsFilterUI.getResource("INPUT_PROCESSORG"));
                    ManufactureOrderTechnicsFilterUI.this.cancelF7Event(e);
                    return;
                }
                try {
                    F7Unit.setMoDepartmentF7(e, ManufactureOrderTechnicsFilterUI.this.prmtStorageOrgUnit, ManufactureOrderTechnicsFilterUI.this.prmtOrgUnit);
                }
                catch (Exception e1) {
                    ManufactureOrderTechnicsFilterUI.this.handUIException(e1);
                }
            }
        });
        this.prmtDepartment.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (ManufactureOrderTechnicsFilterUI.this.prmtStorageOrgUnit.getValue() == null) {
                    MsgBox.showInfo((String)ManufactureOrderTechnicsFilterUI.getResource("INPUT_PROCESSORG"));
                    ManufactureOrderTechnicsFilterUI.this.cancelF7Event(e);
                    return;
                }
                try {
                    F7Unit.setMoDepartmentF7(e, ManufactureOrderTechnicsFilterUI.this.prmtStorageOrgUnit, ManufactureOrderTechnicsFilterUI.this.prmtDepartment);
                }
                catch (Exception e1) {
                    ManufactureOrderTechnicsFilterUI.this.handUIException(e1);
                }
            }
        });
        this.prmtDepartment.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                if (ManufactureOrderTechnicsFilterUI.this.prmtStorageOrgUnit.getValue() == null) {
                    MsgBox.showInfo((String)ManufactureOrderTechnicsFilterUI.getResource("INPUT_PROCESSORG"));
                    ManufactureOrderTechnicsFilterUI.this.cancelF7Event(e);
                    return;
                }
                try {
                    F7Unit.setMoDepartmentF7(e, ManufactureOrderTechnicsFilterUI.this.prmtStorageOrgUnit, ManufactureOrderTechnicsFilterUI.this.prmtDepartment);
                }
                catch (Exception e1) {
                    ManufactureOrderTechnicsFilterUI.this.handUIException(e1);
                }
            }
        });
        this.prmtSONumberFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ManufactureOrderTechnicsFilterUI.this.setSaleOrderF7(e, ManufactureOrderTechnicsFilterUI.this.prmtSONumberFrom);
            }
        });
        this.prmtSONumberFrom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                ManufactureOrderTechnicsFilterUI.this.setSaleOrderF7(e, ManufactureOrderTechnicsFilterUI.this.prmtSONumberFrom);
            }
        });
        this.prmtSONumberTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ManufactureOrderTechnicsFilterUI.this.setSaleOrderF7(e, ManufactureOrderTechnicsFilterUI.this.prmtSONumberTo);
            }
        });
        this.prmtSONumberTo.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                ManufactureOrderTechnicsFilterUI.this.setSaleOrderF7(e, ManufactureOrderTechnicsFilterUI.this.prmtSONumberTo);
            }
        });
    }

    private class SubSingleFilterElement
    extends SingleFilterElement {
        public SubSingleFilterElement(String id, Component component) {
            super(id, component);
        }

        public FilterInfo getFilterInfo() {
            FilterInfo info = new FilterInfo();
            return info;
        }
    }
}

