/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectMultiPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.BOSUIContext;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.form.model.combin.CombinUIApplication;
import com.kingdee.eas.base.form.model.combin.IPlugUI;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.config.IObjectMultiPKBuilder;
import com.kingdee.eas.framework.config.TablePreferencesHelper;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.MOBirthTypeEnum;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.client.AbstractManufactureOrderTreeUI;
import com.kingdee.eas.mm.mo.client.IMOEditUIObserver;
import com.kingdee.eas.mm.mo.client.ManufactureOrderEditUI;
import com.kingdee.eas.mm.mo.client.ManufactureOrderTreeFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ManufactureOrderTreeUI
extends AbstractManufactureOrderTreeUI
implements IPlugUI,
IMOEditUIObserver {
    private boolean mustShowQueryDialog = false;
    private CommonQueryDialog queryDialog;
    private ManufactureOrderTreeFilterUI filterUI = null;
    private ManufactureOrderEditUI manOrderEditUI = null;
    protected IMetaDataPK mainQueryPK;
    private FilterInfo filterInfo;
    private HashMap treeNodeMap;
    private DefaultKingdeeTreeNode curSelectedNode = null;
    private Set manOrderIDSet = null;
    private TreeSelectionListener treeSelectionListener;
    private CombinUIApplication application = null;
    private static final Logger logger = CoreUIObject.getLogger(ManufactureOrderTreeUI.class);

    public ManufactureOrderTreeUI() throws Exception {
        this.kDSplitPane1.setOneTouchExpandable(true);
        this.kDSplitPane1.setArrowType(1);
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.mm.mo.app", "ManufactureOrderTreeQuery");
    }

    public void addTreeListener() {
        if (this.treeSelectionListener == null) {
            this.treeSelectionListener = new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    ManufactureOrderTreeUI.this.manOrderTree_valueChanged(e);
                }
            };
        }
        this.manOrderTree.addTreeSelectionListener(this.treeSelectionListener);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.isFirstOnload()) {
            if (!this.showQueryDialog()) {
                SysUtil.abort();
            }
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            ObjectUuidPK storagePk = new ObjectUuidPK(this.getMainOrgInfo().getId());
            PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)storagePk, (String)"mm_mo_addnew");
            this.loadManOrderEditUI();
        }
        this.addTreeListener();
    }

    protected void initWorkButton() {
        this.setButtonDefaultStyl(this.btnQuery);
    }

    private void loadManOrderEditUI() throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow win = null;
        win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.mm.mo.client.ManufactureOrderEditUI", (Map)uiContext, null, OprtState.ADDNEW);
        if (win != null) {
            this.manOrderEditUI = (ManufactureOrderEditUI)win.getUIObject();
            this.manOrderEditUI.setIObserver(this);
            this.manOrderEditUI.getUIToolBar().remove(this.manOrderEditUI.getUIToolBar().getComponentCount() - 1);
            this.setUIToolBar(this.manOrderEditUI.getUIToolBar());
            this.setUIMenuBar(this.manOrderEditUI.getUIMenuBar());
            this.setStatusBar(this.manOrderEditUI.getStatusBar());
            this.getUIToolBar().add((Component)this.btnQuery, 3);
            this.getUIMenuBar().getMenu(2).add((Component)this.menuItemQuery, 4);
            this.kdOrderPanel.add((Component)((Object)this.manOrderEditUI), (Object)"Center");
            this.kdOrderPanel.repaint();
        }
    }

    public boolean destroyWindow() {
        if (this.manOrderEditUI != null) {
            this.manOrderEditUI.destroyWindow();
        }
        return super.destroyWindow();
    }

    private boolean showQueryDialog() throws Exception {
        this.initCommonQueryDialog();
        this.filterUI.getUIContext().clear();
        this.filterUI.getUIContext().putAll(this.getUIContext());
        boolean hasDefaultSolution = false;
        if (!this.mustShowQueryDialog) {
            try {
                this.queryDialog.init();
                this.queryDialog.getCommonQueryParam().setDirty(false);
                QuerySolutionInfo currSolution = this.queryDialog.getCurrentSolutionInfo();
                if (null != currSolution && currSolution.isIsUserDefaultSolu() && null != currSolution.getEntityViewInfo()) {
                    EntityViewInfo entityViewInfo = new EntityViewInfo(currSolution.getEntityViewInfo());
                    this.filterInfo = entityViewInfo.getFilter();
                    this.setMainOrgByFilter(this.filterInfo);
                    hasDefaultSolution = true;
                    this.initTree();
                    return true;
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        FilterInfo newFilterInfos = null;
        if ((this.mustShowQueryDialog || !hasDefaultSolution) && this.queryDialog.show()) {
            ManufactureOrderTreeFilterUI plsFilterui = (ManufactureOrderTreeFilterUI)this.queryDialog.getUserPanel(0);
            newFilterInfos = plsFilterui.getFilterInfo();
            FilterInfo commonFilter = this.queryDialog.getCommonFilter();
            newFilterInfos.mergeFilter(commonFilter, "and");
            this.setMainOrgForCommonQueryDialog((CustomerQueryPanel)plsFilterui);
            this.filterInfo = newFilterInfos;
            this.initTree();
            return true;
        }
        return false;
    }

    protected void initTree() throws Exception {
        this.initTree(false);
    }

    protected void initTree(boolean keepFocus) throws Exception {
        String selectedMOId = null;
        if (keepFocus) {
            selectedMOId = this.getSelectedMOId();
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource.ManufactureOrder"));
        ManufactureOrderCollection moCol = null;
        IManufactureOrder imo = (IManufactureOrder)this.getBizInterface();
        moCol = (ManufactureOrderCollection)imo.getManOrderCollectionForTree(this.filterInfo);
        this.buildManOrderTree(root, moCol);
        this.manOrderTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        this.manOrderTree.setRootVisible(true);
        this.manOrderTree.setShowsRootHandles(true);
        this.manOrderTree.getSelectionModel().setSelectionMode(1);
        if (selectedMOId != null) {
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeNodeMap.get(selectedMOId);
            if (treeNode != null) {
                this.manOrderTree.removeTreeSelectionListener(this.treeSelectionListener);
                this.selectTreeNode(this.manOrderTree, treeNode);
                this.addTreeListener();
            } else {
                this.curSelectedNode = null;
                this.manOrderTree.setSelectionNode(root);
            }
        } else {
            this.curSelectedNode = null;
            this.manOrderTree.setSelectionNode(root);
        }
    }

    public void buildManOrderTree(DefaultKingdeeTreeNode root, ManufactureOrderCollection moCol) throws Exception {
        IObjectValue[] moArray = this.preProcessTreeData(moCol);
        Arrays.sort(moArray, new ManufactureOrderComparator());
        Icon Icon_Folder_Open = EASResource.getIcon((String)"imgTree_folder_open");
        Icon Icon_Folder_Close = EASResource.getIcon((String)"imgTree_folder_close");
        Icon Icon_Leaf = EASResource.getIcon((String)"imgTree_folder_leaf");
        ManufactureOrderInfo moInfo = null;
        DefaultKingdeeTreeNode parent = null;
        String longNumber = null;
        String pathTemp = null;
        String parentID = null;
        HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
        int size = moArray.length;
        for (int index = 0; index < size; ++index) {
            moInfo = (ManufactureOrderInfo)moArray[index];
            longNumber = moInfo.getLongNumber();
            KDTreeNode subTreeNode = new KDTreeNode((Object)moInfo);
            subTreeNode.setText(this.getTreeNodeText(moInfo));
            if (moInfo.isIsLeaf()) {
                subTreeNode.setCustomIcon(Icon_Leaf);
                nodeMap.put(moInfo.getId().toString(), subTreeNode);
            } else {
                subTreeNode.setCustomOpenIcon(Icon_Folder_Open);
                subTreeNode.setCustomClosedIcon(Icon_Folder_Close);
                nodeMap.put(moInfo.getId().toString(), subTreeNode);
            }
            if (moInfo.getLevel() == 0) {
                root.add((MutableTreeNode)subTreeNode);
                continue;
            }
            pathTemp = longNumber.substring(0, longNumber.lastIndexOf("!"));
            parentID = pathTemp.lastIndexOf("!") > 0 ? pathTemp.substring(pathTemp.lastIndexOf("!") + 1) : pathTemp;
            parent = (DefaultKingdeeTreeNode)nodeMap.get(parentID);
            if (parent == null) continue;
            parent.add((MutableTreeNode)subTreeNode);
        }
        this.treeNodeMap = nodeMap;
    }

    public String getTreeNodeText(ManufactureOrderInfo moInfo) {
        StringBuffer text = new StringBuffer();
        if (moInfo.getLevel() == 0) {
            if (moInfo.getProject() != null) {
                text.append("[P]");
                text.append(moInfo.getProject().getNumber() + " ");
            }
            if (moInfo.getTrackNumber() != null) {
                text.append("[T]");
                text.append(moInfo.getTrackNumber().getNumber() + " ");
            }
            text.append(moInfo.getNumber());
        } else if (moInfo.getTransactionType() != null && ("yRPu9BAfSRuIIEu9QnyxviQHQ1w=".equals(moInfo.getTransactionType().getId().toString()) || "PF40lAXWJXTgU6hCqMCewyQHQ1w=".equals(moInfo.getTransactionType().getId().toString()))) {
            text.append(moInfo.getNumber());
        } else if (moInfo.getBirthType() == MOBirthTypeEnum.REFORM) {
            if (moInfo.getProject() != null) {
                text.append("[P]");
                text.append(moInfo.getProject().getNumber() + " ");
            }
            if (moInfo.getTrackNumber() != null) {
                text.append("[T]");
                text.append(moInfo.getTrackNumber().getNumber() + " ");
            }
            text.append(moInfo.getNumber() + " ");
            text.append(moInfo.getSplitOperationNo());
        } else if (moInfo.getBirthType() == MOBirthTypeEnum.SPLIT) {
            text.append(moInfo.getNumber() + " ");
            text.append(moInfo.getSplitOperationNo());
        } else {
            text.append(moInfo.getNumber());
        }
        return text.toString();
    }

    public IObjectValue[] preProcessTreeData(ManufactureOrderCollection moCol) throws Exception {
        IObjectValue[] moArray = new IObjectValue[moCol.size()];
        ManufactureOrderInfo moInfo = null;
        String longNumber = null;
        int level = 0;
        Iterator iter = moCol.iterator();
        this.manOrderIDSet = new HashSet();
        HashSet<String> parentLongNumberSet = new HashSet<String>();
        while (iter.hasNext()) {
            moInfo = (ManufactureOrderInfo)iter.next();
            longNumber = moInfo.getLongNumber();
            if (longNumber.lastIndexOf("!") <= 0) continue;
            parentLongNumberSet.add(longNumber.substring(0, longNumber.lastIndexOf("!")));
        }
        int size = moCol.size();
        for (int index = 0; index < size; ++index) {
            moInfo = moCol.get(index);
            this.manOrderIDSet.add(moInfo.getId().toString());
            longNumber = moInfo.getLongNumber();
            level = longNumber.split("!").length - 1;
            moInfo.setLevel(level);
            if (parentLongNumberSet.contains(moInfo.getLongNumber())) {
                moInfo.setIsLeaf(false);
            } else {
                moInfo.setIsLeaf(true);
            }
            moArray[index] = moInfo;
        }
        if (this.application != null) {
            if (!this.isFirstOnload()) {
                this.application.setRefresh("com.kingdee.eas.mm.mo.client.ProductionScheduleUI");
            }
            Context ctx = new Context();
            ctx.put((Object)"IDList", (Object)this.manOrderIDSet);
            ctx.put((Object)"ORGID", (Object)((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId().toString());
            this.application.setContext(ctx);
        }
        return moArray;
    }

    private void manOrderTree_valueChanged(TreeSelectionEvent e) {
        if (this.isChangeTreeFocus()) {
            DefaultKingdeeTreeNode currentNode = (DefaultKingdeeTreeNode)this.manOrderTree.getLastSelectedPathComponent();
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.manOrderTree.getModel().getRoot();
            try {
                if (null != currentNode && currentNode != root) {
                    if (!this.manOrderEditUI.checkBeforeWindowClosing()) {
                        this.resetTreeFocus();
                        return;
                    }
                    this.curSelectedNode = currentNode;
                    ManufactureOrderInfo nodeInfo = (ManufactureOrderInfo)this.curSelectedNode.getUserObject();
                    ObjectUuidPK pk = new ObjectUuidPK(nodeInfo.getId());
                    BOSUIContext context = (BOSUIContext)this.manOrderEditUI.getUIContext();
                    context.put((Object)"TreePath", (Object)nodeInfo.getLongNumber());
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.manOrderEditUI.loadOrderData((IObjectPK)pk);
                    this.setCursor(Cursor.getDefaultCursor());
                } else if (currentNode == root) {
                    this.curSelectedNode = currentNode;
                    if (!this.isFirstOnload()) {
                        this.manOrderEditUI.addNew_selectedRoot();
                    }
                } else {
                    this.curSelectedNode = null;
                    this.manOrderTree.expandPath(new TreePath(root.getPath()));
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    protected void initCommonQueryDialog() {
        if (this.queryDialog == null) {
            this.queryDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.queryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.queryDialog.setOwner((Component)((Object)this));
            }
            this.queryDialog.setUiObject((IUIObject)this);
            this.queryDialog.setParentUIClassName(this.getClass().getName());
            this.queryDialog.setQueryObjectPK(this.mainQueryPK);
            MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}-{1}");
            String title = format.format(new Object[]{this.getUITitle(), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter")});
            this.queryDialog.setTitle(title);
            this.queryDialog.setShowSorter(false);
            try {
                this.filterUI = (ManufactureOrderTreeFilterUI)this.getFilterUI();
                this.filterUI.setIsSupportMultiOrgs(true);
                this.queryDialog.setHeight(450);
                this.queryDialog.setWidth(600);
                this.queryDialog.addUserPanel((KDPanel)this.filterUI);
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ManufactureOrderTreeFilterUI();
        }
        return this.filterUI;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ManufactureOrderFactory.getRemoteInstance();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.mustShowQueryDialog = true;
        this.showQueryDialog();
    }

    public void attach(CombinUIApplication app) {
        this.application = app;
    }

    private void resetTreeFocus() {
        if (null != this.curSelectedNode) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.manOrderTree.getModel();
            TreePath treePath = new TreePath(treeModel.getPathToRoot((TreeNode)this.curSelectedNode));
            this.manOrderTree.setSelectionPath(treePath);
        }
    }

    private boolean isChangeTreeFocus() {
        boolean doNext = true;
        DefaultKingdeeTreeNode nextNode = (DefaultKingdeeTreeNode)this.manOrderTree.getLastSelectedPathComponent();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.manOrderTree.getModel().getRoot();
        if (null != nextNode && nextNode != root && null != this.curSelectedNode && this.curSelectedNode != root) {
            ManufactureOrderInfo nextMenuInfo;
            ManufactureOrderInfo showOrderInfo = (ManufactureOrderInfo)this.curSelectedNode.getUserObject();
            if (showOrderInfo.equals(nextMenuInfo = (ManufactureOrderInfo)nextNode.getUserObject())) {
                doNext = false;
            }
        } else if (nextNode == root && this.curSelectedNode == root) {
            doNext = false;
        }
        return doNext;
    }

    protected final void setMainOrgForCommonQueryDialog(CustomerQueryPanel queryPanel) {
        if (queryPanel != null && queryPanel.getMainBizOrgF7().getData() != null) {
            Object mainOrg = queryPanel.getMainBizOrgF7().getData();
            if (mainOrg instanceof OrgUnitInfo && mainOrg != null) {
                this.initUIMainOrgContext(((OrgUnitInfo)mainOrg).getId().toString());
                return;
            }
            if (mainOrg instanceof Object[]) {
                Object[] orgs = (Object[])mainOrg;
                for (int i = 0; i < orgs.length; ++i) {
                    if (orgs[i] == null || ((OrgUnitInfo)orgs[i]).getId() == null) continue;
                    this.initUIMainOrgContext(((OrgUnitInfo)orgs[i]).getId().toString());
                    return;
                }
            }
        }
    }

    protected final void setMainOrgByFilter(FilterInfo filter) throws BOSException {
        if (filter.getFilterItems() != null && filter.getFilterItems().size() > 0) {
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                FilterItemInfo filterItemInfo = filter.getFilterItems().get(i);
                CompareType comp = filterItemInfo.getCompareType();
                if (!filterItemInfo.getPropertyName().equals("storageOrgUnit.number")) continue;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo orgFilter = new FilterInfo();
                if (comp.equals((Object)CompareType.INCLUDE)) {
                    HashSet orgSet = (HashSet)filterItemInfo.getCompareValue();
                    orgFilter.getFilterItems().add(new FilterItemInfo("number", (Object)orgSet, CompareType.INCLUDE));
                } else if (comp.equals((Object)CompareType.EQUALS)) {
                    String orgNumber = (String)filterItemInfo.getCompareValue();
                    orgFilter.getFilterItems().add(new FilterItemInfo("number", (Object)orgNumber, CompareType.EQUALS));
                }
                view.setFilter(orgFilter);
                IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getRemoteInstance();
                FullOrgUnitCollection orgCol = iOrgUnit.getFullOrgUnitCollection(view);
                if (orgCol.size() <= 0) continue;
                this.initUIMainOrgContext(orgCol.get(0).getId().toString());
                return;
            }
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public void findTreePathByManufactureOrder(List result, TreePath root, ManufactureOrderInfo mo, boolean onlyExpanded) {
        if (onlyExpanded && !this.manOrderTree.isVisible(root)) {
            return;
        }
        DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)root.getLastPathComponent();
        if (parent.getUserObject() instanceof ManufactureOrderInfo && mo.getId().equals((Object)((ManufactureOrderInfo)parent.getUserObject()).getId())) {
            result.add(root);
        }
        if (parent.getChildCount() >= 0) {
            Enumeration eum = parent.children();
            while (eum.hasMoreElements()) {
                DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)eum.nextElement();
                TreePath path = root.pathByAddingChild(child);
                this.findTreePathByManufactureOrder(result, path, mo, onlyExpanded);
            }
        }
    }

    @Override
    public void refresh(boolean keepFocus) {
        try {
            this.initTree(keepFocus);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public String getSelectedMOId() {
        String id = null;
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.manOrderTree.getModel().getRoot();
        if (this.curSelectedNode != root) {
            ManufactureOrderInfo selectedMo = (ManufactureOrderInfo)this.curSelectedNode.getUserObject();
            id = selectedMo.getId().toString();
        }
        return id;
    }

    @Override
    public void addNode(IObjectValue newNodeInfo, boolean focusNewNode) {
        ManufactureOrderInfo newInfo = (ManufactureOrderInfo)newNodeInfo;
        ManufactureOrderInfo moInfo = (ManufactureOrderInfo)newInfo.clone();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.manOrderTree.getModel().getRoot();
        Icon Icon_Leaf = EASResource.getIcon((String)"imgTree_folder_leaf");
        KDTreeNode newTreeNode = new KDTreeNode((Object)moInfo);
        newTreeNode.setText(this.getTreeNodeText(moInfo));
        newTreeNode.setCustomIcon(Icon_Leaf);
        this.treeNodeMap.put(moInfo.getId().toString(), newTreeNode);
        DefaultTreeModel treeModel = (DefaultTreeModel)this.manOrderTree.getModel();
        String longNumber = moInfo.getLongNumber();
        DefaultKingdeeTreeNode parentNode = root;
        if (longNumber.lastIndexOf("!") > 0) {
            String parentID = "";
            String pathTemp = longNumber.substring(0, longNumber.lastIndexOf("!"));
            parentID = pathTemp.lastIndexOf("!") > 0 ? pathTemp.substring(pathTemp.lastIndexOf("!") + 1) : pathTemp;
            parentNode = (DefaultKingdeeTreeNode)this.treeNodeMap.get(parentID);
        }
        if (parentNode != null) {
            parentNode.insert((MutableTreeNode)newTreeNode, this.getInserIndex(parentNode, (DefaultKingdeeTreeNode)newTreeNode));
            this.manOrderTree.removeTreeSelectionListener(this.treeSelectionListener);
            treeModel.reload((TreeNode)parentNode);
        }
        if (focusNewNode) {
            this.selectTreeNode(this.manOrderTree, (DefaultKingdeeTreeNode)newTreeNode);
        } else {
            this.selectTreeNode(this.manOrderTree, root);
        }
        this.addTreeListener();
    }

    public void selectTreeNode(KDTree tree, DefaultKingdeeTreeNode treeNode) {
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        TreePath treePath = new TreePath(treeModel.getPathToRoot((TreeNode)treeNode));
        this.manOrderTree.setSelectionPath(treePath);
        this.manOrderTree.setSelectionNode(treeNode);
        this.curSelectedNode = treeNode;
    }

    public int getInserIndex(DefaultKingdeeTreeNode parentNode, DefaultKingdeeTreeNode newChildNode) {
        if (parentNode.getChildCount() == 0) {
            return 0;
        }
        ManufactureOrderInfo newNodeData = (ManufactureOrderInfo)newChildNode.getUserObject();
        ManufactureOrderComparator moComparator = new ManufactureOrderComparator();
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            DefaultKingdeeTreeNode currNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            ManufactureOrderInfo currNodeData = (ManufactureOrderInfo)currNode.getUserObject();
            if (moComparator.compare(newNodeData, currNodeData) >= 0) continue;
            return i;
        }
        return parentNode.getChildCount();
    }

    protected void initHelper() {
        if (this.tHelper != null) {
            return;
        }
        this.tHelperPrint = this.tHelper = new TablePreferencesHelper((CoreUI)this.manOrderEditUI, new IObjectMultiPKBuilder(){

            public IObjectPK buildPK() {
                ObjectMultiPK pk = new ObjectMultiPK();
                pk.setKeyValue("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId());
                pk.setKeyValue("uiClassName", (Object)((Object)((Object)ManufactureOrderTreeUI.this.manOrderEditUI)).getClass().getName());
                return pk;
            }
        });
    }

    private class ManufactureOrderComparator
    implements Comparator {
        private ManufactureOrderComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            String trackNum2;
            String projectNum2;
            int l2;
            ManufactureOrderInfo order1 = (ManufactureOrderInfo)arg0;
            ManufactureOrderInfo order2 = (ManufactureOrderInfo)arg1;
            int l1 = order1.getLevel();
            int result = l1 - (l2 = order2.getLevel());
            if (result != 0) {
                return result;
            }
            String projectNum1 = order1.getProject() == null ? " " : order1.getProject().getNumber();
            result = projectNum1.compareTo(projectNum2 = order2.getProject() == null ? " " : order2.getProject().getNumber());
            if (result != 0) {
                return result;
            }
            String trackNum1 = order1.getTrackNumber() == null ? " " : order1.getTrackNumber().getNumber();
            result = trackNum1.compareTo(trackNum2 = order2.getTrackNumber() == null ? " " : order2.getTrackNumber().getNumber());
            if (result != 0) {
                return result;
            }
            String number1 = order1.getNumber() == null ? " " : order1.getNumber();
            String number2 = order2.getNumber() == null ? " " : order2.getNumber();
            return number1.compareTo(number2);
        }
    }
}

