/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.client.AbstractMatingRule;
import com.kingdee.eas.mm.mo.util.NumericUtil;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Iterator;

public class MatingRule
extends AbstractMatingRule {
    public MatingRule(String orgId, FilterInfo filter, KDTable kdtMO, KDTable kdtStock, boolean isUseInvQty) {
        this.orgId = orgId;
        this.filter = filter;
        this.kdtMo = kdtMO;
        this.kdtStock = kdtStock;
        this.isUseInvQty = isUseInvQty;
    }

    public MatingRule(String orgId, KDTable kdtMO, KDTable kdtStock, boolean isUseInvQty) {
        this(orgId, null, kdtMO, kdtStock, isUseInvQty);
    }

    @Override
    protected void calPickingQty(IRow row) throws BOSException, EASBizException {
        String moNumber = row.getCell("number").getValue().toString();
        for (int i = 0; i < this.kdtStock.getRowCount(); ++i) {
            IRow stockRow = this.kdtStock.getRow(i);
            if (!stockRow.getCell("number").getValue().toString().equals(moNumber)) continue;
            BigDecimal unitQty = NumericUtil.emptyToZero(stockRow.getCell("unitQty").getValue());
            BigDecimal pickingQty = NumericUtil.emptyToZero(row.getCell("getFormula").getValue());
            String materialId = stockRow.getCell("material.id").getValue().toString();
            String measureUnitId = stockRow.getCell("unitid").getValue().toString();
            int precision = new Integer(this.voResult.getMmuPrecisions().get(materialId + measureUnitId).toString());
            BigDecimal tempQty = NumericUtil.emptyToZero(unitQty.multiply(pickingQty));
            tempQty = tempQty.divide(new BigDecimal("1.00"), precision, 1);
            if (precision == 8 && tempQty.signum() == 0) {
                NumberFormat df = CtrlFormatUtilities.getDecimalFormat();
                stockRow.getCell("materialQty").setValue((Object)df.format(tempQty));
            } else {
                stockRow.getCell("materialQty").setValue((Object)tempQty);
            }
            BigDecimal rate = (BigDecimal)this.voResult.getMmuConvsRate().get(materialId + measureUnitId);
            BigDecimal baseMaterialQty = unitQty.multiply(pickingQty).multiply(rate);
            stockRow.getCell("baseMaterialQty").setValue((Object)NumericUtil.emptyToZero(baseMaterialQty));
        }
    }

    @Override
    protected void calMaxPickingSet(IRow row) {
        Object intWarehouseRange = null;
        Object warehouseObjects = null;
        Object isOccupy = null;
        FilterItemCollection items = this.filter.getFilterItems();
        for (int index = 0; index < items.size(); ++index) {
            FilterItemInfo filterInfo = items.get(index);
            if (filterInfo.getPropertyName().equals("warehouseRange")) {
                intWarehouseRange = filterInfo.getCompareValue();
            }
            if (filterInfo.getPropertyName().equals("warehouseID")) {
                warehouseObjects = filterInfo.getCompareValue();
            }
            if (!filterInfo.getPropertyName().equals("isOccupy")) continue;
            isOccupy = filterInfo.getCompareValue();
        }
        BigDecimal maxTaoQty = ZERO;
        String number = row.getCell("number").getValue().toString();
        this.setMaterialAndDynamicQty(row, intWarehouseRange, warehouseObjects, isOccupy, number);
        int camluate = 0;
        for (int i = 0; i < this.kdtStock.getRowCount(); ++i) {
            String recruStockId;
            IRow recruStockRow;
            int j;
            BigDecimal accumUnitQty;
            BigDecimal accumBaseMaxPicking;
            String currentWarehouseId;
            String currentMaterialId;
            String currentStockId;
            IRow stockRow;
            block18: {
                block16: {
                    block17: {
                        stockRow = this.kdtStock.getRow(i);
                        currentStockId = stockRow.getCell("id").getValue().toString();
                        if (!stockRow.getCell("number").getValue().toString().equals(number)) continue;
                        ++camluate;
                        currentMaterialId = stockRow.getCell("material.id").getValue().toString();
                        currentWarehouseId = "";
                        if (stockRow.getCell("warehsID").getValue() != null) {
                            currentWarehouseId = stockRow.getCell("warehsID").getValue().toString();
                        }
                        accumBaseMaxPicking = NumericUtil.emptyToZero(stockRow.getCell("baseMaxPickingQty").getValue());
                        accumUnitQty = NumericUtil.emptyToZero(stockRow.getCell("baseUnitQty").getValue());
                        if (!this.isUseInvQty) break block16;
                        if (null == intWarehouseRange || !intWarehouseRange.toString().equals("20")) break block17;
                        if (currentWarehouseId == null) {
                            maxTaoQty = this.calMaxTaoQty(accumBaseMaxPicking, accumUnitQty, maxTaoQty, camluate, stockRow);
                            continue;
                        }
                        break block18;
                    }
                    if (null != intWarehouseRange && intWarehouseRange.toString().equals("10")) break block18;
                    String onlyWarehouseIDs = this.parseOnlyWarehouseIds(warehouseObjects);
                    if (currentWarehouseId == null || onlyWarehouseIDs.indexOf(currentWarehouseId) == -1) {
                        maxTaoQty = this.calMaxTaoQty(accumBaseMaxPicking, accumUnitQty, maxTaoQty, camluate, stockRow);
                        continue;
                    }
                    break block18;
                }
                if (currentWarehouseId == null) {
                    maxTaoQty = this.calMaxTaoQty(accumBaseMaxPicking, accumUnitQty, maxTaoQty, camluate, stockRow);
                    continue;
                }
            }
            if (this.isUseInvQty) {
                for (j = 0; j < this.kdtStock.getRowCount(); ++j) {
                    recruStockRow = this.kdtStock.getRow(j);
                    recruStockId = recruStockRow.getCell("id").getValue().toString();
                    if (!recruStockRow.getCell("number").getValue().toString().equals(stockRow.getCell("number").getValue().toString()) || currentStockId.equals(recruStockId) || !currentMaterialId.equals(recruStockRow.getCell("material.id").getValue().toString())) continue;
                    String recruWarehouseId = "";
                    if (recruStockRow.getCell("warehsID").getValue() != null) {
                        recruWarehouseId = recruStockRow.getCell("warehsID").getValue().toString();
                    }
                    if (!MaterialProvideTypeEnum.SPANORGPROVIDE.equals(recruStockRow.getCell("provideType").getValue()) && intWarehouseRange.toString().equals("10")) {
                        accumBaseMaxPicking = accumBaseMaxPicking.add(NumericUtil.emptyToZero(recruStockRow.getCell("baseMaxPickingQty").getValue()));
                        accumUnitQty = accumUnitQty.add(NumericUtil.emptyToZero(recruStockRow.getCell("baseUnitQty").getValue()));
                        continue;
                    }
                    if (MaterialProvideTypeEnum.SPANORGPROVIDE.equals(recruStockRow.getCell("provideType").getValue()) || !currentWarehouseId.equals(recruWarehouseId)) continue;
                    accumBaseMaxPicking = accumBaseMaxPicking.add(NumericUtil.emptyToZero(recruStockRow.getCell("baseMaxPickingQty").getValue()));
                    accumUnitQty = accumUnitQty.add(NumericUtil.emptyToZero(recruStockRow.getCell("baseUnitQty").getValue()));
                }
            } else {
                for (j = 0; j < this.kdtStock.getRowCount(); ++j) {
                    recruStockRow = this.kdtStock.getRow(j);
                    recruStockId = recruStockRow.getCell("id").getValue().toString();
                    if (!recruStockRow.getCell("number").getValue().toString().equals(stockRow.getCell("number").getValue().toString()) || ((Integer)recruStockRow.getCell("priority").getValue()).intValue() != ((Integer)stockRow.getCell("priority").getValue()).intValue() || currentStockId.equals(recruStockId) || !currentMaterialId.equals(recruStockRow.getCell("material.id").getValue().toString()) || MaterialProvideTypeEnum.SPANORGPROVIDE.equals(recruStockRow.getCell("provideType").getValue())) continue;
                    accumBaseMaxPicking = accumBaseMaxPicking.add(NumericUtil.emptyToZero(recruStockRow.getCell("baseMaxPickingQty").getValue()));
                    accumUnitQty = accumUnitQty.add(NumericUtil.emptyToZero(recruStockRow.getCell("baseUnitQty").getValue()));
                }
            }
            maxTaoQty = this.calMaxTaoQty(accumBaseMaxPicking, accumUnitQty, maxTaoQty, camluate, stockRow);
        }
        BigDecimal tempQty = this.getScaleQty(row, maxTaoQty);
        int precision = this.getPrecision(row);
        if (precision == 8 && tempQty.signum() == 0) {
            NumberFormat df = CtrlFormatUtilities.getDecimalFormat();
            row.getCell("maxFormula").setValue((Object)df.format(tempQty));
            row.getCell("getFormula").setValue((Object)df.format(tempQty));
        } else {
            row.getCell("maxFormula").setValue((Object)tempQty);
            row.getCell("getFormula").setValue((Object)tempQty);
        }
    }

    private BigDecimal calMaxTaoQty(BigDecimal accumBaseMaxPicking, BigDecimal accumUnitQty, BigDecimal maxTaoQty, int camluate, IRow stockRow) {
        BigDecimal immediateInventBaseQty = NumericUtil.emptyToZero(stockRow.getCell("immediateInventBaseQty").getValue());
        String materialId = stockRow.getCell("material.id").getValue().toString();
        String measureUnitId = stockRow.getCell("unitid").getValue().toString();
        int precision = 0;
        if (this.voResult.getMmuPrecisions() != null) {
            precision = new Integer(this.voResult.getMmuPrecisions().get(materialId + measureUnitId).toString());
        }
        BigDecimal curMaxPickingSet = ZERO;
        if (this.isUseInvQty && immediateInventBaseQty.compareTo(accumBaseMaxPicking) < 0) {
            accumBaseMaxPicking = immediateInventBaseQty;
        }
        if (accumUnitQty.signum() > 0) {
            curMaxPickingSet = accumBaseMaxPicking.divide(accumUnitQty, precision, 1);
        }
        if (!MaterialProvideTypeEnum.SPANORGPROVIDE.equals(stockRow.getCell("provideType").getValue())) {
            if (maxTaoQty == ZERO) {
                maxTaoQty = curMaxPickingSet;
            } else if (curMaxPickingSet.compareTo(maxTaoQty) < 0) {
                maxTaoQty = curMaxPickingSet;
            }
        }
        if (maxTaoQty.signum() < 0) {
            maxTaoQty = ZERO;
        }
        stockRow.getCell("pinkingSet").setValue((Object)(curMaxPickingSet.signum() < 0 ? ZERO : curMaxPickingSet));
        return maxTaoQty;
    }

    private void setMaterialAndDynamicQty(IRow orderRow, Object intWarehouseRange, Object warehouseObjects, Object isOccupy, String number) {
        BigDecimal dynamicQty = ZERO;
        for (int i = 0; i < this.kdtStock.getRowCount(); ++i) {
            IRow stockRow = this.kdtStock.getRow(i);
            if (!this.kdtStock.getCell(i, "number").getValue().toString().equals(number) || MaterialProvideTypeEnum.SPANORGPROVIDE.equals(stockRow.getCell("provideType").getValue())) continue;
            String currentMaterialId = stockRow.getCell("material.id").getValue().toString();
            String currentWarehouseId = "";
            if (stockRow.getCell("warehsID").getValue() != null) {
                currentWarehouseId = stockRow.getCell("warehsID").getValue().toString();
            }
            BigDecimal simlateQty = this.calSimulateQty(orderRow, intWarehouseRange, warehouseObjects, number, currentMaterialId, currentWarehouseId);
            BigDecimal baseCurMaxPicking = ZERO;
            BigDecimal canBeUseQty = NumericUtil.emptyToZero(stockRow.getCell("storageToDoQty").getValue());
            if (isOccupy.toString().equals("true") || isOccupy.toString().equals("1")) {
                BigDecimal productOccupy = NumericUtil.emptyToZero(stockRow.getCell("productOccupy").getValue());
                dynamicQty = canBeUseQty.subtract(productOccupy).subtract(simlateQty);
            } else {
                dynamicQty = canBeUseQty.subtract(simlateQty);
            }
            if (dynamicQty.compareTo(ZERO) < 0) {
                dynamicQty = ZERO;
            }
            stockRow.getCell("immediateInventBaseQty").setValue((Object)NumericUtil.emptyToZero(dynamicQty));
            BigDecimal plannedBaseQty = NumericUtil.emptyToZero(stockRow.getCell("plannedBaseQty").getValue());
            BigDecimal actIssueBaseQty = NumericUtil.emptyToZero(stockRow.getCell("actIssueBaseQty").getValue());
            BigDecimal rejectedBaseQty = NumericUtil.emptyToZero(stockRow.getCell("rejectedBaseQty").getValue());
            baseCurMaxPicking = plannedBaseQty.subtract(actIssueBaseQty).add(rejectedBaseQty);
            stockRow.getCell("baseMaxPickingQty").setValue((Object)NumericUtil.emptyToZero(baseCurMaxPicking));
        }
    }

    private BigDecimal calSimulateQty(IRow row, Object intWarehouseRange, Object warehouseObjects, String number, String currentMaterialId, String currentWarehouseId) {
        BigDecimal simlateQty = ZERO;
        for (int j = 0; j < this.kdtMo.getRowCount(); ++j) {
            IRow currMoRow = this.kdtMo.getRow(j);
            if (currMoRow.getCell("number").getValue().toString().equals(number)) continue;
            Integer currMoRowPriority = new Integer(currMoRow.getCell("priority").getValue().toString());
            Integer rowPriority = new Integer(row.getCell("priority").getValue().toString());
            if (currMoRowPriority >= rowPriority) continue;
            for (int m = 0; m < this.kdtStock.getRowCount(); ++m) {
                IRow stock = this.kdtStock.getRow(m);
                if (MaterialProvideTypeEnum.SPANORGPROVIDE.equals(stock.getCell("provideType").getValue()) || !stock.getCell("number").getValue().toString().equals(currMoRow.getCell("number").getValue().toString()) || !stock.getCell("material.id").getValue().toString().equals(currentMaterialId)) continue;
                String stockWarehouse = "";
                if (stock.getCell("warehsID").getValue() != null) {
                    stockWarehouse = stock.getCell("warehsID").getValue().toString();
                }
                BigDecimal baseSimQty = ZERO;
                if (stock.getCell("baseMaterialQty").getValue() != null) {
                    baseSimQty = (BigDecimal)stock.getCell("baseMaterialQty").getValue();
                }
                if (intWarehouseRange.toString().equals("10")) {
                    simlateQty = simlateQty.add(baseSimQty);
                    continue;
                }
                if (intWarehouseRange.toString().equals("20")) {
                    if (stock.getCell("warehsID").getValue() == null || !stockWarehouse.equals(currentWarehouseId)) continue;
                    simlateQty = simlateQty.add(baseSimQty);
                    continue;
                }
                String onlyWarehouseIDs = this.parseOnlyWarehouseIds(warehouseObjects);
                if (stock.getCell("warehsID").getValue() == null || onlyWarehouseIDs.indexOf(stockWarehouse) == -1 || !stockWarehouse.equals(currentWarehouseId)) continue;
                simlateQty = simlateQty.add(baseSimQty);
            }
        }
        return simlateQty;
    }

    @Override
    protected void calSimulateOccupyQty(IRow row) throws BOSException, EASBizException {
        String moNumber = row.getCell("number").getValue().toString();
        for (int i = 0; i < this.kdtStock.getRowCount(); ++i) {
            IRow stockRow = this.kdtStock.getRow(i);
            if (!stockRow.getCell("number").getValue().toString().equals(moNumber) || MaterialProvideTypeEnum.SPANORGPROVIDE.equals(stockRow.getCell("provideType").getValue())) continue;
            String materialId = stockRow.getCell("material.id").getValue().toString();
            String measureUnitId = stockRow.getCell("unitid").getValue().toString();
            int precision = new Integer(this.voResult.getMmuPrecisions().get(materialId + measureUnitId).toString());
            BigDecimal tempQty = NumericUtil.emptyToZero(stockRow.getCell("materialQty").getValue());
            if (precision == 8 && tempQty.signum() == 0) {
                NumberFormat df = CtrlFormatUtilities.getDecimalFormat();
                stockRow.getCell("imiateOccupy").setValue((Object)df.format(tempQty));
            } else {
                stockRow.getCell("imiateOccupy").setValue((Object)tempQty);
            }
            BigDecimal rate = (BigDecimal)this.voResult.getMmuConvsRate().get(materialId + measureUnitId);
            BigDecimal baseMaterialQty = tempQty.multiply(rate);
            if (precision == 8 && baseMaterialQty.signum() == 0) {
                NumberFormat df = CtrlFormatUtilities.getDecimalFormat();
                stockRow.getCell("baseImiateOccupy").setValue((Object)df.format(baseMaterialQty));
                continue;
            }
            stockRow.getCell("baseImiateOccupy").setValue((Object)baseMaterialQty);
        }
    }

    private String parseOnlyWarehouseIds(Object warehouseObjects) {
        HashSet set = (HashSet)warehouseObjects;
        Iterator it = set.iterator();
        StringBuffer sb = new StringBuffer("");
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

