/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.client.AbstractMatingRule;
import com.kingdee.eas.mm.mo.util.NumericUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import java.math.BigDecimal;
import java.text.NumberFormat;

public class NoMatingRule
extends AbstractMatingRule {
    private BigDecimal ZERO = SCMConstant.BIGDECIMAL_ZERO;

    public NoMatingRule(String orgId, FilterInfo filter, KDTable kdtMO, KDTable kdtStock, boolean isUseInvQty, boolean isGetMaterial, String BILL_TYPE) {
        this.orgId = orgId;
        this.filter = filter;
        this.kdtMo = kdtMO;
        this.kdtStock = kdtStock;
        this.isUseInvQty = isUseInvQty;
        this.isGetMaterial = isGetMaterial;
        this.BILL_TYPE = BILL_TYPE;
    }

    public NoMatingRule(String orgId, KDTable kdtMO, KDTable kdtStock, boolean isUseInvQty, boolean isGetMaterial, String BILL_TYPE) {
        this(orgId, null, kdtMO, kdtStock, isUseInvQty, isGetMaterial, BILL_TYPE);
    }

    @Override
    public void calPickingQty(IRow row) throws EASBizException, BOSException {
        if (!this.isGetMaterial) {
            return;
        }
        BigDecimal ZERO = new BigDecimal("0.00");
        String number = row.getCell("number").getValue().toString();
        if (this.BILL_TYPE.equals("manufactureOrder")) {
            if (this.isUseInvQty) {
                for (int i = 0; i < this.kdtStock.getRowCount(); ++i) {
                    IRow stockRow = this.kdtStock.getRow(i);
                    if (!stockRow.getCell("number").getValue().toString().equals(number)) continue;
                    BigDecimal plannedBaseQty = NumericUtil.emptyToZero(stockRow.getCell("plannedBaseQty").getValue());
                    BigDecimal actIssueBaseQty = NumericUtil.emptyToZero(stockRow.getCell("actIssueBaseQty").getValue());
                    BigDecimal rejectedBaseQty = NumericUtil.emptyToZero(stockRow.getCell("rejectedBaseQty").getValue());
                    BigDecimal stockToDoQty = NumericUtil.emptyToZero(stockRow.getCell("storageToDoQty").getValue());
                    BigDecimal baseMaterialQty = plannedBaseQty.add(rejectedBaseQty).subtract(actIssueBaseQty);
                    baseMaterialQty = baseMaterialQty.compareTo(ZERO) > 0 ? baseMaterialQty : ZERO;
                    baseMaterialQty = baseMaterialQty.compareTo(stockToDoQty) > 0 ? stockToDoQty : baseMaterialQty;
                    stockRow.getCell("baseMaterialQty").setValue((Object)NumericUtil.emptyToZero(this.getPrecisionQty(stockRow, baseMaterialQty)));
                    String materialId = stockRow.getCell("material.id").getValue().toString();
                    String measureUnitId = stockRow.getCell("unitid").getValue().toString();
                    int precision = new Integer(this.voResult.getMmuPrecisions().get(materialId + measureUnitId).toString());
                    BigDecimal rate = (BigDecimal)this.voResult.getMmuConvsRate().get(materialId + measureUnitId);
                    BigDecimal materialQty = baseMaterialQty.divide(rate, precision, 1);
                    if (precision == 8 && materialQty.signum() == 0) {
                        NumberFormat df = CtrlFormatUtilities.getDecimalFormat();
                        stockRow.getCell("materialQty").setValue((Object)df.format(materialQty));
                        continue;
                    }
                    stockRow.getCell("materialQty").setValue((Object)NumericUtil.emptyToZero(materialQty));
                }
            } else {
                for (int i = 0; i < this.kdtStock.getRowCount(); ++i) {
                    IRow stockRow = this.kdtStock.getRow(i);
                    if (!stockRow.getCell("number").getValue().toString().equals(number)) continue;
                    BigDecimal plannedBaseQty = NumericUtil.emptyToZero(stockRow.getCell("plannedBaseQty").getValue());
                    BigDecimal actIssueBaseQty = NumericUtil.emptyToZero(stockRow.getCell("actIssueBaseQty").getValue());
                    BigDecimal rejectedBaseQty = NumericUtil.emptyToZero(stockRow.getCell("rejectedBaseQty").getValue());
                    BigDecimal baseMaterialQty = plannedBaseQty.add(rejectedBaseQty).subtract(actIssueBaseQty);
                    baseMaterialQty = baseMaterialQty.compareTo(ZERO) > 0 ? baseMaterialQty : ZERO;
                    stockRow.getCell("baseMaterialQty").setValue((Object)NumericUtil.emptyToZero(this.getPrecisionQty(stockRow, baseMaterialQty)));
                    String materialId = stockRow.getCell("material.id").getValue().toString();
                    String measureUnitId = stockRow.getCell("unitid").getValue().toString();
                    int precision = new Integer(this.voResult.getMmuPrecisions().get(materialId + measureUnitId).toString());
                    BigDecimal rate = (BigDecimal)this.voResult.getMmuConvsRate().get(materialId + measureUnitId);
                    BigDecimal materialQty = baseMaterialQty.divide(rate, precision, 1);
                    if (precision == 8 && materialQty.signum() == 0) {
                        NumberFormat df = CtrlFormatUtilities.getDecimalFormat();
                        stockRow.getCell("materialQty").setValue((Object)df.format(materialQty));
                        continue;
                    }
                    stockRow.getCell("materialQty").setValue((Object)NumericUtil.emptyToZero(materialQty));
                }
            }
        } else {
            BigDecimal orderQty = NumericUtil.emptyToZero(row.getCell("orderQty").getValue());
            if (this.isUseInvQty) {
                for (int i = 0; i < this.kdtStock.getRowCount(); ++i) {
                    IRow stockRow = this.kdtStock.getRow(i);
                    if (!stockRow.getCell("number").getValue().toString().equals(number)) continue;
                    BigDecimal dtdEntryQty = NumericUtil.emptyToZero(stockRow.getCell("dtdEntryQty").getValue());
                    BigDecimal plannedBaseQty = NumericUtil.emptyToZero(stockRow.getCell("plannedBaseQty").getValue());
                    BigDecimal actIssueBaseQty = NumericUtil.emptyToZero(stockRow.getCell("actIssueBaseQty").getValue());
                    BigDecimal rejectedBaseQty = NumericUtil.emptyToZero(stockRow.getCell("rejectedBaseQty").getValue());
                    BigDecimal stockToDoQty = NumericUtil.emptyToZero(stockRow.getCell("storageToDoQty").getValue());
                    BigDecimal tempQty = plannedBaseQty.add(rejectedBaseQty).subtract(actIssueBaseQty);
                    tempQty = tempQty.compareTo(ZERO) > 0 ? tempQty : ZERO;
                    String materialId = stockRow.getCell("material.id").getValue().toString();
                    String measureUnitId = stockRow.getCell("unitid").getValue().toString();
                    int precision = new Integer(this.voResult.getMmuPrecisions().get(materialId + measureUnitId).toString());
                    tempQty = tempQty.multiply(dtdEntryQty).divide(orderQty, precision, 1);
                    tempQty = tempQty.compareTo(stockToDoQty) > 0 ? stockToDoQty : tempQty;
                    stockRow.getCell("baseMaterialQty").setValue((Object)NumericUtil.emptyToZero(this.getPrecisionQty(stockRow, tempQty)));
                    BigDecimal rate = (BigDecimal)this.voResult.getMmuConvsRate().get(materialId + measureUnitId);
                    BigDecimal materialQty = tempQty.divide(rate, precision, 1);
                    if (precision == 8 && materialQty.signum() == 0) {
                        NumberFormat df = CtrlFormatUtilities.getDecimalFormat();
                        stockRow.getCell("materialQty").setValue((Object)df.format(materialQty));
                        continue;
                    }
                    stockRow.getCell("materialQty").setValue((Object)NumericUtil.emptyToZero(materialQty));
                }
            } else {
                for (int i = 0; i < this.kdtStock.getRowCount(); ++i) {
                    IRow stockRow = this.kdtStock.getRow(i);
                    if (!stockRow.getCell("number").getValue().toString().equals(number)) continue;
                    BigDecimal dtdEntryQty = NumericUtil.emptyToZero(stockRow.getCell("dtdEntryQty").getValue());
                    BigDecimal plannedBaseQty = NumericUtil.emptyToZero(stockRow.getCell("plannedBaseQty").getValue());
                    BigDecimal actIssueBaseQty = NumericUtil.emptyToZero(stockRow.getCell("actIssueBaseQty").getValue());
                    BigDecimal rejectedBaseQty = NumericUtil.emptyToZero(stockRow.getCell("rejectedBaseQty").getValue());
                    BigDecimal tempQty = plannedBaseQty.add(rejectedBaseQty).subtract(actIssueBaseQty);
                    tempQty = tempQty.compareTo(ZERO) > 0 ? tempQty : ZERO;
                    String materialId = stockRow.getCell("material.id").getValue().toString();
                    String measureUnitId = stockRow.getCell("unitid").getValue().toString();
                    int precision = new Integer(this.voResult.getMmuPrecisions().get(materialId + measureUnitId).toString());
                    tempQty = tempQty.multiply(dtdEntryQty).divide(orderQty, precision, 1);
                    stockRow.getCell("baseMaterialQty").setValue((Object)NumericUtil.emptyToZero(this.getPrecisionQty(stockRow, tempQty)));
                    BigDecimal rate = (BigDecimal)this.voResult.getMmuConvsRate().get(materialId + measureUnitId);
                    BigDecimal materialQty = tempQty.divide(rate, precision, 1);
                    if (precision == 8 && materialQty.signum() == 0) {
                        NumberFormat df = CtrlFormatUtilities.getDecimalFormat();
                        stockRow.getCell("materialQty").setValue((Object)df.format(materialQty));
                        continue;
                    }
                    stockRow.getCell("materialQty").setValue((Object)NumericUtil.emptyToZero(materialQty));
                }
            }
        }
    }

    private BigDecimal getPrecisionQty(IRow stockRow, BigDecimal tempQty) {
        String materialId = stockRow.getCell("material.id").getValue().toString();
        String measureUnitId = stockRow.getCell("unitid").getValue().toString();
        int precision = new Integer(this.voResult.getMmuPrecisions().get(materialId + measureUnitId).toString());
        tempQty = tempQty.divide(new BigDecimal("1.00"), precision, 1);
        return tempQty;
    }

    @Override
    public void calMaxPickingSet(IRow row) {
        BigDecimal orderQty = NumericUtil.emptyToZero(row.getCell("orderQty").getValue());
        BigDecimal tempQty = this.getScaleQty(row, orderQty);
        row.getCell("maxFormula").setValue((Object)tempQty);
        row.getCell("getFormula").setValue((Object)tempQty);
    }

    @Override
    protected void calSimulateOccupyQty(IRow row) {
        for (int i = 0; i < this.kdtStock.getRowCount(); ++i) {
            IRow stockRow = this.kdtStock.getRow(i);
            String materialId = stockRow.getCell("material.id").getValue().toString();
            String measureUnitId = stockRow.getCell("unitid").getValue().toString();
            int precision = new Integer(this.voResult.getMmuPrecisions().get(materialId + measureUnitId).toString());
            if (precision == 8) {
                NumberFormat df = CtrlFormatUtilities.getDecimalFormat();
                stockRow.getCell("imiateOccupy").setValue((Object)df.format(NumericUtil.emptyToZero(this.ZERO)));
                continue;
            }
            stockRow.getCell("imiateOccupy").setValue((Object)NumericUtil.emptyToZero(this.ZERO));
        }
    }
}

