/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.IProductTransactionType;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeCollection;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeFactory;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.util.enums.IntEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MOProductTransactionTypeUtil {
    public static final String REGEX = "!";

    public static ProductTransactionTypeInfo getDefaultTransType(Context ctx, MaterialInfo material, MaterialPlanInfo materialPlan, StorageOrgUnitInfo org, AdminOrgUnitInfo admin, String bizTypeID) throws BOSException, EASBizException {
        ProductTransactionTypeInfo productTranType = null;
        productTranType = materialPlan == null ? MOProductTransactionTypeUtil.getMaterialTransType(ctx, material, org) : materialPlan.getProductTranType();
        if (productTranType == null || !EqualsUtil.equals((IntEnum)MMBasedataStatusEnum.OPEN, (IntEnum)productTranType.getStatus()) || !bizTypeID.equalsIgnoreCase("vGXRx5fFSsCYz9Zv7CzzgyQHQ1w=")) {
            productTranType = MOProductTransactionTypeUtil.getDefTransType(ctx, org.getId().toString(), admin == null || admin.getId() == null ? null : admin.getId().toString(), bizTypeID);
        }
        return productTranType;
    }

    public static ProductTransactionTypeInfo getDefTransType(Context ctx, String orgID, String deptID, String bizTypeID) throws BOSException, EASBizException {
        ProductTransactionTypeInfo type = null;
        if (orgID == null || bizTypeID == null) {
            return type;
        }
        String orgDeptID = null;
        if (deptID != null) {
            orgDeptID = orgID + REGEX + deptID;
        }
        if (orgDeptID != null) {
            type = MOProductTransactionTypeUtil.getDefTransTypeByOrgAndDept(ctx, orgDeptID, bizTypeID);
        }
        if (type == null) {
            type = MOProductTransactionTypeUtil.getDefTransTypeByOrg(ctx, orgID, bizTypeID);
        }
        return type;
    }

    public static ProductTransactionTypeInfo getDefTransTypeByOrgAndDept(Context ctx, String orgDeptID, String bizTypeID) throws BOSException, EASBizException {
        ProductTransactionTypeInfo type = null;
        Map typeMap = MOProductTransactionTypeUtil.getDefTransTypeByOrgAndDept(ctx, new String[]{orgDeptID}, bizTypeID);
        if (typeMap != null && typeMap.size() > 0) {
            type = (ProductTransactionTypeInfo)typeMap.get(orgDeptID);
        }
        return type;
    }

    public static Map getDefTransTypeByOrgAndDept(Context ctx, String[] orgDeptIDs, String bizTypeID) throws BOSException, EASBizException {
        if (orgDeptIDs == null || bizTypeID == null) {
            return null;
        }
        HashMap<String, ProductTransactionTypeInfo> transTypes = new HashMap<String, ProductTransactionTypeInfo>();
        HashSet<String> keys = new HashSet<String>();
        String key2 = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        int filterIndex = 0;
        StringBuffer maskString = new StringBuffer();
        for (String key2 : orgDeptIDs) {
            if (keys.contains(key2)) continue;
            keys.add(key2);
            String[] ids = key2.split(REGEX);
            if (ids.length == 1) continue;
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)ids[0]));
            filterInfo.getFilterItems().add(new FilterItemInfo("adminDepartment.id", (Object)ids[1]));
            if (filterIndex == 0) {
                maskString.append("((#").append(filterIndex++).append(" and #").append(filterIndex++).append(")");
                continue;
            }
            maskString.append(" or (#").append(filterIndex++).append(" and #").append(filterIndex++).append(")");
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)bizTypeID));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20)));
        maskString.append(") and #").append(filterIndex++).append(" and #").append(filterIndex++).append(" and #").append(filterIndex++);
        filterInfo.setMaskString(maskString.toString());
        viewInfo.setFilter(filterInfo);
        ProductTransactionTypeCollection prodCol = MOProductTransactionTypeUtil.getTransTypes(ctx, viewInfo);
        ProductTransactionTypeInfo type = null;
        if (prodCol != null && prodCol.size() > 0) {
            int size = prodCol.size();
            for (int i = 0; i < size; ++i) {
                type = prodCol.get(i);
                key2 = type.getStorageOrgUnit().getId().toString() + REGEX + type.getAdminDepartment().getId().toString();
                if (transTypes.containsKey(key2)) continue;
                transTypes.put(key2, type);
            }
        }
        return transTypes;
    }

    public static ProductTransactionTypeInfo getDefTransTypeByOrg(Context ctx, String orgID, String bizTypeID) throws BOSException, EASBizException {
        ProductTransactionTypeInfo type = null;
        Map typeMap = MOProductTransactionTypeUtil.getDefTransTypeByOrg(ctx, new String[]{orgID}, bizTypeID);
        if (typeMap != null && typeMap.size() > 0) {
            type = (ProductTransactionTypeInfo)typeMap.get(orgID);
        }
        return type;
    }

    public static Map getDefTransTypeByOrg(Context ctx, String[] orgIDs, String bizTypeID) throws BOSException, EASBizException {
        if (orgIDs == null || bizTypeID == null) {
            return null;
        }
        HashMap<String, ProductTransactionTypeInfo> transTypes = new HashMap<String, ProductTransactionTypeInfo>();
        HashSet<String> orgs = new HashSet<String>();
        String orgID2 = null;
        for (String orgID2 : orgIDs) {
            if (orgs.contains(orgID2)) continue;
            orgs.add(orgID2);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", orgs, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)bizTypeID));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20)));
        filterInfo.getFilterItems().add(new FilterItemInfo("adminDepartment", null, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        ProductTransactionTypeCollection prodCol = MOProductTransactionTypeUtil.getTransTypes(ctx, viewInfo);
        ProductTransactionTypeInfo type = null;
        if (prodCol != null && prodCol.size() > 0) {
            int size = prodCol.size();
            for (int i = 0; i < size; ++i) {
                type = prodCol.get(i);
                orgID2 = type.getStorageOrgUnit().getId().toString();
                if (transTypes.containsKey(orgID2)) continue;
                transTypes.put(orgID2, type);
            }
        }
        return transTypes;
    }

    public static ProductTransactionTypeCollection getTransTypes(Context ctx, EntityViewInfo viewInfo) throws BOSException {
        if (viewInfo == null) {
            return null;
        }
        IProductTransactionType ptType = null;
        ptType = ctx == null ? ProductTransactionTypeFactory.getRemoteInstance() : ProductTransactionTypeFactory.getLocalInstance((Context)ctx);
        viewInfo.setSelector(MOProductTransactionTypeUtil.getSelectors());
        ProductTransactionTypeCollection prodCol = ptType.getProductTransactionTypeCollection(viewInfo);
        return prodCol;
    }

    public static ProductTransactionTypeInfo getMaterialTransType(Context ctx, MaterialInfo material, StorageOrgUnitInfo storage) throws BOSException {
        if (material == null || storage == null) {
            return null;
        }
        ProductTransactionTypeInfo transType = null;
        MaterialPlanInfo materialPlanInfo = null;
        IMaterialPlan iMaterial = null;
        iMaterial = ctx == null ? MaterialPlanFactory.getRemoteInstance() : MaterialPlanFactory.getLocalInstance((Context)ctx);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        selectorItemCollection.add(new SelectorItemInfo("number"));
        selectorItemCollection.add(new SelectorItemInfo("name"));
        selectorItemCollection.add(new SelectorItemInfo("material.id"));
        selectorItemCollection.add(new SelectorItemInfo("orgUnit.id"));
        selectorItemCollection.add(new SelectorItemInfo("productTranType.id"));
        selectorItemCollection.add(new SelectorItemInfo("productTranType.number"));
        selectorItemCollection.add(new SelectorItemInfo("productTranType.name"));
        selectorItemCollection.add(new SelectorItemInfo("productTranType.status"));
        selectorItemCollection.add(new SelectorItemInfo("productTranType.bizType"));
        selectorItemCollection.add(new SelectorItemInfo("productTranType.isConsiderLossRatio"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storage.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("productTranType.status", (Object)new Integer(20), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorItemCollection);
        MaterialPlanCollection materialPlanCollection = iMaterial.getMaterialPlanCollection(entityViewInfo);
        if (materialPlanCollection != null && materialPlanCollection.size() > 0 && (materialPlanInfo = materialPlanCollection.get(0)) != null) {
            transType = materialPlanInfo.getProductTranType();
        }
        return transType;
    }

    public static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bizType.*"));
        sic.add(new SelectorItemInfo("defaultBFWarehouse.*"));
        sic.add(new SelectorItemInfo("defaultBFLocation.*"));
        return sic;
    }
}

