/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.IStandardRooting;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.PBOMFactory;
import com.kingdee.eas.mm.basedata.PBOMInfo;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.mo.util.MORootingUtil;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MOUntil {
    public static BatchActionResults checkMOClose(Context ctx, BatchActionResults batchResults, String idStr, String tableName, BatchActionEnum action) throws BOSException, EASBizException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select t.fid ");
        selectSql.append(" from T_MM_ManufactureOrder mo ");
        selectSql.append(" inner join ").append(tableName).append(" t on t.fSourceBillID = mo.fid ");
        selectSql.append(" where t.fid in (").append(idStr).append(") ").append(" and mo.fBaseStatus in (6,7,11)  and t.FsourceBillTypeid = 'B2aZSVXaSx6qxdfekgCmrEY+1VI=' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        String msg = null;
        msg = action.equals((Object)BatchActionEnum.UNAUDIT) ? MOUntil.getString(ctx, "Unaudit_Order_Is_Closed") : MOUntil.getString(ctx, "Audit_Order_Is_Closed");
        try {
            while (rs != null && rs.next()) {
                batchResults.addError(rs.getString("fid"), msg);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return batchResults;
    }

    public static String getString(Context ctx, String resourceName) {
        String path = "com.kingdee.eas.mm.mo.ScrapOrderResource";
        String strTemp = ResourceBase.getString((String)path, (String)resourceName, (Locale)ctx.getLocale());
        if (strTemp.equals("Missing Resource")) {
            return "Missing Resource{" + resourceName + "}";
        }
        return strTemp;
    }

    public static Map searchPBOM(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (param.get("bomID") == null) {
            map.put("pbomInfo", null);
            map.put("routingID", null);
            return map;
        }
        String storageOrgUnitID = param.get("storageOrgUnitID").toString();
        String routingID = null;
        if (param.get("routingID") != null) {
            routingID = param.get("routingID").toString();
        }
        String bomID = param.get("bomID").toString();
        BomInfo bom = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectUuidPK(bomID));
        ProjectInfo pInfo = (ProjectInfo)param.get("pInfo");
        TrackNumberInfo tInfo = (TrackNumberInfo)param.get("tInfo");
        StringBuffer sb = new StringBuffer();
        sb.append("delete t_mm_pbomentry where fid in (").append("select t1.fid from t_mm_pbom t0 inner join t_mm_pbomentry t1 on t0.fid = t1.fparentid ").append("left outer join t_mm_bomentry t2 on t1.fbomitemid = t2.fid ").append("where t2.fid is null ").append("and t0.fbomid = ? ");
        if (routingID != null) {
            sb.append("and t0.froutingid = ? ");
        }
        sb.append(")");
        if (routingID != null) {
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new String[]{bomID, routingID});
        } else {
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new String[]{bomID});
        }
        PBOMInfo pbomInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bom.id", (Object)bomID));
        if (routingID != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("routing.id", (Object)routingID));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID));
        if (bom.getBomType() == BOMTypeEnum.OrderBOM) {
            if (pInfo != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("project.id", (Object)pInfo.getId().toString()));
            }
            if (tInfo != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)tInfo.getId().toString()));
            }
        }
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("bom.*"));
        sic.add(new SelectorItemInfo("bom.orderBomTP.*"));
        sic.add(new SelectorItemInfo("routing.*"));
        sic.add(new SelectorItemInfo("routing.material.*"));
        sic.add(new SelectorItemInfo("pbomEntry.*"));
        sic.add(new SelectorItemInfo("pbomEntry.bomItem.*"));
        sic.add(new SelectorItemInfo("pbomEntry.bomItem.material.*"));
        sic.add(new SelectorItemInfo("pbomEntry.bomItem.unit.*"));
        sic.add(new SelectorItemInfo("pbomEntry.bomItem.supplyOrgUnit.*"));
        sic.add(new SelectorItemInfo("pbomEntry.bomItem.defaultWarehouse.*"));
        sic.add(new SelectorItemInfo("pbomEntry.routingItem.*"));
        sic.add(new SelectorItemInfo("pbomEntry.routingItem.*"));
        sic.add(new SelectorItemInfo("pbomEntry.routingItem.operation.*"));
        sic.add(new SelectorItemInfo("trackNumber.*"));
        sic.add(new SelectorItemInfo("project.*"));
        viewInfo.setSelector(sic);
        viewInfo.getSorter().add(new SorterItemInfo("routing.number"));
        CoreBaseCollection pbomCol = PBOMFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        if (pbomCol.size() > 0 && pbomCol.get(0) != null) {
            pbomInfo = (PBOMInfo)pbomCol.get(0);
            if (routingID != null) {
                map.put("routingID", routingID);
            } else {
                map.put("routingID", pbomInfo.getRouting().getId().toString());
            }
        } else {
            Object isRoutingChangeObject = param.get("IsRoutingChange");
            if (isRoutingChangeObject == null || !((Boolean)isRoutingChangeObject).booleanValue()) {
                filterInfo.getFilterItems().clear();
                filterInfo.getFilterItems().add(new FilterItemInfo("bom.id", (Object)bomID));
                filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID));
                if (bom.getBomType() == BOMTypeEnum.OrderBOM) {
                    if (pInfo != null) {
                        filterInfo.getFilterItems().add(new FilterItemInfo("project.id", (Object)pInfo.getId().toString()));
                    }
                    if (tInfo != null) {
                        filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)tInfo.getId().toString()));
                    }
                }
                viewInfo.setFilter(filterInfo);
                viewInfo.setSelector(sic);
                pbomCol = PBOMFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
                if (pbomCol.size() > 0 && pbomCol.get(0) != null) {
                    pbomInfo = (PBOMInfo)pbomCol.get(0);
                    map.put("routingID", pbomInfo.getRouting().getId().toString());
                }
            }
        }
        map.put("pbomInfo", (String)pbomInfo);
        return map;
    }

    public static void getDefaultRouting(Context ctx, String materialID, String storageOrgUnitID, ProductTransactionTypeInfo transInfo, Map inParam, Map outParam) throws BOSException, EASBizException {
        StandardRootingInfo rooting;
        boolean isDefaultRouting = false;
        if (transInfo != null && !transInfo.isIsWPManagement() && transInfo.getBizType() != null && ("yRPu9BAfSRuIIEu9QnyxviQHQ1w=".equals(transInfo.getBizType().getId().toString()) || "PF40lAXWJXTgU6hCqMCewyQHQ1w=".equals(transInfo.getBizType().getId().toString()))) {
            isDefaultRouting = true;
        }
        if (!isDefaultRouting) {
            Object isBOMChangeObject = inParam.get("IsBOMChange");
            String mainRouting = null;
            if (isBOMChangeObject == null || !((Boolean)isBOMChangeObject).booleanValue()) {
                mainRouting = MOUntil.getMainRouting(ctx, materialID, storageOrgUnitID);
            }
            HashMap<String, String> tmpPBomMap = new HashMap<String, String>();
            tmpPBomMap.put("storageOrgUnitID", storageOrgUnitID);
            String bomID = null;
            if (inParam.get("BOM") != null) {
                bomID = ((BomInfo)inParam.get("BOM")).getId().toString();
            }
            tmpPBomMap.put("bomID", bomID);
            tmpPBomMap.put("pInfo", (String)((ProjectInfo)inParam.get("projectID")));
            tmpPBomMap.put("tInfo", (String)((TrackNumberInfo)inParam.get("trackID")));
            if (inParam.get("ROUTINGID") != null) {
                tmpPBomMap.put("routingID", (String)inParam.get("ROUTINGID"));
            } else {
                tmpPBomMap.put("routingID", mainRouting);
            }
            if (inParam.get("IsRoutingChange") != null) {
                tmpPBomMap.put("IsRoutingChange", (String)inParam.get("IsRoutingChange"));
            }
            Map mapPBom = MOUntil.searchPBOM(ctx, tmpPBomMap);
            PBOMInfo pbomInfo = (PBOMInfo)mapPBom.get("pbomInfo");
            String pbomRoutingID = (String)mapPBom.get("routingID");
            if (isBOMChangeObject != null && ((Boolean)isBOMChangeObject).booleanValue()) {
                mainRouting = MOUntil.getMainRouting(ctx, materialID, storageOrgUnitID);
            }
            StandardRootingInfo pbomRoutingInfo = null;
            if (pbomRoutingID != null && !(pbomRoutingInfo = StandardRootingFactory.getLocalInstance((Context)ctx).getStandardRootingInfo((IObjectPK)new ObjectUuidPK(pbomRoutingID))).getStatus().equals((Object)MMBasedataStatusEnum.AUDIT)) {
                pbomRoutingInfo = null;
            }
            if (pbomInfo != null && pbomRoutingInfo != null) {
                if (outParam != null) {
                    outParam.put("ROUTING", pbomRoutingInfo);
                }
                inParam.put("ROUTINGID", pbomRoutingID);
                inParam.put("PBOMID", pbomInfo.getId().toString());
            } else if (inParam.get("ROUTINGID") != null) {
                String tmpRoutingID = (String)inParam.get("ROUTINGID");
                if (outParam != null) {
                    outParam.put("ROUTING", StandardRootingFactory.getLocalInstance((Context)ctx).getStandardRootingInfo((IObjectPK)new ObjectUuidPK(tmpRoutingID)));
                }
                inParam.put("ROUTINGID", tmpRoutingID);
            } else if (mainRouting != null) {
                if (outParam != null) {
                    outParam.put("ROUTING", StandardRootingFactory.getLocalInstance((Context)ctx).getStandardRootingInfo((IObjectPK)new ObjectUuidPK(mainRouting)));
                }
                inParam.put("ROUTINGID", mainRouting);
            } else {
                isDefaultRouting = true;
            }
        }
        if (isDefaultRouting && (rooting = MORootingUtil.getDefaultRooting(ctx, transInfo, storageOrgUnitID)) != null) {
            if (outParam != null) {
                outParam.put("ROUTING", rooting);
            }
            inParam.put("ROUTINGID", rooting.getId().toString());
        }
    }

    public static String getMainRouting(Context ctx, String materialID, String storageOrgUnitID) throws BOSException, EASBizException {
        String strRouting = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(60)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isMainRooting", (Object)Boolean.TRUE));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(MOUntil.getSelectors4Routing());
        IStandardRooting routing = StandardRootingFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection col = routing.getCollection(viewInfo);
        if (col.size() > 0 && col.get(0) != null) {
            strRouting = ((StandardRootingInfo)col.get(0)).getId().toString();
        }
        return strRouting;
    }

    public static SelectorItemCollection getSelectors4Routing() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        return sic;
    }
}

