/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.util;

import com.kingdee.eas.common.SysConstant;
import java.math.BigDecimal;

public class NumericUtil {
    public static Object zeroToEmpty(Object value) {
        if (value == null || String.valueOf(value).matches("0(\\.[0]{1,})?")) {
            return null;
        }
        return value;
    }

    public static BigDecimal emptyToZero(Object value) {
        if (value == null) {
            return new BigDecimal("0");
        }
        if (value instanceof String) {
            if (value.equals("")) {
                return new BigDecimal("0");
            }
            return new BigDecimal(value.toString());
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal("0");
    }

    public static boolean areEqual(BigDecimal a, BigDecimal b) {
        return a.compareTo(b) == 0;
    }

    public static boolean isNullOrZero(BigDecimal x) {
        return x == null ? true : NumericUtil.areEqual(x, SysConstant.BIGZERO);
    }

    public static boolean equals(BigDecimal b1, BigDecimal b2) {
        if (b1 == null || b1.signum() == 0) {
            return b2 == null || b2.signum() == 0;
        }
        if (b2 == null || b2.signum() == 0) {
            return false;
        }
        return b1.compareTo(b2) == 0;
    }
}

