/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.pdm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.TreePathUtil;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.pdm.ExtendFieldMappingCollection;
import com.kingdee.eas.mm.pdm.ExtendFieldMappingFactory;
import com.kingdee.eas.mm.pdm.ExtendFieldMappingInfo;
import com.kingdee.eas.mm.pdm.ExtendMappingObject;
import com.kingdee.eas.mm.pdm.ExtendObjectMappingEnum;
import com.kingdee.eas.mm.pdm.IExtendFieldMapping;
import com.kingdee.eas.mm.pdm.WSMetaDataField;
import com.kingdee.eas.mm.pdm.client.AbstractExtendFieldMappingUI;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ExtendFieldMappingUI
extends AbstractExtendFieldMappingUI {
    private static final long serialVersionUID = 1L;
    private final String COL_ID = "id";
    private final String COL_EXTENDFIELDNAME = "extendFieldName";
    private final String COL_MAPPINGBONAME = "mappingBOName";
    private final String COL_MAPPINGFIELDNAME = "mappingFieldName";
    private final String COL_REMARK = "reMark";
    private TreeSelectionListener treeSelectionListener = null;
    private KDTEditAdapter tableChangeListener = null;
    private KDTreeNode selectNote = null;
    private ExtendMappingObject extendMappingObject = this.getRemoteInstance().getMappingFields();
    private final String NEWID = "NewID";
    private final String SAVEDID = "SavedID";

    public ExtendFieldMappingUI() throws Exception {
        this.setIsNeedDefaultFilter(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.iniTable();
        this.initMenu();
        this.buildTree();
        this.refreshTable((MappingNode)this.selectNote.getUserObject());
        this.menuView.setVisible(false);
        this.btnLocate.setVisible(false);
        this.setActionEnable(false);
        this.tblMain.getActionMap().remove("FocusChangeCol");
        this.addLinsener();
    }

    private void addLinsener() {
        if (null == this.treeSelectionListener) {
            this.treeSelectionListener = new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    try {
                        ExtendFieldMappingUI.this.treeSelectChange(e);
                    }
                    catch (Exception ex) {
                        ExtendFieldMappingUI.this.handUIException(ex);
                    }
                }
            };
        }
        this.kDTree.addTreeSelectionListener(this.treeSelectionListener);
        if (null == this.tableChangeListener) {
            this.tableChangeListener = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        ExtendFieldMappingUI.this.mainTableChange(e);
                    }
                    catch (Exception exc) {
                        ExtendFieldMappingUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.tblMain.addKDTEditListener((KDTEditListener)this.tableChangeListener);
    }

    protected void mainTableChange(KDTEditEvent e) {
        Object newValue;
        Object oldValue = e.getOldValue();
        if (SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = e.getValue()))) {
            this.isModify = true;
            if (e.getColIndex() == this.tblMain.getColumnIndex("extendFieldName")) {
                this.tblMain.getCell(e.getRowIndex(), this.tblMain.getColumnIndex("mappingFieldName")).setValue(null);
            }
        }
    }

    protected void treeSelectChange(TreeSelectionEvent e) throws Exception {
        this.removeLinsener();
        try {
            if (this.isModify) {
                int userChoice = MsgBox.showConfirm3((String)this.getResource("IS_SAVE"));
                if (userChoice == 0) {
                    this.actionSave_actionPerformed(new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand()));
                    if (this.isModify) {
                        this.selectNote = (KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                        this.refreshTable((MappingNode)this.selectNote.getUserObject());
                    }
                } else if (userChoice == 1) {
                    this.isModify = false;
                    this.selectNote = (KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                    this.refreshTable((MappingNode)this.selectNote.getUserObject());
                } else if (userChoice == 2) {
                    this.kDTree.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.kDTree, (TreeModel)this.kDTree.getModel(), (TreePath)e.getOldLeadSelectionPath()));
                }
            } else {
                this.selectNote = (KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                this.refreshTable((MappingNode)this.selectNote.getUserObject());
            }
        }
        finally {
            this.addLinsener();
        }
    }

    private void removeLinsener() {
        if (null != this.treeSelectionListener) {
            this.kDTree.removeTreeSelectionListener(this.treeSelectionListener);
        }
        if (null != this.tableChangeListener) {
            this.tblMain.removeKDTEditListener((KDTEditListener)this.tableChangeListener);
        }
    }

    private void setActionEnable(boolean isEnable) {
        this.actionEdit.setEnabled(!isEnable);
        this.actionSave.setEnabled(isEnable);
        this.actionAddLine.setEnabled(isEnable);
        this.actionInsertLine.setEnabled(isEnable);
        this.actionDeleteLine.setEnabled(isEnable);
        this.tblMain.setEditable(isEnable);
        this.tblMain.setEnabled(isEnable);
    }

    private void buildTree() {
        this.kDTreeView.getControlPane().setVisible(false);
        this.kDTree.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel model = (DefaultTreeModel)this.kDTree.getModel();
        KDTreeNode rootNode = new KDTreeNode((Object)"Root");
        model.setRoot((TreeNode)rootNode);
        this.kDTree.setRootVisible(false);
        ArrayList enumList = new ArrayList(ExtendObjectMappingEnum.getEnumList());
        enumList.remove((Object)ExtendObjectMappingEnum.MaterialPlan);
        KDTreeNode leaf = null;
        for (int i = 0; i < enumList.size(); ++i) {
            ExtendObjectMappingEnum eome = (ExtendObjectMappingEnum)((Object)enumList.get(i));
            leaf = new KDTreeNode((Object)new MappingNode(eome.getAlias(this.getLocale()), eome.getValue()));
            model.insertNodeInto((MutableTreeNode)leaf, (MutableTreeNode)rootNode, i);
        }
        if (model != null && model.getRoot() != null) {
            this.kDTree.expandPath(new TreePath(model.getRoot()));
        }
        TreePath path = new TreePath(rootNode).pathByAddingChild(rootNode.getChildAt(0));
        this.kDTree.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.kDTree, (TreeModel)this.kDTree.getModel(), (TreePath)path));
        this.selectNote = (KDTreeNode)rootNode.getChildAt(0);
    }

    private void refreshTable(MappingNode note) throws BOSException {
        if (note == null) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("mappingBOName", (Object)note.getType()));
        ev.setSelector(this.getSelectors());
        ev.setFilter(fi);
        ExtendFieldMappingCollection efmc = this.getRemoteInstance().getExtendFieldMappingCollection(ev);
        this.bindingColToTable(efmc);
    }

    private void bindingColToTable(ExtendFieldMappingCollection efmc) {
        this.tblMain.removeRows();
        if (efmc == null || efmc.size() == 0) {
            return;
        }
        for (int i = 0; i < efmc.size(); ++i) {
            IRow row = this.tblMain.addRow();
            ExtendFieldMappingInfo efmi = efmc.get(i);
            this.bindingInfoToRow(efmi, row);
        }
    }

    private void bindingInfoToRow(ExtendFieldMappingInfo efmi, IRow row) {
        row.getCell("id").setValue((Object)efmi.getId().toString());
        row.getCell("extendFieldName").setValue((Object)efmi.getExtendFieldName());
        row.getCell("mappingBOName").setValue((Object)efmi.getMappingBOName());
        row.getCell("mappingFieldName").setValue((Object)efmi.getMappingFieldName());
        row.getCell("reMark").setValue((Object)efmi.getReMark());
    }

    private void initMenu() {
        this.btnAuditResult.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.enableActionMenu();
    }

    private void enableActionMenu() {
        this.actionAddLine.setEnabled(false);
        this.actionInsertLine.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.actionSave.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.tblMain.setEditable(false);
    }

    private void iniTable() {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(false);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        KDTextField txt = new KDTextField();
        txt.setMaxLength(255);
        this.tblMain.getColumn("reMark").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txt));
        KDComboBox kdcExtendFieldName = new KDComboBox();
        kdcExtendFieldName.setName("extendFieldName");
        kdcExtendFieldName.setEnabled(true);
        KDTDefaultCellEditor kdtExtendFieldName = new KDTDefaultCellEditor((JComboBox)kdcExtendFieldName);
        this.tblMain.getColumn("extendFieldName").setEditor((ICellEditor)kdtExtendFieldName);
        KDComboBox kdcMappingBOName = new KDComboBox();
        kdcMappingBOName.setName("mappingBOName");
        kdcMappingBOName.setEnabled(true);
        kdcMappingBOName.addItems(EnumUtils.getEnumList((String)ExtendObjectMappingEnum.class.getName()).toArray());
        KDTDefaultCellEditor kdtMappingBOName = new KDTDefaultCellEditor((JComboBox)kdcMappingBOName);
        this.tblMain.getColumn("mappingBOName").setEditor((ICellEditor)kdtMappingBOName);
        this.tblMain.getColumn("mappingBOName").getStyleAttributes().setLocked(true);
        KDComboBox kdcMappingFieldName = new KDComboBox();
        kdcMappingFieldName.setName("mappingFieldName");
        kdcMappingFieldName.setEnabled(true);
        KDTDefaultCellEditor kdtMappingFieldName = new KDTDefaultCellEditor((JComboBox)kdcMappingFieldName);
        this.tblMain.getColumn("extendFieldName").setEditor((ICellEditor)kdtMappingFieldName);
        this.tblMain.getSelectManager().setSelectMode(15);
    }

    protected String getEntityBOSType() throws Exception {
        return "5FD82439";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    private IExtendFieldMapping getRemoteInstance() throws BOSException {
        return ExtendFieldMappingFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("extendFieldName"));
        sic.add(new SelectorItemInfo("mappingBOName"));
        sic.add(new SelectorItemInfo("mappingFieldName"));
        sic.add(new SelectorItemInfo("reMark"));
        return sic;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (!this.tblMain.isEnabled()) {
            return;
        }
        int beginRow = e.getSelectBlock().getBeginRow();
        int endRow = e.getSelectBlock().getEndRow();
        int beginCol = e.getSelectBlock().getBeginCol();
        int endCol = e.getSelectBlock().getEndCol();
        if (beginRow != endRow) {
            return;
        }
        int type = ((MappingNode)this.selectNote.getUserObject()).getType();
        if (beginCol == this.tblMain.getColumnIndex("extendFieldName")) {
            String selectItem = null;
            if (this.tblMain.getCell(beginRow, beginCol).getValue() != null) {
                selectItem = (String)this.tblMain.getCell(beginRow, beginCol).getValue();
            }
            if (type == 10) {
                this.setExtendFieldComboBox(beginRow, beginCol, this.extendMappingObject.getMaterialMiddleFields());
            } else if (type == 30) {
                this.setExtendFieldComboBox(beginRow, beginCol, this.extendMappingObject.getBomMiddleFields());
            } else if (type == 40) {
                this.setExtendFieldComboBox(beginRow, beginCol, this.extendMappingObject.getBomEntryMiddleFields());
            } else if (type == 50) {
                this.setExtendFieldComboBox(beginRow, beginCol, this.extendMappingObject.getStaMiddleFields());
            } else if (type == 60) {
                this.setExtendFieldComboBox(beginRow, beginCol, this.extendMappingObject.getStaEntryMiddleFields());
            } else if (type == 70) {
                this.setExtendFieldComboBox(beginRow, beginCol, this.extendMappingObject.getMrMiddleFields());
            } else if (type == 80) {
                this.setExtendFieldComboBox(beginRow, beginCol, this.extendMappingObject.getMrEntryMiddleFields());
            }
            if (!StringUtils.isEmpty((String)selectItem)) {
                this.tblMain.getCell(beginRow, beginCol).setValue((Object)selectItem);
            }
        } else {
            if (beginCol == this.tblMain.getColumnIndex("mappingBOName")) {
                return;
            }
            if (beginCol == this.tblMain.getColumnIndex("mappingFieldName")) {
                String selectItem = null;
                if (this.tblMain.getCell(beginRow, beginCol).getValue() != null) {
                    selectItem = (String)this.tblMain.getCell(beginRow, beginCol).getValue();
                }
                if (this.tblMain.getCell(beginRow, this.tblMain.getColumnIndex("extendFieldName")).getValue() == null) {
                    MsgBox.showInfo((String)this.getResource("SelectExtendField"));
                    SysUtil.abort();
                }
                String extendField = this.tblMain.getCell(beginRow, this.tblMain.getColumnIndex("extendFieldName")).getValue().toString();
                if (type == 10) {
                    String dataType = this.getDataType(extendField, this.extendMappingObject.getMaterialMiddleFields());
                    this.setMappingFieldComboBox(beginRow, beginCol, dataType, this.extendMappingObject.getMaterialFields());
                } else if (type == 30) {
                    String dataType = this.getDataType(extendField, this.extendMappingObject.getBomMiddleFields());
                    this.setMappingFieldComboBox(beginRow, beginCol, dataType, this.extendMappingObject.getBomFields());
                } else if (type == 40) {
                    String dataType = this.getDataType(extendField, this.extendMappingObject.getBomEntryMiddleFields());
                    this.setMappingFieldComboBox(beginRow, beginCol, dataType, this.extendMappingObject.getBomEntryFields());
                } else if (type == 50) {
                    String dataType = this.getDataType(extendField, this.extendMappingObject.getStaMiddleFields());
                    this.setMappingFieldComboBox(beginRow, beginCol, dataType, this.extendMappingObject.getStaFields());
                } else if (type == 60) {
                    String dataType = this.getDataType(extendField, this.extendMappingObject.getStaEntryMiddleFields());
                    this.setMappingFieldComboBox(beginRow, beginCol, dataType, this.extendMappingObject.getStaEntryFields());
                } else if (type == 70) {
                    String dataType = this.getDataType(extendField, this.extendMappingObject.getMrMiddleFields());
                    this.setMappingFieldComboBox(beginRow, beginCol, dataType, this.extendMappingObject.getMrFields());
                } else if (type == 80) {
                    String dataType = this.getDataType(extendField, this.extendMappingObject.getMrEntryMiddleFields());
                    this.setMappingFieldComboBox(beginRow, beginCol, dataType, this.extendMappingObject.getMrEntryFields());
                }
                if (!StringUtils.isEmpty((String)selectItem)) {
                    this.tblMain.getCell(beginRow, beginCol).setValue((Object)selectItem);
                }
            }
        }
    }

    private String getDataType(String extendField, List<WSMetaDataField> extendFields) {
        String dataType = null;
        if (extendFields != null && extendFields.size() > 0) {
            for (int i = 0; i < extendFields.size(); ++i) {
                if (!extendField.equals(extendFields.get(i).getFieldName())) continue;
                dataType = extendFields.get(i).getDataType();
                break;
            }
        }
        return dataType;
    }

    private void setMappingFieldComboBox(int beginRow, int beginCol, String dataType, List<WSMetaDataField> materialFields) {
        if (materialFields == null || materialFields.size() == 0) {
            return;
        }
        if (dataType == null) {
            return;
        }
        ArrayList<String> mappingFields = new ArrayList<String>();
        for (int j = 0; j < materialFields.size(); ++j) {
            if (!dataType.equals(materialFields.get(j).getDataType())) continue;
            mappingFields.add(materialFields.get(j).getFieldName());
        }
        if (mappingFields.size() > 0) {
            KDComboBox kdcMappingFieldName = new KDComboBox();
            kdcMappingFieldName.setName("mappingFieldName");
            kdcMappingFieldName.setEnabled(true);
            kdcMappingFieldName.addItems(mappingFields.toArray());
            kdcMappingFieldName.setSelectedIndex(0);
            kdcMappingFieldName.putClientProperty((Object)"jump", (Object)"false");
            KDTDefaultCellEditor kdtMappingFieldName = new KDTDefaultCellEditor((JComboBox)kdcMappingFieldName);
            this.tblMain.getCell(beginRow, beginCol).setEditor((ICellEditor)kdtMappingFieldName);
            this.tblMain.getCell(beginRow, beginCol).setValue(kdcMappingFieldName.getSelectedItem());
        } else {
            this.tblMain.getCell(beginRow, beginCol).getStyleAttributes().setLocked(true);
        }
    }

    private void setExtendFieldComboBox(int beginRow, int beginCol, List<WSMetaDataField> extendFields) {
        if (extendFields == null || extendFields.size() == 0) {
            return;
        }
        Object[] checkValue = new Object[extendFields.size()];
        for (int i = 0; i < extendFields.size(); ++i) {
            checkValue[i] = extendFields.get(i).getFieldName();
        }
        KDComboBox kdcExtendFieldName = new KDComboBox();
        kdcExtendFieldName.setName("extendFieldName");
        kdcExtendFieldName.setEnabled(true);
        kdcExtendFieldName.addItems(checkValue);
        kdcExtendFieldName.setSelectedIndex(0);
        kdcExtendFieldName.putClientProperty((Object)"jump", (Object)"false");
        KDTDefaultCellEditor kdtExtendFieldName = new KDTDefaultCellEditor((JComboBox)kdcExtendFieldName);
        this.tblMain.getCell(beginRow, beginCol).setEditor((ICellEditor)kdtExtendFieldName);
        this.tblMain.getCell(beginRow, beginCol).setValue(kdcExtendFieldName.getSelectedItem());
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.isModify) {
            this.doSave();
            KDTreeNode selectNote = (KDTreeNode)this.kDTree.getLastSelectedPathComponent();
            this.refreshTable((MappingNode)selectNote.getUserObject());
        }
    }

    private void doSave() throws EASBizException, BOSException {
        this.checkBeforeSave();
        ExtendFieldMappingCollection addCol = new ExtendFieldMappingCollection();
        ExtendFieldMappingCollection updateCol = new ExtendFieldMappingCollection();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            ExtendFieldMappingInfo efmi = new ExtendFieldMappingInfo();
            if (this.tblMain.getRow(i).getCell("id").getValue().equals("NewID")) {
                efmi.setExtendFieldName((String)this.tblMain.getRow(i).getCell("extendFieldName").getValue());
                efmi.setMappingBOName((ExtendObjectMappingEnum)((Object)this.tblMain.getRow(i).getCell("mappingBOName").getValue()));
                efmi.setMappingFieldName((String)this.tblMain.getRow(i).getCell("mappingFieldName").getValue());
                if (this.tblMain.getRow(i).getCell("reMark").getValue() != null) {
                    efmi.setReMark(this.tblMain.getRow(i).getCell("reMark").getValue().toString());
                }
                addCol.add(efmi);
                continue;
            }
            efmi.setId(BOSUuid.read((String)((String)this.tblMain.getRow(i).getCell("id").getValue())));
            efmi.setExtendFieldName((String)this.tblMain.getRow(i).getCell("extendFieldName").getValue());
            efmi.setMappingBOName((ExtendObjectMappingEnum)((Object)this.tblMain.getRow(i).getCell("mappingBOName").getValue()));
            efmi.setMappingFieldName((String)this.tblMain.getRow(i).getCell("mappingFieldName").getValue());
            if (this.tblMain.getRow(i).getCell("reMark").getValue() != null) {
                efmi.setReMark(this.tblMain.getRow(i).getCell("reMark").getValue().toString());
            }
            updateCol.add(efmi);
        }
        this.getRemoteInstance().saveData((IObjectCollection)addCol, (IObjectCollection)updateCol);
        this.isModify = false;
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ArrayList<ObjectStringPK> ids = new ArrayList<ObjectStringPK>();
        for (int i = selectRows.length - 1; i >= 0; --i) {
            if (this.tblMain.getCell(selectRows[i], this.tblMain.getColumnIndex("id")).getValue() != null) {
                String id = (String)this.tblMain.getCell(selectRows[i], this.tblMain.getColumnIndex("id")).getValue();
                ids.add(new ObjectStringPK(id));
            }
            this.tblMain.removeRow(selectRows[i]);
        }
        if (ids.size() > 0) {
            IObjectPK[] pks = new IObjectPK[ids.size()];
            int size = ids.size();
            for (int j = 0; j < size; ++j) {
                pks[j] = (IObjectPK)ids.get(j);
            }
            this.getRemoteInstance().deleteBatchData(pks);
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        IRow row = null;
        if (null == blocks || blocks.size() < 1) {
            row = this.tblMain.addRow();
        } else {
            int rowBeginIndex = ((KDTSelectBlock)blocks.get(0)).getBeginRow();
            if (rowBeginIndex < 0) {
                rowBeginIndex = 0;
            }
            row = this.tblMain.addRow(rowBeginIndex);
        }
        int type = ((MappingNode)this.selectNote.getUserObject()).getType();
        ExtendObjectMappingEnum eome = ExtendObjectMappingEnum.getEnum(type);
        row.getCell("mappingBOName").setValue((Object)eome);
        row.getCell("id").setValue((Object)"NewID");
        this.isModify = true;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tblMain.addRow();
        int type = ((MappingNode)this.selectNote.getUserObject()).getType();
        ExtendObjectMappingEnum eome = ExtendObjectMappingEnum.getEnum(type);
        row.getCell("mappingBOName").setValue((Object)eome);
        row.getCell("id").setValue((Object)"NewID");
        this.isModify = true;
    }

    private void checkBeforeSave() {
        if (this.tblMain.getRowCount() != -1) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                if (this.tblMain.getRow(i).getCell("extendFieldName").getValue() == null) {
                    sb.append(this.getResource("ExtendFieldCanNotNull", new String[]{String.valueOf(i + 1)})).append("\n");
                }
                if (this.tblMain.getRow(i).getCell("mappingFieldName").getValue() != null) continue;
                sb.append(this.getResource("MappingFieldCanNotNull", new String[]{String.valueOf(i + 1)})).append("\n");
            }
            if (!StringUtils.isEmpty((String)sb.toString())) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getResource("BlankData"), (String)sb.toString(), (int)0);
                SysUtil.abort();
            }
        }
    }

    private String getResource(String resName) {
        return ResourceUtils.getMessageForClient((String)"com.kingdee.eas.mm.pdm.ExtendFieldMappingResource", (String)resName);
    }

    private String getResource(String resName, String[] parameters) {
        return ResourceUtils.getMessageForClient((String)"com.kingdee.eas.mm.pdm.ExtendFieldMappingResource", (String)resName, (String[])parameters);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.setActionEnable(true);
    }

    protected boolean checkBeforeWindowClosing() {
        return this.treatBeforeTableRefresh();
    }

    private boolean treatBeforeTableRefresh() {
        boolean returnValue;
        boolean isChange = false;
        if (this.tblMain.getRowCount() < 0) {
            isChange = false;
        }
        IRow row = null;
        int rowSize = this.tblMain.getRowCount();
        for (int i = 0; i < rowSize; ++i) {
            row = this.tblMain.getRow(i);
            if (!this.isModify) continue;
            isChange = true;
            break;
        }
        if (!isChange) {
            returnValue = true;
        } else {
            int userChoice = MsgBox.showConfirm3((String)this.getResource("IS_SAVE"));
            if (userChoice == 0) {
                try {
                    this.doSave();
                    returnValue = true;
                }
                catch (EASBizException e) {
                    this.handleException((Exception)((Object)e));
                    returnValue = false;
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                    returnValue = false;
                }
            } else {
                returnValue = userChoice == 1;
            }
        }
        return returnValue;
    }

    private class MappingNode {
        String name;
        int type;

        public MappingNode(String name, int type) {
            this.name = name;
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }
    }
}

