/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.pdm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.pdm.client.AbstractStandRootingMiddleFilterUI;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class StandRootingMiddleFilterUI
extends AbstractStandRootingMiddleFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(StandRootingMiddleFilterUI.class);
    private DataChangeListener storageOrgUnitChanged = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtlot.setMaxLength(80);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)this.getViewPermission());
        SingleFilterElement mainOrgElement = new SingleFilterElement("link_storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, StandRootingMiddleFilterUI.getResource("STORAGEORG_ISNULL")));
        elements.add((FilterElement)new SingleFilterElement("link_material.number", (Component)this.prmtParentMaterial));
        MMRangeFilterElement elementImport = new MMRangeFilterElement("importDate", (Component)this.importDateFrom, (Component)this.importDateTo);
        elementImport.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elementImport.setDefaultValue((Object)SCMUtils.getDefaultDateRange(null));
        elements.add((FilterElement)elementImport);
        MMRangeFilterElement elementTrans = new MMRangeFilterElement("transferDate", (Component)this.transferFrom, (Component)this.transferTo);
        elementTrans.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)elementTrans);
        this.transferFrom.setValue(null);
        this.transferTo.setValue(null);
        elements.add((FilterElement)new SingleFilterElement("base_lot", (Component)this.txtlot));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.chkSuccessTransmit.setSelected(false);
    }

    protected String getViewPermission() {
        return "mm_standRootingMiddle_view";
    }

    private static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.pdm.StandRootingMiddleResource", (String)strKey);
    }

    protected String getPropertyOfMainBizOrg() {
        return "link_storageOrgUnit.id";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected void initListener() {
        super.initListener();
        this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgUnitChanged);
        this.storageOrgUnitChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object orgOld;
                Object orgNew = e.getNewValue();
                if (SCMGroupClientUtils.isDiffrent((Object)orgNew, (Object)(orgOld = e.getOldValue()))) {
                    StandRootingMiddleFilterUI.this.prmtParentMaterial.setValue(null);
                }
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgUnitChanged);
        this.prmtParentMaterial.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (null != StandRootingMiddleFilterUI.this.prmtStorageOrgUnit.getValue()) {
                    if (StandRootingMiddleFilterUI.this.prmtStorageOrgUnit.getValue() instanceof Object[]) {
                        Object[] objValues = (Object[])StandRootingMiddleFilterUI.this.prmtStorageOrgUnit.getValue();
                        StandRootingMiddleFilterUI.this.initF7Material((OrgUnitInfo)objValues[0], StandRootingMiddleFilterUI.this.prmtParentMaterial);
                    } else if (StandRootingMiddleFilterUI.this.prmtStorageOrgUnit.getValue() instanceof Object) {
                        Object objValue = StandRootingMiddleFilterUI.this.prmtStorageOrgUnit.getValue();
                        StandRootingMiddleFilterUI.this.initF7Material((OrgUnitInfo)objValue, StandRootingMiddleFilterUI.this.prmtParentMaterial);
                    }
                }
            }
        });
    }

    protected void initF7Material(OrgUnitInfo orgUnitInfo, KDBizPromptBox prmtParentMaterial) {
        try {
            prmtParentMaterial.setEditFormat("$number$");
            prmtParentMaterial.setDisplayFormat("$number$");
            prmtParentMaterial.setCommitFormat("$number$;$name$;$model$;$helpCode$");
            int f7DisplayMode = SCMGroupClientUtils.getF7DisplayMode((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            if (f7DisplayMode == 0) {
                String materialGroupQuery = "com.kingdee.eas.mm.pdm.app.F7MaterialGroupQuery";
                String materialNoGroupQuery = "com.kingdee.eas.mm.pdm.app.F7MaterialNoGroupQuery";
                GeneralKDPromptSelectorAdaptor selectorLisenterMaterial = new GeneralKDPromptSelectorAdaptor((KDPromptBox)prmtParentMaterial, "com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI", (Object)this, MaterialGroupInfo.getBosType(), materialGroupQuery, "materialGroup.id", null, materialNoGroupQuery);
                selectorLisenterMaterial.setIsMultiSelect(true);
                prmtParentMaterial.setSelector((KDPromptSelector)selectorLisenterMaterial);
                prmtParentMaterial.addSelectorListener((SelectorListener)selectorLisenterMaterial);
                this.entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                if (orgUnitInfo != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)orgUnitInfo.getCU().getId().toString(), CompareType.EQUALS));
                }
                this.entityViewInfo.setFilter(filterInfo);
            } else {
                prmtParentMaterial.setQueryInfo("com.kingdee.eas.mm.pdm.app.F7MaterialNoGroupQuery");
                this.entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                if (orgUnitInfo != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgUnitInfo.getCU().getId().toString(), CompareType.EQUALS));
                }
                this.entityViewInfo.setFilter(filterInfo);
            }
            prmtParentMaterial.setEditable(true);
            prmtParentMaterial.setEnabledMultiSelection(true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        HashSet<Integer> flagSet = new HashSet<Integer>();
        FilterInfo filter = new FilterInfo();
        if (this.chkHasNotTransmit.isSelected()) {
            flagSet.add(new Integer(10));
        }
        if (this.chkSuccessTransmit.isSelected()) {
            flagSet.add(new Integer(20));
        }
        if (this.chkFailTransmit.isSelected()) {
            flagSet.add(new Integer(30));
        }
        if (this.chkSuccessMatched.isSelected()) {
            flagSet.add(new Integer(40));
        }
        if (this.chkFailMatched.isSelected()) {
            flagSet.add(new Integer(50));
        }
        if (this.chkNotTransmit.isSelected()) {
            flagSet.add(new Integer(60));
        }
        filter.getFilterItems().add(new FilterItemInfo("flag", flagSet, CompareType.INCLUDE));
        HashSet<Integer> optTypeSet = new HashSet<Integer>();
        if (this.chkUpdate.isSelected()) {
            optTypeSet.add(new Integer(10));
        }
        if (this.chkDelete.isSelected()) {
            optTypeSet.add(new Integer(20));
        }
        filter.getFilterItems().add(new FilterItemInfo("base_operationType", optTypeSet, CompareType.INCLUDE));
        if (this.prmtParentMaterial.getValue() != null) {
            Object[] objects;
            MaterialInfo[] materialInfos = null;
            if (this.prmtParentMaterial.getValue() instanceof MaterialInfo[]) {
                materialInfos = (MaterialInfo[])this.prmtParentMaterial.getValue();
            } else if (this.prmtParentMaterial.getValue() instanceof MaterialInfo) {
                materialInfos = new MaterialInfo[]{(MaterialInfo)this.prmtParentMaterial.getValue()};
            } else if (this.prmtParentMaterial.getValue() instanceof Object[] && (objects = (Object[])this.prmtParentMaterial.getValue()).length != 0) {
                materialInfos = new MaterialInfo[objects.length];
                System.arraycopy(objects, 0, materialInfos, 0, objects.length);
            }
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < materialInfos.length; ++i) {
                ids.add(materialInfos[i].getId().toString());
            }
            if (ids.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("link_material.id", ids, CompareType.INCLUDE));
            }
        }
        try {
            if (filterInfo == null) {
                filterInfo = new FilterInfo();
            }
            filterInfo.mergeFilter(filter, "and");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    public boolean verify() {
        boolean flag = super.verify();
        if (flag) {
            boolean hasSelected = false;
            KDCheckBox[] flags = this.getFlagCheckBoxes();
            for (int i = 0; i < flags.length; ++i) {
                if (!flags[i].isSelected()) continue;
                hasSelected = true;
                break;
            }
            if (!hasSelected) {
                MsgBox.showWarning((Component)((Object)this), (String)StandRootingMiddleFilterUI.getResource("Flag_Not_Selected"));
                flag = false;
            }
            hasSelected = false;
            KDCheckBox[] optTypes = this.getOptTypeCheckBoxes();
            for (int i = 0; i < optTypes.length; ++i) {
                if (!optTypes[i].isSelected()) continue;
                hasSelected = true;
                break;
            }
            if (!hasSelected) {
                MsgBox.showWarning((Component)((Object)this), (String)StandRootingMiddleFilterUI.getResource("OptType_Not_Selected"));
                flag = false;
            }
        }
        return flag;
    }

    private KDCheckBox[] getOptTypeCheckBoxes() {
        KDCheckBox[] box = new KDCheckBox[]{this.chkUpdate, this.chkDelete};
        return box;
    }

    private KDCheckBox[] getFlagCheckBoxes() {
        KDCheckBox[] box = new KDCheckBox[]{this.chkHasNotTransmit, this.chkSuccessTransmit, this.chkFailTransmit, this.chkSuccessMatched, this.chkFailMatched, this.chkNotTransmit};
        return box;
    }

    public void clear() {
        super.clear();
        KDCheckBox[] flags = this.getFlagCheckBoxes();
        for (int i = 0; i < flags.length; ++i) {
            flags[i].setSelected(true);
        }
        KDCheckBox[] optTypes = this.getOptTypeCheckBoxes();
        for (int i = 0; i < optTypes.length; ++i) {
            optTypes[i].setSelected(true);
        }
        this.chkSuccessTransmit.setSelected(false);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        FilterInfo filterInfo;
        KDCheckBox[] flags = this.getFlagCheckBoxes();
        for (int i = 0; i < flags.length; ++i) {
            flags[i].setSelected(false);
        }
        KDCheckBox[] optTypes = this.getOptTypeCheckBoxes();
        for (int i = 0; i < optTypes.length; ++i) {
            optTypes[i].setSelected(false);
        }
        super.loadData(entityViewInfo);
        if (entityViewInfo != null && (filterInfo = entityViewInfo.getFilter()).getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                int j;
                Object[] bss;
                FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                if ("base_operationType".equals(filterItemInfo.getPropertyName()) && (bss = ((HashSet)filterItemInfo.getCompareValue()).toArray()).length > 0) {
                    for (j = 0; j < bss.length; ++j) {
                        if (Integer.valueOf(20) == bss[j]) {
                            this.chkDelete.setSelected(true);
                        }
                        if (Integer.valueOf(10) != bss[j]) continue;
                        this.chkUpdate.setSelected(true);
                    }
                }
                if ("flag".equals(filterItemInfo.getPropertyName()) && (bss = ((HashSet)filterItemInfo.getCompareValue()).toArray()).length > 0) {
                    for (j = 0; j < bss.length; ++j) {
                        if (Integer.valueOf(10) == bss[j]) {
                            this.chkHasNotTransmit.setSelected(true);
                        }
                        if (Integer.valueOf(20) == bss[j]) {
                            this.chkSuccessTransmit.setSelected(true);
                        }
                        if (Integer.valueOf(30) == bss[j]) {
                            this.chkFailTransmit.setSelected(true);
                        }
                        if (Integer.valueOf(40) == bss[j]) {
                            this.chkSuccessMatched.setSelected(true);
                        }
                        if (Integer.valueOf(50) == bss[j]) {
                            this.chkFailMatched.setSelected(true);
                        }
                        if (Integer.valueOf(60) != bss[j]) continue;
                        this.chkNotTransmit.setSelected(true);
                    }
                }
                if (!"link_material.id".equals(filterItemInfo.getPropertyName())) continue;
                try {
                    IMaterial iMaterial = MaterialFactory.getRemoteInstance();
                    Object[] bss2 = ((HashSet)filterItemInfo.getCompareValue()).toArray();
                    HashSet<String> set = new HashSet<String>();
                    for (int j2 = 0; j2 < bss2.length; ++j2) {
                        set.add(bss2[j2].toString());
                    }
                    if (set.size() <= 0) continue;
                    EntityViewInfo view = new EntityViewInfo();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("model"));
                    view.setSelector(sic);
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
                    view.setFilter(filter);
                    MaterialCollection materialColl = iMaterial.getMaterialCollection(view);
                    if (materialColl.size() <= 0) continue;
                    MaterialInfo[] materials = new MaterialInfo[materialColl.size()];
                    for (int k = 0; k < materialColl.size(); ++k) {
                        materials[k] = materialColl.get(k);
                    }
                    this.prmtParentMaterial.setValue((Object)materials);
                    continue;
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        }
    }
}

