/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning;

import com.kingdee.eas.mm.planning.SOPException;
import com.kingdee.eas.mm.planning.SOPProductPlanPolicyEnum;
import com.kingdee.eas.mm.planning.SopProdPlanStrategy;
import java.math.BigDecimal;

public class BalanceProdStrategy
extends SopProdPlanStrategy {
    BigDecimal[] workDays = null;

    @Override
    public SOPProductPlanPolicyEnum getStrategyType() {
        return SOPProductPlanPolicyEnum.AVERAGE_PLAN;
    }

    @Override
    public BigDecimal[] getProdPlan(BigDecimal[] sales, BigDecimal[] targetInvs, BigDecimal bopInv, int precision) throws SOPException {
        BigDecimal[] prods = new BigDecimal[sales.length];
        BigDecimal sumOfSales = ZERO;
        BigDecimal allDays = ZERO;
        for (int i = 0; i < sales.length; ++i) {
            sales[i] = (sales[i] == null ? ZERO : sales[i]).setScale(precision, 4);
            sumOfSales = sumOfSales.add(sales[i]);
            allDays = allDays.add(this.workDays[i]);
        }
        if (allDays.equals(ZERO)) {
            throw new SOPException(SOPException.SUM_WORKDAY_CAN_NOT_BE_ZERO);
        }
        BigDecimal prodPerDay = sumOfSales.divide(allDays, 4);
        BigDecimal prodAccumulated = ZERO;
        BigDecimal daysAccumulated = ZERO;
        for (int i = 0; i < sales.length; ++i) {
            prods[i] = allDays.compareTo(daysAccumulated = daysAccumulated.add(this.workDays[i])) == 0 ? sumOfSales.subtract(prodAccumulated) : prodPerDay.multiply(this.workDays[i]);
            prods[i] = prods[i].setScale(precision, 4);
            prodAccumulated = prodAccumulated.add(prods[i]);
        }
        return prods;
    }

    @Override
    public void setWorkDays(BigDecimal[] workDays) {
        this.workDays = workDays;
    }
}

