/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.planning.client.AbstractCooperatePlanOrderFilterUI;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CooperatePlanOrderFilterUI
extends AbstractCooperatePlanOrderFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CooperatePlanOrderFilterUI.class);
    private CustomerParams cp = null;
    private ItemListener chkExceptionChange = null;
    private List chkStatusList = new LinkedList();
    private List chkIsReleasedList = new LinkedList();
    private List chkCloseStatusList = new LinkedList();
    private Map chkGroupMap = new HashMap();
    private Map chkExcepMsgMap = new HashMap();

    public CooperatePlanOrderFilterUI() throws Exception {
        this.chkStatusList.add(this.chkStatusSave);
        this.chkStatusList.add(this.chkStatusSubmit);
        this.chkStatusList.add(this.chkStatusAudit);
        this.chkStatusList.add(this.chkStatusRelease);
        this.chkStatusList.add(this.chkStatusClose);
        this.chkIsReleasedList.add(this.chkRelease);
        this.chkIsReleasedList.add(this.chkUnRelease);
        this.chkCloseStatusList.add(this.chkUnClose);
        this.chkCloseStatusList.add(this.chkManulClose);
        this.chkCloseStatusList.add(this.chkAutoClose);
        this.chkExcepMsgMap.put(this.kDPanel1, "STATUS_MUST_SELECT");
        this.chkExcepMsgMap.put(this.kDPanel2, "ISRELEASED_MUST_SELECT");
        this.chkExcepMsgMap.put(this.kDPanel3, "CLOSESTATUS_MUST_SELECT");
        this.chkGroupMap.put(this.kDPanel1, this.chkStatusList);
        this.chkGroupMap.put(this.kDPanel2, this.chkIsReleasedList);
        this.chkGroupMap.put(this.kDPanel3, this.chkCloseStatusList);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initFilterElements();
        this.addListener();
    }

    private void initFilterElements() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.getResource("PLANORGUNIT_CANNOT_NULL")));
        elements.add((FilterElement)mainOrgElement);
        SingleFilterElement supplyOrgUnitElement = new SingleFilterElement("supplyOrgUnit.number", (Component)this.prmtSupplyOrgUnit);
        elements.add((FilterElement)supplyOrgUnitElement);
        SingleFilterElement plannerElement = new SingleFilterElement("planner.number", (Component)this.prmtPlanner);
        elements.add((FilterElement)plannerElement);
        elements.add((FilterElement)new MMRangeFilterElement("number", (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo));
        elements.add((FilterElement)new MMRangeFilterElement("calcNum.number", (Component)this.prmtCalcNumFrom, (Component)this.prmtCalcNumTo));
        elements.add((FilterElement)new MMRangeFilterElement("material.number", (Component)this.prmtMaterialNumFrom, (Component)this.prmtMaterialNumTo));
        elements.add((FilterElement)new MMRangeFilterElement("requestDate", (Component)this.dpRequestDateFrom, (Component)this.dpRequestDateTo));
        SingleFilterElement coPlanVersionElement = new SingleFilterElement("coPlanVersion.number", (Component)this.prmtCoPlanVersion);
        elements.add((FilterElement)coPlanVersionElement);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.getFilterManager().setElement((FilterElement)elements);
        this.f7Manager.registerContextChangeF7(this.prmtNumberFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtNumberTo, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtMaterialNumFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtMaterialNumTo, this.getPropertyOfMainBizOrg());
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtMaterialNumFrom, null);
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtMaterialNumTo, null);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterialNumFrom, this.prmtMaterialNumTo});
    }

    public void afterMainOrgChanged(String ids) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)ids));
        view.setFilter(filter);
        this.prmtCalcNumFrom.setEntityViewInfo(view);
        this.prmtCalcNumTo.setEntityViewInfo(view);
        this.prmtCoPlanVersion.setEntityViewInfo(view);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter;
        HashSet<Integer> baseStatusSet = new HashSet<Integer>();
        HashSet<Integer> closeSet = new HashSet<Integer>();
        FilterInfo filterInfo = super.getFilterInfo();
        if (this.chkStatusSave.isSelected()) {
            baseStatusSet.add(new Integer(1));
        }
        if (this.chkStatusSubmit.isSelected()) {
            baseStatusSet.add(new Integer(2));
        }
        if (this.chkStatusAudit.isSelected()) {
            baseStatusSet.add(new Integer(4));
        }
        if (this.chkStatusRelease.isSelected()) {
            baseStatusSet.add(new Integer(5));
        }
        if (this.chkStatusClose.isSelected()) {
            baseStatusSet.add(new Integer(7));
        }
        if (baseStatusSet.size() > 0) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", baseStatusSet, CompareType.INCLUDE));
            try {
                filterInfo.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        if (!this.chkRelease.isSelected() || !this.chkUnRelease.isSelected()) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("entries.isReleased", (Object)(this.chkRelease.isSelected() ? new Integer("1") : new Integer("0"))));
            try {
                filterInfo.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        if (this.chkUnClose.isSelected()) {
            closeSet.add(new Integer(10));
        }
        if (this.chkAutoClose.isSelected()) {
            closeSet.add(new Integer(20));
        }
        if (this.chkManulClose.isSelected()) {
            closeSet.add(new Integer(30));
        }
        if (closeSet.size() > 0) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("entries.closeStatus", closeSet, CompareType.INCLUDE));
            try {
                filterInfo.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return filterInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams customerParams = super.getCustomerParams();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            if (this.chkStatusSave.isSelected()) {
                customerParams.addCustomerParam("statusSave", String.valueOf(1));
            }
            if (this.chkStatusSubmit.isSelected()) {
                customerParams.addCustomerParam("statusSubmit", String.valueOf(2));
            }
            if (this.chkStatusAudit.isSelected()) {
                customerParams.addCustomerParam("statusAudit", String.valueOf(4));
            }
            if (this.chkStatusRelease.isSelected()) {
                customerParams.addCustomerParam("statusRelease", String.valueOf(5));
            }
            if (this.chkStatusClose.isSelected()) {
                customerParams.addCustomerParam("statusClose", String.valueOf(7));
            }
            if (this.chkRelease.isSelected()) {
                customerParams.addCustomerParam("release", "1");
            }
            if (this.chkUnRelease.isSelected()) {
                customerParams.addCustomerParam("unRelease", "0");
            }
            if (this.chkUnClose.isSelected()) {
                customerParams.addCustomerParam("unClose", String.valueOf(10));
            }
            if (this.chkAutoClose.isSelected()) {
                customerParams.addCustomerParam("autoClose", String.valueOf(20));
            }
            if (this.chkManulClose.isSelected()) {
                customerParams.addCustomerParam("manulClose", String.valueOf(10));
            }
        }
        return customerParams;
    }

    public void clear() {
        super.clear();
        Calendar calendar = Calendar.getInstance();
        this.dpRequestDateTo.setValue((Object)calendar.getTime());
        calendar.set(2, calendar.get(2) - 1);
        this.dpRequestDateFrom.setValue((Object)calendar.getTime());
        this.chkStatusSave.setSelected(true);
        this.chkStatusSubmit.setSelected(true);
        this.chkStatusAudit.setSelected(true);
        this.chkStatusRelease.setSelected(true);
        this.chkStatusClose.setSelected(true);
        this.chkRelease.setSelected(true);
        this.chkUnRelease.setSelected(true);
        this.chkUnClose.setSelected(true);
        this.chkAutoClose.setSelected(true);
        this.chkManulClose.setSelected(true);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.remmoveListener();
        this.chkStatusSave.setSelected(false);
        this.chkStatusSubmit.setSelected(false);
        this.chkStatusAudit.setSelected(false);
        this.chkStatusRelease.setSelected(false);
        this.chkStatusClose.setSelected(false);
        this.chkRelease.setSelected(false);
        this.chkUnRelease.setSelected(false);
        this.chkUnClose.setSelected(false);
        this.chkAutoClose.setSelected(false);
        this.chkManulClose.setSelected(false);
        super.loadData(entityViewInfo);
        if (this.cp.getCustomerParam("statusSave") != null && this.cp.getCustomerParam("statusSave").length() > 0) {
            this.chkStatusSave.setSelected(true);
        }
        if (this.cp.getCustomerParam("statusSubmit") != null && this.cp.getCustomerParam("statusSubmit").length() > 0) {
            this.chkStatusSubmit.setSelected(true);
        }
        if (this.cp.getCustomerParam("statusAudit") != null && this.cp.getCustomerParam("statusAudit").length() > 0) {
            this.chkStatusAudit.setSelected(true);
        }
        if (this.cp.getCustomerParam("statusRelease") != null && this.cp.getCustomerParam("statusRelease").length() > 0) {
            this.chkStatusRelease.setSelected(true);
        }
        if (this.cp.getCustomerParam("statusClose") != null && this.cp.getCustomerParam("statusClose").length() > 0) {
            this.chkStatusClose.setSelected(true);
        }
        if (this.cp.getCustomerParam("release") != null && this.cp.getCustomerParam("release").length() > 0) {
            this.chkRelease.setSelected(true);
        }
        if (this.cp.getCustomerParam("unRelease") != null && this.cp.getCustomerParam("unRelease").length() > 0) {
            this.chkUnRelease.setSelected(true);
        }
        if (this.cp.getCustomerParam("unClose") != null && this.cp.getCustomerParam("unClose").length() > 0) {
            this.chkUnClose.setSelected(true);
        }
        if (this.cp.getCustomerParam("autoClose") != null && this.cp.getCustomerParam("autoClose").length() > 0) {
            this.chkAutoClose.setSelected(true);
        }
        if (this.cp.getCustomerParam("manulClose") != null && this.cp.getCustomerParam("manulClose").length() > 0) {
            this.chkManulClose.setSelected(true);
        }
        this.addListener();
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getViewPermission() {
        return "mm_COPlanOrder_view";
    }

    private String getResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.CooperatePlanOrderResource", (String)sKey);
    }

    private void addListener() {
        KDCheckBox kDCheckBox;
        int i;
        if (this.chkExceptionChange == null) {
            this.chkExceptionChange = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CooperatePlanOrderFilterUI.this.chkExceptionHandle(e);
                }
            };
        }
        for (i = 0; i < this.chkStatusList.size(); ++i) {
            kDCheckBox = (KDCheckBox)this.chkStatusList.get(i);
            kDCheckBox.addItemListener(this.chkExceptionChange);
        }
        for (i = 0; i < this.chkIsReleasedList.size(); ++i) {
            kDCheckBox = (KDCheckBox)this.chkIsReleasedList.get(i);
            kDCheckBox.addItemListener(this.chkExceptionChange);
        }
        for (i = 0; i < this.chkCloseStatusList.size(); ++i) {
            kDCheckBox = (KDCheckBox)this.chkCloseStatusList.get(i);
            kDCheckBox.addItemListener(this.chkExceptionChange);
        }
    }

    private void remmoveListener() {
        KDCheckBox kDCheckBox;
        int i;
        for (i = 0; i < this.chkStatusList.size(); ++i) {
            kDCheckBox = (KDCheckBox)this.chkStatusList.get(i);
            kDCheckBox.removeItemListener(this.chkExceptionChange);
        }
        for (i = 0; i < this.chkIsReleasedList.size(); ++i) {
            kDCheckBox = (KDCheckBox)this.chkIsReleasedList.get(i);
            kDCheckBox.removeItemListener(this.chkExceptionChange);
        }
        for (i = 0; i < this.chkCloseStatusList.size(); ++i) {
            kDCheckBox = (KDCheckBox)this.chkCloseStatusList.get(i);
            kDCheckBox.removeItemListener(this.chkExceptionChange);
        }
    }

    private void chkExceptionHandle(ItemEvent e) {
        KDCheckBox box;
        KDCheckBox currentBox = (KDCheckBox)e.getSource();
        List chkBoxList = (List)this.chkGroupMap.get(currentBox.getParent());
        String excepMessage = (String)this.chkExcepMsgMap.get(currentBox.getParent());
        boolean isSelected = false;
        for (int i = 0; i < chkBoxList.size() && !(isSelected = (box = (KDCheckBox)chkBoxList.get(i)).isSelected()); ++i) {
        }
        if (!isSelected) {
            currentBox.setSelected(true);
            MsgBox.showInfo((String)this.getResource(excepMessage));
        }
    }
}

