/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.mm.planning.IMRPRunLog;
import com.kingdee.eas.mm.planning.MRPRunLogFactory;
import com.kingdee.eas.mm.planning.MRPRunLogInfo;
import com.kingdee.eas.mm.planning.client.AbstractMRPLogMaterialUI;
import com.kingdee.jdbc.rowset.IRowSet;
import org.apache.log4j.Logger;

public class MRPLogMaterialUI
extends AbstractMRPLogMaterialUI {
    private static final Logger logger = CoreUIObject.getLogger(MRPLogMaterialUI.class);
    private String tableName = null;
    private IMRPRunLog remoteInstance = null;

    public void onLoad() throws Exception {
        super.onLoad();
        MRPRunLogInfo objRunLog = (MRPRunLogInfo)this.getUIContext().get("RunLog");
        boolean isFormal = (Boolean)this.getUIContext().get("isForm");
        this.setData(objRunLog, isFormal);
        this.kDTable1.checkParsed();
        this.kDTable1.getStyleAttributes().setLocked(true);
        this.kDTable1.getSelectManager().setSelectMode(10);
        this.kDTable1.getDataRequestManager().setDataRequestMode(1);
        this.kDTable1.getDataRequestManager().addDataRequestListener(new KDTDataRequestListener(){

            public void tableDataRequest(KDTDataRequestEvent e) {
                MRPLogMaterialUI.this.fillTable(e);
            }
        });
    }

    private IMRPRunLog getBizInterface() throws Exception {
        if (this.remoteInstance == null) {
            this.remoteInstance = MRPRunLogFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        }
        return this.remoteInstance;
    }

    protected void setData(MRPRunLogInfo objRunLog, boolean isFormal) {
        String storageOrgUnitId = objRunLog.getStorageOrgUnit().getId().toString();
        String runLogId = objRunLog.getId().toString();
        String planVersionId = objRunLog.getPlanVersion().getId().toString();
        try {
            this.tableName = this.getBizInterface().getMaterials(storageOrgUnitId, runLogId, planVersionId, isFormal);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.kDTable1.removeRows();
    }

    private void fillTable(KDTDataRequestEvent e) {
        int start = e.getFirstRow();
        int rows = e.getLastRow() - start + 1;
        try {
            IRowSet rs = this.getBizInterface().getMaterials(this.tableName, start, rows);
            IRow row = null;
            while (rs.next()) {
                row = this.kDTable1.addRow();
                row.getCell("material.number").setValue((Object)rs.getString("FMaterialNumber"));
                row.getCell("material.name").setValue((Object)rs.getString("FMaterialName"));
                row.getCell("material.model").setValue((Object)rs.getString("FMaterialModel"));
                row.getCell("material.planningMode").setValue((Object)PlanningModeEnum.getEnum((int)rs.getInt("FPlanningMode")));
                row.getCell("material.materialAttr").setValue((Object)MaterialAttributeEnum.getEnum((int)rs.getInt("FMaterialAttr")));
            }
        }
        catch (Exception e1) {
            this.handUIExceptionAndAbort(e1);
        }
    }

    public boolean destroyWindow() {
        try {
            this.getBizInterface().releaseTable(this.tableName);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return super.destroyWindow();
    }
}

