/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.planning.IMRPService;
import com.kingdee.eas.mm.planning.MRPClassifyEnum;
import com.kingdee.eas.mm.planning.MRPElementEnum;
import com.kingdee.eas.mm.planning.MRPServiceFactory;
import com.kingdee.eas.mm.planning.client.AbstractMRPRunDetailQueryUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;

public class MRPRunDetailQueryUI
extends AbstractMRPRunDetailQueryUI
implements KDTDataRequestListener {
    private static final long serialVersionUID = 12222323L;
    private static final String[] KDT_DATES = new String[]{"FBillDate", "FPlanBeginDate", "FPlanEndDate"};
    private IMRPService mrpService = null;

    public void onLoad() throws Exception {
        super.onLoad();
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])KDT_DATES);
    }

    public MRPRunDetailQueryUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
    }

    protected IMRPService getMRPService() throws BOSException {
        if (this.mrpService == null) {
            this.mrpService = MRPServiceFactory.getRemoteService();
        }
        return this.mrpService;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.txtNumber.getText() != null) {
            this.tblMain.removeRows();
        } else {
            MsgBox.showError((String)"Please enter Number!");
        }
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        if (this.txtNumber.getText() == null || this.txtNumber.getText().length() == 0) {
            return;
        }
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        try {
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptRowSet rs = this.getMRPService().queryDetailDataByRunlogNum(this.txtNumber.getText(), from, len);
            if (rs == null) {
                return;
            }
            while (rs.next()) {
                IRow row = this.tblMain.addRow();
                row.getCell("FPlanningMode").setValue((Object)PlanningModeEnum.getEnum((int)rs.getInt("FPlanningMode")));
                row.getCell("FMRPClassify").setValue((Object)MRPClassifyEnum.getEnum(rs.getInt("FMRPClassify")));
                row.getCell("FMRPItem").setValue((Object)MRPElementEnum.getEnum(rs.getInt("FMRPItem")));
                row.getCell("FParentMaterialNumber").setValue((Object)rs.getString("FParentMaterialNumber"));
                row.getCell("FSrcBillType").setValue((Object)rs.getString("FSrcBillTypeName"));
                row.getCell("FSrcBillNumber").setValue((Object)rs.getString("FSrcBillNumber"));
                row.getCell("FBillType").setValue(rs.getObject("FBillTypeName"));
                row.getCell("FBillNumber").setValue((Object)rs.getString("FBillNumber"));
                row.getCell("FBillRowSeq").setValue(rs.getObject("FBillRowSeq"));
                row.getCell("FNumber").setValue((Object)rs.getString("FNumber"));
                row.getCell("FBillDate").setValue(rs.getObject("FBillDate"));
                row.getCell("FAvaliable").setValue((Object)rs.getBigDecimal("FAvaliable"));
                row.getCell("FSR").setValue((Object)rs.getBigDecimal("FSR"));
                row.getCell("FAllocation").setValue((Object)rs.getBigDecimal("FAllocation"));
                row.getCell("FIndependent").setValue((Object)rs.getBigDecimal("FIndependent"));
                row.getCell("FDependent").setValue((Object)rs.getBigDecimal("FDependent"));
                row.getCell("FNetReq").setValue((Object)rs.getBigDecimal("FNetReq"));
                row.getCell("FPlannedQty").setValue((Object)rs.getBigDecimal("FPlannedQty"));
                row.getCell("FPAB").setValue((Object)rs.getBigDecimal("FPAB"));
                row.getCell("FPlanBeginDate").setValue(rs.getObject("FPlanBeginDate"));
                row.getCell("FPlanEndDate").setValue(rs.getObject("FPlanEndDate"));
                row.getCell("FException1").setValue((Object)rs.getBigDecimal("FException1"));
                row.getCell("FException2").setValue((Object)rs.getBigDecimal("FException2"));
                row.getCell("FException3").setValue((Object)rs.getBigDecimal("FException3"));
                row.getCell("FIsDelay").setValue((Object)rs.getBoolean("FIsDelay", false));
                row.getCell("FIsTotalLine").setValue((Object)rs.getBoolean("FIsTotalLine", false));
                row.getCell("FSupplyOrgName").setValue((Object)rs.getString("FSupplyOrgName"));
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }
}

