/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.mm.basedata.PLSModelInfo;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.planning.CapUnitEnum;
import com.kingdee.eas.mm.planning.IPLSRunFacade;
import com.kingdee.eas.mm.planning.PLChooseEntryInfo;
import com.kingdee.eas.mm.planning.PLSConstant;
import com.kingdee.eas.mm.planning.PLSRunFacadeFactory;
import com.kingdee.eas.mm.planning.RunResult;
import com.kingdee.eas.mm.planning.client.AbstractPLCCapAnalyzeUI;
import com.kingdee.eas.mm.planning.client.PLSCapFilterUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PLCCapAnalyzeUI
extends AbstractPLCCapAnalyzeUI {
    private static final Logger logger = CoreUIObject.getLogger(PLCCapAnalyzeUI.class);
    private static final String TB_DEPARTMENT = "department";
    private static final String TB_PRODUCTLINENAME = "productLineName";
    private static final String TB_UNITNAME = "unitName";
    private static final String TB_SUMCAP = "sumCap";
    private static final String TB_SUMQTY = "sumQty";
    private static final String TB_DIFFQTY = "diffQty";
    private static final String TB_DIFFRATE = "diffRate";
    private static final String[] QTYCOLUMNS = new String[]{"sumCap", "sumQty", "diffQty"};
    private static final String[] RATECOLUMNS = new String[]{"diffRate"};
    private StorageOrgUnitInfo storageOrgUnit;
    private String voucherId;
    private PLSModelInfo pLSModelInfo;

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtMain.checkParsed();
        this.storageOrgUnit = (StorageOrgUnitInfo)this.getUIContext().get("storageOrgUnit");
        this.prmtOrgUnit.setValue((Object)this.storageOrgUnit);
        Date beginDate = (Date)this.getUIContext().get("beginDate");
        Date endDate = (Date)this.getUIContext().get("endDate");
        this.pkBeginDate.setValue((Object)beginDate);
        this.pkEndDate.setValue((Object)endDate);
        this.voucherId = (String)this.getUIContext().get("voucherID");
        this.pLSModelInfo = (PLSModelInfo)this.getUIContext().get("pLSModelInfo");
        this.actionQuery_actionPerformed(null);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"analyzeSrc", (Object)"PLC");
        uiContext.put((Object)"storageOrgUnit", (Object)this.storageOrgUnit);
        uiContext.put((Object)"beginDate", this.pkBeginDate.getValue());
        uiContext.put((Object)"endDate", this.pkEndDate.getValue());
        List pLCList = (List)this.getUIContext().get("pLCList");
        Set workShopSet = this.getWorkShops(pLCList);
        uiContext.put((Object)"workShopSet", (Object)workShopSet);
        Set productLineSet = this.getProductLines(pLCList);
        uiContext.put((Object)"productLineSet", (Object)productLineSet);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PLSCapFilterUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        PLSCapFilterUI filterUI = (PLSCapFilterUI)uiWindow.getUIObject();
        boolean isQuery = false;
        if (filterUI.getUIContext().get("isQuery") != null) {
            isQuery = (Boolean)filterUI.getUIContext().get("isQuery");
        }
        if (isQuery) {
            PLChooseEntryInfo pLCInfo;
            Iterator ite;
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            Set productLines = (Set)filterUI.getUIContext().get("productLines");
            Set workShops = (Set)filterUI.getUIContext().get("workShops");
            if (productLines != null && productLines.size() > 0) {
                ite = pLCList.iterator();
                while (ite.hasNext()) {
                    pLCInfo = (PLChooseEntryInfo)ite.next();
                    if (productLines.contains(pLCInfo.getProductLine().getId().toString())) continue;
                    ite.remove();
                }
            } else if (workShops != null && workShops.size() > 0) {
                ite = pLCList.iterator();
                while (ite.hasNext()) {
                    pLCInfo = (PLChooseEntryInfo)ite.next();
                    if (workShops.contains(pLCInfo.getWorkShop().getId().toString())) continue;
                    ite.remove();
                }
            }
            filterMap.put("beginDate", this.pkBeginDate.getValue());
            filterMap.put("endDate", this.pkEndDate.getValue());
            filterMap.put("srcList", pLCList);
            filterMap.put("analyzeSrc", "PLC");
            IPLSRunFacade iPLSRunFacade = PLSRunFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            RunResult result = iPLSRunFacade.capAnalyze(this.storageOrgUnit, filterMap, this.voucherId, this.pLSModelInfo);
            List list = result.getReturnList();
            if (list != null && list.size() > 0) {
                this.kdtMain.removeRows();
                this.fillTable(list);
            }
            this.initSortManager();
        } else {
            this.abort();
        }
    }

    private void fillTable(List list) throws Exception {
        if (list != null && list.size() > 0) {
            BigDecimal cap = PLSConstant.ZERO;
            BigDecimal qty = PLSConstant.ZERO;
            BigDecimal totalCap = PLSConstant.ZERO;
            BigDecimal totalQty = PLSConstant.ZERO;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Map map = (Map)list.get(i);
                ProductLineInfo productLine = (ProductLineInfo)map.get("productLine");
                if (map.get("cap") != null) {
                    cap = (BigDecimal)map.get("cap");
                }
                if (map.get("qty") != null) {
                    qty = (BigDecimal)map.get("qty");
                }
                IRow row = this.kdtMain.addRow();
                row.getCell(TB_DEPARTMENT).setValue((Object)productLine.getWorkshop().getName());
                row.getCell(TB_PRODUCTLINENAME).setValue((Object)productLine.getName());
                row.getCell(TB_UNITNAME).setValue((Object)CapUnitEnum.HOUR.getAlias());
                row.getCell(TB_SUMCAP).setValue((Object)cap);
                row.getCell(TB_SUMQTY).setValue((Object)qty);
                row.getCell(TB_SUMCAP).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
                row.getCell(TB_SUMQTY).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
                row.getCell(TB_DIFFQTY).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
                totalCap = totalCap.add(cap);
                totalQty = totalQty.add(qty);
                BigDecimal diffQty = cap.subtract(qty);
                row.getCell(TB_DIFFQTY).setValue((Object)diffQty);
                double diffRate = 100.0;
                if (cap.doubleValue() != 0.0) {
                    diffRate = diffQty.doubleValue() / cap.doubleValue() * 100.0;
                }
                row.getCell(TB_DIFFRATE).setValue((Object)new BigDecimal(diffRate));
                row.getCell(TB_DIFFRATE).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
            }
            KDTFootManager footRowManager = this.kdtMain.getFootManager();
            IRow footRow = null;
            if (footRowManager == null) {
                footRowManager = new KDTFootManager(this.kdtMain);
                footRowManager.addFootView();
                this.kdtMain.setFootManager(footRowManager);
            }
            if ((footRow = footRowManager.getFootRow(0)) == null) {
                footRow = footRowManager.addFootRow(0);
                String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
                this.kdtMain.getIndexColumn().setWidthAdjustMode((short)1);
                this.kdtMain.getIndexColumn().setWidth(30);
                footRowManager.addIndexText(0, total);
                footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            }
            footRow.getCell(TB_SUMCAP).setValue((Object)totalCap);
            footRow.getCell(TB_SUMQTY).setValue((Object)totalQty);
            BigDecimal diffQty = totalCap.subtract(totalQty);
            footRow.getCell(TB_DIFFQTY).setValue((Object)diffQty);
            double diffRate = 100.0;
            if (totalCap.doubleValue() != 0.0) {
                diffRate = diffQty.doubleValue() / totalCap.doubleValue() * 100.0;
            }
            footRow.getCell(TB_DIFFRATE).setValue((Object)new BigDecimal(diffRate));
            footRow.getCell(TB_SUMCAP).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            footRow.getCell(TB_SUMQTY).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            footRow.getCell(TB_DIFFQTY).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            footRow.getCell(TB_DIFFRATE).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
        }
    }

    private void initSortManager() {
        KDTSortManager sortManager = new KDTSortManager(this.kdtMain);
        sortManager.setSortAuto(true);
        sortManager.setClickCount(1);
        this.kdtMain.setSortMange(sortManager);
        for (int i = 0; i < this.kdtMain.getColumnCount(); ++i) {
            this.kdtMain.getColumn(i).setSortable(true);
        }
    }

    private Set getProductLines(List pLCList) {
        HashSet<String> productLineSet = new HashSet<String>();
        int n = pLCList.size();
        for (int i = 0; i < n; ++i) {
            PLChooseEntryInfo pLCInfo = (PLChooseEntryInfo)pLCList.get(i);
            productLineSet.add(pLCInfo.getProductLine().getId().toString());
        }
        return productLineSet;
    }

    private Set getWorkShops(List pLCList) {
        HashSet<String> workShopSet = new HashSet<String>();
        int n = pLCList.size();
        for (int i = 0; i < n; ++i) {
            PLChooseEntryInfo pLCInfo = (PLChooseEntryInfo)pLCList.get(i);
            workShopSet.add(pLCInfo.getWorkShop().getId().toString());
        }
        return workShopSet;
    }
}

