/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.mm.basedata.BDStatusEnum;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryInfo;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryRuleEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryRuleEntryInfo;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.planning.PLSConstant;
import com.kingdee.eas.mm.planning.client.AbstractPLCRowSplitEditUI;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PLCRowSplitEditUI
extends AbstractPLCRowSplitEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PLCRowSplitEditUI.class);
    private static final String F7PRODUCTLINEQUERY = "com.kingdee.eas.mm.basedata.app.ProductLineQuery";
    private static final String TB_WORKSHOP = "workShop";
    private static final String TB_PRODUCTLINE = "productLine";
    private static final String TB_QTY = "qty";
    private KDTEditAdapter productLineTableChange = null;
    public static final String RES_SCHEDULING = "com.kingdee.eas.mm.planning.ProductionLineSchedulingResource";
    private Map workShopMap = new HashMap();

    protected void initListener() {
        super.initListener();
        if (this.productLineTableChange == null) {
            this.productLineTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        PLCRowSplitEditUI.this.kdtProductionLine_Changed(e);
                    }
                    catch (Exception exc) {
                        PLCRowSplitEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtProductionLine.addKDTEditListener((KDTEditListener)this.productLineTableChange);
    }

    private void kdtProductionLine_Changed(KDTEditEvent e) throws Exception {
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        int rowIndex = e.getRowIndex();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue);
        if (!isDiffrent) {
            return;
        }
        String fieldName = this.kdtProductionLine.getColumnKey(e.getColIndex());
        if (TB_PRODUCTLINE.equals(fieldName)) {
            if (newValue != null && newValue instanceof ProductLineInfo) {
                ProductLineInfo lineInfo = (ProductLineInfo)newValue;
                String key = lineInfo.getWorkshop().getId().toString();
                if (!this.workShopMap.containsKey(key)) {
                    AdminOrgUnitInfo workShop = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(lineInfo.getWorkshop().getId()));
                    this.kdtProductionLine.getRow(rowIndex).getCell(TB_WORKSHOP).setValue((Object)workShop);
                } else {
                    this.kdtProductionLine.getRow(rowIndex).getCell(TB_WORKSHOP).setValue((Object)((AdminOrgUnitInfo)this.workShopMap.get(key)));
                }
            } else {
                this.kdtProductionLine.getRow(rowIndex).getCell(TB_WORKSHOP).setValue(null);
                this.kdtProductionLine.getRow(rowIndex).getCell(TB_QTY).setValue((Object)SCMConstant.BIGDECIMAL_ZERO);
                this.resetQty();
            }
        }
        if (isDiffrent && TB_QTY.equals(fieldName) && newValue != null && newValue instanceof BigDecimal) {
            this.resetQty();
        }
    }

    private void resetQty() {
        BigDecimal sumQty = SCMConstant.BIGDECIMAL_ZERO;
        for (int i = 0; i < this.kdtProductionLine.getRowCount(); ++i) {
            BigDecimal qty = (BigDecimal)this.kdtProductionLine.getCell(i, TB_QTY).getValue();
            if (qty == null) {
                qty = SCMConstant.BIGDECIMAL_ZERO;
            }
            sumQty = sumQty.add(qty);
        }
        this.surplusQty.setValue((Object)this.sumSplitQty.getBigDecimalValue().subtract(sumQty));
        KDTFootManager footRowManager = this.kdtProductionLine.getFootManager();
        IRow footRow = footRowManager.getFootRow(0);
        ICell cell = footRow.getCell(TB_QTY);
        cell.setValue((Object)sumQty);
    }

    public void onLoad() throws Exception {
        MaterialInfo material = (MaterialInfo)this.getUIContext().get("material");
        BigDecimal qty = (BigDecimal)this.getUIContext().get(TB_QTY);
        ProductLineInfo productLine = (ProductLineInfo)this.getUIContext().get(TB_PRODUCTLINE);
        ProductLinePAllotDefEntryCollection productLinePAllotDefEntryCollection = (ProductLinePAllotDefEntryCollection)this.getUIContext().get("productLinePAllotDef");
        this.workShopMap = (Map)this.getUIContext().get("workShopMap");
        this.prmtMaterial.setValue((Object)material);
        this.sumSplitQty.setDataType(1);
        this.sumSplitQty.setPrecision(qty.scale());
        this.sumSplitQty.setRemoveingZeroInDispaly(false);
        this.sumSplitQty.setValue((Object)qty);
        this.surplusQty.setDataType(1);
        this.surplusQty.setPrecision(qty.scale());
        this.surplusQty.setRemoveingZeroInDispaly(false);
        this.surplusQty.setValue((Object)qty);
        this.kdtProductionLine.checkParsed();
        KDFormattedTextField formatField = new KDFormattedTextField();
        formatField.setHorizontalAlignment(2);
        formatField.setDataType(1);
        formatField.setNegatived(false);
        formatField.setPrecision(qty.scale());
        KDTDefaultCellEditor formatEditor = new KDTDefaultCellEditor((JTextField)formatField);
        this.kdtProductionLine.getColumn(TB_QTY).setEditor((ICellEditor)formatEditor);
        this.initProductLineF7(productLinePAllotDefEntryCollection, productLine.getId().toString(), material.getId().toString());
        KDTFootManager footRowManager = this.kdtProductionLine.getFootManager();
        IRow footRow = null;
        if (footRowManager == null) {
            footRowManager = new KDTFootManager(this.kdtProductionLine);
            footRowManager.addFootView();
            this.kdtProductionLine.setFootManager(footRowManager);
        }
        if ((footRow = footRowManager.getFootRow(0)) == null) {
            footRow = footRowManager.addFootRow(0);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            footRow.getCell(0).setValue((Object)total);
            footRow.getCell(TB_QTY).setValue((Object)PLSConstant.ZERO);
            footRow.getCell(TB_QTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        } else {
            footRow.getCell(TB_QTY).setValue((Object)PLSConstant.ZERO);
        }
        if (this.getDetailTable() != null) {
            if (this.getDetailTable().getRowCount() > 0) {
                this.getDetailTable().removeRows();
                this.getDetailTable().addRow();
            } else {
                this.getDetailTable().addRow();
            }
        }
        this.getDetailTable().getActionMap().remove("Delete");
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.getDetailTable().addRow();
        }
    }

    protected KDTable getDetailTable() {
        return this.kdtProductionLine;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.verify()) {
            return;
        }
        ArrayList splitList = new ArrayList();
        for (int i = 0; i < this.kdtProductionLine.getRowCount(); ++i) {
            HashMap<String, Object> hMap = new HashMap<String, Object>();
            ProductLineInfo productLine = (ProductLineInfo)this.kdtProductionLine.getRow(i).getCell(TB_PRODUCTLINE).getValue();
            BigDecimal qty = (BigDecimal)this.kdtProductionLine.getRow(i).getCell(TB_QTY).getValue();
            AdminOrgUnitInfo workShop = (AdminOrgUnitInfo)this.kdtProductionLine.getRow(i).getCell(TB_WORKSHOP).getValue();
            hMap.put(TB_WORKSHOP, workShop);
            hMap.put(TB_PRODUCTLINE, productLine);
            hMap.put(TB_QTY, qty);
            splitList.add(hMap);
        }
        this.getUIContext().put("splitList", splitList);
        this.getUIContext().put("surplusQty", this.surplusQty.getBigDecimalValue());
        this.disposeUIWindow();
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtProductionLine == null) {
            return;
        }
        this.insertLine(this.kdtProductionLine);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.kdtProductionLine);
    }

    protected void insertLine(KDTable table) {
        if (table == null) {
            return;
        }
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            this.abort();
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    this.abort();
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                BigDecimal qty = (BigDecimal)this.kdtProductionLine.getCell(rowIndex, TB_QTY).getValue();
                if (qty != null) {
                    this.surplusQty.setValue((Object)this.surplusQty.getBigDecimalValue().add(qty));
                    KDTFootManager footRowManager = this.kdtProductionLine.getFootManager();
                    IRow footRow = footRowManager.getFootRow(0);
                    ICell cell = footRow.getCell(TB_QTY);
                    cell.setValue((Object)((BigDecimal)footRow.getCell(TB_QTY).getValue()).subtract(qty));
                }
                table.removeRow(rowIndex);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    private boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    private void initProductLineF7(ProductLinePAllotDefEntryCollection productLinePAllotDefEntryCollection, String productionLineId, String materialID) throws Exception {
        KDBizPromptBox kDBizPromptBoxProductLine = new KDBizPromptBox();
        kDBizPromptBoxProductLine.setQueryInfo(F7PRODUCTLINEQUERY);
        kDBizPromptBoxProductLine.setDisplayFormat("$name$");
        kDBizPromptBoxProductLine.setEditFormat("$number$");
        kDBizPromptBoxProductLine.setCommitFormat("$number$");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < productLinePAllotDefEntryCollection.size(); ++i) {
            ProductLinePAllotDefEntryInfo entry = productLinePAllotDefEntryCollection.get(i);
            if (!materialID.equals(entry.getMaterial().getId().toString())) continue;
            ProductLinePAllotDefEntryRuleEntryCollection ruleEntrys = entry.getRuleEntrys();
            for (int j = 0; j < ruleEntrys.size(); ++j) {
                String ruleProductLineId;
                ProductLinePAllotDefEntryRuleEntryInfo ruleEntry = ruleEntrys.get(j);
                if (!ruleEntry.getProductLine().getStatus().equals((Object)BDStatusEnum.APPROVE) || (ruleProductLineId = ruleEntry.getProductLine().getId().toString()) == null || productionLineId.equals(ruleProductLineId)) continue;
                set.add(ruleEntry.getProductLine().getId().toString());
            }
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        kDBizPromptBoxProductLine.setEntityViewInfo(entityViewInfo);
        this.kdtProductionLine.getColumn(TB_PRODUCTLINE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxProductLine));
    }

    private String getResourceMsg(String key, String[] params) {
        return ResourceUtils.getMessageForClient((String)RES_SCHEDULING, (String)key, (String[])params);
    }

    private boolean verify() throws Exception {
        boolean bRet = false;
        StringBuffer showInfo = new StringBuffer();
        for (int i = 0; i < this.kdtProductionLine.getRowCount(); ++i) {
            ProductLineInfo productLine = (ProductLineInfo)this.kdtProductionLine.getRow(i).getCell(TB_PRODUCTLINE).getValue();
            BigDecimal qty = (BigDecimal)this.kdtProductionLine.getRow(i).getCell(TB_QTY).getValue();
            if (productLine != null && qty != null && qty.compareTo(new BigDecimal(0)) != 0) continue;
            bRet = true;
            showInfo.append(this.getResourceMsg("Msg_RowSplit_IsNull", new String[]{String.valueOf(i + 1)}) + "\n");
        }
        if (this.surplusQty.getBigDecimalValue().compareTo(new BigDecimal(0)) < 0) {
            bRet = true;
            showInfo.append(ResourceUtils.getMessageForClient((String)RES_SCHEDULING, (String)"Msg_RowSplit_SurplusQty"));
        }
        if (bRet) {
            MsgBox.showInfo((String)showInfo.toString());
        }
        return bRet;
    }

    public boolean destroyWindow() {
        this.getUIContext().put("splitList", null);
        this.getUIContext().put("surplusQty", null);
        return super.destroyWindow();
    }
}

