/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.planning.client.AbstractPLCRowUniteUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class PLCRowUniteUI
extends AbstractPLCRowUniteUI {
    private static final Logger logger = CoreUIObject.getLogger(PLCRowUniteUI.class);
    private static final String TB_SELECT = "select";
    private static final String TB_ID = "id";
    private static final String TB_QTY = "qty";
    public static final String RES_SCHEDULING = "com.kingdee.eas.mm.planning.ProductionLineSchedulingResource";
    private static final String[] KDT_DATES = new String[]{"beginDate", "endDate"};

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtSrcBill.checkParsed();
        this.kdtObjectBill.checkParsed();
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor checkBoxEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.kdtSrcBill.getColumn(TB_SELECT).setEditor((ICellEditor)checkBoxEditor);
        this.kdtObjectBill.removeRows();
        this.kdtSrcBill.removeRows();
        ArrayList entryList = (ArrayList)this.getUIContext().get("entryList");
        for (int i = 0; i < entryList.size(); ++i) {
            HashMap hMap = (HashMap)entryList.get(i);
            IRow srcRow = this.kdtSrcBill.addRow();
            for (int col = 0; col < this.kdtSrcBill.getColumnCount(); ++col) {
                String colName = this.kdtSrcBill.getColumn(col).getKey();
                if (colName.equals(TB_SELECT)) {
                    srcRow.getCell(TB_SELECT).setValue((Object)Boolean.FALSE);
                    continue;
                }
                srcRow.getCell(col).setValue(hMap.get(colName));
                srcRow.getCell(col).getStyleAttributes().setLocked(true);
            }
            IRow objRow = this.kdtObjectBill.addRow();
            for (int col = 0; col < this.kdtObjectBill.getColumnCount(); ++col) {
                String colName = this.kdtObjectBill.getColumn(col).getKey();
                objRow.getCell(col).setValue(hMap.get(colName));
            }
        }
        this.kdtObjectBill.getStyleAttributes().setLocked(true);
        this.kdtObjectBill.getSelectManager().setSelectMode(2);
        this.repaint();
        EditTableUtil.formatColDate((KDTable)this.kdtObjectBill, (String[])KDT_DATES);
        EditTableUtil.formatColDate((KDTable)this.kdtSrcBill, (String[])KDT_DATES);
    }

    @Override
    public void actionSelAll_actionPerformed(ActionEvent e) throws Exception {
        for (int nIndex = 0; nIndex < this.kdtSrcBill.getRowCount(); ++nIndex) {
            if (this.kdtSrcBill.getRow(nIndex).getStyleAttributes().isHided()) continue;
            this.kdtSrcBill.getRow(nIndex).getCell(TB_SELECT).setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void actionClrAll_actionPerformed(ActionEvent e) throws Exception {
        for (int nIndex = 0; nIndex < this.kdtSrcBill.getRowCount(); ++nIndex) {
            this.kdtSrcBill.getRow(nIndex).getCell(TB_SELECT).setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows;
        ArrayList srcList = new ArrayList();
        StringBuffer showInfo = new StringBuffer();
        boolean bVerify = true;
        for (int nIndex = 0; nIndex < this.kdtSrcBill.getRowCount(); ++nIndex) {
            boolean isSelect = (Boolean)this.kdtSrcBill.getCell(nIndex, TB_SELECT).getValue();
            String id = (String)this.kdtSrcBill.getCell(nIndex, TB_ID).getValue();
            BigDecimal qty = (BigDecimal)this.kdtSrcBill.getCell(nIndex, TB_QTY).getValue();
            if (!isSelect) continue;
            HashMap<String, BigDecimal> srcMap = new HashMap<String, BigDecimal>();
            srcMap.put(id, qty);
            srcList.add(srcMap);
        }
        if (srcList.isEmpty()) {
            showInfo.append(ResourceUtils.getMessageForClient((String)RES_SCHEDULING, (String)"Msg_RowUnite_ScrBill"));
            bVerify = false;
        }
        if ((selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtObjectBill)).length == 0) {
            showInfo.append(ResourceUtils.getMessageForClient((String)RES_SCHEDULING, (String)"Msg_RowUnite_ObjBill"));
            bVerify = false;
        }
        if (!bVerify) {
            MsgBox.showInfo((String)showInfo.toString());
            return;
        }
        ArrayList srcOldList = (ArrayList)srcList.clone();
        String objId = (String)this.kdtObjectBill.getCell(selectRows[0], TB_ID).getValue();
        BigDecimal objQty = (BigDecimal)this.kdtObjectBill.getCell(selectRows[0], TB_QTY).getValue();
        for (int i = 0; i < srcList.size(); ++i) {
            HashMap srcMap = (HashMap)srcList.get(i);
            Set set = srcMap.keySet();
            Iterator iter = set.iterator();
            if (!iter.hasNext()) continue;
            String srcId = (String)iter.next();
            if (srcId.equals(objId)) {
                srcOldList.remove(i);
                continue;
            }
            objQty = objQty.add((BigDecimal)srcMap.get(srcId));
        }
        HashMap<String, BigDecimal> objMap = new HashMap<String, BigDecimal>();
        objMap.put(objId, objQty);
        if (!srcOldList.isEmpty()) {
            this.getUIContext().put("srcList", srcOldList);
            this.getUIContext().put("objMap", objMap);
        }
        this.disposeUIWindow();
    }

    public boolean destroyWindow() {
        this.getUIContext().put("srcList", null);
        this.getUIContext().put("objMap", null);
        return super.destroyWindow();
    }
}

