/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.mm.basedata.ClassTeamEntryInfo;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.planning.DayAbilityPlanUserPermFactory;
import com.kingdee.eas.mm.planning.IDayAbilityPlanUserPerm;
import com.kingdee.eas.mm.planning.IPLSEntry;
import com.kingdee.eas.mm.planning.PLSActionResult;
import com.kingdee.eas.mm.planning.PLSBatchDataVO;
import com.kingdee.eas.mm.planning.PLSEntryCollection;
import com.kingdee.eas.mm.planning.PLSEntryFactory;
import com.kingdee.eas.mm.planning.PLSEntryInfo;
import com.kingdee.eas.mm.planning.ProductionLineSchedulingInfo;
import com.kingdee.eas.mm.planning.client.AbstractPLSBatchEditUI;
import com.kingdee.eas.mm.planning.client.PLSBatchFilterUI;
import com.kingdee.eas.mm.planning.client.ScheDiffAnalyseUI;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class PLSBatchEditUI
extends AbstractPLSBatchEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PLSBatchEditUI.class);
    private CommonQueryDialog queryDialog;
    private PLSBatchFilterUI filterUI = null;
    private boolean mustShowQueryDialog = false;
    private PLSEntryCollection editDatas = new PLSEntryCollection();
    private PLSEntryCollection oldEditDatas = new PLSEntryCollection();
    private Map mmuPrecisions;
    private Map mmuConvsRate;
    private FilterInfo filterInfo;
    protected IMetaDataPK mainQueryPK;
    private Map authorizedWorkshops_view = null;
    private Map authorizedWorkshops_modify = null;
    private boolean hasWorkShopFilter = false;
    private StorageOrgUnitInfo storageOrg;
    private static final String TB_PLS_ISMODIFIABLE = "isModifiAble";
    private static final String TB_PLS_ISSELECTED = "isSelected";
    private static final String TB_PLS_ID = "id";
    private static final String TB_PLS_WORKSHOP = "workShop";
    private static final String TB_PLS_PRODUCTLINE = "productLine";
    private static final String TB_PLS_LINENUM = "lineNum";
    private static final String TB_PLS_BASESTATUS = "status";
    private static final String TB_PLS_BEGINDATE = "beginDate";
    private static final String TB_PLS_ENDDATE = "endDate";
    private static final String TB_PLS_OUTPUTDATE = "outputDate";
    private static final String TB_PLS_SHIFT = "classTeam";
    private static final String TB_PLS_PROORDER = "proOrder";
    private static final String TB_PLS_MATERIAL = "material";
    private static final String TB_PLS_UNIT = "unit";
    private static final String TB_PLS_ISSUBPLAN = "isSubPlan";
    private static final String TB_PLS_QTY = "qty";
    private static final String TB_PLS_ENDQTY = "endQty";
    private static final String TB_PLS_DELAYDATE = "delayDate";
    private static final String TB_PLS_MAINPLANID = "mainPlanID";
    private static final String TB_PLS_BASEQTY = "baseQty";
    private static final String TB_PLS_BASEUNIT = "baseUnit";
    private static final String TB_PLS_PARENTID = "parentId";
    private static final String TB_PLS_SALEORDER_NUMBER = "saleOrderNumber";
    private static final String TB_PLS_TRACK_NUMBER = "trackNumber";
    private static final String TB_PLS_LASTUPDATEUSER = "lastUpdateUser";
    private static final String TB_PLS_AUDITOR = "auditor";
    private static final String TB_PLS_RELEASEUSER = "releaseUser";
    protected String[] QTYPRECISIONFROMUNITTAB = new String[]{"qty", "endQty"};
    protected String[] QTYPRECISIONFROMBASEUNITTAB = new String[]{"baseQty"};
    private static final String FILTER_PROP_STORAGEORGUNIT = "parent.storageOrgUnit.number";
    private static final String FILTER_PROP_PLSEBEGINDATE = "beginDate";
    private static final String FILTER_PROP_NUMBER = "parent.number";
    private static final String FILTER_PROP_WORKSHOP = "productLine.workshop.number";
    private static final String FILTER_PROP_MATERIAL = "material.number";
    public static final Color MODIFIABLE_COLOR = Color.WHITE;
    public static final Color UNMODIFIABLE_COLOR = new Color(225, 225, 225);
    public static final int DEFAULT_PRICISION = 2;
    public static final String VIEW = "view";
    public static final String EDIT = "edit";
    private static final String F7CLASSTEAMENTRYQUERY = "com.kingdee.eas.mm.basedata.app.F7ClassTeamEntryQuery";
    public static final String RES_PLSBATCH = "com.kingdee.eas.mm.planning.PLSBatchResource";
    public static final String RES_SCHEDULING = "com.kingdee.eas.mm.planning.ProductionLineSchedulingResource";
    private static final String[] KDT_DATETIMES = new String[]{"beginDate", "endDate", "outputDate", "varDate", "requiredDate"};
    private static final String[] KDT_DATES = new String[]{"lastUpdateTime", "auditTime", "releaseTime"};
    private KDTEditAdapter entryTableChange = null;

    public PLSBatchEditUI() throws Exception {
        this.kdtEntries.checkParsed();
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.base.message", "MsgQuery");
        this.authorizedWorkshops_view = new HashMap();
        this.authorizedWorkshops_modify = new HashMap();
    }

    public void onLoad() throws Exception {
        this.initCheckBox();
        this.initDateTimeFields();
        super.onLoad();
        if (!this.showQueryDialog()) {
            this.abort();
        }
        this.kdtEntries.getColumn(TB_PLS_DELAYDATE).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
        this.initSortManager(this.kdtEntries, true);
        this.initEntriesTableF7Field();
        EditTableUtil.formatColDate((KDTable)this.kdtEntries, (String[])KDT_DATES);
        EditTableUtil.formatColDateTime((KDTable)this.kdtEntries, (String[])KDT_DATETIMES);
    }

    private void initSortManager(KDTable detailTable, boolean isSort) {
        KDTSortManager sortManager = new KDTSortManager(detailTable);
        sortManager.setSortAuto(isSort);
        sortManager.setClickCount(1);
        for (int i = 0; i < detailTable.getColumnCount(); ++i) {
            detailTable.getColumn(i).setSortable(isSort);
        }
    }

    protected void loadData() throws Exception {
        this.setOprtState(VIEW);
        this.parseFilters();
        this.executeQuery();
        this.setDataObject((IObjectValue)this.editData);
        this.initDataStatus();
        this.loadFields();
    }

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = VIEW;
        }
        return this.oprtState;
    }

    protected void initDataStatus() {
        if (this.getOprtState().equals(VIEW)) {
            this.actionEdit.setEnabled(true);
            this.actionSubmit.setEnabled(false);
            this.actionAudit.setEnabled(true);
            this.actionUnAudit.setEnabled(true);
            this.actionRelease.setEnabled(true);
            this.actionCopyLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.lockUIForViewStatus();
        } else {
            this.actionEdit.setEnabled(false);
            this.actionSubmit.setEnabled(true);
            this.actionAudit.setEnabled(false);
            this.actionUnAudit.setEnabled(false);
            this.actionRelease.setEnabled(false);
            this.actionCopyLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
        }
    }

    protected void initWorkButton() {
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnEdit);
        this.setButtonDefaultStyl(this.btnSubmit);
    }

    protected void executeQuery() throws Exception {
        IPLSEntry iplse = PLSEntryFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(this.getSelectors());
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("workShop.number"));
        sorter.add(new SorterItemInfo("productLine.number"));
        sorter.add(new SorterItemInfo(FILTER_PROP_NUMBER));
        sorter.add(new SorterItemInfo(TB_PLS_LINENUM));
        viewInfo.setSorter(sorter);
        IDayAbilityPlanUserPerm iuserPerm = DayAbilityPlanUserPermFactory.getRemoteInstance();
        Map authorityMap = null;
        if (!this.hasWorkShopFilter) {
            if (this.authorizedWorkshops_view.get(this.storageOrg.getId().toString()) == null || this.authorizedWorkshops_modify.get(this.storageOrg.getId().toString()) == null) {
                authorityMap = iuserPerm.getAuthorizedWorkshop(this.storageOrg.getId().toString(), null);
                this.authorizedWorkshops_view.put(this.storageOrg.getId().toString(), (Set)authorityMap.get("VIEW"));
                this.authorizedWorkshops_modify.put(this.storageOrg.getId().toString(), (Set)authorityMap.get("MODIFY"));
            }
            FilterInfo workshopFilter = null;
            workshopFilter = new FilterInfo();
            workshopFilter.getFilterItems().add(new FilterItemInfo(FILTER_PROP_WORKSHOP, this.authorizedWorkshops_view.get(this.storageOrg.getId().toString()), CompareType.INCLUDE));
            this.filterInfo.mergeFilter(workshopFilter, "AND");
            viewInfo.setFilter(this.filterInfo);
        } else {
            if (this.authorizedWorkshops_modify.get(this.storageOrg.getId().toString()) == null) {
                authorityMap = iuserPerm.getAuthorizedWorkshop(this.storageOrg.getId().toString(), "MODIFY");
                this.authorizedWorkshops_modify.put(this.storageOrg.getId().toString(), (Set)authorityMap.get("MODIFY"));
            }
            viewInfo.setFilter(this.filterInfo);
        }
        PLSBatchDataVO dataVo = iplse.getPLSBatchDataVO(viewInfo);
        this.editDatas = dataVo.getPlsEntryCollection();
        this.mmuPrecisions = dataVo.getMmuPrecisions();
        this.mmuConvsRate = dataVo.getMmuConvsRate();
        this.oldEditDatas = (PLSEntryCollection)((Object)this.editDatas.clone());
        this.editData = new ProductionLineSchedulingInfo();
        this.editData.remove("pLSEntry");
        this.editData.put("pLSEntry", (Object)this.editDatas);
    }

    public void parseFilters() {
        try {
            this.kdDateFrom.setValue(null);
            this.kdDateTo.setValue(null);
            this.prmtStorageOrgUnit.setText(null);
            this.prmtNumberFrom.setText(null);
            this.prmtNumberTo.setText(null);
            this.kdDateFrom.setValue(null);
            this.kdDateFrom.setTimeEnabled(true);
            this.kdDateTo.setValue(null);
            this.kdDateTo.setTimeEnabled(true);
            this.kdDateFrom.setDatePattern(CtrlFormatUtilities.getDateTimeFormatString());
            this.kdDateTo.setDatePattern(CtrlFormatUtilities.getDateTimeFormatString());
            this.prmtMaterialFrom.setText(null);
            this.prmtMaterialTo.setText(null);
            if (this.filterInfo.getFilterItems() != null && this.filterInfo.getFilterItems().size() > 0) {
                for (int i = 0; i < this.filterInfo.getFilterItems().size(); ++i) {
                    FilterItemInfo filterItemInfo = this.filterInfo.getFilterItems().get(i);
                    String propName = filterItemInfo.getPropertyName();
                    CompareType comp = filterItemInfo.getCompareType();
                    if (propName.equals(FILTER_PROP_STORAGEORGUNIT)) {
                        if (this.storageOrg == null || !this.storageOrg.getNumber().equals(filterItemInfo.getCompareValue().toString())) {
                            EntityViewInfo viewInfo = new EntityViewInfo();
                            SelectorItemCollection sic = new SelectorItemCollection();
                            sic.add(new SelectorItemInfo(TB_PLS_ID));
                            sic.add(new SelectorItemInfo("name"));
                            sic.add(new SelectorItemInfo("number"));
                            viewInfo.setSelector(sic);
                            FilterInfo orgFilter = new FilterInfo();
                            orgFilter.getFilterItems().add(new FilterItemInfo("number", (Object)filterItemInfo.getCompareValue().toString(), CompareType.EQUALS));
                            viewInfo.setFilter(orgFilter);
                            StorageOrgUnitCollection orgCol = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(viewInfo);
                            if (orgCol != null && orgCol.size() > 0) {
                                this.storageOrg = orgCol.get(0);
                            }
                        }
                        this.prmtStorageOrgUnit.setText(this.storageOrg.getName());
                    }
                    if (propName.equals(FILTER_PROP_NUMBER)) {
                        if (comp.equals((Object)CompareType.GREATER_EQUALS)) {
                            this.prmtNumberFrom.setText(filterItemInfo.getCompareValue().toString());
                        } else if (comp.equals((Object)CompareType.LESS_EQUALS)) {
                            this.prmtNumberTo.setText(filterItemInfo.getCompareValue().toString());
                        }
                    }
                    if (propName.equals("beginDate")) {
                        if (comp.equals((Object)CompareType.GREATER_EQUALS)) {
                            this.kdDateFrom.setValue((Object)Timestamp.valueOf(filterItemInfo.getCompareValue().toString()));
                        } else if (comp.equals((Object)CompareType.LESS_EQUALS)) {
                            this.kdDateTo.setValue((Object)Timestamp.valueOf(filterItemInfo.getCompareValue().toString()));
                        }
                    }
                    this.hasWorkShopFilter = propName.equals(FILTER_PROP_WORKSHOP);
                    if (!propName.equals(FILTER_PROP_MATERIAL)) continue;
                    if (comp.equals((Object)CompareType.GREATER_EQUALS)) {
                        this.prmtMaterialFrom.setText(filterItemInfo.getCompareValue().toString());
                        continue;
                    }
                    if (!comp.equals((Object)CompareType.LESS_EQUALS)) continue;
                    this.prmtMaterialTo.setText(filterItemInfo.getCompareValue().toString());
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void initDateTimeFields() {
        KDDatePicker beginDatePicker = new KDDatePicker();
        beginDatePicker.setName("beginDatePicker");
        beginDatePicker.setVisible(true);
        beginDatePicker.setEditable(true);
        beginDatePicker.setTimeEnabled(true);
        KDTDefaultCellEditor beginDate_CellEditor = new KDTDefaultCellEditor(beginDatePicker);
        this.kdtEntries.getColumn("beginDate").setEditor((ICellEditor)beginDate_CellEditor);
        KDDatePicker endDatePicker = new KDDatePicker();
        endDatePicker.setName("endDatePicker");
        endDatePicker.setVisible(true);
        endDatePicker.setEditable(true);
        endDatePicker.setTimeEnabled(true);
        KDTDefaultCellEditor endDate_CellEditor = new KDTDefaultCellEditor(endDatePicker);
        this.kdtEntries.getColumn(TB_PLS_ENDDATE).setEditor((ICellEditor)endDate_CellEditor);
    }

    private void initEntriesTableF7Field() {
        ObjectValueRender ovr_name = new ObjectValueRender();
        ovr_name.setFormat((IDataFormat)new BizDataFormat("$name$"));
        ObjectValueRender ovr_number = new ObjectValueRender();
        ovr_number.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn(TB_PLS_SHIFT).setRenderer((IBasicRender)ovr_name);
        this.kdtEntries.getColumn(TB_PLS_MATERIAL).setRenderer((IBasicRender)ovr_number);
        this.kdtEntries.getColumn(TB_PLS_SALEORDER_NUMBER).setRenderer((IBasicRender)ovr_number);
        this.kdtEntries.getColumn(TB_PLS_TRACK_NUMBER).setRenderer((IBasicRender)ovr_number);
        this.kdtEntries.getColumn(TB_PLS_LASTUPDATEUSER).setRenderer((IBasicRender)ovr_name);
        this.kdtEntries.getColumn(TB_PLS_AUDITOR).setRenderer((IBasicRender)ovr_name);
        this.kdtEntries.getColumn(TB_PLS_RELEASEUSER).setRenderer((IBasicRender)ovr_name);
    }

    private void initShiftF7ByProductLine() {
        int rowCount = this.kdtEntries.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            this.initShiftF7ByProductLine(rowIndex);
        }
    }

    private void initShiftF7ByProductLine(int rowIndex) {
        ProductLineInfo productLineInfo = (ProductLineInfo)this.kdtEntries.getCell(rowIndex, TB_PLS_PRODUCTLINE).getValue();
        KDBizPromptBox classTeamPromptBox = new KDBizPromptBox();
        classTeamPromptBox.setQueryInfo(F7CLASSTEAMENTRYQUERY);
        classTeamPromptBox.setDisplayFormat("$name$");
        classTeamPromptBox.setEditFormat("$number$");
        classTeamPromptBox.setCommitFormat("$number$");
        if (productLineInfo != null && productLineInfo.getClassTeam() != null) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)productLineInfo.getClassTeam().getId().toString(), CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            classTeamPromptBox.setEntityViewInfo(entityViewInfo);
        }
        this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_SHIFT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)classTeamPromptBox));
    }

    private void initCheckBox() {
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor checkBoxEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.kdtEntries.getColumn(TB_PLS_ISSELECTED).setEditor((ICellEditor)checkBoxEditor);
        KDCheckBox modifyAbleCheckBox = new KDCheckBox();
        KDTDefaultCellEditor checkBoxEditor_isModifiAble = new KDTDefaultCellEditor((JCheckBox)modifyAbleCheckBox);
        this.kdtEntries.getColumn(TB_PLS_ISMODIFIABLE).setEditor((ICellEditor)checkBoxEditor_isModifiAble);
    }

    private boolean showQueryDialog() throws Exception {
        this.initCommonQueryDialog();
        this.filterUI.getUIContext().clear();
        this.filterUI.getUIContext().putAll(this.getUIContext());
        boolean hasDefaultSolution = false;
        if (!this.mustShowQueryDialog) {
            try {
                this.queryDialog.init();
                this.queryDialog.getCommonQueryParam().setDirty(false);
                QuerySolutionInfo currSolution = this.queryDialog.getCurrentSolutionInfo();
                if (null != currSolution && currSolution.isIsUserDefaultSolu() && null != currSolution.getEntityViewInfo()) {
                    EntityViewInfo entityViewInfo = new EntityViewInfo(currSolution.getEntityViewInfo());
                    this.filterInfo = entityViewInfo.getFilter();
                    hasDefaultSolution = true;
                    this.loadData();
                    return true;
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        FilterInfo newFilterInfos = null;
        if (this.mustShowQueryDialog || !hasDefaultSolution) {
            if (this.queryDialog.show()) {
                PLSBatchFilterUI plsFilterui = (PLSBatchFilterUI)this.queryDialog.getUserPanel(0);
                newFilterInfos = plsFilterui.verify() ? plsFilterui.getFilterInfo() : null;
            }
            if (newFilterInfos == null) {
                return false;
            }
            this.filterInfo = newFilterInfos;
            this.loadData();
            return true;
        }
        return false;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo(FILTER_PROP_NUMBER));
        sic.add(new SelectorItemInfo(TB_PLS_ID));
        sic.add(new SelectorItemInfo("workShop.id"));
        sic.add(new SelectorItemInfo("workShop.number"));
        sic.add(new SelectorItemInfo("workShop.name"));
        sic.add(new SelectorItemInfo("productLine.id"));
        sic.add(new SelectorItemInfo("productLine.number"));
        sic.add(new SelectorItemInfo("productLine.name"));
        sic.add(new SelectorItemInfo("productLine.classTeam.id"));
        sic.add(new SelectorItemInfo("productLine.classTeam.number"));
        sic.add(new SelectorItemInfo("productLine.classTeam.name"));
        sic.add(new SelectorItemInfo("productLine.workshop.id"));
        sic.add(new SelectorItemInfo(FILTER_PROP_WORKSHOP));
        sic.add(new SelectorItemInfo("productLine.workshop.name"));
        sic.add(new SelectorItemInfo(TB_PLS_LINENUM));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("beginDate"));
        sic.add(new SelectorItemInfo(TB_PLS_ENDDATE));
        sic.add(new SelectorItemInfo("classTeam.id"));
        sic.add(new SelectorItemInfo("classTeam.number"));
        sic.add(new SelectorItemInfo("classTeam.name"));
        sic.add(new SelectorItemInfo("classTeam.startTime"));
        sic.add(new SelectorItemInfo("classTeam.endTime"));
        sic.add(new SelectorItemInfo(TB_PLS_PROORDER));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo(FILTER_PROP_MATERIAL));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo(TB_PLS_QTY));
        sic.add(new SelectorItemInfo(TB_PLS_ENDQTY));
        sic.add(new SelectorItemInfo("requiredDate"));
        sic.add(new SelectorItemInfo("delayTime"));
        sic.add(new SelectorItemInfo(TB_PLS_ISSUBPLAN));
        sic.add(new SelectorItemInfo("isExpand"));
        sic.add(new SelectorItemInfo("srcType"));
        sic.add(new SelectorItemInfo("sourceBillNumber"));
        sic.add(new SelectorItemInfo("traceNo"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo("trackNumber.name"));
        sic.add(new SelectorItemInfo("parent.pLSModel.id"));
        sic.add(new SelectorItemInfo("parent.pLSModel.number"));
        sic.add(new SelectorItemInfo("parent.pLSModel.name"));
        sic.add(new SelectorItemInfo("saleOrder.id"));
        sic.add(new SelectorItemInfo("saleOrder.number"));
        sic.add(new SelectorItemInfo("saleOrder.name"));
        sic.add(new SelectorItemInfo(TB_PLS_MAINPLANID));
        sic.add(new SelectorItemInfo("varDate"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("baseUnit.number"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo(TB_PLS_BASEQTY));
        sic.add(new SelectorItemInfo("plcEntryId"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateUser.number"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("releaseUser.id"));
        sic.add(new SelectorItemInfo("releaseUser.number"));
        sic.add(new SelectorItemInfo("releaseUser.name"));
        return sic;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.mustShowQueryDialog = true;
        this.showQueryDialog();
    }

    @Override
    public void loadFields() {
        this.removeListener();
        this.dataBinder.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.changePrecision();
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            this.kdtEntries.getRow(i).getCell(TB_PLS_ISSELECTED).setValue((Object)Boolean.FALSE);
            Set workshops = (Set)this.authorizedWorkshops_modify.get(this.storageOrg.getId().toString());
            if (workshops != null && workshops.contains(((AdminOrgUnitInfo)this.kdtEntries.getRow(i).getCell(TB_PLS_WORKSHOP).getValue()).getNumber().toString())) {
                this.kdtEntries.getRow(i).getCell(TB_PLS_ISMODIFIABLE).setValue((Object)Boolean.TRUE);
                this.kdtEntries.getRow(i).getStyleAttributes().setLocked(false);
                continue;
            }
            this.kdtEntries.getRow(i).getCell(TB_PLS_ISMODIFIABLE).setValue((Object)Boolean.FALSE);
            this.kdtEntries.getRow(i).getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(i).getStyleAttributes().setBackground(UNMODIFIABLE_COLOR);
        }
        this.initShiftF7ByProductLine();
        this.addListener();
    }

    private void addListener() {
        this.entryTableChange = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    PLSBatchEditUI.this.kdtEntries_Changed(e);
                }
                catch (Exception exc) {
                    PLSBatchEditUI.this.handUIException(exc);
                }
            }
        };
        this.kdtEntries.addKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    private void removeListener() {
        if (this.entryTableChange != null) {
            this.kdtEntries.removeKDTEditListener((KDTEditListener)this.entryTableChange);
        }
    }

    public void kdtEntries_Changed(KDTEditEvent e) throws Exception {
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        if (oldValue != null && newValue != null && oldValue instanceof BigDecimal && newValue instanceof BigDecimal) {
            BigDecimal oldBigValue = (BigDecimal)oldValue;
            BigDecimal newBigValue = (BigDecimal)newValue;
            if ((oldBigValue = oldBigValue.setScale(newBigValue.scale(), 4)).compareTo(newBigValue) == 0) {
                return;
            }
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.kdtEntries.getColumnKey(colIndex);
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue);
        if (TB_PLS_QTY.equalsIgnoreCase(fieldName)) {
            this.setBaseQtyValueAndPrecision(rowIndex, TB_PLS_MATERIAL, TB_PLS_BASEUNIT, TB_PLS_UNIT, TB_PLS_QTY);
        }
        if (TB_PLS_SHIFT.equals(fieldName) && this.kdtEntries.getRowCount() > 0 && newValue != null && isDiffrent) {
            Date oldBeginDate = (Date)this.kdtEntries.getCell(rowIndex, "beginDate").getValue();
            Date oldEndDate = (Date)this.kdtEntries.getCell(rowIndex, TB_PLS_ENDDATE).getValue();
            Time newBeginDate = ((ClassTeamEntryInfo)newValue).getStartTime();
            Time newEndDate = ((ClassTeamEntryInfo)newValue).getEndTime();
            this.kdtEntries.getCell(rowIndex, "beginDate").setValue((Object)this.setDateTime(oldBeginDate, newBeginDate));
            this.kdtEntries.getCell(rowIndex, TB_PLS_ENDDATE).setValue((Object)this.setDateTime(oldEndDate, newEndDate));
        }
    }

    private Date setDateTime(Date oldDate, Date newDate) {
        Calendar oldCa = Calendar.getInstance();
        Calendar newCa = Calendar.getInstance();
        oldCa.setTime(oldDate);
        newCa.setTime(newDate);
        oldCa.set(11, newCa.get(11));
        oldCa.set(12, newCa.get(12));
        oldCa.set(13, newCa.get(13));
        oldCa.set(14, newCa.get(14));
        return oldCa.getTime();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initCommonQueryDialog() {
        if (this.queryDialog == null) {
            this.queryDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.queryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.queryDialog.setOwner((Component)((Object)this));
            }
            this.queryDialog.setUiObject((IUIObject)this);
            this.queryDialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
            this.queryDialog.setQueryObjectPK(this.mainQueryPK);
            MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}-{1}");
            String title = format.format(new Object[]{this.getUITitle(), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter")});
            this.queryDialog.setTitle(title);
            this.queryDialog.setShowFilter(false);
            this.queryDialog.setShowSorter(false);
            try {
                this.filterUI = (PLSBatchFilterUI)this.getFilterUI();
                this.queryDialog.setHeight(320);
                this.queryDialog.setWidth(450);
                this.queryDialog.addUserPanel((KDPanel)this.filterUI);
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new PLSBatchFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.setOprtState(EDIT);
        this.unLockUI();
        this.initDataStatus();
    }

    protected void unLockUI() {
        this.kdtEntries.getColumn("beginDate").getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn(TB_PLS_ENDDATE).getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn(TB_PLS_SHIFT).getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn(TB_PLS_PROORDER).getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn(TB_PLS_QTY).getStyleAttributes().setLocked(false);
        for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
            EntryBaseStatusEnum rowStatus = (EntryBaseStatusEnum)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_BASESTATUS).getValue();
            if (this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ISMODIFIABLE).getValue().equals(Boolean.TRUE) && EntryBaseStatusEnum.SUBMITED == rowStatus) {
                this.kdtEntries.getRow(rowIndex).getCell("beginDate").getStyleAttributes().setLocked(false);
                this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ENDDATE).getStyleAttributes().setLocked(false);
                this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_SHIFT).getStyleAttributes().setLocked(false);
                this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_PROORDER).getStyleAttributes().setLocked(false);
                this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_QTY).getStyleAttributes().setLocked(false);
                continue;
            }
            this.kdtEntries.getRow(rowIndex).getCell("beginDate").getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ENDDATE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_SHIFT).getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_PROORDER).getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_QTY).getStyleAttributes().setLocked(true);
        }
    }

    protected void lockUIForViewStatus() {
        this.kdtEntries.getColumn("beginDate").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_PLS_ENDDATE).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_PLS_SHIFT).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_PLS_PROORDER).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_PLS_QTY).getStyleAttributes().setLocked(true);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.validData(e);
        this.storeFields();
        PLSEntryCollection addedCol = new PLSEntryCollection();
        PLSEntryCollection modifiedCol = new PLSEntryCollection();
        PLSEntryCollection deletedCol = new PLSEntryCollection();
        IPLSEntry iplse = PLSEntryFactory.getRemoteInstance();
        int saveDataSize = this.editDatas.size();
        for (i = 0; i < saveDataSize; ++i) {
            PLSEntryInfo saveValue = (PLSEntryInfo)this.editDatas.getObject(i);
            PLSEntryInfo oldValue = null;
            boolean find = false;
            int indexInOldEditDatas = 0;
            int oldDataSize = this.oldEditDatas.size();
            for (int j = 0; j < oldDataSize; ++j) {
                oldValue = (PLSEntryInfo)this.oldEditDatas.getObject(j);
                BOSUuid dbPK = oldValue.getId();
                BOSUuid voPK = saveValue.getId();
                if (!dbPK.toString().equals(voPK.toString())) continue;
                find = true;
                indexInOldEditDatas = j;
                break;
            }
            if (!find) {
                addedCol.add(saveValue);
                continue;
            }
            if (!this.checkDataChanged(saveValue, (PLSEntryInfo)this.oldEditDatas.getObject(indexInOldEditDatas))) continue;
            modifiedCol.addObject((IObjectValue)saveValue);
        }
        int oldDataSize = this.oldEditDatas.size();
        for (i = 0; i < oldDataSize; ++i) {
            PLSEntryInfo oldValue = (PLSEntryInfo)this.oldEditDatas.getObject(i);
            boolean find = false;
            int saveDataSize2 = this.editDatas.size();
            for (int j = 0; j < saveDataSize2; ++j) {
                PLSEntryInfo saveValue = (PLSEntryInfo)this.editDatas.getObject(j);
                BOSUuid dbPK = oldValue.getId();
                BOSUuid voPK = saveValue.getId();
                if (!dbPK.toString().equals(voPK.toString())) continue;
                find = true;
                break;
            }
            if (find) continue;
            deletedCol.addObject((IObjectValue)oldValue);
        }
        HashMap result = null;
        if (addedCol.size() > 0 || modifiedCol.size() > 0 || deletedCol.size() > 0) {
            result = iplse.batchSubmit((IObjectCollection)addedCol, (IObjectCollection)modifiedCol, (IObjectCollection)deletedCol);
        }
        if (result != null && result.size() > 0) {
            MsgBox.showWarning((String)((String)result.get("DELETE")));
        } else {
            this.showSubmitSuccess();
        }
        this.loadData();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList<String> selIdList = new ArrayList<String>();
        for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
            if (!((Boolean)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ISSELECTED).getValue()).booleanValue()) continue;
            EntryBaseStatusEnum rowStatus = (EntryBaseStatusEnum)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_BASESTATUS).getValue();
            if (rowStatus == EntryBaseStatusEnum.SUBMITED) {
                selIdList.add(this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ID).getValue().toString());
                continue;
            }
            this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ISSELECTED).setValue((Object)Boolean.FALSE);
        }
        if (selIdList.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PLSBATCH, (String)"NoSubmitedRowSelected_CannotAudit"));
            return;
        }
        IObjectPK[] pks = this.convertListToObjectPK(selIdList);
        IPLSEntry iplse = PLSEntryFactory.getRemoteInstance();
        boolean isExistSubPlan = iplse.checkExistSubPlan(pks, null);
        int result = 1;
        if (isExistSubPlan) {
            result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES_PLSBATCH, (String)"Msg_AuditSubPlan"));
        }
        boolean isSuccess = false;
        try {
            iplse.audit(pks, MsgBox.isYes((int)result));
            isSuccess = true;
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        if (isSuccess) {
            this.showSuccessMsg(EASResource.getString((String)RES_PLSBATCH, (String)"Msg_Audit_OK"));
            this.loadData();
        }
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList<String> selIdList = new ArrayList<String>();
        for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
            if (!((Boolean)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ISSELECTED).getValue()).booleanValue()) continue;
            EntryBaseStatusEnum rowStatus = (EntryBaseStatusEnum)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_BASESTATUS).getValue();
            if (rowStatus == EntryBaseStatusEnum.AUDITED) {
                selIdList.add(this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ID).getValue().toString());
                continue;
            }
            this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ISSELECTED).setValue((Object)Boolean.FALSE);
        }
        if (selIdList.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PLSBATCH, (String)"NoAuditRowSelected_CannotUnAudit"));
            return;
        }
        IObjectPK[] pks = this.convertListToObjectPK(selIdList);
        IPLSEntry iplse = PLSEntryFactory.getRemoteInstance();
        boolean isExistSubPlan = iplse.checkExistSubPlan(pks, null);
        int result = 1;
        if (isExistSubPlan) {
            result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES_PLSBATCH, (String)"Msg_UnAuditSubPlan"));
        }
        boolean isSuccess = false;
        try {
            iplse.unAudit(pks, MsgBox.isYes((int)result));
            isSuccess = true;
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        if (isSuccess) {
            this.showSuccessMsg(EASResource.getString((String)RES_PLSBATCH, (String)"Msg_UnAudit_OK"));
            this.loadData();
        }
    }

    @Override
    public void actionRelease_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList<String> selIdList = new ArrayList<String>();
        for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
            if (!((Boolean)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ISSELECTED).getValue()).booleanValue()) continue;
            boolean isSubPlan = (Boolean)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ISSUBPLAN).getValue();
            EntryBaseStatusEnum rowStatus = (EntryBaseStatusEnum)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_BASESTATUS).getValue();
            if (!isSubPlan && rowStatus == EntryBaseStatusEnum.AUDITED) {
                selIdList.add(this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ID).getValue().toString());
                continue;
            }
            this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ISSELECTED).setValue((Object)Boolean.FALSE);
        }
        if (selIdList.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PLSBATCH, (String)"NoAuditedMainPlanSelected_CannotRelease"));
            return;
        }
        IObjectPK[] pks = this.convertListToObjectPK(selIdList);
        IPLSEntry iplse = PLSEntryFactory.getRemoteInstance();
        boolean isExistSubPlan = iplse.checkExistSubPlan(pks, String.valueOf(2));
        int result = 0;
        if (isExistSubPlan && !MsgBox.isYes((int)(result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES_PLSBATCH, (String)"Msg_AuditAndReleaseSubPlan"))))) {
            SysUtil.abort();
        }
        Object[] rtn = iplse.checkFormula(pks);
        List unReleaseMaterial = null;
        IObjectPK[] releasePks = null;
        if (rtn != null) {
            unReleaseMaterial = (List)rtn[0];
            releasePks = (IObjectPK[])rtn[1];
        }
        if (unReleaseMaterial != null && unReleaseMaterial.size() > 0) {
            ArrayList<String> mats = new ArrayList<String>();
            String material = "";
            StringBuffer materials = new StringBuffer();
            for (int i = 0; i < unReleaseMaterial.size(); ++i) {
                material = unReleaseMaterial.get(i).toString();
                if (mats.contains(material)) continue;
                mats.add(material);
                materials.append(unReleaseMaterial.get(i).toString()).append(" ");
            }
            MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}{1}{2}");
            String detailMessage = format.format(new Object[]{EASResource.getString((String)RES_PLSBATCH, (String)"MaterialNumber"), materials.toString(), EASResource.getString((String)RES_PLSBATCH, (String)"NoFormula")});
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RES_PLSBATCH, (String)"NoFormula_CannotRelease"), (String)detailMessage, (int)8188);
            SysUtil.abort();
        }
        if (releasePks != null && releasePks.length > 0) {
            pks = releasePks;
        }
        boolean isSuccess = false;
        HashMap notAuditedMap = null;
        HashMap statusMap = null;
        HashMap retMap = null;
        try {
            retMap = iplse.release(pks);
            isSuccess = true;
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        if (isSuccess) {
            notAuditedMap = (HashMap)retMap.get("notAuditedMap");
            statusMap = (HashMap)retMap.get("statusMap");
            String status = (String)statusMap.get(TB_PLS_BASESTATUS);
            if ("OK".equalsIgnoreCase(status)) {
                if (notAuditedMap.size() > 0) {
                    StringBuffer errorDetail = new StringBuffer();
                    for (Map.Entry entry : notAuditedMap.entrySet()) {
                        PLSActionResult actionResult = (PLSActionResult)entry.getValue();
                        errorDetail.append(actionResult.getNumber() + "\t");
                        errorDetail.append(actionResult.getLineNumber() + "\t");
                        errorDetail.append(actionResult.getMessage() + "\n");
                    }
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RES_PLSBATCH, (String)"Msg_SomeRecord_NotReleased"), (String)errorDetail.toString(), (int)8188);
                } else {
                    this.showSuccessMsg(EASResource.getString((String)RES_PLSBATCH, (String)"Msg_Release_OK"));
                }
                this.loadData();
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RES_SCHEDULING, (String)"Msg_Edit_ReleasedFail"), (String)status, (int)8188);
                this.loadData();
            }
        }
    }

    @Override
    public void actionUnRelease_actionPerformed(ActionEvent e) throws Exception {
        HashMap retMap;
        HashMap statusMap;
        HashMap notReleaseMap;
        boolean isSuccess;
        block12: {
            this.checkSelected();
            ArrayList<String> selIdList = new ArrayList<String>();
            for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
                if (!((Boolean)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ISSELECTED).getValue()).booleanValue()) continue;
                EntryBaseStatusEnum rowStatus = (EntryBaseStatusEnum)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_BASESTATUS).getValue();
                if (rowStatus == EntryBaseStatusEnum.RELEASED) {
                    selIdList.add(this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ID).getValue().toString());
                    continue;
                }
                this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ISSELECTED).setValue((Object)Boolean.FALSE);
            }
            if (selIdList.size() == 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PLSBATCH, (String)"NoReleasedSelected_CannotUnRelease"));
                return;
            }
            IObjectPK[] pks = this.convertListToObjectPK(selIdList);
            isSuccess = false;
            notReleaseMap = null;
            statusMap = null;
            retMap = null;
            try {
                if (selIdList == null || selIdList.size() <= 0) break block12;
                if (0 == MsgBox.showConfirm2((Component)((Object)this), (String)ResourceUtils.getMessageForClient((String)RES_SCHEDULING, (String)"Msg_Edit_IsUnReleased"))) {
                    IPLSEntry iplse = PLSEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
                    retMap = iplse.unRelease(pks);
                    isSuccess = true;
                    break block12;
                }
                return;
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
        if (isSuccess) {
            notReleaseMap = (HashMap)retMap.get("notReleaseMap");
            statusMap = (HashMap)retMap.get("statusMap");
            String status = (String)statusMap.get(TB_PLS_BASESTATUS);
            if ("OK".equalsIgnoreCase(status)) {
                if (notReleaseMap.size() > 0) {
                    StringBuffer errorDetail = new StringBuffer();
                    for (Map.Entry entry : notReleaseMap.entrySet()) {
                        PLSActionResult actionResult = (PLSActionResult)entry.getValue();
                        errorDetail.append(actionResult.getNumber() + "\t");
                        errorDetail.append(actionResult.getLineNumber() + "\t");
                        errorDetail.append(actionResult.getMessage() + "\n");
                    }
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RES_PLSBATCH, (String)"Msg_SomeRecord_NotUnReleased"), (String)errorDetail.toString(), (int)8188);
                } else {
                    this.showSuccessMsg(EASResource.getString((String)RES_PLSBATCH, (String)"Msg_UnRelease_OK"));
                }
                this.loadData();
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RES_SCHEDULING, (String)"Msg_Edit_UnReleasedFail"), (String)status, (int)8188);
            }
        }
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(msgResource);
        this.showMessage();
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<Integer> selRowIndex = new ArrayList<Integer>();
        for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
            if (!((Boolean)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ISSELECTED).getValue()).booleanValue()) continue;
            selRowIndex.add(new Integer(rowIndex));
        }
        if (selRowIndex.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        if (selRowIndex.size() > 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PLSBATCH, (String)"Msg_OnlyOneRowToCopy"));
            return;
        }
        int fromRowIndex = (Integer)selRowIndex.get(0);
        int toRowIndex = fromRowIndex + 1;
        IRow newRow = this.kdtEntries.addRow(toRowIndex);
        PLSEntryInfo plsEntryInfo = (PLSEntryInfo)this.kdtEntries.getRow(fromRowIndex).getUserObject();
        PLSEntryInfo newEntryInfo = (PLSEntryInfo)plsEntryInfo.clone();
        newEntryInfo.setAuditor(null);
        newEntryInfo.setAuditTime(null);
        newEntryInfo.setLastUpdateUser(UserFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext()).getUserInfo(this.getUserPk()));
        newEntryInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        newEntryInfo.setReleaseUser(null);
        newEntryInfo.setReleaseTime(null);
        newEntryInfo.setId(BOSUuid.create((String)"72079370"));
        newEntryInfo.setLineNum(null);
        newEntryInfo.setQty(new BigDecimal(0));
        newEntryInfo.setEndQty(new BigDecimal(0));
        newEntryInfo.setBaseQty(new BigDecimal(0));
        newEntryInfo.setIsExpand(false);
        newEntryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        try {
            IPLSEntry iplse = PLSEntryFactory.getRemoteInstance();
            String productlineId = newEntryInfo.getProductLine().getId().toString();
            Timestamp startDate = newEntryInfo.getBeginDate();
            BigDecimal maxOrder = new BigDecimal(0);
            if (startDate != null && productlineId != null) {
                maxOrder = iplse.getMaxProOrder(productlineId, startDate);
                int rowCount = this.kdtEntries.getRowCount();
                for (int index = 0; index < rowCount; ++index) {
                    if (index == toRowIndex) continue;
                    String compProductLineId = ((ProductLineInfo)this.kdtEntries.getRow(index).getCell(TB_PLS_PRODUCTLINE).getValue()).getId().toString();
                    Date compStartDate = (Date)this.kdtEntries.getRow(index).getCell("beginDate").getValue();
                    BigDecimal compProOrder = (BigDecimal)this.kdtEntries.getRow(index).getCell(TB_PLS_PROORDER).getValue();
                    if (compStartDate == null || compProOrder == null || !compProductLineId.equals(productlineId) || compStartDate.compareTo(startDate) != 0 || maxOrder.compareTo(compProOrder) >= 0) continue;
                    maxOrder = compProOrder;
                }
            }
            int tempInt = maxOrder.divide(new BigDecimal(10), 0, 1).intValue();
            BigDecimal newOrder = new BigDecimal((tempInt + 1) * 10);
            newEntryInfo.setProOrder(newOrder);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        newRow.getCell(TB_PLS_ISSELECTED).setValue((Object)Boolean.FALSE);
        newRow.getCell(TB_PLS_ISMODIFIABLE).setValue((Object)Boolean.TRUE);
        this.dataBinder.loadLineFields(this.kdtEntries, newRow, (IObjectValue)newEntryInfo);
        this.initShiftF7ByProductLine(toRowIndex);
        this.changeRowPrecision(toRowIndex);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            int choice;
            ArrayList<String> selIdList = new ArrayList<String>();
            boolean isAllSelRecSubmited = true;
            for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
                if (!((Boolean)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ISSELECTED).getValue()).booleanValue()) continue;
                EntryBaseStatusEnum rowStatus = (EntryBaseStatusEnum)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_BASESTATUS).getValue();
                if (rowStatus == EntryBaseStatusEnum.SUBMITED) {
                    selIdList.add(this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ID).getValue().toString());
                    continue;
                }
                isAllSelRecSubmited = false;
            }
            if (selIdList.size() == 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PLSBATCH, (String)"NoSubmitedRowSelected_CannotDelete"));
                return;
            }
            if (!isAllSelRecSubmited && !MsgBox.isYes((int)(choice = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES_PLSBATCH, (String)"NotAllSelectRecSubmited_KeepDelete"))))) {
                return;
            }
            IObjectPK[] pks = this.convertListToObjectPK(selIdList);
            IPLSEntry iplse = PLSEntryFactory.getRemoteInstance();
            boolean isExistSubPlan = iplse.checkExistSubPlan(pks, null);
            int result = 0;
            if (isExistSubPlan) {
                result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES_PLSBATCH, (String)"Msg_DeleteAllSubPlan"));
                if (MsgBox.isYes((int)result)) {
                    boolean isExistNotSubmitedSubPlan = iplse.checkExistSubPlan(pks, String.valueOf(2));
                    if (isExistNotSubmitedSubPlan && !MsgBox.isYes((int)(result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES_PLSBATCH, (String)"ExistNotSubmitedSubPlan_Continue"))))) {
                        return;
                    }
                } else {
                    return;
                }
            }
            this.removeFromKDTable(pks);
        }
    }

    protected void showSubmitSuccess() {
        this.setMessageText(EASResource.getString((String)RES_PLSBATCH, (String)"DayAbilityPlan") + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Submit_OK"));
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    private boolean checkDataChanged(PLSEntryInfo saveValue, PLSEntryInfo oldValue) {
        boolean b5;
        boolean isDatachanged = false;
        boolean b1 = SCMGroupClientUtils.isDiffrent((Object)saveValue.getBeginDate(), (Object)oldValue.getBeginDate());
        boolean b2 = SCMGroupClientUtils.isDiffrent((Object)saveValue.getEndDate(), (Object)oldValue.getEndDate());
        boolean b3 = SCMGroupClientUtils.isDiffrent((Object)saveValue.getClassTeam(), (Object)oldValue.getClassTeam());
        boolean b4 = SCMGroupClientUtils.isDiffrent((Object)saveValue.getProOrder(), (Object)oldValue.getProOrder());
        boolean bl = b5 = saveValue.getQty().compareTo(oldValue.getQty()) != 0;
        if (b1 || b2 || b3 || b4 || b5) {
            isDatachanged = true;
        }
        return isDatachanged;
    }

    protected void validData(ActionEvent e) throws Exception {
        StringBuffer msg = new StringBuffer();
        boolean isvalid = true;
        int focuscol = 0;
        int rowCount = this.kdtEntries.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            msg.delete(0, msg.length());
            msg.append(SCMClientUtils.getResource((String)"EntryFieldCheck_RowNum")).append(rowIndex + 1).append(":");
            IRow row = this.kdtEntries.getRow(rowIndex);
            boolean isModifiAble = (Boolean)row.getCell(TB_PLS_ISMODIFIABLE).getValue();
            EntryBaseStatusEnum rowStatus = (EntryBaseStatusEnum)row.getCell(TB_PLS_BASESTATUS).getValue();
            if (!isModifiAble || rowStatus != EntryBaseStatusEnum.SUBMITED) continue;
            if (row.getCell("beginDate").getValue() == null) {
                msg.append(this.kdtEntries.getHeadRow(0).getCell("beginDate").getValue().toString());
                focuscol = row.getCell("beginDate").getColumnIndex();
                isvalid = false;
            } else if (row.getCell(TB_PLS_ENDDATE).getValue() == null) {
                msg.append(this.kdtEntries.getHeadRow(0).getCell(TB_PLS_ENDDATE).getValue().toString());
                focuscol = row.getCell(TB_PLS_ENDDATE).getColumnIndex();
                isvalid = false;
            } else if (row.getCell(TB_PLS_PROORDER).getValue() == null) {
                msg.append(this.kdtEntries.getHeadRow(0).getCell(TB_PLS_PROORDER).getValue().toString());
                focuscol = row.getCell(TB_PLS_PROORDER).getColumnIndex();
                isvalid = false;
            } else if (row.getCell(TB_PLS_QTY).getValue() == null || ((BigDecimal)row.getCell(TB_PLS_QTY).getValue()).compareTo(new BigDecimal("0")) <= 0) {
                msg.append(this.kdtEntries.getHeadRow(0).getCell(TB_PLS_QTY).getValue().toString());
                focuscol = row.getCell(TB_PLS_QTY).getColumnIndex();
                isvalid = false;
            }
            if (!isvalid) {
                msg.append(SCMClientUtils.getResource((String)"EntryFieldCheck_NotSet"));
                MsgBox.showInfo((String)msg.toString());
                this.kdtEntries.getEditManager().editCellAt(rowIndex, focuscol);
                SysUtil.abort();
                continue;
            }
            if (row.getCell("beginDate").getValue() == null || row.getCell(TB_PLS_ENDDATE).getValue() == null || ((Date)row.getCell("beginDate").getValue()).compareTo((Date)row.getCell(TB_PLS_ENDDATE).getValue()) <= 0) continue;
            msg.append(EASResource.getString((String)RES_PLSBATCH, (String)"STARTDATE_CANNOTGREATERENDDATE"));
            MsgBox.showInfo((String)msg.toString());
            this.kdtEntries.getEditManager().editCellAt(rowIndex, row.getCell("beginDate").getColumnIndex());
            SysUtil.abort();
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    private void removeFromKDTable(IObjectPK[] pks) throws BOSException, EASBizException {
        HashSet deleteSet = null;
        IPLSEntry iplse = PLSEntryFactory.getRemoteInstance();
        deleteSet = (HashSet)iplse.getDeleteAblePlans(pks);
        if (deleteSet != null && deleteSet.size() > 0) {
            int m;
            for (int index = m = this.kdtEntries.getRowCount() - 1; index >= 0; --index) {
                if (!deleteSet.contains(this.kdtEntries.getRow(index).getCell(TB_PLS_ID).getValue().toString())) continue;
                this.removeLine(this.kdtEntries, index);
            }
        }
    }

    public void removeLine(KDTable table, int rowIndex) {
        int index;
        IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
        table.removeRow(rowIndex);
        IObjectCollection collection = (IObjectCollection)table.getUserObject();
        if (collection == null) {
            logger.error((Object)"collection not be binded to table");
        } else if (detailData != null && (index = this.getCollectionIndex(collection, detailData)) >= 0 && collection.size() > index) {
            collection.removeObject(index);
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(EDIT)) {
            for (int nIndex = 0; nIndex < this.kdtEntries.getRowCount(); ++nIndex) {
                if (!this.kdtEntries.getRow(nIndex).getCell(TB_PLS_ISMODIFIABLE).getValue().equals(Boolean.TRUE)) continue;
                this.kdtEntries.getRow(nIndex).getCell(TB_PLS_ISSELECTED).setValue((Object)Boolean.TRUE);
            }
        } else {
            for (int nIndex = 0; nIndex < this.kdtEntries.getRowCount(); ++nIndex) {
                if (!this.kdtEntries.getRow(nIndex).getCell(TB_PLS_ISMODIFIABLE).getValue().equals(Boolean.TRUE)) continue;
                this.kdtEntries.getRow(nIndex).getCell(TB_PLS_ISSELECTED).setValue((Object)Boolean.TRUE);
            }
        }
    }

    @Override
    public void actionDeselectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int nIndex = 0; nIndex < this.kdtEntries.getRowCount(); ++nIndex) {
            if (!this.kdtEntries.getRow(nIndex).getCell(TB_PLS_ISSELECTED).getValue().equals(Boolean.TRUE)) continue;
            this.kdtEntries.getRow(nIndex).getCell(TB_PLS_ISSELECTED).setValue((Object)Boolean.FALSE);
        }
    }

    private void changePrecision() {
        MaterialInfo materialInfo = null;
        MeasureUnitInfo unit = null;
        MeasureUnitInfo baseUnit = null;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            if (this.kdtEntries.getRow(i).getCell(TB_PLS_MATERIAL).getValue() != null) {
                materialInfo = (MaterialInfo)this.kdtEntries.getRow(i).getCell(TB_PLS_MATERIAL).getValue();
                unit = (MeasureUnitInfo)this.kdtEntries.getRow(i).getCell(TB_PLS_UNIT).getValue();
                baseUnit = (MeasureUnitInfo)this.kdtEntries.getRow(i).getCell(TB_PLS_BASEUNIT).getValue();
                SCMClientUtils.changeTableColPrecision((Map)this.mmuPrecisions, (MaterialInfo)materialInfo, (MeasureUnitInfo)unit, (KDTable)this.getDetailTable(), (String[])this.QTYPRECISIONFROMUNITTAB, (int)i);
                SCMClientUtils.changeTableColPrecision((Map)this.mmuPrecisions, (MaterialInfo)materialInfo, (MeasureUnitInfo)baseUnit, (KDTable)this.getDetailTable(), (String[])this.QTYPRECISIONFROMBASEUNITTAB, (int)i);
                continue;
            }
            unit = (MeasureUnitInfo)this.kdtEntries.getRow(i).getCell(TB_PLS_UNIT).getValue();
            this.changePrecisionByUnit(unit, i);
        }
    }

    private void changeRowPrecision(int rowIndex) {
        MaterialInfo materialInfo = null;
        MeasureUnitInfo unit = null;
        MeasureUnitInfo baseUnit = null;
        if (this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_MATERIAL).getValue() != null) {
            materialInfo = (MaterialInfo)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_MATERIAL).getValue();
            unit = (MeasureUnitInfo)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_UNIT).getValue();
            baseUnit = (MeasureUnitInfo)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_BASEUNIT).getValue();
            SCMClientUtils.changeTableColPrecision((Map)this.mmuPrecisions, (MaterialInfo)materialInfo, (MeasureUnitInfo)unit, (KDTable)this.getDetailTable(), (String[])this.QTYPRECISIONFROMUNITTAB, (int)rowIndex);
            SCMClientUtils.changeTableColPrecision((Map)this.mmuPrecisions, (MaterialInfo)materialInfo, (MeasureUnitInfo)baseUnit, (KDTable)this.getDetailTable(), (String[])this.QTYPRECISIONFROMBASEUNITTAB, (int)rowIndex);
        } else {
            unit = (MeasureUnitInfo)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_UNIT).getValue();
            this.changePrecisionByUnit(unit, rowIndex);
        }
    }

    private void changePrecisionByUnit(MeasureUnitInfo unitInfo, int i) {
        if (unitInfo != null) {
            SCMClientUtils.changeTableColPrecision((int)unitInfo.getQtyPrecision(), (KDTable)this.getDetailTable(), (String[])this.QTYPRECISIONFROMUNITTAB, (int)i);
            SCMClientUtils.changeTableColPrecision((int)unitInfo.getQtyPrecision(), (KDTable)this.getDetailTable(), (String[])this.QTYPRECISIONFROMBASEUNITTAB, (int)i);
        } else {
            SCMClientUtils.changeTableColPrecision((int)2, (KDTable)this.getDetailTable(), (String[])this.QTYPRECISIONFROMUNITTAB, (int)i);
            SCMClientUtils.changeTableColPrecision((int)2, (KDTable)this.getDetailTable(), (String[])this.QTYPRECISIONFROMBASEUNITTAB, (int)i);
        }
    }

    private void setBaseQtyValueAndPrecision(int rowIndex, String material, String baseUnit, String unit, String qty) throws EASBizException, BOSException {
        MaterialInfo materialInfo = (MaterialInfo)this.getDetailTable().getRow(rowIndex).getCell(material).getValue();
        MeasureUnitInfo baseUnitInfo = (MeasureUnitInfo)this.getDetailTable().getRow(rowIndex).getCell(baseUnit).getValue();
        MeasureUnitInfo unitInfo = (MeasureUnitInfo)this.getDetailTable().getRow(rowIndex).getCell(unit).getValue();
        BigDecimal orderQty = SCMClientUtils.castToBigDecimalForCell((KDTable)this.getDetailTable(), (int)rowIndex, (String)qty);
        BigDecimal baseUnitQty = this.getBaseUnitQty(materialInfo, baseUnitInfo, unitInfo, orderQty);
        baseUnitQty = baseUnitQty.setScale(baseUnitInfo == null ? 2 : baseUnitInfo.getQtyPrecision(), 4);
        this.getDetailTable().getRow(rowIndex).getCell(TB_PLS_BASEQTY).setValue((Object)baseUnitQty);
    }

    private BigDecimal getBaseUnitQty(MaterialInfo materialInfo, MeasureUnitInfo baseUnitInfo, MeasureUnitInfo unitInfo, BigDecimal orderQty) {
        BigDecimal targetQty = orderQty;
        BigDecimal baseExchangeRate1 = (BigDecimal)this.mmuConvsRate.get(materialInfo.getId().toString() + unitInfo.getId().toString());
        BigDecimal baseExchangeRate2 = (BigDecimal)this.mmuConvsRate.get(materialInfo.getId().toString() + baseUnitInfo.getId().toString());
        if (baseExchangeRate1 == null) {
            baseExchangeRate1 = new BigDecimal("1.00");
        }
        if (baseExchangeRate2 == null) {
            baseExchangeRate2 = new BigDecimal("1.00");
        }
        BigDecimal baseQty = SCMUtils.effectualNumeric((BigDecimal)orderQty).multiply(baseExchangeRate1);
        int scale = 10;
        if (baseQty != null && orderQty != null) {
            scale = baseQty.scale() + orderQty.scale();
        }
        targetQty = SCMUtils.effectualNumeric((BigDecimal)baseQty).divide(SCMUtils.effectualExchangeRate((BigDecimal)baseExchangeRate2), scale != 0 ? scale : 10, 4);
        return targetQty;
    }

    public void checkSelected() {
        boolean isSelected = false;
        for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
            if (!((Boolean)this.kdtEntries.getRow(rowIndex).getCell(TB_PLS_ISSELECTED).getValue()).booleanValue()) continue;
            isSelected = true;
            break;
        }
        if (!isSelected) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected void initOldData(IObjectValue dataObject) {
        if (dataObject == null) {
            return;
        }
        AbstractObjectValue objectValue = (AbstractObjectValue)dataObject;
        objectValue.copyNewToOld();
    }

    public void checkRowSelected() {
        if (this.kdtEntries.getRowCount() == 0 || this.kdtEntries.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected String getSelectedKeyValue() {
        String keyFiledName = TB_PLS_PARENTID;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntries);
        return ListUiHelper.getSelectedKeyValue((int[])selectRows, (KDTable)this.kdtEntries, (String)keyFiledName);
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    public IObjectPK[] convertListToObjectPK(ArrayList idList) {
        int num = idList.size();
        ObjectUuidPK[] objectPk = new ObjectUuidPK[num];
        for (int i = 0; i < num; ++i) {
            objectPk[i] = new ObjectUuidPK(idList.get(i).toString());
        }
        return objectPk;
    }

    @Override
    public void actionScheDiffAnalyse_actionPerformed(ActionEvent e) throws Exception {
        this.checkRowSelected();
        String id = this.getSelectedKeyValue();
        IPLSEntry ipls = PLSEntryFactory.getRemoteInstance();
        HashMap datas = ipls.getScheDiffInfo(id);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"datas", (Object)datas);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ScheDiffAnalyseUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    @Override
    public void actionAbilityAnalyze_actionPerformed(ActionEvent e) throws Exception {
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isModify()) {
            String message = EASResource.getString((String)RES_PLSBATCH, (String)"Confirm_Submit_Exit");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
            if (result == 0) {
                try {
                    this.actionSubmit.setDaemonRun(false);
                    ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                    UtilRequest.setPrepare((boolean)false);
                    this.actionSubmit.actionPerformed(event);
                    return !this.actionSubmit.isInvokeFailed();
                }
                catch (Exception exc) {
                    return false;
                }
            }
            return result == 1;
        }
        return true;
    }

    public boolean isModify() {
        if (this.editData == null) {
            return false;
        }
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        if (VIEW.equals(this.getOprtState())) {
            return false;
        }
        try {
            this.storeFields();
            this.editData.setSyncOldValue(false);
        }
        catch (Exception exc) {
            return false;
        }
        ProductionLineSchedulingInfo objectValue = this.editData;
        return objectValue.isValueChange();
    }
}

