/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.planning.client.AbstractPLSCapFilterUI;
import com.kingdee.eas.mm.planning.util.PLSUtil;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class PLSCapFilterUI
extends AbstractPLSCapFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PLSCapFilterUI.class);
    public static final String RES_SCHEDULING = "com.kingdee.eas.mm.planning.ProductionLineSchedulingResource";
    private DataChangeListener workShopChangeListener = null;

    protected void initListener() {
        super.initListener();
        if (this.workShopChangeListener == null) {
            this.workShopChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        PLSCapFilterUI.this.prmtWorkShop_changed(e);
                    }
                    catch (Exception exc) {
                        PLSCapFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtWorkShop.addDataChangeListener(this.workShopChangeListener);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        Date beginDate = (Date)this.pkBeginDate.getValue();
        Date endDate = (Date)this.pkEndDate.getValue();
        if (beginDate != null && endDate != null) {
            if ((beginDate = PLSUtil.setDate(beginDate)).after(endDate = PLSUtil.setDate(endDate))) {
                MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessage((String)RES_SCHEDULING, (String)"Msg_Edit_WrongDate"));
                SysUtil.abort();
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessage((String)RES_SCHEDULING, (String)"Msg_Edit_BlankDate"));
            SysUtil.abort();
        }
        Object[] workShops = (Object[])this.prmtWorkShop.getValue();
        HashSet<String> workShopSet = new HashSet<String>();
        if (workShops != null && workShops.length > 0) {
            int n = workShops.length;
            for (int i = 0; i < n; ++i) {
                AdminOrgUnitInfo workShop = (AdminOrgUnitInfo)workShops[i];
                workShopSet.add(workShop.getId().toString());
            }
        }
        this.getUIContext().put("workShops", workShopSet);
        Object[] productLines = (Object[])this.prmtProductLine.getValue();
        HashSet<String> productLineSet = new HashSet<String>();
        if (productLines != null && productLines.length > 0) {
            int n = productLines.length;
            for (int i = 0; i < n; ++i) {
                ProductLineInfo productLine = (ProductLineInfo)productLines[i];
                productLineSet.add(productLine.getId().toString());
            }
        }
        this.getUIContext().put("productLines", productLineSet);
        this.getUIContext().put("beginDate", new Timestamp(beginDate.getTime()));
        this.getUIContext().put("endDate", new Timestamp(endDate.getTime()));
        this.getUIContext().put("isQuery", Boolean.TRUE);
        this.disposeUIWindow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.getUIContext().get("storageOrgUnit");
        this.prmtStorageOrgUnit.setValue((Object)storageOrgUnit);
        this.prmtStorageOrgUnit.setEnabled(false);
        Date beginDate = (Date)this.getUIContext().get("beginDate");
        Date endDate = (Date)this.getUIContext().get("endDate");
        this.pkBeginDate.setValue((Object)beginDate);
        this.pkEndDate.setValue((Object)endDate);
        Set productLineSet = (Set)this.getUIContext().get("productLineSet");
        Set workShopSet = (Set)this.getUIContext().get("workShopSet");
        this.initWorkShopF7(workShopSet);
        this.initProductLineF7(productLineSet, null);
        this.prmtWorkShop.setValue(null);
        this.prmtProductLine.setValue(null);
        String analyzeSrc = (String)this.getUIContext().get("analyzeSrc");
        if (analyzeSrc.equals("PLC")) {
            this.pkBeginDate.setEnabled(false);
            this.pkEndDate.setEnabled(false);
        } else {
            this.pkBeginDate.setEnabled(true);
            this.pkEndDate.setEnabled(true);
        }
    }

    private void initWorkShopF7(Set workShopSet) throws Exception {
        this.prmtWorkShop.setEnabledMultiSelection(true);
        this.prmtWorkShop.setDisplayFormat("$name$");
        this.prmtWorkShop.setEditFormat("$number$");
        this.prmtWorkShop.setCommitFormat("$number$");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)workShopSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        this.prmtWorkShop.setEntityViewInfo(viewInfo);
    }

    private void initProductLineF7(Set productLineSet, Set workShopSet) throws Exception {
        this.prmtProductLine.setEnabledMultiSelection(true);
        this.prmtProductLine.setDisplayFormat("$name$");
        this.prmtProductLine.setEditFormat("$number$");
        this.prmtProductLine.setCommitFormat("$number$");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)productLineSet, CompareType.INCLUDE));
        if (workShopSet != null && workShopSet.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("workShop.id", (Object)workShopSet, CompareType.INCLUDE));
        }
        viewInfo.setFilter(filterInfo);
        this.prmtProductLine.setEntityViewInfo(viewInfo);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("isQuery", Boolean.FALSE);
        super.actionExitCurrent_actionPerformed(e);
    }

    private void prmtWorkShop_changed(DataChangeEvent e) throws Exception {
        Object newValue;
        Object oldValue = e.getOldValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = e.getNewValue()));
        if (isDiffrent) {
            Set productLineSet = (Set)this.getUIContext().get("productLineSet");
            this.prmtProductLine.setValue(null);
            if (newValue != null) {
                Object[] workShops = (Object[])newValue;
                HashSet<String> workShopSet = new HashSet<String>();
                if (workShops != null && workShops.length > 0) {
                    int n = workShops.length;
                    for (int i = 0; i < n; ++i) {
                        AdminOrgUnitInfo workShop = (AdminOrgUnitInfo)workShops[i];
                        workShopSet.add(workShop.getId().toString());
                    }
                }
                this.initProductLineF7(productLineSet, workShopSet);
            } else {
                this.initProductLineF7(productLineSet, null);
            }
        }
    }
}

