/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.master.material.MaterialLeadTimeTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.ThrowModeEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.basedata.BDStatusEnum;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.mm.basedata.LineStatusEnum;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.common.AsyManager;
import com.kingdee.eas.mm.common.AsyRunParam;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderMappingFacadeFactory;
import com.kingdee.eas.mm.planning.PlannedOrderTypeEnum;
import com.kingdee.eas.mm.planning.TargetBillTypeEnum;
import com.kingdee.eas.mm.planning.client.AbstractPlannedOrderReleaseUI;
import com.kingdee.eas.mm.planning.client.PlannedOrderFilterUI;
import com.kingdee.eas.mm.planning.util.PLSUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.helper.FormattedEditorFactory;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class PlannedOrderReleaseUI
extends AbstractPlannedOrderReleaseUI {
    private static final long serialVersionUID = 5646345656564563464L;
    private static final String PLANNING_RESOURCE = "com.kingdee.eas.mm.planning.client.PlanningResource";
    private static final String PLANNING_EXCEPTION = "com.kingdee.eas.mm.planning.PlanOrderException";
    private static final String REL_MATERIAL_NUM = "material.number";
    private static final String REL_MATERIAL_NAME = "material.name";
    private static final String REL_MATERIAL_ATTR = "materialPlan.materialAttr";
    private static final String REL_UNIT = "unit.name";
    private static final String REL_START_DATE = "startDate";
    private static final String REL_END_DATE = "endDate";
    private static final String REL_STORAGE_ORG_UNIT = "storageOrgUnit.name";
    private static final String REL_SUPPLY_STORAGE_ORG_UNIT = "productionOrgUnit.name";
    private static final String REL_IS_SELECT = "isSelect";
    private static final String REL_IS_CLOSE = "isClose";
    private static final String REL_TARGET_BILL_TYPE = "targetBillType";
    private static final String REL_RELEASE_QTY = "releaseQty";
    private static final String REL_BASE_RELEASE_QTY = "baseReleaseQty";
    private static final String REL_QTY = "qty";
    private static final String REL_BASE_QTY = "baseQty";
    private static final String REL_TOTAL_RELEASE_QTY = "totalReleaseQty";
    private static final String REL_BASE_TOTAL_RELEASE_QTY = "baseTotalReleaseQty";
    private int selectRowCount = 0;
    private EventListener listeners;
    String[] lockColumnNames = new String[]{"material.number", "material.name", "materialPlan.materialAttr", "storageOrgUnit.name", "targetBillType", "number", "material.model", "baseStatus", "orderType", "releaseDate", "projectNumber", "trackNumber"};
    protected Action actionEnterTable = null;
    private Map materialPlanMap = null;
    private Map productLineMap = null;
    private Map isSelectMap = new HashMap();
    private KDBizPromptBox prmtProductLine = null;
    private KDTSortManager sm = null;

    public PlannedOrderReleaseUI() throws Exception {
        this.listeners = new EventListener();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void addListiners() {
        this.tblMain.addKDTEditListener((KDTEditListener)this.listeners);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    PlannedOrderReleaseUI.this.initData();
                    PlannedOrderReleaseUI.this.updateMaterialAttr();
                    PlannedOrderReleaseUI.this.setProductLine();
                }
                catch (BOSException e1) {
                    PlannedOrderReleaseUI.this.handUIException(e1);
                }
            }
        });
    }

    private void removeListiners() {
        this.tblMain.removeKDTEditListener((KDTEditListener)this.listeners);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            if (this.sm == null) {
                this.sm = new KDTSortManager(this.tblMain);
                this.sm.setEnableSortable(true);
                this.sm.setSortAuto(true);
                this.tblMain.setRefresh(true);
            }
            this.tblMain.getColumn(e.getColIndex()).setSortable(true);
            this.sm.sort(e.getColIndex());
            this.tblMain.repaint();
            return;
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblMain.getRowCount();
        boolean isSelect = true;
        int length = rowCount;
        for (int i = 0; i < length; ++i) {
            IRow curRow = this.tblMain.getRow(i);
            String baseStatus = curRow.getCell("baseStatus").getValue().toString();
            boolean status = baseStatus.equals(BillBaseStatusEnum.CLOSED.getAlias());
            if (status) continue;
            Boolean obj = isSelect;
            curRow.getCell(REL_IS_SELECT).setValue((Object)obj);
            this.isSelectMap.put(curRow.getCell("id").getValue(), Boolean.TRUE);
        }
        if (rowCount > 0) {
            this.btnRelease.setEnabled(true);
        }
        this.selectRowCount = this.getRowCount();
        if (rowCount < this.selectRowCount) {
            this.selectRowCount = rowCount;
        }
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblMain.getRowCount();
        boolean isSelect = false;
        int length = rowCount;
        for (int i = 0; i < length; ++i) {
            IRow curRow = this.tblMain.getRow(i);
            String baseStatus = curRow.getCell("baseStatus").getValue().toString();
            boolean status = baseStatus.equals(BillBaseStatusEnum.CLOSED.getAlias());
            if (status) continue;
            Boolean obj = isSelect;
            curRow.getCell(REL_IS_SELECT).setValue((Object)obj);
        }
        this.btnRelease.setEnabled(false);
        this.selectRowCount = 0;
        this.isSelectMap.clear();
    }

    @Override
    public void actionRelease_actionPerformed(ActionEvent e) throws Exception {
        this.released();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PlannedOrderFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected void initData() throws BOSException {
        IRow curRow;
        int num = 0;
        String[] storageOrgUnitIds = new String[this.tblMain.getRowCount()];
        String[] supplyStorageOrgUnits = new String[this.tblMain.getRowCount()];
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            String storageOrgUnitID;
            TargetBillTypeEnum targetBillType;
            curRow = this.tblMain.getRow(i);
            int qtyPrecision = this.setQtyPrecision(curRow);
            BigDecimal releaseQty = this.setQtyRelease(curRow);
            curRow.getCell(REL_RELEASE_QTY).setValue((Object)releaseQty.setScale(qtyPrecision, 4));
            BigDecimal baseReleaseQty = this.setBaseQtyRelease(curRow);
            curRow.getCell(REL_BASE_RELEASE_QTY).setValue((Object)baseReleaseQty);
            boolean isSelect = false;
            Boolean select = isSelect;
            curRow.getCell(REL_IS_SELECT).setValue((Object)select);
            boolean isClose = false;
            Boolean close = isClose;
            curRow.getCell(REL_IS_CLOSE).setValue((Object)close);
            String orderType = curRow.getCell("orderType").getValue().toString();
            if (orderType.equals(PlannedOrderTypeEnum.FABRICATED.getAlias())) {
                targetBillType = TargetBillTypeEnum.REQUIREMENT_ORDER;
                curRow.getCell(REL_TARGET_BILL_TYPE).setValue((Object)targetBillType);
            } else if (orderType.equals(PlannedOrderTypeEnum.PURCHASE.getAlias())) {
                targetBillType = TargetBillTypeEnum.PURCHASE_REQUIREMENT;
                curRow.getCell(REL_TARGET_BILL_TYPE).setValue((Object)targetBillType);
            } else if (orderType.equals(PlannedOrderTypeEnum.STOCKTRANSFER.getAlias())) {
                String supplyStorageOrgUnit;
                supplyStorageOrgUnits[num] = supplyStorageOrgUnit = curRow.getCell("productionOrgUnit.id").getValue().toString();
                ++num;
            }
            storageOrgUnitIds[i] = storageOrgUnitID = curRow.getCell("storageOrgUnit.id").getValue().toString();
        }
        HashMap mapUnit = null;
        try {
            try {
                String[] unit = new String[storageOrgUnitIds.length + num];
                for (int i = 0; i < storageOrgUnitIds.length; ++i) {
                    unit[i] = storageOrgUnitIds[i];
                }
                int len = storageOrgUnitIds.length;
                for (int i = 0; i < num; ++i) {
                    if (supplyStorageOrgUnits[i] == null) continue;
                    unit[len + i] = supplyStorageOrgUnits[i];
                }
                mapUnit = this.getCouOrgUnit(unit);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        int size2 = this.tblMain.getRowCount();
        for (int i = 0; i < size2; ++i) {
            TargetBillTypeEnum targetBillType = null;
            curRow = this.tblMain.getRow(i);
            String storageOrgUnitID = curRow.getCell("storageOrgUnit.id").getValue().toString();
            String supplyStorageOrgUnit = curRow.getCell("productionOrgUnit.id").getValue().toString();
            String orderType = curRow.getCell("orderType").getValue().toString();
            if (!orderType.equals(PlannedOrderTypeEnum.STOCKTRANSFER.getAlias())) continue;
            targetBillType = this.checkOrgUnit(mapUnit, storageOrgUnitID, supplyStorageOrgUnit) ? TargetBillTypeEnum.SROCK_TRANSFER_BILL : TargetBillTypeEnum.TRANSFER_ORDER_BILL;
            if (storageOrgUnitID.equals(supplyStorageOrgUnit)) {
                targetBillType = TargetBillTypeEnum.OUTPURCHASE_REQUIREMENT;
            }
            curRow.getCell(REL_TARGET_BILL_TYPE).setValue((Object)targetBillType);
        }
        storageOrgUnitIds = null;
    }

    private Set getMaterialIdSet() {
        HashSet<String> matSet = new HashSet<String>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            String materialId = this.tblMain.getRow(i).getCell("material.id").getValue().toString();
            matSet.add(materialId);
        }
        return matSet;
    }

    private MaterialPlanCollection getPlanInfo() throws BOSException {
        MaterialPlanCollection colls = null;
        if (this.tblMain.getRowCount() > 0) {
            String storageOrgUnitId = this.tblMain.getRow(0).getCell("storageOrgUnit.id").getValue().toString();
            Set matIdSet = this.getMaterialIdSet();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)matIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageOrgUnitId));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("material.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("materialAttr"));
            viewInfo.getSelector().add(new SelectorItemInfo("produceLeadTime"));
            viewInfo.getSelector().add(new SelectorItemInfo("forwardProcessTime"));
            viewInfo.getSelector().add(new SelectorItemInfo("backwardProcessTime"));
            viewInfo.getSelector().add(new SelectorItemInfo("throwMode"));
            viewInfo.getSelector().add(new SelectorItemInfo("productLine.number"));
            viewInfo.getSelector().add(new SelectorItemInfo("productLine.name"));
            viewInfo.getSelector().add(new SelectorItemInfo("productLine.workshop.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("productLine.lineStatus"));
            viewInfo.getSelector().add(new SelectorItemInfo("productLine.status"));
            viewInfo.getSelector().add("leadTimeType");
            viewInfo.getSelector().add("changeBatch");
            viewInfo.getSelector().add("changeLeadTime");
            viewInfo.getSelector().add("recevingLeadTime");
            viewInfo.getSelector().add("orgUnit.id");
            viewInfo.setFilter(filter);
            colls = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(viewInfo);
        }
        return colls;
    }

    private void updateMaterialAttr() throws BOSException {
        MaterialPlanCollection mats = this.getPlanInfo();
        if (mats == null) {
            return;
        }
        this.materialPlanMap = new HashMap();
        for (MaterialPlanInfo info : mats) {
            this.materialPlanMap.put(info.getMaterial().getId().toString(), info);
        }
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            String materialId = row.getCell("material.id").getValue().toString();
            MaterialPlanInfo info = (MaterialPlanInfo)this.materialPlanMap.get(materialId);
            if (info == null) continue;
            row.getCell(REL_MATERIAL_ATTR).setValue((Object)info.getMaterialAttr());
        }
    }

    private void setProductLine() {
        this.productLineMap = new HashMap();
        IRow row = null;
        String materialId = null;
        MaterialPlanInfo info = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            materialId = row.getCell("material.id").getValue().toString();
            info = (MaterialPlanInfo)this.materialPlanMap.get(materialId);
            PlannedOrderTypeEnum orderType = this.getPlannedOrderType(row);
            if (info == null || !PlannedOrderTypeEnum.FABRICATED.equals((Object)orderType)) continue;
            row.getCell("productLine").getStyleAttributes().setLocked(!ThrowModeEnum.FLOW.equals((Object)info.getThrowMode()));
            if (info.getProductLine() == null || !BDStatusEnum.APPROVE.equals((Object)info.getProductLine().getStatus()) || !LineStatusEnum.Using.equals((Object)info.getProductLine().getLineStatus())) continue;
            this.setProductLine2Cell(row, info.getProductLine());
        }
    }

    private void setProductLine2Cell(IRow row, ProductLineInfo productLineInfo) {
        row.getCell("productLine").setValue((Object)productLineInfo);
        this.productLineMap.put(row.getCell("id").getValue(), productLineInfo);
    }

    private void updateProductLine() {
        if (this.productLineMap == null) {
            this.setProductLine();
        }
        IRow row = null;
        String poId = null;
        ProductLineInfo plInfo = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            poId = row.getCell("id").getValue().toString();
            plInfo = (ProductLineInfo)this.productLineMap.get(poId);
            row.getCell("productLine").setValue((Object)plInfo);
        }
    }

    private void initProductLineF7() {
        this.prmtProductLine = new KDBizPromptBox();
        this.prmtProductLine.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7ProductLineQuery");
        this.prmtProductLine.setEditFormat("$number$");
        this.prmtProductLine.setDisplayFormat("$name$");
        this.prmtProductLine.setCommitFormat("$number$");
        this.prmtProductLine.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                PlannedOrderReleaseUI.this.setProductLineViewInfo();
            }
        });
        this.prmtProductLine.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                PlannedOrderReleaseUI.this.setProductLineViewInfo();
            }
        });
    }

    private void setProductLineViewInfo() {
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String storageOrgUnitId = null;
        if (this.tblMain.getRowCount() > 0) {
            storageOrgUnitId = this.tblMain.getRow(0).getCell("storageOrgUnit.id").getValue().toString();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", storageOrgUnitId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("lineStatus", (Object)new Integer(10), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20), CompareType.EQUALS));
        entityView.setFilter(filterInfo);
        this.prmtProductLine.setEntityViewInfo(entityView);
        this.prmtProductLine.getQueryAgent().resetRuntimeEntityView();
    }

    private BigDecimal setQtyRelease(IRow curRow) {
        this.setQtyPrecision(curRow);
        BigDecimal totalReleaseQty = (BigDecimal)curRow.getCell(REL_TOTAL_RELEASE_QTY).getValue();
        totalReleaseQty = totalReleaseQty == null ? new BigDecimal("0.00") : totalReleaseQty;
        BigDecimal qty = (BigDecimal)curRow.getCell(REL_QTY).getValue();
        qty = qty == null ? new BigDecimal("0.00") : qty;
        BigDecimal releaseQty = qty.subtract(totalReleaseQty);
        return releaseQty;
    }

    private BigDecimal setBaseQtyRelease(IRow curRow) {
        BigDecimal baseTotalReleaseQty = (BigDecimal)curRow.getCell(REL_BASE_TOTAL_RELEASE_QTY).getValue();
        baseTotalReleaseQty = baseTotalReleaseQty == null ? new BigDecimal("0.00") : baseTotalReleaseQty;
        BigDecimal baseQty = (BigDecimal)curRow.getCell(REL_BASE_QTY).getValue();
        baseQty = baseQty == null ? new BigDecimal("0.00") : baseQty;
        BigDecimal baseReleaseQty = baseQty.subtract(baseTotalReleaseQty);
        return baseReleaseQty;
    }

    protected int[] verifyBeforeRelease() {
        int[] curRowIndex = new int[this.selectRowCount];
        Date now = SCMClientUtils.getServerDate2();
        int j = 0;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow curRow = this.tblMain.getRow(i);
            Date startDate = (Date)curRow.getCell(REL_START_DATE).getValue();
            Date endDate = (Date)curRow.getCell(REL_END_DATE).getValue();
            BigDecimal releaseQty = (BigDecimal)curRow.getCell(REL_RELEASE_QTY).getValue();
            Object isSelect = curRow.getCell(REL_IS_SELECT).getValue();
            if (isSelect == null) {
                isSelect = Boolean.toString(false);
            }
            boolean select = Boolean.valueOf(isSelect.toString());
            int startDateIndex = curRow.getCell(REL_START_DATE).getColumnIndex();
            int endDateIndex = curRow.getCell(REL_END_DATE).getColumnIndex();
            int releaseQtyIndex = curRow.getCell(REL_RELEASE_QTY).getColumnIndex();
            String baseStatus = this.tblMain.getCell(i, "baseStatus").getValue().toString();
            boolean status = baseStatus.equals(BillBaseStatusEnum.CLOSED.getAlias());
            if (!select || status) continue;
            String message = "";
            if (startDate == null || endDate == null || releaseQty == null) {
                if (startDate == null) {
                    message = message + EASResource.getString((String)PLANNING_RESOURCE, (String)"START_DATE");
                    this.tblMain.getEditManager().editCellAt(i, startDateIndex);
                }
                if (endDate == null) {
                    message = message + EASResource.getString((String)PLANNING_RESOURCE, (String)"END_DATE");
                    this.tblMain.getEditManager().editCellAt(i, endDateIndex);
                }
                if (releaseQty == null) {
                    message = message + EASResource.getString((String)PLANNING_RESOURCE, (String)"RELEASED_QTY");
                    this.tblMain.getEditManager().editCellAt(i, releaseQtyIndex);
                }
                String msg = EASResource.getString((String)PLANNING_RESOURCE, (String)"CAN_NOT_BE_NULL");
                MessageFormat msgFmt = new MessageFormat(msg);
                MsgBox.showInfo((String)msgFmt.format(new String[]{message}));
                SysUtil.abort();
            }
            if (endDate.before(this.setCalendar(startDate))) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)PLANNING_RESOURCE, (String)"MSG_FINISHEDDATELESSTHANBEGINDATE"));
                this.tblMain.getEditManager().editCellAt(i, endDateIndex);
                SysUtil.abort();
            }
            if (releaseQty.compareTo(new BigDecimal("0")) <= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)PLANNING_RESOURCE, (String)"Release_Qty_Must_Be_Positive"));
                this.tblMain.getEditManager().editCellAt(i, releaseQtyIndex);
                SysUtil.abort();
                continue;
            }
            curRowIndex[j] = i;
            ++j;
        }
        return curRowIndex;
    }

    private Date setCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        return date;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Delete");
        this.tblMain.getActionMap().remove("Copy");
        this.tblMain.getActionMap().remove("Cut");
        this.btnAttachment.setVisible(false);
        this.btnRelease.setEnabled(false);
        this.tblMain.getStyleAttributes().setLocked(false);
        String[] lockColNames = new String[]{REL_MATERIAL_NUM, REL_MATERIAL_NAME, REL_MATERIAL_ATTR, REL_STORAGE_ORG_UNIT, "number", REL_QTY, REL_TOTAL_RELEASE_QTY, REL_UNIT, REL_SUPPLY_STORAGE_ORG_UNIT, REL_STORAGE_ORG_UNIT, "baseStatus", "orderType", REL_MATERIAL_ATTR, REL_TARGET_BILL_TYPE, "material.model", "productLine"};
        SCMClientUtils.lockColumns((KDTable)this.tblMain, (String[])lockColNames, (boolean)true);
        KDDatePicker startDate = new KDDatePicker();
        KDDatePicker endDate = new KDDatePicker();
        startDate.setBackground(SCMClientUtils.necessaryColor);
        endDate.setBackground(SCMClientUtils.necessaryColor);
        this.tblMain.getColumn(REL_START_DATE).setEditor((ICellEditor)new KDTDefaultCellEditor(startDate));
        this.tblMain.getColumn(REL_END_DATE).setEditor((ICellEditor)new KDTDefaultCellEditor(endDate));
        this.tblMain.getColumn(REL_START_DATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn(REL_END_DATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("avilableDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        KDCheckBox isSelect = new KDCheckBox();
        this.tblMain.getColumn(REL_IS_SELECT).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)isSelect));
        KDCheckBox isClose = new KDCheckBox();
        this.tblMain.getColumn(REL_IS_CLOSE).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)isClose));
        this.tblMain.getColumn(REL_RELEASE_QTY).getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
        KDTextField targetBillNumber = new KDTextField();
        this.tblMain.getColumn("targetBillNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)targetBillNumber));
        this.initProductLineF7();
        this.tblMain.getColumn("productLine").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtProductLine));
        this.tblMain.getActionMap().remove("Delete");
        this.loadFields();
        this.refreshList();
        this.setSize(1000, 600);
        this.setPreferredSize(this.getSize());
        this.getMenuManager(this.tblMain).getMenu().remove(1);
    }

    protected void initTableParams() {
    }

    @Override
    public void loadFields() {
        this.removeListiners();
        super.loadFields();
        this.addListiners();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnDeleteAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnRelease.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
    }

    private void released() {
        String[] colNames = new String[]{REL_MATERIAL_NAME, "orderType", REL_UNIT, REL_STORAGE_ORG_UNIT, REL_SUPPLY_STORAGE_ORG_UNIT, REL_START_DATE, REL_END_DATE, REL_BASE_TOTAL_RELEASE_QTY, REL_BASE_RELEASE_QTY, REL_QTY, REL_RELEASE_QTY, REL_BASE_QTY, REL_TOTAL_RELEASE_QTY, "id", "targetBillNumber", REL_TARGET_BILL_TYPE, "productionOrgUnit.id", "material.id", "unit.id", "number", "bizType.id", "avilableDate", "baseUnit.id", "assistUnit.id", "scheme.id", "scheme.number", "storageOrgUnit.id", "materialGroup.name", "baseStatus", REL_IS_CLOSE, "produceUnit", "produceUnit.id", "material.model", REL_MATERIAL_NUM, "sourceType", "planner.id", "projectid", "trackNumberid", "productLine"};
        Map[] m = new Map[this.selectRowCount];
        int[] rowCount = this.verifyBeforeRelease();
        int size = rowCount.length;
        HashMap map = new HashMap();
        for (int i = 0; i < size; ++i) {
            m[i] = new HashMap();
            m[i] = this.getCellValue(colNames, rowCount[i], this.selectRowCount, i, map);
        }
        Object[] set = this.groupingMaping(m);
        try {
            Context uicontext = this.getMainOrgContext();
            long time = new Date().getTime();
            String flag = time + "";
            flag = flag.substring(6, flag.length());
            uicontext.put((Object)"311F8787", (Object)("311F8787" + flag + m.length));
            AsyManager manager = new AsyManager();
            AsyRunParam runParam = new AsyRunParam();
            runParam.setBosType("311F8787");
            runParam.setClassName("com.kingdee.eas.mm.planning.app.PlannedOrderNewMappingFacadeControllerBean");
            runParam.setMethed("mapping");
            runParam.setParam(set);
            runParam.setTitle(this.getUITitle());
            runParam.setMaxSize(m.length);
            manager.setAsyRunParam(runParam);
            manager.backRun(uicontext);
            this.actionExitCurrent_actionPerformed(null);
            manager.displayAsynchLogtUI(uicontext);
            CoreUI parentUI = (CoreUI)this.getUIContext().get("Owner");
            parentUI.getUIContext().put("maxSize", new Integer(runParam.getParam().length));
            parentUI.getUIContext().put("311F8787", "311F8787" + flag + m.length);
        }
        catch (Exception e) {
            super.handleException(e);
        }
    }

    private Set[] groupingMaping(Map[] m) {
        Map map = null;
        LinkedHashSet<Map> requeit = new LinkedHashSet<Map>();
        LinkedHashSet<Map> purchare = new LinkedHashSet<Map>();
        LinkedHashSet<Map> transet = new LinkedHashSet<Map>();
        LinkedHashSet<Map> srock = new LinkedHashSet<Map>();
        LinkedHashSet<Map> outpurchare = new LinkedHashSet<Map>();
        for (int i = 0; i < m.length; ++i) {
            map = m[i];
            if (map.get(REL_TARGET_BILL_TYPE) != null && map.get(REL_TARGET_BILL_TYPE).equals((Object)TargetBillTypeEnum.REQUIREMENT_ORDER)) {
                requeit.add(map);
            }
            if (map.get(REL_TARGET_BILL_TYPE) != null && map.get(REL_TARGET_BILL_TYPE).equals((Object)TargetBillTypeEnum.PURCHASE_REQUIREMENT)) {
                purchare.add(map);
            }
            if (map.get(REL_TARGET_BILL_TYPE) != null && map.get(REL_TARGET_BILL_TYPE).equals((Object)TargetBillTypeEnum.TRANSFER_ORDER_BILL)) {
                transet.add(map);
            }
            if (map.get(REL_TARGET_BILL_TYPE) != null && map.get(REL_TARGET_BILL_TYPE).equals((Object)TargetBillTypeEnum.SROCK_TRANSFER_BILL)) {
                srock.add(map);
            }
            if (map.get(REL_TARGET_BILL_TYPE) == null || !map.get(REL_TARGET_BILL_TYPE).equals((Object)TargetBillTypeEnum.OUTPURCHASE_REQUIREMENT)) continue;
            outpurchare.add(map);
        }
        ArrayList<LinkedHashSet<Map>> list = new ArrayList<LinkedHashSet<Map>>();
        if (requeit.size() != 0) {
            list.add(requeit);
        }
        if (purchare.size() != 0) {
            list.add(purchare);
        }
        if (transet.size() != 0) {
            list.add(transet);
        }
        if (srock.size() != 0) {
            list.add(srock);
        }
        if (outpurchare.size() != 0) {
            list.add(outpurchare);
        }
        Set[] set = new Set[list.size()];
        return list.toArray(set);
    }

    private Map getCellValue(String[] colNames, int rowIndex, int num, int j, Map map) {
        IRow curRow = this.tblMain.getRow(rowIndex);
        int length = colNames.length;
        map = new HashMap<String, Object>();
        for (int i = 0; i < length; ++i) {
            Object curObj = curRow.getCell(colNames[i]).getValue();
            map.put(colNames[i], curObj);
        }
        return map;
    }

    private int setQtyPrecision(IRow curRow) {
        int qtyPrecision = Integer.parseInt(curRow.getCell("qtyPrecision").getValue().toString());
        String formatString = PrecisionUtil.getFormatString((int)qtyPrecision);
        curRow.getCell(REL_RELEASE_QTY).setEditor((ICellEditor)FormattedEditorFactory.getBigDecimalCellEditor((int)qtyPrecision, (boolean)false));
        curRow.getCell(REL_RELEASE_QTY).getStyleAttributes().setNumberFormat(formatString);
        BigDecimal releaseQty = (BigDecimal)curRow.getCell(REL_RELEASE_QTY).getValue();
        if (releaseQty != null) {
            curRow.getCell(REL_RELEASE_QTY).setValue((Object)releaseQty.setScale(qtyPrecision, 4));
        }
        curRow.getCell(REL_QTY).setEditor((ICellEditor)FormattedEditorFactory.getBigDecimalCellEditor((int)qtyPrecision, (boolean)false));
        curRow.getCell(REL_QTY).getStyleAttributes().setNumberFormat(formatString);
        BigDecimal qty = (BigDecimal)curRow.getCell(REL_QTY).getValue();
        if (qty != null) {
            curRow.getCell(REL_QTY).setValue((Object)qty.setScale(qtyPrecision, 4));
        }
        curRow.getCell(REL_TOTAL_RELEASE_QTY).setEditor((ICellEditor)FormattedEditorFactory.getBigDecimalCellEditor((int)qtyPrecision, (boolean)false));
        curRow.getCell(REL_TOTAL_RELEASE_QTY).getStyleAttributes().setNumberFormat(formatString);
        BigDecimal totalReleaseQty = (BigDecimal)curRow.getCell(REL_TOTAL_RELEASE_QTY).getValue();
        BigDecimal bigDecimal = totalReleaseQty = totalReleaseQty == null ? new BigDecimal("0.00") : totalReleaseQty;
        if (totalReleaseQty != null) {
            curRow.getCell(REL_TOTAL_RELEASE_QTY).setValue((Object)totalReleaseQty.setScale(qtyPrecision, 4));
        }
        return qtyPrecision;
    }

    private void tableValueChanged(KDTEditEvent e) throws BOSException, EASBizException {
        int selectedRow = e.getRowIndex();
        int selectedCol = e.getColIndex();
        Object newValue = e.getValue();
        if (newValue != null && newValue.equals(e.getOldValue())) {
            return;
        }
        IRow curRow = this.tblMain.getRow(selectedRow);
        int colReleaseQty = this.tblMain.getColumnIndex(REL_RELEASE_QTY);
        int colstartDate = this.tblMain.getColumnIndex(REL_START_DATE);
        int colendDate = this.tblMain.getColumnIndex(REL_END_DATE);
        int productLine = this.tblMain.getColumnIndex("productLine");
        if (selectedCol == colReleaseQty) {
            boolean isReleaseMore = this.releaseQtyChanged(curRow, newValue);
            if (isReleaseMore) {
                BigDecimal qtyRelease = (BigDecimal)e.getOldValue();
                this.tblMain.getCell(selectedRow, selectedCol).setValue(e.getOldValue());
                this.tblMain.getEditManager().editCellAt(selectedRow, selectedCol);
                if (qtyRelease != null) {
                    BigDecimal coefficient = (BigDecimal)curRow.getCell("unit.coefficient").getValue();
                    coefficient = coefficient == null ? new BigDecimal("1") : coefficient;
                    BigDecimal baseQtyRelease = qtyRelease.multiply(coefficient);
                    baseQtyRelease = baseQtyRelease == null ? new BigDecimal("0.00") : baseQtyRelease;
                    curRow.getCell(REL_BASE_RELEASE_QTY).setValue((Object)baseQtyRelease);
                } else {
                    curRow.getCell(REL_BASE_RELEASE_QTY).setValue((Object)new BigDecimal("0.00"));
                }
            } else {
                Date startDate = (Date)curRow.getCell(REL_START_DATE).getValue();
                this.calcEndDate(curRow, startDate, (BigDecimal)newValue, true);
            }
        } else if (selectedCol == colendDate) {
            Date old = (Date)e.getOldValue();
            Date oldDate = this.setCalendar(old);
            boolean endDate = this.endDateChanged(curRow, newValue);
            if (endDate) {
                if (newValue != null && newValue.equals(oldDate)) {
                    return;
                }
                this.tblMain.getCell(selectedRow, selectedCol).setValue(e.getOldValue());
                this.tblMain.getEditManager().editCellAt(selectedRow, selectedCol);
            }
        } else if (selectedCol == colstartDate) {
            Date old = (Date)e.getOldValue();
            Date oldDate = this.setCalendar(old);
            boolean starte = this.startDateChanged(curRow, newValue);
            if (starte) {
                if (newValue != null && newValue.equals(oldDate)) {
                    return;
                }
                this.tblMain.getCell(selectedRow, selectedCol).setValue(e.getOldValue());
                this.tblMain.getEditManager().editCellAt(selectedRow, selectedCol);
            } else {
                BigDecimal qty = (BigDecimal)curRow.getCell(REL_RELEASE_QTY).getValue();
                this.calcEndDate(curRow, (Date)newValue, qty, false);
            }
        } else if (selectedCol == productLine) {
            this.productLineMap.put(curRow.getCell("id").getValue(), newValue);
        }
    }

    private void isSelectChanged(KDTEditEvent e) {
        int selectedCol = e.getColIndex();
        Object newValue = e.getValue();
        if (newValue != null && newValue.equals(e.getOldValue())) {
            return;
        }
        int colIsSelect = this.tblMain.getColumnIndex(REL_IS_SELECT);
        if (selectedCol == colIsSelect) {
            newValue = newValue == null ? Boolean.valueOf(false) : newValue;
            boolean select = Boolean.valueOf(newValue.toString());
            IRow row = this.tblMain.getRow(e.getRowIndex());
            if (select) {
                ++this.selectRowCount;
                if (this.selectRowCount > 0) {
                    this.btnRelease.setEnabled(true);
                } else {
                    this.btnRelease.setEnabled(false);
                }
                this.isSelectMap.put(row.getCell("id").getValue(), Boolean.TRUE);
            } else {
                --this.selectRowCount;
                if (this.selectRowCount > 0) {
                    this.btnRelease.setEnabled(true);
                } else {
                    this.btnRelease.setEnabled(false);
                }
                this.isSelectMap.remove(row.getCell("id").getValue());
            }
        }
    }

    private boolean releaseQtyChanged(IRow curRow, Object newValue) {
        this.setQtyPrecision(curRow);
        boolean isReleaseMore = false;
        if (newValue == null) {
            curRow.getCell(REL_BASE_RELEASE_QTY).setValue((Object)new BigDecimal("0.00"));
        } else {
            BigDecimal coefficient = (BigDecimal)curRow.getCell("unit.coefficient").getValue();
            coefficient = coefficient == null ? new BigDecimal("1") : coefficient;
            BigDecimal qtyRelease = (BigDecimal)newValue;
            BigDecimal baseQtyRelease = qtyRelease.multiply(coefficient);
            baseQtyRelease = baseQtyRelease == null ? new BigDecimal("0.00") : baseQtyRelease;
            curRow.getCell(REL_BASE_RELEASE_QTY).setValue((Object)baseQtyRelease);
            BigDecimal baseReleaseQty = (BigDecimal)curRow.getCell(REL_BASE_RELEASE_QTY).getValue();
            BigDecimal baseQty = (BigDecimal)curRow.getCell(REL_BASE_QTY).getValue();
            BigDecimal baseTotalQty = (BigDecimal)curRow.getCell(REL_BASE_TOTAL_RELEASE_QTY).getValue();
            baseTotalQty = baseTotalQty == null ? new BigDecimal("0.00") : baseTotalQty;
            baseQty = baseQty == null ? new BigDecimal("0.00") : baseQty;
            boolean bl = isReleaseMore = baseReleaseQty.compareTo(baseQty.subtract(baseTotalQty)) > 0;
            if (isReleaseMore) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)PLANNING_RESOURCE, (String)"ReleaseQty_should_less_than_qty_sub_totalQty"));
            }
        }
        return isReleaseMore;
    }

    private boolean endDateChanged(IRow curRow, Object newValue) {
        boolean endDateChanged = false;
        Date endDate = (Date)newValue;
        Date startDate = (Date)curRow.getCell(REL_START_DATE).getValue();
        if (endDate == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)PLANNING_RESOURCE, (String)"MSG_EXISTSITEMTOINPUT"));
            return true;
        }
        if (endDate.before(this.setCalendar(startDate))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.planning.PlannedOrderResource", (String)"ENDDATE_CANNOT_LT_STARTDATE"));
            return true;
        }
        String storageOrgUnitId = curRow.getCell("storageOrgUnit.id").getValue().toString();
        boolean isWorkDay = true;
        try {
            isWorkDay = FactoryCalendarFactory.getRemoteInstance().isWorkDay(storageOrgUnitId, endDate);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (!isWorkDay) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)PLANNING_EXCEPTION, (String)"ENDDATE_NOTWORK_EXCEPTION"));
            return true;
        }
        return endDateChanged;
    }

    private boolean startDateChanged(IRow curRow, Object newValue) {
        boolean starteDateChanged = false;
        Date startDate = (Date)newValue;
        int startDateIndex = curRow.getCell(REL_START_DATE).getColumnIndex();
        int row = curRow.getRowIndex();
        Date now = new Date();
        if (newValue == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)PLANNING_RESOURCE, (String)"MSG_EXISTSITEMTOINPUT"));
            this.tblMain.getEditManager().editCellAt(row, startDateIndex);
            return true;
        }
        if (startDate.before(this.setCalendar(now))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)PLANNING_RESOURCE, (String)"START_DATE_CAN_NOT_BE_BEFORE_CUR_DATE"));
            this.tblMain.getEditManager().editCellAt(row, startDateIndex);
            return true;
        }
        String storageOrgUnitId = curRow.getCell("storageOrgUnit.id").getValue().toString();
        boolean isWorkDay = true;
        try {
            isWorkDay = FactoryCalendarFactory.getRemoteInstance().isWorkDay(storageOrgUnitId, startDate);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (!isWorkDay) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)PLANNING_EXCEPTION, (String)"STARTDATE_NOTWORK_EXCEPTION"));
            this.tblMain.getEditManager().editCellAt(row, startDateIndex);
            return true;
        }
        return starteDateChanged;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Storage)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exc = super.getQueryExecutor(queryPK, viewInfo);
        SorterItemCollection sorters = viewInfo.getSorter();
        int size = sorters.size();
        for (int i = 0; i < size; ++i) {
            SorterItemInfo itemInfo = (SorterItemInfo)viewInfo.getSorter().getObject(i);
            if (!itemInfo.getPropertyName().equalsIgnoreCase("entries.seq")) continue;
            viewInfo.getSorter().remove(itemInfo);
        }
        return exc;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        return new PlannedOrderFilterUI();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo2 = super.getDefaultFilterForQuery();
        FilterInfo filterInfo = new FilterInfo();
        Set idSet = (Set)this.getUIContext().get("selectedId");
        idSet = idSet == null ? new HashSet() : idSet;
        Set baseStatusSet = (Set)this.getUIContext().get("baseStatus");
        baseStatusSet = baseStatusSet == null ? new HashSet() : baseStatusSet;
        HashSet<Integer> statusSet = new HashSet<Integer>();
        int size = baseStatusSet.size();
        for (int i = 0; i < size; ++i) {
            Object status = baseStatusSet.toArray()[i];
            if (!status.equals(BillBaseStatusEnum.AUDITED.getAlias())) continue;
            statusSet.add(new Integer(4));
        }
        HashSet<Integer> hashSet = statusSet = statusSet == null ? new HashSet<Integer>() : statusSet;
        if (statusSet.size() == 0) {
            statusSet = null;
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", statusSet, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSimulant", (Object)new Integer(0), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isCannotRelease", (Object)new Integer(0), CompareType.EQUALS));
        if (filterInfo2 != null) {
            try {
                filterInfo.mergeFilter(filterInfo2, "and");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return filterInfo;
    }

    protected boolean isOrderForClickTableHead() {
        return true;
    }

    private boolean checkOrgUnit(HashMap map, String storageOrgUnitId, String supplyUnitId) {
        String s = (String)map.get(storageOrgUnitId);
        String su = (String)map.get(supplyUnitId);
        if (s == null || su == null) {
            return false;
        }
        return s.equalsIgnoreCase(su);
    }

    private HashMap getCouOrgUnit(String[] unit) throws EASBizException, BOSException {
        return (HashMap)PlannedOrderMappingFacadeFactory.getRemoteInstance().getCouOrgUnit(unit);
    }

    private PlannedOrderTypeEnum getPlannedOrderType(IRow row) {
        String orderTypeAlias = row.getCell("orderType").getValue().toString();
        List orderTypeList = PlannedOrderTypeEnum.getEnumList();
        PlannedOrderTypeEnum orderType = null;
        Iterator it = orderTypeList.iterator();
        while (it.hasNext() && !(orderType = (PlannedOrderTypeEnum)((Object)it.next())).getAlias().equals(orderTypeAlias)) {
        }
        return orderType;
    }

    private void calcEndDate(IRow curRow, Date startDate, BigDecimal qty, boolean isChangeQty) throws EASBizException, BOSException {
        String materialId = curRow.getCell("material.id").getValue().toString();
        if (this.materialPlanMap == null) {
            this.updateMaterialAttr();
        }
        MaterialPlanInfo materialPlanInfo = (MaterialPlanInfo)this.materialPlanMap.get(materialId);
        if (isChangeQty && MaterialLeadTimeTypeEnum.FIXBATCHTYPE.equals((Object)materialPlanInfo.getLeadTimeType())) {
            return;
        }
        PlannedOrderTypeEnum orderType = this.getPlannedOrderType(curRow);
        Date endDate = PLSUtil.getPlannedEndDate(orderType, materialPlanInfo, startDate, qty);
        curRow.getCell(REL_END_DATE).setValue((Object)endDate);
    }

    protected String getEditUIName() {
        return null;
    }

    private void updateSelectStatus() {
        IRow row = null;
        String poId = null;
        Boolean isSelect = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            poId = row.getCell("id").getValue().toString();
            isSelect = (Boolean)this.isSelectMap.get(poId);
            if (isSelect == null || !isSelect.booleanValue()) continue;
            row.getCell(REL_IS_SELECT).setValue((Object)isSelect);
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private class EventListener
    implements KDTEditListener {
        private EventListener() {
        }

        public void editStopped(KDTEditEvent e) {
            try {
                PlannedOrderReleaseUI.this.tableValueChanged(e);
            }
            catch (BOSException e1) {
                PlannedOrderReleaseUI.this.handleException((Exception)((Object)e1));
            }
            catch (EASBizException e1) {
                PlannedOrderReleaseUI.this.handleException((Exception)((Object)e1));
            }
        }

        public void editStopping(KDTEditEvent e) {
        }

        public void editValueChanged(KDTEditEvent e) {
            PlannedOrderReleaseUI.this.isSelectChanged(e);
        }

        public void editCanceled(KDTEditEvent e) {
        }

        public void editStarted(KDTEditEvent e) {
        }

        public void editStarting(KDTEditEvent e) {
        }
    }
}

