/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.PlanVersionSetFactory;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.basedata.ProductLineFactory;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.planning.SupplyMaterialShowTypeEnum;
import com.kingdee.eas.mm.planning.client.AbstractProductLineSupplyMaterialPlanFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProductLineSupplyMaterialPlanFilterUI
extends AbstractProductLineSupplyMaterialPlanFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductLineSupplyMaterialPlanFilterUI.class);
    private static final String RESOURCE_PATH = "com.kingdee.eas.mm.planning.ProductLineSupplyMaterialPlanResource";
    protected F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 1);
    private Map productLineMap = null;
    private Map workShopMap = null;

    public void clear() {
        super.clear();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmptStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_SupplyMaterialPlan_view");
        StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_SupplyMaterialPlan_view");
        this.prmptStorageOrgUnit.setValue((Object)storageOrgInfo);
        this.prmptPlanVersion.setValue(null);
        HashMap history = (HashMap)this.getUIContext().get("HISTORY");
        if (history != null) {
            Object storage = history.get("STORAGE");
            Object version = history.get("VERSION");
            if (storageOrgInfo != null && storage != null && storageOrgInfo.getId().toString().equalsIgnoreCase(((StorageOrgUnitInfo)storage).getId().toString())) {
                this.prmptPlanVersion.setValue(version);
            }
        }
        this.prmptWorkShop.setValue(null);
        this.prmptProductLine.setValue(null);
        this.prmptMaterialFrom.setValue(null);
        this.prmptMaterialTo.setValue(null);
        this.cmbShowType.setSelectedItem((Object)SupplyMaterialShowTypeEnum.SupplyMaterialEntry);
        Calendar cal = Calendar.getInstance();
        this.kdBeginDate.setValue((Object)cal.getTime());
        cal.add(2, 1);
        this.kdEndDate.setValue((Object)cal.getTime());
    }

    public FilterInfo getFilterInfo() {
        int i;
        HashSet<String> set;
        this.filterInfo.getFilterItems().clear();
        FilterItemCollection items = this.filterInfo.getFilterItems();
        this.filterInfo.setMaskString(null);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (this.prmptPlanVersion.getValue() != null && this.prmptPlanVersion.getText() != null && this.prmptPlanVersion.getText().length() > 0) {
            items.add(new FilterItemInfo("planVersionId", (Object)((PlanVersionSetInfo)this.prmptPlanVersion.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmptStorageOrgUnit.getValue() != null && this.prmptStorageOrgUnit.getText() != null && this.prmptStorageOrgUnit.getText().length() > 0) {
            items.add(new FilterItemInfo("storageOrgUnitId", (Object)((StorageOrgUnitInfo)this.prmptStorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.kdBeginDate.getValue() != null && this.kdBeginDate.getText().length() > 0) {
            items.add(new FilterItemInfo("beginDate", (Object)format.format(this.kdBeginDate.getValue()), CompareType.LESS_EQUALS));
        }
        if (this.kdEndDate.getText() != null && this.kdEndDate.getText().length() > 0) {
            items.add(new FilterItemInfo("endDate", (Object)format.format(this.kdEndDate.getValue()), CompareType.GREATER_EQUALS));
        }
        if (this.prmptWorkShop.getValue() != null && this.prmptWorkShop.getText() != null && this.prmptWorkShop.getText().length() > 0) {
            set = new HashSet<String>();
            for (i = 0; i < ((Object[])this.prmptWorkShop.getValue()).length; ++i) {
                AdminOrgUnitInfo workShop = (AdminOrgUnitInfo)((Object[])this.prmptWorkShop.getValue())[i];
                set.add(workShop.getId().toString());
            }
            items.add(new FilterItemInfo("workShopId", set, CompareType.INCLUDE));
        }
        if (this.prmptProductLine.getValue() != null && this.prmptProductLine.getText() != null && this.prmptProductLine.getText().length() > 0) {
            set = new HashSet();
            for (i = 0; i < ((Object[])this.prmptProductLine.getValue()).length; ++i) {
                ProductLineInfo productLine = (ProductLineInfo)((Object[])this.prmptProductLine.getValue())[i];
                set.add(productLine.getId().toString());
            }
            items.add(new FilterItemInfo("productLineId", set, CompareType.INCLUDE));
        }
        if (this.prmptMaterialFrom.getText() != null && this.prmptMaterialFrom.getText().length() > 0) {
            items.add(new FilterItemInfo("materialFrom", (Object)this.prmptMaterialFrom.getText().toString().trim(), CompareType.GREATER_EQUALS));
        }
        if (this.prmptMaterialTo.getText() != null && this.prmptMaterialTo.getText().length() > 0) {
            items.add(new FilterItemInfo("materialTo", (Object)this.prmptMaterialTo.getText().toString().trim(), CompareType.LESS_EQUALS));
        }
        if (this.cmbShowType.getSelectedItem() != null) {
            items.add(new FilterItemInfo("showType", (Object)new Integer(((SupplyMaterialShowTypeEnum)((Object)this.cmbShowType.getSelectedItem())).getValue()), CompareType.EQUALS));
        }
        return this.filterInfo;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmptStorageOrgUnit;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    @Override
    protected void prmptStorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        StorageOrgUnitInfo oldObject = (StorageOrgUnitInfo)e.getOldValue();
        StorageOrgUnitInfo newObject = (StorageOrgUnitInfo)e.getNewValue();
        if (null != newObject && !newObject.equals((Object)oldObject)) {
            this.initF7Material(newObject);
            this.initProductLineF7(newObject);
            this.initPlanVersionSetF7(newObject);
        }
    }

    private void initF7Material(StorageOrgUnitInfo orgInfo) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        String materialPlanQuery = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.prmptMaterialFrom.setQueryInfo(materialPlanQuery);
        this.prmptMaterialTo.setQueryInfo(materialPlanQuery);
        this.f7Manager.registerBizMaterialF7(this.prmptMaterialFrom, null, materialPlanQuery, (OrgUnitInfo)orgInfo, false);
        this.f7Manager.registerBizMaterialF7(this.prmptMaterialTo, null, materialPlanQuery, (OrgUnitInfo)orgInfo, false);
        FilterInfo filterInfo = new FilterInfo();
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(10050));
        set.add(new Integer(10040));
        FilterItemInfo mask0 = new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS);
        FilterItemInfo mask1 = new FilterItemInfo("plan.status", (Object)new Integer(1), CompareType.EQUALS);
        FilterItemInfo mask2 = new FilterItemInfo("plan.materialAttr", set, CompareType.INCLUDE);
        FilterItemInfo mask3 = new FilterItemInfo("plan.issMode", (Object)new Integer(11050), CompareType.EQUALS);
        filterInfo.getFilterItems().add(mask0);
        filterInfo.getFilterItems().add(mask1);
        filterInfo.getFilterItems().add(mask2);
        filterInfo.getFilterItems().add(mask3);
        filterInfo.setMaskString("#0 and #1 and (#2 and #3)");
        entityViewInfo.setFilter(filterInfo);
        this.prmptMaterialFrom.setEntityViewInfo(entityViewInfo);
        this.prmptMaterialTo.setEntityViewInfo(entityViewInfo);
        this.prmptMaterialFrom.setValue(null);
        this.prmptMaterialFrom.setValue(null);
    }

    @Override
    protected void prmptWorkShop_dataChanged(DataChangeEvent e) throws Exception {
        Object[] newObject = (Object[])e.getNewValue();
        HashSet<String> set = new HashSet<String>();
        if (newObject != null) {
            for (int i = 0; i < newObject.length; ++i) {
                AdminOrgUnitInfo workShop = (AdminOrgUnitInfo)newObject[i];
                if (workShop == null) continue;
                set.add(workShop.getId().toString());
            }
            if (!set.isEmpty()) {
                this.initProductLineF7((StorageOrgUnitInfo)this.prmptStorageOrgUnit.getValue(), set);
            }
        }
    }

    private void initProductLineF7(StorageOrgUnitInfo storageOrgInfo, Set set) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (storageOrgInfo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("workshop.id", (Object)set, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        this.prmptProductLine.setEntityViewInfo(viewInfo);
        this.prmptProductLine.setValue(null);
    }

    private void initProductLineF7(StorageOrgUnitInfo storageOrgInfo) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (storageOrgInfo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        this.prmptProductLine.setEntityViewInfo(viewInfo);
        this.prmptProductLine.setValue(null);
    }

    private void initPlanVersionSetF7(StorageOrgUnitInfo storageOrgInfo) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("planType", (Object)new Integer(30), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"902", CompareType.EQUALS));
        viewInfo.setFilter(filter);
        this.prmptPlanVersion.setEntityViewInfo(viewInfo);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmptStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_SupplyMaterialPlan_view");
        StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_SupplyMaterialPlan_view");
        this.prmptStorageOrgUnit.setValue((Object)storageOrgInfo);
        if (storageOrgInfo != null) {
            MMUtils.initWorkshopF7((KDBizPromptBox)this.prmptWorkShop, (StorageOrgUnitInfo)storageOrgInfo);
            this.initProductLineF7(storageOrgInfo);
            this.initF7Material(storageOrgInfo);
            this.initPlanVersionSetF7(storageOrgInfo);
        }
        this.prmptWorkShop.setEnabledMultiSelection(true);
        this.prmptProductLine.setEnabledMultiSelection(true);
        Calendar cal = Calendar.getInstance();
        this.kdBeginDate.setValue((Object)cal.getTime());
        cal.add(2, 1);
        this.kdEndDate.setValue((Object)cal.getTime());
    }

    private String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RESOURCE_PATH, (String)key);
    }

    public boolean verify() {
        boolean bRet = true;
        Date beginDate = (Date)this.kdBeginDate.getValue();
        Date endDate = (Date)this.kdEndDate.getValue();
        StringBuffer showInfo = new StringBuffer();
        if (this.prmptPlanVersion == null || this.prmptPlanVersion.getValue() == null) {
            showInfo.append(this.getResourceMsg("Msg_PlanVesionSetIsNotNull") + "\n");
            bRet = false;
        }
        if (this.prmptStorageOrgUnit == null || this.prmptStorageOrgUnit.getValue() == null) {
            showInfo.append(this.getResourceMsg("Msg_StorageOrgUnitIsNotNull") + "\n");
            bRet = false;
        }
        if (beginDate != null && endDate != null && new Timestamp(beginDate.getTime()).after(new Timestamp(endDate.getTime()))) {
            showInfo.append(this.getResourceMsg("Msg_DateCompare") + "\n");
            bRet = false;
        }
        if (!bRet) {
            MsgBox.showInfo((String)showInfo.toString());
        }
        return bRet;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.prmptPlanVersion.setValue(null);
        this.kdBeginDate.setValue(null);
        this.kdEndDate.setValue(null);
        this.prmptStorageOrgUnit.setValue(null);
        this.prmptWorkShop.setValue(null);
        this.prmptProductLine.setValue(null);
        this.prmptMaterialFrom.setText(null);
        this.prmptMaterialTo.setText(null);
        DateFormat format = CtrlFormatUtilities.getDateFormat();
        try {
            FilterInfo filterInfo;
            if (entityViewInfo != null && (filterInfo = entityViewInfo.getFilter()).getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
                for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                    FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                    if (filterItemInfo.getPropertyName().equals("planVersionId")) {
                        this.prmptPlanVersion.setValue((Object)PlanVersionSetFactory.getRemoteInstance().getPlanVersionSetInfo((IObjectPK)new ObjectUuidPK(filterItemInfo.getCompareValue().toString())));
                    }
                    if (filterItemInfo.getPropertyName().equals("storageOrgUnitId")) {
                        this.prmptStorageOrgUnit.setValue((Object)StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(filterItemInfo.getCompareValue().toString())));
                    }
                    if (filterItemInfo.getPropertyName().equals("beginDate")) {
                        this.kdBeginDate.setValue((Object)format.parse((String)filterItemInfo.getCompareValue()));
                    }
                    if (filterItemInfo.getPropertyName().equals("endDate")) {
                        this.kdEndDate.setValue((Object)format.parse((String)filterItemInfo.getCompareValue()));
                    }
                    if (filterItemInfo.getPropertyName().equals("materialFrom")) {
                        this.prmptMaterialFrom.setText(filterItemInfo.getCompareValue().toString());
                    }
                    if (filterItemInfo.getPropertyName().equals("materialTo")) {
                        this.prmptMaterialTo.setText(filterItemInfo.getCompareValue().toString());
                    }
                    if (filterItemInfo.getPropertyName().equals("workShopId") && filterItemInfo.getCompareValue() != null && ((Set)filterItemInfo.getCompareValue()).size() > 0) {
                        this.prmptWorkShop.setValue((Object)this.getWorkShop(((Set)filterItemInfo.getCompareValue()).toArray()));
                    }
                    if (filterItemInfo.getPropertyName().equals("productLineId") && filterItemInfo.getCompareValue() != null && ((Set)filterItemInfo.getCompareValue()).size() > 0) {
                        this.prmptProductLine.setValue((Object)this.getProductLine(((Set)filterItemInfo.getCompareValue()).toArray()));
                    }
                    if (!filterItemInfo.getPropertyName().equals("showType")) continue;
                    this.cmbShowType.setSelectedItem((Object)SupplyMaterialShowTypeEnum.getEnum((Integer)filterItemInfo.getCompareValue()));
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private Object[] getWorkShop(Object[] workShopIDs) {
        if (this.workShopMap == null) {
            this.workShopMap = new HashMap();
        }
        Object[] workShops = new Object[workShopIDs.length];
        for (int i = 0; i < workShopIDs.length; ++i) {
            if (this.workShopMap.containsKey(workShopIDs[i])) {
                workShops[i] = this.workShopMap.get(workShopIDs[i]);
                continue;
            }
            try {
                AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)workShopIDs[i]))));
                if (adminOrgUnitInfo == null) continue;
                workShops[i] = adminOrgUnitInfo;
                this.workShopMap.put(adminOrgUnitInfo.getId().toString(), adminOrgUnitInfo);
                continue;
            }
            catch (EASBizException e) {
                this.handUIException(e);
                continue;
            }
            catch (BOSException e) {
                this.handUIException(e);
                continue;
            }
            catch (UuidException e) {
                this.handUIException(e);
            }
        }
        return workShops;
    }

    private Object[] getProductLine(Object[] productLineIDs) {
        if (this.productLineMap == null) {
            this.productLineMap = new HashMap();
        }
        Object[] productLines = new Object[productLineIDs.length];
        for (int i = 0; i < productLineIDs.length; ++i) {
            if (this.productLineMap.containsKey(productLineIDs[i])) {
                productLines[i] = this.productLineMap.get(productLineIDs[i]);
                continue;
            }
            try {
                ProductLineInfo productLineInfo = ProductLineFactory.getRemoteInstance().getProductLineInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)productLineIDs[i]))));
                if (productLineInfo == null || !productLineInfo.getStorageOrgUnit().getId().toString().equals(((StorageOrgUnitInfo)this.prmptStorageOrgUnit.getValue()).getId().toString())) continue;
                productLines[i] = productLineInfo;
                this.productLineMap.put(productLineInfo.getId().toString(), productLineInfo);
                continue;
            }
            catch (EASBizException e) {
                this.handUIException(e);
                continue;
            }
            catch (BOSException e) {
                this.handUIException(e);
                continue;
            }
            catch (UuidException e) {
                this.handUIException(e);
            }
        }
        return productLines;
    }
}

