/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.IRowType;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.PlanVersionSetFactory;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.planning.RefinedPurPlanDataTypeEnum;
import com.kingdee.eas.mm.planning.RefinedPurPlanFactory;
import com.kingdee.eas.mm.planning.SupplyMaterialCalculateScaleEnum;
import com.kingdee.eas.mm.planning.client.AbstractRefinedPurPlanEditUI;
import com.kingdee.eas.mm.planning.client.RefinedPurPlanFilterUI;
import com.kingdee.eas.mm.planning.client.SupplyBillListUI;
import com.kingdee.eas.mm.planning.client.SupplyMaterialCalculateUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class RefinedPurPlanEditUI
extends AbstractRefinedPurPlanEditUI {
    private static final Logger logger = CoreUIObject.getLogger(RefinedPurPlanEditUI.class);
    private CommonQueryDialog dialog;
    private RefinedPurPlanFilterUI refinedPurPlanFilterUI;
    private FilterInfo filterInfo;
    int originColCount = 0;
    private static final int ROW_COUNT_PER_GROUP = 10;
    private static final String TABLE_HEAD_TYPEENUM = "typeEnum";
    private static final String TABLE_HEAD_SUM = "sum";
    private static final String TABLE_HEAD_STORAGEORGUNITID = "storageOrgUnitId";
    private static final String TABLE_HEAD_MATERIALID = "materialId";
    private static final String TABLE_HEAD_UNITID = "unitId";
    private static final String TABLE_HEAD_SAFETYQTY = "safetyQty";
    private static final String TABLE_HEAD_CURSTOREQTY = "curStoreQty";
    private static final String RESOURCE_PATH = "com.kingdee.eas.mm.planning.RefinedPurPlanResource";
    private KDTEditAdapter refinedPurTableChange = null;
    private Map history = new HashMap();
    private Map precisionMap = new HashMap();

    public RefinedPurPlanEditUI() throws Exception {
        this.setButtonDefaultStyl(this.btnSave);
        this.setButtonDefaultStyl(this.btnEdit);
        this.setButtonDefaultStyl(this.btnQuery);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDTable getTableForCommon() {
        return this.kdtRefinedPur;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtRefinedPur.checkParsed();
        this.originColCount = this.kdtRefinedPur.getColumnCount();
        this.kdtRefinedPur.getHeadMergeManager().setMergeMode(3);
        this.kdtRefinedPur.getViewManager().freeze(-1, this.kdtRefinedPur.getColumn(TABLE_HEAD_TYPEENUM).getColumnIndex() + 1);
        Boolean isFilter = (Boolean)this.getUIContext().get("isFilter");
        if (isFilter != null && !isFilter.booleanValue()) {
            this.calculateResultList(this.getUIContext());
            return;
        }
        if (this.dialog == null) {
            this.initCommonQueryDialog();
            this.dialog.init();
            QuerySolutionInfo currSolution = this.dialog.getCurrentSolutionInfo();
            if (currSolution.isIsUserDefaultSolu() && currSolution.getEntityViewInfo() != null) {
                EntityViewInfo entityViewInfo = new EntityViewInfo(currSolution.getEntityViewInfo());
                this.filterInfo = entityViewInfo.getFilter();
                this.getRefinedPurPlan(this.filterInfo);
            } else if (this.dialog.show()) {
                RefinedPurPlanFilterUI refinedPurPlanFilterUI = (RefinedPurPlanFilterUI)this.dialog.getUserPanel(0);
                this.filterInfo = refinedPurPlanFilterUI.getFilterInfo();
                this.getRefinedPurPlan(this.filterInfo);
            } else {
                this.tHelper.setDialog(this.dialog);
                SysUtil.abort();
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPutIn.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_immediacyputin", (Locale)this.getLocale()));
        this.menuItemPutIn.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_immediacyputin", (Locale)this.getLocale()));
        this.btnOrderAdvise.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_billpropose", (Locale)this.getLocale()));
        this.menuItemOrderAdvise.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_billpropose", (Locale)this.getLocale()));
    }

    protected void initListener() {
        super.initListener();
        if (this.refinedPurTableChange == null) {
            this.refinedPurTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        RefinedPurPlanEditUI.this.kdtRefinedPur_Changed(e);
                    }
                    catch (Exception exc) {
                        RefinedPurPlanEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtRefinedPur.addKDTEditListener((KDTEditListener)this.refinedPurTableChange);
    }

    private void kdtRefinedPur_Changed(KDTEditEvent e) throws Exception {
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue);
        if (this.getSortCountPerGroup(e.getRowIndex()) == 5 && isDiffrent && e.getColIndex() >= this.originColCount && newValue != null) {
            ICell curCell = this.kdtRefinedPur.getRow(e.getRowIndex()).getCell(TABLE_HEAD_SUM);
            if (oldValue == null) {
                oldValue = new BigDecimal(0);
            }
            if (newValue == null) {
                newValue = new BigDecimal(0);
            }
            BigDecimal changeQty = ((BigDecimal)newValue).subtract((BigDecimal)oldValue);
            BigDecimal sumQty = (BigDecimal)curCell.getValue();
            curCell.setValue((Object)sumQty.add(changeQty));
            if (((BigDecimal)newValue).compareTo(new BigDecimal(0)) > 0) {
                int firRowIndex = this.getGroupCount(e.getRowIndex());
                String materialId = (String)this.kdtRefinedPur.getRow(firRowIndex).getCell(TABLE_HEAD_MATERIALID).getValue();
                String strRequireDate = this.kdtRefinedPur.getColumn(e.getColIndex()).getKey();
                ICell oldAdvisePurDateCell = this.kdtRefinedPur.getRow(firRowIndex + 7).getCell(e.getColIndex());
                String oldAdvisePurDate = (String)oldAdvisePurDateCell.getValue();
                if (oldAdvisePurDate == null || oldAdvisePurDate.equals("")) {
                    MaterialPlanInfo materialPlanInfo = (MaterialPlanInfo)RefinedPurPlanFactory.getRemoteInstance().getMaterialPlan(materialId);
                    if (materialPlanInfo != null) {
                        int recevingLeadTime = materialPlanInfo.getRecevingLeadTime();
                        int forwardProcessTime = materialPlanInfo.getForwardProcessTime();
                        int produceLeadTime = materialPlanInfo.getProduceLeadTime();
                        int backwardProcessTime = materialPlanInfo.getBackwardProcessTime();
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(CtrlFormatUtilities.getDateFormat().parse(strRequireDate));
                        cal.add(5, -recevingLeadTime);
                        cal.add(5, -forwardProcessTime);
                        cal.add(5, -produceLeadTime);
                        cal.add(5, -backwardProcessTime);
                        Date advisePurDate = cal.getTime();
                        oldAdvisePurDateCell.setValue((Object)CtrlFormatUtilities.getDateFormat().format(advisePurDate));
                    } else {
                        oldAdvisePurDateCell.setValue((Object)strRequireDate);
                    }
                }
            } else {
                int firRowIndex = this.getGroupCount(e.getRowIndex());
                ICell advisePurQtyCell = this.kdtRefinedPur.getRow(firRowIndex + 6).getCell(e.getColIndex());
                ICell oldAdvisePurDateCell = this.kdtRefinedPur.getRow(firRowIndex + 7).getCell(e.getColIndex());
                BigDecimal advisePurQty = (BigDecimal)advisePurQtyCell.getValue();
                if (advisePurQty.compareTo(new BigDecimal(0)) == 0) {
                    oldAdvisePurDateCell.setValue(null);
                }
            }
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        this.dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            this.dialog.setOwner((Component)((Object)this));
        }
        this.dialog.setUiObject((IUIObject)this);
        this.dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        this.dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.base.message", "MsgQuery"));
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}-{1}");
        String title = format.format(new Object[]{this.getUITitle(), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter")});
        this.dialog.setTitle(title);
        try {
            this.refinedPurPlanFilterUI = new RefinedPurPlanFilterUI();
            this.refinedPurPlanFilterUI.onLoad();
            this.dialog.setShowFilter(false);
            this.dialog.setShowSorter(false);
            this.dialog.setHeight(435);
            this.dialog.setWidth(580);
            this.dialog.addUserPanel((KDPanel)this.refinedPurPlanFilterUI);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return this.dialog;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.initCommonQueryDialog();
        this.refinedPurPlanFilterUI.getUIContext().clear();
        this.refinedPurPlanFilterUI.getUIContext().putAll(this.getUIContext());
        this.refinedPurPlanFilterUI.getUIContext().put("HISTORY", this.history);
        if (this.dialog.show()) {
            RefinedPurPlanFilterUI refinedPurPlanFilterUI = (RefinedPurPlanFilterUI)this.dialog.getUserPanel(0);
            this.filterInfo = refinedPurPlanFilterUI.getFilterInfo();
            this.getRefinedPurPlan(this.filterInfo);
        } else {
            this.tHelper.setDialog(this.dialog);
            SysUtil.abort();
        }
    }

    private void getRefinedPurPlan(FilterInfo filterInfo) throws BOSException {
        try {
            HashMap mapDatas;
            this.btnEdit.setEnabled(true);
            this.btnSave.setEnabled(false);
            this.menuItemEdit.setEnabled(true);
            this.menuItemSave.setEnabled(false);
            this.kdtRefinedPur.checkParsed();
            this.kdtRefinedPur.removeRows();
            this.removeDynamicColumn();
            this.kdtRefinedPur.getHeadMergeManager().setMergeMode(3);
            for (FilterItemInfo filterItem : filterInfo.getFilterItems()) {
                if ("planVersionId".equals(filterItem.getPropertyName())) {
                    this.prmptPlanVersion.setValue((Object)PlanVersionSetFactory.getRemoteInstance().getPlanVersionSetInfo((IObjectPK)new ObjectUuidPK(filterItem.getCompareValue().toString())));
                    this.history.put("VERSION", this.prmptPlanVersion.getValue());
                }
                if (!TABLE_HEAD_STORAGEORGUNITID.equals(filterItem.getPropertyName())) continue;
                this.prmptStorageOrgUnit.setValue((Object)StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(filterItem.getCompareValue().toString())));
                this.history.put("STORAGE", this.prmptStorageOrgUnit.getValue());
            }
            ArrayList headerList = RefinedPurPlanFactory.getRemoteInstance().getMaxHeaderList(filterInfo);
            if (!headerList.isEmpty()) {
                this.kdtRefinedPur.addColumns(headerList.size());
                for (int i = 0; i < headerList.size(); ++i) {
                    IColumn curCol = this.kdtRefinedPur.getColumn(this.originColCount + i);
                    curCol.setKey((String)headerList.get(i));
                    this.kdtRefinedPur.getHeadRow(0).getCell(this.originColCount + i).setValue((Object)((String)headerList.get(i)));
                    this.kdtRefinedPur.getHeadRow(0).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                }
                IColumn sumCol = this.kdtRefinedPur.addColumn();
                sumCol.setKey(TABLE_HEAD_SUM);
                this.kdtRefinedPur.getHeadRow(0).getCell(sumCol.getColumnIndex()).setValue((Object)this.getResourceMsg("sumRowlbl"));
                this.kdtRefinedPur.getHeadRow(0).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                this.kdtRefinedPur.getColumn(TABLE_HEAD_SUM).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.kdtRefinedPur.getColumn(TABLE_HEAD_SUM).getStyleAttributes().setBackground(new Color(252, 251, 223));
            }
            if (!(mapDatas = RefinedPurPlanFactory.getRemoteInstance().getRefinedPurPlanGroup(filterInfo)).isEmpty()) {
                Set rowSet = mapDatas.keySet();
                Iterator iterator = rowSet.iterator();
                int groupFirRow = 0;
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    HashMap rPlanMap = (HashMap)mapDatas.get(key);
                    ArrayList entryList = (ArrayList)rPlanMap.get("entryList");
                    int perGroup = this.rowCountPergroup();
                    this.kdtRefinedPur.addRows(perGroup);
                    IRow row = this.kdtRefinedPur.getRow(groupFirRow);
                    String materialId = null;
                    String unitId = null;
                    int precision = 0;
                    for (int i = 0; i < this.originColCount - 1; ++i) {
                        Object curValue;
                        String columnKey = this.kdtRefinedPur.getColumn(i).getKey();
                        if (columnKey.equals(TABLE_HEAD_MATERIALID)) {
                            materialId = (String)rPlanMap.get(columnKey);
                        }
                        if (columnKey.equals(TABLE_HEAD_UNITID)) {
                            unitId = (String)rPlanMap.get(columnKey);
                        }
                        if ((curValue = rPlanMap.get(columnKey)) instanceof BigDecimal) {
                            BigDecimal qty = (BigDecimal)curValue;
                            String idkey = materialId + unitId;
                            KDFormattedTextField formatField = new KDFormattedTextField();
                            formatField.setHorizontalAlignment(4);
                            formatField.setDataType(1);
                            formatField.setNegatived(false);
                            formatField.setPrecision(precision);
                            formatField.setMaximumValue((Comparable)new BigDecimal("1.0E13"));
                            KDTDefaultCellEditor formatEditor = new KDTDefaultCellEditor((JTextField)formatField);
                            row.getCell(i).setEditor((ICellEditor)formatEditor);
                            row.getCell(i).setEditor((ICellEditor)formatEditor);
                            if (this.precisionMap.containsKey(idkey)) {
                                precision = (Integer)this.precisionMap.get(idkey);
                            } else {
                                int preci;
                                precision = preci = MultiMeasureUnitFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext()).getQtyPrecision(materialId, unitId);
                                this.precisionMap.put(idkey, new Integer(preci));
                            }
                            row.getCell(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                            if (precision == 0) {
                                row.getCell(i).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
                            } else if (qty.doubleValue() == 0.0) {
                                row.getCell(i).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
                            } else {
                                row.getCell(i).getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)precision));
                            }
                            row.getCell(i).setValue((Object)qty);
                        } else {
                            row.getCell(i).setValue(curValue);
                        }
                        this.kdtRefinedPur.getMergeManager().mergeBlock(groupFirRow, i, groupFirRow + perGroup - 1, i);
                    }
                    for (int j = 0; j < perGroup; ++j) {
                        IRow typeRow = this.kdtRefinedPur.getRow(groupFirRow + j);
                        typeRow.getStyleAttributes().setLocked(true);
                        typeRow.getCell(TABLE_HEAD_TYPEENUM).setValue((Object)RefinedPurPlanDataTypeEnum.getEnum(j).getAlias());
                        if (j < 8) continue;
                        typeRow.getStyleAttributes().setHided(true);
                    }
                    for (int dIndex = 0; dIndex < entryList.size(); ++dIndex) {
                        ArrayList entryDataList = (ArrayList)entryList.get(dIndex);
                        String refinedPurDate = (String)entryDataList.get(10);
                        int isPutIn = (Integer)entryDataList.get(8);
                        for (int rIndex = groupFirRow; rIndex < groupFirRow + perGroup; ++rIndex) {
                            Object curValue;
                            int sortCountPerGroup = this.getSortCountPerGroup(rIndex);
                            IRow typeRow = this.kdtRefinedPur.getRow(rIndex);
                            if (this.getSortCountPerGroup(rIndex) == 0) {
                                materialId = (String)typeRow.getCell(TABLE_HEAD_MATERIALID).getValue();
                                unitId = (String)typeRow.getCell(TABLE_HEAD_UNITID).getValue();
                                String idkey = materialId + unitId;
                                if (this.precisionMap.containsKey(idkey)) {
                                    precision = (Integer)this.precisionMap.get(idkey);
                                }
                            }
                            if ((curValue = entryDataList.get(sortCountPerGroup)) instanceof BigDecimal) {
                                BigDecimal sumQty;
                                KDFormattedTextField formatField = new KDFormattedTextField();
                                formatField.setHorizontalAlignment(4);
                                formatField.setDataType(1);
                                formatField.setNegatived(false);
                                formatField.setPrecision(precision);
                                formatField.setMaximumValue((Comparable)new BigDecimal("1.0E13"));
                                KDTDefaultCellEditor formatEditor = new KDTDefaultCellEditor((JTextField)formatField);
                                typeRow.getCell(refinedPurDate).setEditor((ICellEditor)formatEditor);
                                BigDecimal qty = (BigDecimal)curValue;
                                qty = qty.setScale(precision, 4);
                                typeRow.getCell(refinedPurDate).setValue((Object)qty);
                                typeRow.getCell(refinedPurDate).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                                if (precision == 0) {
                                    typeRow.getCell(refinedPurDate).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
                                } else if (qty.doubleValue() == 0.0) {
                                    typeRow.getCell(refinedPurDate).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
                                } else {
                                    typeRow.getCell(refinedPurDate).getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)precision));
                                }
                                if (this.getSortCountPerGroup(rIndex) == 0) {
                                    KDFormattedTextField sumFormatField = new KDFormattedTextField();
                                    sumFormatField.setHorizontalAlignment(4);
                                    sumFormatField.setDataType(1);
                                    sumFormatField.setNegatived(false);
                                    sumFormatField.setPrecision(precision);
                                    KDTDefaultCellEditor sumFormatEditor = new KDTDefaultCellEditor((JTextField)sumFormatField);
                                    typeRow.getCell(TABLE_HEAD_SUM).setEditor((ICellEditor)sumFormatEditor);
                                }
                                sumQty = (sumQty = (BigDecimal)typeRow.getCell(TABLE_HEAD_SUM).getValue()) == null ? qty : sumQty.add(qty);
                                typeRow.getCell(TABLE_HEAD_SUM).setValue((Object)sumQty);
                                if (precision == 0) {
                                    typeRow.getCell(TABLE_HEAD_SUM).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
                                } else if (sumQty.doubleValue() == 0.0) {
                                    typeRow.getCell(TABLE_HEAD_SUM).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
                                } else {
                                    typeRow.getCell(TABLE_HEAD_SUM).getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)precision));
                                }
                            } else {
                                typeRow.getCell(refinedPurDate).setValue(curValue);
                            }
                            if (sortCountPerGroup != 5) continue;
                            if (isPutIn == 1) {
                                typeRow.getCell(refinedPurDate).getStyleAttributes().setBackground(Color.GREEN);
                                continue;
                            }
                            typeRow.getCell(refinedPurDate).getStyleAttributes().setBackground(Color.WHITE);
                        }
                    }
                    groupFirRow += perGroup;
                }
                Font font = this.kdtRefinedPur.getFont();
                FontMetrics metrices = this.kdtRefinedPur.getFontMetrics(font);
                int width = SwingUtilities.computeStringWidth(metrices, RefinedPurPlanDataTypeEnum.initSupplyQty.getAlias());
                int margin = 10;
                this.kdtRefinedPur.getColumn(TABLE_HEAD_TYPEENUM).setWidth(width + margin);
                this.kdtRefinedPur.getViewManager().freeze(-1, this.kdtRefinedPur.getColumn(TABLE_HEAD_TYPEENUM).getColumnIndex() + 1);
                this.kdtRefinedPur.repaint();
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private int rowCountPergroup() {
        return 10;
    }

    private int getGroupCount(int rowIndex) {
        return new BigDecimal(rowIndex).divide(new BigDecimal(this.rowCountPergroup()), 1).multiply(new BigDecimal(this.rowCountPergroup())).intValue();
    }

    private int getSortCountPerGroup(int rowIndex) {
        return rowIndex % this.rowCountPergroup();
    }

    private void removeDynamicColumn() {
        if (this.originColCount > 0) {
            for (int i = this.kdtRefinedPur.getColumnCount() - 1; i >= this.originColCount; --i) {
                this.kdtRefinedPur.removeColumn(i);
            }
        }
    }

    private void setBtnSaveEnabled(boolean isEnabled) {
        if (isEnabled) {
            this.btnSave.setEnabled(true);
            this.btnEdit.setEnabled(false);
            this.btnPutIn.setEnabled(false);
            this.menuItemSave.setEnabled(true);
            this.menuItemEdit.setEnabled(false);
            this.menuItemPutIn.setEnabled(false);
        } else {
            this.btnSave.setEnabled(false);
            this.btnEdit.setEnabled(true);
            this.btnPutIn.setEnabled(true);
            this.menuItemSave.setEnabled(false);
            this.menuItemEdit.setEnabled(true);
            this.menuItemPutIn.setEnabled(true);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        try {
            for (int rowIndex = 0; rowIndex < this.kdtRefinedPur.getRowCount(); rowIndex += this.rowCountPergroup()) {
                IRow dataRow = this.kdtRefinedPur.getRow(rowIndex + 5);
                for (int colIndex = this.originColCount; colIndex < this.kdtRefinedPur.getColumnCount() - 1; ++colIndex) {
                    dataRow.getCell(colIndex).getStyleAttributes().setLocked(false);
                }
            }
            this.setOprtState("EDIT");
            this.pubFireVOChangeListener(this.getMutexID());
            this.setBtnSaveEnabled(true);
        }
        catch (Throwable t) {
            this.handUIException(t);
            this.setBtnSaveEnabled(false);
        }
    }

    private String getMutexID() {
        String planVersionId = null;
        Object storageOrgUnitId = null;
        if (this.filterInfo == null) {
            return null;
        }
        for (FilterItemInfo filterItem : this.filterInfo.getFilterItems()) {
            if (!"planVersionId".equals(filterItem.getPropertyName())) continue;
            planVersionId = (String)filterItem.getCompareValue();
        }
        return planVersionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        try {
            int rowIndex;
            ArrayList updateList = new ArrayList();
            for (rowIndex = 0; rowIndex < this.kdtRefinedPur.getRowCount(); rowIndex += this.rowCountPergroup()) {
                IRow dataRow = this.kdtRefinedPur.getRow(rowIndex + 5);
                for (int colIndex = this.originColCount; colIndex < this.kdtRefinedPur.getColumnCount() - 1; ++colIndex) {
                    dataRow.getCell(colIndex).getStyleAttributes().setLocked(true);
                }
            }
            for (rowIndex = 0; rowIndex < this.kdtRefinedPur.getRowCount(); rowIndex += this.rowCountPergroup()) {
                for (int colIndex = this.originColCount; colIndex < this.kdtRefinedPur.getColumnCount() - 1; ++colIndex) {
                    IRow planPurQtyRow = this.kdtRefinedPur.getRow(rowIndex + 5);
                    BigDecimal planPurQty = (BigDecimal)planPurQtyRow.getCell(colIndex).getValue();
                    IRow advisePurDateRow = this.kdtRefinedPur.getRow(rowIndex + 7);
                    String advisePurDate = (String)advisePurDateRow.getCell(colIndex).getValue();
                    IRow idRow = this.kdtRefinedPur.getRow(rowIndex + 9);
                    String id = (String)idRow.getCell(colIndex).getValue();
                    HashMap<String, Object> updateMap = new HashMap<String, Object>();
                    updateMap.put("id", id);
                    updateMap.put("planPurQty", planPurQty);
                    updateMap.put("advisePurDate", advisePurDate);
                    updateList.add(updateMap);
                }
            }
            if (!updateList.isEmpty()) {
                RefinedPurPlanFactory.getRemoteInstance().updateRefinedPurPlan(updateList);
                this.setBtnSaveEnabled(false);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        finally {
            try {
                this.setOprtState("RELEASEALL");
                this.pubFireVOChangeListener(this.getMutexID());
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    private String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RESOURCE_PATH, (String)key);
    }

    private String getResourceMsg(String key, String[] params) {
        return ResourceUtils.getMessage((String)RESOURCE_PATH, (String)key, (String[])params);
    }

    @Override
    public void actionSuppMateCal_actionPerformed(ActionEvent e) throws Exception {
        try {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"openModel", (Object)"frame");
            uiContext.put((Object)"from", (Object)new Boolean(false));
            uiContext.put((Object)"planVersion", (Object)((PlanVersionSetInfo)this.prmptPlanVersion.getValue()));
            uiContext.put((Object)"storageOrgUnit", (Object)((StorageOrgUnitInfo)this.prmptStorageOrgUnit.getValue()));
            uiContext.put((Object)"calculateScale", (Object)SupplyMaterialCalculateScaleEnum.finePur);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SupplyMaterialCalculateUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            if (uiWindow.getUIObject().getUIContext().get("ok") != null) {
                this.getRefinedPurPlan(this.filterInfo);
            }
            this.setBtnSaveEnabled(false);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void calculateResultList(Map uiContext) throws Exception {
        try {
            PlanVersionSetInfo planVersion = (PlanVersionSetInfo)uiContext.get("planVersion");
            StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)uiContext.get("storageOrgUnit");
            this.filterInfo = new FilterInfo();
            FilterItemCollection items = this.filterInfo.getFilterItems();
            items.add(new FilterItemInfo("planVersionId", (Object)planVersion.getId().toString(), CompareType.EQUALS));
            items.add(new FilterItemInfo(TABLE_HEAD_STORAGEORGUNITID, (Object)storageOrgUnit.getId().toString(), CompareType.EQUALS));
            this.getRefinedPurPlan(this.filterInfo);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void actionPutIn_actionPerformed(ActionEvent e) throws Exception {
        IRow planPurQtyRow;
        BigDecimal planPurQty;
        int colIndex;
        StringBuffer strNoPurchasingInfo = new StringBuffer();
        StringBuffer strQtyLarge = new StringBuffer();
        StringBuffer strPutInAlready = new StringBuffer();
        List invalidCols = null;
        boolean marked = false;
        CoreBaseCollection purRequestCols = new CoreBaseCollection();
        ArrayList refinedPurPlanList = new ArrayList();
        HashSet<String> materialSet = new HashSet<String>();
        HashMap invalidOjectMap = new HashMap();
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.prmptStorageOrgUnit.getValue();
        String storageOrgUnitId = storageOrgUnit.getId().toString();
        if (MMUtils.getCompanyInfo((String)storageOrgUnitId) == null) {
            MsgBox.showInfo((String)this.getResourceMsg("noPurchasingOrgUnit", new String[]{storageOrgUnit.getName()}));
            return;
        }
        for (int rowIndex = 0; rowIndex < this.kdtRefinedPur.getRowCount(); rowIndex += this.rowCountPergroup()) {
            IRow row = this.kdtRefinedPur.getRow(rowIndex);
            String materialId = (String)row.getCell(TABLE_HEAD_MATERIALID).getValue();
            for (int colIndex2 = this.originColCount; colIndex2 < this.kdtRefinedPur.getColumnCount() - 1; ++colIndex2) {
                if (!this.kdtRefinedPur.getSelectManager().isCellSelected(rowIndex + 5, colIndex2) || materialSet.contains(materialId)) continue;
                materialSet.add(materialId);
            }
        }
        if (materialSet.isEmpty()) {
            MsgBox.showInfo((String)this.getResourceMsg("noCellSelected"));
            return;
        }
        HashMap materialPurchasingInfoMap = this.getMaterialPurchasing(materialSet, storageOrgUnitId);
        HashMap materialPlanInfoMap = this.getMaterialPlan(materialSet, storageOrgUnitId);
        StorageOrgUnitInfo storageOrgUnitInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageOrgUnitId));
        IRowType irowtype = RowTypeFactory.getRemoteInstance();
        RowTypeInfo rowType = irowtype.getRowTypeInfo((IObjectPK)new ObjectStringPK("00000000-0000-0000-0000-0000000000017C7DC4A3"));
        block4: for (int rowIndex = 0; rowIndex < this.kdtRefinedPur.getRowCount(); rowIndex += this.rowCountPergroup()) {
            IRow row = this.kdtRefinedPur.getRow(rowIndex);
            String materialId = (String)row.getCell(TABLE_HEAD_MATERIALID).getValue();
            MaterialInfo materialInfo = this.getMaterialInfo(materialId);
            String strMaterial = materialInfo.getNumber() + "(" + materialInfo.getName() + ")";
            String unitId = (String)row.getCell(TABLE_HEAD_UNITID).getValue();
            MaterialPurchasingInfo materialPurchasingInfo = (MaterialPurchasingInfo)materialPurchasingInfoMap.get(materialId);
            for (colIndex = this.originColCount; colIndex < this.kdtRefinedPur.getColumnCount() - 1; ++colIndex) {
                marked = false;
                if (!this.kdtRefinedPur.getSelectManager().isCellSelected(rowIndex + 5, colIndex)) continue;
                if (materialPurchasingInfo == null) {
                    strNoPurchasingInfo.append(this.getResourceMsg("noPurchasingInfo", new String[]{strMaterial}) + "\n");
                    materialSet.remove(materialId);
                    continue block4;
                }
                if (invalidOjectMap.get(materialId) == null) {
                    invalidOjectMap.put(materialId, new ArrayList());
                    invalidCols = (ArrayList)invalidOjectMap.get(materialId);
                } else {
                    invalidCols = (ArrayList)invalidOjectMap.get(materialId);
                }
                String refinedPurDate = this.kdtRefinedPur.getColumn(colIndex).getKey();
                IRow isPutInRow = this.kdtRefinedPur.getRow(rowIndex + 8);
                Integer isPutIn = (Integer)isPutInRow.getCell(colIndex).getValue();
                if (isPutIn == 1) {
                    strPutInAlready.append(this.getResourceMsg("putInAlready", new String[]{strMaterial, refinedPurDate}) + "\n");
                }
                if ((planPurQty = (BigDecimal)(planPurQtyRow = this.kdtRefinedPur.getRow(rowIndex + 5)).getCell(colIndex).getValue()).compareTo(new BigDecimal(0)) <= 0 && !marked) {
                    invalidCols.add(new Integer(colIndex));
                    marked = true;
                }
                MultiMeasureUnitInfo multiUnifInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(materialId, unitId);
                BigDecimal baseConvsRate = multiUnifInfo.getBaseConvsRate();
                MultiMeasureUnitInfo purMultiUnifInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(materialId, materialPurchasingInfo.getUnit().getId().toString());
                BigDecimal purBaseConvsRate = purMultiUnifInfo.getBaseConvsRate();
                int precision = multiUnifInfo.getQtyPrecision();
                BigDecimal baseExchangeRate = baseConvsRate.divide(purBaseConvsRate, precision, 4);
                BigDecimal qty = planPurQty.multiply(baseExchangeRate);
                BigDecimal baseQty = planPurQty.multiply(baseConvsRate);
                MeasureUnitInfo assistUnit = materialInfo.getAssistUnit();
                BigDecimal assistQty = null;
                if (assistUnit != null) {
                    String assistUnitId = assistUnit.getId().toString();
                    MultiMeasureUnitInfo assistMultiUnifInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(materialId, assistUnitId);
                    BigDecimal assistBaseConvsRate = assistMultiUnifInfo.getBaseConvsRate();
                    int assistPrecision = assistMultiUnifInfo.getQtyPrecision();
                    assistQty = baseQty.divide(assistBaseConvsRate, assistPrecision, 4);
                }
                if (qty.compareTo(new BigDecimal("1.0E12")) < 0 && (baseQty == null || baseQty.compareTo(new BigDecimal("1.0E12")) < 0) && (assistQty == null || assistQty.compareTo(new BigDecimal("1.0E12")) < 0)) continue;
                strQtyLarge.append(this.getResourceMsg("qtyLarge", new String[]{strMaterial, refinedPurDate}) + "\n");
                if (marked) continue;
                invalidCols.add(new Integer(colIndex));
                marked = true;
            }
        }
        if (materialSet.size() > 0 && strNoPurchasingInfo.length() > 0) {
            if (!MsgBox.isYes((int)MsgBox.showConfirm2New((Component)((Object)this), (String)(strNoPurchasingInfo.toString() + this.getResourceMsg("continue"))))) {
                return;
            }
        } else if (strNoPurchasingInfo.length() > 0) {
            MsgBox.showInfo((String)(strNoPurchasingInfo.toString() + this.getResourceMsg("selectAgain")));
            return;
        }
        boolean redo = false;
        if (strPutInAlready.length() > 0 && MsgBox.isYes((int)MsgBox.showConfirm2New((Component)((Object)this), (String)(strPutInAlready.toString() + this.getResourceMsg("redo"))))) {
            redo = true;
        }
        if (strQtyLarge.length() > 0 && !MsgBox.isYes((int)MsgBox.showConfirm2New((Component)((Object)this), (String)(strQtyLarge.toString() + this.getResourceMsg("continue"))))) {
            return;
        }
        for (int rowIndex = 0; rowIndex < this.kdtRefinedPur.getRowCount(); rowIndex += this.rowCountPergroup()) {
            IRow row = this.kdtRefinedPur.getRow(rowIndex);
            String materialId = (String)row.getCell(TABLE_HEAD_MATERIALID).getValue();
            if (!materialSet.contains(materialId) || invalidOjectMap.get(materialId) == null) continue;
            invalidCols = (List)invalidOjectMap.get(materialId);
            String unitId = (String)row.getCell(TABLE_HEAD_UNITID).getValue();
            MaterialPurchasingInfo materialPurchasingInfo = (MaterialPurchasingInfo)materialPurchasingInfoMap.get(materialId);
            MaterialPlanInfo materialPlanInfo = (MaterialPlanInfo)materialPlanInfoMap.get(materialId);
            for (colIndex = this.originColCount; colIndex < this.kdtRefinedPur.getColumnCount() - 1 && !invalidCols.contains(new Integer(colIndex)); ++colIndex) {
                IRow isPutInRow;
                Integer isPutIn;
                if (!this.kdtRefinedPur.getSelectManager().isCellSelected(rowIndex + 5, colIndex) || (isPutIn = (Integer)(isPutInRow = this.kdtRefinedPur.getRow(rowIndex + 8)).getCell(colIndex).getValue()) == 1 && !redo) continue;
                String refinedPurDate = this.kdtRefinedPur.getColumn(colIndex).getKey();
                planPurQtyRow = this.kdtRefinedPur.getRow(rowIndex + 5);
                planPurQty = (BigDecimal)planPurQtyRow.getCell(colIndex).getValue();
                IRow advisePurDateRow = this.kdtRefinedPur.getRow(rowIndex + 7);
                String advisePurDate = (String)advisePurDateRow.getCell(colIndex).getValue();
                IRow idRow = this.kdtRefinedPur.getRow(rowIndex + 9);
                String id = (String)idRow.getCell(colIndex).getValue();
                PurRequestInfo purRequestInfo = new PurRequestInfo();
                PurRequestEntryInfo purRequestEntryInfo = new PurRequestEntryInfo();
                purRequestEntryInfo.setParent(purRequestInfo);
                ObjectUuidPK bizTypePK = new ObjectUuidPK("d8e80652-0106-1000-e000-04c5c0a812202407435C");
                purRequestInfo.setBizType(BizTypeFactory.getRemoteInstance().getBizTypeInfo((IObjectPK)bizTypePK));
                ObjectUuidPK billTypePK = new ObjectUuidPK("510b6503-0105-1000-e000-0107c0a812fd463ED552");
                purRequestInfo.setBillType(BillTypeFactory.getRemoteInstance().getBillTypeInfo((IObjectPK)billTypePK));
                ObjectUuidPK sourceBillTypePK = new ObjectUuidPK("OC9kwQEhEADgAAAbfwAAAUY+1VI=");
                purRequestInfo.setSourceBillType(BillTypeFactory.getRemoteInstance().getBillTypeInfo((IObjectPK)sourceBillTypePK));
                CompanyOrgUnitInfo companyOrgUnit = SCMClientUtils.getCompanyInfo((BOSUuid)storageOrgUnitInfo.getId());
                purRequestInfo.setCompanyOrgUnit(companyOrgUnit);
                purRequestInfo.setPerson(SysContext.getSysContext().getCurrentUserInfo().getPerson());
                purRequestInfo.setBizDate(new Date());
                purRequestInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                purRequestEntryInfo.setRowType(rowType);
                purRequestEntryInfo.setDestinationType(rowType.getDestinationType());
                StorageOrgUnitInfo currStorageOrgUnitInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_RefinedPurPlan_putIn");
                purRequestEntryInfo.setStorageOrgUnit(currStorageOrgUnitInfo);
                purRequestEntryInfo.setReceivedOrgUnit(currStorageOrgUnitInfo);
                purRequestEntryInfo.setPurchaseOrgUnit(MMUtils.getCompanyInfo((String)currStorageOrgUnitInfo.getId().toString()));
                MaterialInfo materialInfo = this.getMaterialInfo(materialId);
                purRequestEntryInfo.setMaterial(materialInfo);
                purRequestEntryInfo.setMaterialName(materialInfo.getName());
                purRequestEntryInfo.setUnit(materialPurchasingInfo.getUnit());
                purRequestEntryInfo.setBaseUnit(materialInfo.getBaseUnit());
                MeasureUnitInfo assistUnit = materialInfo.getAssistUnit();
                purRequestEntryInfo.setAssistUnit(assistUnit);
                MultiMeasureUnitInfo multiUnifInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(materialId, unitId);
                BigDecimal baseConvsRate = multiUnifInfo.getBaseConvsRate();
                MultiMeasureUnitInfo purMultiUnifInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(materialId, materialPurchasingInfo.getUnit().getId().toString());
                BigDecimal purBaseConvsRate = purMultiUnifInfo.getBaseConvsRate();
                int precision = multiUnifInfo.getQtyPrecision();
                BigDecimal baseExchangeRate = baseConvsRate.divide(purBaseConvsRate, precision, 4);
                BigDecimal qty = planPurQty.multiply(baseExchangeRate);
                BigDecimal baseQty = planPurQty.multiply(baseConvsRate);
                purRequestEntryInfo.setQty(qty);
                purRequestEntryInfo.setRequestQty(qty);
                purRequestEntryInfo.setBaseQty(baseQty);
                if (assistUnit != null) {
                    String assistUnitId = assistUnit.getId().toString();
                    MultiMeasureUnitInfo assistMultiUnifInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(materialId, assistUnitId);
                    BigDecimal assistBaseConvsRate = assistMultiUnifInfo.getBaseConvsRate();
                    int assistPrecision = assistMultiUnifInfo.getQtyPrecision();
                    BigDecimal assistQty = baseQty.divide(assistBaseConvsRate, assistPrecision, 4);
                    purRequestEntryInfo.setAssistQty(assistQty);
                }
                purRequestEntryInfo.setRequirementDate(CtrlFormatUtilities.getDateFormat().parse(refinedPurDate));
                purRequestEntryInfo.setProposePurchaseDate(CtrlFormatUtilities.getDateFormat().parse(advisePurDate));
                if (materialPlanInfo != null) {
                    int forwardProcessTime = materialPlanInfo.getForwardProcessTime();
                    int produceLeadTime = materialPlanInfo.getProduceLeadTime();
                    int backwardProcessTime = materialPlanInfo.getBackwardProcessTime();
                    Calendar curCal = Calendar.getInstance();
                    curCal.setTime(CtrlFormatUtilities.getDateFormat().parse(advisePurDate));
                    curCal.add(5, forwardProcessTime);
                    curCal.add(5, produceLeadTime);
                    curCal.add(5, backwardProcessTime);
                    purRequestEntryInfo.setProposeDeliveryDate(curCal.getTime());
                } else {
                    purRequestEntryInfo.setProposeDeliveryDate(CtrlFormatUtilities.getDateFormat().parse(advisePurDate));
                }
                purRequestInfo.getEntries().add(purRequestEntryInfo);
                ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                String number = codingRuleManager.getNumber((IObjectValue)new PurRequestInfo(), companyOrgUnit.getId().toString());
                purRequestInfo.setNumber(number);
                purRequestEntryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
                purRequestCols.add((CoreBaseInfo)purRequestInfo);
                HashMap<String, String> updateMap = new HashMap<String, String>();
                updateMap.put("id", id);
                refinedPurPlanList.add(updateMap);
            }
        }
        try {
            if (purRequestCols.isEmpty()) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResourceMsg("selectAgain"));
                return;
            }
            RefinedPurPlanFactory.getRemoteInstance().batchPutIn(purRequestCols, refinedPurPlanList);
            this.getRefinedPurPlan(this.filterInfo);
            this.setMessageText(this.getResourceMsg("success"));
            this.showMessage();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private HashMap getMaterialPlan(Set materialIds, String storageOrgUnitId) throws BOSException, EASBizException {
        HashMap<String, MaterialPlanInfo> materialPlanInfoMap = new HashMap<String, MaterialPlanInfo>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIds, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        entityViewInfo.setSelector(selectorItemCollection);
        MaterialPlanCollection materialPlanCollection = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(entityViewInfo);
        if (materialPlanCollection != null) {
            for (int i = 0; i < materialPlanCollection.size(); ++i) {
                MaterialPlanInfo materialPlanInfo = materialPlanCollection.get(i);
                String materialId = materialPlanInfo.getMaterial().getId().toString();
                if (materialPlanInfoMap.containsKey(materialId)) continue;
                materialPlanInfoMap.put(materialId, materialPlanInfo);
            }
        }
        return materialPlanInfoMap;
    }

    private HashMap getMaterialPurchasing(Set materialIds, String storageOrgUnitId) throws BOSException, EASBizException {
        HashMap<String, MaterialPurchasingInfo> materialPurchasingInfoMap = new HashMap<String, MaterialPurchasingInfo>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIds, CompareType.INCLUDE));
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = MMUtils.getCompanyInfo((String)storageOrgUnitId);
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)purchaseOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("unit.id"));
        selectorItemCollection.add(new SelectorItemInfo("unit.number"));
        selectorItemCollection.add(new SelectorItemInfo("unit.name"));
        entityViewInfo.setSelector(selectorItemCollection);
        MaterialPurchasingCollection materialPurchasingCollection = MaterialPurchasingFactory.getRemoteInstance().getMaterialPurchasingCollection(entityViewInfo);
        if (materialPurchasingCollection != null) {
            for (int i = 0; i < materialPurchasingCollection.size(); ++i) {
                MaterialPurchasingInfo materialPurchasingInfo = materialPurchasingCollection.get(i);
                String materialId = materialPurchasingInfo.getMaterial().getId().toString();
                if (materialPurchasingInfoMap.containsKey(materialId)) continue;
                materialPurchasingInfoMap.put(materialId, materialPurchasingInfo);
            }
        }
        return materialPurchasingInfoMap;
    }

    @Override
    public void actionPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPreview_actionPerformed(e);
        this.preparePrintPage(this.getTableForCommon());
        this.getTableForCommon().getPrintManager().printPreview();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.getTableForCommon());
        this.getTableForCommon().getPrintManager().print();
    }

    @Override
    public void actionOrderAdviseQuery_actionPerformed(ActionEvent e) throws Exception {
        try {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"openModel", (Object)"frame");
            uiContext.put((Object)"planVersion", (Object)((PlanVersionSetInfo)this.prmptPlanVersion.getValue()));
            uiContext.put((Object)"storageOrgUnit", (Object)((StorageOrgUnitInfo)this.prmptStorageOrgUnit.getValue()));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(SupplyBillListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected String getOnloadPermItemName() {
        return "mm_RefinedPurPlan_view";
    }

    public boolean destroyWindow() {
        try {
            this.setOprtState("RELEASEALL");
            this.pubFireVOChangeListener(this.getMutexID());
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        return super.destroyWindow();
    }

    private MaterialInfo getMaterialInfo(String materialId) throws Exception {
        MaterialInfo materialInfo = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("baseUnit.id"));
        selector.add(new SelectorItemInfo("baseUnit.number"));
        selector.add(new SelectorItemInfo("baseUnit.name"));
        materialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(materialId), selector);
        return materialInfo;
    }
}

