/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.basedata.PlanVersionSetFactory;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.planning.client.AbstractRefinedPurPlanFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class RefinedPurPlanFilterUI
extends AbstractRefinedPurPlanFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RefinedPurPlanFilterUI.class);
    protected F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 1);
    private static final String RESOURCE_PATH = "com.kingdee.eas.mm.planning.ProductLineSupplyMaterialPlanResource";

    public void clear() {
        super.clear();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmptStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_RefinedPurPlan_view");
        StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_RefinedPurPlan_view");
        this.prmptStorageOrgUnit.setValue((Object)storageOrgInfo);
        this.prmptPlanVersion.setValue(null);
        HashMap history = (HashMap)this.getUIContext().get("HISTORY");
        if (history != null) {
            Object storage = history.get("STORAGE");
            Object version = history.get("VERSION");
            if (storageOrgInfo != null && storage != null && storageOrgInfo.getId().toString().equalsIgnoreCase(((StorageOrgUnitInfo)storage).getId().toString())) {
                this.prmptPlanVersion.setValue(version);
            }
        }
        this.prmptMaterialFrom.setValue(null);
        this.prmptMaterialTo.setValue(null);
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo.getFilterItems().clear();
        FilterItemCollection items = this.filterInfo.getFilterItems();
        this.filterInfo.setMaskString(null);
        if (this.prmptPlanVersion.getValue() != null && this.prmptPlanVersion.getText() != null && this.prmptPlanVersion.getText().length() > 0) {
            items.add(new FilterItemInfo("planVersionId", (Object)((PlanVersionSetInfo)this.prmptPlanVersion.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmptStorageOrgUnit.getValue() != null && this.prmptStorageOrgUnit.getText() != null && this.prmptStorageOrgUnit.getText().length() > 0) {
            items.add(new FilterItemInfo("storageOrgUnitId", (Object)((StorageOrgUnitInfo)this.prmptStorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmptMaterialFrom.getText() != null && this.prmptMaterialFrom.getText().length() > 0) {
            items.add(new FilterItemInfo("materialFrom", (Object)this.prmptMaterialFrom.getText().toString().trim(), CompareType.GREATER_EQUALS));
        }
        if (this.prmptMaterialTo.getText() != null && this.prmptMaterialTo.getText().length() > 0) {
            items.add(new FilterItemInfo("materialTo", (Object)this.prmptMaterialTo.getText().toString().trim(), CompareType.LESS_EQUALS));
        }
        return this.filterInfo;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmptStorageOrgUnit;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmptStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_RefinedPurPlan_view");
        StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_RefinedPurPlan_view");
        this.prmptStorageOrgUnit.setValue((Object)storageOrgInfo);
        if (storageOrgInfo != null) {
            this.initF7Material(storageOrgInfo);
            this.initPlanVersionSetF7(storageOrgInfo);
        }
    }

    private String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RESOURCE_PATH, (String)key);
    }

    @Override
    protected void prmptStorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        StorageOrgUnitInfo oldObject = (StorageOrgUnitInfo)e.getOldValue();
        StorageOrgUnitInfo newObject = (StorageOrgUnitInfo)e.getNewValue();
        if (null != newObject && !newObject.equals((Object)oldObject)) {
            this.initF7Material(newObject);
            this.initPlanVersionSetF7(newObject);
        }
    }

    private void initF7Material(StorageOrgUnitInfo orgInfo) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        String materialPlanQuery = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.prmptMaterialFrom.setQueryInfo(materialPlanQuery);
        this.prmptMaterialTo.setQueryInfo(materialPlanQuery);
        this.f7Manager.registerBizMaterialF7(this.prmptMaterialFrom, null, materialPlanQuery, (OrgUnitInfo)orgInfo, false);
        this.f7Manager.registerBizMaterialF7(this.prmptMaterialTo, null, materialPlanQuery, (OrgUnitInfo)orgInfo, false);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo mask0 = new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS);
        FilterItemInfo mask1 = new FilterItemInfo("plan.status", (Object)new Integer(1), CompareType.EQUALS);
        FilterItemInfo mask2 = new FilterItemInfo("plan.materialAttr", (Object)new Integer(10050), CompareType.EQUALS);
        FilterItemInfo mask3 = new FilterItemInfo("plan.issMode", (Object)new Integer(11050), CompareType.EQUALS);
        FilterItemInfo mask4 = new FilterItemInfo("plan.materialAttr", (Object)new Integer(10040), CompareType.EQUALS);
        filterInfo.getFilterItems().add(mask0);
        filterInfo.getFilterItems().add(mask1);
        filterInfo.getFilterItems().add(mask2);
        filterInfo.getFilterItems().add(mask3);
        filterInfo.getFilterItems().add(mask4);
        filterInfo.setMaskString("#0 and #1 and (#2 and #3 or #4)");
        entityViewInfo.setFilter(filterInfo);
        this.prmptMaterialFrom.setEntityViewInfo(entityViewInfo);
        this.prmptMaterialTo.setEntityViewInfo(entityViewInfo);
        this.prmptMaterialFrom.setValue(null);
        this.prmptMaterialTo.setValue(null);
    }

    private void initPlanVersionSetF7(StorageOrgUnitInfo storageOrgInfo) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("planType", (Object)new Integer(30), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"902", CompareType.EQUALS));
        viewInfo.setFilter(filter);
        this.prmptPlanVersion.setEntityViewInfo(viewInfo);
    }

    public boolean verify() {
        boolean bRet = true;
        StringBuffer showInfo = new StringBuffer();
        if (this.prmptPlanVersion == null || this.prmptPlanVersion.getValue() == null) {
            showInfo.append(this.getResourceMsg("Msg_PlanVesionSetIsNotNull") + "\n");
            bRet = false;
        }
        if (this.prmptStorageOrgUnit == null || this.prmptStorageOrgUnit.getValue() == null) {
            showInfo.append(this.getResourceMsg("Msg_StorageOrgUnitIsNotNull") + "\n");
            bRet = false;
        }
        if (!bRet) {
            MsgBox.showInfo((String)showInfo.toString());
        }
        return bRet;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.prmptPlanVersion.setValue(null);
        this.prmptStorageOrgUnit.setValue(null);
        this.prmptMaterialFrom.setText(null);
        this.prmptMaterialTo.setText(null);
        try {
            FilterInfo filterInfo;
            if (entityViewInfo != null && (filterInfo = entityViewInfo.getFilter()).getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
                for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                    FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                    if (filterItemInfo.getPropertyName().equals("planVersionId")) {
                        this.prmptPlanVersion.setValue((Object)PlanVersionSetFactory.getRemoteInstance().getPlanVersionSetInfo((IObjectPK)new ObjectUuidPK(filterItemInfo.getCompareValue().toString())));
                    }
                    if (filterItemInfo.getPropertyName().equals("storageOrgUnitId")) {
                        this.prmptStorageOrgUnit.setValue((Object)StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(filterItemInfo.getCompareValue().toString())));
                    }
                    if (filterItemInfo.getPropertyName().equals("materialFrom")) {
                        this.prmptMaterialFrom.setText(filterItemInfo.getCompareValue().toString());
                    }
                    if (!filterItemInfo.getPropertyName().equals("materialTo")) continue;
                    this.prmptMaterialTo.setText(filterItemInfo.getCompareValue().toString());
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }
}

