/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.planning.IReqPlanSOImportFacade;
import com.kingdee.eas.mm.planning.ReqPlanSOImportFacadeFactory;
import com.kingdee.eas.mm.planning.client.AbstractReqPlanSOImportUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class ReqPlanSOImportUI
extends AbstractReqPlanSOImportUI {
    private static final long serialVersionUID = 309321539873558693L;
    private static final String REQPLAN_RESOURCE_FULLNAME = "com.kingdee.eas.mm.planning.client.RequirementPlanResource";
    private static final Logger logger = CoreUIObject.getLogger(ReqPlanSOImportUI.class);
    private F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), OrgType.Storage, 0);

    public ReqPlanSOImportUI() throws Exception {
        this.prmtStorageOrgUnit.setValue((Object)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)"mm_soimport_imp"));
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_soimport_imp");
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        this.initF7(storageOrgUnitInfo);
        Date d = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.pkOrderDateTo.setValue((Object)calendar.getTime());
        calendar.add(2, -1);
        this.pkOrderDateFrom.setValue((Object)calendar.getTime());
        this.setprmtBizTypeToFilter();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)REQPLAN_RESOURCE_FULLNAME, (String)"ImportSOErrorPrompt"));
            return;
        }
        Date d1 = (Date)this.pkOrderDateFrom.getValue();
        Date d2 = (Date)this.pkOrderDateTo.getValue();
        if (d1 != null && d2 != null && d1.after(d2)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)REQPLAN_RESOURCE_FULLNAME, (String)"SODateRangeError"));
            return;
        }
        String[] suIDs = null;
        String bizTypeStartID = null;
        String bizTypeEndID = null;
        String soStartID = null;
        String soEndID = null;
        Date dateStart = null;
        Date dateEnd = null;
        String mGroupStartID = null;
        String mGroupEndID = null;
        String mStartID = null;
        String mEndID = null;
        String plannerID = null;
        Object v = this.prmtStorageOrgUnit.getValue();
        if (v != null) {
            if (v instanceof DataBaseInfo) {
                suIDs = new String[]{((DataBaseInfo)v).getId().toString()};
            } else {
                Object[] vs = (Object[])v;
                if (vs.length == 0) {
                    suIDs = null;
                } else {
                    suIDs = new String[vs.length];
                    for (int i = 0; i < vs.length; ++i) {
                        suIDs[i] = ((DataBaseInfo)vs[i]).getId().toString();
                    }
                }
            }
        }
        if ((v = this.prmtBizTypeFrom.getValue()) != null) {
            bizTypeStartID = ((DataBaseInfo)v).getNumber();
        }
        if ((v = this.prmtBizTypeTo.getValue()) != null) {
            bizTypeEndID = ((DataBaseInfo)v).getNumber();
        }
        if ((v = this.prmtSaleOrderFrom.getValue()) != null) {
            soStartID = ((SaleOrderInfo)v).getNumber();
        }
        if ((v = this.prmtSaleOrderTo.getValue()) != null) {
            soEndID = ((SaleOrderInfo)v).getNumber();
        }
        if ((v = this.pkOrderDateFrom.getValue()) != null) {
            dateStart = (Date)v;
        }
        if ((v = this.pkOrderDateTo.getValue()) != null) {
            dateEnd = (Date)v;
        }
        if ((v = this.prmtMaterialGroupFrom.getValue()) != null) {
            mGroupStartID = ((DataBaseInfo)v).getNumber();
        }
        if ((v = this.prmtMaterialGroupTo.getValue()) != null) {
            mGroupEndID = ((DataBaseInfo)v).getNumber();
        }
        if ((v = this.prmtMaterialFrom.getValue()) != null) {
            mStartID = ((DataBaseInfo)v).getNumber();
        }
        if ((v = this.prmtMaterialTo.getValue()) != null) {
            mEndID = ((DataBaseInfo)v).getNumber();
        }
        if ((v = this.prmtPerson.getValue()) != null) {
            plannerID = ((DataBaseInfo)v).getId().toString();
        }
        try {
            IReqPlanSOImportFacade svc = ReqPlanSOImportFacadeFactory.getRemoteInstance();
            int count = svc.importSO(suIDs, bizTypeStartID, bizTypeEndID, soStartID, soEndID, dateStart, dateEnd, mGroupStartID, mGroupEndID, mStartID, mEndID, plannerID);
            if (count != 0) {
                MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessage((String)REQPLAN_RESOURCE_FULLNAME, (String)"ImportSOSuccessPrompt", (String[])new String[]{"" + count}));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessage((String)REQPLAN_RESOURCE_FULLNAME, (String)"noSOImport", (String[])new String[0]));
            }
            this.destroyWindow();
        }
        catch (Exception t) {
            this.handleException(t);
        }
    }

    @Override
    protected void prmtStorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        Object newVal = e.getNewValue();
        Object oldVal = e.getOldValue();
        if (newVal != null && !newVal.equals(oldVal)) {
            this.initF7((StorageOrgUnitInfo)newVal);
        }
    }

    private void initSaleOrderF7(StorageOrgUnitInfo storageOrgUnitInfo) {
        this.prmtSaleOrderFrom.setValue(null);
        this.prmtSaleOrderTo.setValue(null);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)"4,5,7", CompareType.INNER));
        if (null != storageOrgUnitInfo && null != storageOrgUnitInfo.getId()) {
            filter.getFilterItems().add(new FilterItemInfo("entries.storageOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString()));
        }
        view.setFilter(filter);
        this.prmtSaleOrderFrom.setEntityViewInfo(view);
        this.prmtSaleOrderTo.setEntityViewInfo(view);
        MMUtils.filterRangF7Helper((Component)this.prmtSaleOrderFrom, (Component)this.prmtSaleOrderTo);
    }

    private void initF7(StorageOrgUnitInfo storageOrgUnitInfo) {
        this.initSaleOrderF7(storageOrgUnitInfo);
        try {
            this.registerMaterial(storageOrgUnitInfo);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void registerMaterial(StorageOrgUnitInfo storageOrgUnitInfo) throws EASBizException, BOSException {
        this.prmtMaterialFrom.setDisplayFormat("$number$");
        this.prmtMaterialFrom.setEditFormat("$number$");
        this.prmtMaterialFrom.setCommitFormat("$number$");
        this.prmtMaterialTo.setDisplayFormat("$number$");
        this.prmtMaterialTo.setEditFormat("$number$");
        this.prmtMaterialTo.setCommitFormat("$number$");
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtMaterialFrom, (OrgUnitInfo)storageOrgUnitInfo);
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtMaterialTo, (OrgUnitInfo)storageOrgUnitInfo);
        EntityViewInfo viewInfo = this.prmtMaterialFrom.getEntityViewInfo();
        viewInfo = viewInfo == null ? new EntityViewInfo() : viewInfo;
        FilterInfo filter = new FilterInfo();
        if (null != storageOrgUnitInfo && null != storageOrgUnitInfo.getId()) {
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(filter);
        } else {
            viewInfo.getFilter().mergeFilter(filter, "AND");
        }
        this.prmtMaterialFrom.setEntityViewInfo(viewInfo);
        this.prmtMaterialTo.setEntityViewInfo(viewInfo);
        MMUtils.filterRangF7Helper((Component)this.prmtMaterialFrom, (Component)this.prmtMaterialTo);
        MMUtils.filterRangF7Helper((Component)this.prmtMaterialGroupFrom, (Component)this.prmtMaterialGroupTo);
    }

    protected String getOnloadPermItemName() {
        return "mm_soimport_imp";
    }

    private void setprmtBizTypeToFilter() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizCategory.system", (Object)new Integer(11), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        this.prmtBizTypeTo.setEntityViewInfo(viewInfo);
        this.prmtBizTypeFrom.setEntityViewInfo(viewInfo);
        MMUtils.filterRangF7Helper((Component)this.prmtBizTypeFrom, (Component)this.prmtBizTypeTo);
    }
}

