/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.mm.common.util.MMConstant;
import com.kingdee.eas.mm.planning.RequirementPlanFactory;
import com.kingdee.eas.mm.planning.RequirementPlanInfo;
import com.kingdee.eas.mm.planning.client.AbstractReqSaleOrderRelationUI;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReqSaleOrderRelationUI
extends AbstractReqSaleOrderRelationUI {
    private static final Logger logger = CoreUIObject.getLogger(ReqSaleOrderRelationUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTable1.getSelectManager().setSelectMode(2);
        String requirementId = (String)this.getUIContext().get("REQUIREMENT_ID");
        if (requirementId != null) {
            this.kDTable1.checkParsed();
            this.kDTable1.getStyleAttributes().setLocked(true);
            Map dataMap = RequirementPlanFactory.getRemoteInstance().getSaleOrderRelation(requirementId);
            RequirementPlanInfo reqPlanInfo = (RequirementPlanInfo)dataMap.get("requirementPlan");
            List saleOrderInfoList = (List)dataMap.get("saleOrder");
            this.tfNumber.setText(reqPlanInfo.getNumber());
            this.tfMtrlCode.setText(reqPlanInfo.getMaterial().getNumber());
            this.tfMtrlName.setText(reqPlanInfo.getMaterial().getName());
            this.tfModel.setText(reqPlanInfo.getMaterial().getModel());
            this.tfUnitName.setText(reqPlanInfo.getUnit().getName());
            this.dpRequireDate.setValue((Object)reqPlanInfo.getRequireDate());
            this.ftfQty.setText(this.removeBigDecimalZero(reqPlanInfo.getQty()));
            this.ftfCntQty.setText(this.removeBigDecimalZero(reqPlanInfo.getCntactTotalQty()));
            if (saleOrderInfoList != null) {
                int size = saleOrderInfoList.size();
                for (int i = 0; i < size; ++i) {
                    IRow row = this.kDTable1.addRow();
                    Map saleOrderMap = (Map)saleOrderInfoList.get(i);
                    row.getCell("saleOrderNumber").setValue(saleOrderMap.get("FSaleOrderNumber"));
                    row.getCell("id").setValue(saleOrderMap.get("FSaleOrderId"));
                    row.getCell("status").setValue(saleOrderMap.get("FBaseStatus"));
                    row.getCell("saleEntryID").setValue(saleOrderMap.get("saleEntryID"));
                    row.getCell("saleEntrySeq").setValue(saleOrderMap.get("saleEntrySeq"));
                    row.getCell("saleOrgUnitID").setValue(saleOrderMap.get("saleOrgUnitID"));
                }
            }
        }
    }

    private String removeBigDecimalZero(BigDecimal qty) {
        String qtyString = "0";
        if (qty.compareTo(MMConstant.BIGDECIMAL_ZERO) == 0) {
            qtyString = "0";
        } else {
            qtyString = qty.toString();
            int pointIndex = qtyString.indexOf(".");
            if (pointIndex == -1) {
                return qtyString;
            }
            while (qtyString.lastIndexOf("0") == qtyString.length() - 1 && qtyString.lastIndexOf("0") > pointIndex) {
                qtyString = qtyString.substring(0, qtyString.length() - 1);
            }
            if (qtyString.lastIndexOf(".") == qtyString.length() - 1) {
                qtyString = qtyString.substring(0, qtyString.length() - 1);
            }
        }
        return qtyString;
    }

    @Override
    public void actionViewSourceBill_actionPerformed(ActionEvent e) throws Exception {
        String status;
        if (this.kDTable1 == null) {
            return;
        }
        if (this.kDTable1.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)SCMUtils.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource", (String)"MSG_SelectRecorder", (Locale)SysContext.getSysContext().getLocale()));
            return;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kDTable1);
        if (selectRows == null || selectRows.length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)SCMUtils.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource", (String)"MSG_SelectRecorder", (Locale)SysContext.getSysContext().getLocale()));
            return;
        }
        int currentRowIndex = selectRows[0];
        IRow curruntRow = this.kDTable1.getRow(currentRowIndex);
        String id = (String)curruntRow.getCell("id").getValue();
        String saleOrgUnitID = (String)curruntRow.getCell("saleOrgUnitID").getValue();
        String delete = ResourceUtils.getMessage((String)"com.kingdee.eas.mm.planning.ReqPlanResource", (String)"hasDeleted");
        if (delete.equals(status = (String)curruntRow.getCell("status").getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)SCMUtils.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource", (String)"saleorderisdelete", (Locale)SysContext.getSysContext().getLocale()));
            return;
        }
        if (!SaleOrderFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)))) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        IPermission permission = PermissionFactory.getRemoteInstance();
        permission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(saleOrgUnitID), "saleorder_view");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        RealModeIDList idList = RealModeIDList.getEmptyIDList();
        idList.add(id);
        uiContext.put((Object)"IDList", (Object)idList);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.scm.sd.sale.client.SaleOrderEditUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }
}

