/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.planning.RequirementTypeFactory;
import com.kingdee.eas.mm.planning.client.AbstractRequirementPlanFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class RequirementPlanFilterUI
extends AbstractRequirementPlanFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RequirementPlanFilterUI.class);
    private DataChangeListener storageOrgUnitListener = null;
    private DataChangeListener materialGroupListener = null;

    public RequirementPlanFilterUI() throws Exception {
        this.setDefaultValue();
        this.promptStorageOrgUnit.setEnabledMultiSelection(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.promptStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_reqplan_view");
        this.prmtreqType.setValue(this.getDefaultReqType());
        this.getElementsInfo();
        this.setF7Filter();
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.promptStorageOrgUnit, (KDBizPromptBox)this.prmtTrackNumber);
        this.addListeners();
    }

    protected void setDefaultValue() {
        this.prmptMaterialGroup.setData(null);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        calendar.add(2, 1);
        this.pkrequireDateFrom.setValue((Object)new Timestamp(calendar.getTimeInMillis()));
        calendar.setTime(SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        calendar.add(2, 1);
        this.pkrequireDateTo.setValue((Object)new Timestamp(calendar.getTimeInMillis()));
    }

    private void setF7Filter() throws Exception {
        this.setBizMaterialF7(this.prmptMaterialFrom, false, null);
        this.setBizMaterialF7(this.prmptMaterialTo, false, null);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmptMaterialFrom, this.prmptMaterialTo, this.prmtBillNumberFrom, this.prmtBillNumberTo});
        this.f7Manager.registerContextChangeF7(this.prmptMaterialFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmptMaterialTo, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtBillNumberFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtBillNumberTo, this.getPropertyOfMainBizOrg());
        this.initMaterialGroupF7();
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cu.getId().toString(), CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        this.prmtPlannerFrom.setEntityViewInfo(viewInfo);
        this.prmtPlannerFrom.setEditFormat("$number$");
        this.prmtPlannerFrom.setDisplayFormat("$name$");
        this.prmtPlannerFrom.setCommitFormat("$number$");
        this.prmtProductionDeptFrom.setEditFormat("$number$");
        this.prmtProductionDeptFrom.setDisplayFormat("$name$");
        this.prmtProductionDeptFrom.setCommitFormat("$number$");
        this.prmtProductionDeptTo.setEditFormat("$number$");
        this.prmtProductionDeptTo.setDisplayFormat("$name$");
        this.prmtProductionDeptTo.setCommitFormat("$number$");
        this.prmtProjectNumber.setEnabledMultiSelection(true);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumber);
        this.prmtProjectNumber.setEditFormat("$number$");
        this.prmtProjectNumber.setDisplayFormat("$number$");
        this.prmtProjectNumber.setCommitFormat("$number$");
        this.prmtTrackNumber.setEnabledMultiSelection(true);
        this.prmtPlannerFrom.setEnabledMultiSelection(false);
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new MMRangeFilterElement("material.number", (Component)this.prmptMaterialFrom, (Component)this.prmptMaterialTo));
        elements.add((FilterElement)new MMRangeFilterElement("number", (Component)this.prmtBillNumberFrom, (Component)this.prmtBillNumberTo));
        SingleFilterElement materialGroupElement = new SingleFilterElement("material.materialGroup.number", (Component)this.prmptMaterialGroup);
        elements.add((FilterElement)materialGroupElement);
        MMRangeFilterElement reqDateElement = new MMRangeFilterElement("requireDate", (Component)this.pkrequireDateFrom, (Component)this.pkrequireDateTo);
        reqDateElement.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)reqDateElement);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.promptStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, RequirementPlanFilterUI.getResource("STORAGEORG_ISNULL")));
        elements.add((FilterElement)mainOrgElement);
        SingleFilterElement reqTypeElement = new SingleFilterElement("reqType.number", (Component)this.prmtreqType);
        elements.add((FilterElement)reqTypeElement);
        SingleFilterElement trackNumberElement = new SingleFilterElement("trackNumber.number", (Component)this.prmtTrackNumber);
        elements.add((FilterElement)trackNumberElement);
        elements.add((FilterElement)new SingleFilterElement("planner.number", (Component)this.prmtPlannerFrom));
        SingleFilterElement projectNumberElement = new SingleFilterElement("project.number", (Component)this.prmtProjectNumber);
        elements.add((FilterElement)projectNumberElement);
        elements.add((FilterElement)new MMRangeFilterElement("productionDept.number", (Component)this.prmtProductionDeptFrom, (Component)this.prmtProductionDeptTo));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmptMaterialFrom, this.prmptMaterialTo, this.prmptMaterialGroup, this.prmtBillNumberFrom, this.prmtBillNumberTo});
    }

    private Object getDefaultReqType() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("number"));
        viewInfo.setSelector(selectors);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)"PIC", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)"PID", CompareType.EQUALS));
        filterInfo.setMaskString("#0 or #1");
        viewInfo.setFilter(filterInfo);
        Object[] reqTypes = null;
        try {
            CoreBaseCollection c = RequirementTypeFactory.getRemoteInstance().getCollection(viewInfo);
            reqTypes = c.toArray();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return reqTypes;
    }

    protected void addListeners() {
        this.promptStorageOrgUnit.addDataChangeListener(this.storageOrgUnitListener);
        if (this.materialGroupListener == null) {
            this.materialGroupListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    RequirementPlanFilterUI.this.materialGroup_dataChanged(e);
                }
            };
        }
        this.prmptMaterialGroup.addDataChangeListener(this.materialGroupListener);
    }

    private void initMaterialGroupF7() {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        this.prmptMaterialGroup.setEntityViewInfo(entityViewInfo);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.promptStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getViewPermission() {
        return "mm_reqplan_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    protected void materialGroup_dataChanged(DataChangeEvent e) {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getOldValue(), (Object)e.getNewValue());
        if (isDiffrent) {
            this.prmptMaterialFrom.setValue(null);
            this.prmptMaterialTo.setValue(null);
            try {
                this.setMaterialF7(this.prmptMaterialFrom);
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
    }

    private void setMaterialF7(KDBizPromptBox prmptBox) throws Exception {
        FilterInfo fiMaterialGroup = this.getFilterInfoFromControl(this.prmptMaterialGroup, "MaterialGroup.id");
        try {
            FilterInfo fi = new FilterInfo();
            fi.mergeFilter(fiMaterialGroup, "AND");
            prmptBox.getEntityViewInfo().setFilter(fi);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    private FilterInfo getFilterInfoFromControl(KDBizPromptBox control, String fieldName) {
        Object value = control.getValue();
        FilterInfo filter = new FilterInfo();
        if (value != null) {
            Object[] objectArray;
            if (value instanceof DataBaseInfo) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = value;
            } else {
                objectArray = (Object[])value;
            }
            Object[] arrValues = objectArray;
            StringBuffer arr = new StringBuffer();
            for (int i = 0; i < arrValues.length; ++i) {
                if (arrValues[i] == null) continue;
                if (arr.length() > 0) {
                    arr.append(", ");
                }
                arr.append("'").append(((DataBaseInfo)arrValues[i]).getId().toString()).append("'");
            }
            if (arr.length() > 0) {
                filter.getFilterItems().add(new FilterItemInfo(fieldName, (Object)arr.toString(), CompareType.INNER));
            }
        }
        return filter;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.client.BasedataResource", (String)strKey);
    }
}

