/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.planning.ISOPFacade;
import com.kingdee.eas.mm.planning.ISOPPermissionFacade;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.SOPPermissionFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPlanVersionFactory;
import com.kingdee.eas.mm.planning.SOPPlanVersionInfo;
import com.kingdee.eas.mm.planning.SOPPlannedTypeEnum;
import com.kingdee.eas.mm.planning.SOPSysParams;
import com.kingdee.eas.mm.planning.client.AbstractSOPAddnewFilterUI;
import com.kingdee.eas.scm.common.filter.CheckRadioGroupFilterElment;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JToggleButton;
import org.apache.log4j.Logger;

public class SOPAddnewFilterUI
extends AbstractSOPAddnewFilterUI {
    private static final long serialVersionUID = 18646546464L;
    private static final Logger logger = CoreUIObject.getLogger(SOPAddnewFilterUI.class);
    private HashMap contextHashMap = null;
    private static final String SALE_PERMISSION = "mm_sopsaleplan_edit";
    private static final String PRODUCT_PERMISSION = "mm_sopprodplan_edit";
    private SOPPeriod curPeriod;
    private SOPSysParams SOPParams;
    private static boolean isPermissionSale = false;
    private static boolean isPermissionProduct = false;
    CustomerParams cp = null;
    private ISOPFacade sopFacade = null;
    private RptParams myparams = null;

    private Object getDefaultPlanVersion() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        viewInfo.setSelector(selectors);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"000", CompareType.EQUALS));
        filterInfo.setMaskString("#0");
        viewInfo.setFilter(filterInfo);
        Object[] reqTypes = null;
        try {
            CoreBaseCollection c = SOPPlanVersionFactory.getRemoteInstance().getCollection(viewInfo);
            reqTypes = c.toArray();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return reqTypes[0];
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtstorageOrgUnit;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)strKey);
    }

    public final void setContextHashMap(HashMap value) {
        this.contextHashMap = value;
    }

    public final HashMap getContextHashMap() {
        return this.contextHashMap;
    }

    public void clear() {
        super.clear();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        OrgUnitInfo[] sop = this.getMainOrgs();
        HashSet<String> filterSet = new HashSet<String>();
        String[] str = new String[]{SALE_PERMISSION, PRODUCT_PERMISSION};
        for (int i = 0; i < sop.length; ++i) {
            OrgUnitInfo info = sop[i];
            Map filterMap = this.isFilterPermission(str, info);
            Boolean str1 = (Boolean)filterMap.get(str[0]);
            Boolean str2 = (Boolean)filterMap.get(str[1]);
            if (!str1.booleanValue() && !str2.booleanValue()) continue;
            filterSet.add(info.getId().toString());
        }
        this.prmtstorageOrgUnit.setEntityViewInfo(this.getMainOrgUnitFilter(filterSet));
        this.prmtstorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                SOPAddnewFilterUI.this.prmtProductionOrgUnit_dataChanged(e);
            }
        });
        this.prmtPlannedVersion.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                SOPAddnewFilterUI.this.prmtPlannedVersion_dataChanged(e);
            }
        });
        this.cmbEditMode.setSelectedItem((Object)SOPEditModeEnum.MONTHLY);
        this.cmbEditMode.removeAllItems();
        this.cmbEditMode.addItems(new Object[]{SOPEditModeEnum.MONTHLY, SOPEditModeEnum.WEEKLY});
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("org", (Component)this.prmtstorageOrgUnit);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("executStorageOrg", (Component)this.prmtSupplyOrgUnit));
        elements.add((FilterElement)new SingleFilterElement("matFrom", (Component)this.prmtmaterialNumFrom));
        elements.add((FilterElement)new SingleFilterElement("matTo", (Component)this.prmtmaterialNumTo));
        MMUtils.filterRangF7Helper((Component)this.prmtmaterialNumFrom, (Component)this.prmtmaterialNumTo);
        elements.add((FilterElement)new SingleFilterElement("planVersion", (Component)this.prmtPlannedVersion));
        SingleFilterElement editMode = new SingleFilterElement("sopeditmode", (Component)this.cmbEditMode);
        editMode.setDefaultValue((Object)SOPEditModeEnum.MONTHLY);
        elements.add((FilterElement)editMode);
        CheckRadioGroupFilterElment element2 = new CheckRadioGroupFilterElment("currentPlanType");
        element2.addButton((JToggleButton)this.productType, (Object)SOPPlannedTypeEnum.PRODUCT_PLAN);
        element2.addButton((JToggleButton)this.saleType, (Object)SOPPlannedTypeEnum.SALEPLAN);
        element2.addButton((JToggleButton)this.saleAndProductType, (Object)SOPPlannedTypeEnum.SALE_PRODUCT_PLAN);
        elements.add((FilterElement)element2);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.setMaterialFilter();
        this.f7Manager.registerContextChangeF7(this.prmtmaterialNumFrom, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.prmtmaterialNumTo, "storageOrgUnit.id");
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtmaterialNumFrom, this.prmtmaterialNumTo, this.prmtPlannedVersion});
        this.prmtmaterialNumFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (SOPAddnewFilterUI.this.prmtstorageOrgUnit.getValue() == null) {
                    MsgBox.showInfo((String)SOPAddnewFilterUI.this.getResource("PLEASE_INPUT_ORGUNIT"));
                    SOPAddnewFilterUI.this.prmtstorageOrgUnit.requestFocus();
                    e.setCanceled(true);
                }
            }
        });
        this.prmtmaterialNumTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (SOPAddnewFilterUI.this.prmtstorageOrgUnit.getValue() == null) {
                    MsgBox.showInfo((String)SOPAddnewFilterUI.this.getResource("PLEASE_INPUT_ORGUNIT"));
                    SOPAddnewFilterUI.this.prmtstorageOrgUnit.requestFocus();
                    e.setCanceled(true);
                }
            }
        });
        this.prmtSupplyOrgUnit.setEnabledMultiSelection(true);
        this.setSupplyOrgUnitFilter();
    }

    private EntityViewInfo getMainOrgUnitFilter(Set set) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(this.getPropertyOfMainBizOrg(), (Object)set, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private void setMaterialFilter() {
        String queryInfo = UIHelper.getMaterialPlanQueryForSopFilter((int)this.f7Manager.getF7DisplayMode());
        this.setBizMaterialF7(this.prmtmaterialNumFrom, false, queryInfo);
        this.setBizMaterialF7(this.prmtmaterialNumTo, false, queryInfo);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        if (storageOrgUnitInfo == null) {
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)" ", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)storageOrgUnitInfo.getId(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("Status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("plan.status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtmaterialNumTo.setEntityViewInfo(view);
        this.prmtmaterialNumFrom.setEntityViewInfo(view);
    }

    protected void setDefaultValue() {
        if (this.myparams == null) {
            super.setDefaultValue();
            this.prmtPlannedVersion.setValue(this.getDefaultPlanVersion());
        } else {
            this.setFilterValue(this.myparams);
            this.initPermission();
        }
    }

    private void prmtProductionOrgUnit_dataChanged(DataChangeEvent e) {
        Object newValue = e.getNewValue();
        if (!(newValue instanceof StorageOrgUnitInfo) && !(newValue instanceof FullOrgUnitInfo)) {
            return;
        }
        if (newValue == null || e.getOldValue() == newValue) {
            if (newValue == null) {
                this.prmtmaterialNumFrom.setValue(null);
                this.prmtmaterialNumTo.setValue(null);
            }
            return;
        }
        Object orgInfo = null;
        orgInfo = newValue instanceof FullOrgUnitInfo ? (FullOrgUnitInfo)newValue : (StorageOrgUnitInfo)newValue;
        if (orgInfo != null) {
            if (this.myparams == null) {
                this.setPlannedType();
            }
            try {
                if (this.sopFacade == null) {
                    this.sopFacade = SOPFacadeFactory.getRemoteInstance();
                }
                this.SOPParams = SOPFacadeFactory.getRemoteInstance().getSOPSysParams(orgInfo.getId().toString());
                if (this.SOPParams == null) {
                    MsgBox.showInfo((String)this.getResource("THE_OQG_HAS_NOT_PAREMS"));
                    this.prmtstorageOrgUnit.setValue(e.getOldValue());
                    return;
                }
            }
            catch (EASBizException e1) {
                this.handUIException(e1);
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        }
        this.prmtmaterialNumFrom.setValue(null);
        this.prmtmaterialNumTo.setValue(null);
    }

    private void prmtPlannedVersion_dataChanged(DataChangeEvent e) {
        Object newValue = e.getNewValue();
        if (!(newValue instanceof SOPPlanVersionInfo)) {
            return;
        }
        if (newValue == null || e.getOldValue() == newValue) {
            if (newValue == null) {
                this.prmtmaterialNumFrom.setValue(null);
                this.prmtmaterialNumTo.setValue(null);
            }
            return;
        }
        SOPPlanVersionInfo sopPlanVerInfo = (SOPPlanVersionInfo)newValue;
        if (sopPlanVerInfo != null) {
            // empty if block
        }
        this.prmtmaterialNumFrom.setValue(null);
        this.prmtmaterialNumTo.setValue(null);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams pp = super.getCustomerParams();
        Object stotageInfo = null;
        stotageInfo = this.prmtstorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (OrgUnitInfo)this.prmtstorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        pp.addCustomerParam("storageOrgUnit.id", stotageInfo.getId().toString());
        pp.addCustomerParam("storageOrgUnit.name", stotageInfo.getName().toString());
        SOPPlanVersionInfo planVersionInfo = (SOPPlanVersionInfo)this.prmtPlannedVersion.getValue();
        pp.addCustomerParam("planVersion.id", planVersionInfo.getId().toString());
        if (planVersionInfo.getName() == null) {
            planVersionInfo.setName("");
        }
        pp.addCustomerParam("planVersion.name", planVersionInfo.getName().toString());
        pp.addCustomerParam("planVersion.isActivation", String.valueOf(planVersionInfo.isActivation()));
        int planType = 0;
        if (this.productType.isSelected()) {
            planType = 2;
        }
        if (this.saleType.isSelected()) {
            planType = 1;
        }
        if (this.saleAndProductType.isSelected()) {
            planType = 3;
        }
        pp.addCustomerParam("currentPlanType", new Integer(planType).toString());
        return pp;
    }

    public RptParams getCustomCondition() {
        SOPPlanVersionInfo planVersionInfo;
        RptParams pp = super.getCustomCondition();
        Object stotageInfo = null;
        Object[] supplyOrgUnit = null;
        ArrayList<String> supplyOrgUnitNumList = new ArrayList<String>();
        stotageInfo = this.prmtstorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (OrgUnitInfo)this.prmtstorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        pp.setString("storageOrgUnit.id", stotageInfo.getId().toString());
        pp.setString("storageOrgUnit.name", stotageInfo.getName().toString());
        pp.setString("org", stotageInfo.getNumber());
        if (!(this.prmtSupplyOrgUnit.getValue() instanceof String) && this.prmtSupplyOrgUnit.getValue() != null && !this.prmtSupplyOrgUnit.getText().equals("") && ((Object[])this.prmtSupplyOrgUnit.getValue()).length != 0 && ((Object[])this.prmtSupplyOrgUnit.getValue())[0] != null) {
            supplyOrgUnit = (Object[])this.prmtSupplyOrgUnit.getValue();
            if (supplyOrgUnit != null) {
                for (int i = 0; i < supplyOrgUnit.length; ++i) {
                    supplyOrgUnitNumList.add(((OrgUnitInfo)supplyOrgUnit[i]).getNumber());
                }
            }
            pp.setObject("supplyOrgUnit.number", supplyOrgUnitNumList);
        }
        if ((this.prmtSupplyOrgUnit.getValue() == null || this.prmtSupplyOrgUnit.getValue() instanceof String) && this.prmtSupplyOrgUnit.getText().length() > 0) {
            String[] supplyOrgNumber = this.prmtSupplyOrgUnit.getText().split(";");
            if (supplyOrgNumber.length > 0) {
                for (int i = 0; i < supplyOrgNumber.length; ++i) {
                    supplyOrgUnitNumList.add(supplyOrgNumber[i].trim());
                }
            }
            pp.setObject("supplyOrgUnit.number", supplyOrgUnitNumList);
        }
        if ((planVersionInfo = (SOPPlanVersionInfo)this.prmtPlannedVersion.getValue()) != null) {
            pp.setObject("planVersion.id", (Object)planVersionInfo.getId().toString());
            if (planVersionInfo.getName() == null) {
                planVersionInfo.setName("");
            }
            pp.setString("planVersion.name", planVersionInfo.getName().toString());
            pp.setBoolean("planVersion.isActivation", planVersionInfo.isActivation());
            pp.setString("planVersion", planVersionInfo.getNumber());
        }
        this.curPeriod = this.getCurPeriod();
        pp.setObject("curPeriod.beginDate", (Object)this.curPeriod.getBeginDate());
        pp.setObject("curPeriod.endDate", (Object)this.curPeriod.getEndDate());
        pp.setInt("curPeriod.year", this.curPeriod.getYear());
        pp.setInt("curPeriod.number", this.curPeriod.getNumber());
        pp.setInt("curPeriod.paramMonthStartDay", this.curPeriod.getParamMonthStartDay());
        int horizon = this.getHorizon();
        pp.setInt("numOfPeriod", horizon);
        int editMode = 0;
        if (this.cmbEditMode.getSelectedItem().toString().equals(SOPEditModeEnum.MONTHLY.getAlias())) {
            editMode = 20;
        }
        if (this.cmbEditMode.getSelectedItem().toString().equals(SOPEditModeEnum.WEEKLY.getAlias())) {
            editMode = 10;
        }
        pp.setString("sopeditmode", new Integer(editMode).toString());
        int planType = 0;
        if (this.productType.isSelected()) {
            planType = 2;
        }
        if (this.saleType.isSelected()) {
            planType = 1;
        }
        if (this.saleAndProductType.isSelected()) {
            planType = 3;
        }
        pp.setString("currentPlanType", new Integer(planType).toString());
        MaterialInfo matFromInfo = (MaterialInfo)this.prmtmaterialNumFrom.getValue();
        MaterialInfo matToInfo = (MaterialInfo)this.prmtmaterialNumTo.getValue();
        if (matFromInfo != null) {
            pp.setString("matFrom", matFromInfo.getNumber());
        } else {
            pp.setString("matFrom", this.prmtmaterialNumFrom.getText().trim());
        }
        if (matToInfo != null) {
            pp.setString("matTo", matToInfo.getNumber());
        } else {
            pp.setString("matTo", this.prmtmaterialNumTo.getText().trim());
        }
        pp.setBoolean("isPermissionSale", isPermissionSale);
        pp.setBoolean("isPermissionProduct", isPermissionProduct);
        this.cp = null;
        return pp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        if (this.cp.getCustomerParam("prmtSupplyOrgUnit") != null && this.cp.getCustomerParam("prmtSupplyOrgUnit").length() != 0) {
            String supplyOrgUnit = this.cp.getCustomerParam("prmtSupplyOrgUnit");
            this.prmtSupplyOrgUnit.setText(supplyOrgUnit);
        }
        if (this.cp.getCustomerParam("planVersion.id") != null) {
            SOPPlanVersionInfo planVersionInfo = new SOPPlanVersionInfo();
            planVersionInfo.setActivation(this.cp.getBoolean("planVersion.isActivation"));
            planVersionInfo.setName(this.cp.getCustomerParam("planVersion.name"));
            planVersionInfo.setNumber(this.cp.getCustomerParam("prmtPlannedVersion"));
            planVersionInfo.setId(BOSUuid.read((String)this.cp.getCustomerParam("planVersion.id")));
            this.prmtPlannedVersion.setValue((Object)planVersionInfo);
            StorageOrgUnitInfo storageInfo = new StorageOrgUnitInfo();
            storageInfo.setId(BOSUuid.read((String)this.cp.getCustomerParam("storageOrgUnit.id")));
            storageInfo.setName(this.cp.getCustomerParam("storageOrgUnit.name"));
            storageInfo.setNumber(this.cp.getCustomerParam("prmtstorageOrgUnit"));
            this.prmtstorageOrgUnit.setValue((Object)storageInfo);
            this.cmbEditMode.removeAllItems();
            this.cmbEditMode.addItems(new Object[]{SOPEditModeEnum.MONTHLY, SOPEditModeEnum.WEEKLY});
            if (this.cp.getCustomerParam("cmbEditMode").toString().equals(new Integer(20).toString())) {
                this.cmbEditMode.setSelectedItem((Object)SOPEditModeEnum.MONTHLY);
            } else {
                this.cmbEditMode.setSelectedItem((Object)SOPEditModeEnum.WEEKLY);
            }
            int planType = Integer.parseInt(this.cp.getCustomerParam("currentPlanType"));
            if (planType == 2) {
                this.productType.setSelected(true);
            }
            if (planType == 1) {
                this.saleType.setSelected(true);
            }
            if (planType == 3) {
                this.saleAndProductType.setSelected(true);
            }
            this.prmtmaterialNumFrom.setText(this.cp.getCustomerParam("prmtmaterialNumFrom"));
            this.prmtmaterialNumTo.setText(this.cp.getCustomerParam("prmtmaterialNumTo"));
        }
    }

    public boolean verify() {
        boolean bRet = true;
        if (this.prmtstorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("STORAGE_ORG_CAN_NOT_BE_NULL"));
            this.prmtstorageOrgUnit.requestFocus();
            bRet = false;
            return bRet;
        }
        if (this.prmtPlannedVersion.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("PLANNED_VERSION_CAN_NOT_BE_NULL"));
            bRet = false;
            return bRet;
        }
        Object stotageInfo = null;
        stotageInfo = this.prmtstorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (FullOrgUnitInfo)this.prmtstorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        if (!this.prmtstorageOrgUnit.getText().equals(stotageInfo.getName())) {
            MsgBox.showError((String)this.getResource("NO_SUCH_ORGUNIT"));
            bRet = false;
            return bRet;
        }
        SOPPlanVersionInfo planVersionInfo = (SOPPlanVersionInfo)this.prmtPlannedVersion.getValue();
        if (!this.prmtPlannedVersion.getText().equals(planVersionInfo.getName())) {
            MsgBox.showError((String)this.getResource("NO_SUCH_PLANVERSION"));
            bRet = false;
            return bRet;
        }
        Object info = null;
        info = this.prmtstorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (FullOrgUnitInfo)this.prmtstorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        String[] orgUnit = new String[]{info.getName()};
        if (this.productType.isSelected() && !isPermissionProduct) {
            String msg = this.getResource("NO_SOP_PRODUCTPLAN_EDIT_PERMISSION");
            MessageFormat msgFmt = new MessageFormat(msg);
            MsgBox.showError((String)msgFmt.format(orgUnit));
            bRet = false;
            return bRet;
        }
        if (this.saleType.isSelected()) {
            if (!isPermissionSale) {
                String msg = this.getResource("NO_SOP_SALEPLAN_EDIT_PERMISSION");
                MessageFormat msgFmt = new MessageFormat(msg);
                MsgBox.showError((String)msgFmt.format(orgUnit));
                bRet = false;
                return bRet;
            }
        } else if (!(!this.saleAndProductType.isSelected() || isPermissionSale && isPermissionProduct)) {
            if (!isPermissionSale && isPermissionProduct) {
                String msg = this.getResource("NO_SOP_SALEPLAN_EDIT_PERMISSION");
                MessageFormat msgFmt = new MessageFormat(msg);
                MsgBox.showError((String)msgFmt.format(orgUnit));
                bRet = false;
                return bRet;
            }
            if (!isPermissionProduct && isPermissionSale) {
                String msg = this.getResource("NO_SOP_PRODUCTPLAN_EDIT_PERMISSION");
                MessageFormat msgFmt = new MessageFormat(msg);
                MsgBox.showError((String)msgFmt.format(orgUnit));
                bRet = false;
                return bRet;
            }
            String msg = this.getResource("NO_SOP_PRODUCTPLAN_AND_SALEPLAN_EDIT_PERMISSION");
            MessageFormat msgFmt = new MessageFormat(msg);
            MsgBox.showError((String)msgFmt.format(orgUnit));
            bRet = false;
            return bRet;
        }
        if (!(this.saleType.isSelected() || this.saleAndProductType.isSelected() || this.productType.isSelected())) {
            String msg = this.getResource("NO_SOP_PRODUCTPLAN_AND_SALEPLAN_EDIT_PERMISSION");
            MessageFormat msgFmt = new MessageFormat(msg);
            MsgBox.showError((String)msgFmt.format(orgUnit));
            bRet = false;
            return bRet;
        }
        return bRet;
    }

    private void setPlannedType() {
        Map permMap = new HashMap();
        String[] str = new String[]{SALE_PERMISSION, PRODUCT_PERMISSION};
        try {
            permMap = this.isPermission(str);
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        isPermissionSale = Boolean.valueOf(permMap.get(SALE_PERMISSION).toString());
        isPermissionProduct = Boolean.valueOf(permMap.get(PRODUCT_PERMISSION).toString());
        if (isPermissionSale && !isPermissionProduct) {
            this.saleType.setSelected(true);
        }
        if (!isPermissionSale && isPermissionProduct) {
            this.productType.setSelected(true);
        }
        if (isPermissionSale && isPermissionProduct) {
            this.saleAndProductType.setSelected(true);
        }
    }

    private Map isPermission(String[] str) throws BOSException, EASBizException {
        Object info = null;
        info = this.prmtstorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (FullOrgUnitInfo)this.prmtstorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        ISOPPermissionFacade sopPermFacade = SOPPermissionFacadeFactory.getRemoteInstance();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        Map permMap = sopPermFacade.checkPermissions(userPK.toString(), info.getId().toString(), str);
        return permMap;
    }

    private Map isFilterPermission(String[] str, OrgUnitInfo orgUnitInfo) throws BOSException, EASBizException {
        ISOPPermissionFacade sopPermFacade = SOPPermissionFacadeFactory.getRemoteInstance();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        Map permMap = sopPermFacade.checkPermissions(userPK.toString(), orgUnitInfo.getId().toString(), str);
        return permMap;
    }

    private SOPPeriod getCurPeriod() {
        Object info = null;
        info = this.prmtstorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (FullOrgUnitInfo)this.prmtstorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        try {
            if (this.sopFacade == null) {
                this.sopFacade = SOPFacadeFactory.getRemoteInstance();
            }
            this.curPeriod = this.sopFacade.getCurrentPeriod((SOPEditModeEnum)((Object)this.cmbEditMode.getSelectedItem()), info.getId().toString());
            if (this.curPeriod == null) {
                MsgBox.showInfo((String)this.getResource("THE_OQG_HAS_NOT_PAREMS"));
                SysUtil.abort();
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return this.curPeriod;
    }

    private int getHorizon() {
        Object info = null;
        info = this.prmtstorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (OrgUnitInfo)this.prmtstorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        int ihorizon = 0;
        if (this.SOPParams == null) {
            try {
                if (this.sopFacade == null) {
                    this.sopFacade = SOPFacadeFactory.getRemoteInstance();
                }
                this.SOPParams = this.sopFacade.getSOPSysParams(info.getId().toString());
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        ihorizon = this.cmbEditMode.getSelectedItem().equals((Object)SOPEditModeEnum.WEEKLY) ? this.SOPParams.getSOPWeekHorizon() : this.SOPParams.getSOPMonthHorizon();
        return ihorizon;
    }

    public void handUIException(Throwable exc) {
        Throwable e = exc;
        if (e instanceof AlreadyInProcessQueueException) {
            logger.error((Object)e);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AlreadyInProcessQueue"));
            return;
        }
        if (e instanceof MissMatchParticipantException) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MissMatchParticipant"));
            return;
        }
        if (e instanceof MatchAssignmentException) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFMatch"));
            return;
        }
        ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    private void setSupplyOrgUnitFilter() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        this.prmtSupplyOrgUnit.setEntityViewInfo(viewInfo);
    }

    public void setFilterValue(RptParams params) {
        Iterator it = params.keySet().iterator();
        while (it.hasNext()) {
            MaterialCollection materialCols;
            FilterInfo filter;
            EntityViewInfo view;
            String valueKey = it.next().toString();
            if (valueKey.equalsIgnoreCase("planVersion.id")) {
                SOPPlanVersionInfo planVersionInfo = new SOPPlanVersionInfo();
                planVersionInfo.setActivation(params.getBoolean("planVersion.isActivation"));
                planVersionInfo.setName(params.getString("planVersion.name"));
                planVersionInfo.setNumber(params.getString("planVersion"));
                planVersionInfo.setId(BOSUuid.read((String)params.getObject(valueKey).toString()));
                this.prmtPlannedVersion.setValue((Object)planVersionInfo);
                continue;
            }
            if (valueKey.equalsIgnoreCase("storageOrgUnit.id")) {
                StorageOrgUnitInfo storageInfo = new StorageOrgUnitInfo();
                storageInfo.setId(BOSUuid.read((String)params.getObject("storageOrgUnit.id").toString()));
                storageInfo.setName(params.getObject("storageOrgUnit.name").toString());
                storageInfo.setNumber(params.getObject("org").toString());
                this.prmtstorageOrgUnit.setValue((Object)storageInfo);
                continue;
            }
            if (valueKey.equalsIgnoreCase("sopeditmode")) {
                this.cmbEditMode.removeAllItems();
                this.cmbEditMode.addItems(new Object[]{SOPEditModeEnum.MONTHLY, SOPEditModeEnum.WEEKLY});
                if (params.getObject(valueKey).toString().equals(new Integer(20).toString())) {
                    this.cmbEditMode.setSelectedItem((Object)SOPEditModeEnum.MONTHLY);
                    continue;
                }
                this.cmbEditMode.setSelectedItem((Object)SOPEditModeEnum.WEEKLY);
                continue;
            }
            if (valueKey.equalsIgnoreCase("currentPlanType")) {
                int planType = Integer.parseInt(params.getObject(valueKey).toString());
                if (planType == 2) {
                    this.productType.setSelected(true);
                }
                if (planType == 1) {
                    this.saleType.setSelected(true);
                }
                if (planType != 3) continue;
                this.saleAndProductType.setSelected(true);
                continue;
            }
            if (valueKey.equalsIgnoreCase("matFrom")) {
                MaterialInfo materialInfo = new MaterialInfo();
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)params.getObject(valueKey).toString(), CompareType.EQUALS));
                view.setFilter(filter);
                try {
                    materialCols = MaterialFactory.getRemoteInstance().getMaterialCollection(view);
                    materialInfo = materialCols.get(0);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                this.prmtmaterialNumFrom.setValue((Object)materialInfo);
                continue;
            }
            if (valueKey.equalsIgnoreCase("matTo")) {
                MaterialInfo materialInfo = new MaterialInfo();
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)params.getObject(valueKey).toString(), CompareType.EQUALS));
                view.setFilter(filter);
                try {
                    materialCols = MaterialFactory.getRemoteInstance().getMaterialCollection(view);
                    materialInfo = materialCols.get(0);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                this.prmtmaterialNumTo.setValue((Object)materialInfo);
                continue;
            }
            if (!valueKey.equalsIgnoreCase("supplyOrgUnit.number")) continue;
            StorageOrgUnitCollection storageCols = null;
            HashSet set = new HashSet();
            List supplyOrgUnit = (List)params.getObject(valueKey);
            for (int i = 0; i < supplyOrgUnit.size(); ++i) {
                set.add(supplyOrgUnit.get(i));
            }
            EntityViewInfo view2 = new EntityViewInfo();
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
            view2.setFilter(filter2);
            try {
                storageCols = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(view2);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.prmtSupplyOrgUnit.setValue((Object)storageCols.toArray());
        }
    }

    public void setMyparams(RptParams myparams) {
        this.myparams = myparams;
    }

    public RptParams getMyparams() {
        return this.myparams;
    }

    private void initPermission() {
        Map permMap = new HashMap();
        String[] str = new String[]{SALE_PERMISSION, PRODUCT_PERMISSION};
        try {
            permMap = this.isPermission(str);
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        isPermissionSale = Boolean.valueOf(permMap.get(SALE_PERMISSION).toString());
        isPermissionProduct = Boolean.valueOf(permMap.get(PRODUCT_PERMISSION).toString());
    }
}

