/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPException;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.SOPPlanVersionInfo;
import com.kingdee.eas.mm.planning.SOPPlannedTypeEnum;
import com.kingdee.eas.mm.planning.client.AbstractSOPCopyUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class SOPCopyUI
extends AbstractSOPCopyUI {
    private static final long serialVersionUID = -7472857419490132071L;
    private static final Logger logger = CoreUIObject.getLogger(SOPCopyUI.class);
    private Map paramMap = null;
    SOPPeriod[] periods = null;
    StorageOrgUnitInfo org = null;
    SOPPlanVersionInfo srcVer = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.paramMap = (Map)this.getUIContext().get("COPYSOP");
        if (this.paramMap == null) {
            throw new Exception("no parameters.");
        }
        SOPEditModeEnum sopEditMode = (SOPEditModeEnum)((Object)this.paramMap.get("sopeditmode"));
        this.cmbEditMode.setSelectedItem((Object)sopEditMode);
        String orgId = (String)this.paramMap.get("org");
        String sourceVerId = (String)this.paramMap.get("sourceVersion");
        List materialLst = (List)this.paramMap.get("materials");
        if (materialLst == null || materialLst.size() == 0) {
            throw new SOPException(SOPException.NO_SELECTED_MATERIAL);
        }
        SOPPlannedTypeEnum planType = (SOPPlannedTypeEnum)((Object)this.paramMap.get("PlanType"));
        if (planType.equals((Object)SOPPlannedTypeEnum.SALEPLAN)) {
            this.bgPlanType.setValue(0);
        } else if (planType.equals((Object)SOPPlannedTypeEnum.PRODUCT_PLAN)) {
            this.bgPlanType.setValue(1);
        } else {
            this.bgPlanType.setValue(2);
        }
        EntityViewInfo sopVersionEV = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        FilterItemInfo fiInfo = new FilterItemInfo("id", (Object)sourceVerId, CompareType.NOTEQUALS);
        fi.getFilterItems().add(fiInfo);
        sopVersionEV.setFilter(fi);
        this.prmtTargetSOPVersion.setEntityViewInfo(sopVersionEV);
        HashMap<String, Object> inMap = new HashMap<String, Object>();
        inMap.put("org", orgId);
        inMap.put("sourceVersion", sourceVerId);
        inMap.put("sopeditmode", (Object)sopEditMode);
        Map outMap = SOPFacadeFactory.getRemoteInstance().getDataForCopySOP(inMap);
        this.org = (StorageOrgUnitInfo)outMap.get("org");
        this.prmtStorageOrgUnit.setData((Object)this.org);
        this.srcVer = (SOPPlanVersionInfo)outMap.get("sourceVersion");
        this.prmtSourceSOPVersion.setData((Object)this.srcVer);
        Integer horizon = (Integer)outMap.get("NumberOfTerm");
        this.setSpinRange(this.sprNumberOfTerm, horizon, new Integer(1));
        SOPPeriod currentPeriod = (SOPPeriod)outMap.get("StartSOPPeriod");
        this.periods = currentPeriod.forwardPeriods(horizon);
        this.cmbStartSOPTerm.removeAllItems();
        this.cmbStartSOPTerm.addItems((Object[])this.periods);
        this.cmbStartSOPTerm.setSelectedItem((Object)currentPeriod);
        if (planType.equals((Object)SOPPlannedTypeEnum.SALEPLAN)) {
            this.chkBopCopy.setEnabled(false);
        } else if (planType.equals((Object)SOPPlannedTypeEnum.PRODUCT_PLAN)) {
            this.chkBopCopy.setEnabled(true);
        }
    }

    protected void initListener() {
        super.initListener();
        this.rbSaleProd.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SOPCopyUI.this.rbSaleProd.isSelected()) {
                    SOPCopyUI.this.chkBopCopy.setEnabled(true);
                }
            }
        });
        this.rbSale.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SOPCopyUI.this.rbSale.isSelected()) {
                    SOPCopyUI.this.chkBopCopy.setSelected(false);
                    SOPCopyUI.this.chkBopCopy.setEnabled(false);
                }
            }
        });
        this.rbProduction.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SOPCopyUI.this.rbProduction.isSelected()) {
                    SOPCopyUI.this.chkBopCopy.setEnabled(true);
                }
            }
        });
    }

    private void setSpinRange(KDSpinner sp, Integer maxVal, Integer minVal) throws Exception {
        SpinnerModel sm = sp.getModel();
        SpinnerNumberModel nm = (SpinnerNumberModel)sm;
        nm.setMaximum(maxVal);
        nm.setMinimum(minVal);
        nm.setValue(minVal);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        int termNum;
        if (this.prmtTargetSOPVersion.getValue() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource.TARGET_VERSION_ISNULL"));
            return;
        }
        int termInx = this.cmbStartSOPTerm.getSelectedIndex();
        if (termInx + (termNum = ((Integer)this.sprNumberOfTerm.getModel().getValue()).intValue()) > this.periods.length) {
            String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource.COPYSOP_PERIOD_ERROR");
            msg = MessageFormat.format(msg, this.periods[0], this.periods[this.periods.length - 1]);
            MsgBox.showError((String)msg);
            return;
        }
        SOPPlanVersionInfo targetVer = (SOPPlanVersionInfo)this.prmtTargetSOPVersion.getValue();
        String targetVerID = targetVer.getId().toString();
        SOPPeriod endPeriod = this.periods[termInx + termNum - 1];
        this.paramMap.put("targetVerID", targetVerID);
        this.paramMap.put("StartSOPPeriod", this.cmbStartSOPTerm.getSelectedItem());
        this.paramMap.put("EndSOPPeriod", endPeriod);
        this.paramMap.put("NumberOfTerm", this.sprNumberOfTerm.getModel().getValue());
        this.paramMap.put("PlanType", new Integer(this.bgPlanType.getValue()));
        this.paramMap.put("CopyMode", new Integer(this.bgCopyMode.getValue()));
        this.paramMap.put("isCopyBop", this.chkBopCopy.getSelected() == 32);
        SOPFacadeFactory.getRemoteInstance().copySOP(this.paramMap);
        String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource.COPY_SUCCESS_MSG");
        msg = MessageFormat.format(msg, this.org.getNumber(), this.srcVer.getNumber(), targetVer.getNumber());
        MsgBox.showInfo((String)msg);
        this.actionExitCurrent_actionPerformed(e);
    }
}

