/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.planning.SOPCheckFormulaException;
import com.kingdee.eas.mm.planning.SOPPlanVersionFactory;
import com.kingdee.eas.mm.planning.client.AbstractSOPPlanVersionListUI;
import com.kingdee.eas.mm.planning.client.SOPPlanVersionEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SOPPlanVersionListUI
extends AbstractSOPPlanVersionListUI {
    private static final Logger logger = CoreUIObject.getLogger(SOPPlanVersionListUI.class);
    public static final String RESOURCE = "com.kingdee.eas.mm.planning.SOPCheckFormulaResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String actionName = (String)this.actionRemove.getValue("Name");
        this.bacthExecute(e, "delete", actionName);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        super.actionPrintPreview_actionPerformed(e);
    }

    protected String getEditUIName() {
        return SOPPlanVersionEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SOPPlanVersionFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        dialog.setWidth(450);
        dialog.setHeight(320);
        return dialog;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return super.getDefaultFilterForQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bacthExecute(ActionEvent e, String action, String actionName) throws Exception {
        this.checkSelected();
        Throwable[] ex = null;
        HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
        ArrayList ids = this.getSelectedIdValues();
        ArrayList<String> exceptionIds = new ArrayList<String>();
        Map mapNumber = this.getSelectColumnValue(this.tblMain, this.getKeyFieldName(), this.getNumberColumn());
        Map rowNumberMap = null;
        if (mapNumber.isEmpty()) {
            rowNumberMap = this.getSelectRowNumberMap(this.tblMain, this.getKeyFieldName());
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)ids);
            Iterator lt = ids.iterator();
            while (lt.hasNext()) {
                String id = (String)lt.next();
                Object value = map.get(id);
                if (value == null || Boolean.valueOf(value.toString()).booleanValue()) continue;
                EASBizException mutexException = new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
                exceptionMap.put(id, mutexException);
                exceptionIds.add(id);
                lt.remove();
            }
            if (ids.size() > 0) {
                BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[ids.size()];
                for (int i = 0; i < ids.size(); ++i) {
                    BatchExecuteParamsEntry entry;
                    if (ids.get(i) == null) continue;
                    ObjectStringPK pk = new ObjectStringPK(ids.get(i).toString());
                    paramEntries[i] = entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{pk});
                }
                BatchExecuteResult result = this.getBizInterface().batchExecute(action, new Class[]{IObjectPK.class}, paramEntries);
                ex = result.getExceptions();
                for (int i = 0; i < ex.length; ++i) {
                    if (ex[i] == null) continue;
                    if (ex[i] instanceof ObjectNotFoundException) {
                        exceptionMap.put((String)ids.get(i), (Throwable)((Object)new SOPCheckFormulaException(SOPCheckFormulaException.DATANOTEXIST)));
                    } else {
                        exceptionMap.put((String)ids.get(i), ex[i]);
                    }
                    exceptionIds.add((String)ids.get(i));
                }
            }
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate((List)ids);
        }
        StringBuffer errorMsg = new StringBuffer();
        String numbetMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteFail_ByNumber");
        String rowIndexMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteFail_ByRowIndex");
        for (String id : exceptionIds) {
            if (mapNumber.isEmpty()) {
                errorMsg.append(MessageFormat.format(rowIndexMsg, rowNumberMap.get(id)));
            } else {
                errorMsg.append(MessageFormat.format(numbetMsg, mapNumber.get(id)));
            }
            if (ex != null) {
                errorMsg.append(ExceptionMessageUtility.getMessage((Throwable)((Throwable)exceptionMap.get(id))) + "\n");
                continue;
            }
            errorMsg.append("\n");
        }
        if (exceptionIds.size() > 0) {
            String deleteError = ResourceUtils.getMessageForClient((String)RESOURCE, (String)"LISTUI_OPRFAIL", (String[])new String[]{actionName});
            MsgBox.showDetailAndOK((Component)((Object)this), (String)deleteError, (String)errorMsg.toString(), (int)8188);
        }
        this.refresh(e);
    }

    public Map getSelectColumnValue(KDTable table, String keyColumnName, String valueColumnName) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (valueColumnName == null || valueColumnName.equals("")) {
            return map;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = table.getRow(selectRows[i]);
            ICell keyCell = null;
            ICell valueCell = null;
            if (row != null) {
                keyCell = row.getCell(keyColumnName);
                valueCell = row.getCell(valueColumnName);
            }
            if (keyCell == null || keyCell.getValue() == null || valueCell == null || valueCell.getValue() == null || map.containsKey(keyCell.getValue().toString())) continue;
            map.put(keyCell.getValue().toString(), valueCell.getValue().toString());
        }
        return map;
    }

    protected String getNumberColumn() {
        return "number";
    }

    public Map getSelectRowNumberMap(KDTable table, String fieldName) {
        HashMap<String, Integer> rowNumberMap = new HashMap<String, Integer>();
        if (table != null) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
            IRow row = null;
            ICell keyCell = null;
            if (selectRows != null) {
                for (int i = 0; i < selectRows.length; ++i) {
                    row = table.getRow(selectRows[i]);
                    if (row != null) {
                        keyCell = row.getCell(fieldName);
                    }
                    if (keyCell == null) continue;
                    rowNumberMap.put(keyCell.getValue().toString(), new Integer(selectRows[i] + 1));
                }
            }
        }
        return rowNumberMap;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        return null;
    }

    public boolean isNeedDefaultFilter() {
        QuerySolutionInfo querySolution = this.getCurrentSolutionInfo();
        if (querySolution != null && querySolution.isIsUserDefaultSolu()) {
            return false;
        }
        return super.isDefaultFilterInited();
    }
}

