/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.SOPSysParams;
import com.kingdee.eas.mm.planning.client.AbstractSOPProductPlanPolicyUI;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class SOPProductPlanPolicyUI
extends AbstractSOPProductPlanPolicyUI {
    private static final long serialVersionUID = 1564134132153L;
    private static final Logger logger = CoreUIObject.getLogger(SOPProductPlanPolicyUI.class);
    private SOPPeriod curPeriod;
    private SOPPeriod periodFrom;
    private SOPPeriod[] periods;
    private int horizon;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("period", null);
        this.getUIWindow().close();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SOPPeriod startPeriod = (SOPPeriod)this.cmbSOPStartPeriod.getShowSelectedItem();
        int size = this.cmbSOPStartPeriod.getSelectedIndex();
        Object numOfPeriod = this.sprNumPeriod.getValue();
        map.put("StartSOPPeriod", startPeriod);
        map.put("NumberOfTerm", numOfPeriod);
        map.put("size", size + "");
        map.put("prodplan", this.chkApply2Prod.getSelected() == 32);
        this.getUIContext().put("period", map);
        this.getUIWindow().close();
    }

    public void onLoad() throws Exception {
        Map uiContext = this.getUIContext();
        Object productPlanPolicy = uiContext.get("productPlanPolicy");
        String storageOrgUnit = uiContext.get("storageOrgUnitIID").toString();
        this.curPeriod = (SOPPeriod)uiContext.get("curPeriod");
        this.periodFrom = (SOPPeriod)uiContext.get("startPeriod");
        String uiTitle = (String)uiContext.get("uititle");
        if (uiTitle != null) {
            this.setUITitle(uiTitle);
            this.chkApply2Prod.setEnabled(false);
            this.chkApply2Prod.setVisible(false);
        }
        int numOfPeriod = Integer.parseInt(uiContext.get("numOfPeriod").toString());
        this.periods = this.periodFrom.forwardPeriods(numOfPeriod);
        this.horizon = numOfPeriod;
        this.cmbSOPStartPeriod.addItems((Object[])this.periods);
        this.SetSpinnerMaxMin((JSpinner)this.sprNumPeriod, 1, this.horizon);
        this.sprNumPeriod.setValue((Object)new Integer(this.horizon));
        this.cmbSOPStartPeriod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SOPProductPlanPolicyUI.this.cmbSOPStartPeriod.getSelectedItem() == null) {
                    return;
                }
                int selectIndex = SOPProductPlanPolicyUI.this.cmbSOPStartPeriod.getSelectedIndex();
                SOPProductPlanPolicyUI.this.sprNumPeriod.setValue((Object)new Integer(SOPProductPlanPolicyUI.this.horizon - selectIndex));
                SOPProductPlanPolicyUI.this.SetSpinnerMaxMin((JSpinner)SOPProductPlanPolicyUI.this.sprNumPeriod, 1, SOPProductPlanPolicyUI.this.horizon - selectIndex);
            }
        });
        super.onLoad();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    private void SetSpinnerMaxMin(JSpinner spinner, int min, int max) {
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel) {
            if (max >= min) {
                ((SpinnerNumberModel)model).setMaximum(new Integer(max));
            }
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
        }
    }

    private int getHorizon(String storageOrgUnit) {
        SOPSysParams SOPParams = null;
        int ihorizon = 0;
        try {
            SOPParams = SOPFacadeFactory.getRemoteInstance().getSOPSysParams(storageOrgUnit);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        ihorizon = SOPParams.getSOPMonthHorizon();
        return ihorizon;
    }
}

