/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.IRequirementPlan;
import com.kingdee.eas.mm.planning.RequirementPlanCollection;
import com.kingdee.eas.mm.planning.RequirementPlanFactory;
import com.kingdee.eas.mm.planning.RequirementPlanInfo;
import com.kingdee.eas.mm.planning.client.AbstractSaleOrderQtySettingUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SaleOrderQtySettingUI
extends AbstractSaleOrderQtySettingUI {
    private static final Logger logger = CoreUIObject.getLogger(SaleOrderQtySettingUI.class);
    private RequirementPlanCollection reqPlanColl;
    private List availableId;
    private IRequirementPlan repPlanInterface = RequirementPlanFactory.getRemoteInstance();
    private final String TB_REQ_PLAN_NUMBER = "reqPlanNumber";
    private final String TB_MATERIAL_NUMBER = "materialNumber";
    private final String TB_MATERIAL_NAME = "materialName";
    private final String TB_UNIT = "unit";
    private final String TB_REQ_QTY = "reqQty";
    private final String TB_CNTACT_QTY = "cntactQty";
    private final String TB_SALE_ORDER_QTY = "saleOrderQty";
    private boolean isGenericSaleOrder = false;

    public boolean isGenericSaleOrder() {
        return this.isGenericSaleOrder;
    }

    public void setGenericSaleOrder(boolean isGenericSaleOrder) {
        this.isGenericSaleOrder = isGenericSaleOrder;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.availableId = (List)this.getUIContext().get("availableId");
        String ids = SQLUtil.arrayToString((Object[])this.availableId.toArray());
        this.reqPlanColl = RequirementPlanFactory.getRemoteInstance().getRequirementPlanCollection("select *, material.number,material.name, unit.name, unit.qtyPrecision,baseUnit.qtyPrecision,qty,baseQty,cntactTotalQty,baseCntactTotalQty where id in (" + ids + ") order by number asc");
        this.kDTable1.checkParsed();
        this.kDTable1.getStyleAttributes().setLocked(true);
        this.kDTable1.getColumn("saleOrderQty").getStyleAttributes().setLocked(false);
        this.kDTable1.getActionMap().remove("Copy");
        this.kDTable1.getActionMap().remove("Paste");
        this.kDTable1.getActionMap().remove("Cut");
        this.kDTable1.getActionMap().remove("Delete");
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        int precision = 0;
        if (this.reqPlanColl.size() > 0) {
            int size = this.reqPlanColl.size();
            for (int i = 0; i < size; ++i) {
                IRow currentRow = this.kDTable1.addRow();
                RequirementPlanInfo reqPlanInfo = this.reqPlanColl.get(i);
                currentRow.getCell("reqPlanNumber").setValue((Object)reqPlanInfo.getNumber());
                currentRow.getCell("materialNumber").setValue((Object)reqPlanInfo.getMaterial().getNumber());
                currentRow.getCell("materialName").setValue((Object)reqPlanInfo.getMaterial().getName());
                currentRow.getCell("unit").setValue((Object)reqPlanInfo.getUnit().getName());
                MultiMeasureUnitInfo multiUnitInfo = imultiUnit.getMultiUnit(reqPlanInfo.getMaterial().getId().toString(), reqPlanInfo.getUnit().getId().toString());
                if (multiUnitInfo != null) {
                    precision = multiUnitInfo.getQtyPrecision();
                }
                String[] fieldNames = new String[]{"reqQty", "cntactQty", "saleOrderQty"};
                SCMClientUtils.changeCellPrecision((IRow)currentRow, (String[])fieldNames, (int)precision);
                currentRow.getCell("reqQty").setValue((Object)reqPlanInfo.getQty());
                currentRow.getCell("cntactQty").setValue((Object)reqPlanInfo.getCntactTotalQty());
                currentRow.getCell("saleOrderQty").setValue((Object)reqPlanInfo.getQty().subtract(reqPlanInfo.getCntactTotalQty()));
                KDFormattedTextField kdtMain_qty_NumberBox = new KDFormattedTextField();
                kdtMain_qty_NumberBox.setHorizontalAlignment(4);
                kdtMain_qty_NumberBox.setDataType(1);
                kdtMain_qty_NumberBox.setNegatived(false);
                kdtMain_qty_NumberBox.setPrecision(precision);
                KDTDefaultCellEditor kdtMain_qty_CellEditor = new KDTDefaultCellEditor((JTextField)kdtMain_qty_NumberBox);
                currentRow.getCell("saleOrderQty").setEditor((ICellEditor)kdtMain_qty_CellEditor);
            }
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        SaleOrderInfo saleOrder;
        if (this.kDTable1.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)SCMUtils.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource", (String)"MSG_SelectRecorder", (Locale)SysContext.getSysContext().getLocale()));
            return;
        }
        ArrayList<BigDecimal> saleOrderList = new ArrayList<BigDecimal>();
        int size = this.kDTable1.getRowCount();
        for (int i = 0; i < size; ++i) {
            BigDecimal saleOrderQty = (BigDecimal)this.kDTable1.getRow(i).getCell("saleOrderQty").getValue();
            saleOrderList.add(saleOrderQty);
        }
        if (this.availableId != null && (saleOrder = this.repPlanInterface.generateSaleOrder(this.reqPlanColl, saleOrderList)) != null) {
            int isConfirm = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.mm.planning.ReqPlanResource.isOpenSaleOrder"));
            this.destroyWindow();
            this.setGenericSaleOrder(true);
            if (isConfirm == 0) {
                String id = saleOrder.getSaleOrgUnit().getId().toString();
                PermissionHelper.checkFunctionPermission(null, (IObjectPK)new ObjectUuidPK(id), (String)"saleorder_view");
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)saleOrder.getId().toString());
                RealModeIDList idList = RealModeIDList.getEmptyIDList();
                idList.add(saleOrder.getId().toString());
                uiContext.put((Object)"IDList", (Object)idList);
                IUIWindow uiWindow = null;
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.scm.sd.sale.client.SaleOrderEditUI", (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
        this.setGenericSaleOrder(false);
    }
}

