/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.mm.basedata.IPlanVersionSet;
import com.kingdee.eas.mm.basedata.MaterialRangeEnum;
import com.kingdee.eas.mm.basedata.PlanVersionSetCollection;
import com.kingdee.eas.mm.basedata.PlanVersionSetFactory;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.planning.IRequirementPlan;
import com.kingdee.eas.mm.planning.MRPRunLogInfo;
import com.kingdee.eas.mm.planning.MRPRunMaterialEntryInfo;
import com.kingdee.eas.mm.planning.MrpRunEnum;
import com.kingdee.eas.mm.planning.ReqPlanStatusEnum;
import com.kingdee.eas.mm.planning.RequirementPlanCollection;
import com.kingdee.eas.mm.planning.RequirementPlanFactory;
import com.kingdee.eas.mm.planning.RequirementPlanInfo;
import com.kingdee.eas.mm.planning.client.AbstractSelectBillPlanRunUI;
import com.kingdee.eas.mm.planning.client.RequirementPlanSelectListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class SelectBillPlanRunUI
extends AbstractSelectBillPlanRunUI {
    private static final Logger logger = CoreUIObject.getLogger(SelectBillPlanRunUI.class);
    private List reqPlanIds = null;
    private List unCalcReqPlanIds = new ArrayList();
    private RequirementPlanCollection reqPlanCollection = null;
    private Set materils = new HashSet();

    @Override
    public void onLoad() throws Exception {
        this.adaptWinMode();
        super.onLoad();
        this.kDTable1.checkParsed();
        Object reqPlanList = this.getUIContext().get("reqPlanList");
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)this.getUIContext().get("orgInfo");
        if (orgInfo != null) {
            this.prmtStorageOrgUnit.setValue((Object)orgInfo);
        }
        if (reqPlanList != null) {
            this.loadReqPlanList(reqPlanList);
        }
        this.setDefaultValue();
        this.cbManageMRP.setVisible(false);
        this.menuBiz.setVisible(true);
        this.menuBiz.setEnabled(true);
        this.menuItemSelectReqPlan.setVisible(true);
        this.menuItemSelectReqPlan.setEnabled(true);
        this.menuItemCancelCancel.setVisible(false);
        this.menuItemCancel.setVisible(false);
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.kDTable1, (int)2);
    }

    private void adaptWinMode() {
        Dimension d = KDToolkit.getScreenSize();
        d.width -= 20;
        d.height -= 150;
        this.setPreferredSize(new Dimension(d));
        if (this.getUIContext().get("winMode") != null) {
            this.menuBar.setVisible(false);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.pnlRequirementPlan.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, this.kDTabbedPane1.getWidth(), this.kDTabbedPane1.getHeight()));
    }

    @Override
    public void actionSelectReqPlan_actionPerformed(ActionEvent e) throws Exception {
        String resultName = "selectedIdList";
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (storageOrgUnitInfo == null) {
            MsgBox.showInfo((String)this.getResource("CANNOT_ALLOW_STORAGEORGUNIT_ISNULL"));
            SysUtil.abort();
        }
        this.getUIContext().put("storageOrgUnit", storageOrgUnitInfo);
        this.getUIContext().put("Owner", this);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(RequirementPlanSelectListUI.class.getName(), this.getUIContext(), null, OprtState.VIEW, 95);
        window.show();
        boolean isComfirm = ((RequirementPlanSelectListUI)window.getUIObject()).isComfirm();
        Object result = window.getUIObject().getUIContext().get(resultName);
        if (isComfirm) {
            this.loadReqPlanList(result);
        }
    }

    private void loadReqPlanList(Object result) throws Exception {
        this.reqPlanIds = (List)result;
        this.reqPlanCollection = this.getRequirementPlan(this.reqPlanIds);
        this.setValueToTable(this.reqPlanCollection);
    }

    @Override
    public void actionSelectBill_actionPerformed(ActionEvent e) throws Exception {
        if (!this.cbAllowCalculatedReqPlan.isSelected()) {
            this.unCalcReqPlanIds.clear();
            if (this.reqPlanIds != null) {
                this.unCalcReqPlanIds.addAll(this.reqPlanIds);
            }
            this.removeCalculatedReqPlan();
            if (this.unCalcReqPlanIds.size() == 0) {
                MsgBox.showInfo((String)this.getResource("PLEASE_SELECT_RECORDS_TORUN"));
                return;
            }
        } else if (this.reqPlanIds == null || this.reqPlanIds.size() == 0) {
            MsgBox.showInfo((String)this.getResource("PLEASE_SELECT_RECORDS_TORUN"));
            return;
        }
        this.setCursor(new Cursor(3));
        MRPRunLogInfo dataObject = (MRPRunLogInfo)this.getDataObject();
        if (this.materils.size() > 0) {
            dataObject.setMateriaRange(MaterialRangeEnum.CUSTOM);
            this.setMaterilPlan(this.materils, dataObject.getStorageOrgUnit().getId().toString(), dataObject);
        }
        if (!this.cbAllowCalculatedReqPlan.isSelected()) {
            dataObject.put("requirementPlanIds", this.unCalcReqPlanIds);
        } else {
            dataObject.put("requirementPlanIds", this.reqPlanIds);
        }
        try {
            this.calcMpsMrpPlan();
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    private void setMaterilPlan(Set materids, String orgids, MRPRunLogInfo dataObject) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgids, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("material.id"));
        view.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        MaterialPlanCollection planCol = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(view);
        dataObject.getMaterialEntry().clear();
        for (int i = 0; i < planCol.size(); ++i) {
            MRPRunMaterialEntryInfo runMaterialEntryInfo = new MRPRunMaterialEntryInfo();
            MaterialInfo materialInfo = new MaterialInfo();
            materialInfo.setId(planCol.get(i).getMaterial().getId());
            runMaterialEntryInfo.setMaterial(planCol.get(i).getMaterial());
            runMaterialEntryInfo.setMaterialPlan(planCol.get(i));
            this.insertLine(i, (IObjectValue)runMaterialEntryInfo);
        }
    }

    @Override
    public void actionDeleteRow_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kDTable1);
        if (selectRows.length == 0) {
            MsgBox.showInfo((String)this.getResource("PLEASE_SELECT_RECORDS"));
            SysUtil.abort();
        }
        for (int i = 0; i < selectRows.length; ++i) {
            this.reqPlanCollection.remove((RequirementPlanInfo)this.kDTable1.getRow(selectRows[i]).getUserObject());
            this.reqPlanIds.remove(this.kDTable1.getRow(selectRows[i]).getCell("id").getValue());
        }
        this.setValueToTable(this.reqPlanCollection);
    }

    @Override
    protected void initWithMenuParam(String strParam) throws NumberFormatException {
        this.bIsMPSPlan = true;
        this.bIsGlobalPlan = false;
        this.setButtonAction(this.btnRunPlan, this.actionSelectBill);
        this.strPermissionItem = "mm_selectBill_plan_execution";
        this.mrpRunEnum = MrpRunEnum.MPS_GROSS;
        this.matEntry.getStyleAttributes().setHided(true);
        this.cbIsTransformPlannedOrder.setVisible(false);
        this.cbManageMRP.setVisible(false);
        this.kDContainer1.setVisible(false);
    }

    protected void storeToBoundObject() {
        MRPRunLogInfo objRunLog = (MRPRunLogInfo)this.getDataObject();
        objRunLog.setIsDelayOrder(this.cbAllowOverduePlanDate.getModel().isSelected());
        objRunLog.setIsCheckBOM(this.cbValidateBOM.getModel().isSelected());
        objRunLog.setIsManageLLC(this.cbReCalcLLC.getModel().isSelected());
        objRunLog.setStorageOrgUnit((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        objRunLog.setPlanDate((Date)this.pkStartTime.getValue());
        objRunLog.setPlanVersion((PlanVersionSetInfo)this.prmtPlanVersion.getValue());
        if (!this.cbAllowCalculatedReqPlan.isSelected()) {
            objRunLog.put("requirementPlanIds", this.unCalcReqPlanIds);
        } else {
            objRunLog.put("requirementPlanIds", this.reqPlanIds);
        }
    }

    @Override
    protected void setUI() throws Exception {
        this.strOpLog = this.getResource("SELECTBILL_PLAN_RUN");
    }

    @Override
    protected void setF7PlanVersion(StorageOrgUnitInfo sInfo) {
        if (sInfo != null) {
            PlanVersionSetCollection planVersionSetInfo = this.getPlanVersionSetCollection(sInfo.getId().toString());
            if (planVersionSetInfo == null || planVersionSetInfo.size() == 0) {
                this.prmtPlanVersion.setValue(null);
            } else {
                this.prmtPlanVersion.setValue((Object)planVersionSetInfo.get(0));
            }
            this.cbAllowOverduePlanDate.setSelected(true);
            this.cbValidateBOM.setSelected(true);
            this.cbReCalcLLC.setSelected(true);
            this.cbAllowCalculatedReqPlan.setSelected(false);
            if (this.reqPlanIds != null && this.reqPlanCollection != null) {
                this.reqPlanIds.clear();
                this.reqPlanCollection.clear();
                this.materils.clear();
                try {
                    this.setValueToTable(this.reqPlanCollection);
                }
                catch (Exception e) {
                    this.handUIExceptionAndAbort(e);
                }
            }
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK orgPK = super.getOrgPK(action);
        StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (action != null && action.equals((Object)this.actionSelectReqPlan) && orgUnitInfo != null) {
            String orgUnitId = orgUnitInfo.getId().toString();
            orgPK = new ObjectUuidPK(orgUnitId);
        }
        return orgPK;
    }

    private void setDefaultValue() throws Exception {
        this.prmtStorageOrgUnit.setEditable(true);
        this.prmtStorageOrgUnit.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent arg0) {
                if (arg0.getOldData() == null || arg0.getData() != null && arg0.getData().equals(arg0.getOldData())) {
                    return;
                }
                if (arg0.getData() == null && arg0.getSource().equals(SelectBillPlanRunUI.this.prmtStorageOrgUnit)) {
                    SelectBillPlanRunUI.this.prmtStorageOrgUnit.setValue(arg0.getOldData());
                    SelectBillPlanRunUI.this.prmtStorageOrgUnit.requestFocus(true);
                    arg0.setResult(0);
                    return;
                }
            }
        });
        this.kDTable1.getStyleAttributes().setLocked(true);
        this.kDTable1.getSelectManager().setSelectMode(2);
        this.prmtPlanVersion.setEnabled(false);
        this.btnDeleteRow.setEnabled(true);
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (storageOrgUnitInfo == null) {
            return;
        }
        String storageOrgUnitId = storageOrgUnitInfo.getId().toString();
        PlanVersionSetCollection planVersionSetInfo = this.getPlanVersionSetCollection(storageOrgUnitId);
        if (planVersionSetInfo == null || planVersionSetInfo.size() == 0) {
            MsgBox.showInfo((String)this.getResource("SELECTBILL_PLANVERSIONSET_ISNULL"));
            SysUtil.abort();
        }
        this.prmtPlanVersion.setValue((Object)planVersionSetInfo.get(0));
    }

    @Override
    protected void prmtPlanVersionChanged(DataChangeEvent e) {
    }

    private void setValueToTable(RequirementPlanCollection reqPlanCollection) throws Exception {
        RequirementPlanInfo reqPlanInfo = null;
        this.kDTable1.refresh();
        this.reqPlanIds.clear();
        for (int i = 0; i < reqPlanCollection.size(); ++i) {
            reqPlanInfo = reqPlanCollection.get(i);
            IRow reqPlanRow = this.kDTable1.addRow();
            reqPlanRow.setUserObject((Object)reqPlanInfo);
            if (!this.materils.contains(reqPlanInfo.getMaterial().getId().toString())) {
                this.materils.add(reqPlanInfo.getMaterial().getId().toString());
            }
            reqPlanRow.getCell("id").setValue((Object)reqPlanInfo.getId().toString());
            reqPlanRow.getCell("number").setValue((Object)reqPlanInfo.getNumber());
            reqPlanRow.getCell("material.number").setValue((Object)reqPlanInfo.getMaterial().getNumber());
            reqPlanRow.getCell("material.name").setValue((Object)reqPlanInfo.getMaterial().getName());
            reqPlanRow.getCell("material.mode").setValue((Object)reqPlanInfo.getMaterial().getModel());
            reqPlanRow.getCell("unit").setValue((Object)reqPlanInfo.getUnit());
            reqPlanRow.getCell("qty").setValue((Object)reqPlanInfo.getQty());
            reqPlanRow.getCell("cntactTotalQty").setValue((Object)(reqPlanInfo.getCntactTotalQty().compareTo(new BigDecimal("0.00")) == 0 ? null : reqPlanInfo.getCntactTotalQty()));
            reqPlanRow.getCell("requireDate").setValue((Object)reqPlanInfo.getRequireDate());
            reqPlanRow.getCell("reqType").setValue(reqPlanInfo.getReqType() != null ? reqPlanInfo.getReqType().getNumber() : null);
            reqPlanRow.getCell("reqSource").setValue((Object)reqPlanInfo.getReqSource());
            reqPlanRow.getCell("project").setValue(reqPlanInfo.getProject() != null ? reqPlanInfo.getProject().getNumber() : null);
            reqPlanRow.getCell("trackNumber").setValue(reqPlanInfo.getTrackNumber() != null ? reqPlanInfo.getTrackNumber().getNumber() : null);
            reqPlanRow.getCell("billType").setValue((Object)reqPlanInfo.getBillType());
            reqPlanRow.getCell("sourceBillNum").setValue((Object)reqPlanInfo.getSourceBillNum());
            reqPlanRow.getCell("sourceEntrySeq").setValue((Object)(reqPlanInfo.getSourceEntrySeq() == 0 ? null : new Integer(reqPlanInfo.getSourceEntrySeq())));
            reqPlanRow.getCell("productionDept").setValue(reqPlanInfo.getProductionDept() != null ? reqPlanInfo.getProductionDept().getName() : null);
            reqPlanRow.getCell("planner").setValue(reqPlanInfo.getPlanner() != null ? reqPlanInfo.getPlanner().getName() : null);
            reqPlanRow.getCell("calcaulationDate").setValue((Object)reqPlanInfo.getCalculateTime());
            this.reqPlanIds.add(reqPlanInfo.getId().toString());
        }
    }

    private IPlanVersionSet getPlanVersionSetInterface() throws Exception {
        return PlanVersionSetFactory.getRemoteInstanceWithObjectContext((Context)this.getUserContext());
    }

    private IRequirementPlan getRequirementPlanInterface() throws Exception {
        return RequirementPlanFactory.getRemoteInstanceWithObjectContext(this.getUserContext());
    }

    private String getResource(String resourceName) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource", (String)resourceName);
    }

    private RequirementPlanCollection getRequirementPlan(List reqPlanIds) throws Exception {
        RequirementPlanCollection reqPlanCollection = null;
        HashSet reqPlanIdsSet = new HashSet();
        reqPlanIdsSet.addAll(reqPlanIds);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", reqPlanIdsSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("reqType.number", (Object)"PRD", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)ReqPlanStatusEnum.ACTIVE, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selector = entityViewInfo.getSelector();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("material.number"));
        selector.add(new SelectorItemInfo("material.id"));
        selector.add(new SelectorItemInfo("material.name"));
        selector.add(new SelectorItemInfo("material.model"));
        selector.add(new SelectorItemInfo("unit.name"));
        selector.add(new SelectorItemInfo("reqType.number"));
        selector.add(new SelectorItemInfo("project.number"));
        selector.add(new SelectorItemInfo("trackNumber.number"));
        selector.add(new SelectorItemInfo("billType.name"));
        selector.add(new SelectorItemInfo("productionDept.name"));
        selector.add(new SelectorItemInfo("planner.name"));
        reqPlanCollection = this.getRequirementPlanInterface().getRequirementPlanCollection(entityViewInfo);
        return reqPlanCollection;
    }

    private PlanVersionSetCollection getPlanVersionSetCollection(String storageOrgUnitId) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.Id", (Object)storageOrgUnitId));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"903"));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20)));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selector = entityViewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("status"));
        PlanVersionSetCollection planVersionSetInfo = null;
        try {
            planVersionSetInfo = this.getPlanVersionSetInterface().getPlanVersionSetCollection(entityViewInfo);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return planVersionSetInfo;
    }

    private void removeCalculatedReqPlan() {
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            if (this.kDTable1.getRow(i).getCell("calcaulationDate").getValue() == null) continue;
            this.unCalcReqPlanIds.remove(this.kDTable1.getRow(i).getCell("id").getValue());
        }
    }
}

