/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.client.AbstractSimulantPlanOrderListUI;
import com.kingdee.eas.mm.planning.client.PlannedOrderEditUI;
import com.kingdee.eas.mm.planning.client.SimulantPlanOrderFilterUI;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class SimulantPlanOrderListUI
extends AbstractSimulantPlanOrderListUI {
    private static final Logger logger = CoreUIObject.getLogger(SimulantPlanOrderListUI.class);
    private static final String[] KDT_DATES = new String[]{"startDate", "endDate"};
    private CommonQueryDialog commonQueryDialog;

    public void onLoad() throws Exception {
        super.onLoad();
        this.MenuService.setVisible(false);
        this.btnQuery.setTextIconDisStyle((short)3);
        this.btnQuery.setText(this.getResource("BTN_QUERY"));
    }

    public void onShow() throws Exception {
        super.onShow();
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])KDT_DATES);
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    protected ISCMFilter getFilterUI() throws Exception {
        return new SimulantPlanOrderFilterUI();
    }

    protected String getEditUIName() {
        return PlannedOrderEditUI.class.getName();
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Storage)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PlannedOrderFactory.getRemoteInstanceWithObjectContext(this.getUserContext());
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        this.commonQueryDialog = super.initCommonQueryDialog();
        this.commonQueryDialog.setOwner((Component)((Object)this));
        this.commonQueryDialog.setWidth(460);
        this.commonQueryDialog.setHeight(360);
        OrgUnitCollection authorizedMainOrgs = new OrgUnitCollection();
        try {
            ISCMFilter iFilter = this.getFilterUI();
            iFilter.setContextObject((Object)this.getUIContext());
            authorizedMainOrgs.add((OrgUnitInfo)((StorageOrgUnitInfo)this.getUIContext().get("storageOrgUnit")));
            iFilter.setAuthorizedMainOrgs(authorizedMainOrgs);
            this.commonQueryDialog.addUserPanel((KDPanel)iFilter);
            this.commonQueryDialog.setShowFilter(false);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setUiObject(null);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return this.commonQueryDialog;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
        if (ev.getFilter() == null) {
            ev.setFilter(new FilterInfo());
        }
        FilterItemCollection filters = ev.getFilter().getFilterItems();
        for (int i = 0; i < filters.size(); ++i) {
            if (!filters.get(i).getPropertyName().equalsIgnoreCase("baseStatus")) continue;
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4)));
        try {
            ev.getFilter().mergeFilter(filterInfo, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        filterInfo.getFilterItems().add(new FilterItemInfo("isSimulant", (Object)new Integer(1), CompareType.EQUALS));
        PlanVersionSetInfo pvInfo = (PlanVersionSetInfo)this.getUIContext().get("planVersionSetInfo");
        String pvInfoId = pvInfo.getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)pvInfoId, CompareType.EQUALS));
        return filterInfo;
    }

    public boolean handleDynQuery(EntityViewInfo ev, boolean returnVal) throws Exception {
        super.handleDynQuery(ev, returnVal);
        return false;
    }

    @Override
    public void actionTransformInBatch_actionPerformed(ActionEvent e) throws Exception {
        boolean isDeleteSimulantPlanOrder = false;
        ArrayList selectList = this.getSelectedIdValues();
        if (selectList.size() == 0) {
            MsgBox.showInfo((String)this.getResource("PLEASE_SELECT_BILL"));
            SysUtil.abort();
        }
        PlanVersionSetInfo planVersionSetInfo = (PlanVersionSetInfo)this.getUIContext().get("planVersionSetInfo");
        String confirmMsg = MessageFormat.format(this.getResource("WILL_DELETE_SINULANT_PLANORDER"), planVersionSetInfo.getNumber());
        int confirmResult = MsgBox.showConfirm3((String)confirmMsg);
        if (confirmResult == 0) {
            isDeleteSimulantPlanOrder = true;
        }
        if (confirmResult == 2) {
            return;
        }
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.getUIContext().get("storageOrgUnit");
        Map errorMap = PlannedOrderFactory.getRemoteInstanceWithObjectContext(this.getUserContext()).transformInBatch(storageOrgUnit.getId().toString(), selectList, planVersionSetInfo.getId().toString(), isDeleteSimulantPlanOrder);
        if (errorMap.size() > 0) {
            String errorMsg = MessageFormat.format(this.getResource("SIMULANT_TRANSFER_ERROR"), new Integer(selectList.size()), new Integer(errorMap.size()));
            String seperator = "     ";
            StringBuffer detailMsg = new StringBuffer(this.getResource("BILLNUMBER_AND_FAILREASON"));
            detailMsg.append("\n");
            for (String key : errorMap.keySet()) {
                detailMsg.append(key).append(seperator).append(errorMap.get(key)).append("\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)errorMsg, (String)detailMsg.toString(), (int)0);
        } else {
            MsgBox.showInfo((String)this.getResource("TRANSFORM_SUCCESS"));
        }
        this.refreshList();
    }

    private String getResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.PlannedOrderResource", (String)sKey);
    }
}

