/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.mm.common.client.tableutils.DeducedValueUtil;
import com.kingdee.eas.mm.common.client.tableutils.DetailObject;
import com.kingdee.eas.mm.common.client.tableutils.DynamicColumn;
import com.kingdee.eas.mm.common.client.tableutils.DynamicColumnMap;
import com.kingdee.eas.mm.common.client.tableutils.DynamicEditTable;
import com.kingdee.eas.mm.common.client.tableutils.DynamicFields;
import com.kingdee.eas.mm.common.client.tableutils.DynamicLeftHeader;
import com.kingdee.eas.mm.common.client.tableutils.DynamicStyleEnum;
import com.kingdee.eas.mm.common.client.tableutils.FieldDefinition;
import com.kingdee.eas.mm.common.client.tableutils.LeftHeaderObject;
import com.kingdee.eas.mm.common.client.tableutils.RowChangeInfo;
import com.kingdee.eas.mm.planning.BalanceProdStrategy;
import com.kingdee.eas.mm.planning.EnsureTargetInvStrategy;
import com.kingdee.eas.mm.planning.ISOPCheckFormula;
import com.kingdee.eas.mm.planning.ISOPFacade;
import com.kingdee.eas.mm.planning.ISOPPermissionFacade;
import com.kingdee.eas.mm.planning.SOPCheckFormulaFactory;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPException;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.SOPPermissionFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPlanVersionInfo;
import com.kingdee.eas.mm.planning.SOPPlannedTypeEnum;
import com.kingdee.eas.mm.planning.SOPProductPlanPolicyEnum;
import com.kingdee.eas.mm.planning.SOPProductPlanPolicyFacadeFactory;
import com.kingdee.eas.mm.planning.SopDeducedInventroy;
import com.kingdee.eas.mm.planning.SopPlanConst;
import com.kingdee.eas.mm.planning.SopProdPlanStrategy;
import com.kingdee.eas.mm.planning.SyncWithSalesStrategy;
import com.kingdee.eas.mm.planning.ZeroInventoryStrategy;
import com.kingdee.eas.mm.planning.client.AbstractSopPlanEditUI;
import com.kingdee.eas.mm.planning.client.PlanAddNewMaterialDialog;
import com.kingdee.eas.mm.planning.client.SOPAddnewFilterUI;
import com.kingdee.eas.mm.planning.client.SOPCheckFormulaListUI;
import com.kingdee.eas.mm.planning.client.SOPDisplaySetUI;
import com.kingdee.eas.mm.planning.client.SOPFilterUI;
import com.kingdee.eas.mm.planning.client.SOPProductPlanPolicyUI;
import com.kingdee.eas.mm.planning.util.SOPUtil;
import com.kingdee.eas.scm.common.client.MaterialQueryListUI;
import com.kingdee.eas.scm.common.client.SCMBillFilterUI;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class SopPlanEditUI
extends AbstractSopPlanEditUI
implements KDTPropertyChangeListener {
    public static final String strResource = "com.kingdee.eas.mm.planning.client.SOPPlanVersionResource.";
    private static final Logger logger = CoreUIObject.getLogger(SopPlanEditUI.class);
    private DynamicEditTable tblManager;
    private boolean isFromEditMenu = false;
    private SOPPeriod periodHidedAbs = null;
    private SOPEditModeEnum editMode;
    private SOPPlannedTypeEnum planType;
    private Map matId2Bop = new HashMap();
    private Map changedRows = new HashMap();
    private boolean isEditing;
    private String storageOrgUnitId;
    private String storageOrgUnitName;
    private List supplyOrgUnitId;
    private StorageOrgUnitInfo supplyOrgUnitInfo;
    private String planVersionId;
    private String planVersionName;
    private String planVersionNumber;
    private String materialNumberFrom;
    private String materialNumberTo;
    private boolean planVersionActivated;
    private boolean isGlodAddNewMaterials;
    private SOPPeriod curPeriod;
    private SOPPeriod periodFrom;
    private int numOfPeriod;
    private SOPPeriod[] periodRange;
    private Map colKey2PeriodMap;
    private CommonQueryDialog dlgEdit;
    private CommonQueryDialog dlgQuery;
    private CustomerQueryPanel editPanel;
    private CustomerQueryPanel queryPanel;
    private CustomerQueryPanel filterPanel;
    private boolean displayDateInCaption = false;
    private boolean hideHistoryPeriods = false;
    private boolean hideSales = false;
    private boolean hideProdTheory = false;
    private boolean hideProduction = false;
    private boolean hideTargetInv = false;
    private boolean hideInv = false;
    private static String bopColKey = "BOPBalance";
    private int bopColIndex = 11;
    private static final String VIEW_SALE_PERMISSION = "mm_sopsaleplan_view";
    private static final String VIEW_PRODUCT_PERMISSION = "mm_sopprodplan_view";
    private static final String EDIT_SALE_PERMISSION = "mm_sopsaleplan_edit";
    private static final String EDIT_PRODUCT_PERMISSION = "mm_sopprodplan_edit";
    private static final String TRANSFER_PERMISSION = "mm_soptransfer";
    private boolean hasViewSalesPermission = false;
    private boolean hasViewProdPermission = false;
    private boolean hasEditSalesPermission = false;
    private boolean hasEditProdPermission = false;
    private boolean hasTransferPermission = false;
    private BigDecimal ZERO = new BigDecimal("0.0");
    private static Color lockedColor = new Color(238, 250, 255);
    private static Color defaultColor = new Color(255, 255, 255);
    private boolean isCancel = false;
    private IUIWindow materialWindow = null;
    String preFilterName = null;
    private Map rateMap = new HashMap();
    private Map precisionMap = new HashMap();
    Map storeStateMap = new HashMap();

    public Map getRateMap() {
        return this.rateMap;
    }

    public void setRateMap(Map rateMap) {
        this.rateMap = rateMap;
    }

    public Map getPrecisionMap() {
        return this.precisionMap;
    }

    public void setPrecisionMap(Map precisionMap) {
        this.precisionMap = precisionMap;
    }

    public SopPlanEditUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.storeStateMap.put("1", "181875d5-0105-1000-e000-012ec0a812fd62A73FA5");
        this.storeStateMap.put("201", "1z4PVQEPEADgAAFSwKg9BWKnP6U=");
        this.storeStateMap.put("202", "1z20BwEPEADgAAFxwKg9BWKnP6U=");
        this.storeStateMap.put("203", "wWRyhKt0Reum9XN9RNW9Z2KnP6U=");
        this.storeStateMap.put("301", "181875d5-1105-1000-e000-013dc0a812fd62A73FA5");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public IRowSet retrieveSopPlan() throws EASBizException {
        IRowSet rs = null;
        return rs;
    }

    public void drawAndFillTable(IRowSet rs) {
        if (rs == null || rs.size() > 0) {
            // empty if block
        }
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        if (this.saveDataFirst()) {
            super.actionExitCurrent_actionPerformed(e);
        }
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    private DynamicLeftHeader getDynamicHeader() {
        DynamicLeftHeader dynHeader = new DynamicLeftHeader("FMatStorageIds");
        dynHeader.addFieldName("FMatStorageIds");
        dynHeader.addFieldName("FStorageId");
        dynHeader.addFieldName("FMatId");
        dynHeader.addFieldName("FDaysPlanTurnover");
        dynHeader.addFieldName("FExecutOrg");
        dynHeader.addFieldName("FMatNumber");
        dynHeader.addFieldName("FMatName");
        dynHeader.addFieldName("FMatModel");
        dynHeader.addFieldName("FBaseUnit");
        dynHeader.setPrecisionField("FQtyPrecision");
        return dynHeader;
    }

    private DynamicFields getDynamicFields() {
        DynamicFields dynFields = new DynamicFields();
        dynFields.setParentField("FMatStorageIds");
        dynFields.setKeyField("FDisplayPeriod");
        dynFields.addFieldInfo("FSalesQty", EASResource.getString((String)"com.kingdee.eas.mm.planning.client.SOPPlanVersionResource.SOP_PLAN_TYPE_SALES"), false, this.hideSales, true);
        dynFields.addFieldInfo("FProdTheoryQty", EASResource.getString((String)"com.kingdee.eas.mm.planning.client.SOPPlanVersionResource.SOP_PLAN_TYPE_PROD_THEORY"), false, this.hideProdTheory, true);
        dynFields.addFieldInfo("FProductionQty", EASResource.getString((String)"com.kingdee.eas.mm.planning.client.SOPPlanVersionResource.SOP_PLAN_TYPE_PRODUCTION"), false, this.hideProduction, true);
        dynFields.addFieldInfo("FTargetInvQty", EASResource.getString((String)"com.kingdee.eas.mm.planning.client.SOPPlanVersionResource.SOP_PLAN_TYPE_TARGET_INV"), false, this.hideTargetInv, false);
        dynFields.addFieldInfo("FInvQty", EASResource.getString((String)"com.kingdee.eas.mm.planning.client.SOPPlanVersionResource.SOP_PLAN_TYPE_INV"), true, this.hideInv, false);
        return dynFields;
    }

    private void switchUITitle() {
        String prefix = EASResource.getString((String)"com.kingdee.eas.mm.planning.client.SOPPlanVersionResource.SOP");
        String suffix = null;
        suffix = this.isEditing ? EASResource.getString((String)"com.kingdee.eas.mm.planning.client.SOPPlanVersionResource.SOP_EDIT") : EASResource.getString((String)"com.kingdee.eas.mm.planning.client.SOPPlanVersionResource.SOP_QUERY");
        this.setUITitle(prefix + suffix);
    }

    public void onLoad() throws Exception {
        String strParam = (String)this.getUIContext().get("UIClassParam");
        if (strParam.equalsIgnoreCase("EDIT")) {
            this.isFromEditMenu = true;
        }
        this.isEditing = this.isFromEditMenu;
        this.storageOrgUnitId = SopPlanConst.getStorageUnitOrg4Test();
        this.tblManager = new DynamicEditTable(this.tblMain, true);
        this.tblManager.setSumFieldCaption(EASResource.getString((String)"com.kingdee.eas.mm.planning.client.SOPPlanVersionResource.SUM_UP"));
        this.tblManager.setFieldTypeCaption(EASResource.getString((String)"com.kingdee.eas.mm.planning.client.SOPPlanVersionResource.SOP_PLAN_TYPE"));
        this.switchUITitle();
        this.tblManager.setDynamicStyle(DynamicStyleEnum.ROW);
        this.tblManager.initTable(this.getDynamicHeader(), this.getDynamicFields(), (DeducedValueUtil)new SopDeducedInventroy());
        this.tblMain.getGroupManager().setGroup(true);
        super.onLoad();
        this.btnCopyPlan.setVisible(false);
        this.btnCurInventory.setVisible(true);
        this.actionCurInventory.setEnabled(true);
        this.tblMain.getActionMap().remove("Copy");
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Cut");
        this.tblMain.getActionMap().remove("Delete");
        this.menuItemQuery.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.menuItemSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.menuItemEdit.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.adjustUI();
        IObjectPK pk = LogUtil.beginLog(null, (String)this.getUITitle(), (BOSObjectType)new BOSObjectType("63D23A66"), null, (String)this.getUITitle());
        LogUtil.afterLog(null, (IObjectPK)pk);
        this.btnConstraintCheck.setIcon(EASResource.getIcon((String)"imgTbtn_prolinedistribute"));
        this.btnDefineConstraints.setIcon(EASResource.getIcon((String)"imgTbtn_prodistribute"));
        this.menuItemTransfer.setIcon(EASResource.getIcon((String)"imgTbtn_post"));
        this.menuItemConstraintCheck.setIcon(EASResource.getIcon((String)"imgTbtn_prolinedistribute"));
        this.menuItemDefineConstraints.setIcon(EASResource.getIcon((String)"imgTbtn_prodistribute"));
        this.menuItemTransferLog.setIcon(EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
    }

    private IRowSet fetchMaterials(SOPPeriod periodFrom, SOPPeriod periodTo, ArrayList storageOrgIds, ArrayList materialIds) throws BOSException, EASBizException {
        ISOPFacade sop = SOPFacadeFactory.getRemoteInstance();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("org", this.storageOrgUnitId);
        map.put("planVersion", this.planVersionId);
        map.put("isEditing", this.isEditing);
        map.put("materials", materialIds);
        map.put("executStorageOrg", storageOrgIds);
        map.put("supplyOrgUnitId", this.supplyOrgUnitId);
        if (this.materialNumberFrom != null) {
            map.put("matFrom", this.materialNumberFrom);
        }
        if (this.materialNumberTo != null) {
            map.put("matTo", this.materialNumberTo);
        }
        IRowSet rs = sop.getMaterial(map);
        return rs;
    }

    private Map fetchSopSalesPlan(SOPPeriod period, Set matIdSet) throws BOSException, EASBizException, SQLException {
        ISOPFacade sop = SOPFacadeFactory.getRemoteInstance();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map storageMatIds = this.getStorageMatIds(matIdSet);
        map.put("org", this.storageOrgUnitId);
        map.put("planVersion", this.planVersionId);
        map.put("sopeditmode", (Object)this.editMode);
        map.put("periodFrom", new Integer(period.toNumber()));
        map.put("materials", matIdSet);
        map.put("matStorageIds", storageMatIds);
        if (this.materialNumberFrom != null) {
            map.put("matFrom", this.materialNumberFrom);
        }
        if (this.materialNumberTo != null) {
            map.put("matTo", this.materialNumberTo);
        }
        IRowSet rs = sop.getSopSalesPlan(map);
        HashMap<String, BigDecimal> id2sales = new HashMap<String, BigDecimal>();
        while (rs.next()) {
            id2sales.put(rs.getString("FMatId"), rs.getBigDecimal("FSalesQty"));
        }
        return id2sales;
    }

    private IRowSet fetchSopPlan(SOPPeriod periodFrom, SOPPeriod periodTo, ArrayList storageOrgIds, ArrayList materialIds) throws BOSException, EASBizException {
        ISOPFacade sop = SOPFacadeFactory.getRemoteInstance();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("org", this.storageOrgUnitId);
        map.put("planVersion", this.planVersionId);
        if (this.materialNumberFrom != null) {
            map.put("matFrom", this.materialNumberFrom);
        }
        if (this.materialNumberTo != null) {
            map.put("matTo", this.materialNumberTo);
        }
        map.put("sopeditmode", (Object)this.editMode);
        map.put("periodFrom", new Integer(periodFrom.toNumber()));
        map.put("periodTo", new Integer(periodTo.toNumber()));
        map.put("materials", materialIds);
        map.put("executStorageOrg", storageOrgIds);
        map.put("isEditing", this.isEditing);
        IRowSet rs = sop.getSopPlan(map);
        return rs;
    }

    private void setBopEditableAndEditor() {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            ICell sumCell = this.tblManager.getSumCell(i);
            ICell bopCell = this.tblMain.getCell(i, bopColKey);
            boolean isInv = this.hasViewProdPermission && this.isInvRow(i);
            bopCell.getStyleAttributes().setLocked(!this.isEditing || !isInv);
            if (this.isEditing && isInv) {
                bopCell.getStyleAttributes().setBackground(defaultColor);
            } else {
                bopCell.getStyleAttributes().setBackground(lockedColor);
            }
            KDFormattedTextField bopEditor = (KDFormattedTextField)sumCell.getEditor().getComponent();
            bopEditor.setNegatived(true);
            bopCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)bopEditor));
            bopCell.getStyleAttributes().setNumberFormat(sumCell.getStyleAttributes().getNumberFormat());
        }
    }

    private void fillBopColumn() throws SQLException {
        if (this.hasViewProdPermission) {
            IRowSet rs = this.tblManager.getDynHeader().getRowSet();
            rs.beforeFirst();
            while (rs.next()) {
                String matId = rs.getString("FMatStorageIds");
                BigDecimal bop = rs.getBigDecimal("FBop");
                IRow row = this.tblManager.getRowFromHeadObjKey(matId);
                if (bop == null) continue;
                IRow invRow = this.tblMain.getRow(row.getRowIndex() + this.getInvOffset());
                invRow.getCell(this.bopColIndex).setValue((Object)bop);
                this.calcInventory(invRow);
            }
        }
    }

    private void insertBopBalance() {
        IColumn col = this.tblMain.addColumn(this.bopColIndex);
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        col.setKey(bopColKey);
        this.setBopEditableAndEditor();
        this.tblMain.getHeadRow(0).getCell(this.bopColIndex).setValue((Object)EASResource.getString((String)"com.kingdee.eas.mm.planning.client.SOPPlanVersionResource.BOP_BALANCE"));
    }

    private boolean getFilters(RptParams filters, boolean isParamsFromDefaultFilterSchema) {
        this.editMode = SOPEditModeEnum.getEnum(Integer.parseInt(filters.getString("sopeditmode")));
        this.planType = SOPPlannedTypeEnum.getEnum(Integer.parseInt(filters.getString("currentPlanType")));
        this.storageOrgUnitId = filters.getString("storageOrgUnit.id");
        this.storageOrgUnitName = filters.getString("storageOrgUnit.name");
        this.supplyOrgUnitId = (List)filters.getObject("supplyOrgUnit.number");
        this.planVersionId = filters.getString("planVersion.id");
        if (this.storageOrgUnitId == null || this.planVersionId == null) {
            return false;
        }
        this.planVersionName = filters.getString("planVersion.name");
        this.planVersionNumber = filters.getString("planVersion");
        this.planVersionActivated = filters.getBoolean("planVersion.isActivation");
        this.materialNumberFrom = filters.getString("matFrom");
        if (this.materialNumberFrom == null || this.materialNumberFrom.trim().length() == 0) {
            this.materialNumberFrom = null;
        }
        this.materialNumberTo = filters.getString("matTo");
        if (this.materialNumberTo == null || this.materialNumberTo.trim().length() == 0) {
            this.materialNumberTo = null;
        }
        try {
            this.getPermission(this.storageOrgUnitId);
            StorageOrgUnitInfo info = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.storageOrgUnitId));
            String[] orgUnit = new String[]{info.getName()};
            if (this.isEditing) {
                if (this.planType == SOPPlannedTypeEnum.PRODUCT_PLAN && !this.hasEditProdPermission) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)"NO_SOP_PRODUCTPLAN_EDIT_PERMISSION");
                    MessageFormat msgFmt = new MessageFormat(msg);
                    MsgBox.showError((String)msgFmt.format(orgUnit));
                    return false;
                }
                if (this.planType == SOPPlannedTypeEnum.SALEPLAN) {
                    if (!this.hasEditSalesPermission) {
                        String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)"NO_SOP_SALEPLAN_EDIT_PERMISSION");
                        MessageFormat msgFmt = new MessageFormat(msg);
                        MsgBox.showError((String)msgFmt.format(orgUnit));
                        return false;
                    }
                } else if (!(this.planType != SOPPlannedTypeEnum.SALE_PRODUCT_PLAN || this.hasEditSalesPermission && this.hasEditProdPermission)) {
                    if (!this.hasEditSalesPermission && this.hasEditProdPermission) {
                        String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)"NO_SOP_SALEPLAN_EDIT_PERMISSION");
                        MessageFormat msgFmt = new MessageFormat(msg);
                        MsgBox.showError((String)msgFmt.format(orgUnit));
                        return false;
                    }
                    if (!this.hasEditProdPermission && this.hasEditSalesPermission) {
                        String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)"NO_SOP_PRODUCTPLAN_EDIT_PERMISSION");
                        MessageFormat msgFmt = new MessageFormat(msg);
                        MsgBox.showError((String)msgFmt.format(orgUnit));
                        return false;
                    }
                    String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)"NO_SOP_PRODUCTPLAN_AND_SALEPLAN_EDIT_PERMISSION");
                    MessageFormat msgFmt = new MessageFormat(msg);
                    MsgBox.showError((String)msgFmt.format(orgUnit));
                    return false;
                }
            } else {
                if (this.planType == SOPPlannedTypeEnum.PRODUCT_PLAN && !this.hasViewProdPermission) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)"NO_SOP_PRODUCTPLAN_VIEW_PERMISSION");
                    MessageFormat msgFmt = new MessageFormat(msg);
                    MsgBox.showError((String)msgFmt.format(orgUnit));
                    return false;
                }
                if (this.planType == SOPPlannedTypeEnum.SALEPLAN) {
                    if (!this.hasViewSalesPermission) {
                        String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)"NO_SOP_SALEPLAN_VIEW_PERMISSION");
                        MessageFormat msgFmt = new MessageFormat(msg);
                        MsgBox.showError((String)msgFmt.format(orgUnit));
                        return false;
                    }
                } else if (!(this.planType != SOPPlannedTypeEnum.SALE_PRODUCT_PLAN || this.hasViewSalesPermission && this.hasViewProdPermission)) {
                    if (!this.hasViewSalesPermission && this.hasViewProdPermission) {
                        String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)"NO_SOP_SALEPLAN_VIEW_PERMISSION");
                        MessageFormat msgFmt = new MessageFormat(msg);
                        MsgBox.showError((String)msgFmt.format(orgUnit));
                        return false;
                    }
                    if (!this.hasViewProdPermission && this.hasViewSalesPermission) {
                        String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)"NO_SOP_PRODUCTPLAN_VIEW_PERMISSION");
                        MessageFormat msgFmt = new MessageFormat(msg);
                        MsgBox.showError((String)msgFmt.format(orgUnit));
                        return false;
                    }
                    String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)"NO_SOP_PRODUCTPLAN_AND_SALEPLAN_VIEW_PERMISSION");
                    MessageFormat msgFmt = new MessageFormat(msg);
                    MsgBox.showError((String)msgFmt.format(orgUnit));
                    return false;
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.curPeriod = new SOPPeriod();
        this.curPeriod.setBeginDate((Calendar)filters.getObject("curPeriod.beginDate"));
        this.curPeriod.setEndDate((Calendar)filters.getObject("curPeriod.endDate"));
        this.curPeriod.setYear(filters.getInt("curPeriod.year"));
        this.curPeriod.setNumber(filters.getInt("curPeriod.number"));
        this.curPeriod.setType(this.editMode);
        this.curPeriod.setParamMonthStartDay(filters.getInt("curPeriod.paramMonthStartDay"));
        if (!this.isEditing) {
            this.periodFrom = new SOPPeriod();
            this.periodFrom.setBeginDate((Calendar)filters.getObject("selectePeriod.beginDate"));
            this.periodFrom.setEndDate((Calendar)filters.getObject("selectePeriod.endDate"));
            this.periodFrom.setYear(filters.getInt("selectePeriod.year"));
            this.periodFrom.setNumber(filters.getInt("selectePeriod.number"));
            this.periodFrom.setType(this.editMode);
            this.periodFrom.setParamMonthStartDay(filters.getInt("selectePeriod.paramMonthStartDay"));
        } else {
            this.periodFrom = this.curPeriod;
        }
        this.numOfPeriod = filters.getInt("numOfPeriod");
        this.periodRange = this.periodFrom.forwardPeriods(this.numOfPeriod);
        if (this.periodFrom.toNumber() > this.curPeriod.toNumber()) {
            List periodList = this.curPeriod.forwardPeriods(this.periodRange[this.periodRange.length - 1].getEndDate());
            this.periodRange = SOPPeriod.list2Array(periodList);
        }
        this.constructColumnKey2PeriodMap();
        if (this.planType == SOPPlannedTypeEnum.PRODUCT_PLAN) {
            this.hideProduction = false;
            this.hideProdTheory = false;
            this.hideTargetInv = false;
            this.hideInv = false;
            this.hideSales = false;
        } else if (this.planType == SOPPlannedTypeEnum.SALEPLAN) {
            this.hideProduction = true;
            this.hideProdTheory = true;
            this.hideTargetInv = true;
            this.hideInv = true;
            this.hideSales = false;
        } else {
            this.hideProduction = false;
            this.hideProdTheory = false;
            this.hideTargetInv = false;
            this.hideInv = false;
            this.hideSales = false;
        }
        return true;
    }

    private void fillHeadUI() {
        this.txtPlanVersionNumber.setText(this.planVersionNumber);
        this.txtPlanVersionDesc.setText(this.planVersionName);
        this.cbActivated.getModel().setSelected(this.planVersionActivated);
        this.txtStorage.setText(this.storageOrgUnitName);
        if (this.periodRange != null && this.periodRange.length > 0) {
            String endPeriod = this.periodRange[this.periodRange.length - 1].toString();
            String beginPeriod = this.periodFrom.toString();
            this.txtBeginPeriod.setText(beginPeriod + "~" + endPeriod);
        }
        if (this.planType != null) {
            this.txtPlanType.removeAllItems();
        }
        this.txtPlanType.addItem((Object)this.planType);
    }

    private void executeQuery(boolean isAddNewMaterials, ArrayList storageOrgIds, ArrayList materialIds) throws Exception {
        this.listen4UpdateChanges(false);
        IRowSet rsMat = null;
        IRowSet rsPlan = null;
        if (!isAddNewMaterials) {
            this.initDynamicColumnMap(this.editMode, this.periodFrom, this.numOfPeriod);
        }
        if (this.periodFrom.toNumber() > this.curPeriod.toNumber()) {
            this.initRateAndPrecision(this.curPeriod, null, storageOrgIds, materialIds);
            rsMat = this.fetchMaterials(this.curPeriod, null, storageOrgIds, materialIds);
            rsPlan = this.fetchSopPlan(this.curPeriod, this.periodRange[this.periodRange.length - 1], storageOrgIds, materialIds);
        } else {
            this.initRateAndPrecision(this.periodFrom, null, storageOrgIds, materialIds);
            rsMat = this.fetchMaterials(this.periodFrom, null, storageOrgIds, materialIds);
            rsPlan = this.fetchSopPlan(this.periodFrom, this.periodRange[this.periodRange.length - 1], storageOrgIds, materialIds);
        }
        this.tblManager.getDynHeader().setRowSet(rsMat);
        if (isAddNewMaterials) {
            if (this.isEditing) {
                this.releaseMutexMat();
            }
            this.isGlodAddNewMaterials = isAddNewMaterials;
            this.tblManager.appendData(rsPlan);
        } else {
            this.loadDynamicObject(this.isEditing, rsPlan);
        }
        this.setViewAppearance(true);
        this.tblManager.fillTableWithDynamicData();
        this.setViewAppearance(false);
        if (!isAddNewMaterials) {
            this.insertBopBalance();
        } else {
            this.setBopEditableAndEditor();
        }
        this.tblMain.getViewManager().setFreezeView(0, 11);
        this.fillBopColumn();
        this.listen4UpdateChanges(true);
        if (this.isEditing && !isAddNewMaterials) {
            this.requestMutexMat();
        }
    }

    private void listen4UpdateChanges(boolean start2Listen) {
        if (start2Listen) {
            if (this.hasEditProdPermission || this.hasEditSalesPermission) {
                this.tblMain.addKDTPropertyChangeListener((KDTPropertyChangeListener)this);
            }
        } else {
            this.tblMain.removeKDTPropertyChangeListener((KDTPropertyChangeListener)this);
        }
    }

    private void loadDynamicObject(boolean isDynColumnsReady, IRowSet rs) throws BOSException, SQLException {
        this.tblManager.loadDataAndFillTable(false, rs);
    }

    private void initDynamicColumnMap(SOPEditModeEnum editMode, SOPPeriod curPeriod, int horizon) {
        DynamicColumnMap dynColMap = new DynamicColumnMap();
        for (int i = 0; i < this.periodRange.length; ++i) {
            DynamicColumn info = new DynamicColumn();
            String key = Integer.toString(this.periodRange[i].toNumber());
            info.setKey(key);
            info.setCaption(this.periodRange[i].toString());
            if (this.periodRange[i].toNumber() < curPeriod.toNumber() && this.hideHistoryPeriods) {
                info.setHide(this.hideHistoryPeriods);
            } else {
                info.setHide(false);
            }
            dynColMap.add(info);
        }
        this.tblManager.setDynamicColumnMap(dynColMap);
    }

    private String getDynamicColumnCaption(DynamicColumn col) {
        String caption = "";
        for (int i = 0; i < this.periodRange.length; ++i) {
            String key = Integer.toString(this.periodRange[i].toNumber());
            if (!key.equals(col.getKey())) continue;
            caption = this.displayDateInCaption && this.editMode.getValue() == 10 ? this.periodRange[i].toRangeString() : this.periodRange[i].toString();
        }
        return caption;
    }

    private void setPeriodAttribute(boolean isHide) {
        int i;
        SOPPeriod periodToBeHided = null;
        for (i = this.periodRange.length - 1; i >= 0; --i) {
            if (this.periodRange[i].toNumber() >= this.curPeriod.toNumber()) continue;
            periodToBeHided = this.periodRange[i];
            break;
        }
        if (this.curPeriod.toNumber() <= this.periodFrom.toNumber()) {
            i = 0;
            while (this.periodFrom.toNumber() != this.periodRange[i].toNumber()) {
                ++i;
            }
            this.periodHidedAbs = this.periodRange[i];
        } else {
            this.periodHidedAbs = this.periodFrom;
        }
        Set colSet = this.tblManager.getDynColumns().entrySet();
        Iterator it = colSet.iterator();
        while (it.hasNext()) {
            DynamicColumn col = (DynamicColumn)((Map.Entry)it.next()).getValue();
            if (periodToBeHided != null && col.getKey().compareTo(Integer.toString(periodToBeHided.toNumber())) <= 0) {
                col.setHide(isHide);
                col.setLock(true);
            }
            if (this.periodHidedAbs != null && col.getKey().compareTo(Integer.toString(this.periodHidedAbs.toNumber())) < 0) {
                col.setHide(true);
            }
            col.setCaption(this.getDynamicColumnCaption(col));
        }
    }

    private int getMaterialPrecision(String matId) {
        LeftHeaderObject headObj = (LeftHeaderObject)this.tblManager.getMapData().get(matId);
        int precision = 0;
        if (headObj != null) {
            precision = headObj.getDefaultPrecision();
        }
        return precision;
    }

    private int getColumnIndex4Period(SOPPeriod period) {
        boolean index = false;
        String key = "" + period.toNumber();
        return this.tblMain.getColumnIndex(key);
    }

    private SOPPeriod getMaxPeriodDisplayed() {
        SOPPeriod period = null;
        if (this.tblMain.getColumnCount() > this.tblManager.getDynHeader().getFieldsCount() + 2) {
            String lastPeriodCaption = (String)this.tblMain.getHeadRow(0).getCell(this.tblMain.getColumnCount() - 1).getValue();
            for (int i = this.periodRange.length; i > 0; --i) {
                if (!this.periodRange[i - 1].toString().equals(lastPeriodCaption)) continue;
                period = this.periodRange[i - 1];
                break;
            }
        }
        return period;
    }

    private boolean isViewProdPlan() {
        return this.planType == SOPPlannedTypeEnum.PRODUCT_PLAN || this.planType == SOPPlannedTypeEnum.SALE_PRODUCT_PLAN;
    }

    private void setViewAppearance(boolean hideWithPermissionOnly) {
        this.setPeriodAttribute(this.hideHistoryPeriods);
        DynamicFields fields = this.tblManager.getDynFields();
        boolean editSalesPlan = this.planType == SOPPlannedTypeEnum.SALEPLAN || this.planType == SOPPlannedTypeEnum.SALE_PRODUCT_PLAN;
        boolean viewProdPlan = this.isViewProdPlan();
        block7: for (int i = 0; i < fields.getFieldDefCount(); ++i) {
            FieldDefinition field = fields.getFieldDef(i);
            switch (i) {
                case 0: {
                    field.setFillTable(this.hasViewSalesPermission);
                    if (hideWithPermissionOnly) {
                        field.setHide(!this.hasViewSalesPermission);
                    } else {
                        field.setHide(this.hideSales || !this.hasViewSalesPermission);
                    }
                    field.setEditable(this.hasEditSalesPermission && this.isEditing && editSalesPlan);
                    continue block7;
                }
                case 1: {
                    field.setFillTable(this.hasViewProdPermission);
                    if (hideWithPermissionOnly) {
                        field.setHide(!this.hasViewProdPermission);
                    } else {
                        field.setHide(this.hideProdTheory || !this.hasViewProdPermission || !viewProdPlan);
                    }
                    field.setEditable(false);
                    continue block7;
                }
                case 2: {
                    field.setFillTable(this.hasViewProdPermission);
                    if (hideWithPermissionOnly) {
                        field.setHide(!this.hasViewProdPermission);
                    } else {
                        field.setHide(this.hideProduction || !this.hasViewProdPermission || !viewProdPlan);
                    }
                    field.setEditable(this.hasEditProdPermission && this.isEditing && viewProdPlan);
                    continue block7;
                }
                case 3: {
                    field.setFillTable(this.hasViewProdPermission);
                    if (hideWithPermissionOnly) {
                        field.setHide(!this.hasViewProdPermission);
                    } else {
                        field.setHide(this.hideTargetInv || !this.hasViewProdPermission || !viewProdPlan);
                    }
                    field.setEditable(this.hasEditProdPermission && this.isEditing && viewProdPlan);
                    continue block7;
                }
                case 4: {
                    field.setFillTable(this.hasViewProdPermission);
                    if (hideWithPermissionOnly) {
                        field.setHide(!this.hasViewProdPermission);
                    } else {
                        field.setHide(this.hideInv || !this.hasViewProdPermission || !viewProdPlan);
                    }
                    field.setEditable(false);
                }
            }
        }
        if (!hideWithPermissionOnly) {
            this.tblManager.changeViewAppearance();
        }
    }

    private void changeViewAppearance() {
        this.setViewAppearance(false);
        this.tblManager.changeViewAppearance();
    }

    public void onShow() throws Exception {
        this.tblMain.getViewManager().setFreezeView(-1, 11);
        super.onShow();
    }

    @Override
    public void actionStrategyAverage_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        this.applyProductionStrategy(new BalanceProdStrategy());
    }

    @Override
    public void actionStrategySynWithSales_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        this.applyProductionStrategy(new SyncWithSalesStrategy());
    }

    @Override
    public void actionStrategyTargetInv_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        this.applyProductionStrategy(new EnsureTargetInvStrategy());
    }

    @Override
    public void actionStrategyZeroInv_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        this.applyProductionStrategy(new ZeroInventoryStrategy());
    }

    private void applyProductionStrategy(SopProdPlanStrategy strategy) throws Exception {
        Map retVals;
        if (!this.saveDataFirst()) {
            return;
        }
        if (this.isCancel) {
            this.isCancel = false;
            this.abort();
        }
        if ((retVals = this.acquirePeriods((Object)strategy.getStrategyType())) == null) {
            return;
        }
        SOPPeriod period = (SOPPeriod)retVals.get("StartSOPPeriod");
        Integer num = (Integer)retVals.get("NumberOfTerm");
        Boolean apply2Prod2 = (Boolean)retVals.get("prodplan");
        int startColumn = this.getColumnIndex4Period(period);
        int count = num;
        count = Math.min(this.tblMain.getColumnCount() - startColumn, count);
        if (strategy instanceof BalanceProdStrategy) {
            int i;
            ISOPFacade sop = SOPFacadeFactory.getRemoteInstance();
            SOPPeriod[] range = new SOPPeriod[count];
            int matchedIndex = -1;
            for (i = 0; i < this.periodRange.length; ++i) {
                if (this.periodRange[i].toNumber() < period.toNumber()) continue;
                matchedIndex = i;
                break;
            }
            for (i = 0; i < count; ++i) {
                range[i] = this.periodRange[i + matchedIndex];
            }
            BigDecimal[] dayCounts = sop.getWorkDayCount(this.storageOrgUnitId, range);
            strategy.setWorkDays(dayCounts);
            logger.info((Object)("SOPPlanEdit: applyProductionStrategy, dayCounts=" + dayCounts));
        }
        Set matIds = this.getSelectedMaterials(true);
        this.listen4UpdateChanges(false);
        try {
            BigDecimal[] sales = new BigDecimal[count];
            BigDecimal[] targetInvs = new BigDecimal[count];
            for (String matId : matIds) {
                int precision = this.getMaterialPrecision(matId);
                IRow row = this.tblManager.getRowFromHeadObjKey(matId);
                IRow targetInvRow = this.tblMain.getRow(row.getRowIndex() + this.getTargetInvOffset());
                IRow prodTheoryRow = this.tblMain.getRow(row.getRowIndex() + this.getProdTheoryOffset());
                IRow prodRow = this.tblMain.getRow(row.getRowIndex() + this.getProdOffset());
                IRow invRow = this.tblMain.getRow(row.getRowIndex() + this.getInvOffset());
                for (int i = 0; i < count; ++i) {
                    int colIndex = i + startColumn;
                    sales[i] = (BigDecimal)row.getCell(colIndex).getValue();
                    targetInvs[i] = (BigDecimal)targetInvRow.getCell(colIndex).getValue();
                }
                int loopcount = Integer.parseInt(retVals.get("size").toString());
                BigDecimal bopInv = this.getbopInv(loopcount, row, prodTheoryRow, prodRow, invRow);
                BigDecimal[] prods = strategy.getProdPlan(sales, targetInvs, bopInv, precision);
                for (int i = 0; i < count; ++i) {
                    int colIndex = i + startColumn;
                    this.setCellValue(prodTheoryRow.getCell(colIndex), prods[i], true);
                    if (!apply2Prod2.equals(Boolean.TRUE)) continue;
                    this.setCellValue(prodRow.getCell(colIndex), prods[i], true);
                }
                this.updateSumValue(prodTheoryRow.getRowIndex());
                if (apply2Prod2.equals(Boolean.TRUE)) {
                    this.updateSumValue(prodRow.getRowIndex());
                }
                this.calcInventory(invRow);
            }
        }
        catch (Exception e1) {
            throw e1;
        }
        finally {
            this.listen4UpdateChanges(true);
        }
    }

    private void setCellValue(ICell cell, BigDecimal newValue, boolean bufferChanges) {
        BigDecimal oldValue = (BigDecimal)cell.getValue();
        cell.setValue((Object)newValue);
        if (bufferChanges) {
            this.bufferChanges(cell.getRowIndex(), cell.getColumnIndex(), oldValue, newValue);
        }
    }

    private void updateSumValue(int rowIndex) {
        ICell cell = this.tblManager.getSumCell(rowIndex);
        BigDecimal sum = this.ZERO;
        for (int i = this.bopColIndex + 1; i < this.tblMain.getColumnCount(); ++i) {
            BigDecimal value = (BigDecimal)this.tblMain.getCell(rowIndex, i).getValue();
            if (value == null) {
                value = this.ZERO;
            }
            sum = sum.add(value);
        }
        cell.setValue((Object)sum);
    }

    private void strategy(SOPProductPlanPolicyEnum SOPProductPlanPolicy) throws Exception {
        if (!this.saveDataFirst()) {
            return;
        }
        Map params = new HashMap();
        UIContext uiContext = this.showSOPProductPlanPolicyUI((Object)SOPProductPlanPolicy);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.mm.planning.client.SOPProductPlanPolicyUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        SOPProductPlanPolicyUI ui = (SOPProductPlanPolicyUI)uiWindow.getUIObject();
        Object period = ui.getUIContext().get("period");
        if (period == null) {
            return;
        }
        Map mPeriod = (Map)period;
        mPeriod.put("productPlanPolicy", SOPProductPlanPolicy);
        mPeriod.put("currentorgID", this.storageOrgUnitId);
        params = this.preDataForStrategy(mPeriod);
        Map productPlan = SOPProductPlanPolicyFacadeFactory.getRemoteInstance().Policy(params);
        this.saveDataOfStrategy(productPlan);
    }

    private Map acquirePeriods(Object titleOrStrategy) throws Exception {
        UIContext uiContext = null;
        if (titleOrStrategy instanceof String) {
            String dlgTitle = (String)titleOrStrategy;
            dlgTitle = dlgTitle.substring(0, dlgTitle.lastIndexOf("("));
            uiContext = this.showSOPProductPlanPolicyUI(dlgTitle);
        } else {
            uiContext = this.showSOPProductPlanPolicyUI(titleOrStrategy);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.mm.planning.client.SOPProductPlanPolicyUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        SOPProductPlanPolicyUI ui = (SOPProductPlanPolicyUI)uiWindow.getUIObject();
        Map retVals = (Map)ui.getUIContext().get("period");
        return retVals;
    }

    private UIContext showSOPProductPlanPolicyUI(Object obj) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        int numOfPeriod = 0;
        SOPPeriod startPeriod = this.curPeriod;
        SOPProductPlanPolicyEnum SOPProductPlanPolicy = SOPProductPlanPolicyEnum.EQUAL_TO_SALE;
        if (obj instanceof SOPProductPlanPolicyEnum) {
            SOPProductPlanPolicy = (SOPProductPlanPolicyEnum)((Object)obj);
        } else {
            uiContext.put((Object)"uititle", obj);
        }
        if (this.curPeriod.toNumber() < this.periodFrom.toNumber()) {
            startPeriod = this.periodFrom;
        }
        SOPPeriod endPeriod = this.getMaxPeriodDisplayed();
        int Start = this.getColumnIndex4Period(startPeriod);
        int end = this.tblMain.getColumnCount() - 1;
        numOfPeriod = end - Start + 1;
        uiContext.put((Object)"productPlanPolicy", (Object)SOPProductPlanPolicy);
        uiContext.put((Object)"storageOrgUnitIID", (Object)this.storageOrgUnitId);
        uiContext.put((Object)"curPeriod", (Object)this.curPeriod);
        uiContext.put((Object)"startPeriod", (Object)startPeriod);
        uiContext.put((Object)"numOfPeriod", (Object)new Integer(numOfPeriod));
        return uiContext;
    }

    private Map preDataForStrategy(Map period) throws Exception {
        int numOfPeriod = Integer.parseInt(period.get("NumberOfTerm").toString());
        SOPPeriod periodFrom = (SOPPeriod)period.get("StartSOPPeriod");
        String startPeriod = Integer.toString(periodFrom.toNumber());
        ArrayList salePlans = new ArrayList();
        ArrayList<Object> startInvertory = new ArrayList<Object>();
        ArrayList TargetInvertorys = new ArrayList();
        ArrayList<Integer> precisionList = new ArrayList<Integer>();
        ArrayList<BigDecimal> sumSalePlans = new ArrayList<BigDecimal>();
        DynamicColumn start = this.tblManager.getDynColumns().get(startPeriod);
        int planTypeIdx = this.tblMain.getColumnIndex(start.getKey());
        Map selected = this.getSelectedRowIndex();
        List indexSet = (List)selected.get("indexSet");
        Iterator index = indexSet.iterator();
        List matSet = (List)selected.get("matSet");
        Iterator mats = matSet.iterator();
        SOPProductPlanPolicyEnum policy = (SOPProductPlanPolicyEnum)((Object)period.get("productPlanPolicy"));
        boolean isAverage = false;
        if (policy.equals((Object)SOPProductPlanPolicyEnum.AVERAGE_PLAN)) {
            isAverage = true;
        }
        while (index.hasNext()) {
            if (isAverage) {
                int precision = this.getMaterialPrecision(mats.next().toString());
                precisionList.add(new Integer(precision));
            }
            ArrayList<BigDecimal> aSalesPlan = new ArrayList<BigDecimal>();
            ArrayList<Object> aTargetInvertory = new ArrayList<Object>();
            BigDecimal sumSalePlan = new BigDecimal(0);
            int i = Integer.parseInt(index.next().toString());
            Object aInventory = this.tblMain.getCell(this.getInvOffset() + i, bopColKey).getValue();
            aInventory = aInventory == null ? new BigDecimal("0.00") : aInventory;
            for (int j = 0; j < numOfPeriod && planTypeIdx + j <= this.tblMain.getColumnCount() - 1; ++j) {
                Object oSale = this.tblMain.getCell(i, planTypeIdx + j).getValue();
                Object targetInvertory = this.tblMain.getCell(this.getTargetInvOffset() + i, planTypeIdx + j).getValue();
                oSale = oSale == null ? new BigDecimal("0.00") : oSale;
                targetInvertory = targetInvertory == null ? new BigDecimal("0.00") : targetInvertory;
                BigDecimal sale = new BigDecimal(oSale.toString());
                aSalesPlan.add(sale);
                aTargetInvertory.add(targetInvertory);
                sumSalePlan = sumSalePlan.add(sale);
            }
            salePlans.add(aSalesPlan);
            TargetInvertorys.add(aTargetInvertory);
            startInvertory.add(aInventory);
            sumSalePlans.add(sumSalePlan);
        }
        period.put("saleplan", salePlans);
        period.put("START_INVERTORY", startInvertory);
        period.put("targetinv", TargetInvertorys);
        period.put("SUM_SALE_PLAN", sumSalePlans);
        period.put("precision", precisionList);
        period.put("planTypeIdx", new Integer(planTypeIdx));
        period.put("indexset", indexSet);
        return period;
    }

    private void saveDataOfStrategy(Map map) throws Exception {
        this.listen4UpdateChanges(false);
        List mProductArray = (List)map.get("productArray");
        List matset = (List)map.get("indexset");
        int planTypeIdx = Integer.parseInt(map.get("planTypeIdx").toString());
        Iterator mat = matset.iterator();
        int k = 0;
        while (mat.hasNext()) {
            int i = Integer.parseInt(mat.next().toString());
            List aProductArray = (List)mProductArray.toArray()[k];
            IRow row = this.tblMain.getRow(i + this.getProdOffset());
            BigDecimal total = new BigDecimal("0.0");
            int size = aProductArray.size();
            for (int j = 0; j < size; ++j) {
                BigDecimal productPlan = new BigDecimal(aProductArray.toArray()[j].toString());
                ICell cell = row.getCell(planTypeIdx + j);
                this.bufferChanges(i + 1, planTypeIdx + j, (BigDecimal)cell.getValue(), productPlan);
                cell.setValue((Object)productPlan);
                total = total.add(productPlan);
            }
            ICell cell = row.getCell(planTypeIdx - 2);
            cell.setValue((Object)total);
            this.calcInventory(this.tblMain.getRow(this.getInvOffset() + i));
            ++k;
        }
        this.listen4UpdateChanges(true);
    }

    private Map getSelectedRowIndex() {
        ArrayList<Integer> indexSet = new ArrayList<Integer>();
        ArrayList<String> matSet = new ArrayList<String>();
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>();
        int size = this.tblMain.getSelectManager().size();
        size = size == 0 ? 1 : size;
        int start = 0;
        int end = this.tblMain.getRowCount3() - 1;
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
            if (sb != null) {
                if (sb.getMode() == 4) {
                    start = 0;
                    end = this.tblMain.getRowCount() - 1;
                } else {
                    start = sb.getTop();
                    end = sb.getBottom();
                }
            }
            for (int j = start; j <= end; ++j) {
                String matId = (String)this.tblMain.getCell(j, 0).getValue();
                matSet.add(matId);
                indexSet.add(new Integer(j / this.getDynamicFieldCount() * this.getDynamicFieldCount()));
            }
        }
        map.put("matSet", matSet);
        map.put("indexSet", indexSet);
        return map;
    }

    protected IMetaDataPK getQueryMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.framework.report.app", "CommRptEmptyQuery");
    }

    private void getPermission(String storageOrgUnitId) throws BOSException, EASBizException {
        String[] str = new String[]{VIEW_SALE_PERMISSION, VIEW_PRODUCT_PERMISSION, EDIT_SALE_PERMISSION, EDIT_PRODUCT_PERMISSION, TRANSFER_PERMISSION};
        ISOPPermissionFacade sopPermFacade = SOPPermissionFacadeFactory.getRemoteInstance();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        Map permMap = sopPermFacade.checkPermissions(userPK.toString(), storageOrgUnitId, str);
        this.hasViewSalesPermission = Boolean.valueOf(permMap.get(VIEW_SALE_PERMISSION).toString());
        this.hasViewProdPermission = Boolean.valueOf(permMap.get(VIEW_PRODUCT_PERMISSION).toString());
        this.hasEditSalesPermission = Boolean.valueOf(permMap.get(EDIT_SALE_PERMISSION).toString());
        this.hasEditProdPermission = Boolean.valueOf(permMap.get(EDIT_PRODUCT_PERMISSION).toString());
        this.hasTransferPermission = Boolean.valueOf(permMap.get(TRANSFER_PERMISSION).toString());
    }

    private void getPermission4Test(int permissionCase) {
        switch (permissionCase) {
            case 1: {
                this.hasViewSalesPermission = true;
                this.hasEditSalesPermission = false;
                this.hasViewProdPermission = false;
                this.hasEditProdPermission = false;
                this.hasTransferPermission = false;
                break;
            }
            case 2: {
                this.hasViewSalesPermission = true;
                this.hasEditSalesPermission = true;
                this.hasViewProdPermission = false;
                this.hasEditProdPermission = false;
                this.hasTransferPermission = false;
                break;
            }
            case 3: {
                this.hasViewSalesPermission = true;
                this.hasEditSalesPermission = false;
                this.hasViewProdPermission = true;
                this.hasEditProdPermission = false;
                this.hasTransferPermission = false;
                break;
            }
            case 4: {
                this.hasViewSalesPermission = true;
                this.hasEditSalesPermission = true;
                this.hasViewProdPermission = true;
                this.hasEditProdPermission = true;
                this.hasTransferPermission = false;
                break;
            }
            case 5: {
                this.hasViewSalesPermission = true;
                this.hasEditSalesPermission = true;
                this.hasViewProdPermission = true;
                this.hasEditProdPermission = false;
                this.hasTransferPermission = false;
                break;
            }
            case 6: {
                this.hasViewSalesPermission = true;
                this.hasEditSalesPermission = true;
                this.hasViewProdPermission = false;
                this.hasEditProdPermission = false;
                this.hasTransferPermission = true;
            }
        }
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        block15: {
            CustomerParams cp = null;
            CommonQueryDialog queryDialog = null;
            boolean isParamsFromDefaultFilterSchema = false;
            try {
                SCMBillFilterUI rbqp;
                QuerySolutionInfo solution;
                QueryPanelInfo qpi;
                String queryName;
                IQuerySolutionFacade iQuery;
                queryDialog = this.initCommonQueryDialog();
                this.filterPanel.getUIContext().clear();
                this.filterPanel.getUIContext().putAll(this.getUIContext());
                String parentUIClassName = null;
                parentUIClassName = this.isEditing ? ((Object)((Object)this)).getClass().getName() + "edit" : ((Object)((Object)this)).getClass().getName() + "query";
                if (useDefaultSolution && (iQuery = QuerySolutionFacadeFactory.getRemoteInstance()).hasDefaultSolution(parentUIClassName, queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName()) && (qpi = (solution = iQuery.getDefaultSolution(parentUIClassName, queryName)).getQueryPanelInfo().get(0)) != null) {
                    try {
                        cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                        isParamsFromDefaultFilterSchema = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                boolean ok = false;
                if (cp == null || !useDefaultSolution) {
                    this.filterPanel.onShow();
                    if (queryDialog.show()) {
                        rbqp = (SCMBillFilterUI)queryDialog.getUserPanel(0);
                        this.params = rbqp.getCustomCondition();
                        ok = true;
                    } else if (this.isEditing) {
                        this.requestMutexMat();
                    }
                }
                if (cp != null) {
                    rbqp = (SCMBillFilterUI)this.getCustomerQueryPanel();
                    rbqp.setCustomerParams(cp);
                    rbqp.loadData(null);
                    this.params = rbqp.getCustomCondition();
                }
                if (this.params == null || !ok && !useDefaultSolution) break block15;
                if (ok) {
                    if (!this.isFirstOnload() && this.isEditing) {
                        this.releaseMutexMat();
                    }
                    this.changedRows.clear();
                    this.matId2Bop.clear();
                    this.btnSave.setEnabled(false);
                    this.actionSavePlan.setEnabled(false);
                }
                if (this.getFilters(this.params, isParamsFromDefaultFilterSchema)) {
                    this.queryWithWrap();
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                logger.error((Object)"@showQueryDialog", (Throwable)e);
                this.handleException(e);
            }
        }
        return false;
    }

    protected CommonQueryDialog initCommonQueryDialog() throws Exception {
        boolean initialized = true;
        CommonQueryDialog queryDialog = null;
        if (this.isEditing) {
            if (this.dlgEdit == null) {
                this.dlgEdit = new CommonQueryDialog();
                this.userPanel = this.filterPanel = (this.editPanel = new SOPAddnewFilterUI());
                this.dlgEdit.addUserPanel((KDPanel)this.userPanel);
                initialized = false;
                this.dlgEdit.setParentUIClassName(((Object)((Object)this)).getClass().getName() + "edit");
                this.preFilterName = ((Object)((Object)this)).getClass().getName() + "edit";
            }
            queryDialog = this.dlgEdit;
        } else {
            if (this.dlgQuery == null) {
                this.dlgQuery = new CommonQueryDialog();
                this.userPanel = this.filterPanel = (this.queryPanel = new SOPFilterUI());
                this.dlgQuery.addUserPanel((KDPanel)this.userPanel);
                initialized = false;
                this.dlgQuery.setParentUIClassName(((Object)((Object)this)).getClass().getName() + "query");
                this.preFilterName = ((Object)((Object)this)).getClass().getName() + "query";
            }
            queryDialog = this.dlgQuery;
        }
        if (!initialized) {
            this.filterPanel.loadFields();
            Dimension dd = this.filterPanel.getSize();
            queryDialog.setWidth(450);
            queryDialog.setHeight(320);
            if (this.getUIWindow() == null) {
                queryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                queryDialog.setOwner((Component)((Object)this));
            }
            queryDialog.setTitle(this.filterPanel.getUITitle());
            queryDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            queryDialog.setShowFilter(false);
            queryDialog.setShowSorter(false);
            Method m = this.filterPanel.getClass().getMethod("onInit", RptParams.class);
            m.invoke((Object)this.filterPanel, this.getUIContextInitParams());
            this.filterPanel.initLayout();
            if (this.params != null) {
                ((SOPAddnewFilterUI)this.filterPanel).setMyparams(this.params);
                this.filterPanel.setCustomerParams(RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.params));
            }
        }
        return queryDialog;
    }

    @Override
    public void actionViewOption_actionPerformed(ActionEvent e) throws Exception {
        String uiClass = "com.kingdee.eas.mm.planning.client.SOPDisplaySetUI";
        HashMap<String, Object> inMap = new HashMap<String, Object>();
        inMap.put("currentorgID", this.storageOrgUnitId);
        inMap.put("currentPlanType", (Object)this.planType);
        inMap.put("saleplan", !this.hideSales);
        inMap.put("storagevol", !this.hideInv);
        inMap.put("prodplanTheory", !this.hideProdTheory);
        inMap.put("prodplan", !this.hideProduction);
        inMap.put("targetinv", !this.hideTargetInv);
        inMap.put("diaplaydate", this.displayDateInCaption);
        inMap.put("hidehistorydata", this.hideHistoryPeriods);
        UIContext ctx = new UIContext();
        ctx.put((Object)"sopdisplay", inMap);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)ctx, null, OprtState.VIEW);
        uiWindow.show();
        SOPDisplaySetUI setUI = (SOPDisplaySetUI)uiWindow.getUIObject();
        Map outMap = setUI.getSetData();
        if (outMap != null) {
            this.hideHistoryPeriods = (Boolean)outMap.get("hidehistorydata");
            this.displayDateInCaption = (Boolean)outMap.get("diaplaydate");
            this.hideSales = (Boolean)outMap.get("saleplan") == false;
            this.hideProdTheory = (Boolean)outMap.get("prodplanTheory") == false;
            this.hideProduction = (Boolean)outMap.get("prodplan") == false;
            this.hideTargetInv = (Boolean)outMap.get("targetinv") == false;
            this.hideInv = (Boolean)outMap.get("storagevol") == false;
            this.changeViewAppearance();
        }
    }

    @Override
    public void actionCopyPlan_actionPerformed(ActionEvent e) throws Exception {
        if (!this.saveDataFirst()) {
            return;
        }
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        String uiClass = "com.kingdee.eas.mm.planning.client.SOPCopyUI";
        HashMap<String, Object> inMap = new HashMap<String, Object>();
        inMap.put("org", this.storageOrgUnitId);
        inMap.put("sopeditmode", (Object)this.editMode);
        inMap.put("PlanType", (Object)this.planType);
        ArrayList materialLst = new ArrayList();
        Set set = this.getSelectedMaterials(false);
        materialLst.addAll(set);
        Map storageMatIds = this.getStorageMatIds(set);
        inMap.put("materials", materialLst);
        inMap.put("matStorageIds", storageMatIds);
        inMap.put("sourceVersion", this.planVersionId);
        if (!this.planType.equals((Object)SOPPlannedTypeEnum.SALEPLAN)) {
            Map bopMap = this.getSelectedBops(false);
            inMap.put("bop", bopMap);
        }
        inMap.put("rate", this.rateMap);
        inMap.put("precision", this.precisionMap);
        UIContext ctx = new UIContext();
        ctx.put((Object)"COPYSOP", inMap);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)ctx);
        uiWindow.show();
    }

    @Override
    public void actionBOPLastPeriod_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        this.fillInventoryData(true);
    }

    @Override
    public void actionBOPCurrent_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        this.fillInventoryData(false);
    }

    private void fillInventoryData(boolean isPre) throws Exception {
        if (this.isEditing && (this.planType.getValue() == 2 || this.planType.getValue() == 3)) {
            HashSet<String> noPermissionSet = new HashSet<String>();
            Set matSet = this.getSelectedMaterials(false);
            Map storageMatIds = this.getStorageMatIds(matSet);
            if (matSet != null && matSet.size() > 0) {
                ArrayList matLst = new ArrayList();
                matLst.addAll(matSet);
                HashMap invMap = null;
                StorageOrgUnitInfo org = new StorageOrgUnitInfo();
                org.setId(BOSUuid.read((String)this.storageOrgUnitId));
                ISOPFacade sop = SOPFacadeFactory.getRemoteInstance();
                List valueList = sop.getSopParamValue();
                if (isPre) {
                    invMap = sop.getPrePeroidInventoryBalance(valueList, matLst, storageMatIds, this.storageOrgUnitId);
                } else {
                    String userInfoID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                    for (int i = 0; i < matLst.size(); ++i) {
                        String storageId = (String)storageMatIds.get(matLst.get(i) + "storage");
                        boolean hasPermission = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(userInfoID), (IObjectPK)new ObjectUuidPK(storageId), "inventory");
                        if (hasPermission) continue;
                        storageMatIds.remove(matLst.get(i) + "storage");
                        storageMatIds.remove(matLst.get(i) + "material");
                        noPermissionSet.add(storageId);
                    }
                    if (noPermissionSet.size() > 0) {
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("id", noPermissionSet, CompareType.INCLUDE));
                        viewInfo.setFilter(filter);
                        SelectorItemCollection coll = new SelectorItemCollection();
                        coll.add(new SelectorItemInfo("name"));
                        viewInfo.setSelector(coll);
                        StorageOrgUnitCollection storageCol = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(viewInfo);
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < storageCol.size(); ++i) {
                            sb.append(storageCol.get(i).getName());
                        }
                        MsgBox.showInfo((String)ResourceUtils.getMessage((String)"com.kingdee.eas.mm.planning.client.SOPPlanVersionResource", (String)"HAS_NO_CURRENT_STORAGE_VIEW_PERMISSION", (String[])new String[]{sb.toString()}));
                    }
                    if (storageMatIds.size() <= 0) {
                        return;
                    }
                    invMap = sop.getInventory(valueList, matLst, storageMatIds, this.storageOrgUnitId);
                }
                if (invMap != null && invMap.size() > 0) {
                    for (String ids : invMap.keySet()) {
                        BigDecimal qty = (BigDecimal)invMap.get(ids);
                        if (qty != null) {
                            this.setMaterialBOP(ids, qty);
                            continue;
                        }
                        this.setMaterialBOP(ids, new BigDecimal("0.0"));
                    }
                }
            }
        }
    }

    private Map getTransformForUnit(Set matSet, HashMap invMap) throws Exception {
        int i;
        MaterialPlanInfo info;
        if (matSet.isEmpty()) {
            return invMap;
        }
        IMaterial materialFactory = MaterialFactory.getRemoteInstance();
        IMaterialPlan materialPlanFactory = MaterialPlanFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)matSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.storageOrgUnitId, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        CoreBaseCollection materialPlanCollection = materialPlanFactory.getCollection(viewInfo);
        FilterInfo filterForBaseUnit = new FilterInfo();
        filterForBaseUnit.getFilterItems().add(new FilterItemInfo("material.id", (Object)matSet, CompareType.INCLUDE));
        EntityViewInfo viewInfoForBaseUnit = new EntityViewInfo();
        CoreBaseCollection materialCollection = materialFactory.getCollection(viewInfoForBaseUnit);
        HashMap<String, MeasureUnitInfo> productUnitMap = new HashMap<String, MeasureUnitInfo>();
        HashMap<String, MeasureUnitInfo> baseUnitMap = new HashMap<String, MeasureUnitInfo>();
        if (null != materialPlanCollection && materialPlanCollection.size() > 0) {
            info = null;
            for (i = 0; i < materialPlanCollection.size(); ++i) {
                info = (MaterialPlanInfo)materialPlanCollection.get(i);
                productUnitMap.put(info.getMaterial().getId().toString(), info.getProductUnit());
            }
        }
        if (null != materialCollection && materialCollection.size() > 0) {
            info = null;
            for (i = 0; i < materialCollection.size(); ++i) {
                info = (MaterialInfo)materialCollection.get(i);
                baseUnitMap.put(info.getId().toString(), info.getBaseUnit());
            }
        }
        Object[] ids = matSet.toArray();
        BigDecimal resultQty = new BigDecimal("0.00");
        String matId = "";
        for (int i2 = 0; i2 < ids.length; ++i2) {
            matId = ids[i2].toString();
            if (!baseUnitMap.containsKey(matId) || !productUnitMap.containsKey(matId) || !invMap.containsKey(matId) || null == invMap.get(matId)) continue;
            resultQty = SCMUtils.getExchangeQtyForClient((String)matId, (MeasureUnitInfo)((MeasureUnitInfo)baseUnitMap.get(matId)), (MeasureUnitInfo)((MeasureUnitInfo)productUnitMap.get(matId)), (BigDecimal)new BigDecimal((String)invMap.get(matId)));
            invMap.remove(matId);
            invMap.put(matId, resultQty.toString());
        }
        return invMap;
    }

    @Override
    public void actionNewPlan_actionPerformed(ActionEvent e) throws Exception {
        if (!this.saveDataFirst()) {
            return;
        }
        PlanAddNewMaterialDialog dialog = new PlanAddNewMaterialDialog((IUIObject)this);
        dialog.setStorageOrgUnitId(this.storageOrgUnitId);
        dialog.setPlanVersionId(this.planVersionId);
        if (dialog.show()) {
            ArrayList materialIds = dialog.getMaterialIds();
            ArrayList storageOrgIds = dialog.getStorageOrgIds();
            ArrayList<String> materialIds1 = new ArrayList<String>();
            ArrayList<String> storageOrgIds1 = new ArrayList<String>();
            Map dataDisplayed = this.tblManager.getMapData();
            Iterator mt = materialIds.iterator();
            Iterator st = storageOrgIds.iterator();
            String matStroageIds = new String();
            while (mt.hasNext() && st.hasNext()) {
                String mat = (String)mt.next();
                String storage = (String)st.next();
                matStroageIds = storage + mat;
                if (dataDisplayed.containsKey(matStroageIds)) continue;
                materialIds1.add(mat);
                storageOrgIds1.add(storage);
            }
            if (materialIds1.size() > 0) {
                String addPlanDesc = this.menuItemNewPlan.getText();
                addPlanDesc = addPlanDesc.substring(0, addPlanDesc.lastIndexOf("("));
                IObjectPK pk = LogUtil.beginLog(null, (String)addPlanDesc, (BOSObjectType)new BOSObjectType("63D23A66"), null, (String)addPlanDesc);
                this.addNewMaterialsSopPlan(storageOrgIds1, materialIds1);
                this.releaseMutexMat();
                this.queryWithWrap();
                LogUtil.afterLog(null, (IObjectPK)pk);
            }
        }
    }

    private boolean saveDataFirst() throws Exception {
        boolean isSave = true;
        if (this.isThereDataNotSaved()) {
            int confirm = MsgBox.showConfirm3((String)EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)"DATA_NOT_SAVE"));
            if (confirm == 2) {
                this.isCancel = true;
                return false;
            }
            if (confirm == 0) {
                this.actionSavePlan_actionPerformed(null);
                isSave = true;
                this.isCancel = false;
            } else {
                isSave = true;
                this.isCancel = false;
            }
        }
        return isSave;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return null;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        this.filterPanel = this.isEditing ? this.editPanel : this.queryPanel;
        return this.filterPanel;
    }

    public void releaseMutex() {
        try {
            if (this.isEditing && this.storageOrgUnitId != null && this.planVersionId != null) {
                SOPUtil.releaseMutex(null, this.storageOrgUnitId, this.planVersionId);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void releaseMutexMat() {
        try {
            ArrayList<String> matIDList = new ArrayList<String>();
            HashMap<String, String> storageMatIds = new HashMap<String, String>();
            int dynFieldCount = this.tblManager.getDynFields().getDisplayFieldCount();
            int n = this.tblMain.getRowCount();
            for (int i = 0; i < n; i += dynFieldCount) {
                String ids = (String)this.tblMain.getCell(i, 0).getValue();
                String storageId = (String)this.tblMain.getCell(i, 1).getValue();
                String materialId = (String)this.tblMain.getCell(i, 2).getValue();
                matIDList.add(ids);
                storageMatIds.put(ids + "storage", storageId);
                storageMatIds.put(ids + "material", materialId);
            }
            SOPUtil.releaseMutex(null, this.storageOrgUnitId, this.planVersionId, matIDList, storageMatIds);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public boolean requestMutex() {
        boolean acquired = false;
        try {
            if (this.isEditing) {
                if (SOPUtil.requestMutex(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.storageOrgUnitId, this.planVersionId)) {
                    acquired = true;
                } else {
                    this.isEditing = false;
                    String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)"SOP_EDIT_REQUEST_MUTEX_FAILURE_PROMPT");
                    MsgBox.showError((String)msg);
                }
            } else {
                acquired = true;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return acquired;
    }

    public boolean requestMutexMat() {
        boolean acquired = true;
        try {
            String materialId;
            String storageId;
            ArrayList<String> matIDList = new ArrayList<String>();
            HashMap<String, String> storageMatIds = new HashMap<String, String>();
            int dynFieldCount = this.tblManager.getDynFields().getDisplayFieldCount();
            int n = this.tblMain.getRowCount();
            for (int i = 0; i < n; i += dynFieldCount) {
                String ids = (String)this.tblMain.getCell(i, 0).getValue();
                storageId = (String)this.tblMain.getCell(i, 1).getValue();
                materialId = (String)this.tblMain.getCell(i, 2).getValue();
                matIDList.add(ids);
                storageMatIds.put(ids + "storage", storageId);
                storageMatIds.put(ids + "material", materialId);
            }
            ISOPFacade sop = SOPFacadeFactory.getRemoteInstance();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org", this.storageOrgUnitId);
            map.put("planVersion", this.planVersionId);
            map.put("materials", matIDList);
            map.put("matStorageIds", storageMatIds);
            Map sopBill = sop.getSOPPlanBillIDAndMatIDList(map);
            List sopBillIdList = (List)sopBill.get("sopIds");
            Map sopBillIdToMatId = (Map)sopBill.get("sopIdToMatId");
            List forUpdateList = SOPUtil.getObjIDForUpdateLists(null, this.storageOrgUnitId, this.planVersionId);
            if (sopBillIdList != null && forUpdateList != null) {
                int n2 = sopBillIdList.size();
                for (int i = 0; i < n2; ++i) {
                    int m = forUpdateList.size();
                    for (int j = 0; j < m; ++j) {
                        String keyStr = (String)forUpdateList.get(j);
                        if (!keyStr.equals((String)sopBillIdList.get(i))) continue;
                        acquired = false;
                        break;
                    }
                    if (acquired) continue;
                    return acquired;
                }
            }
            Map result = SOPUtil.requestMutex(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.storageOrgUnitId, this.planVersionId, matIDList, storageMatIds);
            if (sopBillIdList != null) {
                int n3 = sopBillIdList.size();
                for (int i = 0; i < n3; ++i) {
                    if (((Boolean)result.get((String)sopBillIdList.get(i))).booleanValue()) continue;
                    acquired = false;
                    break;
                }
            }
            if (!acquired) {
                ArrayList<String> releaseMatIdList = new ArrayList<String>();
                HashMap<String, String> releaseStorageMatIds = new HashMap<String, String>();
                int n4 = sopBillIdList.size();
                for (int i = 0; i < n4; ++i) {
                    String fid = (String)sopBillIdList.get(i);
                    if (!result.containsKey(fid) || !((Boolean)result.get(fid)).booleanValue()) continue;
                    storageId = (String)sopBillIdToMatId.get(fid + "storage");
                    materialId = (String)sopBillIdToMatId.get(fid + "material");
                    releaseStorageMatIds.put(fid + "storage", storageId);
                    releaseStorageMatIds.put(fid + "material", materialId);
                    releaseMatIdList.add((String)sopBillIdToMatId.get(fid));
                }
                SOPUtil.releaseMutex(null, this.storageOrgUnitId, this.planVersionId, releaseMatIdList, releaseStorageMatIds);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return acquired;
    }

    protected void query() {
        this.fillHeadUI();
        this.tblMain.removeRows();
    }

    public boolean destroyWindow() {
        try {
            this.tblMain.getEditManager().stopEditing();
            this.saveDataFirst();
            if (this.isEditing) {
                this.releaseMutexMat();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (this.isCancel) {
            this.isCancel = false;
            this.abort();
            return false;
        }
        return super.destroyWindow();
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        try {
            this.adjustUI();
            this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            this.executeQuery(false, null, null);
            this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    private void showSaveSuccess(boolean show) {
        if (show) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        }
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    @Override
    public void actionSavePlan_actionPerformed(ActionEvent e) throws Exception {
        if (this.changedRows.size() > 0) {
            this.submitAll();
            this.changedRows.clear();
        } else if (this.matId2Bop.size() > 0) {
            Map matStorageIds = this.getStorageMatIds(this.matId2Bop.keySet());
            Object[] submitData = this.constructSaveData(null, matStorageIds);
            ISOPFacade sop = SOPFacadeFactory.getRemoteInstance();
            Map map = sop.saveSopPlan(submitData);
            this.rateMap.putAll((Map)map.get("rate"));
            this.precisionMap.putAll((Map)map.get("precision"));
            this.matId2Bop.clear();
        }
        this.enableSavePlanAction(false);
        if (this.isGlodAddNewMaterials) {
            this.requestMutexMat();
        }
    }

    public boolean submitAll() throws Exception {
        if (this.changedRows.size() == 0) {
            return true;
        }
        Map data = this.tblManager.getMapData();
        HashMap toBeSubmited = new HashMap();
        HashMap<String, String> storageMatIds = new HashMap<String, String>();
        Set rowSet = this.changedRows.entrySet();
        Iterator it = rowSet.iterator();
        while (it.hasNext()) {
            RowChangeInfo row = (RowChangeInfo)it.next().getValue();
            if (this.tblMain.getCell(row.getRowIndex(), 0) == null) {
                this.changedRows.clear();
                this.matId2Bop.clear();
                return true;
            }
            String matStorageId = (String)this.tblMain.getCell(row.getRowIndex(), 0).getValue();
            String materialId = (String)this.tblMain.getCell(row.getRowIndex(), 2).getValue();
            String storageId = (String)this.tblMain.getCell(row.getRowIndex(), 1).getValue();
            LeftHeaderObject headObj = (LeftHeaderObject)data.get(matStorageId);
            HashMap<String, DetailObject> rowMap = (HashMap<String, DetailObject>)toBeSubmited.get(matStorageId);
            if (rowMap == null) {
                rowMap = new HashMap<String, DetailObject>();
                toBeSubmited.put(matStorageId, rowMap);
                storageMatIds.put(matStorageId + "storage", storageId);
                storageMatIds.put(matStorageId + "material", materialId);
            }
            int planTypeIdx = 0;
            if (this.hasViewProdPermission) {
                planTypeIdx = row.getRowIndex() % this.getDynamicFieldCount();
            }
            Set cellValueSet = row.getEntrySet();
            Iterator it1 = cellValueSet.iterator();
            while (it1.hasNext()) {
                String key = (String)((Map.Entry)it1.next()).getKey();
                DetailObject obj1 = (DetailObject)headObj.getDetails().get(key);
                DetailObject obj2 = (DetailObject)rowMap.get(key);
                if (obj1 == null && obj2 == null) {
                    obj1 = new DetailObject(this.tblManager.getDynFields().getFieldDefCount());
                    obj1.setKey(key);
                    obj2 = obj1;
                    rowMap.put(key, obj2);
                    headObj.getDetails().put(key, obj1);
                } else if (obj1 != null && obj2 == null) {
                    obj2 = obj1;
                    rowMap.put(key, obj2);
                }
                if (this.tblMain.getCell(row.getRowIndex(), key) == null) continue;
                BigDecimal bdVal = (BigDecimal)this.tblMain.getCell(row.getRowIndex(), key).getValue();
                if (bdVal == null) {
                    bdVal = new BigDecimal("0.0");
                }
                obj2.setPropertyByIndex(planTypeIdx, bdVal);
            }
        }
        Object[] submitData = this.constructSaveData(toBeSubmited.entrySet(), storageMatIds);
        ISOPFacade sop = SOPFacadeFactory.getRemoteInstance();
        Map map = sop.saveSopPlan(submitData);
        this.rateMap.putAll((Map)map.get("rate"));
        this.precisionMap.putAll((Map)map.get("precision"));
        this.matId2Bop.clear();
        Iterator it2 = toBeSubmited.entrySet().iterator();
        while (it2.hasNext()) {
            Map rowMap = (Map)it2.next().getValue();
            Iterator it1 = rowMap.entrySet().iterator();
            while (it1.hasNext()) {
                DetailObject obj = (DetailObject)it1.next().getValue();
                obj.setFromData(true);
            }
        }
        return true;
    }

    public SOPPeriod dynamicColumnKey2Period(String colKey) {
        Integer idx = (Integer)this.colKey2PeriodMap.get(colKey);
        return this.periodRange[idx];
    }

    public void constructColumnKey2PeriodMap() {
        if (this.colKey2PeriodMap == null) {
            this.colKey2PeriodMap = new HashMap();
        }
        this.colKey2PeriodMap.clear();
        for (int i = 0; i < this.periodRange.length; ++i) {
            this.colKey2PeriodMap.put(Integer.toString(this.periodRange[i].toNumber()), new Integer(i));
        }
    }

    private Object[] constructSaveData(Set dataSet, Map matStorageIds) throws SQLException {
        Object[] data = new Object[11];
        data[0] = this.planVersionId;
        data[1] = this.storageOrgUnitId;
        data[2] = this.editMode;
        String[] mat = null;
        int[] precision = null;
        data[3] = mat;
        data[4] = precision;
        data[5] = this.periodRange;
        DynamicRowSet drs = null;
        if (dataSet != null) {
            mat = new String[dataSet.size()];
            precision = new int[dataSet.size()];
            data[3] = mat;
            data[4] = precision;
            int i = 0;
            drs = new DynamicRowSet(8);
            drs.setColInfo(1, "FMatIndex", "FMatIndex", 4, null);
            drs.setColInfo(2, "FYear", "FYear", 4, null);
            drs.setColInfo(3, "FMonth", "FMonth", 4, null);
            drs.setColInfo(4, "FSalesQty", "FSalesQty", 2, null);
            drs.setColInfo(5, "FProdTheoryQty", "FProdTheoryQty", 2, null);
            drs.setColInfo(6, "FProductionQty", "FProductionQty", 2, null);
            drs.setColInfo(7, "FTargetInvQty", "FTargetInvQty", 2, null);
            drs.setColInfo(8, "FFlag", "FFlag", 4, null);
            Map mapData = this.tblManager.getMapData();
            for (Map.Entry entry : dataSet) {
                mat[i] = (String)entry.getKey();
                Map matMap = (Map)entry.getValue();
                LeftHeaderObject headObj = (LeftHeaderObject)mapData.get(mat[i]);
                precision[i] = headObj.getDefaultPrecision();
                Iterator it1 = matMap.entrySet().iterator();
                while (it1.hasNext()) {
                    DetailObject obj = (DetailObject)it1.next().getValue();
                    SOPPeriod period = this.dynamicColumnKey2Period(obj.getKey());
                    drs.moveToInsertRow();
                    drs.updateInt(1, i);
                    drs.updateInt(2, period.getYear());
                    drs.updateInt(3, period.getNumber());
                    for (int j = 0; j < this.getDynamicFieldCount() - 1; ++j) {
                        if (this.tblManager.getDynFields().getFieldDef(j).isDeducedValue()) continue;
                        if (obj.getPropertyByIndex(j) == null) {
                            drs.updateBigDecimal(4 + j, new BigDecimal("0"));
                            continue;
                        }
                        drs.updateBigDecimal(4 + j, obj.getPropertyByIndex(j));
                    }
                    if (obj.isFromData()) {
                        drs.updateInt(8, 1);
                    } else {
                        drs.updateInt(8, 0);
                    }
                    drs.insertRow();
                }
                ++i;
            }
        }
        data[6] = this.matId2Bop;
        data[7] = drs;
        data[8] = this.rateMap;
        data[9] = this.precisionMap;
        data[10] = matStorageIds;
        return data;
    }

    public boolean submitRow(RowChangeInfo row) {
        return false;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    private void adjustUI() {
        this.actionDeletePlan.setEnabled(this.isEditing && (this.hasEditProdPermission || this.hasEditSalesPermission));
        this.actionNewPlan.setEnabled(this.isEditing && (this.hasEditProdPermission || this.hasEditSalesPermission));
        this.actionSavePlan.setEnabled(this.isEditing && this.isThereDataNotSaved());
        this.actionEditPlan.setEnabled(!this.isEditing);
        this.actionGetPoductionValue.setEnabled(this.isEditing && this.hasEditProdPermission && !this.planType.equals((Object)SOPPlannedTypeEnum.SALEPLAN));
        boolean enableStrategy = this.isEditing && this.editMode == SOPEditModeEnum.MONTHLY && this.hasEditProdPermission;
        this.actionStrategyAverage.setEnabled(enableStrategy);
        this.actionStrategyTargetInv.setEnabled(enableStrategy);
        this.actionStrategySynWithSales.setEnabled(enableStrategy);
        this.actionStrategyZerioInv.setEnabled(enableStrategy);
        this.menuItemStrategy.setEnabled(enableStrategy);
        this.actionBOPLastPeriod.setEnabled(this.isEditing && this.hasEditProdPermission);
        this.actionBOPCurrent.setEnabled(this.isEditing && this.hasEditProdPermission);
        this.menuBOP.setEnabled(this.isEditing && this.hasEditProdPermission);
        this.actionCalcTargetInv.setEnabled(enableStrategy);
        this.menuItemCalcTargetInv.setEnabled(enableStrategy);
        this.actionTransferPlan.setEnabled(this.hasTransferPermission && this.planVersionActivated);
        if (this.planType != null) {
            this.txtPlanType.removeAllItems();
            this.txtPlanType.addItem((Object)this.planType);
        }
        this.switchUITitle();
    }

    private void enableSavePlanAction(boolean enabled) {
        if (this.actionSavePlan.isEnabled() != enabled) {
            this.actionSavePlan.setEnabled(enabled);
            if (!enabled) {
                this.showSaveSuccess(!enabled);
            }
        }
    }

    @Override
    public void actionEditPlan_actionPerformed(ActionEvent e) throws Exception {
        if (this.hasEditSalesPermission || this.hasEditProdPermission) {
            boolean reqMutex = this.requestMutexMat();
            if (reqMutex) {
                this.isEditing = true;
                switch (this.planType.getValue()) {
                    case 1: {
                        if (this.hasEditSalesPermission) break;
                        this.planType = SOPPlannedTypeEnum.PRODUCT_PLAN;
                        break;
                    }
                    case 2: {
                        if (this.hasEditProdPermission) break;
                        this.planType = SOPPlannedTypeEnum.SALEPLAN;
                        break;
                    }
                    case 3: {
                        if (!this.hasEditSalesPermission) {
                            this.planType = SOPPlannedTypeEnum.PRODUCT_PLAN;
                        }
                        if (this.hasEditProdPermission) break;
                        this.planType = SOPPlannedTypeEnum.SALEPLAN;
                    }
                }
                if (this.planType == SOPPlannedTypeEnum.PRODUCT_PLAN) {
                    this.hideProduction = false;
                    this.hideProdTheory = false;
                    this.hideTargetInv = false;
                    this.hideInv = false;
                    this.hideSales = false;
                } else if (this.planType == SOPPlannedTypeEnum.SALEPLAN) {
                    this.hideProduction = true;
                    this.hideProdTheory = true;
                    this.hideTargetInv = true;
                    this.hideInv = true;
                    this.hideSales = false;
                } else {
                    this.hideProduction = false;
                    this.hideProdTheory = false;
                    this.hideTargetInv = false;
                    this.hideInv = false;
                    this.hideSales = false;
                }
                this.adjustUI();
                this.setViewAppearance(false);
                this.setBopEditableAndEditor();
                IObjectPK pk = LogUtil.beginLog(null, (String)this.getUITitle(), (BOSObjectType)new BOSObjectType("63D23A66"), null, (String)this.getUITitle());
                LogUtil.afterLog(null, (IObjectPK)pk);
            } else {
                String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)"SOP_EDIT_REQUEST_MUTEX_FAILURE_PROMPT");
                MsgBox.showError((String)msg);
            }
        } else {
            String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)"NO_SOP_PRODUCTPLAN_AND_SALEPLAN_EDIT_PERMISSION");
            MessageFormat msgFmt = new MessageFormat(msg);
            MsgBox.showError((String)msgFmt.format(new String[]{this.storageOrgUnitName}));
        }
    }

    private ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "com.kingdee.eas.mm.planning.app.SopPlanTransformer";
        param.alias = EASResource.getString((String)"com.kingdee.eas.mm.planning.client.SOPPlanVersionResource.SOP");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        if (this.getImportParam() != null) {
            if (this.isEditing) {
                this.releaseMutexMat();
            }
            task.invoke(this.getImportParam(), 0);
        }
        this.queryWithWrap();
    }

    private Set getSelectedMaterials(boolean allIfNoSelection) {
        HashSet<String> set = new HashSet<String>();
        int size = this.tblMain.getSelectManager().size();
        int beginIndex = 0;
        int endIndex = this.tblMain.getRowCount3() - 1;
        if (size == 0 && allIfNoSelection) {
            size = 1;
        }
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
            if (sb != null) {
                if (sb.getMode() == 4 || sb.getMode() == 8) {
                    beginIndex = 0;
                    endIndex = this.tblMain.getRowCount() - 1;
                } else {
                    beginIndex = sb.getTop();
                    endIndex = sb.getBottom();
                }
            }
            for (int j = beginIndex; j <= endIndex; ++j) {
                if (j == -1) continue;
                String matId = (String)this.tblMain.getCell(j, 0).getValue();
                set.add(matId);
            }
        }
        return set;
    }

    @Override
    public void actionGetProductionValue_actionPerformed(ActionEvent e) throws Exception {
        if (!this.saveDataFirst()) {
            return;
        }
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        Set matIds = this.getSelectedMaterials(false);
        if (matIds == null || matIds.size() == 0) {
            throw new SOPException(SOPException.NO_SELECTED_MATERIAL);
        }
        Map retVals = this.acquirePeriods(this.menuItemGetProdValue.getText());
        if (retVals == null) {
            return;
        }
        SOPPeriod period = (SOPPeriod)retVals.get("StartSOPPeriod");
        int startColumn = this.getColumnIndex4Period(period);
        Integer num = (Integer)retVals.get("NumberOfTerm");
        int count = Math.min(this.tblMain.getColumnCount() - startColumn, num);
        this.listen4UpdateChanges(false);
        try {
            for (String matId : matIds) {
                IRow row = this.tblManager.getRowFromHeadObjKey(matId);
                IRow prodTheoryRow = this.tblMain.getRow(row.getRowIndex() + this.getProdTheoryOffset());
                IRow prodRow = this.tblMain.getRow(row.getRowIndex() + this.getProdOffset());
                IRow invRow = this.tblMain.getRow(row.getRowIndex() + this.getInvOffset());
                for (int i = startColumn; i < count + startColumn && i != this.tblMain.getColumnCount(); ++i) {
                    this.setCellValue(prodRow.getCell(i), (BigDecimal)prodTheoryRow.getCell(i).getValue(), true);
                }
                this.updateSumValue(prodRow.getRowIndex());
                this.calcInventory(invRow);
            }
        }
        catch (Exception e1) {
            throw e1;
        }
        finally {
            this.listen4UpdateChanges(true);
        }
    }

    private boolean isThereSalesPlanSelected() {
        boolean salesSelected = false;
        boolean otherSelected = false;
        if (this.hasViewProdPermission) {
            int size = this.tblMain.getSelectManager().size();
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    if (this.isSalesRow(j)) {
                        salesSelected = true;
                        continue;
                    }
                    otherSelected = true;
                }
            }
        } else {
            salesSelected = true;
        }
        return salesSelected && !otherSelected;
    }

    private void setMaterialBOP(String matId, BigDecimal bop) throws Exception {
        IRow row = this.tblManager.getRowFromHeadObjKey(matId);
        this.tblMain.getCell(row.getRowIndex() + this.getInvOffset(), bopColKey).setValue((Object)bop);
    }

    private void addNewMaterialsSopPlan(ArrayList storageOrgIds, ArrayList materialIds) throws Exception {
        String matStorageId;
        IRow row;
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        this.executeQuery(true, storageOrgIds, materialIds);
        this.tblMain.getGroupManager().group();
        for (int i = 0; i < materialIds.size() && (row = this.tblManager.getRowFromHeadObjKey(matStorageId = (String)storageOrgIds.get(i) + (String)materialIds.get(i))) != null; ++i) {
            BigDecimal bop = (BigDecimal)row.getCell(this.bopColIndex).getValue();
            if (bop != null) continue;
            bop = this.ZERO;
            this.bufferBalanceOfPeriodChange(matStorageId, row.getRowIndex() + this.getInvOffset(), bop);
        }
        this.actionSavePlan_actionPerformed(null);
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    private void setZeroForRow(IRow row) {
        this.tblManager.getSumCell(row.getRowIndex()).setValue((Object)this.ZERO);
        for (int i = this.tblManager.getColumnCountBeforeDynamic() + 1; i < this.tblMain.getColumnCount(); ++i) {
            row.getCell(i).setValue((Object)this.ZERO);
        }
    }

    private void setZeroForRow(int rowIndex) {
        IRow row = this.tblMain.getRow(rowIndex);
        this.setZeroForRow(row);
    }

    private void setZeroForMat(String matId) {
        IRow row = this.tblManager.getRowFromHeadObjKey(matId);
        if (this.planType.getValue() == 1) {
            this.setZeroForRow(row);
        } else if (this.planType.getValue() == 2) {
            this.setZeroForRow(row.getRowIndex() + this.getProdOffset());
            this.setZeroForRow(row.getRowIndex() + this.getTargetInvOffset());
        }
        this.calcInventory(row.getRowIndex() + this.getInvOffset());
    }

    private void removeBufferedBalanceOfPeriod(Set matSet) {
        for (String matId : matSet) {
            this.matId2Bop.remove(matId);
        }
    }

    @Override
    public void actionDeletePlan_actionPerformed(ActionEvent e) throws Exception {
        if (!this.saveDataFirst()) {
            return;
        }
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        Set set = this.getSelectedMaterials(false);
        Map matStorageIds = this.getStorageMatIds(set);
        ArrayList matIDList = new ArrayList();
        if (set.size() > 0) {
            String plantype = ((SOPPlannedTypeEnum)((Object)this.txtPlanType.getSelectedItem())).getAlias();
            String prompt = EASResource.getString((String)"com.kingdee.eas.mm.planning.client.SOPPlanVersionResource.SOP_DELETE_PLAN_CONFIRM_PREFIX") + plantype + EASResource.getString((String)"com.kingdee.eas.mm.planning.client.SOPPlanVersionResource.SOP_DELETE_PLAN_CONFIRM_SUFFIX");
            int nYes = MsgBox.showConfirm2((Component)((Object)this), (String)prompt);
            if (0 != nYes) {
                return;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                matIDList.add(iterator.next());
            }
            String deleteDesc = this.menuItemDeletePlan.getText();
            deleteDesc = deleteDesc.substring(0, deleteDesc.lastIndexOf("("));
            IObjectPK pk = LogUtil.beginLog(null, (String)deleteDesc, (BOSObjectType)new BOSObjectType("63D23A66"), null, (String)deleteDesc);
            ISOPFacade sop = SOPFacadeFactory.getRemoteInstance();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("org", this.storageOrgUnitId);
            params.put("planVersion", this.planVersionId);
            params.put("PlanType", (Object)this.planType);
            params.put("materials", set);
            params.put("matStorageIds", matStorageIds);
            if (this.planType.getValue() == 3) {
                this.tblManager.removeData(set);
                SOPUtil.releaseMutex(null, this.storageOrgUnitId, this.planVersionId, matIDList, matStorageIds);
                if (!sop.deleteSopPlan(params)) {
                    SOPUtil.requestMutex(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.storageOrgUnitId, this.planVersionId, matIDList, matStorageIds);
                } else {
                    this.removeBufferedBalanceOfPeriod(set);
                }
            } else if (sop.deleteSopPlan(params)) {
                this.listen4UpdateChanges(false);
                try {
                    for (String matId : set) {
                        this.setZeroForMat(matId);
                    }
                }
                catch (Exception e1) {
                    throw e1;
                }
                finally {
                    this.listen4UpdateChanges(true);
                }
                this.removeBufferedBalanceOfPeriod(set);
            }
            LogUtil.afterLog(null, (IObjectPK)pk);
        }
        if (this.tblMain.getRowCount() <= 0) {
            this.btnSave.setEnabled(false);
            this.menuItemSave.setEnabled(false);
            this.changedRows.clear();
            this.matId2Bop.clear();
        }
    }

    private void resetSavePlanActionEnabled() {
        if (this.isThereDataNotSaved()) {
            this.enableSavePlanAction(true);
        }
    }

    @Override
    public void actoinCalcTargetInv_actionPerformed(ActionEvent e) throws Exception {
        if (!this.saveDataFirst()) {
            return;
        }
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        SOPPeriod maxPeriodDisplayed = this.getMaxPeriodDisplayed();
        Set selectedRows = this.getSelectedMaterials(false);
        Map id2nextSales = null;
        if (selectedRows.size() == 0) {
            throw new SOPException(SOPException.NO_SELECTED_MATERIAL);
        }
        if (selectedRows.size() > 0) {
            Map retVals = this.acquirePeriods(this.menuItemCalcTargetInv.getText());
            if (retVals == null) {
                return;
            }
            SOPPeriod period = (SOPPeriod)retVals.get("StartSOPPeriod");
            Integer num = (Integer)retVals.get("NumberOfTerm");
            int count = num;
            SOPPeriod[] pRange = period.forwardPeriods(count);
            if (maxPeriodDisplayed.toNumber() <= pRange[pRange.length - 1].toNumber()) {
                SOPPeriod[] nextRange = maxPeriodDisplayed.forwardPeriods(2);
                id2nextSales = this.fetchSopSalesPlan(nextRange[nextRange.length - 1], selectedRows);
            }
            int startColumn = this.getColumnIndex4Period(period);
            HashMap<String, Object> inMap = new HashMap<String, Object>();
            inMap.put("org", this.storageOrgUnitId);
            ArrayList materialLst = new ArrayList();
            materialLst.addAll(selectedRows);
            inMap.put("materials", materialLst);
            Map storageMatIds = this.getStorageMatIds(selectedRows);
            inMap.put("matStorageIds", storageMatIds);
            HashMap<String, BigDecimal> matIdToMax = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> matIdToMin = new HashMap<String, BigDecimal>();
            BigDecimal MaxInv = null;
            BigDecimal MinInv = null;
            int size = materialLst.size();
            for (int i = 0; i < size; ++i) {
                matIdToMax.put((String)materialLst.get(i), null);
                matIdToMin.put((String)materialLst.get(i), null);
            }
            ISOPFacade sop = SOPFacadeFactory.getRemoteInstance();
            IRowSet rs = sop.getHighLowTargetInv(inMap);
            if (rs != null) {
                while (rs.next()) {
                    MaxInv = rs.getBigDecimal("FQtyMax");
                    MinInv = rs.getBigDecimal("FQtyMin");
                    matIdToMax.put(rs.getString("FMaterialId"), MaxInv);
                    matIdToMin.put(rs.getString("FMaterialId"), MinInv);
                }
            }
            for (String matId : selectedRows) {
                int precision = this.getMaterialPrecision(matId);
                IRow rowSales = this.tblManager.getRowFromHeadObjKey(matId);
                if (rowSales == null) break;
                IRow rowTargetInv = this.tblMain.getRow(rowSales.getRowIndex() + this.getTargetInvOffset());
                BigDecimal targetTurnover = new BigDecimal((String)rowSales.getCell(3).getValue());
                for (int i = startColumn; i < startColumn + count; ++i) {
                    BigDecimal nextPeriodSales;
                    if (i < this.tblMain.getColumnCount() - 1) {
                        nextPeriodSales = (BigDecimal)rowSales.getCell(i + 1).getValue();
                    } else if (i == this.tblMain.getColumnCount() - 1) {
                        nextPeriodSales = (BigDecimal)id2nextSales.get(matId);
                    } else {
                        return;
                    }
                    if (nextPeriodSales != null) {
                        nextPeriodSales = nextPeriodSales.setScale(precision, 4);
                        BigDecimal curPeriodTargetInv = nextPeriodSales.multiply(targetTurnover).divide(new BigDecimal(30), 4);
                        MaxInv = (BigDecimal)matIdToMax.get(matId);
                        MinInv = (BigDecimal)matIdToMin.get(matId);
                        if (MaxInv != null && curPeriodTargetInv.compareTo(MaxInv) > 0) {
                            curPeriodTargetInv = MaxInv;
                        }
                        if (MinInv != null && curPeriodTargetInv.compareTo(MinInv) < 0) {
                            curPeriodTargetInv = MinInv;
                        }
                        rowTargetInv.getCell(i).setValue((Object)curPeriodTargetInv);
                        continue;
                    }
                    rowTargetInv.getCell(i).setValue((Object)new BigDecimal(0));
                }
            }
        }
    }

    private boolean isThereDataNotSaved() {
        return this.changedRows.size() > 0 || this.matId2Bop.size() > 0;
    }

    private void bufferChanges(int rowIndex, int colIndex, BigDecimal oldValue, BigDecimal newValue) {
        if (newValue == null) {
            newValue = this.ZERO;
        }
        if (oldValue == null) {
            oldValue = this.ZERO;
        }
        if (oldValue.compareTo(newValue) != 0) {
            Integer index = new Integer(rowIndex);
            RowChangeInfo row = (RowChangeInfo)this.changedRows.get(index);
            if (row == null) {
                row = new RowChangeInfo(rowIndex);
                this.changedRows.put(index, row);
            }
            row.addChangedCell(this.tblMain.getColumnKey(colIndex), oldValue, newValue);
            this.enableSavePlanAction(true);
        }
    }

    private void bufferBalanceOfPeriodChange(String matId, int rowIndex, BigDecimal bop) {
        this.matId2Bop.put(matId, bop);
        this.enableSavePlanAction(true);
        if (this.isViewProdPlan()) {
            this.calcInventory(this.tblMain.getRow(rowIndex), this.bopColIndex + 1);
        }
    }

    public void propertyChange(KDTPropertyChangeEvent evt) {
        if (evt.getType() == 1 && evt.getPropertyName().equals("cellValue")) {
            if (evt.getColIndex() < this.bopColIndex) {
                return;
            }
            String matId = (String)this.tblMain.getCell(evt.getRowIndex(), 0).getValue();
            if (evt.getColIndex() == this.bopColIndex) {
                double oldVale;
                double newVale = evt.getNewValue() != null ? ((BigDecimal)evt.getNewValue()).doubleValue() : new BigDecimal("0.0").doubleValue();
                if (newVale != (oldVale = evt.getOldValue() != null ? ((BigDecimal)evt.getOldValue()).doubleValue() : new BigDecimal("0.0").doubleValue())) {
                    this.bufferBalanceOfPeriodChange(matId, evt.getRowIndex(), (BigDecimal)evt.getNewValue());
                }
            } else {
                int fieldCount = this.tblManager.getDynFields().getFieldDefCount();
                int offset = 0;
                if (this.hasViewProdPermission && ((offset = evt.getRowIndex() % fieldCount) == this.getSalesOffset() || offset == this.getProdOffset())) {
                    this.calcInventory(this.tblMain.getRow(evt.getRowIndex() + (fieldCount - offset - 1)), this.bopColIndex + 1);
                }
                if (offset == this.getInvOffset()) {
                    return;
                }
                BigDecimal oldValue = (BigDecimal)evt.getOldValue();
                BigDecimal newValue = (BigDecimal)evt.getNewValue();
                this.bufferChanges(evt.getRowIndex(), evt.getColIndex(), oldValue, newValue);
                FieldDefinition field = this.tblManager.getDynFields().getFieldDef(offset);
                if (field.isSum()) {
                    ICell sumCell = this.tblManager.getSumCell(evt.getRowIndex());
                    BigDecimal sum = (BigDecimal)sumCell.getValue();
                    if (newValue != null) {
                        sum = sum.add(newValue);
                    }
                    if (oldValue != null) {
                        sum = sum.subtract(oldValue);
                    }
                    sumCell.setValue((Object)sum);
                }
            }
        }
    }

    protected boolean isCanCopyPaste() {
        return false;
    }

    private void reCalcInventory() {
        int dynFieldCount = this.tblManager.getDynFields().getDisplayFieldCount();
        for (int i = dynFieldCount - 1; i < this.tblMain.getRowCount(); i += dynFieldCount) {
            IRow invRow = this.tblMain.getRow(i);
            this.calcInventory(invRow, this.bopColIndex + 1);
        }
    }

    private int getSalesOffset() {
        return 0;
    }

    private int getProdTheoryOffset() {
        return 1;
    }

    private int getProdOffset() {
        return 2;
    }

    private int getTargetInvOffset() {
        return 3;
    }

    private int getInvOffset() {
        return 4;
    }

    private int getDynamicFieldCount() {
        return 5;
    }

    private boolean isInvRow(int rowIndex) {
        return rowIndex % this.getDynamicFieldCount() == this.getInvOffset();
    }

    private boolean isSalesRow(int rowIndex) {
        return rowIndex % this.getDynamicFieldCount() == this.getSalesOffset();
    }

    private void calcInventory(IRow invRow, int startColIndex) {
        if (!this.hasViewProdPermission) {
            return;
        }
        BigDecimal bop = (BigDecimal)invRow.getCell(this.bopColIndex).getValue();
        if (bop == null) {
            bop = this.ZERO;
        }
        int offsetFromInv2Sales = this.getInvOffset() - this.getSalesOffset();
        int offsetFromInv2Prod = this.getInvOffset() - this.getProdOffset();
        for (int i = startColIndex; i < this.tblMain.getColumnCount(); ++i) {
            BigDecimal sales = (BigDecimal)this.tblMain.getCell(invRow.getRowIndex() - offsetFromInv2Sales, i).getValue();
            BigDecimal prod = (BigDecimal)this.tblMain.getCell(invRow.getRowIndex() - offsetFromInv2Prod, i).getValue();
            BigDecimal prevInv = null;
            prevInv = i == startColIndex ? bop : (BigDecimal)this.tblMain.getCell(invRow.getRowIndex(), i - 1).getValue();
            if (sales == null) {
                sales = this.ZERO;
            }
            if (prod == null) {
                prod = this.ZERO;
            }
            if (prevInv == null) {
                prevInv = this.ZERO;
            }
            BigDecimal inv = prevInv.add(prod).subtract(sales);
            invRow.getCell(i).setValue((Object)inv);
        }
    }

    private void calcInventory(IRow invRow) {
        this.calcInventory(invRow, this.bopColIndex);
    }

    private void calcInventory(int rowIndex) {
        this.calcInventory(this.tblMain.getRow(rowIndex), this.bopColIndex);
    }

    @Override
    public void actionTransferPlan_actionPerformed(ActionEvent e) throws Exception {
        if (!this.saveDataFirst()) {
            return;
        }
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        String uiClassName = "com.kingdee.eas.mm.planning.client.SopPlanTransferUI";
        UIContext map = new UIContext((Object)this);
        SOPPeriod startPeriod = this.curPeriod;
        if (this.curPeriod.toNumber() < this.periodFrom.toNumber()) {
            startPeriod = this.periodFrom;
        }
        map.put("org", this.storageOrgUnitId);
        map.put("sopeditmode", this.editMode);
        map.put("periodFrom", startPeriod);
        map.put("isEditing", this.isEditing);
        Set selectedMats = this.getSelectedMaterials(false);
        Map storageMatId = this.getStorageMatIds(selectedMats);
        String matId = null;
        String materialId = null;
        if (selectedMats.size() == 1) {
            matId = (String)selectedMats.toArray()[0];
            String material = storageMatId.get(matId + "material").toString();
            String storage = storageMatId.get(matId + "storage").toString();
            MaterialPlanInfo materialPlanInfo = this.getMaterialPlanInfo(material, storage);
            Set set = this.getStratergy();
            if (materialPlanInfo.getManufactureStrategy() != null && materialPlanInfo != null && set.contains(materialPlanInfo.getManufactureStrategy().getId().toString())) {
                materialId = material;
            }
        }
        map.put("matFrom", materialId);
        if (this.isThereSalesPlanSelected()) {
            map.put("PlanType", SOPPlannedTypeEnum.SALEPLAN);
        } else {
            map.put("PlanType", SOPPlannedTypeEnum.PRODUCT_PLAN);
        }
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClassName, (Map)map, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.saveDataFirst()) {
            if (!this.isFirstOnload() && this.isEditing) {
                this.releaseMutexMat();
            }
            super.actionQuery_actionPerformed(e);
        }
    }

    protected void checkPrintPermission(String printPermission) throws Exception {
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        int i = this.planType.getValue();
        if (i < 2) {
            this.checkPrintPermission(this.getPermission(i));
        } else {
            this.checkPrintPermission(this.getPermission(1));
            this.checkPrintPermission(this.getPermission(2));
        }
        super.actionPrint_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        int i = this.planType.getValue();
        if (i < 2) {
            this.checkPrintPermission(this.getPermission(i));
        } else {
            this.checkPrintPermission(this.getPermission(1));
            this.checkPrintPermission(this.getPermission(2));
        }
        super.actionPrintPreview_actionPerformed(e);
    }

    private String getPermission(int i) {
        switch (i) {
            case 1: {
                return "mm_sopsaleplan_print";
            }
            case 2: {
                return "mm_sopprodplan_print";
            }
        }
        return "";
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.kDLabelContainer1.getBoundLabelText() + ":").append("&[PlanVersion]").append("&|").append(this.kDLabelContainer2.getBoundLabelText() + ":").append("&[PlanVersionDesc]").append("&|").append(this.kDLabelContainer4.getBoundLabelText() + ":").append("&[PlanType]");
        header.addRow(sb.toString(), sa);
        sb.setLength(0);
        sb.append(this.kDLabelContainer3.getBoundLabelText() + ":").append("&[StorageOrgUnit]").append("&|").append(this.cbActivated.getText() + ":").append("&[Activation]").append("&|").append(this.kDLabelContainer5.getBoundLabelText() + ":").append("&[Period]");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("PlanVersion", this.txtPlanVersionNumber.getText());
        map.put("PlanVersionDesc", this.txtPlanVersionDesc.getText());
        map.put("StorageOrgUnit", this.txtStorage.getText());
        map.put("PlanType", ((SOPPlannedTypeEnum)((Object)this.txtPlanType.getSelectedItem())).getAlias());
        map.put("Activation", this.cbActivated.isSelected() ? "Y" : "N");
        map.put("Period", this.txtBeginPeriod.getText());
        return map;
    }

    private Map getSelectedBops(boolean allIfNoSelection) {
        HashMap<String, BigDecimal> matIdToBop = new HashMap<String, BigDecimal>();
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 && allIfNoSelection) {
            size = 1;
        }
        int beginIndex = 0;
        int endIndex = this.tblMain.getRowCount3() - 1;
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
            if (sb != null) {
                if (sb.getMode() == 4) {
                    beginIndex = 0;
                    endIndex = this.tblMain.getRowCount() - 1;
                } else {
                    beginIndex = sb.getTop();
                    endIndex = sb.getBottom();
                }
            }
            for (int j = beginIndex; j <= endIndex; ++j) {
                String matId = (String)this.tblMain.getCell(j, 0).getValue();
                IRow row = this.tblManager.getRowFromHeadObjKey(matId);
                IRow invRow = this.tblMain.getRow(row.getRowIndex() + this.getInvOffset());
                BigDecimal bop = (BigDecimal)invRow.getCell(this.bopColIndex).getValue();
                matIdToBop.put(matId, bop);
            }
        }
        return matIdToBop;
    }

    private BigDecimal getbopInv(int count, IRow saleRow, IRow prodRow, IRow prodTheoryRow, IRow invRow) {
        BigDecimal bopInv = null;
        BigDecimal prodNum = new BigDecimal("0.00");
        bopInv = invRow.getCell(8).getValue() != null ? (BigDecimal)invRow.getCell(this.bopColIndex).getValue() : this.ZERO;
        prodNum = bopInv;
        int i = 0;
        int j = 12;
        while (i < count) {
            BigDecimal prod = (BigDecimal)prodTheoryRow.getCell(j).getValue();
            prod = prod == null ? this.ZERO : prod;
            BigDecimal saleNum = (BigDecimal)saleRow.getCell(j).getValue();
            saleNum = saleNum == null ? this.ZERO : saleNum;
            prodNum = prodNum.add(prod).subtract(saleNum);
            ++i;
            ++j;
        }
        return prodNum;
    }

    @Override
    public void actionConstraintCheck_actionPerformed(ActionEvent e) throws Exception {
        if (!this.saveDataFirst()) {
            return;
        }
        Map inMap = new HashMap();
        HashSet<String> matNumberSet = new HashSet<String>();
        IStorageOrgUnit storage = StorageOrgUnitFactory.getRemoteInstance();
        StorageOrgUnitInfo storageInfo = storage.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.storageOrgUnitId));
        SOPPeriod[] periods = new SOPPeriod[this.periodRange.length];
        for (int i = 0; i < this.periodRange.length; ++i) {
            periods[i] = this.periodRange[i];
        }
        SOPPlanVersionInfo version = new SOPPlanVersionInfo();
        version.setId(BOSUuid.read((String)this.planVersionId));
        Set materialList = this.getSelectedMaterials(true);
        Map storageMatIds = this.getStorageMatIds(materialList);
        HashSet<String> materialLst = new HashSet<String>();
        for (String matStorageIds : materialList) {
            materialLst.add((String)storageMatIds.get(matStorageIds + "material"));
        }
        if (materialLst == null || materialLst.size() == 0) {
            throw new SOPException(SOPException.NO_SELECTED_MATERIAL);
        }
        IMaterial imaterial = MaterialFactory.getRemoteInstance();
        EntityViewInfo viewMaterial = new EntityViewInfo();
        FilterInfo filterMaterial = new FilterInfo();
        filterMaterial.getFilterItems().add(new FilterItemInfo("id", materialLst, CompareType.INCLUDE));
        viewMaterial.setFilter(filterMaterial);
        MaterialCollection collection = imaterial.getMaterialCollection(viewMaterial);
        int startColumn = this.getColumnIndex4Period(this.curPeriod);
        int count = this.periodRange.length;
        for (int i = 0; i < collection.size(); ++i) {
            MaterialInfo material = collection.get(i);
            matNumberSet.add(material.getNumber());
        }
        if (matNumberSet.size() > 0) {
            inMap = SOPFacadeFactory.getRemoteInstance().getSopData(storageInfo, periods, matNumberSet, version);
        }
        ISOPCheckFormula isopCheckFormula = SOPCheckFormulaFactory.getRemoteInstance();
        List list = isopCheckFormula.checkSopData(storageInfo, periods, inMap, version);
        UIContext ctx = new UIContext();
        ctx.put((Object)"list", (Object)list);
        String uiClass = "com.kingdee.eas.mm.planning.client.SOPCheckFormulaUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)ctx, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionDefineConstraints_actionPerformed(ActionEvent e) throws Exception {
        UIContext context = new UIContext((Object)this);
        context.put((Object)"Owner", (Object)this);
        IUIWindow curDialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SOPCheckFormulaListUI.class.getName(), (Map)context, null, OprtState.VIEW);
        curDialog.show();
    }

    @Override
    public void actionTransferPlanLog_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        String uiClassName = "com.kingdee.eas.mm.planning.client.SopPlanTranferLogUI";
        UIContext map = new UIContext((Object)this);
        map.put("org", this.storageOrgUnitId);
        map.put("sopeditmode", this.editMode);
        Set selectedMats = this.getSelectedMaterials(false);
        Map storageMatIds = this.getStorageMatIds(selectedMats);
        String matId = null;
        if (selectedMats.size() == 1) {
            String ids = (String)selectedMats.toArray()[0];
            matId = (String)storageMatIds.get(ids + "material");
        }
        map.put("matFrom", matId);
        if (this.planType.equals((Object)SOPPlannedTypeEnum.SALEPLAN)) {
            map.put("PlanType", SOPPlannedTypeEnum.SALEPLAN);
        } else if (this.planType.equals((Object)SOPPlannedTypeEnum.PRODUCT_PLAN)) {
            map.put("PlanType", SOPPlannedTypeEnum.PRODUCT_PLAN);
        } else {
            map.put("PlanType", SOPPlannedTypeEnum.SALE_PRODUCT_PLAN);
        }
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClassName, (Map)map, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionCurInventory_actionPerformed(ActionEvent e) throws Exception {
        Set materialList = this.getSelectedMaterials(true);
        Map storageMatIds = this.getStorageMatIds(materialList);
        if (materialList == null || materialList.size() == 0) {
            throw new SOPException(SOPException.NO_SELECTED_MATERIAL);
        }
        Object[] material = materialList.toArray();
        ArrayList paramList = new ArrayList();
        String materialId = (String)storageMatIds.get((String)material[0] + "material");
        String storageId = (String)storageMatIds.get((String)material[0] + "storage");
        String userInfoID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        try {
            PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(userInfoID), (IObjectPK)new ObjectUuidPK(storageId), "inventory");
        }
        catch (EASBizException e1) {
            this.handleException((Exception)((Object)e1));
            return;
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
            return;
        }
        MaterialInfo materialInfo = this.buildMatrialInfo(materialId);
        ISOPFacade sop = SOPFacadeFactory.getRemoteInstance();
        List valueList = sop.getSopParamValue();
        for (int i = 0; i < valueList.size(); ++i) {
            paramList.add(this.storeStateMap.get(valueList.get(i)));
        }
        ArrayList<String> storeTypeList = new ArrayList<String>();
        storeTypeList.add("181875d5-0105-1000-e000-0111c0a812fd97D461A6");
        storeTypeList.add("181875d5-0105-1000-e000-0114c0a812fd97D461A6");
        storeTypeList.add("181875d5-0105-1000-e000-0120c0a812fd97D461A6");
        if (materialInfo != null) {
            HashMap<String, Serializable> hm = new HashMap<String, Serializable>();
            hm.put("TABLEHASFOCUS", Boolean.valueOf(true));
            hm.put("MATERIAL", (Serializable)materialInfo);
            hm.put("STORAGEORGUNIT", (Serializable)this.getStorageOrgUnitInfo(storageId));
            hm.put("STORESTATE", paramList);
            hm.put("STORETYPE", storeTypeList);
            this.queryResultByMaterial(hm);
        }
    }

    private MaterialInfo buildMatrialInfo(String materialId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("model");
        sic.add("baseUnit.name");
        viewInfo.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)materialId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        MaterialCollection mc = MaterialFactory.getRemoteInstance().getMaterialCollection(viewInfo);
        MaterialInfo materialInfo = mc.get(0);
        return materialInfo;
    }

    private void queryResultByMaterial(HashMap hm) throws UIException, BOSException, Exception, SQLException {
        UIContext uiContext = new UIContext((Object)this);
        if (this.materialWindow == null) {
            this.materialWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.common.client.MaterialQueryListUI", (Map)uiContext, null, OprtState.EDIT);
        }
        MaterialQueryListUI aMaterialQueryListUI = (MaterialQueryListUI)this.materialWindow.getUIObject();
        aMaterialQueryListUI.setHmQueryCon(hm);
        aMaterialQueryListUI.executQuery();
        this.materialWindow.show();
    }

    private StorageOrgUnitInfo getStorageOrgUnitInfo(String storageId) throws BOSException {
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)storageId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        StorageOrgUnitCollection sc = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(viewInfo);
        if (sc.size() > 0) {
            storageOrgUnitInfo = sc.get(0);
        }
        return storageOrgUnitInfo;
    }

    public void initRateAndPrecision(SOPPeriod periodFrom, SOPPeriod periodTo, ArrayList storageOrgIds, ArrayList materialIds) throws BOSException, SQLException {
        if (storageOrgIds == null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org", this.storageOrgUnitId);
            map.put("planVersion", this.planVersionId);
            map.put("isEditing", this.isEditing);
            map.put("materials", materialIds);
            map.put("executStorageOrg", storageOrgIds);
            if (this.materialNumberFrom != null) {
                map.put("matFrom", this.materialNumberFrom);
            }
            if (this.materialNumberTo != null) {
                map.put("matTo", this.materialNumberTo);
            }
            ISOPFacade sop = SOPFacadeFactory.getRemoteInstance();
            IRowSet set = sop.getRatePrecision(map);
            while (set.next()) {
                String id = set.getString("billId");
                String rate = set.getString("rate");
                String precision = set.getString("qtyPrecision");
                this.rateMap.put(id, new BigDecimal(rate));
                this.precisionMap.put(id, new Integer(precision));
            }
        }
    }

    private Map getStorageMatIds(Set keySet) {
        HashMap<String, String> storageMatIds = new HashMap<String, String>();
        Iterator it = keySet.iterator();
        int size = this.getDynamicFieldCount();
        block0: while (it.hasNext()) {
            String matStorageIds = (String)it.next();
            for (int i = 0; i < this.tblMain.getRowCount(); i += size) {
                String ids = (String)this.tblMain.getCell(i, 0).getValue();
                if (!matStorageIds.equals(ids)) continue;
                storageMatIds.put(ids + "storage", (String)this.tblMain.getCell(i, 1).getValue());
                storageMatIds.put(ids + "material", (String)this.tblMain.getCell(i, 2).getValue());
                continue block0;
            }
        }
        return storageMatIds;
    }

    public MaterialPlanInfo getMaterialPlanInfo(String materialId, String orgId) {
        try {
            MaterialPlanInfo mpInfo = null;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgId, CompareType.EQUALS));
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("manufactureStrategy"));
            view.setFilter(filter);
            MaterialPlanCollection collection = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(view);
            if (collection.size() > 0) {
                mpInfo = collection.get(0);
            }
            return mpInfo;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Set getStratergy() {
        HashSet<String> stratergy = new HashSet<String>();
        stratergy.add("qAYbemEdG9ngQKjAYj0V1dg0uEU=");
        stratergy.add("qAYfaBzTrmLgQKjAYj0f3dg0uEU=");
        stratergy.add("qAYfaBzUrmLgQKjAYj0f3dg0uEU=");
        stratergy.add("qAYfaBzVrmLgQKjAYj0f3dg0uEU=");
        stratergy.add("NUnM+gEcEADgAA3cwKgL09g0uEU=");
        stratergy.add("NUnM+gEcEADgAA3ewKgL09g0uEU=");
        stratergy.add("NUnM+gEcEADgAA3gwKgL09g0uEU=");
        return stratergy;
    }

    class MaterialBop {
        BigDecimal weekBop;
        BigDecimal monthBop;

        MaterialBop() {
        }
    }
}

